/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;

import stec.lang.DString;

import stec.iws.Utils;
import stec.iws.Request;
import stec.iws.Response;

public class HelloServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		PrintWriter writer = _response.getWriter();

		String name;

		String args = Utils.decodeURL(Utils.getArgs(_request), _response.getCharacterEncoding());
		if(args == null)
		{
			name = "";
		}
		else
		{
			name = DString.extract(args, " ", 1);
			if(name == null)
			{
				name = "";
			}
		}

		writer.println("<html>");
		writer.println("<head><title>Hello " + name + "</title></head>");
		writer.println("<body>");
		writer.println("<h1>Hello " + name + "</h1>");
		writer.println("</body>");
		writer.println("</html>");
	}
}
