/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import java.io.IOException;
import java.io.File;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import stec.iws.MultiPartForm;
import stec.iws.FileUpload;
import stec.iws.iws;
import stec.iws.Utils;
import stec.iws.Request;
import stec.iws.Response;

public class FileUploadServlet extends BaseServlet
{
	private static final int KB = 1024;
	private static final int DEFAULT_MAX_CONTENT_LENGTH = 1024 * KB;

	private static int max_content_length;

	public void init(ServletConfig _config) throws ServletException
	{
		super.init(_config);

		String sValue = _config.getInitParameter("max_content_length");
		if(sValue == null)
		{
			max_content_length = DEFAULT_MAX_CONTENT_LENGTH;
		}
		else
		{
			try
			{
				max_content_length = Integer.parseInt(sValue);
			}
			catch(NumberFormatException ex)
			{
				max_content_length = DEFAULT_MAX_CONTENT_LENGTH; // [mjg] ignore
			}
		}
	}

	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		try
		{
			PrintWriter writer = _response.getWriter();

			String basedir = iws.getWorkDirectory("./samples/upload");
			File fh = new File(basedir);

			String charset = _request.getCharset();
			if(charset == null)
			{
				charset = iws.getDefaultCharset();
			}

			Hashtable ht = MultiPartForm.parse(_request, fh.getCanonicalPath(), max_content_length, charset);

			String key;
			Vector v;
			Object obj;
			String sValue;
			byte[] bValue;
			FileUpload fileUpload;

			writer.println("<html>");
			writer.println("<head><title>File Upload Servlet</title></head>");
			writer.println("<body>");
			writer.println("<h1>File Upload Servlet</h1>");

			writer.println("<table border=1>");

			writer.println("<tr>");
			writer.println("<th>");
			writer.println("Key");
			writer.println("</th>");
			writer.println("<th>");
			writer.println("Data");
			writer.println("</th>");
			writer.println("</tr>");

			Enumeration e = ht.keys();
			while(e.hasMoreElements())
			{
				writer.println("<tr>");

				key = (String)e.nextElement();

				writer.println("<td>");
				writer.println(key);
				writer.println("</td>");

				writer.println("<td>");

				v = (Vector)ht.get(key);
				for(int i = 0; i < v.size(); i++)
				{
					obj = v.elementAt(i);
					if(obj instanceof FileUpload)
					{
						fileUpload = (FileUpload)obj;
						sValue = fileUpload.getRemoteFilePath();
						writer.println("remote file path: [" + (((sValue = fileUpload.getRemoteFilePath()) == null) ? "" : sValue) + "]<br>");
						writer.println("local file path: [" + (((sValue = fileUpload.getLocalFilePath()) == null) ? "" : sValue) + "]<br>");
						writer.println("content type: [" + (((sValue = fileUpload.getContentType()) == null) ? "" : sValue) + "]<br>");
					}
					else
					{
						writer.println((String)obj + "<br>");
					}
				}

				writer.println("</td>");

				writer.println("</tr>");
			}

			writer.println("</table>");

			writer.println("</body>");
			writer.println("</html>");
		}
		catch(Exception ex)
		{
			throw new ServletException(ex.getMessage());
		}
	}
}