/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.Logger;
import stec.iws.Utils;
import stec.iws.iws;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DatabaseLogger
extends Logger {
    private static String f = "";
    private Connection h = null;
    private PreparedStatement e = null;
    private PreparedStatement g = null;
    private PreparedStatement i = null;

    public final void init(Hashtable hashtable) throws Exception {
        super.init(hashtable);
        Object v = hashtable.get("driver");
        if (v == null) {
            throw new Exception(iws.Z.getLocalString("err.was_not_specified", "driver"));
        }
        String string = ((String[])v)[0];
        Class.forName(string);
        v = hashtable.get("url");
        if (v == null) {
            throw new Exception(iws.Z.getLocalString("err.was_not_specified", "url"));
        }
        String string2 = ((String[])v)[0];
        v = hashtable.get("user");
        String string3 = v == null ? "" : ((String[])v)[0];
        v = hashtable.get("password");
        String string4 = v == null ? "" : ((String[])v)[0];
        try {
            this.h = DriverManager.getConnection(string2, string3, string4);
            this.h.setAutoCommit(true);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO AccessLog (");
            stringBuffer.append("Date_Time");
            stringBuffer.append(", Remote_Address");
            stringBuffer.append(", Remote_Host");
            stringBuffer.append(", Remote_User");
            stringBuffer.append(", Host");
            stringBuffer.append(", Port");
            stringBuffer.append(", Local_Address");
            stringBuffer.append(", Content_Length");
            stringBuffer.append(", Request_Length");
            stringBuffer.append(", Response_Time");
            stringBuffer.append(", Status_Code");
            stringBuffer.append(", Error_Code");
            stringBuffer.append(", Request_Method");
            stringBuffer.append(", Request_URI");
            stringBuffer.append(", User_Agent");
            stringBuffer.append(", Referer");
            stringBuffer.append(", Protocol");
            stringBuffer.append(", Server_Service");
            stringBuffer.append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            this.i = this.h.prepareStatement(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("INSERT INTO EventLog (");
            stringBuffer.append("Date_Time");
            stringBuffer.append(", Message");
            stringBuffer.append(") VALUES (?,?)");
            this.g = this.h.prepareStatement(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("INSERT INTO ErrorLog (");
            stringBuffer.append("Date_Time");
            stringBuffer.append(", Exception");
            stringBuffer.append(", Message");
            stringBuffer.append(") VALUES (?,?,?)");
            this.e = this.h.prepareStatement(stringBuffer.toString());
        }
        catch (Exception exception) {
            this.if();
            throw exception;
        }
    }

    public final void output(ErrorLogEntry errorLogEntry) throws IOException, SQLException {
        Closeable closeable;
        Closeable closeable2;
        String string;
        System.err.print(errorLogEntry.message);
        Utils.a((PrintStream)System.err, (Throwable)errorLogEntry.error);
        this.e.setTimestamp(1, new Timestamp(errorLogEntry.timestamp));
        if (errorLogEntry.error == null) {
            string = f;
        } else {
            closeable2 = new CharArrayWriter();
            closeable = new PrintWriter((Writer)closeable2);
            Utils.a((PrintWriter)closeable, (Throwable)errorLogEntry.error);
            string = String.valueOf(closeable2);
        }
        closeable2 = new ByteArrayOutputStream();
        closeable = new ObjectOutputStream((OutputStream)closeable2);
        ((ObjectOutputStream)closeable).writeObject(string);
        byte[] byArray = ((ByteArrayOutputStream)closeable2).toByteArray();
        this.e.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        String string2 = errorLogEntry.message == null ? f : errorLogEntry.message;
        closeable2 = new ByteArrayOutputStream();
        closeable = new ObjectOutputStream((OutputStream)closeable2);
        ((ObjectOutputStream)closeable).writeObject(string2);
        byArray = ((ByteArrayOutputStream)closeable2).toByteArray();
        this.e.setBinaryStream(3, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        this.e.executeUpdate();
    }

    public final void output(EventLogEntry eventLogEntry) throws IOException, SQLException {
        this.g.setTimestamp(1, new Timestamp(eventLogEntry.timestamp));
        String string = eventLogEntry.message == null ? f : eventLogEntry.message;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(string);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.g.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        this.g.executeUpdate();
    }

    public final void output(AccessLogEntry accessLogEntry) throws SQLException {
        this.i.setTimestamp(1, new Timestamp(accessLogEntry.timestamp));
        this.i.setString(2, accessLogEntry.remoteAddress == null ? f : accessLogEntry.remoteAddress);
        this.i.setString(3, accessLogEntry.remoteHost == null ? f : accessLogEntry.remoteHost);
        this.i.setString(4, accessLogEntry.remoteUser == null ? f : accessLogEntry.remoteUser);
        this.i.setString(5, accessLogEntry.host == null ? f : accessLogEntry.host);
        this.i.setInt(6, accessLogEntry.port == -1 ? 80 : accessLogEntry.port);
        this.i.setString(7, accessLogEntry.localAddress == null ? f : accessLogEntry.localAddress);
        this.i.setInt(8, accessLogEntry.contentLength == (long)-1 ? 0 : (int)accessLogEntry.contentLength);
        this.i.setInt(9, (int)accessLogEntry.requestLength);
        this.i.setInt(10, (int)accessLogEntry.responseTime);
        this.i.setInt(11, accessLogEntry.statusCode);
        this.i.setInt(12, accessLogEntry.errorCode);
        this.i.setString(13, accessLogEntry.requestMethod == null ? f : accessLogEntry.requestMethod);
        this.i.setString(14, accessLogEntry.requestURI == null ? f : accessLogEntry.requestURI);
        this.i.setString(15, accessLogEntry.userAgent == null ? f : accessLogEntry.userAgent);
        this.i.setString(16, accessLogEntry.referer == null ? f : accessLogEntry.referer);
        this.i.setString(17, accessLogEntry.protocol == null ? f : accessLogEntry.protocol);
        this.i.setString(18, accessLogEntry.serverService == null ? f : accessLogEntry.serverService);
        this.i.executeUpdate();
    }

    public final synchronized void destroy() {
        try {
            super.destroy();
            Object var2_1 = null;
            this.if();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.if();
            throw throwable;
        }
    }

    private final void if() {
        if (this.g != null) {
            try {
                this.g.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.g = null;
        }
        if (this.e != null) {
            try {
                this.e.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.e = null;
        }
        if (this.i != null) {
            try {
                this.i.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.i = null;
        }
        if (this.h != null) {
            try {
                this.h.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.h = null;
        }
    }
}

