/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.depend;

import org.apache.tomcat.util.depend.Dependency;

public class DependManager {
    int delay = 4000;
    Dependency[] deps;
    int depsCount = 0;
    long lastCheck = 0L;
    boolean checking = false;
    long checkTime = 0L;
    int checkCount = 0;
    private boolean expired = false;
    static final int INITIAL_DEP_SIZE = 32;
    private static boolean noWarnBadVM;
    private int debug = 0;

    public DependManager() {
        this(32);
    }

    public DependManager(int initial_size) {
        this.deps = new Dependency[initial_size];
    }

    public void reset() {
        this.expired = false;
        for (int i = 0; i < this.depsCount; ++i) {
            Dependency d = this.deps[i];
            d.reset();
        }
    }

    public void setDelay(int d) {
        this.delay = d;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public long getCheckCount() {
        return this.checkCount;
    }

    public boolean shouldReload() {
        boolean b = this.shouldReload1();
        if (b != this.expired && noWarnBadVM) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("BUG ( VM or Tomcat? ) shouldReload returns expired=").append(b).append(" and the real value is ").append(this.expired))));
            noWarnBadVM = false;
        }
        return this.expired;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldReload1() {
        if (this.debug > 0 && this.expired) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("ShouldReload1 E=").append(this.expired).append(" C=").append(this.checking))));
        }
        if (this.checking) {
            return this.expired;
        }
        DependManager dependManager = this;
        synchronized (dependManager) {
            block14: {
                boolean bl;
                block13: {
                    try {
                        if (this.debug > 0 && this.expired) {
                            this.log(String.valueOf(String.valueOf(new StringBuffer("ShouldReload2 E=").append(this.expired).append(" C=").append(this.checking))));
                        }
                        if (this.checking) {
                            boolean bl2 = this.expired;
                            Object var7_4 = null;
                            this.checking = false;
                            return bl2;
                        }
                        long startCheck = System.currentTimeMillis();
                        if (startCheck - this.lastCheck < (long)this.delay) {
                            if (this.debug > 0 && this.expired) {
                                this.log(String.valueOf(String.valueOf(new StringBuffer("ShouldReload3 E=").append(this.expired).append(" C=").append(this.checking))));
                            }
                            bl = this.expired;
                            break block13;
                        }
                        this.checking = true;
                        for (int i = 0; i < this.depsCount; ++i) {
                            Dependency d = this.deps[i];
                            if (!d.checkExpiry()) continue;
                            if (this.debug > 0) {
                                this.log("Found expired file ".concat(String.valueOf(String.valueOf(d.getOrigin().getName()))));
                            }
                            if (d.isLocal()) continue;
                            this.expired = true;
                        }
                        this.checkTime += this.lastCheck - startCheck;
                        ++this.checkCount;
                        this.lastCheck = startCheck;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.checking = false;
                        throw throwable;
                    }
                }
                Object var7_5 = null;
                this.checking = false;
                return bl;
            }
            Object var7_6 = null;
            this.checking = false;
            if (this.debug <= 0) return this.expired;
            if (!this.expired) return this.expired;
            this.log(String.valueOf(String.valueOf(new StringBuffer("ShouldReload5 E=").append(this.expired).append(" C=").append(this.checking))));
            return this.expired;
        }
    }

    public void setLastModified(long time) {
        for (int i = 0; i < this.depsCount; ++i) {
            this.deps[i].setLastModified(time);
        }
    }

    public void setExpired(boolean e) {
        if (this.debug > 0) {
            this.log("SetExpired ".concat(String.valueOf(String.valueOf(e))));
        }
        for (int i = 0; i < this.depsCount; ++i) {
            this.deps[i].setExpired(e);
        }
    }

    public synchronized void addDependency(Dependency dep) {
        if (this.depsCount >= this.deps.length) {
            Dependency[] deps1 = new Dependency[this.deps.length * 2];
            System.arraycopy(this.deps, 0, deps1, 0, this.depsCount);
            this.deps = deps1;
        }
        this.deps[this.depsCount++] = dep;
        if (this.debug > 2) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("Added ").append(dep.getOrigin()).append(" ").append(dep.getTarget()))));
        }
    }

    public void setDebug(int i) {
        this.debug = i;
    }

    void log(String s) {
        System.out.println("DependManager: ".concat(String.valueOf(String.valueOf(s))));
    }

    static {
        INITIAL_DEP_SIZE = 32;
        noWarnBadVM = true;
    }
}

