/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.depend;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.depend.DependManager;
import org.apache.tomcat.util.depend.Dependency;

public class DependClassLoader
extends ClassLoader {
    protected ClassLoader parent;
    protected ClassLoader parent2;
    private static int debug = 0;
    DependManager dependM;
    protected Object pd;
    static Jdk11Compat jdkCompat = Jdk11Compat.getJdkCompat();

    public static DependClassLoader getDependClassLoader(DependManager depM, ClassLoader parent, Object pd, int debug) {
        if (Jdk11Compat.isJava2()) {
            try {
                Class<?> c = Class.forName("org.apache.tomcat.util.depend.DependClassLoader12");
                DependClassLoader dcl = (DependClassLoader)c.newInstance();
                dcl.init(depM, parent, pd);
                DependClassLoader.debug = debug;
                DependClassLoader dependClassLoader = dcl;
                return dependClassLoader;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return new DependClassLoader(depM, parent, pd);
    }

    DependClassLoader() {
    }

    public DependClassLoader(DependManager depM, ClassLoader parent, Object pd) {
        this.init(depM, parent, pd);
    }

    void init(DependManager depM, ClassLoader parent, Object pd) {
        this.parent = parent;
        this.parent2 = jdkCompat.getParentLoader(parent);
        this.dependM = depM;
        this.pd = pd;
    }

    final void log(String s) {
        System.out.println("DependClassLoader: ".concat(String.valueOf(String.valueOf(s))));
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClassInternal1(name, resolve);
    }

    protected Class loadClassInternal1(String name, boolean resolve) throws ClassNotFoundException {
        if (debug > 9) {
            this.log(String.valueOf(String.valueOf(new StringBuffer("loadClass() ").append(name).append(" ").append(resolve))));
        }
        Class c = null;
        c = this.findLoadedClass(name);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        String classFileName = String.valueOf(String.valueOf(name.replace('.', '/'))).concat(".class");
        URL res = this.getResource(classFileName);
        try {
            c = this.parent2.loadClass(name);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                Class clazz = c;
                return clazz;
            }
        }
        catch (Exception e) {
            c = null;
        }
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream is = this.getResourceAsStream(classFileName);
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] data = null;
        try {
            data = this.readFully(is);
            if (data.length == 0) {
                data = null;
            }
            is.close();
        }
        catch (IOException ex) {
            if (debug > 0) {
                ex.printStackTrace();
            }
            data = null;
            throw new ClassNotFoundException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(name))).append(" error reading ").append(ex.toString()))));
        }
        if (data == null) {
            throw new ClassNotFoundException(String.valueOf(String.valueOf(name)).concat(" lenght==0"));
        }
        c = this.defineClassCompat(name, data, 0, data.length, res);
        this.dependency(c, res);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class defineClassCompat(String name, byte[] data, int s, int end, URL res) throws ClassNotFoundException {
        return this.defineClass(data, s, end);
    }

    public URL getResource(String name) {
        return this.parent.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.parent.getResourceAsStream(name);
    }

    private void dependency(Class c, URL res) {
        if (res == null) {
            return;
        }
        File f = null;
        if ("file".equals(res.getProtocol())) {
            f = new File(res.getFile());
            if (debug > 9) {
                this.log("File dep ".concat(String.valueOf(String.valueOf(f))));
            }
            if (!f.exists()) {
                f = null;
            }
        }
        if ("jar".equals(res.getProtocol())) {
            String fileN = res.getFile();
            int idx = fileN.indexOf("!");
            if (idx >= 0) {
                fileN = fileN.substring(0, idx);
            }
            if (fileN.startsWith("file:")) {
                fileN = fileN.substring(5);
            }
            if (fileN.startsWith("/file:")) {
                fileN = fileN.substring(6);
            }
            f = new File(fileN);
            if (debug > 9) {
                this.log(String.valueOf(String.valueOf(new StringBuffer("Jar dep ").append(f).append(" ").append(f.exists()))));
            }
            if (!f.exists()) {
                f = null;
            }
        }
        if (f == null) {
            return;
        }
        Dependency dep = new Dependency();
        dep.setLastModified(f.lastModified());
        dep.setTarget(c);
        dep.setOrigin(f);
        this.dependM.addDependency(dep);
    }

    public ClassLoader getParentLoader() {
        return this.parent;
    }

    private byte[] readFully(InputStream is) throws IOException {
        byte[] b = new byte[1024];
        int count = 0;
        int available = 1024;
        while (true) {
            int nRead;
            if ((nRead = is.read(b, count, available)) == -1) {
                byte[] result = new byte[count];
                System.arraycopy(b, 0, result, 0, count);
                return result;
            }
            count += nRead;
            if ((available -= nRead) != 0) continue;
            byte[] b1 = new byte[b.length * 2];
            available = b.length;
            System.arraycopy(b, 0, b1, 0, b.length);
            b = b1;
        }
    }
}

