/* RESOLV.H - This file is part of
Resolver for Windows, copyright (C) Fabrizio Gennari, 2000-2003

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#pragma pack(1)

struct query {
		char id[2];
		unsigned char control[2];
		unsigned short int qdcount;
		unsigned short int ancount;
		unsigned short int nscount;
		unsigned short int arcount;
};

struct answer {
		unsigned short type;
		unsigned short class;
		unsigned int   ttl;
		unsigned short rdlength;
};

typedef enum __ns_sect {
        ns_s_qd = 0,                /* Query: Question. */
        ns_s_zn = 0,                /* Update: Zone. */
        ns_s_an = 1,                /* Query: Answer. */
        ns_s_pr = 1,                /* Update: Prerequisites. */
        ns_s_ns = 2,                /* Query: Name servers. */
        ns_s_ud = 2,                /* Update: Update. */
        ns_s_ar = 3,                /* Query|Update: Additional records. */
        ns_s_max = 4
} ns_sect;

int res_mkquery(int query_type, char* domain_name, int class, int type,
				char* data, int data_length, int inutile, char* buffer,
				int buf_length);

int dn_expand(const u_char *msg, const u_char *eom, const u_char *src,
          char *dst, int dstsiz);
int dn_skipname(const u_char *src, const u_char *eom);

void GetAnswer(unsigned char *msg, unsigned char *eom, unsigned char *src,
			   unsigned short int type, unsigned short int length,
			   char nomehost[], int namelen);

int process_errors(int errors,char* message,char* host);

int res_nsend(SOCKADDR *dns_addr, const unsigned char *query, int querylen,
			  unsigned char *query_rep, int anslength);
int ns_skiprr(const u_char *msg, const u_char *eom,
			  ns_sect section,
			  int count);

int GetIPAddress(const u_char *src, const u_char *eom,
				 char *string, int len);
int GetMailExchanger(unsigned char *msg, unsigned char *eom, unsigned char *src,
			   		   char *name, int namelen, unsigned short *preference);

int GetSOA(unsigned char *msg, unsigned char *eom, unsigned char *src,
			   char *name, int namelen,
			   char *rname, int rnamelen,
			   unsigned long *serial,
			   unsigned long *refresh,
			   unsigned long *retry,
			   unsigned long *expire);
