#ifndef GAME_H
#define GAME_H

#pragma pack(1)
struct HEADER
{
	char gname[10]			PACKED;
	char nul1[2]			PACKED;
	char something			PACKED;
	char nul2[2]			PACKED;
	char num_sectors		PACKED;
	char num_sectors_mod	PACKED;
	char nul3[0x6F]			PACKED;
};

struct DATAHEADER
{
	UINT8	num_objects			PACKED;		/* number of objects */
	UINT8	num_verbs			PACKED;		/* number of verbs */
	UINT8	num_nouns			PACKED;		/* number of nouns */
	UINT8	red_room			PACKED;		/* the red room (dead room) */
	UINT8	max_items_carried	PACKED;		/* max number of items can be carried */
	UINT8	begin_locn			PACKED;		/* room to start in */
	UINT8	num_treasures		PACKED;		/* number of treasures */
	UINT8	cmd_length			PACKED;		/* number of letters in commands */
	UINT16	light_turns			PACKED;		/* max number of turns light lasts */
	UINT8	treasure_locn		PACKED;		/* location of where to store treasures */
	UINT8	strange				PACKED;		/* !?! not known. */

	UINT16	p_obj_table			PACKED;		/* pointer to object table */
	UINT16	p_orig_items		PACKED;		/* pointer to original items */
	UINT16	p_obj_link			PACKED;		/* pointer to link table from noun to object */
	UINT16	p_obj_descr			PACKED;		/* pointer to object descriptions */
	UINT16	p_message			PACKED;		/* pointer to message pointers */
	UINT16	p_room_exit			PACKED;		/* pointer to room exits table */
	UINT16	p_room_descr		PACKED;		/* pointer to room descr table */

	UINT16	p_noun_table		PACKED;		/* pointer to noun table */
	UINT16	p_verb_table		PACKED;		/* pointer to verb table */

	UINT16	p_explicit			PACKED;		/* pointer to explicit action table */
	UINT16	p_implicit			PACKED;		/* pointer to implicit actions */
	UINT16	saved_room			PACKED;		/* saved room */
	UINT16	nul1[2]				PACKED;		/* nul1 */
	UINT16	saved_timer			PACKED;		/* saved timer */
	UINT16	nul2[14]			PACKED;		/* nul2 */
	UINT16	save_area			PACKED;		/* save area */
	UINT16	nul3[4]				PACKED;		/* nul3 */
	UINT16	dynamic_area		PACKED;		/* dynamic part of file */
};

#pragma pack()

#define MAX_TIMERS		16
#define MAX_ITEMS		254
#define MAX_RRV			16
#define MAX_FLAGS		32

#define X_TRUE			1
#define X_FALSE			0

struct GAME
{
	int		locn;				/* current location */
	unsigned char bitflags[MAX_FLAGS/8];	/* bitflags */
	int		inv_flag;			/* inventory flag */
	long	rnd_seed;			/* random seed */
	int		light;				/* light turns */
	int		cur_timer;			/* current timer */
	int		timers[MAX_TIMERS];	/* 16 timers */
	int		room_rv[MAX_RRV];	/* room rv (?) for select_rv */
	int		items[MAX_ITEMS];	/* you have these items. */

	char	undo_data_ok;		/* can we do an undo? */
	int		sgeo_game_flag;		/* cooked game */
};

#endif
