#charset "us-ascii"

/* License.t - License Info for Games */

#include <adv3.h>
#include <en_us.h>

DefineSystemAction(License)
  execSystemAction()
  {
    
        
   "<u><<versionInfo.name>></u>\b
    Copyright (c) <<versionInfo.cYear>> <<versionInfo.byline>>\b
   

1. This license grants you the right to use and distribute <<versionInfo.name>> (<q>the game</q>) 
under the conditions outlined below. You cannot use or distribute the game if you do not 
agree with these conditions.\b

2. The game, including any and all associated files as well as all of the output produced 
by the game, and all derivative works, is copyright (c) <<versionInfo.cYear>> <<versionInfo.byline>>.\b

3. Queries about the license should be addressed to the copyright holder, whose address 
at the time of writing is <<email('mailto:', 'eric.eve@hmc.ox.ac.uk')>>.
If contact cannot be established, you 
may be able to locate the copyright holder via the <<email('news:', 'rec.arts.int-fiction')>> 
Internet newsgroup.\b

4. You are allowed to use the game and make copies for your personal use without restrictions. 
You may also copy and distribute the game in any medium, as long as (a) you make no charge for 
doing so, and (b) the game, all associated files and this license are included and remain 
unmodified.\b

5. You are <b>not allowed</b> to make a charge for distributing the game (either for profit or merely 
to recover your media and distribution costs) whether as a stand-alone product, or as part of 
a compilation or anthology, without written permission.\b

6. NO WARRANTY. The game is licensed and provided <q>as is</q> without warranty of any kind, 
express or implied, including, but not limited to, the implied warranties of merchantability 
and fitness for a particular purpose or a warranty of non-infringement.";

  }
  
 email(prefix, address)
 {
     local htmlTerp = (systemInfo(SysInfoInterpClass) == SysInfoIClassHTML);
     
     if(htmlTerp)
       return '<a href=\''+ prefix + address + '\'>' + address + '</a>';
     else
       return '&lt;' + address + '&gt;';
 }  
  
;


VerbRule(License)
  'license' | 'copyright'
  : LicenseAction
  verbPhrase = 'display/displaying license information'
;

#ifdef __DEBUG

InitObject 
  execute
  {
     if(versionInfo.cYear == nil)
     {
       versionInfo.cYear = getTime()[1];
       "<.p><FONT COLOR=RED><b>*** WARNING ***</b></FONT>\n
       Copyright year temporarily set to <<versionInfo.cYear>>. To ensure the correct year in 
        your released game please define it in the property
        <FONT FACE=TADS-Typewriter>versionInfo.cYear</FONT>.<.p>";
     }
  } 
  execBeforeMe = [adv3LibInit]

;
 
#endif