! ----------------------------------------------------------------------------
!  GRAMMAR:  Grammar table entries for the standard verbs library.
!
!  Supplied for use with Inform 6                         Serial number 991113
!                                                                 Release 6/10
!  (c) Graham Nelson 1993, 1994, 1995, 1996, 1997, 1998, 1999
!      but freely usable (see manuals)
! ----------------------------------------------------------------------------
!  The "meta-verbs", commands to the game rather than in the game, come first:
! ----------------------------------------------------------------------------
!   Deutsch von (c) Toni Arnold 1997/98/99
!   Schlierenberg 22, 8048 Zuerich, Switzerland
!
!   Deutsche Serial No 991216
!
! Teile davon korrigiert und ergaenzt mit der library von Ralf Herrman.
!
! This library is free software; you can redistribute it and/or modify it under
! the terms of the GNU Library General Public License as published by the Free
! Software Foundation; either version 2 of the License, or (at your option) any
! later version.
!
! This library is distributed in the hope that it will be useful, but without
! any warranty; without even the implied warranty of merchantability or fitness
! for a particular purpose. See the GNU Library General Public License for more
! details.
!
! You should have received a copy of the GNU Library General Public License
! along with this library; if not, write to the Free Software Foundation, Inc.,
! 675 Mass Ave, Cambridge, MA 02139, USA.
! ----------------------------------------------------------------------------


! My handling of the german imperative verbs removes its 'e'-suffix
! because it is optional. As a consequence ALL verb entries must not end
! with an 'e'.

System_file;

Verb meta 'punkt' 'punktestand' 'scor'
                *                                -> Score
                * 'on'/'an'/'ein'/'einschalten'  -> NotifyOn
                * 'off'/'aus'/'ausschalten'      -> NotifyOff
                * 'voll'			 -> FullScore;
Verb meta 'voll' 'fullscor'
                *                                -> FullScore
                * 'punkte'                       -> FullScore;
Verb meta 'notify' 'meldungen'
	* 'on'/'an'/'ein'/'einschalten'		 -> NotifyOn
	* 'off'/'aus'/'ausschalten'		 -> NotifyOff;
Verb meta 'q//' 'quit' 'stirb' 'end' 'by' 'abbruch' 'beend' 'schluss'
                *                                -> Quit;
Verb meta 'lad' 'laden' 'load' 'restor'
                *                                -> Restore;
Verb meta 'neustart' 'wiedergeburt' 'neu'
                *                                -> Restart;
Verb meta 'filecheck' 'verify'
                *                                -> Verify;
Verb meta 'speicher' 'sicher' 'sav' 'speichern'
                *                                -> Save;
Verb meta 'skript' 'script' 'transkript' 'transcript' 'mitschrift'
                *                                -> ScriptOn
                * 'off'/'aus'                    -> ScriptOff
                * 'on'/'an'/'ein'                -> ScriptOn;
!Verb meta 'noscript' 'unscript'
!                *                                -> ScriptOff;
Verb meta 'knapp' 'normal' * -> LMode1;
Verb meta 'ausfuehrlich' 'lang' * -> LMode2;
Verb meta 'superknapp' 'superkurz' 'kurz' * -> LMode3;
Verb meta 'pronomen' 'fuerwort'
                *                                -> Pronouns;
Verb meta 'version'
                *                                -> Version;
#IFNDEF NO_PLACES;
Verb meta 'ort' 'places' 'plaetz' 'raeum'
                *                                -> Places;
Verb meta 'objekt' 'objects' 'gegenstaend' 'ding' 'sachen'
                *                                -> Objects;
#ENDIF;

! ----------------------------------------------------------------------------
!  Debugging grammar
! ----------------------------------------------------------------------------

#ifdef DEBUG;
Verb meta 'trac'
                *                                -> TraceOn
                * number                         -> TraceLevel
                * 'on'                           -> TraceOn
                * 'off'                          -> TraceOff;
Verb meta 'actions'
                *                                -> ActionsOn
                * 'on'                           -> ActionsOn
                * 'off'                          -> ActionsOff;
Verb meta 'routines' 'messages'
                *                                -> RoutinesOn
                * 'on'                           -> RoutinesOn
                * 'off'                          -> RoutinesOff;
Verb meta 'timers' 'daemons'
                *                                -> TimersOn
                * 'on'                           -> TimersOn
                * 'off'                          -> TimersOff;
Verb meta 'changes'
                *                                -> ChangesOn
                * 'on'                           -> ChangesOn
                * 'off'                          -> ChangesOff;
Verb meta 'recording'
                *                                -> CommandsOn
                * 'on'                           -> CommandsOn
                * 'off'                          -> CommandsOff;
Verb meta 'replay'
                *                                -> CommandsRead;
Verb meta 'random'
                *                                -> Predictable;
Verb meta 'purloin'
                * multi                          -> XPurloin;
Verb meta 'abstract'
                * noun 'to' noun                 -> XAbstract;
Verb meta 'tre'
                *                                -> XTree
                * noun                           -> XTree;
Verb meta 'goto'
                * number                         -> Goto;
Verb meta 'gonear'
                * noun                           -> Gonear;
Verb meta 'scop'
                *                                -> Scope
                * noun                           -> Scope;
Verb meta 'showverb'
                * special                        -> Showverb;
Verb meta 'showobj'
                *                                -> Showobj
                * multi                          -> Showobj;

Verb meta 'deklinier' 'dekl'	  		 ! esp for german
                * noun                           -> Dekliniere
                * 'komplett' noun                -> DekliniereAll;
#ifdef TARGET_GLULX;
Verb meta 'glklist'
                *                                -> Glklist;
#endif; ! TARGET_;
#endif;

! ------------------------------------------------------------------------------
! Token <hinein>	Ueberliest 'hinein' und 'rein'
! Token <heraus>	Ueberliest 'heraus' 'herunter' und 'raus'
!
! Token <xhinweg>	Verlange eines von 'weg' 'fort' 'hinweg' und 'hinfort'
!
! Token <xhinein>	Bilde 'hinein' und 'rein' auf Objekt `qwe' ab
! Token <xheraus>	Bilde 'heraus' etc. auf Objekt `qwe' ab
!
! Man beachte, dass die Abbildung von 'hinein' etc auf qwe (i.e., das Objekt,
! das von diesem Pronomen bezeichnet wird) nicht von LanguageToInformese
! vorgenommen werden kann, da wir diese Bezeichnungen auch als Richtungsangabe
! brauchen (und wir wollen doch nicht das >>gehe hinein<< zu >>gehe in qwe<<
! uebersetzt wird, da dies allzu oft missverstaendlich waere. Ausserdem sind im
! Deutschen Saetze wie >>lege alles in die truhe hinein<< durchaus ueblich, doch
! ergaeben sie dann nur Unsinn).
! ------------------------------------------------------------------------------

!Erweiterung Max Kalus:
! Token <xdamit>		Bilde 'damit' etc. auf Objekt `qwe' ab

[ Token__LokalAdverb a i	w;

  w = NextWordStopped();

  if (w == -1 && i == 1) return GPR_PREPOSITION;
  if (w == 'da' or 'dort' or 'hier') w = NextWordStopped();

  switch (a)
    {
      1: if (w == 'hinein' or 'rein') a = -1;
      2: if (w == 'heraus' or 'herunter' or 'raus') a = -1;
      3: if (w == 'hinweg' or 'hinfort' or 'weg' or 'fort') a = -1;
      4: if (w == 'damit') a = -1;
    };

  if (a == -1)
    {
      if (i ~= 0) return GPR_PREPOSITION;

      w = PronounValue('spez.');

      if (w == 0) return GPR_FAIL;
      if (TestScope(w, actor)) return w;
    };

  return GPR_FAIL;
];

[ hinein;	return Token__LokalAdverb(1, 1); ];
[ heraus;	return Token__LokalAdverb(2, 1); ];
[ xhinweg;	return Token__LokalAdverb(3, 2); ];
[ xhinein;	return Token__LokalAdverb(1, 0); ];
[ xheraus;	return Token__LokalAdverb(2, 0); ];
[ xdamit;	return Token__LokalAdverb(4, 0); ];

! ----------------------------------------------------------------------------
!  And now the game verbs.
!   Thanks to Max Kalus and Ralf Herrmann
! ----------------------------------------------------------------------------

Verb 'nimm' 'nehm' 'hol'
                * multi                          -> Take
                * multi 'auf'/'mit'              -> Take
                * worn 'ab'                      -> Disrobe
                * multiinside 'von'/'aus' noun   -> Remove
                * multiinside 'von'/'aus' noun heraus -> Remove
                * multiinside xheraus            -> Remove
		* 'platz' 'auf'/'in' noun	 -> Enter
		* 'auf'/'in' noun 'platz'	 -> Enter;
                
Verb 'greif' 'fass' 'ergreif'
	* multi					 -> Take
	* multiinside 'in' noun			 -> Remove
	* multiinside 'auf' noun		 -> Remove
	* multiinside xheraus    		 -> Remove
	* 'an' noun				 -> Touch
	* creature 'an'				 -> Attack
        * creature 'mit' held 'an'               -> Attack
        * 'mit' held creature 'an'               -> Attack reverse
        * creature 'an' 'mit' held               -> Attack
	* noun 'an'				 -> Touch
	* 'nach' multi				 -> Take
	* 'nach' multiinside 'in' noun		 -> Remove
	* 'nach' multiinside 'auf' noun		 -> Remove
	* multiinside 'von'/'aus' noun  	 -> Remove
	* multiinside 'von'/'aus' noun heraus 	 -> Remove;

Verb 'pack'
	* multi					 -> Take
	* multi 'ein'				 -> Take
	* 'ein' multi				 -> Take
	* creature				 -> Attack
	* multiexcept 'auf' noun		 -> PutOn
	* multiexcept 'in' noun hinein		 -> Insert
	* multiexcept xhinein			 -> Insert
	* 'dich'				 -> VagueGo
	* 'dich' 'auf' noun			 -> Enter;

Verb 'heb'
	* multi 'auf'				 -> Take
	* multiinside xheraus    		 -> Remove
	* noun 'an'/'hoch'			 -> Lift
	* 'an'/'hoch' noun			 -> Lift
	* 'dich' 'auf'				 -> Exit
	* 'dich' 'auf' 'aus'/'von' noun		 -> GetOff
	* 'dich' 'aus'/'von' noun		 -> GetOff
	* 'dich' xhinweg			 -> VagueGo;

Verb 'trag'
                * held				 -> wear;

Verb 'steh'
                *                                 -> Exit
                * 'auf'                           -> Exit
                * 'auf' 'von'/'aus' noun	  -> GetOff
                * 'auf' noun                      -> Enter;
Verb 'entfern'
                * worn				  -> Disrobe
                * multi                           -> Take
                * held                            -> Drop	!auskommentieren? Max Kalus
                * multiinside 'von'/'aus' noun    -> Remove;

Verb 'tu' 'platzier'
                * multiheld                       -> Drop
                * multiheld 'weg'                 -> Drop
                * 'dich'/'mich' 'auf'/'in' noun	  -> Enter
                * 'dich'/'mich' 'auf'/'in' noun 'nieder'  -> Enter
		* 'dich'/'mich' xhinein		  -> Enter
                * multiexcept 'in' noun           -> Insert
                * multiexcept 'in' noun hinein    -> Insert
                * multiexcept xhinein		  -> Insert
                * multiexcept 'auf' noun          -> PutOn;

Verb 'steck'
	* multiexcept 'in' noun hinein			-> Insert
	* multiexcept 'in' noun				-> Insert
	* multiexcept 'ein'				-> Take
	* multiexcept xhinein				-> Insert
	* multiexcept 'auf' noun			-> PutOn
	* clothing 'an'					-> Wear
	* 'an' clothing					-> Wear
	* noun 'an'					-> Burn
	* noun 'mit' held 'an'				-> Burn
	* 'mit' held noun 'an'				-> Burn;

Verb 'leer' 'schuett' 'giess' 'entleer'
                 * noun                           -> Empty
                 * noun 'aus'                     -> Empty
                 * noun 'zu'/'in'/'auf' noun      -> EmptyT
                 * noun xhinein		          -> EmptyT;

Verb 'lass' 'wirf' 'werf' 'schmeiss' 'schleuder'
                * multiheld                      -> Drop
                * multiheld 'fallen'/'hier'/'ab'/'weg' -> Drop
                * multiexcept 'in'/'unter' noun  -> Insert
                * multiexcept 'in' noun hinein   -> Insert
                * multiexcept xhinein            -> Insert
                * multiexcept 'auf'/'ueber' noun -> PutOn
                * held 'nach'/'gegen'/'auf'/'zu' noun    -> ThrowAt
                * 'nach'/'gegen'/'auf'/'zu' noun held    -> ThrowAt
                * held noun 'zu'/'nach'          -> ThrowAt
		* multiheld xhinweg		 -> Drop
		* 'dich' 'auf' creature		 -> Attack
		* 'dich' 'gegen' noun		 -> Attack
		* creature 'nieder'		 -> Attack
		* 'dich' 'auf'/'in' noun	 -> Enter;

Verb 'gib' 'geb' 'offerier' 'reich' 'uebertrag' 'ueberreich' 'uebergib'
                * held creature                  -> Give
                * held 'an' creature             -> Give
                * 'an' creature held             -> Give reverse
                * creature held                  -> Give reverse;

Verb 'fuetter' 'bezahl' 'zahl'
        * creature 'mit' held	      		-> Give reverse
	* 'mit' held creature			-> Give
	* held 'an' creature			-> Give
	* 'an' creature held			-> Give reverse
        * creature xdamit	      		-> Give reverse
	* xdamit creature			-> Give;
	
Verb 'biet'
     	* creature held 'an'				-> Give reverse
	* held creature 'an'				-> Give
	* 'fuer' noun					-> Buy;

Verb 'zeig' 'praesentier' 'fuehr'
	* creature held					-> Show reverse
	* held creature 				-> Show
	* creature held 'vor'				-> Show reverse
	* held creature 'vor'				-> Show
	* 'inventar'/'besitz'/'eigentum'		-> Inv;

[ ADirection; if (noun in compass) rtrue; rfalse; ];
Verb 'geh' 'lauf' 'renn' 'wander' 'fluechte' 'flieh' 'schreite' 'spazier'
                *                                -> VagueGo
		* 'umher'/'weg'/'fort'		 -> VagueGo
                * 'in'/'durch' noun              -> Enter
                * 'auf' noun                     -> Climb
                * noun=ADirection	         -> Go
                * 'nach' noun=ADirection         -> Go
		* 'nach' 'draussen'		 -> Exit
                * noun                           -> Enter
                * 'raus'/'hinaus'/'heraus'       -> Exit
                * 'rein'/'hinein'/'herein'       -> GoIn;

Verb 'verlass' 'v//'
                *                                -> VagueGo
		* creature			 -> VagueGo
                * noun=ADirection                -> Go
                * noun                           -> Exit
                * 'in'/'durch' noun              -> Enter
                * 'diesen' 'ort'/'raum'/'platz'	 -> VagueGo
                * 'ort'/'raum'/'platz'	 	 -> VagueGo;

Verb 'mach'
                * noun 'zu'                      -> Close
                * noun 'auf'                     -> Open
                * noun 'an'			 -> SwitchOn
                * noun 'aus'			 -> SwitchOff
                * noun 'kaputt'			 -> Attack;

Verb 'inventar' 'inv' 'i//' 'besitz' 'eigentum' 'zeug'
                *                                -> Inv
                * 'gross'/'lang'/'liste'         -> InvTall
                * 'weit'/'breit'/'satz'          -> InvWide;

Verb 'schau' 'seh' 'l//' 'sieh' 'blick'
                *                                -> Look
                * 'dich'/'mich' 'um'             -> Look
                * 'herum'/'umher'                -> Look
		* noun 'an'			 -> Examine
                * noun				 -> Examine
                * 'auf'/'durch' noun             -> Examine
                * 'in'/'aus'/'nach'/'neben' noun -> Search
                * 'in'/'auf'/'neben' noun 'nach' -> Search
                * 'in' noun hinein		 -> Search
                * xhinein			 -> Search
                * 'unter'/'hinter' noun          -> LookUnder
                * 'unter'/'hinter' noun 'nach'   -> LookUnder
                * topic 'nach' 'in' noun         -> Consult
                * 'nach' topic 'in' noun         -> Consult
                * 'in' noun 'ob'/'ueber' topic 'nach' -> Consult
                * 'ueber'/'ob' topic 'in' noun 'nach' -> Consult;
                
Verb 'forsch' 'lern'
	* 'nach'/'ob'/'ueber'/'von' topic 'in'/'aus' noun	-> Consult
	* 'in'/'aus' noun 'nach'/'ob'/'ueber'/'von' topic	-> Consult;

Verb 'konsultier'
                * noun 'ueber' topic             -> Consult
                * noun 'bezueglich' topic        -> Consult;
Verb 'oeffn'
                * noun                           -> Open
                * 'mit' held noun                -> Unlock reverse
                * noun 'mit' held                -> Unlock
                * xdamit noun                    -> Unlock reverse
                * noun xdamit                    -> Unlock;

Verb 'durchquer' 'betret' 'betritt'
                *                                -> GoIn
                * noun                           -> Enter;

Verb 'tret' 'tritt'
                * noun                           -> Attack
                * 'ein'                          -> GoIn
                * 'aus'/'heraus'/'hinaus'        -> Exit
                * 'in' noun                      -> Enter
                * 'in' noun 'hinein'/'ein'       -> Enter
                * xhinein			 -> Enter;

Verb 'setz' 'leg'
                * multiheld                       -> Drop
                * worn 'ab'                       -> Disrobe
                * multiheld 'ab'/'hin'/'weg'      -> Drop
                * xhinweg multiheld 		  -> Drop
                * multiheld xhinweg		  -> Drop
                * 'dich'/'mich' 'auf'/'in' noun	  -> Enter
                * 'dich'/'mich' 'auf'/'in' noun 'nieder'  -> Enter
                * 'dich'/'mich' xhinein		  -> Enter
                * multiexcept 'in' noun           -> Insert
                * multiexcept 'in' noun hinein    -> Insert
                * multiexcept xhinein		  -> Insert
                * multiexcept 'auf' noun          -> PutOn
                * xhinein			  -> Enter
                * held 'an'/'um'                  -> Wear;

Verb 'sitz' 'lieg'
                * 'auf' noun                      -> Enter
                * 'in' noun                       -> Enter;

Verb 'rein' 'hinein' 'herein'
                *                                -> GoIn
                * 'in' noun                      -> GoIn;

Verb 'raus' 'hinaus' 'heraus' 'a//'
                *                                -> Exit
                * 'aus' noun                     -> Exit;

Verb 'untersuch' 'x//' 'b//' 'u//' 'betracht' 'beschreib' 'check' 'begutacht'
                *                                -> Look
                * noun                           -> Examine
                * multiexcept                    -> Examine;

Verb 'durchsuch' 'durchwuehl' 'durchstoeber'
	* noun					 -> Search;

Verb 'lies' 'les'
                * noun                           -> Examine
		* multi 'auf'			 -> Take
                * 'in' noun			 -> Examine
                * 'ueber'/'von' topic 'in' noun  -> Consult
                * 'ueber'/'von' topic 'in' noun 'nach' -> Consult
                * topic 'in' noun                -> Consult
                * 'in' noun 'ueber'/'von' topic  -> Consult;

Verb 'ja' 'j//' 'jawohl'
                *                                -> Yes;
Verb 'nein' 'nee' 'noe'
                *                                -> No;

Verb 'sorry' 'entschuldigung' 'entschuldig' 'verzeih' 'pardon'
	*						-> Sorry
	* 'mir'						-> Sorry
	* 'mir' 'bitte'					-> Sorry
	* 'bitte'					-> Sorry;

Verb 'scheiss' 'kack' 'arsch' 'arschloch' 'wichser' 'wixer' 'piss' 'verpiss'
                *                                -> Strong
                * topic                          -> Strong;

Verb  'tadel' 'verfluch' 'verdamm' 'verdammt' 'mist' 'jammer' 'winsel' 'schimpf'
	'wuete' 'zuerne' 'schiet' 'hader' 'scheibenkl' 'fluch'
                *                                -> Mild;
                
Verb 'such' 'spuere' 'stoeber' 'wuehl'
	* noun						-> Search
	* 'in'/'auf'/'ab'/'hinter'/'neben' noun		-> Search
	* noun 'ab'					-> Search
	* 'unter' noun					-> LookUnder
	* 'in' noun 'nach' topic			-> Consult
	* 'nach' topic 'in' noun			-> Consult;

Verb 'wink'     *                                -> WaveHands
                * 'mit' noun                     -> Wave
                * xdamit                         -> Wave;

Verb 'stell'
                * noun                           	-> Set
		* multiexcept 'in' noun 		-> Insert
		* multiexcept 'in' noun	hinein		-> Insert
		* multiexcept xhinein			-> Insert
		* multiexcept 'auf' noun		-> PutOn
                * noun 'auf' special 'ein'		-> SetTo
                * noun 'auf' special			-> SetTo
                * noun 'auf' topic 'ein'		-> SetTo
                * noun 'auf' topic			-> SetTo
                * noun 'an'				-> SwitchOn
                * switchable 'ab'			-> SwitchOff
                * multiheld 'ab'			-> Drop
                * multiheld xhinweg			-> Drop;

Verb 'zieh' 'reiss' 'zerr' 'rupf'
                * noun                           -> Pull
                * 'an' noun                      -> Pull
                * noun 'weg'                     -> Pull
                * noun 'ab'                      -> Take
                * noun heraus                    -> Remove
                * held 'an'/'ueber'              -> Wear
                * held 'aus'                     -> Disrobe;

Verb 'kleid' 'bekleid' 'schmueck'
	* 'dich'/'mich' 'an' 'mit' noun		-> Wear
	* 'dich'/'mich' 'mit' noun 'an'		-> Wear
	* 'dich'/'mich' 'mit'/'in' noun		-> Wear
	* 'dich'/'mich' 'an' xdamit		-> Wear
	* 'dich'/'mich' xdamit 'an'		-> Wear
	* 'dich'/'mich' xdamit		        -> Wear;

Verb 'drueck' 'press' 'beweg' 'schieb' 'verschieb'
                * noun                           -> Push
                * xhinein                        -> Push
                * noun 'weg'                     -> Push
                * 'gegen' noun                   -> Push
                * noun noun                      -> PushDir
                * noun 'nach'/'richtung' noun    -> PushDir
                * noun 'aus'/'zusammen'          -> Squeeze
                * noun 'zu' noun                 -> Transfer
                * multiexcept 'in' noun		 -> Insert
                * multiexcept xhinein		 -> Insert
                * noun 'auf'			 -> Open
                * noun 'zu'			 -> Close
		* noun 'hoch'/'hinauf'		 -> Lift
		* noun 'nach' 'oben'		 -> Lift;

Verb 'dreh' 'rotier' 'schraub'
                * noun                           -> Turn
                * noun 'ein'/'an'                -> Switchon
                * noun 'aus'                     -> Switchoff
                * 'ein'/'an' noun                -> Switchon
                * noun 'aus'                     -> Switchoff
                * noun 'auf' special             -> SetTo
                * noun 'auf'                     -> Open
                * noun 'zu'                      -> Close;

Verb 'schalt'
                * noun                           -> Switchon
                * noun 'ein'/'an'                -> Switchon
                * noun 'aus'/'ab'                -> Switchoff
                * 'ein'/'an' noun                -> Switchon
                * noun 'aus'                     -> Switchoff;

Verb 'schliess' 'sperr'
                * noun                           -> Close
                * noun 'mit' held                -> Lock
                * noun 'mit' held 'ab'           -> Lock
                * noun 'ab'                      -> Lock
                * noun 'ab' 'mit' held           -> Lock
                * noun 'mit' held 'auf'          -> Unlock
                * noun 'auf' 'mit' held          -> Unlock
                * noun xdamit                    -> Lock
                * noun xdamit 'ab'               -> Lock
                * noun 'ab' xdamit               -> Lock
                * noun xdamit 'auf'              -> Unlock
                * noun 'auf' xdamit              -> Unlock;

Verb 'verschliess' 'verriegel' 'verriegl'
                * lockable                       -> Lock
                * noun                           -> Close
                * noun 'mit' held                -> Lock
                * noun xdamit                    -> Lock;

Verb 'schlag' 'hau'
		* creature				-> Attack
		* xhinein				-> Attack
		* noun					-> Attack
		* 'auf'	noun				-> Attack
		* noun 'auf'				-> Open
		* noun 'zu'				-> Open
		* 'in' noun 'ueber' topic 'nach' 	-> Consult
		* 'in' noun topic 'nach'         	-> Consult
		* 'mit' held 'gegen' noun		-> Attack reverse
		* held 'gegen' noun			-> Attack reverse
		* noun 'um'/'ab'/'entzwei'/'kaputt'	-> Attack
		* topic 'in'/'nach' noun 'nach'         -> Consult
		* topic 'nach' 'in' noun         	-> Consult
		* xdamit 'gegen' noun	   	        -> Attack reverse;

Verb 'attackier' 'brich' 'brech' 'zerbrich' 'vernichte' 'zerstoer' 'zerschlag' 'zertruemmer'
     'destroy' 'kaempf' 'toet' 'kick' 'ermord' 'mord' 'bekaempf' 'folter' 'quael' 'pruegel'
                * noun                          -> Attack
		* noun 'mit' held		-> Attack
		* noun xdamit		        -> Attack;

Verb 'wart' 'z//' 'harr' 'verharr'
                *                                -> Wait;

Verb 'antwort' 'schrei' 'beantwort'
                * creature topic		 -> Answer reverse
                * topic 'zu' creature            -> Answer;

Verb 'red' 'sprech' 'sprich' 'schwatz' 'schwaetz' 'babbel'
                * creature 'ueber' topic         -> Tell
                * 'mit'/'zu' creature 'ueber' topic 
                                                 -> Tell;

Verb 'erzaehl' 'unterricht' 'bericht' 'erklaer'
                * creature 'ueber'/'von' topic   -> Tell;

Verb 'sag'
                * creature topic                 -> Tell
                * creature 'ueber' topic         -> Tell;

Verb 'frag' 'befrag'
		* creature			 -> Ask
                * creature 'ueber' topic         -> Ask
                * creature 'nach' noun           -> AskFor
		* creature 'nach'/'ueber'/'ob' topic -> Ask;

Verb 'ess' 'iss' 'friss' 'verspeis' 'verzehr'
                * held                           -> Eat;

Verb 'schlaf' 'nick' 'schlummer' 'does'
                * 'ein'                          -> Sleep
                *                                -> Sleep;

!Verb 'schael'   * noun                            -> Take;

Verb 'streif'   * noun 'ab'                       -> Disrobe;

Verb 'sing' 'traeller' 'pfeif'
		*                                 -> Sing;

Verb 'kletter' 'klettr' 'steig' 'erklimm' 'erkletter'
                * noun                            -> Climb
                * noun 'hoch'                     -> Climb
                * 'auf'/'ueber' noun              -> Climb
                * 'auf' noun 'hoch'               -> Climb
                * 'in' noun                       -> Enter
                * 'in' noun hinein                -> Enter
                * xhinein                         -> Enter
                * xheraus                         -> GetOff
                * 'von'/'aus' noun		  -> GetOff
                * 'von'/'aus' noun 'ab'/'runter'  -> GetOff;

Verb 'kauf' 'erwerb' 'erwirb'
                * noun                            -> Buy;

Verb 'zerdrueck' 'quetsch' 'zerquetsch'
                * noun                            -> Squeeze;

Verb 'schwimm' 'tauch'
                *                                 -> Swim;

Verb 'schwing' 'schwenk' 'wedel' 'wedl' 'bauml''baumel'
                * noun                            -> Wave
                * 'auf'/'an' noun                 -> Swing
                * 'mit' noun			  -> Wave
                * xdamit			  -> Wave
                * 'dich'/'mich' 'auf'/'in' noun   -> Swing
                * 'mit' 'der' 'hand'		  -> WaveHands
                * 'mit' 'den' 'haenden'		  -> WaveHands;

Verb 'blas' 'pust'
                * held                            -> Blow
                * 'in'/'auf' held                 -> Blow
                * xhinein                         -> Blow;

Verb 'bet' 'bitt'
                *                                 -> Pray
                * creature 'um' noun              -> AskFor;

Verb 'wach' 'erwach' 'weck' 'erweck'
                *                                 -> Wake
                * 'auf'                           -> Wake
                * creature                        -> WakeOther
                * creature 'auf'                  -> WakeOther;

Verb 'kuess' 'umarm' 'lieb' 'streichel' 'streichl' 'knutsch' 'umgarn' 'liebkos'
                * creature                        -> Kiss;
Verb 'denk'
                *                                 -> Think;
Verb 'riech' 'schnueffl' 'schnueffel' 'schnupper'
                *                                 -> Smell
                * noun                            -> Smell
                * 'an' noun                       -> Smell;

Verb 'hoer' 'horch' 'lausch'
                *                                 -> Listen
                * noun                            -> Listen
                * noun 'zu'                       -> Listen
                * 'an' noun                       -> Listen;

Verb 'schmeck' 'leck' 'kost' 'probier'
                * noun                            -> Taste;

Verb 'beruehr' 'fuehl' 'ertast' 'tast' 'befuehl' 'betaste'
                * noun                            -> Touch
		* noun 'an'			  -> Touch
		* 'an'/'ueber'/'nach' noun	  -> Touch;

Verb 'wisch' 'reinig' 'putz' 'reib' 'schrubb' 'saeuber' 'polier' 'glaette' 'schmirgel' 'buerst'
                * noun                            -> Rub
                * noun 'mit' held                 -> Rub
                * noun xdamit                     -> Rub;

Verb 'fixier' 'bind' 'befestig' 'knot' 'verknot'
                * noun                            -> Tie
                * noun 'an' noun                  -> Tie;

Verb 'zuend' 'brenn'
                * noun 'an'/'nieder'              -> Burn
                * noun 'mit' held 'an'            -> Burn
                * noun xdamit			  -> Burn
                * 'mit' held noun 'an'            -> Burn reverse
                * xdamit noun 			  -> Burn reverse;
                
Verb 'entzuend' 'entflamm' 'verbrenn'
                * noun                            -> Burn
                * noun 'mit' held                 -> Burn
                * 'mit' held noun                 -> Burn
                * noun xdamit                     -> Burn
                * xdamit noun    	          -> Burn;

Verb 'trink' 'sauf' 'schluerf' 'schluck'
                * noun                           -> Drink;

Verb 'fuell'
                * noun                           -> Fill
                * noun 'auf'                     -> Fill
                * noun 'in' noun                 -> EmptyT
                * noun 'mit' noun                -> EmptyT reverse;

Verb 'schneid' 'trenn' 'loese' 'spalte' 'zertrenn' 'durchschneid' 'teil' 'zerteil' 'zerschneid'
                * noun                           -> Cut
                * creature                       -> Attack
                * noun 'durch'                   -> Cut
                * 'mit' noun                     -> Cut
		* noun 'mit' noun                -> Cut reverse
                * noun 'durch'/'ab' 'mit' noun   -> Cut reverse
                * noun 'mit' noun 'durch'/'ab'   -> Cut reverse
                * 'dich' 'von' multiheld	 -> Drop
		* noun 'auf'			 -> Cut
                * xdamit			 -> Cut
		* noun xdamit                	 -> Cut reverse
                * noun 'durch'/'ab' xdamit       -> Cut reverse
                * noun xdamit 'durch'/'ab'       -> Cut reverse;

Verb 'spring' 'huepf'
                *                                -> Jump
                * 'hoch'/'herum'/'umher'         -> Jump
                * 'ueber' noun                   -> JumpOver;

Verb 'grab' 'hack'
                *                                -> Dig    ! ### Maulwurf
                * noun                           -> Dig
                * 'in' noun                      -> Dig
                * 'in' noun 'mit' held           -> Dig
                * 'mit' held 'in' noun           -> Dig reverse
                * noun 'mit' held                -> Dig
                * 'in' noun xdamit               -> Dig
                * xdamit 'in' noun               -> Dig reverse
                * noun xdamit                    -> Dig;

! ------------------------------------------------------------------------------
! And now the game verbs
! ------------------------------------------------------------------------------

[ LiftSub;	<<LookUnder noun>>;	];	! Hebe den Schrank an

! ----------------------------------------------------------------------------
!  This routine is no longer used here, but provided to help existing games
!  which use it as a general parsing routine:

[ ConTopic w; consult_from = wn;
  do w=NextWordStopped();
  until (w==-1 || (w=='to' && action_to_be==##Answer));
  wn--;
  consult_words = wn-consult_from;
  if (consult_words==0) return -1;
  if (action_to_be==##Ask or ##Answer or ##Tell)
  {   w=wn; wn=consult_from; parsed_number=NextWord();
      if (parsed_number=='the' && consult_words>1) parsed_number=NextWord();
      wn=w; return 1;
  }
  return 0;
];
! ----------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ----------------------------------------------------------------------------
#Stub TimePasses      0;
#Stub Amusing         0;
#Stub DeathMessage    0;
#Stub DarkToDark      0;
#Stub NewRoom         0;
#Stub LookRoutine     0;
#Stub AfterLife       0;
#Stub GamePreRoutine  0;
#Stub GamePostRoutine 0;
#Stub AfterPrompt     0;
#Stub BeforeParsing   0;
#Stub PrintTaskName   1;
#Stub InScope         1;
#Stub UnknownVerb     1;
#Stub PrintVerb       1;
#Stub ParserError     1;
#Stub ParseNumber     2;
#Stub ChooseObjects   2;

#ifdef TARGET_GLULX;
#Stub IdentifyGlkObject 4;
#Stub HandleGlkEvent  2;
#Stub InitGlkWindow   1;
#endif; ! TARGET_GLULX

#IFNDEF PrintRank;
Constant Make__PR;
#ENDIF;
#IFDEF Make__PR;
[ PrintRank; "."; ];
#ENDIF;
#IFNDEF ParseNoun;
Constant Make__PN;
#ENDIF;
#IFDEF Make__PN;
[ ParseNoun obj; obj=obj; return -1; ];
#ENDIF;
#Default Story 0;
#Default Headline 0;
#IFDEF INFIX;
#Include "infix";
#ENDIF;
! ----------------------------------------------------------------------------
