! -*- mode: indented-text; coding: latin-1 -*- ---------------------------------
!  
! German Inform Library: Grammar layout
! Copyright (C) 1997, 1998, 1999 Ralf Herrmann
!
! $Release: 6.9.1 $
! $Revision: 1.23 $
! $Date: 1999/08/08 10:45:22 $
!
!	ralf@niflheim.de
!	http://www.niflheim.de/inform/
!
!	Ralf Herrmann
!	Ludwig-Landmann-Str. 52
!	60488 Frankfurt am Main
!	Federal Republic of Germany
!
! This library is free software; you can redistribute it and/or modify it under
! the terms of the GNU Library General Public License as published by the Free
! Software Foundation; either version 2 of the License, or (at your option) any
! later version.
!
! This library is distributed in the hope that it will be useful, but without
! any warranty; without even the implied warranty of merchantability or fitness
! for a particular purpose. See the GNU Library General Public License for more
! details.
!
! You should have received a copy of the GNU Library General Public License
! along with this library; if not, write to the Free Software Foundation, Inc.,
! 675 Mass Ave, Cambridge, MA 02139, USA.
!
! ------------------------------------------------------------------------------

System_file;

! ------------------------------------------------------------------------------
! Die Grammatik kann durch die Definition der folgenden Konstanten beeinflusst
! werden:
!
! VERB_WENIGE	Durch Definition dieser Konstanten werden einge weniger haeufig
!		gebrauchte Verben nicht mit aufgenommen
!
! VERB_MACHE	Erlaubt das Verb `mache'
!
! VERB_UGS	Definiert umgangssprachliche Aequivalente wie nehme, gebe...
! ------------------------------------------------------------------------------

! ------------------------------------------------------------------------------
! The "meta-verbs", commands to the game rather than in the game, come first
! ------------------------------------------------------------------------------

Verb meta 'q//' 'quit' 'bye' 'ende' 'abbruch' 'beende' 'schluss' 'stirb'
	*						-> Quit;
Verb meta 'score' 'fullscore' 'full' 'punkte' 'punktestand' 'pk' 'gesamt'
	*						-> Score
	* 'insgesamt'/'gesamt'				-> FullScore
	* 'in' 'dem' 'gesamten'				-> FullScore
	* 'score'/'punkte'				-> FullScore;
Verb meta 'notify' 'meldungen'
	* 'on'/'an'/'ein'/'einschalten'			-> NotifyOn
	* 'off'/'aus'/'ausschalten'			-> NotifyOff;
Verb meta 'restore' 'lade'
	*						-> Restore;
Verb meta 'restart' 'neustart' 'neu'
	*						-> Restart;
Verb meta 'verify'
	*						-> Verify;
Verb meta 'save' 'speicher' 'sicher'
	*						-> Save;
Verb meta 'script' 'transcript' 'skript' 'mitschrift'
	*						-> ScriptOn
	* 'on'/'an'/'ein'				-> ScriptOn
	* 'off'/'aus'					-> ScriptOff;
Verb meta 'noscript' 'unscript'
        *	     					-> ScriptOff;
Verb meta 'schilder'
	* 'sehr' 'knapp'/'kurz'				-> LMode3
	* 'kurz' 'und' 'knapp'				-> LMode1
	* 'knapp'/'normal'/'kurz'			-> LMode1
	* 'wortreich'/'ausfuehrlich'/'lang'		-> LMode2;
Verb meta 'verbose'
	* 						-> LMode2;
Verb meta 'superbrief'
	* 						-> LMode3;
Verb meta 'brief'
        * 						-> LMode1;
Verb meta 'pronouns' 'nouns' 'pronomen' 'fuerwort'
	*						-> Pronouns;
Verb meta 'version'
	*						-> Version;
Verb meta 'rechtschreibung'
	* 'schweiz'					-> szSwiss
	* 'reform'/'neu'				-> szGermNew
	* 'alt'						-> szGermOld
	* 'ohne'/'keine' 'umlaute'			-> noUmlaut
	*						-> szGermOld;

#ifndef NO_PLACES;

Verb meta 'places' 'orte' 'plaetze' 'raeume'
	*						-> Places;
Verb meta 'objects' 'objekte' 'gegenstaende' 'dinge' 'sachen'
	*						-> Objects;

#endif;

! ------------------------------------------------------------------------------
! Debugging grammar (there are no german verbs to avoid confusion)
! ------------------------------------------------------------------------------

#ifdef DEBUG;

Verb meta 'decline' 'deklinier'
	* noun						-> Decline;
Verb meta 'trace'
	*						-> TraceOn
	* number					-> TraceLevel
	* 'on'						-> TraceOn
	* 'off'						-> TraceOff
	* 'LTI'						-> TraceLTIOn
	* 'LTI' 'on'					-> TraceLTIOn
	* 'LTI' 'off'					-> TraceLTIOff;
Verb meta 'actions'
	*						-> ActionsOn
	* 'on'						-> ActionsOn
	* 'off'						-> ActionsOff;
Verb meta 'routines' 'messages'
	*						-> RoutinesOn
	* 'on'						-> RoutinesOn
	* 'off'						-> RoutinesOff;
Verb meta 'timers' 'daemons'
	*						-> TimersOn
	* 'on'						-> TimersOn
	* 'off'						-> TimersOff;
Verb meta 'recording'
	*						-> CommandsOn
	* 'on'						-> CommandsOn
	* 'off'						-> CommandsOff;
Verb meta 'replay'
	*						-> CommandsRead;
Verb meta 'random'
	*						-> Predictable;
Verb meta 'purloin'
	* multi						-> XPurloin;
Verb meta 'abstract'
	* noun 'to' noun				-> XAbstract;
Verb meta 'tree'
	*						-> XTree
	* noun						-> XTree;
Verb meta 'goto'
	* number					-> Goto;
Verb meta 'gonear'
	* noun						-> Gonear;
Verb meta 'scope'
	*						-> Scope
	* noun						-> Scope;
Verb meta 'showverb'
	* special					-> ShowVerb;
Verb meta 'showobj'
	* 						-> ShowObj
	* multi						-> ShowObj;

#endif;

! ------------------------------------------------------------------------------
! Special Tokens
! ------------------------------------------------------------------------------

! ------------------------------------------------------------------------------
! Token <direction>	Eine Richtungsangabe
!
! Syntax:	'gen'/'nach'/'richtung' noun	: gehe nach Norden
!		'in' noun 'richtung'		: gehe in noerdliche richtung
!		noun				: gehe noerdlich
! ------------------------------------------------------------------------------

[ direction		w x n;

  w = NextWord();

  switch (w)
    {
      'gen', 'nach', 'richtung':
        x = 0;
      'in':
        x = 'richtung';
      default:
        wn--;
    };

  n = NounDomain(actors_location, actor, NOUN_TOKEN);

  if (n == 0 or 1) return GPR_FAIL;
  if (n == REPARSE_CODE) return GPR_REPARSE;

  if (n notin compass) return GPR_FAIL;
  if (x ~= 0 && x ~= NextWord()) return GPR_FAIL;

  return n;
];

! ------------------------------------------------------------------------------
! Token <hinein>	Ueberliest 'hinein' und 'rein'
! Token <heraus>	Ueberliest 'heraus' 'herunter' und 'raus'
!
! Token <xhinweg>	Verlange eines von 'weg' 'fort' 'hinweg' und 'hinfort'
!
! Token <xhinein>	Bilde 'hinein' und 'rein' auf Objekt `qwe' ab
! Token <xheraus>	Bilde 'heraus' etc. auf Objekt `qwe' ab
!
! Man beachte, dass die Abbildung von 'hinein' etc auf qwe (i.e., das Objekt,
! das von diesem Pronomen bezeichnet wird) nicht von LanguageToInformese
! vorgenommen werden kann, da wir diese Bezeichnungen auch als Richtungsangabe
! brauchen (und wir wollen doch nicht das >>gehe hinein<< zu >>gehe in qwe<<
! uebersetzt wird, da dies allzu oft missverstaendlich waere. Ausserdem sind im
! Deutschen Saetze wie >>lege alles in die truhe hinein<< durchaus ueblich, doch
! ergaeben sie dann nur Unsinn).
! ------------------------------------------------------------------------------

[ Token__LokalAdverb a i	w;

  w = NextWordStopped();

  if (w == -1 && i == 1) return GPR_PREPOSITION;
  if (w == 'da' or 'dort' or 'hier') w = NextWordStopped();

  switch (a)
    {
      1: if (w == 'hinein' or 'rein') a = -1;
      2: if (w == 'heraus' or 'herunter' or 'raus') a = -1;
      3: if (w == 'hinweg' or 'hinfort' or 'weg' or 'fort') a = -1;
    };

  if (a == -1)
    {
      if (i ~= 0) return GPR_PREPOSITION;

      w = PronounValue('qwe');

      if (w == 0) return GPR_FAIL;
      if (TestScope(w, actor)) return w;
    };

  return GPR_FAIL;
];

[ hinein;	return Token__LokalAdverb(1, 1); ];
[ heraus;	return Token__LokalAdverb(2, 1); ];
[ xhinweg;	return Token__LokalAdverb(3, 2); ];
[ xhinein;	return Token__LokalAdverb(1, 0); ];
[ xheraus;	return Token__LokalAdverb(2, 0); ];

! ------------------------------------------------------------------------------
! And now the game verbs
! ------------------------------------------------------------------------------

[ LiftSub;	<<LookUnder noun>>;	];	! Hebe den Schrank an
[ ReadSub;	<<Examine noun>>;	];	! Lies das Buch
[ RamSub;	<<Attack noun second>>;	];	! Schlage Nagel in die Wand
[ MissmatchSub;     L__M(##ListMiscellany, 27, 0); ];

! ------------------------------------------------------------------------------
! *** WICHTIG! 
!
! Verben und "Praepositionen" (Token) sind in nichtumgelauteter Schreibweise,
! also mit ae, oe, ue und ss, anzugeben. Bei einem Verb das mit oder ohne -e
! geschrieben werden kann, etwa `tanze', muss die Form ohne -e eingetragen
! werden; die Library ergaenzt es automatisch.
!
! Worte wie 'davon' 'darauf' etc. werden auf dem LanguageToInformese Level
! gehandhabt, wie auch das Auftrennen verschmolzener Praepositionen (ins, vom).
! Diese Worte koennen also nicht als Token eingesetzt werden!
! ------------------------------------------------------------------------------

! ------------------------------------------------------------------------------
! *** FEHLER beim Verwenden von MULTI#? Token
!
! Beim Definieren von Grammatikzeilen mit multi#? Tokens ist darauf zu achten,
! dass der Parser NACH diesen ein Objekt erwartet, welches zudem durch eine
! Praeposition eindeutig identifiziert ist. Aus diesem Grunde koennen Konstrukte
! wie:
!
! 	Verb 'nimm' 'entnimm'
!         * 'aus' noun multiinside
!	  * multiinside noun
!
!	>nimm aus dem Fass alles
!	>entnimm alles dem fass
!
! nicht verwandt werden.
!
! Weiterhin darf vor dem multi#? Token keine Routine gesetzt werden, wie etwa
! das optionale 'dir', da der Parser dann die Zeile nicht mehr erkennt.
! ------------------------------------------------------------------------------

Verb 'nimm' 'hol'
	* multi						-> Take
	* multi 'auf'/'mit'				-> Take
	* 'auf'/'mit' multi				-> Take
	* worn 'ab'					-> Disrobe
	* 'ab' worn					-> Disrobe
	* multiinside 'von'/'aus' noun heraus		-> Remove
	* multiinside xheraus				-> Remove
	* 'platz' 'auf'/'in' noun			-> Enter
	* 'auf'/'in' noun 'platz'			-> Enter;
Verb 'greif' 'fass' 'ergreif'
	* multi						-> Take
	* multiinside 'in' noun				-> Remove
	* multiinside 'auf' noun			-> Remove
	* 'nach' multi					-> Take
	* 'nach' multiinside 'in' noun			-> Remove
	* 'nach' multiinside 'auf' noun			-> Remove
	* 'an' noun					-> Touch
	* noun 'an'					-> Touch
	* 'dir' 'an' 'den'/'die' 'kopf'/'stirn'		-> Mild;
Verb 'pack'
	* multi						-> Take
	* multi 'ein'					-> Take
	* 'ein' multi					-> Take
	* creature					-> Attack
	* multiexcept 'auf' noun			-> PutOn
	* multiexcept 'in' noun hinein			-> Insert
	* multiexcept xhinein				-> Insert
	* 'dich'					-> VagueGo
	* 'dich' 'auf' noun				-> Enter;
Verb 'heb'
	* multi 'auf'					-> Take
	* 'auf' multi					-> Take
	* noun 'an'/'hoch'				-> Lift
	* 'an'/'hoch' noun				-> Lift
	* 'dich' 'auf'					-> Exit
	* 'dich' 'auf' 'aus'/'von' noun			-> GetOff
	* 'dich' 'aus'/'von' noun			-> GetOff
	* 'dich' xhinweg				-> VagueGo;
Verb 'pflueck' 'rupf' 'reiss'
	* creature					-> Attack
	* multi						-> Take
	* multi 'ab'/'aus'				-> Take
	* multiinside 'in' noun				-> Remove
	* multiinside 'auf' noun			-> Remove
	* multiinside 'von' noun			-> Remove
	* multiinside 'in' noun 'ab'/'aus'		-> Remove
	* multiinside 'auf' noun 'ab'/'aus'		-> Remove
	* multiinside 'von' noun 'ab'/'aus'		-> Remove;
Verb 'trag'
	* held						-> Wear;
Verb 'zieh' 'streif'
	* clothing 'aus'/'ab'				-> Disrobe
	* 'aus'/'ab' clothing				-> Disrobe
	* noun 'an'/'auf'/'ueber'/'um'			-> Wear
	* noun 'zu'					-> Close
	* 'zu' noun					-> Close
	* 'an' noun					-> Pull
	* noun direction				-> PushDir
	* multiinside 'aus' noun			-> Remove
	* multiinside 'von' noun			-> Remove
	* 'von' 'dannen'				-> VagueGo
	* direction					-> Go
	* noun 'ob'/'ueber' topic 'zu' 'rate'		-> Consult
	* 'ob'/'ueber' topic noun 'zu' 'rate'		-> Consult
	* 'zu' 'rate' noun 'ob'/'ueber' topic		-> Consult;
Verb 'kleid' 'bekleid' 'schmueck'
	* 'dich' 'an' 'mit' noun			-> Wear
	* 'dich' 'mit' noun 'an'			-> Wear
	* 'dich' 'mit'/'in' noun			-> Wear;
Verb 'steh'
	* 'auf'						-> Exit
	* 'auf' 'von'/'aus' noun			-> GetOff
	* 'auf' noun					-> Enter;	! Schweizer
Verb 'leg' 'plazier' 'platzier'
	* multiexcept 'in' noun				-> Insert
	* multiexcept 'in' noun hinein			-> Insert
	* multiexcept xhinein				-> Insert
	* multiexcept 'auf' noun			-> PutOn
	* worn 'ab'					-> Disrobe
	* 'ab' worn					-> Disrobe
	* multiheld xhinweg				-> Drop
	* multiheld 'ab'				-> Drop
	* xhinweg multiheld				-> Drop
	* 'ab' multiheld				-> Drop
	* 'auf' creature 'an'				-> Attack
	* 'auf' creature 'mit' held 'an'		-> Attack
	* 'mit' held 'auf' creature 'an'		-> Attack
	* noun 'an'/'um'/'auf'/'ueber'			-> Wear
	* 'an'/'auf'/'um'/'ueber' noun			-> Wear
	* 'dich' 'auf'/'in' noun			-> Enter
	* 'dich' 'auf'/'in' noun 'nieder'		-> Enter;
Verb 'steck'
	* multiexcept 'in' noun hinein			-> Insert
	* multiexcept xhinein				-> Insert
	* multiexcept 'auf' noun			-> PutOn
	* clothing 'an'					-> Wear
	* 'an' clothing					-> Wear
	* 'an' noun					-> Burn
	* noun 'an'					-> Burn
	* noun 'mit' held 'an'				-> Burn
	* 'mit' held noun 'an'				-> Burn;
Verb 'leer' 'entleer' 'schuett' 'giess'
	* noun						-> Empty
	* 'aus' noun					-> Empty
	* noun 'aus'					-> Empty
	* noun 'in'/'auf' noun				-> EmptyT;
Verb 'gib' 'reich' 'uebertrag' 'ueberreich' 'uebergib'
	* held 'an' creature				-> Give
	* 'an' creature held				-> Give reverse
	* held creature					-> Give
	* creature held					-> Give reverse
	* multiheld 'her'				-> Drop
	* 'her' multiheld				-> Drop;
Verb 'fuetter' 'bezahl'
        * creature 'mit' held	      			-> Give reverse
	* 'mit' held creature				-> Give
	* held 'an' creature				-> Give
	* 'an' creature held				-> Give reverse;
Verb 'biet'
     	* creature held 'an'				-> Give reverse
	* held creature 'an'				-> Give
	* 'fuer' noun					-> Buy;
Verb 'trenn' 'loese' 'spalte' 'zertrenn'
	* 'dich' 'von' multiheld			-> Drop
	* noun 'ab'/'von' noun				-> Cut
	* noun 'von' noun 'ab'				-> Cut
	* 'von' noun noun 'ab'				-> Cut
	* 'ab' noun 'von' noun				-> Cut
	* noun 'auf'					-> Cut
	* noun 'und' noun				-> Cut
	* noun						-> Attack;
Verb 'wirf' 'schmeiss' 'schleuder'
        * multiheld    					-> Drop
	* multiheld xhinweg				-> Drop
	* xhinweg multiheld				-> Drop
	* multiheld 'ab'				-> Drop
	* 'ab' multiheld				-> Drop
	* held 'nach'/'gegen'/'auf'/'zu' noun		-> ThrowAt
	* 'nach'/'gegen'/'auf'/'zu' noun held		-> ThrowAt reverse
	* multiexcept 'in' noun	hinein			-> Insert
	* multiexcept 'auf' noun			-> PutOn
	* 'dich' 'auf' creature				-> Attack
	* 'dich' 'gegen' noun				-> Attack
	* creature 'nieder'				-> Attack
	* 'nieder' creature				-> Attack
	* 'dich' 'auf'/'in' noun			-> Enter;
Verb 'zeig' 'praesentier' 'fuehr'
	* creature held					-> Show reverse
	* held creature 				-> Show
	* creature held 'vor'				-> Show reverse
	* held creature 'vor'				-> Show;
Verb 'geh' 'lauf' 'renn' 'wander' 'fluechte' 'flieh' 'schreite'
	*						-> VagueGo
	* 'umher'/'weg'/'fort'				-> VagueGo
	* 'hinein'/'rein'				-> GoIn
	* 'hinaus'/'raus'				-> Exit
	* direction					-> Go
	* 'in'/'auf'/'durch' noun			-> Enter;
Verb 'sitz' 'lieg'
	* 'auf'/'in' enterable				-> Enter
	* 'auf'/'in' noun				-> Enter;
Verb 'setz'
	* 'dich' 'auf'/'in' noun			-> Enter
	* clothing 'auf'				-> Wear
	* 'auf' clothing				-> Wear
	* worn 'ab'					-> Disrobe
	* 'ab' worn					-> Disrobe
	* multiexcept 'auf' noun			-> PutOn
	* multiexcept 'in' noun	hinein			-> Insert
	* multiexcept xhinein				-> Insert
	* noun 'in' 'brand'/'flammen'			-> Burn
	* noun 'mit' held 'in' 'brand'/'flammen'	-> Burn
	* 'mit' held noun 'in' 'brand'/'flammen'	-> Burn
	* 'ueber' noun					-> JumpOver;
Verb 'tritt'
	* 'hinein'/'ein'/'rein'				-> GoIn
	* 'heraus'/'hinaus'/'raus'			-> Exit
	* 'in'/'auf' noun				-> Enter
	* 'aus' noun					-> GetOff
	* 'an'/'gegen' noun				-> Attack
	* noun						-> Attack
	* noun 'platt'					-> Squeeze;
Verb 'betritt'
	* noun						-> Enter;
Verb 'verlass'
	* creature					-> VagueGo
	* noun						-> GetOff
	* 'diesen' 'ort'/'raum'/'platz'			-> VagueGo;
Verb 'sieh' 'schau' 'blick' 'l//' 'sc'
	*						-> Look
	* 'dich' 'um'					-> Look
	* 'herum'/'umher'				-> Look
	* 'an'/'nach' noun				-> Examine
	* noun 'an'					-> Examine
	* noun 'durch'					-> Read
	* 'in'/'auf'/'durch'/'neben' noun		-> Search
	* 'in'/'auf'/'neben' noun'nach'		-> Search
	* xhinein					-> Search
	* 'nach' topic 'in' noun			-> Consult
	* 'in' noun 'ob'/'ueber' topic 'nach'		-> Consult
	* 'ueber'/'ob' topic 'in' noun 'nach'		-> Consult
	* 'unter'/'hinter' noun				-> LookUnder
	* 'unter'/'hinter' noun 'nach'			-> LookUnder;
Verb 'forsch' 'lern'
	* 'nach'/'ob'/'ueber'/'von' topic 'in'/'aus' noun	-> Consult
	* 'in'/'aus' noun 'nach'/'ob'/'ueber'/'von' topic	-> Consult;
Verb 'lies' 'konsultier'
	* noun						-> Read
	* multi 'auf'					-> Take
	* 'auf' multi					-> Take
	* 'ueber'/'ob'/'von' topic 'in' noun		-> Consult
	* 'nach' 'ueber'/'ob' topic 'in' noun		-> Consult
	* 'von' topic 'in' noun				-> Consult
	* 'in' noun 'ueber'/'ob' topic 'nach'		-> Consult
	* 'in' noun 'ueber'/'ob'/'von' topic		-> Consult;
Verb 'befrag' 'frag'
	* creature					-> Ask
	* creature 'nach'/'ueber'/'ob' noun		-> AskFor
	* creature 'nach'/'ueber'/'ob' topic		-> Ask
	
	* noun						-> Read
	* noun						-> AskFor
	* creature 'nach'/'ueber'/'ob' topic		-> Ask
	* 'nach'/'ob' topic creature			-> Ask
	* noun 'ueber'/'ob'/'nach' topic		-> Consult;
Verb 'such' 'spuere' 'stoeber' 'wuehl'
	* 'in'/'auf'/'ab'/'hinter'/'neben' noun		-> Search
	* noun 'ab'					-> Search
	* 'unter' noun					-> LookUnder
	* 'in' noun 'nach' topic			-> Consult
	* 'nach' topic 'in' noun			-> Consult;
Verb 'durchsuch' 'durchwuehl' 'durchstoeber'
	* noun						-> Search;
Verb 'schlag' 'hau'
	* creature					-> Attack
	* noun						-> Attack
	* creature 'an' 'das' 'kreuz'			-> Attack
	* 'nach' 'in' noun 'ueber'/'ob' topic		-> Consult
	* 'in' noun 'ueber'/'ob' topic 'nach'		-> Consult
	* 'auf' noun					-> Open
	* noun 'auf'					-> Open
	* noun 'in'/'gegen' noun			-> Ram
!	* noun 'in'/'gegen' noun 'ein'			-> Ram
!	* 'in' noun noun 'ein'				-> Ram
	* noun 'zu'					-> Close
	* 'zu' noun					-> Close
	* noun 'um'/'ab'/'entzwei'/'kaputt'		-> Attack
	* 'um'/'ab'/'entzwei'/'kaputt' noun		-> Attack
	* 'mit' 'der' 'Faust' 'auf' noun		-> Mild;
Verb 'brich'
	* noun 'auf'/'entzwei'/'ab'			-> Attack
	* 'auf'						-> VagueGo;
Verb 'treib'
	* creature xhinweg				-> Attack
	* noun direction				-> PushDir
	* noun 'in' noun				-> Ram;
Verb 'oeffne' 'entriegel' 'entfalte'
	* noun						-> Open
	* noun 'mit' held				-> Unlock
	* 'mit' held noun				-> Unlock;
Verb 'schliess' 'sperr' 'schliesse'
	* noun						-> Close
	* noun 'mit' held 'ab'				-> Lock
	* 'mit' held noun 'ab'				-> Lock
	* 'ab' noun 'mit' held				-> Lock
	* noun 'ab' 'mit' held				-> Lock
	* noun 'auf' 'mit' held				-> Unlock
	* noun 'mit' held 'auf'				-> Unlock
	* 'mit' held noun 'auf'				-> Unlock
	* 'auf' noun 'mit' held				-> Unlock;
Verb 'verriegel' 'verriegle' 'verschliess'
	* noun						-> Close
	* noun 'mit' held				-> Lock
	* 'mit' held noun				-> Lock;
Verb 'hinein' 'rein'
	*						-> GoIn
	* 'in' noun					-> Enter;
Verb 'hinaus' 'raus'
	*						-> Exit
	* 'aus' noun					-> GetOff;
Verb 'untersuch' 'betrachte' 'begutachte' 'beschreib' 'x//'
	* noun						-> Examine;
Verb 'ja'
	*						-> Yes;
Verb 'nein'
	*						-> No;
Verb 'wink' 'schwenk' 'wedel' 'wedle'
	*						-> WaveHands
	* 'mit' 'der'/'den' 'hand'/'haenden'		-> WaveHands
	* noun						-> Wave
	* 'mit' noun					-> Wave;
Verb 'zerbrich' 'vernichte' 'zerstoer' 'zerschlag' 'zertruemmer'
	* noun						-> Attack;
Verb 'toete' 'ermorde' 'morde' 'folter' 'bekaempf' 'quael' 'kreuzig' 'pruegel'
	* creature					-> Attack
	* creature 'mit' held				-> Attack;
Verb 'wart' 'harre' 'verharre' 'z//'
	*						-> Wait
	* 'eine' 'weile'/'zeitlang'			-> Wait
	* 'einige' 'zeit'				-> Wait
	* 'aus'						-> Wait;
Verb 'sprich' 'sag' 'schwatz' 'schwaetz' 'red' 'babbel'
	* 'mit' creature 'ueber'/'ob' topic		-> Answer reverse
	* 'ueber'/'ob' topic 'mit' creature		-> Answer
	* topic 'zu' creature				-> Answer
	* creature topic				-> Answer reverse
	* 'ein'/'das' 'gebet'/'vaterunser'		-> Pray;
Verb 'erzaehl' 'unterrichte' 'berichte' 'erklaere'
	* creature 'von'/'ueber' topic			-> Tell
	* 'von'/'ueber' topic creature			-> Tell;
Verb 'dreh' 'schraub'
	* noun						-> Turn
	* noun 'auf'					-> Open
	* 'auf' noun					-> Open
	* noun 'zu'					-> Close
	* 'zu' noun					-> Close
	* multiinside 'aus' noun heraus			-> Remove
	* multiinside 'von' noun 'ab'			-> Remove
	* multiexcept 'in' noun				-> Insert
	* multiexcept 'auf' noun			-> PutOn;
Verb 'schalt'
	* noun 'an'/'ein'				-> SwitchOn
	* 'ein'/'an' noun				-> SwitchOn
	* noun 'aus'/'ab'				-> SwitchOff
	* 'aus'/'ab' noun				-> SwitchOff;
Verb 'drueck' 'press' 'schieb' 'beweg' 'verschieb'
	* noun						-> Push
	* 'gegen' noun					-> Push
	* noun direction				-> PushDir
	* noun 'auf'					-> Open
	* 'auf' noun					-> Open
	* noun 'zu'					-> Close
	* 'zu' noun					-> Close
	* multiexcept 'in' noun				-> Insert
	* multiexcept 'auf' noun			-> PutOn
	* noun 'zusammen'/'aus'				-> Squeeze
	* 'aus'/'zusammen' noun				-> Squeeze
	* noun 'hoch'/'hinauf'				-> Lift
	* noun 'nach' 'oben'				-> Lift;
Verb 'zerdrueck' 'quetsch' 'zerquetsch'
	* noun						-> Squeeze;
Verb 'reinige' 'putz' 'reib' 'schrubb' 'saeuber' 'polier' 'glaette' 'schmirgel'
	* noun						-> Rub;
Verb 'iss' 'friss' 'verspeis'
	* held						-> Eat;
Verb 'trink' 'schluck' 'verzehr' 'saug'
	* edible					-> Eat
	* noun						-> Drink
	* noun 'auf'/'ein'/'runter'/'hinunter'		-> Drink;
Verb 'schlaf' 'schlummer' 'does'
	*						-> Sleep;
Verb 'sing' 'traeller' 'pfeif'
	*						-> Sing;
Verb 'schmeck' 'koste' 'leck' 'probiere'
	* noun						-> Taste
	* 'an'/'von' noun				-> Taste;
Verb 'horch' 'lausch' 'hoer'
	*						-> Listen
	* noun						-> Listen
	* 'nach'/'an'/'auf' noun			-> Listen
	* noun 'an'/'zu'				-> Listen;
Verb 'riech' 'schnueffel' 'schnueffle' 'schnupper' 'witter'
	*						-> Smell
	* 'an' noun					-> Smell
	* noun						-> Smell;
Verb 'streichel' 'streichle' 'kuess' 'knutsch' 'umarm' 'umgarn' 'liebkos'
	* creature					-> Kiss
	* noun						-> Touch;
Verb 'beruehr' 'befuehl' 'betaste'
	* noun						-> Touch;
Verb 'taste' 'fuehl'
	* noun 'an'					-> Touch
	* 'an'/'ueber'/'nach' noun			-> Touch;
Verb 'grab'
	*						-> Dig
	* noun 'um'					-> Dig
	* noun 'mit' held 'um'				-> Dig
	* 'um' noun 'mit' held				-> Dig
	* 'mit' held noun 'um'				-> Dig
	* 'in' noun					-> Dig
	* 'in' noun 'mit' held				-> Dig
	* 'mit' held 'in' noun				-> Dig;
Verb 'stell'
!	* noun 'ein'					-> Set
	* noun 'auf' special				-> Set
!	* noun 'auf' special 'ein'			-> Set
	* 'dich' 'auf'/'in' noun			-> Enter
	* multiexcept 'auf' noun			-> PutOn
	* multiexcept 'in' noun				-> Insert
	* multiheld xhinweg				-> Drop
	* multiheld 'ab'				-> Drop
	* xhinweg multiheld				-> Drop
	* 'ab' multiheld				-> Drop;
Verb 'zuend' 'brenn'
	* noun 'an'/'nieder'				-> Burn
	* 'an'/'nieder' noun				-> Burn
	* noun 'mit' held 'an'/'nieder'			-> Burn
	* 'mit' held noun 'an'/'nieder'			-> Burn reverse
	* 'an'/'nieder' noun 'mit' held			-> burn
	* 'mit' held 'noun' 'an'/'nieder'		-> Burn reverse;
Verb 'entzuend' 'entflamm' 'verbrenn'
	* noun 						-> Burn
	* noun 'mit' held				-> Burn
	* 'mit' held noun				-> Burn reverse;
Verb 'kletter' 'steig'
	* 'auf'/'in' enterable				-> Enter
	* 'von'/'aus' noun				-> GetOff	! *BUG*
	* 'von' noun 'ab'/'runter'				-> GetOff	! HINAUS
	* 'runter'/'hinunter'/'herab'/'ab' 'von' noun	-> GetOff	! Verb entferne
	* 'runter'/'hinunter'/'herab'/'ab'		-> Exit
	* noun 'hoch'					-> Climb	! *******
	* 'auf'/'ueber'/'in' noun			-> Climb;
Verb 'erkletter' 'erklimm' 'ersteig'
	* noun						-> Climb;
Verb 'kauf' 'erwirb'
	* noun						-> Buy
	* noun 'von' creature				-> Buy;
Verb 'schwimm' 'tauch' 'plansch'
	*						-> Swim
	* 'in' noun					-> Swim;
Verb 'schwing' 'baumle''baumel'
	* 'an'/'mit' noun				-> Swing
	* 'dich' 'auf'/'in' noun			-> Enter
	* creature					-> Attack;	! Schweiz
Verb 'blas' 'puste'
	* held						-> Blow
	* 'in' held					-> Blow
	* 'in'/'auf' noun				-> Blow
	* held 'auf'					-> Blow
	* multiinside 'von' noun			-> Remove
	* multiinside 'aus' noun			-> Remove;
Verb 'bet'
	*						-> Pray
	* 'ein'/'das' 'vaterunser'			-> Pray
	* 'ein'/'das' 'ave' 'maria'			-> Pray;
Verb 'weck' 'erweck'
	* creature					-> WakeOther
	* creature 'auf'				-> WakeOther
	* 'auf' creature				-> WakeOther;
Verb 'wach' 'erwach'
	*						-> Wake
	* 'auf'						-> WakeOther;
Verb 'denk'
	*						-> Think
	* 'nach'					-> Think;
Verb 'bind' 'knote' 'hefte' 'verknote'
	* noun 'zu'					-> Tie
	* noun 'an'/'mit'/'und' noun			-> Tie
	* noun 'mit'/'und' noun 'zusammen'		-> Tie
	* 'zusammen' noun 'mit'/'und' noun		-> Tie;
Verb 'fuell'
	* noun						-> Fill
	* noun 'auf'					-> Fill
	* noun 'mit' noun 'auf'				-> Fill
	* 'auf' noun 'mit' noun				-> Fill reverse
	* noun 'mit' noun				-> Fill
	* 'mit' noun noun				-> Fill reverse;
Verb 'schneid' 'teil' 'schnippel' 'schnipple' 'zerteil' 'zerschneid' 'zerschnipp'
	* noun						-> Cut
	* noun 'entzwei'/'kaputt'/'klein'		-> Cut
	* 'entzwei'/'kaputt'/'klein' noun		-> Cut;
Verb 'spring' 'huepf'
	*						-> Jump
	* 'hoch'/'herum'/'umher'			-> Jump
	* 'ueber'/'durch' noun				-> JumpOver
	* 'in'/'auf' noun				-> Enter
	* 'aus'/'von' noun				-> GetOff
	* 'runter'/'hinunter'/'hinab' 'von' noun	-> GetOff
	* 'runter'/'hinunter'/'hinab'			-> Exit
	* direction					-> Go		! Schweiz
	* creature 'an'					-> Attack
	* 'an' creature					-> Attack;
Verb 'inventar' 'inv' 'i//' 'besitz' 'b//' 'eigentum' 'zeug'
	*						-> Inv
	* 'breit'/'lang'/'episch'			-> InvWide
	* 'schmal'/'kurz'				-> InvTall;
Verb 'scheiss' 'kack' 'arsch' 'arschloch' 'wichser' 'wixer' 'piss' 'verpiss'
	*						-> Strong
	* topic						-> Strong;
Verb 'tadel' 'verfluch' 'verdamm' 'verdammt' 'mist' 'jammer' 'winsel' 'schmipf'
		'wuete' 'zuerne' 'schiet' 'hader' 'scheibenkl' 'fluch'
	*						-> Mild
	* topic						-> Mild;
Verb 'entschuldig' 'verzeih' 'sorry' 'pardon'
	*						-> Sorry
	* 'mir'						-> Sorry
	* 'mir' 'bitte'					-> Sorry
	* 'bitte'					-> Sorry;

! ------------------------------------------------------------------------------
! Changes from the standard verb definitions
! ------------------------------------------------------------------------------

#ifndef VERB_WENIGE;

Verb 'erheb'
	* 'dich'					-> Exit
	* 'dich' 'von'/'aus' noun			-> GetOff;
Verb 'sammel' 'sammle'
	* multi 'ein'/'auf'				-> Take
	* 'auf'/'ein' multi				-> Take;
Verb 'begib'
	* 'dich' 'zu'/'in'/'auf' noun			-> Enter
	* 'dich' direction				-> Go;
Verb 'lass'
	* multiheld 'fallen'				-> Drop
	* 'fallen' multiheld				-> Drop
	* creature 'alleine'/'zurueck'			-> VagueGo
	* 'dich' 'auf'/'in' noun 'nieder'		-> Enter;
Verb 'halte'
	* 'ausschau'					-> Look
	* 'auf' creature 'an'				-> Attack
	* 'an' 'auf' creature				-> Attack
	* 'mit' held 'auf' creature 'an'		-> Attack
	* 'auf' creature 'mit' held 'an'		-> Attack
	* creature 'fest'				-> Attack
	* 'durch'/'aus'					-> Mild;
Verb 'scheuch' 'verscheuch' 'verjag' 'jag'
	* creature					-> Attack
	* creature 'auf'				-> Attack;
Verb 'entziffer'
	* noun						-> Read;
Verb 'haeng'
	* 'dich' 'an' noun				-> Swing;
Verb 'verlier'
	* multiheld					-> Drop;

#endif;

#ifdef VERB_MACHE;

Verb 'mache'
	* noun 'auf'					-> Open
	* 'auf' noun					-> Open
	* noun 'zu'					-> Close
	* 'zu' noun					-> Close
	* creature 'an'					-> Kiss
	* creature 'schoene' 'Augen'			-> Kiss
	* noun 'an'					-> SwitchOn
	* noun 'aus'					-> SwitchOff
	* creature 'kaputt'/'klein'/'nieder'		-> Attack
	* noun 'kaputt'					-> Attack
	* noun 'klein'					-> Cut
	* 'dich' xhinweg				-> VagueGo
	* 'auf'/'in' noun				-> Strong;

#endif;

#ifdef VERB_UGS;

Verb 'nehm' = 'nimm';
Verb 'geb' = 'gib';
Verb 'begeb' = 'begib';
Verb 'ess' 'fress' = 'iss';
Verb 'trete' = 'tritt';
Verb 'betrete' = 'betritt';
Verb 'les' = 'lies';
Verb 'sprech' = 'sprich';
Verb 'brech' = 'brich';
Verb 'zerbrech' = 'zerbrich';
Verb 'erwerb' = 'erwirb';

#endif;

! ------------------------------------------------------------------------------
!  Final task: provide trivial routines if the user hasn't already:
! ------------------------------------------------------------------------------

#Stub TimePasses      0;
#Stub Amusing         0;
#Stub DeathMessage    0;
#Stub DarkToDark      0;
#Stub NewRoom         0;
#Stub LookRoutine     0;
#Stub AfterLife       0;
#Stub GamePreRoutine  0;
#Stub GamePostRoutine 0;
#Stub AfterPrompt     0;
#Stub BeforeParsing   0;
#Stub PrintTaskName   1;
#Stub InScope         1;
#Stub UnknownVerb     1;
#Stub PrintVerb       1;
#Stub ParserError     1;
#Stub ParseNumber     2;
#Stub ChooseObjects   2;

#ifndef PrintRank;
  Constant Make__PR;
#endif;
#ifdef Make__PR;
  [ PrintRank; "."; ];
#endif;
#ifndef ParseNoun;
  Constant Make__PN;
#endif;
#ifdef Make__PN;
  [ ParseNoun obj; obj=obj; return -1; ];
#endif;

#Default Story 0;
#Default Headline 0;

