/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.encoding;

import org.zmpp.encoding.AccentTable;

public class ZsciiEncoding {
    public static final short NULL = 0;
    public static final short DELETE = 8;
    public static final short NEWLINE_10 = 10;
    public static final short NEWLINE = 13;
    public static final short ESCAPE = 27;
    public static final short CURSOR_UP = 129;
    public static final short CURSOR_DOWN = 130;
    public static final short CURSOR_LEFT = 131;
    public static final short CURSOR_RIGHT = 132;
    public static final short ASCII_START = 32;
    public static final short ASCII_END = 126;
    public static final short ACCENT_START = 155;
    public static final short ACCENT_END = 251;
    public static final short MOUSE_DOUBLE_CLICK = 253;
    public static final short MOUSE_SINGLE_CLICK = 254;
    private AccentTable accentTable;

    public ZsciiEncoding(AccentTable accentTable) {
        this.accentTable = accentTable;
    }

    public boolean isZsciiCharacter(short s) {
        switch (s) {
            case 0: 
            case 8: 
            case 13: 
            case 27: {
                return true;
            }
        }
        return ZsciiEncoding.isAscii(s) || ZsciiEncoding.isAccent(s) || ZsciiEncoding.isUnicodeCharacter(s);
    }

    public boolean isConvertableToZscii(char c) {
        return ZsciiEncoding.isAscii((short)c) || this.isInTranslationTable(c) || c == '\n' || c == '\u0000' || ZsciiEncoding.isUnicodeCharacter((short)c);
    }

    public char getUnicodeChar(short s) {
        int n;
        if (ZsciiEncoding.isAscii(s)) {
            return (char)s;
        }
        if (ZsciiEncoding.isAccent(s) && (n = s - 155) < this.accentTable.getLength()) {
            return (char)this.accentTable.getAccent(n);
        }
        if (s == 0) {
            return '\u0000';
        }
        if (s == 13 || s == 10) {
            return '\n';
        }
        if (ZsciiEncoding.isUnicodeCharacter(s)) {
            return (char)s;
        }
        return '?';
    }

    public short[] convertToZscii(String string) {
        short[] sArray = new short[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            sArray[i] = this.getZsciiChar(string.charAt(i));
        }
        return sArray;
    }

    public short getZsciiChar(char c) {
        if (ZsciiEncoding.isAscii((short)c)) {
            return (short)c;
        }
        if (this.isInTranslationTable(c)) {
            return (short)(this.getIndexInTranslationTable(c) + 155);
        }
        if (c == '\n') {
            return 13;
        }
        return 0;
    }

    private boolean isInTranslationTable(char c) {
        for (int i = 0; i < this.accentTable.getLength(); ++i) {
            if (this.accentTable.getAccent(i) != c) continue;
            return true;
        }
        return false;
    }

    private int getIndexInTranslationTable(char c) {
        for (int i = 0; i < this.accentTable.getLength(); ++i) {
            if (this.accentTable.getAccent(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAscii(short s) {
        return s >= 32 && s <= 126;
    }

    public static boolean isAccent(short s) {
        return s >= 155 && s <= 251;
    }

    public static boolean isCursorKey(short s) {
        return s >= 129 && s <= 132;
    }

    private static boolean isUnicodeCharacter(short s) {
        return s >= 256;
    }

    public static boolean isFunctionKey(short s) {
        return s >= 129 && s <= 154 || s >= 252 && s <= 254;
    }

    public short toLower(short s) {
        if (ZsciiEncoding.isAscii(s)) {
            return (short)Character.toLowerCase(s);
        }
        if (ZsciiEncoding.isAccent(s)) {
            return (short)(this.accentTable.getIndexOfLowerCase(s - 155) + 155);
        }
        return s;
    }
}

