// Generated by CoffeeScript 1.7.1
var Aleph, Building, CrystalSkull, Diamond, Room, Thing, Window, Writing, active, flesh, glass, glowing, ink, landmarks, materialName, objects, orangeBoxes, relation, stone, vegetable, water, wood,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

relation = {
  "in": {
    text: "containing",
    preposition: "in"
  },
  on: {
    text: "with",
    preposition: "on"
  },
  under: {
    text: "underneath which is",
    preposition: "under"
  },
  behind: {
    text: "behind which is",
    preposition: "behind"
  },
  beside: {
    text: "beside which is",
    preposition: "beside"
  },
  buried: {
    text: "buried underneath which is"
  },
  hanging: {
    text: "festooned with",
    preposition: "hanging on"
  },
  base: {
    text: "at the base of which is",
    preposition: "at the base of"
  },
  stuck: {
    text: "stuck with",
    preposition: "stuck on"
  },
  scratched: {
    text: "on which is scratched"
  },
  written: {
    text: "on which is"
  },
  toeast: {
    text: "on the east side of which is",
    peer: "To the east"
  },
  painted: {
    text: "of"
  },
  stained: {
    text: "stained with"
  },
  overgrown: {
    text: "overgrown with"
  },
  fallen: {
    text: "fallen on which is",
    peer: "Fallen before you"
  },
  clinging: {
    text: "clung to by"
  },
  decorated: {
    text: "decorated by"
  },
  of: {
    text: "of"
  },
  holding: {
    text: "holding"
  },
  wearing: {
    text: "wearing"
  }
};

flesh = {
  hardness: 3,
  flexibilty: 8,
  weight: 5
};

orangeBoxes = {
  hardness: 5,
  flexibilty: 5,
  weight: 5
};

glass = {
  hardness: 5,
  flexibilty: 0,
  weight: 3,
  transparent: true
};

wood = {
  hardness: 5,
  flexibility: 3,
  weight: 3
};

ink = {
  hardness: 0,
  flexibility: 9,
  weight: 5
};

glowing = {
  hardness: 0,
  flexibility: 9,
  weight: 5
};

stone = {
  hardness: 8,
  flexibility: 0,
  weight: 8
};

vegetable = {
  hardness: 2,
  flexibity: 8,
  weight: 5
};

water = {
  hardness: 0,
  flexibility: 9,
  weight: 5,
  liquid: true
};

materialName = function(material) {
  var v;
  for (v in window) {
    if (window[v] === material) {
      return v;
    }
  }
};

objects = [];

active = [];

landmarks = [];

Thing = (function() {
  function Thing(list) {
    var prop, thing, _i, _len, _ref;
    for (prop in list) {
      if (!__hasProp.call(list, prop)) continue;
      this[prop] = list[prop];
    }
    try {
      this.synonyms = this.synonyms.concat(this.name.toLowerCase().split(' '));
    } catch (_error) {
      debugger;
    }
    this.synonyms.push(pluralise(this.name));
    if (this.contents) {
      _ref = this.contents;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        thing = _ref[_i];
        thing.inside = this;
      }
    }
    objects.push(this);
    if (this.act) {
      active.push(this);
    }
    if ((typeof this !== "undefined" && this !== null ? this.size : void 0) > 100) {
      landmarks.push(this);
    }
  }

  Thing.prototype.name = "nameless thing";

  Thing.prototype.synonyms = [];

  Thing.prototype.relation = relation["in"];

  Thing.prototype.material = orangeBoxes;

  Thing.prototype.size = 5;

  Thing.prototype.quantity = 1;

  Thing.prototype.examine = function() {
    var thing, _i, _len, _ref, _results;
    if (this.description) {
      Say(this.description);
    } else {
      Say("The " + this.name + " defies description.");
    }
    if (this.contents) {
      _ref = this.contents;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        thing = _ref[_i];
        _results.push(thing.examine());
      }
      return _results;
    }
  };

  Thing.prototype.fancyName = function() {
    return Say(this.name);
  };

  Thing.prototype.get = function(thing) {
    var container;
    container = thing;
    while (container && container.inside !== this.inside) {
      if (container.relation === relation.painted) {
        Say("" + (capitalize(knowIntimately(this))) + " paw" + (s(this)) + " at the image of " + (knowIntimately(thing)) + ".");
        return;
      }
      container = container.inside;
    }
    if (thing.size * thing.material.weight > this.strength * 5) {
      Say("" + (capitalize(knowIntimately(this))) + " cannot lift " + (knowIntimately(thing)) + ".");
      return;
    }
    if (thing.quantity > 1) {
      thing.quantity--;
      thing = duplicate(thing);
      thing.quantity = 1;
      Say("" + (capitalize(knowIntimately(this))) + " take" + (s(this)) + " one of " + (pluralise(knowIntimately(thing))) + " from " + (knowIntimately(thing.inside)) + ".");
    } else {
      Say("" + (capitalize(knowIntimately(this))) + " pick" + (s(this)) + " up " + (knowIntimately(thing)) + " from " + (knowIntimately(thing.inside)) + ".");
    }
    if (thing.gotby) {
      thing.gotby(this);
    }
    get(this, thing);
    return thing;
  };

  Thing.prototype.move = function(direction) {
    var dx, dy, dz, from, goal, location, to, _ref;
    from = this.inside;
    if (from.outdoors) {
      dx = deltas[direction][0];
      dy = deltas[direction][1];
      dz = 0;
      location = position(this);
      to = location.map.get(location.x + dx, location.y + dy, location.z + dz);
    } else {
      to = (_ref = this.inside.exits) != null ? _ref[direction] : void 0;
    }
    if (to) {
      if (this === player && this.inside.travel) {
        Say("" + (capitalize(knowIntimately(this))) + " travel" + (s(this)) + " " + this.inside.travel[direction] + ".");
      } else {
        if (player.inside === from) {
          if (!to.known) {
            goal = "to the " + directions_long[direction];
          } else {
            goal = "for " + (know(to));
          }
          if (!to.known && this === player) {
            Say("" + (capitalize(goal)) + " you discover--");
          } else {
            Say("" + (capitalize(knowIntimately(this))) + " leave" + (s(this)) + " " + goal + ".");
          }
        }
        if (player.inside === to) {
          if (!from.known) {
            goal = "from the " + directions_long[direction];
          } else {
            goal = "from " + (know(from));
          }
          Say("" + (capitalize(know(this))) + " arrive" + (s(this)) + " " + goal + ".");
        }
      }
      get(to, this);
      if (this === player) {
        return look(player.inside);
      }
    } else {
      if (player.inside === from) {
        return Say("" + (capitalize(knowIntimately(this))) + " cannot go " + directions_long[direction] + ".");
      }
    }
  };

  Thing.prototype.attack = function(target) {
    see("#1 attack#s #2.", this, target);
    if (target.hp) {
      return target.hurt(smear(this.strength), this);
    } else if (target.material === glass) {
      see("They shatter.");
      return destroy(this);
    } else {
      return see("To no effect.");
    }
  };

  Thing.prototype.hurt = function(injury, attacker) {
    if (injury < this.hp / 2) {
      see("#1 is injured.", this);
    } else {
      see("#1 is severely injured.", this);
    }
    if (this.hp <= 0) {
      return;
    }
    this.hp -= injury;
    if (this.hp <= 0) {
      see("#1 die#s.", this);
      this.name = this.name + "'s corpse";
      this.nutrition = this.size;
      remove(active, this);
      if (attacker === player) {
        return player.curse = true;
      }
    }
  };

  Thing.prototype.lick = function(licked) {
    var flavour, output, _ref;
    output = "" + (capitalize(knowIntimately(this))) + " lick" + (s(this)) + " " + (knowIntimately(licked, true)) + ".";
    if (this === player) {
      flavour = (_ref = licked.flavour) != null ? _ref : "nothing in particular";
      output += " " + (capitalize(pronoun(licked))) + " taste like " + flavour + ".";
    }
    return Say(output);
  };

  Thing.prototype.read = function(thing) {
    if (thing.readby) {
      thing.readby(this);
      return;
    }
    if (thing.message) {
      Say("It is written in " + (materialName(thing.material)) + " " + thing.method + " in a " + thing.hand + " hand:");
      return Say(thing.message);
    } else {
      return Say("There is nothing to read on " + (know(thing)) + ".");
    }
  };

  Thing.prototype.push = function(thing) {
    if (thing.relation === relation.on) {
      Say("" + (capitalize(knowIntimately(this))) + " push" + (s(this)) + " " + (knowIntimately(thing, true)) + " off " + (knowIntimately(thing.inside)) + ".");
      get(thing.inside.inside, thing);
      return thing.relation = relation.fallen;
    } else if (thing.unsteady) {
      Say("" + (capitalize(knowIntimately(this))) + " push" + (s(this)) + " " + (knowIntimately(thing, true)) + " over.");
      return thing.relation = relation.fallen;
    } else if (thing.size * thing.material.weight <= this.strength * 5) {
      Say("" + (capitalize(knowIntimately(this))) + " push" + (s(this)) + " " + (knowIntimately(thing, true)) + " over.");
      return thing.relation = relation.fallen;
    } else {
      return Say("" + (capitalize(knowIntimately(this))) + " push" + (s(this)) + " futilely against " + (knowIntimately(thing, true)) + ".");
    }
  };

  Thing.prototype.kiss = function(thing) {
    see("#1 smooch#s #2.", this, thing);
    return thing.kissedBy(this);
  };

  Thing.prototype.kissedBy = function(thing) {
    return "";
  };

  Thing.prototype.lookedAt = function() {
    return know(this);
  };

  Thing.prototype.shout = function(subject) {
    var end, thing, words, _i, _len, _ref, _results;
    words = subject[0] != null;
    if (!words.length) {
      words = "wordlessly";
    }
    end = words[words.length - 1];
    if (end !== "!" && end !== "." && end !== "?") {
      words += ".";
    }
    hear("#1 shout#s " + words, this);
    _ref = root(this);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      thing = _ref[_i];
      if (this !== this) {
        _results.push(thing.startle());
      } else {
        _results.push(void 0);
      }
    }
    return _results;
  };

  Thing.prototype.startle = function() {
    return "";
  };

  Thing.prototype.sing = function() {
    return hear("#1 sing#s " + (oneOf(['loudly', 'tunelessly', 'darkly'])) + ".", this);
  };

  Thing.prototype.eat = function(thing) {
    if (thing.nutrition) {
      see("#1 eat#s #2.", this, thing);
      this.hunger -= thing.nutrition;
      return destroy(thing);
    } else {
      return see("#1 is not edible!", thing);
    }
  };

  Thing.prototype.shake = function(thing) {
    var c, _i, _len, _ref, _results;
    see("#1 shake#s #2.", this, thing);
    if (thing.contents) {
      _ref = thing.contents;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        c = _ref[_i];
        if (c.relation === relation["in"]) {
          hear("Something rattles.");
        }
        if (c.material.liquid) {
          see("#1 spills!");
          _results.push(destroy(c));
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    }
  };

  Thing.prototype.twist = function(thing) {
    return see("#1 twist#s #2.", this, thing);
  };

  Thing.prototype.smell = function(thing) {
    var flavour, t, _i, _len, _ref, _ref1, _results;
    see("#1 sniff#s.", this);
    _ref = root(player).contents;
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      t = _ref[_i];
      flavour = (_ref1 = t.flavour) != null ? _ref1 : "nothing in particular";
      _results.push(Say("" + (capitalize(know(t))) + " smell like " + flavour + "."));
    }
    return _results;
  };

  return Thing;

})();

Room = (function(_super) {
  __extends(Room, _super);

  function Room(list) {
    this.exits = [];
    this.location = void 0;
    Room.__super__.constructor.call(this, list);
  }

  Room.prototype.singular = true;

  Room.prototype.size = 500;

  Room.prototype.room = true;

  return Room;

})(Thing);

Building = (function(_super) {
  __extends(Building, _super);

  function Building() {
    return Building.__super__.constructor.apply(this, arguments);
  }

  Building.prototype.building = true;

  Building.prototype.size = 100;

  Building.prototype.examine = function() {
    var thing, windows, _i, _len, _ref;
    windows = [];
    _ref = this.contents;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      thing = _ref[_i];
      if (thing instanceof Window) {
        windows.push(thing);
      }
    }
    if (windows.length > 0) {
      return oneOf(windows).examine(player);
    }
  };

  return Building;

})(Thing);

Window = (function(_super) {
  __extends(Window, _super);

  function Window(list) {
    Window.__super__.constructor.call(this, list);
    if (!this.outside.contents) {
      this.outside.contents = [];
    }
    this.outside.contents.push(this);
    if (!this.inside.contents) {
      this.inside.contents = [];
    }
    this.inside.contents.push(this);
    this.synonyms = this.synonyms.concat(this.inside.name.split(' '));
  }

  Window.prototype.examine = function() {
    var sibling, target, _i, _len, _ref;
    if (player.inside === this.inside) {
      target = this.outside;
    } else {
      target = this.inside;
    }
    if (target.building) {
      target = target.inside;
    }
    Say("You see a " + target.name + " through a " + this.name + ".");
    target.examine();
    _ref = target.contents;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      sibling = _ref[_i];
      if ((this.outside !== sibling && sibling !== this)) {
        Say("You see " + lookAt(sibling) + ".");
      }
    }
    if (this.etchings) {
      return nameEtchings(this, examinee);
    }
  };

  Window.prototype.name = "window";

  Window.prototype.material = glass;

  return Window;

})(Thing);

Writing = (function(_super) {
  __extends(Writing, _super);

  function Writing() {
    return Writing.__super__.constructor.apply(this, arguments);
  }

  Writing.prototype.material = ink;

  Writing.prototype.method = "characters";

  Writing.prototype.hand = "carefully written";

  Writing.prototype.message = "hello sailor";

  Writing.prototype.relation = relation.written;

  Writing.prototype.name = "message";

  Writing.prototype.lookedAt = function() {
    return "" + this.hand + ": '" + this.message + "'";
  };

  return Writing;

})(Thing);

Aleph = (function(_super) {
  __extends(Aleph, _super);

  function Aleph() {
    return Aleph.__super__.constructor.apply(this, arguments);
  }

  Aleph.prototype.name = "aleph";

  Aleph.prototype.gotby = function() {
    var i, result, _i;
    result = [];
    player.name += " (examining the aleph)";
    for (i = _i = 0; _i <= 100; i = ++_i) {
      result.push(lookAt(oneOf(objects)));
    }
    Say("Inside the aleph you see " + assemble(result) + ".");
    return player.name = player.name.slice(0, +(player.name.length - " (examining the aleph)".length) + 1 || 9e9);
  };

  return Aleph;

})(Thing);

Diamond = (function(_super) {
  __extends(Diamond, _super);

  function Diamond() {
    return Diamond.__super__.constructor.apply(this, arguments);
  }

  Diamond.prototype.name = "enormous diamond";

  Diamond.prototype.gotby = function() {
    return see("Ethereal voices ring out: 'Thief!'");
  };

  return Diamond;

})(Thing);

CrystalSkull = (function(_super) {
  __extends(CrystalSkull, _super);

  function CrystalSkull() {
    return CrystalSkull.__super__.constructor.apply(this, arguments);
  }

  CrystalSkull.prototype.name = "crystal skull";

  CrystalSkull.prototype.singular = true;

  CrystalSkull.prototype.gotby = function() {
    return see("A terrifying chill runs up your arm.");
  };

  return CrystalSkull;

})(Thing);
