
#define V1_SUPERMAGIC	  0x137F	/* magic number for V1 file system */
#define V2_SUPERMAGIC	  0x2468	/* magic number for V2 file system */

/* V1_Inode Entry */
#define V1_FMODE	   0
#define V1_UID		   2
#define V1_FSIZE	   4
#define V1_TIME		   8
#define V1_LINKS	  10
#define V1_GID		  12
#define V1_ZONE0	  14
#define V1_ZONE1	  16
#define V1_ZONE2	  18
#define V1_ZONE3	  20
#define V1_ZONE4	  22
#define V1_ZONE5	  24
#define V1_ZONE6	  26
#define V1_ZONE7	  28
#define V1_ZONE8	  30
#define V1_INODESIZE	  32

/* V2_Inode Entry */
#define V2_FMODE	   0
#define V2_LINKS	   2
#define V2_UID		   4
#define V2_GID		   6
#define V2_FSIZE	   8
#define V2_ATIME	  12
#define V2_MTIME	  16
#define V2_CTIME	  20
#define V2_ZONE0	  24
#define V2_ZONE1	  28
#define V2_ZONE2	  32
#define V2_ZONE3	  36
#define V2_ZONE4	  40
#define V2_ZONE5	  44
#define V2_ZONE6	  48
#define V2_ZONE7	  52
#define V2_ZONE8	  56
#define V2_ZONE9	  60
#define V2_INODESIZE	  64

#define BOOT_BLOCK  	  0	/* block number of boot block */
#define SUPER_BLOCK	  1	/* block number of super block */
#define ROOT_INODE	  1	/* inode number for root directory */

struct super_block {
  ino_t s_ninodes;		/* # usable inodes on the minor device */
  zone_nr s_nzones;		/* total device size, including bit maps etc */
  unshort s_imap_blocks;	/* # of blocks used by inode bit map */
  unshort s_zmap_blocks;	/* # of blocks used by zone bit map */
  zone_nr s_firstdatazone;	/* number of first data zone */
  short int s_log_zone_size;	/* log2 of blocks/zone */
  off_t s_max_size;		/* maximum file size on this device */
  short s_magic;		/* magic number to recognize super-blocks */
};

struct dir_struct {		/* directory entry */
  ino_t d_inum;			/* inode number */
  char d_name[NAME_MAX];	/* character string */
};

typedef unsigned char u8_t;
typedef unsigned short u16_t;
typedef unsigned long u32_t;
