/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: labyrinth.h
**
** benoetigt:
**  global.h
**
** Kommentar:
**  Definiert Ausmasse und Datenstruktur des Labyrinths
*/


static char sccsid_labyrinth[] = "@(#)labyrinth.h	1.6 17 May 1994";


/* Das Labyrinth besteht aus maximal MAXFELDBREITE^2 Bloecken; fuer
   jeden Block sind 4 Waende gespeichert. (die meisten Waende sind
   dadurch doppelt gespeichert, das ermoeglicht "Einbahnstrassen")
   Ein Block ist in RASPT^2 feine Abstufungen unterteilt */


#define NORD 0
#define WEST 1
#define SUED 2
#define OST 3

#define MAXFELDBREITE 127
#define RASPT 256


/* oberstes Farbbit gibt an, ob Tuer oder Wand */
#define IST_TUER(farbe) (((farbe) & 8) != 0)


/* Welche Informationen sind fuer eine einzelne Wand gespeichert? */
struct wand
{
	u_int unbegehbar:1;   /* fuer unsichtbare Waende */
	u_int schusssicher:1; /* Wand nicht durchschiessbar */
	u_int tuer:1;         /* Wand ist eine Tuer */
	u_int tueroffen:1;    /* Tuer ist offen (in rechne3d) */
	u_int farbe:4;        /* maximal 16 Farben */
};

typedef struct wand block[4];

/* reale Feldgroesse */
extern u_int feldlaenge, feldbreite;

/* ein Spielfeld + 4* Spielfeld in 90 Grad Winkeln gedreht */
extern block **spielfeld, **feld_himricht[4];
