/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Loader;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.Version;
import net.sf.saxon.instruct.TerminationException;
import org.xml.sax.InputSource;

public class Compile {
    private TransformerFactoryImpl factory = new TransformerFactoryImpl();
    private boolean showTime = false;

    public static void main(String[] stringArray) throws Exception {
        new Compile().doMain(stringArray);
    }

    protected void doMain(String[] stringArray) {
        String string = null;
        boolean bl = false;
        String string2 = null;
        try {
            Object object;
            Object object2;
            Source source;
            int n = 0;
            while (true) {
                String string3;
                if (n >= stringArray.length) {
                    this.badUsage("No stylesheet file name");
                }
                if (stringArray[n].charAt(0) != '-') break;
                if (stringArray[n].equals("-u")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-t")) {
                    System.err.println(Version.getProductTitle());
                    System.err.println("Java version " + System.getProperty("java.version"));
                    this.factory.setAttribute("http://saxon.sf.net/feature/timing", Boolean.TRUE);
                    Loader.setTracing(true);
                    this.showTime = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-y")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage("No style parser class");
                    }
                    string3 = stringArray[n++];
                    this.factory.setAttribute("http://saxon.sf.net/feature/styleParserClass", string3);
                    continue;
                }
                if (stringArray[n].equals("-r")) {
                    if (stringArray.length < ++n + 2) {
                        this.badUsage("No URIResolver class");
                    }
                    string3 = stringArray[n++];
                    this.factory.setURIResolver(Compile.makeURIResolver(string3));
                    continue;
                }
                this.badUsage("Unknown option " + stringArray[n]);
            }
            if (stringArray.length < n + 1) {
                this.badUsage("No stylesheet file name");
            }
            string = stringArray[n++];
            if (stringArray.length < n + 1) {
                this.badUsage("No output file name");
            }
            string2 = stringArray[n++];
            long l = new Date().getTime();
            if (bl || string.startsWith("http:") || string.startsWith("file:")) {
                source = this.factory.getURIResolver().resolve(string, null);
            } else {
                object2 = new File(string);
                if (!((File)object2).exists()) {
                    Compile.quit("Stylesheet file " + object2 + " does not exist", 2);
                }
                object = new InputSource(((File)object2).toURL().toString());
                source = new SAXSource(this.factory.getConfiguration().getStyleParser(), (InputSource)object);
            }
            if (source == null) {
                Compile.quit("URIResolver for stylesheet file must return a Source", 2);
            }
            object2 = this.factory.newTemplates(source);
            if (this.showTime) {
                long l2 = new Date().getTime();
                System.err.println("Stylesheet compilation time: " + (l2 - l) + " milliseconds");
                l = l2;
            }
            try {
                System.err.println("Serializing compiled stylesheet");
                object = new ObjectOutputStream(new FileOutputStream(string2));
                ((ObjectOutputStream)object).writeObject(object2);
                ((ObjectOutputStream)object).close();
                System.err.println("Finished serializing stylesheet");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (TerminationException terminationException) {
            Compile.quit(terminationException.getMessage(), 1);
        }
        catch (TransformerException transformerException) {
            Compile.quit("Transformation failed: " + transformerException.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            Compile.quit("Transformation failed: " + transformerFactoryConfigurationError.getMessage(), 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void quit(String string, int n) {
        System.err.println(string);
        System.exit(n);
    }

    protected void badUsage(String string) {
        System.err.println(string);
        System.err.println(Version.getProductTitle());
        System.err.println("Usage: java net.sf.saxon.Compile [options] stylesheet-file output-file");
        System.err.println("Options: ");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -u              Names are URLs not filenames");
        System.err.println("  -y classname    Use specified SAX parser for stylesheet");
        System.err.println("  -?              Display this message ");
        System.exit(2);
    }

    public static URIResolver makeURIResolver(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new TransformerException("Class " + string + " is not a URIResolver");
    }
}

