#! /usr/bin/perl -w
use strict;
use vars qw($keymaps);

$keymaps = {};
require $ARGV[0];

my @output = ();
foreach my $kbdarch (keys %$keymaps) {
    next if $kbdarch eq 'default';
    my $kbdarchmaps = $keymaps->{$kbdarch};
    foreach my $family (keys %$kbdarchmaps) {
	next if $family eq 'default';
	my $familymaps = $kbdarchmaps->{$family};
	foreach my $layout (keys %$familymaps) {
	    next if $layout eq 'default';
	    my $layoutmaps = $familymaps->{$layout};
	    foreach my $kbdvariant (keys %$layoutmaps) {
		next if $kbdvariant eq 'default';
		my $kbdvariantmaps = $layoutmaps->{$kbdvariant};
		foreach my $mapvariant (keys %$kbdvariantmaps) {
		    next if $mapvariant eq 'default';
		    push @output, "$kbdarch $kbdvariantmaps->{$mapvariant}";
		}
	    }
	}
    }
}

my %output = map { $_ => 1 } @output;
print join("\n", sort keys %output), "\n";
