/*
 * Copyright 2019 Hitoshi Irino <irino@sfc.wide.ad.jp> All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS    OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PSAMP_H
#define _PSAMP_H

#include "common.h"
#include "softflowd.h"

#define PSAMP_selectionSequenceId         301
#define PSAMP_selectorAlgorithm           304
#define PSAMP_samplingPacketInterval      305
#define PSAMP_samplingPacketSpace         306
#define PSAMP_digestHashValue             326
#define PSAMP_observationTimeMicroseconds 324
#define PSAMP_dataLinkFrameSection        315
#define PSAMP_sectionExportedOctets       410

#define PSAMP_selectorAlgorithm_count   1


int send_psamp (const u_char * pkt, int caplen, struct timeval tv,
                struct NETFLOW_TARGET *target, uint64_t total_packets);
int recv_psamp (int rsock, struct CB_CTXT *cb_ctxt);
#endif /* _PSAMP_H */
