/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Stdlib includes


/////////////////////// Qt includes
#include <QString>

/////////////////////// Local includes
#include "MsXpS/export-import-config.h"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC PolChemDefSpec
{
  public:
  PolChemDefSpec(const QString &name = QString());
  ~PolChemDefSpec();

  void setName(const QString &name);
  const QString &getName() const;

  void setFilePath(const QString &file_path);
  QString getFilePath() const;

  QString dirPath();

  protected:
  // Name of the polymer definition(ie polymer type, 'protein').
  QString m_name;

  // PolChemDef definition file(path relative to the polymer chemistry
  // definitions directory in the data directory, as found in the
  // catalogue files, like protein-1-letter/protein-1-letter.xml
  QString m_filePath;
};

typedef std::shared_ptr<PolChemDefSpec> PolChemDefSpecSPtr;
typedef std::shared_ptr<const PolChemDefSpec> PolChemDefSpecCstSPtr;


} // namespace libXpertMassCore
} // namespace MsXpS
