/*
 * init.c: Struct initialization procedures for libppd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 * Contents:
 *
 *   ppd_choice_new()
 *   ppd_option_new()
 *   ppd_group_new() 
 *   ppd_constraint_new()
 *   ppd_size_new()
 *   ppd_emulator_new()
 *   ppd_profile_new()
 *
 */


#include "ppd.h"

/* no magic here, this is all very boring and straight forward! */

PpdChoice *ppd_choice_new(PpdOption * option, const char *choice,
			  const char *text)
{
  PpdChoice *c = g_new(PpdChoice, 1);

  c->id = PPD_TYPE_CHOICE;
  c->marked = FALSE;
  c->choice = g_string_new(choice);
  c->text = g_string_new(text);
  c->code = NULL;
  c->option = option;

  return (c);
}

PpdOption *ppd_option_new(PpdGroup * group, const char *keyword)
{
  PpdOption *o = g_new(PpdOption, 1);
  group->options = g_slist_append(group->options, o);

  o->id = PPD_TYPE_OPTION;

  o->conflicted = o->emitted = FALSE;
  o->keyword = g_string_new(keyword);
  o->defchoice = NULL;
  o->text = NULL;
  o->choices = NULL;
  o->ui = PPD_UI_BOOLEAN;
  o->section = PPD_ORDER_ANY;
  o->order = 0.0;

  return (o);
}

PpdGroup *ppd_group_new(void)
{
  PpdGroup *g = g_malloc(sizeof(PpdGroup));

  g->id = PPD_TYPE_GROUP;

  g->text = NULL;
  g->options = NULL;
  g->subgroups = NULL;

  return (g);
}

PpdConstraint *ppd_constraint_new(void)
{
  PpdConstraint *c = g_malloc(sizeof(PpdConstraint));

  c->id = PPD_TYPE_CONSTRAINT;

  c->option1 = c->option2 = NULL;
  c->choice1 = c->choice2 = NULL;

  return (c);
}

PpdSize *ppd_size_new(const char *name)
{
  PpdSize *s = g_new(PpdSize, 1);

  s->id = PPD_TYPE_SIZE;

  s->marked = FALSE;
  s->name = g_string_new(name);
  s->width = s->length = s->left = s->bottom = s->right = s->top = 0.0;

  return (s);
}

PpdEmulator *ppd_emulator_new(void)
{
  PpdEmulator *e = g_malloc(sizeof(PpdEmulator));

  e->id = PPD_TYPE_EMULATOR;

  e->name = NULL;
  e->start = NULL;
  e->stop = NULL;

  return (e);
}

PpdProfile *ppd_profile_new(void)
{
  PpdProfile *p = g_malloc(sizeof(PpdProfile));
  int i, j;

  p->id = PPD_TYPE_PROFILE;

  p->resolution = p->media_type = NULL;
  p->density = p->gamma = 0.0;

  for (i = 0; i < 3; i++)
    for (j = 0; j < 3; j++)
      p->matrix[i][j] = 0.0;

  return (p);
}
