# frozen_string_literal: true

class DropIndexVulnerabilityOccurrencesForIssueLinksMigration < Gitlab::Database::Migration[2.2]
  TABLE_NAME = :vulnerability_occurrences
  INDEX = 'index_vulnerability_occurrences_for_issue_links_migration'

  milestone '17.2'
  disable_ddl_transaction!

  def up
    remove_concurrent_index_by_name TABLE_NAME, name: INDEX
  end

  def down
    add_concurrent_index(
      TABLE_NAME,
      "project_id, report_type, encode(project_fingerprint, 'hex'::text)",
      name: INDEX
    )
  end
end
