# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create a virtual machine of a VM scale set.
    """

    _aaz_info = {
        "version": "2025-04-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/virtualmachinescalesets/{}/virtualmachines/{}", "2025-04-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.if_match = AAZStrArg(
            options=["--if-match"],
            help="The ETag of the transformation. Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting concurrent changes.",
        )
        _args_schema.if_none_match = AAZStrArg(
            options=["--if-none-match"],
            help="Set to '*' to allow a new record set to be created, but to prevent updating an existing record set. Other values will result in error from server as they are not supported.",
        )
        _args_schema.instance_id = AAZStrArg(
            options=["-n", "--name", "--instance-id"],
            help="The instance ID of the virtual machine.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.vm_scale_set_name = AAZStrArg(
            options=["--vm-scale-set-name"],
            help="The name of the VM scale set.",
            required=True,
        )

        # define Arg Group "Identity"

        _args_schema = cls._args_schema
        _args_schema.mi_system_assigned = AAZStrArg(
            options=["--system-assigned", "--mi-system-assigned"],
            arg_group="Identity",
            help="Set the system managed identity.",
            blank="True",
        )
        _args_schema.mi_user_assigned = AAZListArg(
            options=["--user-assigned", "--mi-user-assigned"],
            arg_group="Identity",
            help="Set the user managed identities.",
            blank=[],
        )

        mi_user_assigned = cls._args_schema.mi_user_assigned
        mi_user_assigned.Element = AAZStrArg()

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Parameters",
            help="The geo-location where the resource lives",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.plan = AAZObjectArg(
            options=["--plan"],
            arg_group="Parameters",
            help="Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Parameters",
            help="Resource tags.",
        )

        plan = cls._args_schema.plan
        plan.name = AAZStrArg(
            options=["name"],
            help="The plan ID.",
        )
        plan.product = AAZStrArg(
            options=["product"],
            help="Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.",
        )
        plan.promotion_code = AAZStrArg(
            options=["promotion-code"],
            help="The promotion code.",
        )
        plan.publisher = AAZStrArg(
            options=["publisher"],
            help="The publisher ID.",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.additional_capabilities = AAZObjectArg(
            options=["--additional-capabilities"],
            arg_group="Properties",
            help="Specifies additional capabilities enabled or disabled on the virtual machine in the scale set. For instance: whether the virtual machine has the capability to support attaching managed data disks with UltraSSD_LRS storage account type.",
        )
        _args_schema.availability_set = AAZObjectArg(
            options=["--availability-set"],
            arg_group="Properties",
            help="Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs.microsoft.com/azure/virtual-machines/availability-set-overview). For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.",
        )
        cls._build_args_sub_resource_create(_args_schema.availability_set)
        _args_schema.diagnostics_profile = AAZObjectArg(
            options=["--diagnostics-profile"],
            arg_group="Properties",
            help="Specifies the boot diagnostic settings state. Minimum api-version: 2015-06-15.",
        )
        _args_schema.hardware_profile = AAZObjectArg(
            options=["--hardware-profile"],
            arg_group="Properties",
            help="Specifies the hardware settings for the virtual machine.",
        )
        _args_schema.license_type = AAZStrArg(
            options=["--license-type"],
            arg_group="Properties",
            help="Specifies that the image or disk that is being used was licensed on-premises. <br><br> Possible values for Windows Server operating system are: <br><br> Windows_Client <br><br> Windows_Server <br><br> Possible values for Linux Server operating system are: <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br> For more information, see [Azure Hybrid Use Benefit for Windows Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing) <br><br> [Azure Hybrid Use Benefit for Linux Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux) <br><br> Minimum api-version: 2015-06-15",
        )
        _args_schema.network_profile = AAZObjectArg(
            options=["--network-profile"],
            arg_group="Properties",
            help="Specifies the network interfaces of the virtual machine.",
        )
        _args_schema.network_profile_configuration = AAZObjectArg(
            options=["--network-profile-configuration"],
            arg_group="Properties",
            help="Specifies the network profile configuration of the virtual machine.",
        )
        _args_schema.os_profile = AAZObjectArg(
            options=["--os-profile"],
            arg_group="Properties",
            help="Specifies the operating system settings for the virtual machine.",
        )
        _args_schema.protection_policy = AAZObjectArg(
            options=["--protection-policy"],
            arg_group="Properties",
            help="Specifies the protection policy of the virtual machine.",
        )
        _args_schema.resilient_vm_deletion_status = AAZStrArg(
            options=["--resilient-vm-deletion-status"],
            arg_group="Properties",
            help="Specifies the resilient VM deletion status for the virtual machine.",
            enum={"Disabled": "Disabled", "Enabled": "Enabled", "Failed": "Failed", "InProgress": "InProgress"},
        )
        _args_schema.security_profile = AAZObjectArg(
            options=["--security-profile"],
            arg_group="Properties",
            help="Specifies the Security related profile settings for the virtual machine.",
        )
        _args_schema.storage_profile = AAZObjectArg(
            options=["--storage-profile"],
            arg_group="Properties",
            help="Specifies the storage settings for the virtual machine disks.",
        )
        _args_schema.user_data = AAZStrArg(
            options=["--user-data"],
            arg_group="Properties",
            help="UserData for the VM, which must be base-64 encoded. Customer should not pass any secrets in here. Minimum api-version: 2021-03-01",
        )

        additional_capabilities = cls._args_schema.additional_capabilities
        additional_capabilities.enable_fips1403_encryption = AAZBoolArg(
            options=["enable-fips1403-encryption"],
            help="The flag enables the usage of FIPS 140-3 compliant cryptography on the protectedSettings of an extension. Learn more at: https://aka.ms/linuxagentfipssupport.",
        )
        additional_capabilities.hibernation_enabled = AAZBoolArg(
            options=["hibernation-enabled"],
            help="The flag that enables or disables hibernation capability on the VM.",
        )
        additional_capabilities.ultra_ssd_enabled = AAZBoolArg(
            options=["ultra-ssd-enabled"],
            help="The flag that enables or disables a capability to have one or more managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale set only if this property is enabled.",
        )

        diagnostics_profile = cls._args_schema.diagnostics_profile
        diagnostics_profile.boot_diagnostics = AAZObjectArg(
            options=["boot-diagnostics"],
            help="Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. **NOTE**: If storageUri is being specified then ensure that the storage account is in the same region and subscription as the VM. You can easily view the output of your console log. Azure also enables you to see a screenshot of the VM from the hypervisor.",
        )

        boot_diagnostics = cls._args_schema.diagnostics_profile.boot_diagnostics
        boot_diagnostics.enabled = AAZBoolArg(
            options=["enabled"],
            help="Whether boot diagnostics should be enabled on the Virtual Machine.",
        )
        boot_diagnostics.storage_uri = AAZStrArg(
            options=["storage-uri"],
            help="Uri of the storage account to use for placing the console output and screenshot. If storageUri is not specified while enabling boot diagnostics, managed storage will be used.",
        )

        hardware_profile = cls._args_schema.hardware_profile
        hardware_profile.vm_size = AAZStrArg(
            options=["vm-size"],
            help="Specifies the size of the virtual machine. The enum data type is currently deprecated and will be removed by December 23rd 2023. The recommended way to get the list of available sizes is using these APIs: [List all available virtual machine sizes in an availability set](https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes), [List all available virtual machine sizes in a region]( https://docs.microsoft.com/rest/api/compute/resourceskus/list), [List all available virtual machine sizes for resizing](https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes). For more information about virtual machine sizes, see [Sizes for virtual machines](https://docs.microsoft.com/azure/virtual-machines/sizes). The available VM sizes depend on region and availability set.",
            enum={"Basic_A0": "Basic_A0", "Basic_A1": "Basic_A1", "Basic_A2": "Basic_A2", "Basic_A3": "Basic_A3", "Basic_A4": "Basic_A4", "Standard_A0": "Standard_A0", "Standard_A1": "Standard_A1", "Standard_A10": "Standard_A10", "Standard_A11": "Standard_A11", "Standard_A1_v2": "Standard_A1_v2", "Standard_A2": "Standard_A2", "Standard_A2_v2": "Standard_A2_v2", "Standard_A2m_v2": "Standard_A2m_v2", "Standard_A3": "Standard_A3", "Standard_A4": "Standard_A4", "Standard_A4_v2": "Standard_A4_v2", "Standard_A4m_v2": "Standard_A4m_v2", "Standard_A5": "Standard_A5", "Standard_A6": "Standard_A6", "Standard_A7": "Standard_A7", "Standard_A8": "Standard_A8", "Standard_A8_v2": "Standard_A8_v2", "Standard_A8m_v2": "Standard_A8m_v2", "Standard_A9": "Standard_A9", "Standard_B1ms": "Standard_B1ms", "Standard_B1s": "Standard_B1s", "Standard_B2ms": "Standard_B2ms", "Standard_B2s": "Standard_B2s", "Standard_B4ms": "Standard_B4ms", "Standard_B8ms": "Standard_B8ms", "Standard_D1": "Standard_D1", "Standard_D11": "Standard_D11", "Standard_D11_v2": "Standard_D11_v2", "Standard_D12": "Standard_D12", "Standard_D12_v2": "Standard_D12_v2", "Standard_D13": "Standard_D13", "Standard_D13_v2": "Standard_D13_v2", "Standard_D14": "Standard_D14", "Standard_D14_v2": "Standard_D14_v2", "Standard_D15_v2": "Standard_D15_v2", "Standard_D16_v3": "Standard_D16_v3", "Standard_D16s_v3": "Standard_D16s_v3", "Standard_D1_v2": "Standard_D1_v2", "Standard_D2": "Standard_D2", "Standard_D2_v2": "Standard_D2_v2", "Standard_D2_v3": "Standard_D2_v3", "Standard_D2s_v3": "Standard_D2s_v3", "Standard_D3": "Standard_D3", "Standard_D32_v3": "Standard_D32_v3", "Standard_D32s_v3": "Standard_D32s_v3", "Standard_D3_v2": "Standard_D3_v2", "Standard_D4": "Standard_D4", "Standard_D4_v2": "Standard_D4_v2", "Standard_D4_v3": "Standard_D4_v3", "Standard_D4s_v3": "Standard_D4s_v3", "Standard_D5_v2": "Standard_D5_v2", "Standard_D64_v3": "Standard_D64_v3", "Standard_D64s_v3": "Standard_D64s_v3", "Standard_D8_v3": "Standard_D8_v3", "Standard_D8s_v3": "Standard_D8s_v3", "Standard_DS1": "Standard_DS1", "Standard_DS11": "Standard_DS11", "Standard_DS11_v2": "Standard_DS11_v2", "Standard_DS12": "Standard_DS12", "Standard_DS12_v2": "Standard_DS12_v2", "Standard_DS13": "Standard_DS13", "Standard_DS13-2_v2": "Standard_DS13-2_v2", "Standard_DS13-4_v2": "Standard_DS13-4_v2", "Standard_DS13_v2": "Standard_DS13_v2", "Standard_DS14": "Standard_DS14", "Standard_DS14-4_v2": "Standard_DS14-4_v2", "Standard_DS14-8_v2": "Standard_DS14-8_v2", "Standard_DS14_v2": "Standard_DS14_v2", "Standard_DS15_v2": "Standard_DS15_v2", "Standard_DS1_v2": "Standard_DS1_v2", "Standard_DS2": "Standard_DS2", "Standard_DS2_v2": "Standard_DS2_v2", "Standard_DS3": "Standard_DS3", "Standard_DS3_v2": "Standard_DS3_v2", "Standard_DS4": "Standard_DS4", "Standard_DS4_v2": "Standard_DS4_v2", "Standard_DS5_v2": "Standard_DS5_v2", "Standard_E16_v3": "Standard_E16_v3", "Standard_E16s_v3": "Standard_E16s_v3", "Standard_E2_v3": "Standard_E2_v3", "Standard_E2s_v3": "Standard_E2s_v3", "Standard_E32-16_v3": "Standard_E32-16_v3", "Standard_E32-8s_v3": "Standard_E32-8s_v3", "Standard_E32_v3": "Standard_E32_v3", "Standard_E32s_v3": "Standard_E32s_v3", "Standard_E4_v3": "Standard_E4_v3", "Standard_E4s_v3": "Standard_E4s_v3", "Standard_E64-16s_v3": "Standard_E64-16s_v3", "Standard_E64-32s_v3": "Standard_E64-32s_v3", "Standard_E64_v3": "Standard_E64_v3", "Standard_E64s_v3": "Standard_E64s_v3", "Standard_E8_v3": "Standard_E8_v3", "Standard_E8s_v3": "Standard_E8s_v3", "Standard_F1": "Standard_F1", "Standard_F16": "Standard_F16", "Standard_F16s": "Standard_F16s", "Standard_F16s_v2": "Standard_F16s_v2", "Standard_F1s": "Standard_F1s", "Standard_F2": "Standard_F2", "Standard_F2s": "Standard_F2s", "Standard_F2s_v2": "Standard_F2s_v2", "Standard_F32s_v2": "Standard_F32s_v2", "Standard_F4": "Standard_F4", "Standard_F4s": "Standard_F4s", "Standard_F4s_v2": "Standard_F4s_v2", "Standard_F64s_v2": "Standard_F64s_v2", "Standard_F72s_v2": "Standard_F72s_v2", "Standard_F8": "Standard_F8", "Standard_F8s": "Standard_F8s", "Standard_F8s_v2": "Standard_F8s_v2", "Standard_G1": "Standard_G1", "Standard_G2": "Standard_G2", "Standard_G3": "Standard_G3", "Standard_G4": "Standard_G4", "Standard_G5": "Standard_G5", "Standard_GS1": "Standard_GS1", "Standard_GS2": "Standard_GS2", "Standard_GS3": "Standard_GS3", "Standard_GS4": "Standard_GS4", "Standard_GS4-4": "Standard_GS4-4", "Standard_GS4-8": "Standard_GS4-8", "Standard_GS5": "Standard_GS5", "Standard_GS5-16": "Standard_GS5-16", "Standard_GS5-8": "Standard_GS5-8", "Standard_H16": "Standard_H16", "Standard_H16m": "Standard_H16m", "Standard_H16mr": "Standard_H16mr", "Standard_H16r": "Standard_H16r", "Standard_H8": "Standard_H8", "Standard_H8m": "Standard_H8m", "Standard_L16s": "Standard_L16s", "Standard_L32s": "Standard_L32s", "Standard_L4s": "Standard_L4s", "Standard_L8s": "Standard_L8s", "Standard_M128-32ms": "Standard_M128-32ms", "Standard_M128-64ms": "Standard_M128-64ms", "Standard_M128ms": "Standard_M128ms", "Standard_M128s": "Standard_M128s", "Standard_M64-16ms": "Standard_M64-16ms", "Standard_M64-32ms": "Standard_M64-32ms", "Standard_M64ms": "Standard_M64ms", "Standard_M64s": "Standard_M64s", "Standard_NC12": "Standard_NC12", "Standard_NC12s_v2": "Standard_NC12s_v2", "Standard_NC12s_v3": "Standard_NC12s_v3", "Standard_NC24": "Standard_NC24", "Standard_NC24r": "Standard_NC24r", "Standard_NC24rs_v2": "Standard_NC24rs_v2", "Standard_NC24rs_v3": "Standard_NC24rs_v3", "Standard_NC24s_v2": "Standard_NC24s_v2", "Standard_NC24s_v3": "Standard_NC24s_v3", "Standard_NC6": "Standard_NC6", "Standard_NC6s_v2": "Standard_NC6s_v2", "Standard_NC6s_v3": "Standard_NC6s_v3", "Standard_ND12s": "Standard_ND12s", "Standard_ND24rs": "Standard_ND24rs", "Standard_ND24s": "Standard_ND24s", "Standard_ND6s": "Standard_ND6s", "Standard_NV12": "Standard_NV12", "Standard_NV24": "Standard_NV24", "Standard_NV6": "Standard_NV6"},
        )
        hardware_profile.vm_size_properties = AAZObjectArg(
            options=["vm-size-properties"],
            help="Specifies the properties for customizing the size of the virtual machine. Minimum api-version: 2021-07-01. This feature is still in preview mode and is not supported for VirtualMachineScaleSet. Please follow the instructions in [VM Customization](https://aka.ms/vmcustomization) for more details.",
        )

        vm_size_properties = cls._args_schema.hardware_profile.vm_size_properties
        vm_size_properties.v_cp_us_available = AAZIntArg(
            options=["v-cp-us-available"],
            help="Specifies the number of vCPUs available for the VM. When this property is not specified in the request body the default behavior is to set it to the value of vCPUs available for that VM size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list).",
        )
        vm_size_properties.v_cp_us_per_core = AAZIntArg(
            options=["v-cp-us-per-core"],
            help="Specifies the vCPU to physical core ratio. When this property is not specified in the request body the default behavior is set to the value of vCPUsPerCore for the VM Size exposed in api response of [List all available virtual machine sizes in a region](https://docs.microsoft.com/en-us/rest/api/compute/resource-skus/list). **Setting this property to 1 also means that hyper-threading is disabled.**",
        )

        network_profile = cls._args_schema.network_profile
        network_profile.network_api_version = AAZStrArg(
            options=["network-api-version"],
            help="specifies the Microsoft.Network API version used when creating networking resources in the Network Interface Configurations",
            enum={"2020-11-01": "2020-11-01", "2022-11-01": "2022-11-01"},
        )
        network_profile.network_interface_configurations = AAZListArg(
            options=["network-interface-configurations"],
            help="Specifies the networking configurations that will be used to create the virtual machine networking resources.",
        )
        network_profile.network_interfaces = AAZListArg(
            options=["network-interfaces"],
            help="Specifies the list of resource Ids for the network interfaces associated with the virtual machine.",
        )

        network_interface_configurations = cls._args_schema.network_profile.network_interface_configurations
        network_interface_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.network_profile.network_interface_configurations.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The network interface configuration name.",
            required=True,
        )
        _element.auxiliary_mode = AAZStrArg(
            options=["auxiliary-mode"],
            help="Specifies whether the Auxiliary mode is enabled for the Network Interface resource.",
            enum={"AcceleratedConnections": "AcceleratedConnections", "Floating": "Floating", "None": "None"},
        )
        _element.auxiliary_sku = AAZStrArg(
            options=["auxiliary-sku"],
            help="Specifies whether the Auxiliary sku is enabled for the Network Interface resource.",
            enum={"A1": "A1", "A2": "A2", "A4": "A4", "A8": "A8", "None": "None"},
        )
        _element.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the network interface when the VM is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        _element.disable_tcp_state_tracking = AAZBoolArg(
            options=["disable-tcp-state-tracking"],
            help="Specifies whether the network interface is disabled for tcp state tracking.",
        )
        _element.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The dns settings to be applied on the network interfaces.",
        )
        _element.dscp_configuration = AAZObjectArg(
            options=["dscp-configuration"],
        )
        cls._build_args_sub_resource_create(_element.dscp_configuration)
        _element.enable_accelerated_networking = AAZBoolArg(
            options=["enable-accelerated-networking"],
            help="Specifies whether the network interface is accelerated networking-enabled.",
        )
        _element.enable_fpga = AAZBoolArg(
            options=["enable-fpga"],
            help="Specifies whether the network interface is FPGA networking-enabled.",
        )
        _element.enable_ip_forwarding = AAZBoolArg(
            options=["enable-ip-forwarding"],
            help="Whether IP forwarding enabled on this NIC.",
        )
        _element.ip_configurations = AAZListArg(
            options=["ip-configurations"],
            help="Specifies the IP configurations of the network interface.",
        )
        _element.network_security_group = AAZObjectArg(
            options=["network-security-group"],
            help="The network security group.",
        )
        cls._build_args_sub_resource_create(_element.network_security_group)
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Specifies the primary network interface in case the virtual machine has more than 1 network interface.",
        )
        _element.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags applied to the networkInterface address created by this NetworkInterfaceConfiguration",
        )

        dns_settings = cls._args_schema.network_profile.network_interface_configurations.Element.dns_settings
        dns_settings.dns_servers = AAZListArg(
            options=["dns-servers"],
            help="List of DNS servers IP addresses",
        )

        dns_servers = cls._args_schema.network_profile.network_interface_configurations.Element.dns_settings.dns_servers
        dns_servers.Element = AAZStrArg()

        ip_configurations = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations
        ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The IP configuration name.",
            required=True,
        )
        _element.application_gateway_backend_address_pools = AAZListArg(
            options=["application-gateway-backend-address-pools"],
            help="Specifies an array of references to backend address pools of application gateways. A virtual machine can reference backend address pools of multiple application gateways. Multiple virtual machines cannot use the same application gateway.",
        )
        _element.application_security_groups = AAZListArg(
            options=["application-security-groups"],
            help="Specifies an array of references to application security group.",
        )
        _element.load_balancer_backend_address_pools = AAZListArg(
            options=["load-balancer-backend-address-pools"],
            help="Specifies an array of references to backend address pools of load balancers. A virtual machine can reference backend address pools of one public and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load balancer].",
        )
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Specifies the primary network interface in case the virtual machine has more than 1 network interface.",
        )
        _element.private_ip_address_version = AAZStrArg(
            options=["private-ip-address-version"],
            help="Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        _element.public_ip_address_configuration = AAZObjectArg(
            options=["public-ip-address-configuration"],
            help="The publicIPAddressConfiguration.",
        )
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Specifies the identifier of the subnet.",
        )
        cls._build_args_sub_resource_create(_element.subnet)

        application_gateway_backend_address_pools = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(application_gateway_backend_address_pools.Element)

        application_security_groups = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.application_security_groups
        application_security_groups.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(application_security_groups.Element)

        load_balancer_backend_address_pools = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(load_balancer_backend_address_pools.Element)

        public_ip_address_configuration = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration
        public_ip_address_configuration.name = AAZStrArg(
            options=["name"],
            help="The publicIP address configuration name.",
            required=True,
        )
        public_ip_address_configuration.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the public IP address when the VM is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        public_ip_address_configuration.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The dns settings to be applied on the publicIP addresses .",
        )
        public_ip_address_configuration.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address_configuration.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of IP tags associated with the public IP address.",
        )
        public_ip_address_configuration.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address_configuration.public_ip_allocation_method = AAZStrArg(
            options=["public-ip-allocation-method"],
            help="Specify the public IP allocation type",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        public_ip_address_configuration.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The PublicIPPrefix from which to allocate publicIP addresses.",
        )
        cls._build_args_sub_resource_create(public_ip_address_configuration.public_ip_prefix)
        public_ip_address_configuration.sku = AAZObjectArg(
            options=["sku"],
            help="Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.",
        )
        cls._build_args_public_ip_address_sku_create(public_ip_address_configuration.sku)
        public_ip_address_configuration.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags applied to the publicIP address created by this PublicIPAddressConfiguration",
        )

        dns_settings = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="The Domain name label prefix of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the domain name label and vm network profile unique ID.",
            required=True,
        )
        dns_settings.domain_name_label_scope = AAZStrArg(
            options=["domain-name-label-scope"],
            help="The Domain name label scope of the PublicIPAddress resources that will be created. The generated name label is the concatenation of the hashed domain name label with policy according to the domain name label scope and vm network profile unique ID.",
            enum={"NoReuse": "NoReuse", "ResourceGroupReuse": "ResourceGroupReuse", "SubscriptionReuse": "SubscriptionReuse", "TenantReuse": "TenantReuse"},
        )

        ip_tags = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.ip_tags
        ip_tags.Element = AAZObjectArg()

        _element = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="IP tag type. Example: FirstPartyUsage.",
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="IP tag associated with the public IP. Example: SQL, Storage etc.",
        )

        tags = cls._args_schema.network_profile.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.tags
        tags.Element = AAZStrArg()

        tags = cls._args_schema.network_profile.network_interface_configurations.Element.tags
        tags.Element = AAZStrArg()

        network_interfaces = cls._args_schema.network_profile.network_interfaces
        network_interfaces.Element = AAZObjectArg()

        _element = cls._args_schema.network_profile.network_interfaces.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )
        _element.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the network interface when the VM is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Specifies the primary network interface in case the virtual machine has more than 1 network interface.",
        )

        network_profile_configuration = cls._args_schema.network_profile_configuration
        network_profile_configuration.network_interface_configurations = AAZListArg(
            options=["network-interface-configurations"],
            help="The list of network configurations.",
        )

        network_interface_configurations = cls._args_schema.network_profile_configuration.network_interface_configurations
        network_interface_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.network_profile_configuration.network_interface_configurations.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The network configuration name.",
            required=True,
        )
        _element.auxiliary_mode = AAZStrArg(
            options=["auxiliary-mode"],
            help="Specifies whether the Auxiliary mode is enabled for the Network Interface resource.",
            enum={"AcceleratedConnections": "AcceleratedConnections", "Floating": "Floating", "None": "None"},
        )
        _element.auxiliary_sku = AAZStrArg(
            options=["auxiliary-sku"],
            help="Specifies whether the Auxiliary sku is enabled for the Network Interface resource.",
            enum={"A1": "A1", "A2": "A2", "A4": "A4", "A8": "A8", "None": "None"},
        )
        _element.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the network interface when the VM is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        _element.disable_tcp_state_tracking = AAZBoolArg(
            options=["disable-tcp-state-tracking"],
            help="Specifies whether the network interface is disabled for tcp state tracking.",
        )
        _element.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The dns settings to be applied on the network interfaces.",
        )
        _element.enable_accelerated_networking = AAZBoolArg(
            options=["enable-accelerated-networking"],
            help="Specifies whether the network interface is accelerated networking-enabled.",
        )
        _element.enable_fpga = AAZBoolArg(
            options=["enable-fpga"],
            help="Specifies whether the network interface is FPGA networking-enabled.",
        )
        _element.enable_ip_forwarding = AAZBoolArg(
            options=["enable-ip-forwarding"],
            help="Whether IP forwarding enabled on this NIC.",
        )
        _element.ip_configurations = AAZListArg(
            options=["ip-configurations"],
            help="Specifies the IP configurations of the network interface.",
        )
        _element.network_security_group = AAZObjectArg(
            options=["network-security-group"],
            help="The network security group.",
        )
        cls._build_args_sub_resource_create(_element.network_security_group)
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Specifies the primary network interface in case the virtual machine has more than 1 network interface.",
        )
        _element.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags applied to the networkInterface address created by this NetworkInterfaceConfiguration",
        )

        dns_settings = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.dns_settings
        dns_settings.dns_servers = AAZListArg(
            options=["dns-servers"],
            help="List of DNS servers IP addresses",
        )

        dns_servers = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.dns_settings.dns_servers
        dns_servers.Element = AAZStrArg()

        ip_configurations = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations
        ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The IP configuration name.",
            required=True,
        )
        _element.application_gateway_backend_address_pools = AAZListArg(
            options=["application-gateway-backend-address-pools"],
            help="Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets cannot use the same application gateway.",
        )
        _element.application_security_groups = AAZListArg(
            options=["application-security-groups"],
            help="Specifies an array of references to application security group.",
        )
        _element.load_balancer_backend_address_pools = AAZListArg(
            options=["load-balancer-backend-address-pools"],
            help="Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.",
        )
        _element.load_balancer_inbound_nat_pools = AAZListArg(
            options=["load-balancer-inbound-nat-pools"],
            help="Specifies an array of references to inbound Nat pools of the load balancers. A scale set can reference inbound nat pools of one public and one internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.",
        )
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Specifies the primary network interface in case the virtual machine has more than 1 network interface.",
        )
        _element.private_ip_address_version = AAZStrArg(
            options=["private-ip-address-version"],
            help="Available from Api-Version 2017-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        _element.public_ip_address_configuration = AAZObjectArg(
            options=["public-ip-address-configuration"],
            help="The publicIPAddressConfiguration.",
        )
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Specifies the identifier of the subnet.",
        )
        cls._build_args_api_entity_reference_create(_element.subnet)

        application_gateway_backend_address_pools = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(application_gateway_backend_address_pools.Element)

        application_security_groups = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.application_security_groups
        application_security_groups.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(application_security_groups.Element)

        load_balancer_backend_address_pools = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(load_balancer_backend_address_pools.Element)

        load_balancer_inbound_nat_pools = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.load_balancer_inbound_nat_pools
        load_balancer_inbound_nat_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(load_balancer_inbound_nat_pools.Element)

        public_ip_address_configuration = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration
        public_ip_address_configuration.name = AAZStrArg(
            options=["name"],
            help="The publicIP address configuration name.",
            required=True,
        )
        public_ip_address_configuration.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the public IP when the VM is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        public_ip_address_configuration.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The dns settings to be applied on the publicIP addresses .",
        )
        public_ip_address_configuration.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address_configuration.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of IP tags associated with the public IP address.",
        )
        public_ip_address_configuration.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address_configuration.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The PublicIPPrefix from which to allocate publicIP addresses.",
        )
        cls._build_args_sub_resource_create(public_ip_address_configuration.public_ip_prefix)
        public_ip_address_configuration.sku = AAZObjectArg(
            options=["sku"],
            help="Describes the public IP Sku. It can only be set with OrchestrationMode as Flexible.",
        )
        cls._build_args_public_ip_address_sku_create(public_ip_address_configuration.sku)
        public_ip_address_configuration.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags applied to the publicIP address created by this PublicIPAddressConfiguration",
        )

        dns_settings = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="The Domain name label.The concatenation of the domain name label and vm index will be the domain name labels of the PublicIPAddress resources that will be created",
            required=True,
        )
        dns_settings.domain_name_label_scope = AAZStrArg(
            options=["domain-name-label-scope"],
            help="The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created",
            enum={"NoReuse": "NoReuse", "ResourceGroupReuse": "ResourceGroupReuse", "SubscriptionReuse": "SubscriptionReuse", "TenantReuse": "TenantReuse"},
        )

        ip_tags = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.ip_tags
        ip_tags.Element = AAZObjectArg()

        _element = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="IP tag type. Example: FirstPartyUsage.",
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="IP tag associated with the public IP. Example: SQL, Storage etc.",
        )

        tags = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.ip_configurations.Element.public_ip_address_configuration.tags
        tags.Element = AAZStrArg()

        tags = cls._args_schema.network_profile_configuration.network_interface_configurations.Element.tags
        tags.Element = AAZStrArg()

        os_profile = cls._args_schema.os_profile
        os_profile.admin_password = AAZPasswordArg(
            options=["admin-password"],
            help="Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** \"abc@123\", \"P@$$w0rd\", \"P@ssw0rd\", \"P@ssword123\", \"Pa$$word\", \"pass@word1\", \"Password!\", \"Password1\", \"Password22\", \"iloveyou!\" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)",
            blank=AAZPromptPasswordInput(
                msg="Password:",
            ),
        )
        os_profile.admin_username = AAZStrArg(
            options=["admin-username"],
            help="Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in \".\" <br><br> **Disallowed values:** \"administrator\", \"admin\", \"user\", \"user1\", \"test\", \"user2\", \"test1\", \"user3\", \"admin1\", \"1\", \"123\", \"a\", \"actuser\", \"adm\", \"admin2\", \"aspnet\", \"backup\", \"console\", \"david\", \"guest\", \"john\", \"owner\", \"root\", \"server\", \"sql\", \"support\", \"support_388945a0\", \"sys\", \"test2\", \"test3\", \"user4\", \"user5\". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.",
        )
        os_profile.allow_extension_operations = AAZBoolArg(
            options=["allow-extension-operations"],
            help="Specifies whether extension operations should be allowed on the virtual machine. This may only be set to False when no extensions are present on the virtual machine.",
        )
        os_profile.computer_name = AAZStrArg(
            options=["computer-name"],
            help="Specifies the host OS name of the virtual machine. This name cannot be updated after the VM is created. **Max-length (Windows):** 15 characters. **Max-length (Linux):** 64 characters. For naming conventions and restrictions see [Azure infrastructure services implementation guidelines](https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules).",
        )
        os_profile.custom_data = AAZStrArg(
            options=["custom-data"],
            help="Specifies a base-64 encoded string of custom data. The base-64 encoded string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum length of the binary array is 65535 bytes. **Note: Do not pass any secrets or passwords in customData property.** This property cannot be updated after the VM is created. The property 'customData' is passed to the VM to be saved as a file, for more information see [Custom Data on Azure VMs](https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/). For using cloud-init for your Linux VM, see [Using cloud-init to customize a Linux VM during creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init).",
        )
        os_profile.linux_configuration = AAZObjectArg(
            options=["linux-configuration"],
            help="Specifies the Linux operating system settings on the virtual machine. For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).",
        )
        os_profile.require_guest_provision_signal = AAZBoolArg(
            options=["require-guest-provision-signal"],
            help="Optional property which must either be set to True or omitted.",
        )
        os_profile.secrets = AAZListArg(
            options=["secrets"],
            help="Specifies set of certificates that should be installed onto the virtual machine. To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).",
        )
        os_profile.windows_configuration = AAZObjectArg(
            options=["windows-configuration"],
            help="Specifies Windows operating system settings on the virtual machine.",
        )

        linux_configuration = cls._args_schema.os_profile.linux_configuration
        linux_configuration.disable_password_authentication = AAZBoolArg(
            options=["disable-password-authentication"],
            help="Specifies whether password authentication should be disabled.",
        )
        linux_configuration.enable_vm_agent_platform_updates = AAZBoolArg(
            options=["enable-vm-agent-platform-updates"],
            help="Indicates whether VMAgent Platform Updates is enabled for the Linux virtual machine. Default value is false.",
        )
        linux_configuration.patch_settings = AAZObjectArg(
            options=["patch-settings"],
            help="[Preview Feature] Specifies settings related to VM Guest Patching on Linux.",
        )
        linux_configuration.provision_vm_agent = AAZBoolArg(
            options=["provision-vm-agent"],
            help="Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, default behavior is to set it to true. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.",
        )
        linux_configuration.ssh = AAZObjectArg(
            options=["ssh"],
            help="Specifies the ssh key configuration for a Linux OS.",
        )

        patch_settings = cls._args_schema.os_profile.linux_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrArg(
            options=["assessment-mode"],
            help="Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.",
            enum={"AutomaticByPlatform": "AutomaticByPlatform", "ImageDefault": "ImageDefault"},
        )
        patch_settings.automatic_by_platform_settings = AAZObjectArg(
            options=["automatic-by-platform-settings"],
            help="Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Linux.",
        )
        patch_settings.patch_mode = AAZStrArg(
            options=["patch-mode"],
            help="Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true",
            enum={"AutomaticByPlatform": "AutomaticByPlatform", "ImageDefault": "ImageDefault"},
        )

        automatic_by_platform_settings = cls._args_schema.os_profile.linux_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolArg(
            options=["bypass-platform-safety-checks-on-user-schedule"],
            help="Enables customer to schedule patching without accidental upgrades",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrArg(
            options=["reboot-setting"],
            help="Specifies the reboot setting for all AutomaticByPlatform patch installation operations.",
            enum={"Always": "Always", "IfRequired": "IfRequired", "Never": "Never", "Unknown": "Unknown"},
        )

        ssh = cls._args_schema.os_profile.linux_configuration.ssh
        ssh.public_keys = AAZListArg(
            options=["public-keys"],
            help="The list of SSH public keys used to authenticate with linux based VMs.",
        )

        public_keys = cls._args_schema.os_profile.linux_configuration.ssh.public_keys
        public_keys.Element = AAZObjectArg()

        _element = cls._args_schema.os_profile.linux_configuration.ssh.public_keys.Element
        _element.key_data = AAZStrArg(
            options=["key-data"],
            help="SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).",
        )
        _element.path = AAZStrArg(
            options=["path"],
            help="Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys",
        )

        secrets = cls._args_schema.os_profile.secrets
        secrets.Element = AAZObjectArg()

        _element = cls._args_schema.os_profile.secrets.Element
        _element.source_vault = AAZObjectArg(
            options=["source-vault"],
            help="The relative URL of the Key Vault containing all of the certificates in VaultCertificates.",
        )
        cls._build_args_sub_resource_create(_element.source_vault)
        _element.vault_certificates = AAZListArg(
            options=["vault-certificates"],
            help="The list of key vault references in SourceVault which contain certificates.",
        )

        vault_certificates = cls._args_schema.os_profile.secrets.Element.vault_certificates
        vault_certificates.Element = AAZObjectArg()

        _element = cls._args_schema.os_profile.secrets.Element.vault_certificates.Element
        _element.certificate_store = AAZStrArg(
            options=["certificate-store"],
            help="For Windows VMs, specifies the certificate store on the Virtual Machine to which the certificate should be added. The specified certificate store is implicitly in the LocalMachine account. For Linux VMs, the certificate file is placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of these files are .pem formatted.",
        )
        _element.certificate_url = AAZStrArg(
            options=["certificate-url"],
            help="This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  \"data\":\"<Base64-encoded-certificate>\",<br>  \"dataType\":\"pfx\",<br>  \"password\":\"<pfx-file-password>\"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).",
        )

        windows_configuration = cls._args_schema.os_profile.windows_configuration
        windows_configuration.additional_unattend_content = AAZListArg(
            options=["additional-unattend-content"],
            help="Specifies additional base-64 encoded XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup.",
        )
        windows_configuration.enable_automatic_updates = AAZBoolArg(
            options=["enable-automatic-updates"],
            help="Indicates whether Automatic Updates is enabled for the Windows virtual machine. Default value is true. For virtual machine scale sets, this property can be updated and updates will take effect on OS reprovisioning.",
        )
        windows_configuration.patch_settings = AAZObjectArg(
            options=["patch-settings"],
            help="[Preview Feature] Specifies settings related to VM Guest Patching on Windows.",
        )
        windows_configuration.provision_vm_agent = AAZBoolArg(
            options=["provision-vm-agent"],
            help="Indicates whether virtual machine agent should be provisioned on the virtual machine. When this property is not specified in the request body, it is set to true by default. This will ensure that VM Agent is installed on the VM so that extensions can be added to the VM later.",
        )
        windows_configuration.time_zone = AAZStrArg(
            options=["time-zone"],
            help="Specifies the time zone of the virtual machine. e.g. \"Pacific Standard Time\". Possible values can be [TimeZoneInfo.Id](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id) value from time zones returned by [TimeZoneInfo.GetSystemTimeZones](https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones).",
        )
        windows_configuration.win_rm = AAZObjectArg(
            options=["win-rm"],
            help="Specifies the Windows Remote Management listeners. This enables remote Windows PowerShell.",
        )

        additional_unattend_content = cls._args_schema.os_profile.windows_configuration.additional_unattend_content
        additional_unattend_content.Element = AAZObjectArg()

        _element = cls._args_schema.os_profile.windows_configuration.additional_unattend_content.Element
        _element.component_name = AAZStrArg(
            options=["component-name"],
            help="The component name. Currently, the only allowable value is Microsoft-Windows-Shell-Setup.",
            enum={"Microsoft-Windows-Shell-Setup": "Microsoft-Windows-Shell-Setup"},
        )
        _element.content = AAZStrArg(
            options=["content"],
            help="Specifies the XML formatted content that is added to the unattend.xml file for the specified path and component. The XML must be less than 4KB and must include the root element for the setting or feature that is being inserted.",
        )
        _element.pass_name = AAZStrArg(
            options=["pass-name"],
            help="The pass name. Currently, the only allowable value is OobeSystem.",
            enum={"OobeSystem": "OobeSystem"},
        )
        _element.setting_name = AAZStrArg(
            options=["setting-name"],
            help="Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.",
            enum={"AutoLogon": "AutoLogon", "FirstLogonCommands": "FirstLogonCommands"},
        )

        patch_settings = cls._args_schema.os_profile.windows_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrArg(
            options=["assessment-mode"],
            help="Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine.<br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.",
            enum={"AutomaticByPlatform": "AutomaticByPlatform", "ImageDefault": "ImageDefault"},
        )
        patch_settings.automatic_by_platform_settings = AAZObjectArg(
            options=["automatic-by-platform-settings"],
            help="Specifies additional settings for patch mode AutomaticByPlatform in VM Guest Patching on Windows.",
        )
        patch_settings.enable_hotpatching = AAZBoolArg(
            options=["enable-hotpatching"],
            help="Enables customers to patch their Azure VMs without requiring a reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must be set to 'AutomaticByPlatform'.",
        )
        patch_settings.patch_mode = AAZStrArg(
            options=["patch-mode"],
            help="Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **Manual** - You  control the application of patches to a virtual machine. You do this by applying patches manually inside the VM. In this mode, automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates must be false<br /><br /> **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property WindowsConfiguration.enableAutomaticUpdates must be true. <br /><br /> **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true",
            enum={"AutomaticByOS": "AutomaticByOS", "AutomaticByPlatform": "AutomaticByPlatform", "Manual": "Manual"},
        )

        automatic_by_platform_settings = cls._args_schema.os_profile.windows_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolArg(
            options=["bypass-platform-safety-checks-on-user-schedule"],
            help="Enables customer to schedule patching without accidental upgrades",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrArg(
            options=["reboot-setting"],
            help="Specifies the reboot setting for all AutomaticByPlatform patch installation operations.",
            enum={"Always": "Always", "IfRequired": "IfRequired", "Never": "Never", "Unknown": "Unknown"},
        )

        win_rm = cls._args_schema.os_profile.windows_configuration.win_rm
        win_rm.listeners = AAZListArg(
            options=["listeners"],
            help="The list of Windows Remote Management listeners",
        )

        listeners = cls._args_schema.os_profile.windows_configuration.win_rm.listeners
        listeners.Element = AAZObjectArg()

        _element = cls._args_schema.os_profile.windows_configuration.win_rm.listeners.Element
        _element.certificate_url = AAZStrArg(
            options=["certificate-url"],
            help="This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a secret to the Key Vault, see [Add a key or secret to the key vault](https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add). In this case, your certificate needs to be the Base64 encoding of the following JSON Object which is encoded in UTF-8: <br><br> {<br>  \"data\":\"<Base64-encoded-certificate>\",<br>  \"dataType\":\"pfx\",<br>  \"password\":\"<pfx-file-password>\"<br>} <br> To install certificates on a virtual machine it is recommended to use the [Azure Key Vault virtual machine extension for Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux) or the [Azure Key Vault virtual machine extension for Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Specifies the protocol of WinRM listener. Possible values are: **http,** **https.**",
            enum={"Http": "Http", "Https": "Https"},
        )

        protection_policy = cls._args_schema.protection_policy
        protection_policy.protect_from_scale_in = AAZBoolArg(
            options=["protect-from-scale-in"],
            help="Indicates that the virtual machine scale set VM shouldn't be considered for deletion during a scale-in operation.",
        )
        protection_policy.protect_from_scale_set_actions = AAZBoolArg(
            options=["protect-from-scale-set-actions"],
            help="Indicates that model updates or actions (including scale-in) initiated on the virtual machine scale set should not be applied to the virtual machine scale set VM.",
        )

        security_profile = cls._args_schema.security_profile
        security_profile.encryption_at_host = AAZBoolArg(
            options=["encryption-at-host"],
            help="This property can be used by user in the request to enable or disable the Host Encryption for the virtual machine or virtual machine scale set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. The default behavior is: The Encryption at host will be disabled unless this property is set to true for the resource.",
        )
        security_profile.encryption_identity = AAZObjectArg(
            options=["encryption-identity"],
            help="Specifies the Managed Identity used by ADE to get access token for keyvault operations.",
        )
        security_profile.proxy_agent_settings = AAZObjectArg(
            options=["proxy-agent-settings"],
            help="Specifies ProxyAgent settings while creating the virtual machine. Minimum api-version: 2023-09-01.",
        )
        security_profile.security_type = AAZStrArg(
            options=["security-type"],
            help="Specifies the SecurityType of the virtual machine. It has to be set to any specified value to enable UefiSettings. The default behavior is: UefiSettings will not be enabled unless this property is set.",
            enum={"ConfidentialVM": "ConfidentialVM", "TrustedLaunch": "TrustedLaunch"},
        )
        security_profile.uefi_settings = AAZObjectArg(
            options=["uefi-settings"],
            help="Specifies the security settings like secure boot and vTPM used while creating the virtual machine. Minimum api-version: 2020-12-01.",
        )

        encryption_identity = cls._args_schema.security_profile.encryption_identity
        encryption_identity.user_assigned_identity_resource_id = AAZStrArg(
            options=["user-assigned-identity-resource-id"],
            help="Specifies ARM Resource ID of one of the user identities associated with the VM.",
        )

        proxy_agent_settings = cls._args_schema.security_profile.proxy_agent_settings
        proxy_agent_settings.add_proxy_agent_extension = AAZBoolArg(
            options=["add-proxy-agent-extension"],
            help="Specify whether to implicitly install the ProxyAgent Extension. This option is currently applicable only for Linux Os.",
        )
        proxy_agent_settings.enabled = AAZBoolArg(
            options=["enabled"],
            help="Specifies whether ProxyAgent feature should be enabled on the virtual machine or virtual machine scale set.",
        )
        proxy_agent_settings.imds = AAZObjectArg(
            options=["imds"],
            help="Specifies the IMDS endpoint settings while creating the virtual machine or virtual machine scale set. Minimum api-version: 2024-03-01.",
        )
        cls._build_args_host_endpoint_settings_create(proxy_agent_settings.imds)
        proxy_agent_settings.key_incarnation_id = AAZIntArg(
            options=["key-incarnation-id"],
            help="Increase the value of this property allows users to reset the key used for securing communication channel between guest and host.",
        )
        proxy_agent_settings.mode = AAZStrArg(
            options=["mode"],
            help="Specifies the mode that ProxyAgent will execute on. Warning: this property has been deprecated, please specify 'mode' under particular hostendpoint setting.",
            enum={"Audit": "Audit", "Enforce": "Enforce"},
        )
        proxy_agent_settings.wire_server = AAZObjectArg(
            options=["wire-server"],
            help="Specifies the Wire Server endpoint settings while creating the virtual machine or virtual machine scale set. Minimum api-version: 2024-03-01.",
        )
        cls._build_args_host_endpoint_settings_create(proxy_agent_settings.wire_server)

        uefi_settings = cls._args_schema.security_profile.uefi_settings
        uefi_settings.secure_boot_enabled = AAZBoolArg(
            options=["secure-boot-enabled"],
            help="Specifies whether secure boot should be enabled on the virtual machine. Minimum api-version: 2020-12-01.",
        )
        uefi_settings.v_tpm_enabled = AAZBoolArg(
            options=["v-tpm-enabled"],
            help="Specifies whether vTPM should be enabled on the virtual machine. Minimum api-version: 2020-12-01.",
        )

        storage_profile = cls._args_schema.storage_profile
        storage_profile.align_regional_disks_to_vm_zone = AAZBoolArg(
            options=["align-regional-disks-to-vm-zone"],
            help="Specifies whether the regional disks should be aligned/moved to the VM zone. This is applicable only for VMs with placement property set. Please note that this change is irreversible. Minimum api-version: 2024-11-01.",
        )
        storage_profile.data_disks = AAZListArg(
            options=["data-disks"],
            help="Specifies the parameters that are used to add a data disk to a virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).",
        )
        storage_profile.disk_controller_type = AAZStrArg(
            options=["disk-controller-type"],
            help="Specifies the disk controller type configured for the VM. **Note:** This property will be set to the default disk controller type if not specified provided virtual machine is being created with 'hyperVGeneration' set to V2 based on the capabilities of the operating system disk and VM size from the the specified minimum api version. You need to deallocate the VM before updating its disk controller type unless you are updating the VM size in the VM configuration which implicitly deallocates and reallocates the VM. Minimum api-version: 2022-08-01.",
            enum={"NVMe": "NVMe", "SCSI": "SCSI"},
        )
        storage_profile.image_reference = AAZObjectArg(
            options=["image-reference"],
            help="Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations.",
        )
        storage_profile.os_disk = AAZObjectArg(
            options=["os-disk"],
            help="Specifies information about the operating system disk used by the virtual machine. For more information about disks, see [About disks and VHDs for Azure virtual machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).",
        )

        data_disks = cls._args_schema.storage_profile.data_disks
        data_disks.Element = AAZObjectArg()

        _element = cls._args_schema.storage_profile.data_disks.Element
        _element.caching = AAZStrArg(
            options=["caching"],
            help="Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**",
            enum={"None": "None", "ReadOnly": "ReadOnly", "ReadWrite": "ReadWrite"},
        )
        _element.create_option = AAZStrArg(
            options=["create-option"],
            help="Specifies how the virtual machine disk should be created. Possible values are **Attach:** This value is used when you are using a specialized disk to create the virtual machine. **FromImage:** This value is used when you are using an image to create the virtual machine data disk. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described. **Empty:** This value is used when creating an empty data disk. **Copy:** This value is used to create a data disk from a snapshot or another disk. **Restore:** This value is used to create a data disk from a disk restore point.",
            required=True,
            enum={"Attach": "Attach", "Copy": "Copy", "Empty": "Empty", "FromImage": "FromImage", "Restore": "Restore"},
        )
        _element.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        _element.detach_option = AAZStrArg(
            options=["detach-option"],
            help="Specifies the detach behavior to be used while detaching a disk or which is already in the process of detachment from the virtual machine. Supported values: **ForceDetach.** detachOption: **ForceDetach** is applicable only for managed data disks. If a previous detachment attempt of the data disk did not complete due to an unexpected failure from the virtual machine and the disk is still not released then use force-detach as a last resort option to detach the disk forcibly from the VM. All writes might not have been flushed when using this detach behavior. **This feature is still in preview**. To force-detach a data disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'.",
            enum={"ForceDetach": "ForceDetach"},
        )
        _element.disk_iops_read_write = AAZIntArg(
            options=["disk-iops-read-write"],
            help="Specifies the Read-Write IOPS for the managed disk when StorageAccountType is UltraSSD_LRS.",
        )
        _element.disk_m_bps_read_write = AAZIntArg(
            options=["disk-m-bps-read-write"],
            help="Specifies the bandwidth in MB per second for the managed disk when StorageAccountType is UltraSSD_LRS.",
        )
        _element.disk_size_gb = AAZIntArg(
            options=["disk-size-gb"],
            help="Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.",
        )
        _element.image = AAZObjectArg(
            options=["image"],
            help="The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.",
        )
        cls._build_args_virtual_hard_disk_create(_element.image)
        _element.lun = AAZIntArg(
            options=["lun"],
            help="Specifies the logical unit number of the data disk. This value is used to identify data disks within the VM and therefore must be unique for each data disk attached to a VM.",
            required=True,
        )
        _element.managed_disk = AAZObjectArg(
            options=["managed-disk"],
            help="The managed disk parameters.",
        )
        cls._build_args_managed_disk_parameters_create(_element.managed_disk)
        _element.name = AAZStrArg(
            options=["name"],
            help="The disk name.",
        )
        _element.source_resource = AAZObjectArg(
            options=["source-resource"],
            help="The source resource identifier. It can be a snapshot, or disk restore point from which to create a disk.",
        )
        cls._build_args_api_entity_reference_create(_element.source_resource)
        _element.to_be_detached = AAZBoolArg(
            options=["to-be-detached"],
            help="Specifies whether the data disk is in process of detachment from the VirtualMachine/VirtualMachineScaleset",
        )
        _element.vhd = AAZObjectArg(
            options=["vhd"],
            help="The virtual hard disk.",
        )
        cls._build_args_virtual_hard_disk_create(_element.vhd)
        _element.write_accelerator_enabled = AAZBoolArg(
            options=["write-accelerator-enabled"],
            help="Specifies whether writeAccelerator should be enabled or disabled on the disk.",
        )

        image_reference = cls._args_schema.storage_profile.image_reference
        image_reference.community_gallery_image_id = AAZStrArg(
            options=["community-gallery-image-id"],
            help="Specified the community gallery image unique id for vm deployment. This can be fetched from community gallery image GET call.",
        )
        image_reference.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )
        image_reference.offer = AAZStrArg(
            options=["offer"],
            help="Specifies the offer of the platform image or marketplace image used to create the virtual machine.",
        )
        image_reference.publisher = AAZStrArg(
            options=["publisher"],
            help="The image publisher.",
        )
        image_reference.shared_gallery_image_id = AAZStrArg(
            options=["shared-gallery-image-id"],
            help="Specified the shared gallery image unique id for vm deployment. This can be fetched from shared gallery image GET call.",
        )
        image_reference.sku = AAZStrArg(
            options=["sku"],
            help="The image SKU.",
        )
        image_reference.version = AAZStrArg(
            options=["version"],
            help="Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available. Please do not use field 'version' for gallery image deployment, gallery image should always use 'id' field for deployment, to use 'latest' version of gallery image, just set '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}' in the 'id' field without version input.",
        )

        os_disk = cls._args_schema.storage_profile.os_disk
        os_disk.caching = AAZStrArg(
            options=["caching"],
            help="Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**",
            enum={"None": "None", "ReadOnly": "ReadOnly", "ReadWrite": "ReadWrite"},
        )
        os_disk.create_option = AAZStrArg(
            options=["create-option"],
            help="Specifies how the virtual machine disk should be created. Possible values are **Attach:** This value is used when you are using a specialized disk to create the virtual machine. **FromImage:** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.",
            required=True,
            enum={"Attach": "Attach", "Copy": "Copy", "Empty": "Empty", "FromImage": "FromImage", "Restore": "Restore"},
        )
        os_disk.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specifies whether OS Disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If this value is used, the OS disk is deleted when VM is deleted. **Detach.** If this value is used, the os disk is retained after VM is deleted. The default value is set to **Detach**. For an ephemeral OS Disk, the default value is set to **Delete**. The user cannot change the delete option for an ephemeral OS Disk.",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        os_disk.diff_disk_settings = AAZObjectArg(
            options=["diff-disk-settings"],
            help="Specifies the ephemeral Disk Settings for the operating system disk used by the virtual machine.",
        )
        os_disk.disk_size_gb = AAZIntArg(
            options=["disk-size-gb"],
            help="Specifies the size of an empty data disk in gigabytes. This element can be used to overwrite the size of the disk in a virtual machine image. The property 'diskSizeGB' is the number of bytes x 1024^3 for the disk and the value cannot be larger than 1023.",
        )
        os_disk.encryption_settings = AAZObjectArg(
            options=["encryption-settings"],
            help="Specifies the encryption settings for the OS Disk. Minimum api-version: 2015-06-15.",
        )
        os_disk.image = AAZObjectArg(
            options=["image"],
            help="The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.",
        )
        cls._build_args_virtual_hard_disk_create(os_disk.image)
        os_disk.managed_disk = AAZObjectArg(
            options=["managed-disk"],
            help="The managed disk parameters.",
        )
        cls._build_args_managed_disk_parameters_create(os_disk.managed_disk)
        os_disk.name = AAZStrArg(
            options=["name"],
            help="The disk name.",
        )
        os_disk.os_type = AAZStrArg(
            options=["os-type"],
            help="This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**",
            enum={"Linux": "Linux", "Windows": "Windows"},
        )
        os_disk.vhd = AAZObjectArg(
            options=["vhd"],
            help="The virtual hard disk.",
        )
        cls._build_args_virtual_hard_disk_create(os_disk.vhd)
        os_disk.write_accelerator_enabled = AAZBoolArg(
            options=["write-accelerator-enabled"],
            help="Specifies whether writeAccelerator should be enabled or disabled on the disk.",
        )

        diff_disk_settings = cls._args_schema.storage_profile.os_disk.diff_disk_settings
        diff_disk_settings.option = AAZStrArg(
            options=["option"],
            help="Specifies the ephemeral disk settings for operating system disk.",
            enum={"Local": "Local"},
        )
        diff_disk_settings.placement = AAZStrArg(
            options=["placement"],
            help="Specifies the ephemeral disk placement for operating system disk. Possible values are: **CacheDisk,** **ResourceDisk,** **NvmeDisk.** The defaulting behavior is: **CacheDisk** if one is configured for the VM size otherwise **ResourceDisk** or **NvmeDisk** is used. Refer to the VM size documentation for Windows VM at https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a cache disk. Minimum api-version for NvmeDisk: 2024-03-01.",
            enum={"CacheDisk": "CacheDisk", "NvmeDisk": "NvmeDisk", "ResourceDisk": "ResourceDisk"},
        )

        encryption_settings = cls._args_schema.storage_profile.os_disk.encryption_settings
        encryption_settings.disk_encryption_key = AAZObjectArg(
            options=["disk-encryption-key"],
            help="Specifies the location of the disk encryption key, which is a Key Vault Secret.",
        )
        encryption_settings.enabled = AAZBoolArg(
            options=["enabled"],
            help="Specifies whether disk encryption should be enabled on the virtual machine.",
        )
        encryption_settings.key_encryption_key = AAZObjectArg(
            options=["key-encryption-key"],
            help="Specifies the location of the key encryption key in Key Vault.",
        )

        disk_encryption_key = cls._args_schema.storage_profile.os_disk.encryption_settings.disk_encryption_key
        disk_encryption_key.secret_url = AAZStrArg(
            options=["secret-url"],
            help="The URL referencing a secret in a Key Vault.",
            required=True,
        )
        disk_encryption_key.source_vault = AAZObjectArg(
            options=["source-vault"],
            help="The relative URL of the Key Vault containing the secret.",
            required=True,
        )
        cls._build_args_sub_resource_create(disk_encryption_key.source_vault)

        key_encryption_key = cls._args_schema.storage_profile.os_disk.encryption_settings.key_encryption_key
        key_encryption_key.key_url = AAZStrArg(
            options=["key-url"],
            help="The URL referencing a key encryption key in Key Vault.",
            required=True,
        )
        key_encryption_key.source_vault = AAZObjectArg(
            options=["source-vault"],
            help="The relative URL of the Key Vault containing the key.",
            required=True,
        )
        cls._build_args_sub_resource_create(key_encryption_key.source_vault)
        return cls._args_schema

    _args_api_entity_reference_create = None

    @classmethod
    def _build_args_api_entity_reference_create(cls, _schema):
        if cls._args_api_entity_reference_create is not None:
            _schema.id = cls._args_api_entity_reference_create.id
            return

        cls._args_api_entity_reference_create = AAZObjectArg()

        api_entity_reference_create = cls._args_api_entity_reference_create
        api_entity_reference_create.id = AAZStrArg(
            options=["id"],
            help="The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...",
        )

        _schema.id = cls._args_api_entity_reference_create.id

    _args_disk_encryption_set_parameters_create = None

    @classmethod
    def _build_args_disk_encryption_set_parameters_create(cls, _schema):
        if cls._args_disk_encryption_set_parameters_create is not None:
            _schema.id = cls._args_disk_encryption_set_parameters_create.id
            return

        cls._args_disk_encryption_set_parameters_create = AAZObjectArg()

        disk_encryption_set_parameters_create = cls._args_disk_encryption_set_parameters_create
        disk_encryption_set_parameters_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )

        _schema.id = cls._args_disk_encryption_set_parameters_create.id

    _args_host_endpoint_settings_create = None

    @classmethod
    def _build_args_host_endpoint_settings_create(cls, _schema):
        if cls._args_host_endpoint_settings_create is not None:
            _schema.in_vm_access_control_profile_reference_id = cls._args_host_endpoint_settings_create.in_vm_access_control_profile_reference_id
            _schema.mode = cls._args_host_endpoint_settings_create.mode
            return

        cls._args_host_endpoint_settings_create = AAZObjectArg()

        host_endpoint_settings_create = cls._args_host_endpoint_settings_create
        host_endpoint_settings_create.in_vm_access_control_profile_reference_id = AAZStrArg(
            options=["in-vm-access-control-profile-reference-id"],
            help="Specifies the InVMAccessControlProfileVersion resource id in the format of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{profile}/versions/{version}",
        )
        host_endpoint_settings_create.mode = AAZStrArg(
            options=["mode"],
            help="Specifies the execution mode. In Audit mode, the system acts as if it is enforcing the access control policy, including emitting access denial entries in the logs but it does not actually deny any requests to host endpoints. In Enforce mode, the system will enforce the access control and it is the recommended mode of operation.",
            enum={"Audit": "Audit", "Disabled": "Disabled", "Enforce": "Enforce"},
        )

        _schema.in_vm_access_control_profile_reference_id = cls._args_host_endpoint_settings_create.in_vm_access_control_profile_reference_id
        _schema.mode = cls._args_host_endpoint_settings_create.mode

    _args_managed_disk_parameters_create = None

    @classmethod
    def _build_args_managed_disk_parameters_create(cls, _schema):
        if cls._args_managed_disk_parameters_create is not None:
            _schema.disk_encryption_set = cls._args_managed_disk_parameters_create.disk_encryption_set
            _schema.id = cls._args_managed_disk_parameters_create.id
            _schema.security_profile = cls._args_managed_disk_parameters_create.security_profile
            _schema.storage_account_type = cls._args_managed_disk_parameters_create.storage_account_type
            return

        cls._args_managed_disk_parameters_create = AAZObjectArg()

        managed_disk_parameters_create = cls._args_managed_disk_parameters_create
        managed_disk_parameters_create.disk_encryption_set = AAZObjectArg(
            options=["disk-encryption-set"],
            help="Specifies the customer managed disk encryption set resource id for the managed disk.",
        )
        cls._build_args_disk_encryption_set_parameters_create(managed_disk_parameters_create.disk_encryption_set)
        managed_disk_parameters_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )
        managed_disk_parameters_create.security_profile = AAZObjectArg(
            options=["security-profile"],
            help="Specifies the security profile for the managed disk.",
        )
        managed_disk_parameters_create.storage_account_type = AAZStrArg(
            options=["storage-account-type"],
            help="Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.",
            enum={"PremiumV2_LRS": "PremiumV2_LRS", "Premium_LRS": "Premium_LRS", "Premium_ZRS": "Premium_ZRS", "StandardSSD_LRS": "StandardSSD_LRS", "StandardSSD_ZRS": "StandardSSD_ZRS", "Standard_LRS": "Standard_LRS", "UltraSSD_LRS": "UltraSSD_LRS"},
        )

        security_profile = cls._args_managed_disk_parameters_create.security_profile
        security_profile.disk_encryption_set = AAZObjectArg(
            options=["disk-encryption-set"],
            help="Specifies the customer managed disk encryption set resource id for the managed disk that is used for Customer Managed Key encrypted ConfidentialVM OS Disk and VMGuest blob.",
        )
        cls._build_args_disk_encryption_set_parameters_create(security_profile.disk_encryption_set)
        security_profile.security_encryption_type = AAZStrArg(
            options=["security-encryption-type"],
            help="Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob.. **Note:** It can be set for only Confidential VMs.",
            enum={"DiskWithVMGuestState": "DiskWithVMGuestState", "NonPersistedTPM": "NonPersistedTPM", "VMGuestStateOnly": "VMGuestStateOnly"},
        )

        _schema.disk_encryption_set = cls._args_managed_disk_parameters_create.disk_encryption_set
        _schema.id = cls._args_managed_disk_parameters_create.id
        _schema.security_profile = cls._args_managed_disk_parameters_create.security_profile
        _schema.storage_account_type = cls._args_managed_disk_parameters_create.storage_account_type

    _args_public_ip_address_sku_create = None

    @classmethod
    def _build_args_public_ip_address_sku_create(cls, _schema):
        if cls._args_public_ip_address_sku_create is not None:
            _schema.name = cls._args_public_ip_address_sku_create.name
            _schema.tier = cls._args_public_ip_address_sku_create.tier
            return

        cls._args_public_ip_address_sku_create = AAZObjectArg()

        public_ip_address_sku_create = cls._args_public_ip_address_sku_create
        public_ip_address_sku_create.name = AAZStrArg(
            options=["name"],
            help="Specify public IP sku name",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )
        public_ip_address_sku_create.tier = AAZStrArg(
            options=["tier"],
            help="Specify public IP sku tier",
            enum={"Global": "Global", "Regional": "Regional"},
        )

        _schema.name = cls._args_public_ip_address_sku_create.name
        _schema.tier = cls._args_public_ip_address_sku_create.tier

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Id",
        )

        _schema.id = cls._args_sub_resource_create.id

    _args_virtual_hard_disk_create = None

    @classmethod
    def _build_args_virtual_hard_disk_create(cls, _schema):
        if cls._args_virtual_hard_disk_create is not None:
            _schema.uri = cls._args_virtual_hard_disk_create.uri
            return

        cls._args_virtual_hard_disk_create = AAZObjectArg()

        virtual_hard_disk_create = cls._args_virtual_hard_disk_create
        virtual_hard_disk_create.uri = AAZStrArg(
            options=["uri"],
            help="Specifies the virtual hard disk's uri.",
        )

        _schema.uri = cls._args_virtual_hard_disk_create.uri

    def _execute_operations(self):
        self.pre_operations()
        yield self.VirtualMachineScaleSetVMsUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualMachineScaleSetVMsUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "instanceId", self.ctx.args.instance_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "vmScaleSetName", self.ctx.args.vm_scale_set_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-04-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "If-Match", self.ctx.args.if_match,
                ),
                **self.serialize_header_param(
                    "If-None-Match", self.ctx.args.if_none_match,
                ),
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("identity", AAZIdentityObjectType)
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("plan", AAZObjectType, ".plan")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            identity = _builder.get(".identity")
            if identity is not None:
                identity.set_prop("userAssigned", AAZListType, ".mi_user_assigned", typ_kwargs={"flags": {"action": "create"}})
                identity.set_prop("systemAssigned", AAZStrType, ".mi_system_assigned", typ_kwargs={"flags": {"action": "create"}})

            user_assigned = _builder.get(".identity.userAssigned")
            if user_assigned is not None:
                user_assigned.set_elements(AAZStrType, ".")

            plan = _builder.get(".plan")
            if plan is not None:
                plan.set_prop("name", AAZStrType, ".name")
                plan.set_prop("product", AAZStrType, ".product")
                plan.set_prop("promotionCode", AAZStrType, ".promotion_code")
                plan.set_prop("publisher", AAZStrType, ".publisher")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("additionalCapabilities", AAZObjectType, ".additional_capabilities")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("availabilitySet", AAZObjectType, ".availability_set"))
                properties.set_prop("diagnosticsProfile", AAZObjectType, ".diagnostics_profile")
                properties.set_prop("hardwareProfile", AAZObjectType, ".hardware_profile")
                properties.set_prop("licenseType", AAZStrType, ".license_type")
                properties.set_prop("networkProfile", AAZObjectType, ".network_profile")
                properties.set_prop("networkProfileConfiguration", AAZObjectType, ".network_profile_configuration")
                properties.set_prop("osProfile", AAZObjectType, ".os_profile")
                properties.set_prop("protectionPolicy", AAZObjectType, ".protection_policy")
                properties.set_prop("resilientVMDeletionStatus", AAZStrType, ".resilient_vm_deletion_status")
                properties.set_prop("securityProfile", AAZObjectType, ".security_profile")
                properties.set_prop("storageProfile", AAZObjectType, ".storage_profile")
                properties.set_prop("userData", AAZStrType, ".user_data")

            additional_capabilities = _builder.get(".properties.additionalCapabilities")
            if additional_capabilities is not None:
                additional_capabilities.set_prop("enableFips1403Encryption", AAZBoolType, ".enable_fips1403_encryption")
                additional_capabilities.set_prop("hibernationEnabled", AAZBoolType, ".hibernation_enabled")
                additional_capabilities.set_prop("ultraSSDEnabled", AAZBoolType, ".ultra_ssd_enabled")

            diagnostics_profile = _builder.get(".properties.diagnosticsProfile")
            if diagnostics_profile is not None:
                diagnostics_profile.set_prop("bootDiagnostics", AAZObjectType, ".boot_diagnostics")

            boot_diagnostics = _builder.get(".properties.diagnosticsProfile.bootDiagnostics")
            if boot_diagnostics is not None:
                boot_diagnostics.set_prop("enabled", AAZBoolType, ".enabled")
                boot_diagnostics.set_prop("storageUri", AAZStrType, ".storage_uri")

            hardware_profile = _builder.get(".properties.hardwareProfile")
            if hardware_profile is not None:
                hardware_profile.set_prop("vmSize", AAZStrType, ".vm_size")
                hardware_profile.set_prop("vmSizeProperties", AAZObjectType, ".vm_size_properties")

            vm_size_properties = _builder.get(".properties.hardwareProfile.vmSizeProperties")
            if vm_size_properties is not None:
                vm_size_properties.set_prop("vCPUsAvailable", AAZIntType, ".v_cp_us_available")
                vm_size_properties.set_prop("vCPUsPerCore", AAZIntType, ".v_cp_us_per_core")

            network_profile = _builder.get(".properties.networkProfile")
            if network_profile is not None:
                network_profile.set_prop("networkApiVersion", AAZStrType, ".network_api_version")
                network_profile.set_prop("networkInterfaceConfigurations", AAZListType, ".network_interface_configurations")
                network_profile.set_prop("networkInterfaces", AAZListType, ".network_interfaces")

            network_interface_configurations = _builder.get(".properties.networkProfile.networkInterfaceConfigurations")
            if network_interface_configurations is not None:
                network_interface_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties")
            if properties is not None:
                properties.set_prop("auxiliaryMode", AAZStrType, ".auxiliary_mode")
                properties.set_prop("auxiliarySku", AAZStrType, ".auxiliary_sku")
                properties.set_prop("deleteOption", AAZStrType, ".delete_option")
                properties.set_prop("disableTcpStateTracking", AAZBoolType, ".disable_tcp_state_tracking")
                properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("dscpConfiguration", AAZObjectType, ".dscp_configuration"))
                properties.set_prop("enableAcceleratedNetworking", AAZBoolType, ".enable_accelerated_networking")
                properties.set_prop("enableFpga", AAZBoolType, ".enable_fpga")
                properties.set_prop("enableIPForwarding", AAZBoolType, ".enable_ip_forwarding")
                properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group"))
                properties.set_prop("primary", AAZBoolType, ".primary")

            dns_settings = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.dnsSettings")
            if dns_settings is not None:
                dns_settings.set_prop("dnsServers", AAZListType, ".dns_servers")

            dns_servers = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.dnsSettings.dnsServers")
            if dns_servers is not None:
                dns_servers.set_elements(AAZStrType, ".")

            ip_configurations = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations")
            if ip_configurations is not None:
                ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties")
            if properties is not None:
                properties.set_prop("applicationGatewayBackendAddressPools", AAZListType, ".application_gateway_backend_address_pools")
                properties.set_prop("applicationSecurityGroups", AAZListType, ".application_security_groups")
                properties.set_prop("loadBalancerBackendAddressPools", AAZListType, ".load_balancer_backend_address_pools")
                properties.set_prop("primary", AAZBoolType, ".primary")
                properties.set_prop("privateIPAddressVersion", AAZStrType, ".private_ip_address_version")
                properties.set_prop("publicIPAddressConfiguration", AAZObjectType, ".public_ip_address_configuration")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

            application_gateway_backend_address_pools = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools")
            if application_gateway_backend_address_pools is not None:
                _CreateHelper._build_schema_sub_resource_create(application_gateway_backend_address_pools.set_elements(AAZObjectType, "."))

            application_security_groups = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.applicationSecurityGroups")
            if application_security_groups is not None:
                _CreateHelper._build_schema_sub_resource_create(application_security_groups.set_elements(AAZObjectType, "."))

            load_balancer_backend_address_pools = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.loadBalancerBackendAddressPools")
            if load_balancer_backend_address_pools is not None:
                _CreateHelper._build_schema_sub_resource_create(load_balancer_backend_address_pools.set_elements(AAZObjectType, "."))

            public_ip_address_configuration = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration")
            if public_ip_address_configuration is not None:
                public_ip_address_configuration.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                public_ip_address_configuration.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _CreateHelper._build_schema_public_ip_address_sku_create(public_ip_address_configuration.set_prop("sku", AAZObjectType, ".sku"))
                public_ip_address_configuration.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties")
            if properties is not None:
                properties.set_prop("deleteOption", AAZStrType, ".delete_option")
                properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("ipTags", AAZListType, ".ip_tags")
                properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
                properties.set_prop("publicIPAllocationMethod", AAZStrType, ".public_ip_allocation_method")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))

            dns_settings = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.dnsSettings")
            if dns_settings is not None:
                dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label", typ_kwargs={"flags": {"required": True}})
                dns_settings.set_prop("domainNameLabelScope", AAZStrType, ".domain_name_label_scope")

            ip_tags = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.ipTags")
            if ip_tags is not None:
                ip_tags.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.ipTags[]")
            if _elements is not None:
                _elements.set_prop("ipTagType", AAZStrType, ".ip_tag_type")
                _elements.set_prop("tag", AAZStrType, ".tag")

            tags = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            tags = _builder.get(".properties.networkProfile.networkInterfaceConfigurations[].tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            network_interfaces = _builder.get(".properties.networkProfile.networkInterfaces")
            if network_interfaces is not None:
                network_interfaces.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkProfile.networkInterfaces[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.networkProfile.networkInterfaces[].properties")
            if properties is not None:
                properties.set_prop("deleteOption", AAZStrType, ".delete_option")
                properties.set_prop("primary", AAZBoolType, ".primary")

            network_profile_configuration = _builder.get(".properties.networkProfileConfiguration")
            if network_profile_configuration is not None:
                network_profile_configuration.set_prop("networkInterfaceConfigurations", AAZListType, ".network_interface_configurations")

            network_interface_configurations = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations")
            if network_interface_configurations is not None:
                network_interface_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties")
            if properties is not None:
                properties.set_prop("auxiliaryMode", AAZStrType, ".auxiliary_mode")
                properties.set_prop("auxiliarySku", AAZStrType, ".auxiliary_sku")
                properties.set_prop("deleteOption", AAZStrType, ".delete_option")
                properties.set_prop("disableTcpStateTracking", AAZBoolType, ".disable_tcp_state_tracking")
                properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
                properties.set_prop("enableAcceleratedNetworking", AAZBoolType, ".enable_accelerated_networking")
                properties.set_prop("enableFpga", AAZBoolType, ".enable_fpga")
                properties.set_prop("enableIPForwarding", AAZBoolType, ".enable_ip_forwarding")
                properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group"))
                properties.set_prop("primary", AAZBoolType, ".primary")

            dns_settings = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.dnsSettings")
            if dns_settings is not None:
                dns_settings.set_prop("dnsServers", AAZListType, ".dns_servers")

            dns_servers = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.dnsSettings.dnsServers")
            if dns_servers is not None:
                dns_servers.set_elements(AAZStrType, ".")

            ip_configurations = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations")
            if ip_configurations is not None:
                ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties")
            if properties is not None:
                properties.set_prop("applicationGatewayBackendAddressPools", AAZListType, ".application_gateway_backend_address_pools")
                properties.set_prop("applicationSecurityGroups", AAZListType, ".application_security_groups")
                properties.set_prop("loadBalancerBackendAddressPools", AAZListType, ".load_balancer_backend_address_pools")
                properties.set_prop("loadBalancerInboundNatPools", AAZListType, ".load_balancer_inbound_nat_pools")
                properties.set_prop("primary", AAZBoolType, ".primary")
                properties.set_prop("privateIPAddressVersion", AAZStrType, ".private_ip_address_version")
                properties.set_prop("publicIPAddressConfiguration", AAZObjectType, ".public_ip_address_configuration")
                _CreateHelper._build_schema_api_entity_reference_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

            application_gateway_backend_address_pools = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.applicationGatewayBackendAddressPools")
            if application_gateway_backend_address_pools is not None:
                _CreateHelper._build_schema_sub_resource_create(application_gateway_backend_address_pools.set_elements(AAZObjectType, "."))

            application_security_groups = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.applicationSecurityGroups")
            if application_security_groups is not None:
                _CreateHelper._build_schema_sub_resource_create(application_security_groups.set_elements(AAZObjectType, "."))

            load_balancer_backend_address_pools = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.loadBalancerBackendAddressPools")
            if load_balancer_backend_address_pools is not None:
                _CreateHelper._build_schema_sub_resource_create(load_balancer_backend_address_pools.set_elements(AAZObjectType, "."))

            load_balancer_inbound_nat_pools = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.loadBalancerInboundNatPools")
            if load_balancer_inbound_nat_pools is not None:
                _CreateHelper._build_schema_sub_resource_create(load_balancer_inbound_nat_pools.set_elements(AAZObjectType, "."))

            public_ip_address_configuration = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration")
            if public_ip_address_configuration is not None:
                public_ip_address_configuration.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                public_ip_address_configuration.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _CreateHelper._build_schema_public_ip_address_sku_create(public_ip_address_configuration.set_prop("sku", AAZObjectType, ".sku"))
                public_ip_address_configuration.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties")
            if properties is not None:
                properties.set_prop("deleteOption", AAZStrType, ".delete_option")
                properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("ipTags", AAZListType, ".ip_tags")
                properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))

            dns_settings = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.dnsSettings")
            if dns_settings is not None:
                dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label", typ_kwargs={"flags": {"required": True}})
                dns_settings.set_prop("domainNameLabelScope", AAZStrType, ".domain_name_label_scope")

            ip_tags = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.ipTags")
            if ip_tags is not None:
                ip_tags.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.properties.ipTags[]")
            if _elements is not None:
                _elements.set_prop("ipTagType", AAZStrType, ".ip_tag_type")
                _elements.set_prop("tag", AAZStrType, ".tag")

            tags = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].properties.ipConfigurations[].properties.publicIPAddressConfiguration.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            tags = _builder.get(".properties.networkProfileConfiguration.networkInterfaceConfigurations[].tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            os_profile = _builder.get(".properties.osProfile")
            if os_profile is not None:
                os_profile.set_prop("adminPassword", AAZStrType, ".admin_password", typ_kwargs={"flags": {"secret": True}})
                os_profile.set_prop("adminUsername", AAZStrType, ".admin_username")
                os_profile.set_prop("allowExtensionOperations", AAZBoolType, ".allow_extension_operations")
                os_profile.set_prop("computerName", AAZStrType, ".computer_name")
                os_profile.set_prop("customData", AAZStrType, ".custom_data")
                os_profile.set_prop("linuxConfiguration", AAZObjectType, ".linux_configuration")
                os_profile.set_prop("requireGuestProvisionSignal", AAZBoolType, ".require_guest_provision_signal")
                os_profile.set_prop("secrets", AAZListType, ".secrets")
                os_profile.set_prop("windowsConfiguration", AAZObjectType, ".windows_configuration")

            linux_configuration = _builder.get(".properties.osProfile.linuxConfiguration")
            if linux_configuration is not None:
                linux_configuration.set_prop("disablePasswordAuthentication", AAZBoolType, ".disable_password_authentication")
                linux_configuration.set_prop("enableVMAgentPlatformUpdates", AAZBoolType, ".enable_vm_agent_platform_updates")
                linux_configuration.set_prop("patchSettings", AAZObjectType, ".patch_settings")
                linux_configuration.set_prop("provisionVMAgent", AAZBoolType, ".provision_vm_agent")
                linux_configuration.set_prop("ssh", AAZObjectType, ".ssh")

            patch_settings = _builder.get(".properties.osProfile.linuxConfiguration.patchSettings")
            if patch_settings is not None:
                patch_settings.set_prop("assessmentMode", AAZStrType, ".assessment_mode")
                patch_settings.set_prop("automaticByPlatformSettings", AAZObjectType, ".automatic_by_platform_settings")
                patch_settings.set_prop("patchMode", AAZStrType, ".patch_mode")

            automatic_by_platform_settings = _builder.get(".properties.osProfile.linuxConfiguration.patchSettings.automaticByPlatformSettings")
            if automatic_by_platform_settings is not None:
                automatic_by_platform_settings.set_prop("bypassPlatformSafetyChecksOnUserSchedule", AAZBoolType, ".bypass_platform_safety_checks_on_user_schedule")
                automatic_by_platform_settings.set_prop("rebootSetting", AAZStrType, ".reboot_setting")

            ssh = _builder.get(".properties.osProfile.linuxConfiguration.ssh")
            if ssh is not None:
                ssh.set_prop("publicKeys", AAZListType, ".public_keys")

            public_keys = _builder.get(".properties.osProfile.linuxConfiguration.ssh.publicKeys")
            if public_keys is not None:
                public_keys.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.osProfile.linuxConfiguration.ssh.publicKeys[]")
            if _elements is not None:
                _elements.set_prop("keyData", AAZStrType, ".key_data")
                _elements.set_prop("path", AAZStrType, ".path")

            secrets = _builder.get(".properties.osProfile.secrets")
            if secrets is not None:
                secrets.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.osProfile.secrets[]")
            if _elements is not None:
                _CreateHelper._build_schema_sub_resource_create(_elements.set_prop("sourceVault", AAZObjectType, ".source_vault"))
                _elements.set_prop("vaultCertificates", AAZListType, ".vault_certificates")

            vault_certificates = _builder.get(".properties.osProfile.secrets[].vaultCertificates")
            if vault_certificates is not None:
                vault_certificates.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.osProfile.secrets[].vaultCertificates[]")
            if _elements is not None:
                _elements.set_prop("certificateStore", AAZStrType, ".certificate_store")
                _elements.set_prop("certificateUrl", AAZStrType, ".certificate_url")

            windows_configuration = _builder.get(".properties.osProfile.windowsConfiguration")
            if windows_configuration is not None:
                windows_configuration.set_prop("additionalUnattendContent", AAZListType, ".additional_unattend_content")
                windows_configuration.set_prop("enableAutomaticUpdates", AAZBoolType, ".enable_automatic_updates")
                windows_configuration.set_prop("patchSettings", AAZObjectType, ".patch_settings")
                windows_configuration.set_prop("provisionVMAgent", AAZBoolType, ".provision_vm_agent")
                windows_configuration.set_prop("timeZone", AAZStrType, ".time_zone")
                windows_configuration.set_prop("winRM", AAZObjectType, ".win_rm")

            additional_unattend_content = _builder.get(".properties.osProfile.windowsConfiguration.additionalUnattendContent")
            if additional_unattend_content is not None:
                additional_unattend_content.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.osProfile.windowsConfiguration.additionalUnattendContent[]")
            if _elements is not None:
                _elements.set_prop("componentName", AAZStrType, ".component_name")
                _elements.set_prop("content", AAZStrType, ".content")
                _elements.set_prop("passName", AAZStrType, ".pass_name")
                _elements.set_prop("settingName", AAZStrType, ".setting_name")

            patch_settings = _builder.get(".properties.osProfile.windowsConfiguration.patchSettings")
            if patch_settings is not None:
                patch_settings.set_prop("assessmentMode", AAZStrType, ".assessment_mode")
                patch_settings.set_prop("automaticByPlatformSettings", AAZObjectType, ".automatic_by_platform_settings")
                patch_settings.set_prop("enableHotpatching", AAZBoolType, ".enable_hotpatching")
                patch_settings.set_prop("patchMode", AAZStrType, ".patch_mode")

            automatic_by_platform_settings = _builder.get(".properties.osProfile.windowsConfiguration.patchSettings.automaticByPlatformSettings")
            if automatic_by_platform_settings is not None:
                automatic_by_platform_settings.set_prop("bypassPlatformSafetyChecksOnUserSchedule", AAZBoolType, ".bypass_platform_safety_checks_on_user_schedule")
                automatic_by_platform_settings.set_prop("rebootSetting", AAZStrType, ".reboot_setting")

            win_rm = _builder.get(".properties.osProfile.windowsConfiguration.winRM")
            if win_rm is not None:
                win_rm.set_prop("listeners", AAZListType, ".listeners")

            listeners = _builder.get(".properties.osProfile.windowsConfiguration.winRM.listeners")
            if listeners is not None:
                listeners.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.osProfile.windowsConfiguration.winRM.listeners[]")
            if _elements is not None:
                _elements.set_prop("certificateUrl", AAZStrType, ".certificate_url")
                _elements.set_prop("protocol", AAZStrType, ".protocol")

            protection_policy = _builder.get(".properties.protectionPolicy")
            if protection_policy is not None:
                protection_policy.set_prop("protectFromScaleIn", AAZBoolType, ".protect_from_scale_in")
                protection_policy.set_prop("protectFromScaleSetActions", AAZBoolType, ".protect_from_scale_set_actions")

            security_profile = _builder.get(".properties.securityProfile")
            if security_profile is not None:
                security_profile.set_prop("encryptionAtHost", AAZBoolType, ".encryption_at_host")
                security_profile.set_prop("encryptionIdentity", AAZObjectType, ".encryption_identity")
                security_profile.set_prop("proxyAgentSettings", AAZObjectType, ".proxy_agent_settings")
                security_profile.set_prop("securityType", AAZStrType, ".security_type")
                security_profile.set_prop("uefiSettings", AAZObjectType, ".uefi_settings")

            encryption_identity = _builder.get(".properties.securityProfile.encryptionIdentity")
            if encryption_identity is not None:
                encryption_identity.set_prop("userAssignedIdentityResourceId", AAZStrType, ".user_assigned_identity_resource_id")

            proxy_agent_settings = _builder.get(".properties.securityProfile.proxyAgentSettings")
            if proxy_agent_settings is not None:
                proxy_agent_settings.set_prop("addProxyAgentExtension", AAZBoolType, ".add_proxy_agent_extension")
                proxy_agent_settings.set_prop("enabled", AAZBoolType, ".enabled")
                _CreateHelper._build_schema_host_endpoint_settings_create(proxy_agent_settings.set_prop("imds", AAZObjectType, ".imds"))
                proxy_agent_settings.set_prop("keyIncarnationId", AAZIntType, ".key_incarnation_id")
                proxy_agent_settings.set_prop("mode", AAZStrType, ".mode")
                _CreateHelper._build_schema_host_endpoint_settings_create(proxy_agent_settings.set_prop("wireServer", AAZObjectType, ".wire_server"))

            uefi_settings = _builder.get(".properties.securityProfile.uefiSettings")
            if uefi_settings is not None:
                uefi_settings.set_prop("secureBootEnabled", AAZBoolType, ".secure_boot_enabled")
                uefi_settings.set_prop("vTpmEnabled", AAZBoolType, ".v_tpm_enabled")

            storage_profile = _builder.get(".properties.storageProfile")
            if storage_profile is not None:
                storage_profile.set_prop("alignRegionalDisksToVMZone", AAZBoolType, ".align_regional_disks_to_vm_zone")
                storage_profile.set_prop("dataDisks", AAZListType, ".data_disks")
                storage_profile.set_prop("diskControllerType", AAZStrType, ".disk_controller_type")
                storage_profile.set_prop("imageReference", AAZObjectType, ".image_reference")
                storage_profile.set_prop("osDisk", AAZObjectType, ".os_disk")

            data_disks = _builder.get(".properties.storageProfile.dataDisks")
            if data_disks is not None:
                data_disks.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.storageProfile.dataDisks[]")
            if _elements is not None:
                _elements.set_prop("caching", AAZStrType, ".caching")
                _elements.set_prop("createOption", AAZStrType, ".create_option", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("deleteOption", AAZStrType, ".delete_option")
                _elements.set_prop("detachOption", AAZStrType, ".detach_option")
                _elements.set_prop("diskIOPSReadWrite", AAZIntType, ".disk_iops_read_write")
                _elements.set_prop("diskMBpsReadWrite", AAZIntType, ".disk_m_bps_read_write")
                _elements.set_prop("diskSizeGB", AAZIntType, ".disk_size_gb")
                _CreateHelper._build_schema_virtual_hard_disk_create(_elements.set_prop("image", AAZObjectType, ".image"))
                _elements.set_prop("lun", AAZIntType, ".lun", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_managed_disk_parameters_create(_elements.set_prop("managedDisk", AAZObjectType, ".managed_disk"))
                _elements.set_prop("name", AAZStrType, ".name")
                _CreateHelper._build_schema_api_entity_reference_create(_elements.set_prop("sourceResource", AAZObjectType, ".source_resource"))
                _elements.set_prop("toBeDetached", AAZBoolType, ".to_be_detached")
                _CreateHelper._build_schema_virtual_hard_disk_create(_elements.set_prop("vhd", AAZObjectType, ".vhd"))
                _elements.set_prop("writeAcceleratorEnabled", AAZBoolType, ".write_accelerator_enabled")

            image_reference = _builder.get(".properties.storageProfile.imageReference")
            if image_reference is not None:
                image_reference.set_prop("communityGalleryImageId", AAZStrType, ".community_gallery_image_id")
                image_reference.set_prop("id", AAZStrType, ".id")
                image_reference.set_prop("offer", AAZStrType, ".offer")
                image_reference.set_prop("publisher", AAZStrType, ".publisher")
                image_reference.set_prop("sharedGalleryImageId", AAZStrType, ".shared_gallery_image_id")
                image_reference.set_prop("sku", AAZStrType, ".sku")
                image_reference.set_prop("version", AAZStrType, ".version")

            os_disk = _builder.get(".properties.storageProfile.osDisk")
            if os_disk is not None:
                os_disk.set_prop("caching", AAZStrType, ".caching")
                os_disk.set_prop("createOption", AAZStrType, ".create_option", typ_kwargs={"flags": {"required": True}})
                os_disk.set_prop("deleteOption", AAZStrType, ".delete_option")
                os_disk.set_prop("diffDiskSettings", AAZObjectType, ".diff_disk_settings")
                os_disk.set_prop("diskSizeGB", AAZIntType, ".disk_size_gb")
                os_disk.set_prop("encryptionSettings", AAZObjectType, ".encryption_settings")
                _CreateHelper._build_schema_virtual_hard_disk_create(os_disk.set_prop("image", AAZObjectType, ".image"))
                _CreateHelper._build_schema_managed_disk_parameters_create(os_disk.set_prop("managedDisk", AAZObjectType, ".managed_disk"))
                os_disk.set_prop("name", AAZStrType, ".name")
                os_disk.set_prop("osType", AAZStrType, ".os_type")
                _CreateHelper._build_schema_virtual_hard_disk_create(os_disk.set_prop("vhd", AAZObjectType, ".vhd"))
                os_disk.set_prop("writeAcceleratorEnabled", AAZBoolType, ".write_accelerator_enabled")

            diff_disk_settings = _builder.get(".properties.storageProfile.osDisk.diffDiskSettings")
            if diff_disk_settings is not None:
                diff_disk_settings.set_prop("option", AAZStrType, ".option")
                diff_disk_settings.set_prop("placement", AAZStrType, ".placement")

            encryption_settings = _builder.get(".properties.storageProfile.osDisk.encryptionSettings")
            if encryption_settings is not None:
                encryption_settings.set_prop("diskEncryptionKey", AAZObjectType, ".disk_encryption_key")
                encryption_settings.set_prop("enabled", AAZBoolType, ".enabled")
                encryption_settings.set_prop("keyEncryptionKey", AAZObjectType, ".key_encryption_key")

            disk_encryption_key = _builder.get(".properties.storageProfile.osDisk.encryptionSettings.diskEncryptionKey")
            if disk_encryption_key is not None:
                disk_encryption_key.set_prop("secretUrl", AAZStrType, ".secret_url", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_sub_resource_create(disk_encryption_key.set_prop("sourceVault", AAZObjectType, ".source_vault", typ_kwargs={"flags": {"required": True}}))

            key_encryption_key = _builder.get(".properties.storageProfile.osDisk.encryptionSettings.keyEncryptionKey")
            if key_encryption_key is not None:
                key_encryption_key.set_prop("keyUrl", AAZStrType, ".key_url", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_sub_resource_create(key_encryption_key.set_prop("sourceVault", AAZObjectType, ".source_vault", typ_kwargs={"flags": {"required": True}}))

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _CreateHelper._build_schema_virtual_machine_scale_set_vm_read(cls._schema_on_200)

            return cls._schema_on_200


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_api_entity_reference_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_disk_encryption_set_parameters_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_host_endpoint_settings_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("inVMAccessControlProfileReferenceId", AAZStrType, ".in_vm_access_control_profile_reference_id")
        _builder.set_prop("mode", AAZStrType, ".mode")

    @classmethod
    def _build_schema_managed_disk_parameters_create(cls, _builder):
        if _builder is None:
            return
        cls._build_schema_disk_encryption_set_parameters_create(_builder.set_prop("diskEncryptionSet", AAZObjectType, ".disk_encryption_set"))
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("securityProfile", AAZObjectType, ".security_profile")
        _builder.set_prop("storageAccountType", AAZStrType, ".storage_account_type")

        security_profile = _builder.get(".securityProfile")
        if security_profile is not None:
            cls._build_schema_disk_encryption_set_parameters_create(security_profile.set_prop("diskEncryptionSet", AAZObjectType, ".disk_encryption_set"))
            security_profile.set_prop("securityEncryptionType", AAZStrType, ".security_encryption_type")

    @classmethod
    def _build_schema_public_ip_address_sku_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("tier", AAZStrType, ".tier")

    @classmethod
    def _build_schema_sub_resource_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_virtual_hard_disk_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("uri", AAZStrType, ".uri")

    _schema_api_entity_reference_read = None

    @classmethod
    def _build_schema_api_entity_reference_read(cls, _schema):
        if cls._schema_api_entity_reference_read is not None:
            _schema.id = cls._schema_api_entity_reference_read.id
            return

        cls._schema_api_entity_reference_read = _schema_api_entity_reference_read = AAZObjectType()

        api_entity_reference_read = _schema_api_entity_reference_read
        api_entity_reference_read.id = AAZStrType()

        _schema.id = cls._schema_api_entity_reference_read.id

    _schema_disk_encryption_set_parameters_read = None

    @classmethod
    def _build_schema_disk_encryption_set_parameters_read(cls, _schema):
        if cls._schema_disk_encryption_set_parameters_read is not None:
            _schema.id = cls._schema_disk_encryption_set_parameters_read.id
            return

        cls._schema_disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read = AAZObjectType()

        disk_encryption_set_parameters_read = _schema_disk_encryption_set_parameters_read
        disk_encryption_set_parameters_read.id = AAZStrType()

        _schema.id = cls._schema_disk_encryption_set_parameters_read.id

    _schema_disk_encryption_settings_read = None

    @classmethod
    def _build_schema_disk_encryption_settings_read(cls, _schema):
        if cls._schema_disk_encryption_settings_read is not None:
            _schema.disk_encryption_key = cls._schema_disk_encryption_settings_read.disk_encryption_key
            _schema.enabled = cls._schema_disk_encryption_settings_read.enabled
            _schema.key_encryption_key = cls._schema_disk_encryption_settings_read.key_encryption_key
            return

        cls._schema_disk_encryption_settings_read = _schema_disk_encryption_settings_read = AAZObjectType()

        disk_encryption_settings_read = _schema_disk_encryption_settings_read
        disk_encryption_settings_read.disk_encryption_key = AAZObjectType(
            serialized_name="diskEncryptionKey",
        )
        cls._build_schema_key_vault_secret_reference_read(disk_encryption_settings_read.disk_encryption_key)
        disk_encryption_settings_read.enabled = AAZBoolType()
        disk_encryption_settings_read.key_encryption_key = AAZObjectType(
            serialized_name="keyEncryptionKey",
        )

        key_encryption_key = _schema_disk_encryption_settings_read.key_encryption_key
        key_encryption_key.key_url = AAZStrType(
            serialized_name="keyUrl",
            flags={"required": True},
        )
        key_encryption_key.source_vault = AAZObjectType(
            serialized_name="sourceVault",
            flags={"required": True},
        )
        cls._build_schema_sub_resource_read(key_encryption_key.source_vault)

        _schema.disk_encryption_key = cls._schema_disk_encryption_settings_read.disk_encryption_key
        _schema.enabled = cls._schema_disk_encryption_settings_read.enabled
        _schema.key_encryption_key = cls._schema_disk_encryption_settings_read.key_encryption_key

    _schema_host_endpoint_settings_read = None

    @classmethod
    def _build_schema_host_endpoint_settings_read(cls, _schema):
        if cls._schema_host_endpoint_settings_read is not None:
            _schema.in_vm_access_control_profile_reference_id = cls._schema_host_endpoint_settings_read.in_vm_access_control_profile_reference_id
            _schema.mode = cls._schema_host_endpoint_settings_read.mode
            return

        cls._schema_host_endpoint_settings_read = _schema_host_endpoint_settings_read = AAZObjectType()

        host_endpoint_settings_read = _schema_host_endpoint_settings_read
        host_endpoint_settings_read.in_vm_access_control_profile_reference_id = AAZStrType(
            serialized_name="inVMAccessControlProfileReferenceId",
        )
        host_endpoint_settings_read.mode = AAZStrType()

        _schema.in_vm_access_control_profile_reference_id = cls._schema_host_endpoint_settings_read.in_vm_access_control_profile_reference_id
        _schema.mode = cls._schema_host_endpoint_settings_read.mode

    _schema_instance_view_status_read = None

    @classmethod
    def _build_schema_instance_view_status_read(cls, _schema):
        if cls._schema_instance_view_status_read is not None:
            _schema.code = cls._schema_instance_view_status_read.code
            _schema.display_status = cls._schema_instance_view_status_read.display_status
            _schema.level = cls._schema_instance_view_status_read.level
            _schema.message = cls._schema_instance_view_status_read.message
            _schema.time = cls._schema_instance_view_status_read.time
            return

        cls._schema_instance_view_status_read = _schema_instance_view_status_read = AAZObjectType()

        instance_view_status_read = _schema_instance_view_status_read
        instance_view_status_read.code = AAZStrType()
        instance_view_status_read.display_status = AAZStrType(
            serialized_name="displayStatus",
        )
        instance_view_status_read.level = AAZStrType()
        instance_view_status_read.message = AAZStrType()
        instance_view_status_read.time = AAZStrType()

        _schema.code = cls._schema_instance_view_status_read.code
        _schema.display_status = cls._schema_instance_view_status_read.display_status
        _schema.level = cls._schema_instance_view_status_read.level
        _schema.message = cls._schema_instance_view_status_read.message
        _schema.time = cls._schema_instance_view_status_read.time

    _schema_key_vault_secret_reference_read = None

    @classmethod
    def _build_schema_key_vault_secret_reference_read(cls, _schema):
        if cls._schema_key_vault_secret_reference_read is not None:
            _schema.secret_url = cls._schema_key_vault_secret_reference_read.secret_url
            _schema.source_vault = cls._schema_key_vault_secret_reference_read.source_vault
            return

        cls._schema_key_vault_secret_reference_read = _schema_key_vault_secret_reference_read = AAZObjectType()

        key_vault_secret_reference_read = _schema_key_vault_secret_reference_read
        key_vault_secret_reference_read.secret_url = AAZStrType(
            serialized_name="secretUrl",
            flags={"required": True},
        )
        key_vault_secret_reference_read.source_vault = AAZObjectType(
            serialized_name="sourceVault",
            flags={"required": True},
        )
        cls._build_schema_sub_resource_read(key_vault_secret_reference_read.source_vault)

        _schema.secret_url = cls._schema_key_vault_secret_reference_read.secret_url
        _schema.source_vault = cls._schema_key_vault_secret_reference_read.source_vault

    _schema_managed_disk_parameters_read = None

    @classmethod
    def _build_schema_managed_disk_parameters_read(cls, _schema):
        if cls._schema_managed_disk_parameters_read is not None:
            _schema.disk_encryption_set = cls._schema_managed_disk_parameters_read.disk_encryption_set
            _schema.id = cls._schema_managed_disk_parameters_read.id
            _schema.security_profile = cls._schema_managed_disk_parameters_read.security_profile
            _schema.storage_account_type = cls._schema_managed_disk_parameters_read.storage_account_type
            return

        cls._schema_managed_disk_parameters_read = _schema_managed_disk_parameters_read = AAZObjectType()

        managed_disk_parameters_read = _schema_managed_disk_parameters_read
        managed_disk_parameters_read.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(managed_disk_parameters_read.disk_encryption_set)
        managed_disk_parameters_read.id = AAZStrType()
        managed_disk_parameters_read.security_profile = AAZObjectType(
            serialized_name="securityProfile",
        )
        managed_disk_parameters_read.storage_account_type = AAZStrType(
            serialized_name="storageAccountType",
        )

        security_profile = _schema_managed_disk_parameters_read.security_profile
        security_profile.disk_encryption_set = AAZObjectType(
            serialized_name="diskEncryptionSet",
        )
        cls._build_schema_disk_encryption_set_parameters_read(security_profile.disk_encryption_set)
        security_profile.security_encryption_type = AAZStrType(
            serialized_name="securityEncryptionType",
        )

        _schema.disk_encryption_set = cls._schema_managed_disk_parameters_read.disk_encryption_set
        _schema.id = cls._schema_managed_disk_parameters_read.id
        _schema.security_profile = cls._schema_managed_disk_parameters_read.security_profile
        _schema.storage_account_type = cls._schema_managed_disk_parameters_read.storage_account_type

    _schema_public_ip_address_sku_read = None

    @classmethod
    def _build_schema_public_ip_address_sku_read(cls, _schema):
        if cls._schema_public_ip_address_sku_read is not None:
            _schema.name = cls._schema_public_ip_address_sku_read.name
            _schema.tier = cls._schema_public_ip_address_sku_read.tier
            return

        cls._schema_public_ip_address_sku_read = _schema_public_ip_address_sku_read = AAZObjectType()

        public_ip_address_sku_read = _schema_public_ip_address_sku_read
        public_ip_address_sku_read.name = AAZStrType()
        public_ip_address_sku_read.tier = AAZStrType()

        _schema.name = cls._schema_public_ip_address_sku_read.name
        _schema.tier = cls._schema_public_ip_address_sku_read.tier

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_system_data_read = None

    @classmethod
    def _build_schema_system_data_read(cls, _schema):
        if cls._schema_system_data_read is not None:
            _schema.created_at = cls._schema_system_data_read.created_at
            _schema.created_by = cls._schema_system_data_read.created_by
            _schema.created_by_type = cls._schema_system_data_read.created_by_type
            _schema.last_modified_at = cls._schema_system_data_read.last_modified_at
            _schema.last_modified_by = cls._schema_system_data_read.last_modified_by
            _schema.last_modified_by_type = cls._schema_system_data_read.last_modified_by_type
            return

        cls._schema_system_data_read = _schema_system_data_read = AAZObjectType(
            flags={"read_only": True}
        )

        system_data_read = _schema_system_data_read
        system_data_read.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data_read.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data_read.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data_read.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data_read.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data_read.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        _schema.created_at = cls._schema_system_data_read.created_at
        _schema.created_by = cls._schema_system_data_read.created_by
        _schema.created_by_type = cls._schema_system_data_read.created_by_type
        _schema.last_modified_at = cls._schema_system_data_read.last_modified_at
        _schema.last_modified_by = cls._schema_system_data_read.last_modified_by
        _schema.last_modified_by_type = cls._schema_system_data_read.last_modified_by_type

    _schema_virtual_hard_disk_read = None

    @classmethod
    def _build_schema_virtual_hard_disk_read(cls, _schema):
        if cls._schema_virtual_hard_disk_read is not None:
            _schema.uri = cls._schema_virtual_hard_disk_read.uri
            return

        cls._schema_virtual_hard_disk_read = _schema_virtual_hard_disk_read = AAZObjectType()

        virtual_hard_disk_read = _schema_virtual_hard_disk_read
        virtual_hard_disk_read.uri = AAZStrType()

        _schema.uri = cls._schema_virtual_hard_disk_read.uri

    _schema_virtual_machine_extension_instance_view_read = None

    @classmethod
    def _build_schema_virtual_machine_extension_instance_view_read(cls, _schema):
        if cls._schema_virtual_machine_extension_instance_view_read is not None:
            _schema.name = cls._schema_virtual_machine_extension_instance_view_read.name
            _schema.statuses = cls._schema_virtual_machine_extension_instance_view_read.statuses
            _schema.substatuses = cls._schema_virtual_machine_extension_instance_view_read.substatuses
            _schema.type = cls._schema_virtual_machine_extension_instance_view_read.type
            _schema.type_handler_version = cls._schema_virtual_machine_extension_instance_view_read.type_handler_version
            return

        cls._schema_virtual_machine_extension_instance_view_read = _schema_virtual_machine_extension_instance_view_read = AAZObjectType()

        virtual_machine_extension_instance_view_read = _schema_virtual_machine_extension_instance_view_read
        virtual_machine_extension_instance_view_read.name = AAZStrType()
        virtual_machine_extension_instance_view_read.statuses = AAZListType()
        virtual_machine_extension_instance_view_read.substatuses = AAZListType()
        virtual_machine_extension_instance_view_read.type = AAZStrType()
        virtual_machine_extension_instance_view_read.type_handler_version = AAZStrType(
            serialized_name="typeHandlerVersion",
        )

        statuses = _schema_virtual_machine_extension_instance_view_read.statuses
        statuses.Element = AAZObjectType()
        cls._build_schema_instance_view_status_read(statuses.Element)

        substatuses = _schema_virtual_machine_extension_instance_view_read.substatuses
        substatuses.Element = AAZObjectType()
        cls._build_schema_instance_view_status_read(substatuses.Element)

        _schema.name = cls._schema_virtual_machine_extension_instance_view_read.name
        _schema.statuses = cls._schema_virtual_machine_extension_instance_view_read.statuses
        _schema.substatuses = cls._schema_virtual_machine_extension_instance_view_read.substatuses
        _schema.type = cls._schema_virtual_machine_extension_instance_view_read.type
        _schema.type_handler_version = cls._schema_virtual_machine_extension_instance_view_read.type_handler_version

    _schema_virtual_machine_scale_set_vm_read = None

    @classmethod
    def _build_schema_virtual_machine_scale_set_vm_read(cls, _schema):
        if cls._schema_virtual_machine_scale_set_vm_read is not None:
            _schema.etag = cls._schema_virtual_machine_scale_set_vm_read.etag
            _schema.id = cls._schema_virtual_machine_scale_set_vm_read.id
            _schema.identity = cls._schema_virtual_machine_scale_set_vm_read.identity
            _schema.instance_id = cls._schema_virtual_machine_scale_set_vm_read.instance_id
            _schema.location = cls._schema_virtual_machine_scale_set_vm_read.location
            _schema.name = cls._schema_virtual_machine_scale_set_vm_read.name
            _schema.plan = cls._schema_virtual_machine_scale_set_vm_read.plan
            _schema.properties = cls._schema_virtual_machine_scale_set_vm_read.properties
            _schema.resources = cls._schema_virtual_machine_scale_set_vm_read.resources
            _schema.sku = cls._schema_virtual_machine_scale_set_vm_read.sku
            _schema.system_data = cls._schema_virtual_machine_scale_set_vm_read.system_data
            _schema.tags = cls._schema_virtual_machine_scale_set_vm_read.tags
            _schema.type = cls._schema_virtual_machine_scale_set_vm_read.type
            _schema.zones = cls._schema_virtual_machine_scale_set_vm_read.zones
            return

        cls._schema_virtual_machine_scale_set_vm_read = _schema_virtual_machine_scale_set_vm_read = AAZObjectType()

        virtual_machine_scale_set_vm_read = _schema_virtual_machine_scale_set_vm_read
        virtual_machine_scale_set_vm_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        virtual_machine_scale_set_vm_read.id = AAZStrType(
            flags={"read_only": True},
        )
        virtual_machine_scale_set_vm_read.identity = AAZIdentityObjectType()
        virtual_machine_scale_set_vm_read.instance_id = AAZStrType(
            serialized_name="instanceId",
            flags={"read_only": True},
        )
        virtual_machine_scale_set_vm_read.location = AAZStrType(
            flags={"required": True},
        )
        virtual_machine_scale_set_vm_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_machine_scale_set_vm_read.plan = AAZObjectType()
        virtual_machine_scale_set_vm_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        virtual_machine_scale_set_vm_read.resources = AAZListType(
            flags={"read_only": True},
        )
        virtual_machine_scale_set_vm_read.sku = AAZObjectType(
            flags={"read_only": True},
        )
        virtual_machine_scale_set_vm_read.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        cls._build_schema_system_data_read(virtual_machine_scale_set_vm_read.system_data)
        virtual_machine_scale_set_vm_read.tags = AAZDictType()
        virtual_machine_scale_set_vm_read.type = AAZStrType(
            flags={"read_only": True},
        )
        virtual_machine_scale_set_vm_read.zones = AAZListType(
            flags={"read_only": True},
        )

        identity = _schema_virtual_machine_scale_set_vm_read.identity
        identity.principal_id = AAZStrType(
            serialized_name="principalId",
            flags={"read_only": True},
        )
        identity.tenant_id = AAZStrType(
            serialized_name="tenantId",
            flags={"read_only": True},
        )
        identity.type = AAZStrType()
        identity.user_assigned_identities = AAZDictType(
            serialized_name="userAssignedIdentities",
        )

        user_assigned_identities = _schema_virtual_machine_scale_set_vm_read.identity.user_assigned_identities
        user_assigned_identities.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.identity.user_assigned_identities.Element
        _element.client_id = AAZStrType(
            serialized_name="clientId",
            flags={"read_only": True},
        )
        _element.principal_id = AAZStrType(
            serialized_name="principalId",
            flags={"read_only": True},
        )

        plan = _schema_virtual_machine_scale_set_vm_read.plan
        plan.name = AAZStrType()
        plan.product = AAZStrType()
        plan.promotion_code = AAZStrType(
            serialized_name="promotionCode",
        )
        plan.publisher = AAZStrType()

        properties = _schema_virtual_machine_scale_set_vm_read.properties
        properties.additional_capabilities = AAZObjectType(
            serialized_name="additionalCapabilities",
        )
        properties.availability_set = AAZObjectType(
            serialized_name="availabilitySet",
        )
        cls._build_schema_sub_resource_read(properties.availability_set)
        properties.diagnostics_profile = AAZObjectType(
            serialized_name="diagnosticsProfile",
        )
        properties.hardware_profile = AAZObjectType(
            serialized_name="hardwareProfile",
        )
        properties.instance_view = AAZObjectType(
            serialized_name="instanceView",
            flags={"read_only": True},
        )
        properties.latest_model_applied = AAZBoolType(
            serialized_name="latestModelApplied",
            flags={"read_only": True},
        )
        properties.license_type = AAZStrType(
            serialized_name="licenseType",
        )
        properties.model_definition_applied = AAZStrType(
            serialized_name="modelDefinitionApplied",
            flags={"read_only": True},
        )
        properties.network_profile = AAZObjectType(
            serialized_name="networkProfile",
        )
        properties.network_profile_configuration = AAZObjectType(
            serialized_name="networkProfileConfiguration",
        )
        properties.os_profile = AAZObjectType(
            serialized_name="osProfile",
        )
        properties.protection_policy = AAZObjectType(
            serialized_name="protectionPolicy",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resilient_vm_deletion_status = AAZStrType(
            serialized_name="resilientVMDeletionStatus",
        )
        properties.security_profile = AAZObjectType(
            serialized_name="securityProfile",
        )
        properties.storage_profile = AAZObjectType(
            serialized_name="storageProfile",
        )
        properties.time_created = AAZStrType(
            serialized_name="timeCreated",
            flags={"read_only": True},
        )
        properties.user_data = AAZStrType(
            serialized_name="userData",
        )
        properties.vm_id = AAZStrType(
            serialized_name="vmId",
            flags={"read_only": True},
        )

        additional_capabilities = _schema_virtual_machine_scale_set_vm_read.properties.additional_capabilities
        additional_capabilities.enable_fips1403_encryption = AAZBoolType(
            serialized_name="enableFips1403Encryption",
        )
        additional_capabilities.hibernation_enabled = AAZBoolType(
            serialized_name="hibernationEnabled",
        )
        additional_capabilities.ultra_ssd_enabled = AAZBoolType(
            serialized_name="ultraSSDEnabled",
        )

        diagnostics_profile = _schema_virtual_machine_scale_set_vm_read.properties.diagnostics_profile
        diagnostics_profile.boot_diagnostics = AAZObjectType(
            serialized_name="bootDiagnostics",
        )

        boot_diagnostics = _schema_virtual_machine_scale_set_vm_read.properties.diagnostics_profile.boot_diagnostics
        boot_diagnostics.enabled = AAZBoolType()
        boot_diagnostics.storage_uri = AAZStrType(
            serialized_name="storageUri",
        )

        hardware_profile = _schema_virtual_machine_scale_set_vm_read.properties.hardware_profile
        hardware_profile.vm_size = AAZStrType(
            serialized_name="vmSize",
        )
        hardware_profile.vm_size_properties = AAZObjectType(
            serialized_name="vmSizeProperties",
        )

        vm_size_properties = _schema_virtual_machine_scale_set_vm_read.properties.hardware_profile.vm_size_properties
        vm_size_properties.v_cp_us_available = AAZIntType(
            serialized_name="vCPUsAvailable",
        )
        vm_size_properties.v_cp_us_per_core = AAZIntType(
            serialized_name="vCPUsPerCore",
        )

        instance_view = _schema_virtual_machine_scale_set_vm_read.properties.instance_view
        instance_view.assigned_host = AAZStrType(
            serialized_name="assignedHost",
            flags={"read_only": True},
        )
        instance_view.boot_diagnostics = AAZObjectType(
            serialized_name="bootDiagnostics",
        )
        instance_view.computer_name = AAZStrType(
            serialized_name="computerName",
        )
        instance_view.disks = AAZListType()
        instance_view.extensions = AAZListType()
        instance_view.hyper_v_generation = AAZStrType(
            serialized_name="hyperVGeneration",
        )
        instance_view.maintenance_redeploy_status = AAZObjectType(
            serialized_name="maintenanceRedeployStatus",
        )
        instance_view.os_name = AAZStrType(
            serialized_name="osName",
        )
        instance_view.os_version = AAZStrType(
            serialized_name="osVersion",
        )
        instance_view.placement_group_id = AAZStrType(
            serialized_name="placementGroupId",
        )
        instance_view.platform_fault_domain = AAZIntType(
            serialized_name="platformFaultDomain",
        )
        instance_view.platform_update_domain = AAZIntType(
            serialized_name="platformUpdateDomain",
        )
        instance_view.rdp_thumb_print = AAZStrType(
            serialized_name="rdpThumbPrint",
        )
        instance_view.statuses = AAZListType()
        instance_view.vm_agent = AAZObjectType(
            serialized_name="vmAgent",
        )
        instance_view.vm_health = AAZObjectType(
            serialized_name="vmHealth",
            flags={"read_only": True},
        )

        boot_diagnostics = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.boot_diagnostics
        boot_diagnostics.console_screenshot_blob_uri = AAZStrType(
            serialized_name="consoleScreenshotBlobUri",
            flags={"read_only": True},
        )
        boot_diagnostics.serial_console_log_blob_uri = AAZStrType(
            serialized_name="serialConsoleLogBlobUri",
            flags={"read_only": True},
        )
        boot_diagnostics.status = AAZObjectType(
            flags={"read_only": True},
        )
        cls._build_schema_instance_view_status_read(boot_diagnostics.status)

        disks = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.disks
        disks.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.disks.Element
        _element.encryption_settings = AAZListType(
            serialized_name="encryptionSettings",
        )
        _element.name = AAZStrType()
        _element.statuses = AAZListType()

        encryption_settings = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.disks.Element.encryption_settings
        encryption_settings.Element = AAZObjectType()
        cls._build_schema_disk_encryption_settings_read(encryption_settings.Element)

        statuses = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.disks.Element.statuses
        statuses.Element = AAZObjectType()
        cls._build_schema_instance_view_status_read(statuses.Element)

        extensions = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.extensions
        extensions.Element = AAZObjectType()
        cls._build_schema_virtual_machine_extension_instance_view_read(extensions.Element)

        maintenance_redeploy_status = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.maintenance_redeploy_status
        maintenance_redeploy_status.is_customer_initiated_maintenance_allowed = AAZBoolType(
            serialized_name="isCustomerInitiatedMaintenanceAllowed",
        )
        maintenance_redeploy_status.last_operation_message = AAZStrType(
            serialized_name="lastOperationMessage",
        )
        maintenance_redeploy_status.last_operation_result_code = AAZStrType(
            serialized_name="lastOperationResultCode",
        )
        maintenance_redeploy_status.maintenance_window_end_time = AAZStrType(
            serialized_name="maintenanceWindowEndTime",
        )
        maintenance_redeploy_status.maintenance_window_start_time = AAZStrType(
            serialized_name="maintenanceWindowStartTime",
        )
        maintenance_redeploy_status.pre_maintenance_window_end_time = AAZStrType(
            serialized_name="preMaintenanceWindowEndTime",
        )
        maintenance_redeploy_status.pre_maintenance_window_start_time = AAZStrType(
            serialized_name="preMaintenanceWindowStartTime",
        )

        statuses = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.statuses
        statuses.Element = AAZObjectType()
        cls._build_schema_instance_view_status_read(statuses.Element)

        vm_agent = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.vm_agent
        vm_agent.extension_handlers = AAZListType(
            serialized_name="extensionHandlers",
        )
        vm_agent.statuses = AAZListType()
        vm_agent.vm_agent_version = AAZStrType(
            serialized_name="vmAgentVersion",
        )

        extension_handlers = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.vm_agent.extension_handlers
        extension_handlers.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.vm_agent.extension_handlers.Element
        _element.status = AAZObjectType()
        cls._build_schema_instance_view_status_read(_element.status)
        _element.type = AAZStrType()
        _element.type_handler_version = AAZStrType(
            serialized_name="typeHandlerVersion",
        )

        statuses = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.vm_agent.statuses
        statuses.Element = AAZObjectType()
        cls._build_schema_instance_view_status_read(statuses.Element)

        vm_health = _schema_virtual_machine_scale_set_vm_read.properties.instance_view.vm_health
        vm_health.status = AAZObjectType(
            flags={"read_only": True},
        )
        cls._build_schema_instance_view_status_read(vm_health.status)

        network_profile = _schema_virtual_machine_scale_set_vm_read.properties.network_profile
        network_profile.network_api_version = AAZStrType(
            serialized_name="networkApiVersion",
        )
        network_profile.network_interface_configurations = AAZListType(
            serialized_name="networkInterfaceConfigurations",
        )
        network_profile.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
        )

        network_interface_configurations = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations
        network_interface_configurations.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()

        properties = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties
        properties.auxiliary_mode = AAZStrType(
            serialized_name="auxiliaryMode",
        )
        properties.auxiliary_sku = AAZStrType(
            serialized_name="auxiliarySku",
        )
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.disable_tcp_state_tracking = AAZBoolType(
            serialized_name="disableTcpStateTracking",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.dscp_configuration = AAZObjectType(
            serialized_name="dscpConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.dscp_configuration)
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_fpga = AAZBoolType(
            serialized_name="enableFpga",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"required": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_sub_resource_read(properties.network_security_group)
        properties.primary = AAZBoolType()

        dns_settings = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.dns_settings
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )

        dns_servers = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        ip_configurations = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.public_ip_address_configuration = AAZObjectType(
            serialized_name="publicIPAddressConfiguration",
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_sub_resource_read(properties.subnet)

        application_gateway_backend_address_pools = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_gateway_backend_address_pools.Element)

        application_security_groups = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancer_backend_address_pools.Element)

        public_ip_address_configuration = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration
        public_ip_address_configuration.name = AAZStrType(
            flags={"required": True},
        )
        public_ip_address_configuration.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_configuration.sku = AAZObjectType()
        cls._build_schema_public_ip_address_sku_read(public_ip_address_configuration.sku)
        public_ip_address_configuration.tags = AAZDictType()

        properties = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_allocation_method = AAZStrType(
            serialized_name="publicIPAllocationMethod",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)

        dns_settings = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
            flags={"required": True},
        )
        dns_settings.domain_name_label_scope = AAZStrType(
            serialized_name="domainNameLabelScope",
        )

        ip_tags = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        tags = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.tags
        tags.Element = AAZStrType()

        tags = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interface_configurations.Element.tags
        tags.Element = AAZStrType()

        network_interfaces = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interfaces
        network_interfaces.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interfaces.Element
        _element.id = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_machine_scale_set_vm_read.properties.network_profile.network_interfaces.Element.properties
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.primary = AAZBoolType()

        network_profile_configuration = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration
        network_profile_configuration.network_interface_configurations = AAZListType(
            serialized_name="networkInterfaceConfigurations",
        )

        network_interface_configurations = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations
        network_interface_configurations.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()

        properties = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties
        properties.auxiliary_mode = AAZStrType(
            serialized_name="auxiliaryMode",
        )
        properties.auxiliary_sku = AAZStrType(
            serialized_name="auxiliarySku",
        )
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.disable_tcp_state_tracking = AAZBoolType(
            serialized_name="disableTcpStateTracking",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_fpga = AAZBoolType(
            serialized_name="enableFpga",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"required": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_sub_resource_read(properties.network_security_group)
        properties.primary = AAZBoolType()

        dns_settings = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.dns_settings
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )

        dns_servers = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        ip_configurations = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_pools = AAZListType(
            serialized_name="loadBalancerInboundNatPools",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.public_ip_address_configuration = AAZObjectType(
            serialized_name="publicIPAddressConfiguration",
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_api_entity_reference_read(properties.subnet)

        application_gateway_backend_address_pools = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_gateway_backend_address_pools.Element)

        application_security_groups = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancer_backend_address_pools.Element)

        load_balancer_inbound_nat_pools = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.load_balancer_inbound_nat_pools
        load_balancer_inbound_nat_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancer_inbound_nat_pools.Element)

        public_ip_address_configuration = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration
        public_ip_address_configuration.name = AAZStrType(
            flags={"required": True},
        )
        public_ip_address_configuration.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_configuration.sku = AAZObjectType()
        cls._build_schema_public_ip_address_sku_read(public_ip_address_configuration.sku)
        public_ip_address_configuration.tags = AAZDictType()

        properties = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties
        properties.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)

        dns_settings = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
            flags={"required": True},
        )
        dns_settings.domain_name_label_scope = AAZStrType(
            serialized_name="domainNameLabelScope",
        )

        ip_tags = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        tags = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.properties.ip_configurations.Element.properties.public_ip_address_configuration.tags
        tags.Element = AAZStrType()

        tags = _schema_virtual_machine_scale_set_vm_read.properties.network_profile_configuration.network_interface_configurations.Element.tags
        tags.Element = AAZStrType()

        os_profile = _schema_virtual_machine_scale_set_vm_read.properties.os_profile
        os_profile.admin_password = AAZStrType(
            serialized_name="adminPassword",
            flags={"secret": True},
        )
        os_profile.admin_username = AAZStrType(
            serialized_name="adminUsername",
        )
        os_profile.allow_extension_operations = AAZBoolType(
            serialized_name="allowExtensionOperations",
        )
        os_profile.computer_name = AAZStrType(
            serialized_name="computerName",
        )
        os_profile.custom_data = AAZStrType(
            serialized_name="customData",
        )
        os_profile.linux_configuration = AAZObjectType(
            serialized_name="linuxConfiguration",
        )
        os_profile.require_guest_provision_signal = AAZBoolType(
            serialized_name="requireGuestProvisionSignal",
        )
        os_profile.secrets = AAZListType()
        os_profile.windows_configuration = AAZObjectType(
            serialized_name="windowsConfiguration",
        )

        linux_configuration = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.linux_configuration
        linux_configuration.disable_password_authentication = AAZBoolType(
            serialized_name="disablePasswordAuthentication",
        )
        linux_configuration.enable_vm_agent_platform_updates = AAZBoolType(
            serialized_name="enableVMAgentPlatformUpdates",
        )
        linux_configuration.patch_settings = AAZObjectType(
            serialized_name="patchSettings",
        )
        linux_configuration.provision_vm_agent = AAZBoolType(
            serialized_name="provisionVMAgent",
        )
        linux_configuration.ssh = AAZObjectType()

        patch_settings = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.linux_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrType(
            serialized_name="assessmentMode",
        )
        patch_settings.automatic_by_platform_settings = AAZObjectType(
            serialized_name="automaticByPlatformSettings",
        )
        patch_settings.patch_mode = AAZStrType(
            serialized_name="patchMode",
        )

        automatic_by_platform_settings = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.linux_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
            serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrType(
            serialized_name="rebootSetting",
        )

        ssh = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.linux_configuration.ssh
        ssh.public_keys = AAZListType(
            serialized_name="publicKeys",
        )

        public_keys = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.linux_configuration.ssh.public_keys
        public_keys.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.linux_configuration.ssh.public_keys.Element
        _element.key_data = AAZStrType(
            serialized_name="keyData",
        )
        _element.path = AAZStrType()

        secrets = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.secrets
        secrets.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.secrets.Element
        _element.source_vault = AAZObjectType(
            serialized_name="sourceVault",
        )
        cls._build_schema_sub_resource_read(_element.source_vault)
        _element.vault_certificates = AAZListType(
            serialized_name="vaultCertificates",
        )

        vault_certificates = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.secrets.Element.vault_certificates
        vault_certificates.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.secrets.Element.vault_certificates.Element
        _element.certificate_store = AAZStrType(
            serialized_name="certificateStore",
        )
        _element.certificate_url = AAZStrType(
            serialized_name="certificateUrl",
        )

        windows_configuration = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration
        windows_configuration.additional_unattend_content = AAZListType(
            serialized_name="additionalUnattendContent",
        )
        windows_configuration.enable_automatic_updates = AAZBoolType(
            serialized_name="enableAutomaticUpdates",
        )
        windows_configuration.enable_vm_agent_platform_updates = AAZBoolType(
            serialized_name="enableVMAgentPlatformUpdates",
            flags={"read_only": True},
        )
        windows_configuration.patch_settings = AAZObjectType(
            serialized_name="patchSettings",
        )
        windows_configuration.provision_vm_agent = AAZBoolType(
            serialized_name="provisionVMAgent",
        )
        windows_configuration.time_zone = AAZStrType(
            serialized_name="timeZone",
        )
        windows_configuration.win_rm = AAZObjectType(
            serialized_name="winRM",
        )

        additional_unattend_content = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration.additional_unattend_content
        additional_unattend_content.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration.additional_unattend_content.Element
        _element.component_name = AAZStrType(
            serialized_name="componentName",
        )
        _element.content = AAZStrType()
        _element.pass_name = AAZStrType(
            serialized_name="passName",
        )
        _element.setting_name = AAZStrType(
            serialized_name="settingName",
        )

        patch_settings = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration.patch_settings
        patch_settings.assessment_mode = AAZStrType(
            serialized_name="assessmentMode",
        )
        patch_settings.automatic_by_platform_settings = AAZObjectType(
            serialized_name="automaticByPlatformSettings",
        )
        patch_settings.enable_hotpatching = AAZBoolType(
            serialized_name="enableHotpatching",
        )
        patch_settings.patch_mode = AAZStrType(
            serialized_name="patchMode",
        )

        automatic_by_platform_settings = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration.patch_settings.automatic_by_platform_settings
        automatic_by_platform_settings.bypass_platform_safety_checks_on_user_schedule = AAZBoolType(
            serialized_name="bypassPlatformSafetyChecksOnUserSchedule",
        )
        automatic_by_platform_settings.reboot_setting = AAZStrType(
            serialized_name="rebootSetting",
        )

        win_rm = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration.win_rm
        win_rm.listeners = AAZListType()

        listeners = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration.win_rm.listeners
        listeners.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.os_profile.windows_configuration.win_rm.listeners.Element
        _element.certificate_url = AAZStrType(
            serialized_name="certificateUrl",
        )
        _element.protocol = AAZStrType()

        protection_policy = _schema_virtual_machine_scale_set_vm_read.properties.protection_policy
        protection_policy.protect_from_scale_in = AAZBoolType(
            serialized_name="protectFromScaleIn",
        )
        protection_policy.protect_from_scale_set_actions = AAZBoolType(
            serialized_name="protectFromScaleSetActions",
        )

        security_profile = _schema_virtual_machine_scale_set_vm_read.properties.security_profile
        security_profile.encryption_at_host = AAZBoolType(
            serialized_name="encryptionAtHost",
        )
        security_profile.encryption_identity = AAZObjectType(
            serialized_name="encryptionIdentity",
        )
        security_profile.proxy_agent_settings = AAZObjectType(
            serialized_name="proxyAgentSettings",
        )
        security_profile.security_type = AAZStrType(
            serialized_name="securityType",
        )
        security_profile.uefi_settings = AAZObjectType(
            serialized_name="uefiSettings",
        )

        encryption_identity = _schema_virtual_machine_scale_set_vm_read.properties.security_profile.encryption_identity
        encryption_identity.user_assigned_identity_resource_id = AAZStrType(
            serialized_name="userAssignedIdentityResourceId",
        )

        proxy_agent_settings = _schema_virtual_machine_scale_set_vm_read.properties.security_profile.proxy_agent_settings
        proxy_agent_settings.add_proxy_agent_extension = AAZBoolType(
            serialized_name="addProxyAgentExtension",
        )
        proxy_agent_settings.enabled = AAZBoolType()
        proxy_agent_settings.imds = AAZObjectType()
        cls._build_schema_host_endpoint_settings_read(proxy_agent_settings.imds)
        proxy_agent_settings.key_incarnation_id = AAZIntType(
            serialized_name="keyIncarnationId",
        )
        proxy_agent_settings.mode = AAZStrType()
        proxy_agent_settings.wire_server = AAZObjectType(
            serialized_name="wireServer",
        )
        cls._build_schema_host_endpoint_settings_read(proxy_agent_settings.wire_server)

        uefi_settings = _schema_virtual_machine_scale_set_vm_read.properties.security_profile.uefi_settings
        uefi_settings.secure_boot_enabled = AAZBoolType(
            serialized_name="secureBootEnabled",
        )
        uefi_settings.v_tpm_enabled = AAZBoolType(
            serialized_name="vTpmEnabled",
        )

        storage_profile = _schema_virtual_machine_scale_set_vm_read.properties.storage_profile
        storage_profile.align_regional_disks_to_vm_zone = AAZBoolType(
            serialized_name="alignRegionalDisksToVMZone",
        )
        storage_profile.data_disks = AAZListType(
            serialized_name="dataDisks",
        )
        storage_profile.disk_controller_type = AAZStrType(
            serialized_name="diskControllerType",
        )
        storage_profile.image_reference = AAZObjectType(
            serialized_name="imageReference",
        )
        storage_profile.os_disk = AAZObjectType(
            serialized_name="osDisk",
        )

        data_disks = _schema_virtual_machine_scale_set_vm_read.properties.storage_profile.data_disks
        data_disks.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.properties.storage_profile.data_disks.Element
        _element.caching = AAZStrType()
        _element.create_option = AAZStrType(
            serialized_name="createOption",
            flags={"required": True},
        )
        _element.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        _element.detach_option = AAZStrType(
            serialized_name="detachOption",
        )
        _element.disk_iops_read_write = AAZIntType(
            serialized_name="diskIOPSReadWrite",
        )
        _element.disk_m_bps_read_write = AAZIntType(
            serialized_name="diskMBpsReadWrite",
        )
        _element.disk_size_gb = AAZIntType(
            serialized_name="diskSizeGB",
        )
        _element.image = AAZObjectType()
        cls._build_schema_virtual_hard_disk_read(_element.image)
        _element.lun = AAZIntType(
            flags={"required": True},
        )
        _element.managed_disk = AAZObjectType(
            serialized_name="managedDisk",
        )
        cls._build_schema_managed_disk_parameters_read(_element.managed_disk)
        _element.name = AAZStrType()
        _element.source_resource = AAZObjectType(
            serialized_name="sourceResource",
        )
        cls._build_schema_api_entity_reference_read(_element.source_resource)
        _element.to_be_detached = AAZBoolType(
            serialized_name="toBeDetached",
        )
        _element.vhd = AAZObjectType()
        cls._build_schema_virtual_hard_disk_read(_element.vhd)
        _element.write_accelerator_enabled = AAZBoolType(
            serialized_name="writeAcceleratorEnabled",
        )

        image_reference = _schema_virtual_machine_scale_set_vm_read.properties.storage_profile.image_reference
        image_reference.community_gallery_image_id = AAZStrType(
            serialized_name="communityGalleryImageId",
        )
        image_reference.exact_version = AAZStrType(
            serialized_name="exactVersion",
            flags={"read_only": True},
        )
        image_reference.id = AAZStrType()
        image_reference.offer = AAZStrType()
        image_reference.publisher = AAZStrType()
        image_reference.shared_gallery_image_id = AAZStrType(
            serialized_name="sharedGalleryImageId",
        )
        image_reference.sku = AAZStrType()
        image_reference.version = AAZStrType()

        os_disk = _schema_virtual_machine_scale_set_vm_read.properties.storage_profile.os_disk
        os_disk.caching = AAZStrType()
        os_disk.create_option = AAZStrType(
            serialized_name="createOption",
            flags={"required": True},
        )
        os_disk.delete_option = AAZStrType(
            serialized_name="deleteOption",
        )
        os_disk.diff_disk_settings = AAZObjectType(
            serialized_name="diffDiskSettings",
        )
        os_disk.disk_size_gb = AAZIntType(
            serialized_name="diskSizeGB",
        )
        os_disk.encryption_settings = AAZObjectType(
            serialized_name="encryptionSettings",
        )
        cls._build_schema_disk_encryption_settings_read(os_disk.encryption_settings)
        os_disk.image = AAZObjectType()
        cls._build_schema_virtual_hard_disk_read(os_disk.image)
        os_disk.managed_disk = AAZObjectType(
            serialized_name="managedDisk",
        )
        cls._build_schema_managed_disk_parameters_read(os_disk.managed_disk)
        os_disk.name = AAZStrType()
        os_disk.os_type = AAZStrType(
            serialized_name="osType",
        )
        os_disk.vhd = AAZObjectType()
        cls._build_schema_virtual_hard_disk_read(os_disk.vhd)
        os_disk.write_accelerator_enabled = AAZBoolType(
            serialized_name="writeAcceleratorEnabled",
        )

        diff_disk_settings = _schema_virtual_machine_scale_set_vm_read.properties.storage_profile.os_disk.diff_disk_settings
        diff_disk_settings.option = AAZStrType()
        diff_disk_settings.placement = AAZStrType()

        resources = _schema_virtual_machine_scale_set_vm_read.resources
        resources.Element = AAZObjectType()

        _element = _schema_virtual_machine_scale_set_vm_read.resources.Element
        _element.id = AAZStrType(
            flags={"read_only": True},
        )
        _element.location = AAZStrType(
            flags={"required": True},
        )
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        cls._build_schema_system_data_read(_element.system_data)
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_machine_scale_set_vm_read.resources.Element.properties
        properties.auto_upgrade_minor_version = AAZBoolType(
            serialized_name="autoUpgradeMinorVersion",
        )
        properties.enable_automatic_upgrade = AAZBoolType(
            serialized_name="enableAutomaticUpgrade",
        )
        properties.force_update_tag = AAZStrType(
            serialized_name="forceUpdateTag",
        )
        properties.instance_view = AAZObjectType(
            serialized_name="instanceView",
        )
        cls._build_schema_virtual_machine_extension_instance_view_read(properties.instance_view)
        properties.protected_settings = AAZAnyType(
            serialized_name="protectedSettings",
        )
        properties.protected_settings_from_key_vault = AAZObjectType(
            serialized_name="protectedSettingsFromKeyVault",
        )
        cls._build_schema_key_vault_secret_reference_read(properties.protected_settings_from_key_vault)
        properties.provision_after_extensions = AAZListType(
            serialized_name="provisionAfterExtensions",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.publisher = AAZStrType()
        properties.settings = AAZAnyType()
        properties.suppress_failures = AAZBoolType(
            serialized_name="suppressFailures",
        )
        properties.type = AAZStrType()
        properties.type_handler_version = AAZStrType(
            serialized_name="typeHandlerVersion",
        )

        provision_after_extensions = _schema_virtual_machine_scale_set_vm_read.resources.Element.properties.provision_after_extensions
        provision_after_extensions.Element = AAZStrType()

        tags = _schema_virtual_machine_scale_set_vm_read.resources.Element.tags
        tags.Element = AAZStrType()

        sku = _schema_virtual_machine_scale_set_vm_read.sku
        sku.capacity = AAZIntType()
        sku.name = AAZStrType()
        sku.tier = AAZStrType()

        tags = _schema_virtual_machine_scale_set_vm_read.tags
        tags.Element = AAZStrType()

        zones = _schema_virtual_machine_scale_set_vm_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_machine_scale_set_vm_read.etag
        _schema.id = cls._schema_virtual_machine_scale_set_vm_read.id
        _schema.identity = cls._schema_virtual_machine_scale_set_vm_read.identity
        _schema.instance_id = cls._schema_virtual_machine_scale_set_vm_read.instance_id
        _schema.location = cls._schema_virtual_machine_scale_set_vm_read.location
        _schema.name = cls._schema_virtual_machine_scale_set_vm_read.name
        _schema.plan = cls._schema_virtual_machine_scale_set_vm_read.plan
        _schema.properties = cls._schema_virtual_machine_scale_set_vm_read.properties
        _schema.resources = cls._schema_virtual_machine_scale_set_vm_read.resources
        _schema.sku = cls._schema_virtual_machine_scale_set_vm_read.sku
        _schema.system_data = cls._schema_virtual_machine_scale_set_vm_read.system_data
        _schema.tags = cls._schema_virtual_machine_scale_set_vm_read.tags
        _schema.type = cls._schema_virtual_machine_scale_set_vm_read.type
        _schema.zones = cls._schema_virtual_machine_scale_set_vm_read.zones


__all__ = ["Create"]
