/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef hmac_sha512_vectors_h__
#define hmac_sha512_vectors_h__

#include "testvectors_base/test-structs.h"

const HmacTestVector kHmacSha512WycheproofVectors[] = {
    {1, "empty message",
     "5365244bb43f23f18dfc86c09d62db4741138bec1fbddc282d295e0a098eb5c3e37bd6f4c"
     "c16d5ce7d77b1d474a1eb4db313cc0c24e48992ac125196549df9a8",
     "",
     "d0a556bd1afa8df1ebf9e3ee683a8a2450a7c83eba2daf2e2ff2f953f0cd64da216e67134"
     "cf55578b205c8a1e241ba1369516a5ef4298b9c1d31e9d59fc04fe4",
     false},

    {2, "short message",
     "00698977f7102c67b594166919aa99dc3e58c7b6697a6422e238d04d2f57b2c74e4e84f5c"
     "4c6b792952df72f1c09244802f0bcf8752efb90e836110703bfa21c",
     "01",
     "4d1609cc2c2f1ab5ddc35815ae1b5dc046f226bde17ec37a4c89ec46fbd31af2aeb810b19"
     "6dffdd11924d3772bef26a7a542e0a1673b76b915d41cbd3df0f6a6",
     false},

    {3, "short message",
     "ed6dc65dbeaadbdaab530a0d35f19f78a7bd93e698546c82751bf650c2a44fc8529033d08"
     "8febeed288fb4c8132a59df0207687640c76dcdb270ac3af5f042f1",
     "a78f",
     "0757b27e120559d64cd3d6e3cb40d497845375815181bd9b4e74f2189d09d01a1b3ead537"
     "01380d988958ed22bc379ace9d47cbcac1d49bfa7e14f1f44804c30",
     false},

    {4, "short message",
     "463c5e696da0ec0d784388be775d1d91d94746aa8d3d2c209f56ac95ea54e7288329f9fb4"
     "0be4eef35547e64c61dc51a4a1f3380a2b96420f088655ea9d85b97",
     "e956c1",
     "ac4b1509391814ae5cb5a123e7a060601575c11d81b563bdc52febe6bb2c747b85eeddcb6"
     "748c98147a46a1cc9be6776d1a8e82ae4896b9c18da2ff351c56795",
     false},

    {5, "short message",
     "4bc0d32e945cfdafd20d39be3820f9649727cbda5ab5859953a322cbde1ab7a514d7dcd14"
     "ba90905e70919bb86b85cfeaa375ee2ce2703711b938c8f4ab5f178",
     "b2aa48b3",
     "c4ecdbd2efb17640ce6707e2e9d0ee5bfb98b91584bc86ab386437eaa37b0f2eb70500361"
     "105416c0dcecff389dc94c723fcff18cb801740962312007a195a23",
     false},

    {6, "short message",
     "aca47f6350941a0efd8c3bac9064a554be337cde7d192f6fbf86d1b4db09b36531165cbae"
     "0a634206f71fa400df33352fff60e1fba4009ac6671cd37312bdd98",
     "bc993b1db0",
     "89af2f5746cab89fda6993e00f1bf0cc70a77188945bb7b5409b536aec5533ad501db6ecf"
     "a3e516b580b7df9c8eadb3cf556ccc01668be984335bd5a6255d566",
     false},

    {7, "short message",
     "b3ecae6f25c2f699f158b3ffcd0a7a575583e4c9cb56b5c22ef4273cde6c6734e84d74007"
     "49c17e47e8cfccafaf8b50c65eb47dfeb273d5d30a1181e37b27ad0",
     "f0361d58291e",
     "4037a57aa279b5a07abe9389dcf508be9495a8257dcb3feba3f0801cd57574c30bfddc6df"
     "5df6567cd572c4e82735fd4e67b65e85b030f183a7f4457fb7d2c3d",
     false},

    {8, "short message",
     "70ff24a252d65183bdc6b7c88751f850821141a61246727c3240b4f96088ae3278767a822"
     "b65735a28ccebe4c874bcb2c942882cb23f9dd87fe08fbaad5ae72f",
     "e18da3ebf0ffa4",
     "878d488754bc796c70e11d5db77acda2e1796d86146e27d862586740c4d488ed12239e6fb"
     "4ab2925afc88168609edc048f8572536fae96e149d73d230b18db66",
     false},

    {9, "short message",
     "dd4e05933d09711ee88cb4c1ceb3600b2b33808bc08d499387b331d9c7af49bc65b55172c"
     "f8083385a940e4b864b7b4b73ddf3bd513a6cbcac73878a879b4d06",
     "66948029351432c3",
     "9968a16eff2b4eeecb2f9d11fcb105e8d8ca59ed4e69131c9de599cd8155fa4f33def1195"
     "a6b452263aad9265e16d4951841d7cd33c74c475da04497c02922ea",
     false},

    {10, "short message",
     "fbd32caf8984fc4376d10daa7288db8e6e74464bdd94b448adab4497b319e9a6dcce542f8"
     "2a7ff2e775d12477c880e460a9eab8efc49fcfc8c5476cb4b08954a",
     "38a2586a2883953cc4",
     "e0c69bd034cdec5b48150fdf3a4383456a7626d4405df52dc6c2bc8fe93bd87e369e06a78"
     "1ed80ba8b1fe1146c4df82b6a514412358b31b77b9b79c7a91ec9e4",
     false},

    {11, "short message",
     "fd4c3f6b2137513616c28ed4d8638f867ad0b97188b73fc9b36f3d52b82d72a49b9dc1b8b"
     "25397eb448054a8d38d838e7a88b4df9c263aea1b968771d5ac5756",
     "86b4e61b3b7d650044ad",
     "29345d7da44e2f228e8d502e29fb655da3676a481f9947c8482502ce070b3da5065589d84"
     "c02a05cd774b4bd5a15b668c59bafc192695aec43e5df3a82301745",
     false},

    {12, "short message",
     "f95baea535f477d22b405c67d927f59a9e042c46297a1681bcc16fdbe1b2cd59675a22135"
     "1a78075981e7eb4998066768801cbd7a85231114d7f27f9bdf24899",
     "5a34dee4e0982d458efffb",
     "63867bb3e82bd4a5f715b3dd67ba3625666e458c5e3d75804709f80b6dde6f774ea223ba9"
     "e2536c60ab636dd12d07b217234a490ea9cae4fe673215d33f8c57a",
     false},

    {13, "short message",
     "4d76ae95a123207e01c6d22d8b587e63ba682963e50961afff531160a9b9aac6c772c5e8b"
     "f918ddecbeb56455ea64710e51ac21e3bb9af4b24eaa8535b3c2924",
     "2c31f2d986f68a6d6a96c4b0",
     "9d4f9549ac134a6f60f17fd0fbc80f55426afa73cdaf84a806d98dfffc94263178116f76a"
     "adca95a9243a9128f5f66d3e7f33e72603d4b35ab90ab7d1e870ad7",
     false},

    {14, "short message",
     "0da7fa1f5d217951e3e343cda81f232deb71764eb49e8510bc28dba8eb62afa2a98b6f053"
     "6adb10250c74878fe649f47bbafdf3f722fa150f66e83f65f606ab0",
     "83511de190663c9c4229ace901",
     "11bd76ba2fd5684e3faadd44abc05d32661472ae4c75fd69e62e47a2d462e483ab5fd3740"
     "70e648017250934d486fed55e68f4338547fb5dc54d4bed894c1c2f",
     false},

    {15, "short message",
     "cec9e9f25ed9a017004a7882b1e44e8bd8fa3203c50cb6058455ed4f2a036788d46fcd328"
     "327d0d86b1abae69f7bbb96e3d66373ec8bd45075890879a83f4d33",
     "80dcd8ba66f98b51094144e9b8bd",
     "c69f1787bf7804bfffd9da7e62f58c1c9f599ccae2ed4fc6abda1be48620afc797d59d4ad"
     "b396e1fa5d18b8c1aa1c7c15218a9f9e3aab226119adad742641089",
     false},

    {16, "short message",
     "bbe25649ecdf54ae0028fb923cc8c28ec00e10e2d44214590781238a143b75d54efb037eb"
     "9f53082a8ab3d8876daf4dbdc2483c4ba222797fe20da3b7730368b",
     "33f630088c0d24cda98caff1a3afc7",
     "c803ca833e851418a3d9ed764f8c83f481060141eb1b2bf64d7ee7991b041c48bfc747bce"
     "13d69722f63944085cef8e7a166270530fe31a2a525a99b8a75f1b1",
     false},

    {17, "",
     "f5e2b9e2313f4f807cb3a924a7d4943fc3fb475d8f1a1b40ce09a37770f621af8977729ca"
     "df986c98c75f08a4fab4280538e09e7e51e87a8d62c03411bdb8d24",
     "74ef623c83275ae99745bff7e6142afa",
     "471055f7a2d44758e7d7837db85c33626b8306760eb45e18d4ba8dfbcd0d4279fcf8b539e"
     "f7b165eeabf5457ee2c41e52d07e9121da02c988f08162f86bdf208",
     false},

    {18, "",
     "8e323d5fb4752d92a6d905c512b287d07b21ae50002d026ff0388e1593bde9998dd02321e"
     "200d148f5fa2e824b37e9f5a77441794b840bedd552d1051c1ddd8c",
     "4daa229b009b8984354c2ec3e7973e0042",
     "93a2137cc84e2fa1439d7c239767b3ce653d634c58a4590eb61af9d3ef986445220aff355"
     "4de45a1b0933fa06d3d64460418910977d8d9ddb2eb04963c816841",
     false},

    {19, "",
     "465bc1ab2125cca29729d01df044e393b0677defdd939280a3aa141224efa06457e623056"
     "d02f6c36eca3dfc4a7476dd36b97d0c2d60c7672129189e73b6af8f",
     "dd84599b47ba9ae9f2ad0c8eac678485433eb6b1dfb7c998",
     "9fff43a83c71833211f9d60eeef4166965c41a37c76634b1bdf9c5291df75dc877668f228"
     "7bcf8108ea9e03d061a708db2db08687eda61fa97b1ca92dcf22b92",
     false},

    {20, "",
     "b90226798dff2ffb91d1ee4103f26397d0bf84c13c1ec717392c5fe1d4d0f4dc790236d75"
     "9fa1be852e305da585a3dbde0d3912bea60d6b140c25645eb00943f",
     "aa29c372f136993c65ace5e1d62078806eb787913bb35af33371056359d354b2",
     "493a727536b07d434a7fc8df6b70989148a8d94cadb9761ad845ac5fde2068f9565e68607"
     "b531b0f307d7c17ce0a2ba69fb1ac1b0c716f93904eec75669e70b7",
     false},

    {21, "long message",
     "af1bb91775cb40c73983f119c927a2ce8f7b954a6274ecc1cd96019e5c417af4b09437619"
     "4eae71c7f68f3345654d5d9f8198a697b41ae251e82308accd935bd",
     "75ededdfa7f1df1dc144fb195b27e454640e3f897cb564222f05e8aab0c6024f90472afea"
     "6e7254ed25134ea43452a",
     "b53d564086a745b10d88a48b50ed8b53f4c83fd12bf56a75108074de9b343cdf0668ce8b6"
     "a3d884ba2da5f4c957f1319e26c0813c99a4269c171ad80981013a2",
     false},

    {22, "long message",
     "513e0e7622eabcb6bfc81669dac903df46daea1240f32248bbf4fc61f1f9b13b2c3fe1bcc"
     "97540d30065be9eee41e51748bc42c16a8c8269fbe2b6f625c19228",
     "81d8650937f50871a66af71605ea4fa9d6c5d7a375774c2280eb34aefcee8c0ef83345bc5"
     "47e4de7cbea482369b25a93",
     "9d942e4585742ba118bda6e132510af3b9297047d364f76b2a0d1fc803849b06ccac0eaa4"
     "27934055c9d2e5a5da19cf17299ffdab65089580d10ff7207c9ed03",
     false},

    {23, "long message",
     "627c9a72247d07b0cec8346277468311c7401fc4cecaea8e22e13ece4b352c8f7a7eb1ba8"
     "1ce348a08670438c97b8d9e883614d550f1ff16d636975c59988c2d",
     "118e0468cbb52f93a3396ebfaa114881a98a4101f4ff912ced47ecfc73b27f52205b7a5d4"
     "f3899506f9e34ebf99460da7a",
     "a186e08c7731d4bbb1d5342a105ef48f5353c5c542277de607831fcbbc8d0b9fd509c74bf"
     "9e352ee739792ee3cd6382f96e70adb589fdf1fb031d43eef1a595f",
     false},

    {24, "long message",
     "1e981d0cbbad5bea9480d836b4704bf3147663b6ea59e1e0a280fb45d9b85d445dc972159"
     "dde301c6f1e66681f95642dbb9a9218c00d0cd724cb02f3bcaea2ea",
     "440dff390688c9fde31c17fdb61c1d13899f9544a986324c34d5eb07bef9a4436297f4a7f"
     "e16de5dd7b24e0c7c129051efe6f2dd0a21aec05c3e3c8f6fa30d9c0cbd60d840d14f0b2a"
     "928bc7189b9de4a6a731151d6b31e6a0ecae75095434737be8c3db11a6a697d0616c78b97"
     "041de",
     "c52eb5d18e90687248342a84dc0241c680e992b88b1409275df7e347c99169a50cd780eb4"
     "726ad759e2a027fb091354e3d7c7aba8a21f8acd1d0e21236af5f98",
     false},

    {25, "long message",
     "ee8aea2a52eb7e0c1120ab736b1a825b12610063de9642c594766c020cb87314d8ac94b13"
     "072bfbf3c019b4aacb1d2695cdd7563a26f574e12559906784d853c",
     "a3951f1d18135602fdadceeef5741c24ad22756160d0c55e51b788af952adaeb13e18c24c"
     "6b09672f405d7ec3d49b0bd86c7f8691b6f69af49175423215cf57d7c08a54ab0b0293e68"
     "5c9aa250f1599d78193a00af822dec4b56fdb41f0343ab2cf85ea27bb2e650930f5e8ca83"
     "6833903b053b3e06899b4012a6532978d90",
     "d3678ca7c5c1aa21f12eccc21a1add0b3eb12ccd134033570468191e51b058c61f2a7d88f"
     "2ca6c652c29c65c491bf1f0252bc157bdd77436ff55204eac6dfb0d",
     false},

    {26, "long message",
     "ecd1861a12eaee48aef1d7ed278223b50d3416dbff81e976c56ecd4b1a1bc8892b584cbcc"
     "72370ff5e976a6af1790caa32f9ea912855914c0315979578fbf165",
     "5779c56373a8e5db43bd65c0453ce23144230d43666d717a3b59d2e90f0e10732376831d7"
     "281cb23dd5566e5f8c627d00d39650139ceb87cd47e921d65d6c1cc7712ac4bd75bda8828"
     "e68abc968f4160ed91b28946c9d706b0360bbbdd65f47ef9983c50f2d09d05c3674c0943e"
     "a4af54c381089f9b846dd69ce908e0f6eaaaf",
     "d377e4efc39f25ca751452e79dcb5661f8adcc06570bd3f710e03854e032286ca477e6a62"
     "0647958fd31706463b542ddf617757875f349c61109358d04f6dc58",
     false},

    {27, "long message",
     "71aadbf330ea133b46c939d12e603896902e8df638597c98872dfb5aecd5161bc84095221"
     "de3222367012f45c6d70701e862ab000e782e91b505b21b4e212c38",
     "e6d7b0280d2f7df83fd26562fcdea2597cf687a9c9fa194f655c44d3271b881f28adc436d"
     "b8e0437ff4dc5d38356271c338829c3e2d9ba4ac1777c94886983d4b72c275bc00e4f7b06"
     "c5ce38a2fe549fe53761857f236da705fd03790b41cc6f759f41aa206feca7ba5486f4fc9"
     "d09f35c8e0887241291882010414ae41b8b384a715a409be13da17bfd60d3fbd4b8cb3cc7"
     "c26043807264a20b9a5c02725e742fff03e1806b38af357ebf8c79fc4c38b007bf0613286"
     "cf063e45482375475e6c426d4f70057cd92efcb2dfe86e45bdea399273a5e0f142221fae2"
     "06800555c01b18533295f577e23a9a7a0aa072823002b9096501174d3bc4aac33e0dc600",
     "0c1cbb2f196d3d1af5f982a330bf1d9accaada72cf6c254658cb32bfd8705481abd2e163a"
     "73338700f0d961ca02a31b600df04faf311cd06498557831102f80f",
     false},

    {28, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d39b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {29, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "be301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {30, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d09b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {31, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bd301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {32, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "529b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {33, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "3f301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {34, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29a9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {35, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf311cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {36, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9ebf87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {37, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301c3fb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {38, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f86809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {39, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb466720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {40, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f85809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {41, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb766720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {42, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809606f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {43, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566728e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {44, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f24109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {45, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e22f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {46, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686734109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {47, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720ea3f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {48, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f36109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {49, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23d166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {50, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34108fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {51, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f167e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {52, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34109fbc618d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {53, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24965c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {54, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34109fbc518d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {55, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24a65c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {56, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34109fb4718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {57, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e2c865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {58, "Flipped bit 504 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388d",
     true},

    {59, "Flipped bit 504 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca53",
     true},

    {60, "Flipped bit 505 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388e",
     true},

    {61, "Flipped bit 505 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca50",
     true},

    {62, "Flipped bit 510 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb038cc",
     true},

    {63, "Flipped bit 510 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca12",
     true},

    {64, "Flipped bit 511 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0380c",
     true},

    {65, "Flipped bit 511 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8cad2",
     true},

    {66, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d39b9e3f87809686f24109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {67, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "be301cbfb566720e22f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {68, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9ebf87809606f34109fbc718d6abbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {69, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301c3fb566728e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {70, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d29b9e3f87809606f34109fbc718d62bbb09c278cf05a206adf21463e1170362122e58272"
     "a31679720b254cbd63a7c6d696bf9283f9c6897e7d792483bb0388c",
     true},

    {71, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566728e23f166e24865c316f21619c7c15033cc6e8ebbcc8c5c5ba3e7e2dca7b"
     "011bf4cec4c7e7d6cc41bc10c3be36e8320c50aaf6c35f04ac8ca52",
     true},

    {72, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "2d6461c0787f69790cbef60438e7295444f63d8730fa5df9520deb9c1ee8fc9dedd1a7d8d"
     "5ce9868df4dab3429c58392969406d7c063976818286db7c44fc773",
     true},

    {73, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "40cfe3404a998df1dc0e991db79a3c690de9e6383eafcc339171443373a3a45c181d23584"
     "fee40b313b38182933be43ef3c41c917cdf3af55093ca0fb53735ad",
     true},

    {74, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "0000000000000000000000000000000000000000000000000000000",
     true},

    {75, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "0000000000000000000000000000000000000000000000000000000",
     true},

    {76, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffff",
     true},

    {77, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffff",
     true},

    {78, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "521b1ebf0700160673c1897b4798562b3b8942f84f8522862d7294e3619783e292aed8a7a"
     "ab1e717a032d44b56bafcede9eb79a8bf1ce817675712c8bb30b80c",
     true},

    {79, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "3fb09c3f35e6f28ea371e662c8e543167296994741d0b34cee0e3b4c0cdcdb2367625c273"
     "0913fcc6cccfefdec449b418cbb63ee03a0458a2fecb570ca484ad2",
     true},

    {80, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "d39a9f3e86819787f24008fac619d7aaba08c379ce04a307acf31562e0160263132f59262"
     "b30669621b355cad73b7d6c686af8293e9d6996e6d693493ab1398d",
     true},

    {81, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "be311dbeb467730f22f067e34964c297f31718c6c05132cd6f8fbacd8d5d5aa2e6e3dda6b"
     "110be4ded4d7f7c6dc51ac00d3ae26f8221c40bae6d34f14bc9cb53",
     true},

    {82, "empty message",
     "eef6bcf16ef7ae17326a33f22d1406ec1bd3f866505f4b2e4fe8b45bd62ccbd85032a9899"
     "facf2db0c93a2345cb8892afb74db549781211dd8881a8c8e25c171",
     "", "75f6975e3500be4fbfee1bc95644745ce9f8d47b6f3818a48ff34e8c2b186ba6",
     false},

    {83, "short message",
     "838696e6190c874c3717b8be0cf063ca6d60760987d1a33703e7e35eb173e5ae954e741a3"
     "7935139d612149e76f6ab2a370604f5b4a68bee87e309240a9ba3d6",
     "d8", "5bcf44539d8783bb708e7f5dafc4d683bcaa0d240c902675bdde059f944dacde",
     false},

    {84, "short message",
     "fa999ed1cfbc5c43afb16f22d024e3ce645e00b06712c93b946167c9c2c037d192f0f3003"
     "f87c43a71166fe1a3c5824c348673a2f0f3c475706985940f6b02a2",
     "cad2", "9a93f4728aa5941da160ec707f14b7e9ee1e768c7f627269543430d2fc681e90",
     false},

    {85, "short message",
     "b53fced8b7b4aa59d3b56d91e1386763c39e351c2f5ad6a4885e442ad894d5181c5bfe5c0"
     "5280a84ad19d758e359bf8171fe652988fcf9d1458ea17364ca8fa9",
     "d3393c",
     "02c4968e86d1c62837a41650d3199ca6b3c59b8227f55e0ba40e5e3904ab512a", false},

    {86, "short message",
     "3f0cbeebe391c6491e77c57a05e85a16f0b5294d19f9a7f3390baf7a2051fbf980e041ee4"
     "5c9104a9126a6a7ec182eaec27a99c1a7a3f5a1e8cd8ffde60641dc",
     "bebb0392",
     "8d68dd7d67763e8eafee0029d01e96e6a09c4ba09e57a2e5bde3bacca213c695", false},

    {87, "short message",
     "4a7f110b92241badc907ba3c61477bab0953a851bf327425e858fc724bd33ede2a4a5018f"
     "e71aab434bda8eb2464a41577c8d570530c460f7c8bc0172f1ee0f1",
     "40a333f4cf",
     "5feda3366ce9f5ac3402c977a4062d33c09e2c9a3d0c2dcda0c8d67b4bbd1a37", false},

    {88, "short message",
     "c6c95bf9facab295cebfa4b907855874f57a5c1548576ad8bae694a364f5e58dbb8c8dd49"
     "330b2fdd1b71657d211db2a6569a9f3a356c0c5b3c4efbd5b6777cb",
     "4cf926af475a",
     "0a748aa33762d374aa04b617b58d129ad1aaf252a40463fd62ce924e21e6d52c", false},

    {89, "short message",
     "0d3387fe59e8e7c43c928dac7913826dec4d63ac3c8ee346ba7caed9505b9e63ff8942cde"
     "90997e8dbeaf6e17ee187c0a84a1853952d866c15f9a32fcee6a82a",
     "2ba3bc3cd64bc6",
     "cc7e97630884bd8ad56f6d96fd34690eab6c8ad5556b519db3bc3c6083c82d3c", false},

    {90, "short message",
     "3cb9ce565388a6f0454a80add86c7e107ea537d7f468a0648930fc37172cf7b4ca9058033"
     "071c354a20a608e2d46e98afe46435a344362989cbaafac18859bba",
     "33ce498e1f94f412",
     "76335ee23ee1dc258812be373bb5f95918babed0b69e565e00ee3af776c5a5fc", false},

    {91, "short message",
     "c25f45ceb2a5597f361445fa41a9019f41a6e6d7f144203f29c0b9fcea362d60894c3cadc"
     "1ce25d53da362e464c11fc6e169e3db2ea1cf40fe08fffb429b1a5b",
     "81978af4795c50f89c",
     "bf73218544d8458e6ad00727b236f833d281723d7dcae4d1019b70b9d6e8bc4d", false},

    {92, "short message",
     "b458764ee273f391cb718f64a1bca64c96a870d9426d6254ee37e5c93898d6a5ef68e9d3b"
     "0e057a3c396faa834a29926a9680cfa903d2a605b85407bb24c8cee",
     "d804dc2a1e146f62b621",
     "5b25843416467b9e0a24cfab67d8fc27e0623ff9e01b2204b5afdf3e9cc05d1b", false},

    {93, "short message",
     "7cbc5778f70595fc211cee3a93e17ff7f25a1d9f3766f8eb70eb1e08c9420a62bd89e8b7d"
     "834cc854d059afd413e4d9c062a532e015928528c7f5812dfebecac",
     "4017e0ffcaac4c485ce7ec",
     "66b4191b37a6f78809c434736ed6ac2273c04a11219636e92671ea05bf6dc299", false},

    {94, "short message",
     "937b9711d670daa2359920e47dd6d0fb75275105b3ef07bb4a31d3c4b99baa8ff79ee4b4a"
     "1b4a5b250d0fd7b4721e04a7b06035b1d0c9d739597707839018bce",
     "6991810e9788af7aabff8eb4",
     "23522de80ff6a3a6d8fc1bf9b632e1600df53c59f38589a6f2ae9b95d940a340", false},

    {95, "short message",
     "ad37630a280b1a75ebed1984217150a400a55dca2362a8eaf3c907858d0b45db3e208c316"
     "d033854eb4284f71117d33876e0e203ca922d26f9b76d94cab0d4f3",
     "7c6f2fd83e5691827be38e49a0",
     "b609c0b5d359061ac066bd3bccabc98493fd33bac8fe0e3f2e2b4758cb6578b0", false},

    {96, "short message",
     "526aa2645ab71229e2c60f68bd5bbcf0cea0978a0a9c60cf695e81fecaedecfa0362c2174"
     "7eaa995975208ca35cfa6bc2b95d1c2afcee11275f43add6f026d6c",
     "681bca550fe301f2dcc1e38b53c1",
     "1f1f50dacb3dc35b90429c0f9b31edd239a6af4c09d51095cb39ff11c7c26598", false},

    {97, "short message",
     "6026a9047a07ccf197fde09c8b9f15f34bc52472b7d1ea4673b4914a0e1c3aa4cfe8d6ef1"
     "2d4d4019f5ff3ac0adcad7358490874155daf41da2f74aca1cd894a",
     "ce1d869c53041c5f6acdda7a05af15",
     "bd2d678ceadd71680f9987c88d24c49335cb985af0bcf8e23fe810e83a920f13", false},

    {98, "",
     "a03d2c543c302949c51b662f43114c1305a8f6961ae48342803d3690dc18255fab9249655"
     "36a79bc38564c7c97cb8cc0209786e9f76375bf181529cf7f93d954",
     "697617ae31f19b8a6ad4b8489bfc3db1",
     "577d62d7279b39a0d71e2f80833425ed43e4a16233eeb5d251f766db0bf7a58c", false},

    {99, "",
     "25843665d39c3ae9a7b3e4427e2bf7785281fd2594bdde67860ca9b8fa11646469d1645ae"
     "8ca3825b8c551f9eac3da0660d8c2e2e3bd23d34395c6775dcdfd2e",
     "74082cc5d14db1967442d66aac6092bd23",
     "b373ac5fb1982b9d47d28844e969d51680dc81d21d556c2671c29c11dfa6e340", false},

    {100, "",
     "4831ab4962a2d2436091cbbf388d2ba042b472a262ed8373c85d047c702adf73a87eb097e"
     "72d91d089b7d1504a7f7d8abb3bc2c44c1340d6c16c84ea9269e64b",
     "2803c2f4e5b4bfccd2b407469a6cb5ef21fd14a682636397",
     "641f29925c06aa01086c8bce89d99e1456dc2ad4b1d3364442187ce4392838ee", false},

    {101, "",
     "449bb57d046551e1819b3c994122c3605954317d0d76212284a3328c226732cbf4ecb442a"
     "582c8423888aaed946e5eec2be66e127f1e2e29b66e68b9b4bec4d1",
     "79004e644389a11b709bc0a23cb8592f9fc7960bfa46132cc1ffb9747df37dec",
     "c054667d992cc1e84fa5b13f6402125b4bb6fd2900dbcdaf8b8644c82edadc2b", false},

    {102, "long message",
     "ff97b77020861a0ce00eff8de9e701aea8c6de0fffd9b4c1342a416d357fce35a7016c64c"
     "cd38e2bdf674802281c2234153dd83aacb948966dc87ea4718fff75",
     "d7e2d2437b7067a30f04529041960e041e281737d1e0daa8cd50cc0b264716e117aa2fe9a"
     "7e39c2f178c607faa50c2",
     "062e9c4609a3b1d5df277a33ac1c7501df81ec1ddf460b0850a2aa332d07bfcb", false},

    {103, "long message",
     "f4daf370c4f437d8a85391ec455e34540be8d32df8dfac05b166ae72ec1cc608f8c177b30"
     "dde8bf07c9d434732c26a6e530b182c7ab21093eb79d0bb5be85e53",
     "f60418f6c54a25fabf518273088619c0741c1c7187de93a0cf6a03f4565f1765de6567545"
     "41b860137f3f8455de7c403",
     "4d4a568dd26d27267d0772540ebb0b94d44fbbb15a1bb749a570ed6313ee695b", false},

    {104, "long message",
     "3be95e879421ed7856269eef39a2070fae406cec5e30b50d92792df5a37de98595684eaa9"
     "205587ca607eeac8f96592f458f63434b7dc82596d3e4a1a16c3d59",
     "c64f7c970a441c6c503838a491308c783099eac52bd35a217978a64dcec84d34186ab3b74"
     "f20285d6fea2165eab4da3d2c",
     "4ea9e2f08870c30cb68d419816deb681cfd6ba62906e6b4a8088efcd9fa4edf9", false},

    {105, "long message",
     "b5eb53586b948587db3dd46c43ad65498a5079157562e4074c9c20d097d0c97f19db4661f"
     "b2dd11b87a5ccba2c345642618f561d00bf87dffc66762e45e0156f",
     "9e8ebf96429955d60b925a4111745ec7028de24e694a6d2eee1dbd5e820ab9f00beafde09"
     "f95095933a02f251297282b0cf67c518397655841f230e1d9ae5ba93150d4375dc7c0738b"
     "99850b07d5a442994e68dc813d55edefa6cd063ccb202711d97ba674efa02ddbdc692341e"
     "77cfa",
     "6a5b6272df7fb6315293ce22483511d700a83c34db6b0ee4398b4a770241fcf2", false},

    {106, "long message",
     "fbc678235d596980268730a7aa8a3c25095f1dbcf7f830990716a510c44e62b1ae8ce095c"
     "65e1852bd8a09f25ab93415ae736f22b2c68ecdf3c0f71e15a057dc",
     "ef395738f2b3bd7a0649eea75e734e5c79baf21358c7ae96c63a58e260266c7bfa869664c"
     "5d10e87c26d0f5edb3b5f73900c1d9a96a5a2c2912506c19dff04e900b8d5d63e1bb606fe"
     "3d5a229b642b1ac59e08a4687a7aade3de16d183131ddd02da988ff826e88b74ba0c5c41c"
     "fcd8570cca59fb3304d588f7f7e63dad47a",
     "84df3338f502e65866cf2077f6776341a89dd2234961b474d5b7438d1836fd6b", false},

    {107, "long message",
     "d8437b093e170afc30fb68d873db6dd67ee0372b6c5feb124d548abbd93304a082235a170"
     "a9d326268d0cfc34264d8ebcfcbcc0dc0ea7767b650dbcfc7848f91",
     "0fb91bb043cf3d49341482eacbab92da92117bb6ec03b518a93c9d59e54702c6a21ade4f2"
     "55870cb52da4a24b36856b0cbf8b122d2fd5b0219aeacb6e292c95863921789092d5d65d5"
     "a9389231670e38be31d8b76630650c77edc23773d5ec9189915560ef6f45a4275f85957d8"
     "762916d8147ef43ea6f438d066227354df26c",
     "4b9b51f2c7d725269a5bd735d4251cbfda71ea5cf5c046379b439ddff766d21a", false},

    {108, "long message",
     "d29225e3042b43d4eb7a9399f224424b5b4dd99031c8abf609d3a6e3175897134cc7ba8a6"
     "be25d436d41a757a2daa4e1b03f7c3053ee8cada19531d48dab93e0",
     "1fdad8cd37e115ef8131d4619b5d61a9827a11b9c25c5b8220b002d5b7f6e2bc30a7e2f3d"
     "103dbcaf849a255c20ec5d1b40a623e398d76c5b7f07fe305181cd5bee29de3360fed55f6"
     "9063e6a8fd2ef31291e4d7c3908449466b4ff1166959ff1f2e86eb48a7ed11bdcec2fc2df"
     "b6684b36b8d0b68e0f1b23ef11bf5907d4a2b162cec26f31b6d5d9892a27b3fad7a554985"
     "8dad530bae193d9b60d42d7ad2a66476a3ba4bf7a27ff9d0f885a540bf181caad71a235eb"
     "348a23d053ba2db7aed8d7d01d96dc9f780e2e426c72bb63fcb3fff44c14bb7b0f8af3552"
     "d67ee6761092c757627d19c080499c247d13b431699397159b1b71c6274584959d5c30f0",
     "f9ad00420ce909cd050fdb84dcc70f00df97928968d0aca51db2784f0394898d", false},

    {109, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d39b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {110, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "be301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {111, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d09b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {112, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bd301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {113, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "529b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {114, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "3f301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {115, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29a9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {116, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf311cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {117, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9ebf87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {118, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301c3fb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {119, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f86809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {120, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb466720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {121, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f85809686f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {122, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb766720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {123, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809606f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {124, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566728e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {125, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f24109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {126, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e22f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {127, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686734109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {128, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720ea3f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {129, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f36109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {130, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23d166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {131, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34108fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {132, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f167e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {133, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34109fbc618d6abbb09c278cf05a206adf21463e1170362",
     true},

    {134, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24965c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {135, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34109fbc518d6abbb09c278cf05a206adf21463e1170362",
     true},

    {136, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24a65c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {137, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34109fb4718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {138, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e2c865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {139, "Flipped bit 248 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170363",
     true},

    {140, "Flipped bit 248 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba2", true},

    {141, "Flipped bit 249 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170360",
     true},

    {142, "Flipped bit 249 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba1", true},

    {143, "Flipped bit 254 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e1170322",
     true},

    {144, "Flipped bit 254 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5be3", true},

    {145, "Flipped bit 255 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809686f34109fbc718d6abbb09c278cf05a206adf21463e11703e2",
     true},

    {146, "Flipped bit 255 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566720e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5b23", true},

    {147, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d39b9e3f87809686f24109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {148, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "be301cbfb566720e22f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {149, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9ebf87809606f34109fbc718d6abbb09c278cf05a206adf21463e1170362",
     true},

    {150, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301c3fb566728e23f166e24865c396f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {151, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d29b9e3f87809606f34109fbc718d62bbb09c278cf05a206adf21463e1170362",
     true},

    {152, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "bf301cbfb566728e23f166e24865c316f21619c7c15033cc6e8ebbcc8c5c5ba3", true},

    {153, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "2d6461c0787f69790cbef60438e7295444f63d8730fa5df9520deb9c1ee8fc9d",
     true},

    {154, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "40cfe3404a998df1dc0e991db79a3c690de9e6383eafcc339171443373a3a45c", true},

    {155, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "0000000000000000000000000000000000000000000000000000000000000000",
     true},

    {156, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "0000000000000000000000000000000000000000000000000000000000000000", true},

    {157, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
     true},

    {158, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {159, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "521b1ebf0700160673c1897b4798562b3b8942f84f8522862d7294e3619783e2",
     true},

    {160, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "3fb09c3f35e6f28ea371e662c8e543167296994741d0b34cee0e3b4c0cdcdb23", true},

    {161, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "d39a9f3e86819787f24008fac619d7aaba08c379ce04a307acf31562e0160263",
     true},

    {162, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "be311dbeb467730f22f067e34964c297f31718c6c05132cd6f8fbacd8d5d5aa2", true},

    {163, "short key",
     "14d93759fc28f3319ab74b8167c974e800f032344dc2747ec0f4945061a47827", "",
     "68934dbe948d9a77a5e0a92ed98254fa3b6c93c8bf5eeaa912b7dfdf762b37192c5d8523b"
     "cab9ad71b09bf96d8454188d001c7f2077eb641199f5731b9f94669",
     false},

    {164, "short key",
     "9fa371f36fb273d514fd628cb938067a4bae32a19a1e045a7d6d7f6de3751cbf",
     "311bbf722d322cd7a0710f480fc66518",
     "16345f6a6ca6e78d4ccac30b48d76691d6442420efa113c15ef127b538b5b024018b7d2db"
     "4bc3ed3424251ab6b8b6c3cb108b0beda842dc3e68e63400287e5cd",
     false},

    {165, "short key",
     "6313f1526bc220f20dde1e64ced8597279586d1e15aad05ad591d841b369284f",
     "f744fa3933e16d8bf524afaeb34c715653a9cfb01fa45fe1fb68e701fe1487ca",
     "b88d1ba03e2799200a447550d18e310697a57974f513df77eb07bbe315ba5fef397eeb81a"
     "d9071680bcc6c70f6b252ade35b4a4040279ec01b86e40b98770e39",
     false},

    {166, "short key",
     "1e225cafb90339bba1b24076d4206c3e79c355805d851682bc818baa4f5a7779", "",
     "23d482a05c907eeb346ba98f83db0f63c2adfbd5b2940f33c7964c7f1799f180", false},

    {167, "short key",
     "6fa353868c82e5deeedac7f09471a61bf749ab5498239e947e012eee3c82d7c4",
     "aeed3e4d4cb9bbb60d482e98c126c0f5",
     "1cf9d2c9c1b55a45190b5beb590cd4cc95e3853df8aaf9f4fef9bbbbd72435ff", false},

    {168, "short key",
     "186e248ad824e1eb93329a7fdcd565b6cb4eaf3f85b90b910777128d8c538d27",
     "92ef9ff52f46eccc7e38b9ee19fd2de3b37726c8e6ce9e1b96db5dda4c317902",
     "d127b7385badf0c76f2b3d8aa9c722333592e01f462fedd35ec664a6f6d52d74", false},

    {169, "long key",
     "dd1e0bdbb6b60862176484f3669da531455f1cd714f999c29f08b851055fee8d72186d376"
     "c236f4e16cba7a25cba879fb2753deca4459aaebc6f6de625d99af330",
     "",
     "7e4f7d844b3ba0e025b66de7cc6227bc50d4e174930251bfff3df36c3900b5b76b00095a8"
     "96d0f96842e37b6134df40760307699534d6670f138974ee1c58d94",
     false},

    {170, "long key",
     "432b311ebcfd46ecfcd3cc706ebd05c787dfbe1855fdcfce8d50c9a00f72b65a8d42acec3"
     "35b4e07d544c92fd7b1d38543ac6e0fc04c26d88de8dd974af69e24d7",
     "36b1fbe8f1335e7c0399c24730906420",
     "2cfb688f30b10534da9377a4b3fbee1dec161cb288ac8b758793838b45ab953979dadf278"
     "17f477c9ebf23cfdcbacb60b81038e08bc4fc3180bd2a1ee805976a",
     false},

    {171, "long key",
     "17f720f09df5972af9b9c63e10043284608900d50b7955db3b4e2679cb4120be2c9b9e2aa"
     "1a5743eb519792822c326b4d890b5554d1cb0eb71081b7569a2f04df7",
     "57167c2524a55289687b83a40d3a69bc90adc53ad247020b88897f9b95d1516d",
     "4f70267b98fceb4f662901bd18fb4c81ac164281dd0ece43028a3c2a65ca213aedf1bd207"
     "f0939bd879bbe20fd09cdeb20246e6539766add08b3adc5143d2bd9",
     false},

    {172, "long key",
     "8a0c46eb8a2959e39865330079763341e7439dab149694ee57e0d61ec73d947e1d5301cd9"
     "74e18a5e0d1cf0d2c37e8aadd9fd589d57ef32e47024a99bc3f70c077",
     "", "e1657f44bf84895e6db0810a2cca61a6e105e12ec006f0b5961020301b57744e",
     false},

    {173, "long key",
     "2877ebb81f80334fd00516337446c5cf5ad4a3a2e197269e5b0ad1889dfe2b4b0aaa676fa"
     "c55b36ce3affc7f1092ab89c53273a837bd5bc94d1a9d9e5b02e9856f",
     "ba448db88f154f775028fdecf9e6752d",
     "33d5a2d1998a586849eebf8134728485fcfc71248f4a98e622f83b967844c40e", false},

    {174, "long key",
     "21178e26bc28ffc27c06f762ba190a627075856d7ca6feab79ac63149b17126e34fd9e559"
     "0e0e90aac801df09505d8af2dd0a2703b352c573ac9d2cb063927f2af",
     "7d5f1d6b993452b1b53a4375760d10a20d46a0ab9ec3943fc4b07a2ce735e731",
     "88d579c2801905b818070ccebd2c7192f97bb3e7acdcaf613cecc74d0e411232",
     false}};

#endif  // hmac_sha512_vectors_h__
