/*
 * Copyright (C) 2019 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file generated by the script "utils/lexbor/encoding/single-byte.py"!
 * Do not change this file!
 */

#include "lexbor/encoding/base.h"

#include "lexbor/core/shs.h"


LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_ibm866[128] = 
{
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xe2', '\x96', '\x91'}, 3, 0x2591}, /* (LIGHT SHADE) */
    {{'\xe2', '\x96', '\x92'}, 3, 0x2592}, /* (MEDIUM SHADE) */
    {{'\xe2', '\x96', '\x93'}, 3, 0x2593}, /* (DARK SHADE) */
    {{'\xe2', '\x94', '\x82'}, 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {{'\xe2', '\x94', '\xa4'}, 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {{'\xe2', '\x95', '\xa1'}, 3, 0x2561}, /* (BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE) */
    {{'\xe2', '\x95', '\xa2'}, 3, 0x2562}, /* (BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE) */
    {{'\xe2', '\x95', '\x96'}, 3, 0x2556}, /* (BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE) */
    {{'\xe2', '\x95', '\x95'}, 3, 0x2555}, /* (BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE) */
    {{'\xe2', '\x95', '\xa3'}, 3, 0x2563}, /* (BOX DRAWINGS DOUBLE VERTICAL AND LEFT) */
    {{'\xe2', '\x95', '\x91'}, 3, 0x2551}, /* (BOX DRAWINGS DOUBLE VERTICAL) */
    {{'\xe2', '\x95', '\x97'}, 3, 0x2557}, /* (BOX DRAWINGS DOUBLE DOWN AND LEFT) */
    {{'\xe2', '\x95', '\x9d'}, 3, 0x255D}, /* (BOX DRAWINGS DOUBLE UP AND LEFT) */
    {{'\xe2', '\x95', '\x9c'}, 3, 0x255C}, /* (BOX DRAWINGS UP DOUBLE AND LEFT SINGLE) */
    {{'\xe2', '\x95', '\x9b'}, 3, 0x255B}, /* (BOX DRAWINGS UP SINGLE AND LEFT DOUBLE) */
    {{'\xe2', '\x94', '\x90'}, 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {{'\xe2', '\x94', '\x94'}, 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {{'\xe2', '\x94', '\xb4'}, 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xac'}, 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {{'\xe2', '\x94', '\x9c'}, 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {{'\xe2', '\x94', '\x80'}, 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {{'\xe2', '\x94', '\xbc'}, 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x95', '\x9e'}, 3, 0x255E}, /* (BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE) */
    {{'\xe2', '\x95', '\x9f'}, 3, 0x255F}, /* (BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\x9a'}, 3, 0x255A}, /* (BOX DRAWINGS DOUBLE UP AND RIGHT) */
    {{'\xe2', '\x95', '\x94'}, 3, 0x2554}, /* (BOX DRAWINGS DOUBLE DOWN AND RIGHT) */
    {{'\xe2', '\x95', '\xa9'}, 3, 0x2569}, /* (BOX DRAWINGS DOUBLE UP AND HORIZONTAL) */
    {{'\xe2', '\x95', '\xa6'}, 3, 0x2566}, /* (BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL) */
    {{'\xe2', '\x95', '\xa0'}, 3, 0x2560}, /* (BOX DRAWINGS DOUBLE VERTICAL AND RIGHT) */
    {{'\xe2', '\x95', '\x90'}, 3, 0x2550}, /* (BOX DRAWINGS DOUBLE HORIZONTAL) */
    {{'\xe2', '\x95', '\xac'}, 3, 0x256C}, /* (BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x95', '\xa7'}, 3, 0x2567}, /* (BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xe2', '\x95', '\xa8'}, 3, 0x2568}, /* (BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE) */
    {{'\xe2', '\x95', '\xa4'}, 3, 0x2564}, /* (BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xe2', '\x95', '\xa5'}, 3, 0x2565}, /* (BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE) */
    {{'\xe2', '\x95', '\x99'}, 3, 0x2559}, /* (BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\x98'}, 3, 0x2558}, /* (BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE) */
    {{'\xe2', '\x95', '\x92'}, 3, 0x2552}, /* (BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE) */
    {{'\xe2', '\x95', '\x93'}, 3, 0x2553}, /* (BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\xab'}, 3, 0x256B}, /* (BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE) */
    {{'\xe2', '\x95', '\xaa'}, 3, 0x256A}, /* (BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xe2', '\x94', '\x98'}, 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {{'\xe2', '\x94', '\x8c'}, 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {{'\xe2', '\x96', '\x88'}, 3, 0x2588}, /* (FULL BLOCK) */
    {{'\xe2', '\x96', '\x84'}, 3, 0x2584}, /* (LOWER HALF BLOCK) */
    {{'\xe2', '\x96', '\x8c'}, 3, 0x258C}, /* (LEFT HALF BLOCK) */
    {{'\xe2', '\x96', '\x90'}, 3, 0x2590}, /* (RIGHT HALF BLOCK) */
    {{'\xe2', '\x96', '\x80'}, 3, 0x2580}, /* (UPPER HALF BLOCK) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xd0', '\x84'}, 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {{'\xd1', '\x94'}, 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {{'\xd0', '\x87'}, 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {{'\xd1', '\x97'}, 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {{'\xd0', '\x8e'}, 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {{'\xd1', '\x9e'}, 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xe2', '\x88', '\x99'}, 3, 0x2219}, /* (BULLET OPERATOR) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xe2', '\x84', '\x96'}, 3, 0x2116}, /* (NUMERO SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xe2', '\x96', '\xa0'}, 3, 0x25A0}, /* (BLACK SQUARE) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_10[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc4', '\x84'}, 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {{'\xc4', '\x92'}, 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {{'\xc4', '\xa2'}, 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {{'\xc4', '\xaa'}, 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {{'\xc4', '\xa8'}, 2, 0x0128}, /* (LATIN CAPITAL LETTER I WITH TILDE) */
    {{'\xc4', '\xb6'}, 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc4', '\xbb'}, 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {{'\xc4', '\x90'}, 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xc5', '\xa6'}, 2, 0x0166}, /* (LATIN CAPITAL LETTER T WITH STROKE) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc5', '\xaa'}, 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {{'\xc5', '\x8a'}, 2, 0x014A}, /* (LATIN CAPITAL LETTER ENG) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc4', '\x85'}, 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {{'\xc4', '\x93'}, 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {{'\xc4', '\xa3'}, 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {{'\xc4', '\xab'}, 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {{'\xc4', '\xa9'}, 2, 0x0129}, /* (LATIN SMALL LETTER I WITH TILDE) */
    {{'\xc4', '\xb7'}, 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc4', '\xbc'}, 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {{'\xc4', '\x91'}, 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xc5', '\xa7'}, 2, 0x0167}, /* (LATIN SMALL LETTER T WITH STROKE) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xe2', '\x80', '\x95'}, 3, 0x2015}, /* (HORIZONTAL BAR) */
    {{'\xc5', '\xab'}, 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {{'\xc5', '\x8b'}, 2, 0x014B}, /* (LATIN SMALL LETTER ENG) */
    {{'\xc4', '\x80'}, 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\x83'}, 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc4', '\xae'}, 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {{'\xc4', '\x8c'}, 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc4', '\x98'}, 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x96'}, 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\x90'}, 2, 0x00D0}, /* (LATIN CAPITAL LETTER ETH) */
    {{'\xc5', '\x85'}, 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {{'\xc5', '\x8c'}, 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc5', '\xa8'}, 2, 0x0168}, /* (LATIN CAPITAL LETTER U WITH TILDE) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc5', '\xb2'}, 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\x9d'}, 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {{'\xc3', '\x9e'}, 2, 0x00DE}, /* (LATIN CAPITAL LETTER THORN) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc4', '\x81'}, 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\xa3'}, 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc4', '\xaf'}, 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {{'\xc4', '\x8d'}, 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc4', '\x99'}, 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x97'}, 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\xb0'}, 2, 0x00F0}, /* (LATIN SMALL LETTER ETH) */
    {{'\xc5', '\x86'}, 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {{'\xc5', '\x8d'}, 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc5', '\xa9'}, 2, 0x0169}, /* (LATIN SMALL LETTER U WITH TILDE) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc5', '\xb3'}, 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\xbd'}, 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {{'\xc3', '\xbe'}, 2, 0x00FE}, /* (LATIN SMALL LETTER THORN) */
    {{'\xc4', '\xb8'}, 2, 0x0138}, /* (LATIN SMALL LETTER KRA) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_13[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc5', '\x96'}, 2, 0x0156}, /* (LATIN CAPITAL LETTER R WITH CEDILLA) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc5', '\x97'}, 2, 0x0157}, /* (LATIN SMALL LETTER R WITH CEDILLA) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc4', '\x84'}, 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {{'\xc4', '\xae'}, 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {{'\xc4', '\x80'}, 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {{'\xc4', '\x86'}, 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc4', '\x98'}, 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {{'\xc4', '\x92'}, 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {{'\xc4', '\x8c'}, 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc5', '\xb9'}, 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {{'\xc4', '\x96'}, 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {{'\xc4', '\xa2'}, 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {{'\xc4', '\xb6'}, 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {{'\xc4', '\xaa'}, 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {{'\xc4', '\xbb'}, 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xc5', '\x83'}, 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {{'\xc5', '\x85'}, 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc5', '\x8c'}, 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc5', '\xb2'}, 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {{'\xc5', '\x81'}, 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {{'\xc5', '\x9a'}, 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {{'\xc5', '\xaa'}, 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xbb'}, 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc4', '\x85'}, 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {{'\xc4', '\xaf'}, 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {{'\xc4', '\x81'}, 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {{'\xc4', '\x87'}, 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc4', '\x99'}, 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {{'\xc4', '\x93'}, 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {{'\xc4', '\x8d'}, 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc5', '\xba'}, 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {{'\xc4', '\x97'}, 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {{'\xc4', '\xa3'}, 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {{'\xc4', '\xb7'}, 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {{'\xc4', '\xab'}, 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {{'\xc4', '\xbc'}, 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xc5', '\x84'}, 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {{'\xc5', '\x86'}, 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc5', '\x8d'}, 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc5', '\xb3'}, 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {{'\xc5', '\x82'}, 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {{'\xc5', '\x9b'}, 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {{'\xc5', '\xab'}, 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xbc'}, 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_14[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xe1', '\xb8', '\x82'}, 3, 0x1E02}, /* (LATIN CAPITAL LETTER B WITH DOT ABOVE) */
    {{'\xe1', '\xb8', '\x83'}, 3, 0x1E03}, /* (LATIN SMALL LETTER B WITH DOT ABOVE) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc4', '\x8a'}, 2, 0x010A}, /* (LATIN CAPITAL LETTER C WITH DOT ABOVE) */
    {{'\xc4', '\x8b'}, 2, 0x010B}, /* (LATIN SMALL LETTER C WITH DOT ABOVE) */
    {{'\xe1', '\xb8', '\x8a'}, 3, 0x1E0A}, /* (LATIN CAPITAL LETTER D WITH DOT ABOVE) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xe1', '\xba', '\x80'}, 3, 0x1E80}, /* (LATIN CAPITAL LETTER W WITH GRAVE) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xe1', '\xba', '\x82'}, 3, 0x1E82}, /* (LATIN CAPITAL LETTER W WITH ACUTE) */
    {{'\xe1', '\xb8', '\x8b'}, 3, 0x1E0B}, /* (LATIN SMALL LETTER D WITH DOT ABOVE) */
    {{'\xe1', '\xbb', '\xb2'}, 3, 0x1EF2}, /* (LATIN CAPITAL LETTER Y WITH GRAVE) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc5', '\xb8'}, 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {{'\xe1', '\xb8', '\x9e'}, 3, 0x1E1E}, /* (LATIN CAPITAL LETTER F WITH DOT ABOVE) */
    {{'\xe1', '\xb8', '\x9f'}, 3, 0x1E1F}, /* (LATIN SMALL LETTER F WITH DOT ABOVE) */
    {{'\xc4', '\xa0'}, 2, 0x0120}, /* (LATIN CAPITAL LETTER G WITH DOT ABOVE) */
    {{'\xc4', '\xa1'}, 2, 0x0121}, /* (LATIN SMALL LETTER G WITH DOT ABOVE) */
    {{'\xe1', '\xb9', '\x80'}, 3, 0x1E40}, /* (LATIN CAPITAL LETTER M WITH DOT ABOVE) */
    {{'\xe1', '\xb9', '\x81'}, 3, 0x1E41}, /* (LATIN SMALL LETTER M WITH DOT ABOVE) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xe1', '\xb9', '\x96'}, 3, 0x1E56}, /* (LATIN CAPITAL LETTER P WITH DOT ABOVE) */
    {{'\xe1', '\xba', '\x81'}, 3, 0x1E81}, /* (LATIN SMALL LETTER W WITH GRAVE) */
    {{'\xe1', '\xb9', '\x97'}, 3, 0x1E57}, /* (LATIN SMALL LETTER P WITH DOT ABOVE) */
    {{'\xe1', '\xba', '\x83'}, 3, 0x1E83}, /* (LATIN SMALL LETTER W WITH ACUTE) */
    {{'\xe1', '\xb9', '\xa0'}, 3, 0x1E60}, /* (LATIN CAPITAL LETTER S WITH DOT ABOVE) */
    {{'\xe1', '\xbb', '\xb3'}, 3, 0x1EF3}, /* (LATIN SMALL LETTER Y WITH GRAVE) */
    {{'\xe1', '\xba', '\x84'}, 3, 0x1E84}, /* (LATIN CAPITAL LETTER W WITH DIAERESIS) */
    {{'\xe1', '\xba', '\x85'}, 3, 0x1E85}, /* (LATIN SMALL LETTER W WITH DIAERESIS) */
    {{'\xe1', '\xb9', '\xa1'}, 3, 0x1E61}, /* (LATIN SMALL LETTER S WITH DOT ABOVE) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\x83'}, 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\x8c'}, 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc5', '\xb4'}, 2, 0x0174}, /* (LATIN CAPITAL LETTER W WITH CIRCUMFLEX) */
    {{'\xc3', '\x91'}, 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {{'\xc3', '\x92'}, 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xe1', '\xb9', '\xaa'}, 3, 0x1E6A}, /* (LATIN CAPITAL LETTER T WITH DOT ABOVE) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\x9d'}, 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {{'\xc5', '\xb6'}, 2, 0x0176}, /* (LATIN CAPITAL LETTER Y WITH CIRCUMFLEX) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\xa3'}, 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\xac'}, 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc5', '\xb5'}, 2, 0x0175}, /* (LATIN SMALL LETTER W WITH CIRCUMFLEX) */
    {{'\xc3', '\xb1'}, 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {{'\xc3', '\xb2'}, 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xe1', '\xb9', '\xab'}, 3, 0x1E6B}, /* (LATIN SMALL LETTER T WITH DOT ABOVE) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\xbd'}, 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {{'\xc5', '\xb7'}, 2, 0x0177}, /* (LATIN SMALL LETTER Y WITH CIRCUMFLEX) */
    {{'\xc3', '\xbf'}, 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_15[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc2', '\xa1'}, 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc2', '\xaa'}, 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc2', '\xba'}, 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xc5', '\xb8'}, 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {{'\xc2', '\xbf'}, 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\x83'}, 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\x8c'}, 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\x90'}, 2, 0x00D0}, /* (LATIN CAPITAL LETTER ETH) */
    {{'\xc3', '\x91'}, 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {{'\xc3', '\x92'}, 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\x9d'}, 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {{'\xc3', '\x9e'}, 2, 0x00DE}, /* (LATIN CAPITAL LETTER THORN) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\xa3'}, 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\xac'}, 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\xb0'}, 2, 0x00F0}, /* (LATIN SMALL LETTER ETH) */
    {{'\xc3', '\xb1'}, 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {{'\xc3', '\xb2'}, 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\xbd'}, 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {{'\xc3', '\xbe'}, 2, 0x00FE}, /* (LATIN SMALL LETTER THORN) */
    {{'\xc3', '\xbf'}, 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_16[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc4', '\x84'}, 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {{'\xc4', '\x85'}, 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {{'\xc5', '\x81'}, 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc8', '\x98'}, 2, 0x0218}, /* (LATIN CAPITAL LETTER S WITH COMMA BELOW) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc5', '\xb9'}, 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc5', '\xba'}, 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {{'\xc5', '\xbb'}, 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc4', '\x8c'}, 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {{'\xc5', '\x82'}, 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xc4', '\x8d'}, 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {{'\xc8', '\x99'}, 2, 0x0219}, /* (LATIN SMALL LETTER S WITH COMMA BELOW) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xc5', '\xb8'}, 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {{'\xc5', '\xbc'}, 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x82'}, 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\x86'}, 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\x8c'}, 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc4', '\x90'}, 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {{'\xc5', '\x83'}, 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {{'\xc3', '\x92'}, 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc5', '\x90'}, 2, 0x0150}, /* (LATIN CAPITAL LETTER O WITH DOUBLE ACUTE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc5', '\x9a'}, 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {{'\xc5', '\xb0'}, 2, 0x0170}, /* (LATIN CAPITAL LETTER U WITH DOUBLE ACUTE) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc4', '\x98'}, 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {{'\xc8', '\x9a'}, 2, 0x021A}, /* (LATIN CAPITAL LETTER T WITH COMMA BELOW) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x83'}, 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\x87'}, 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\xac'}, 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc4', '\x91'}, 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {{'\xc5', '\x84'}, 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {{'\xc3', '\xb2'}, 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc5', '\x91'}, 2, 0x0151}, /* (LATIN SMALL LETTER O WITH DOUBLE ACUTE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc5', '\x9b'}, 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {{'\xc5', '\xb1'}, 2, 0x0171}, /* (LATIN SMALL LETTER U WITH DOUBLE ACUTE) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc4', '\x99'}, 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {{'\xc8', '\x9b'}, 2, 0x021B}, /* (LATIN SMALL LETTER T WITH COMMA BELOW) */
    {{'\xc3', '\xbf'}, 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_2[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc4', '\x84'}, 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {{'\xcb', '\x98'}, 2, 0x02D8}, /* (BREVE) */
    {{'\xc5', '\x81'}, 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc4', '\xbd'}, 2, 0x013D}, /* (LATIN CAPITAL LETTER L WITH CARON) */
    {{'\xc5', '\x9a'}, 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xc5', '\x9e'}, 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {{'\xc5', '\xa4'}, 2, 0x0164}, /* (LATIN CAPITAL LETTER T WITH CARON) */
    {{'\xc5', '\xb9'}, 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc5', '\xbb'}, 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc4', '\x85'}, 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {{'\xcb', '\x9b'}, 2, 0x02DB}, /* (OGONEK) */
    {{'\xc5', '\x82'}, 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc4', '\xbe'}, 2, 0x013E}, /* (LATIN SMALL LETTER L WITH CARON) */
    {{'\xc5', '\x9b'}, 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {{'\xcb', '\x87'}, 2, 0x02C7}, /* (CARON) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xc5', '\x9f'}, 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {{'\xc5', '\xa5'}, 2, 0x0165}, /* (LATIN SMALL LETTER T WITH CARON) */
    {{'\xc5', '\xba'}, 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {{'\xcb', '\x9d'}, 2, 0x02DD}, /* (DOUBLE ACUTE ACCENT) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xc5', '\xbc'}, 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {{'\xc5', '\x94'}, 2, 0x0154}, /* (LATIN CAPITAL LETTER R WITH ACUTE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x82'}, 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\xb9'}, 2, 0x0139}, /* (LATIN CAPITAL LETTER L WITH ACUTE) */
    {{'\xc4', '\x86'}, 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc4', '\x8c'}, 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc4', '\x98'}, 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x9a'}, 2, 0x011A}, /* (LATIN CAPITAL LETTER E WITH CARON) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc4', '\x8e'}, 2, 0x010E}, /* (LATIN CAPITAL LETTER D WITH CARON) */
    {{'\xc4', '\x90'}, 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {{'\xc5', '\x83'}, 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {{'\xc5', '\x87'}, 2, 0x0147}, /* (LATIN CAPITAL LETTER N WITH CARON) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc5', '\x90'}, 2, 0x0150}, /* (LATIN CAPITAL LETTER O WITH DOUBLE ACUTE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc5', '\x98'}, 2, 0x0158}, /* (LATIN CAPITAL LETTER R WITH CARON) */
    {{'\xc5', '\xae'}, 2, 0x016E}, /* (LATIN CAPITAL LETTER U WITH RING ABOVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc5', '\xb0'}, 2, 0x0170}, /* (LATIN CAPITAL LETTER U WITH DOUBLE ACUTE) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\x9d'}, 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {{'\xc5', '\xa2'}, 2, 0x0162}, /* (LATIN CAPITAL LETTER T WITH CEDILLA) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc5', '\x95'}, 2, 0x0155}, /* (LATIN SMALL LETTER R WITH ACUTE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x83'}, 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\xba'}, 2, 0x013A}, /* (LATIN SMALL LETTER L WITH ACUTE) */
    {{'\xc4', '\x87'}, 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc4', '\x8d'}, 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc4', '\x99'}, 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x9b'}, 2, 0x011B}, /* (LATIN SMALL LETTER E WITH CARON) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc4', '\x8f'}, 2, 0x010F}, /* (LATIN SMALL LETTER D WITH CARON) */
    {{'\xc4', '\x91'}, 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {{'\xc5', '\x84'}, 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {{'\xc5', '\x88'}, 2, 0x0148}, /* (LATIN SMALL LETTER N WITH CARON) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc5', '\x91'}, 2, 0x0151}, /* (LATIN SMALL LETTER O WITH DOUBLE ACUTE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc5', '\x99'}, 2, 0x0159}, /* (LATIN SMALL LETTER R WITH CARON) */
    {{'\xc5', '\xaf'}, 2, 0x016F}, /* (LATIN SMALL LETTER U WITH RING ABOVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc5', '\xb1'}, 2, 0x0171}, /* (LATIN SMALL LETTER U WITH DOUBLE ACUTE) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\xbd'}, 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {{'\xc5', '\xa3'}, 2, 0x0163}, /* (LATIN SMALL LETTER T WITH CEDILLA) */
    {{'\xcb', '\x99'}, 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_3[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc4', '\xa6'}, 2, 0x0126}, /* (LATIN CAPITAL LETTER H WITH STROKE) */
    {{'\xcb', '\x98'}, 2, 0x02D8}, /* (BREVE) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc4', '\xa4'}, 2, 0x0124}, /* (LATIN CAPITAL LETTER H WITH CIRCUMFLEX) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc4', '\xb0'}, 2, 0x0130}, /* (LATIN CAPITAL LETTER I WITH DOT ABOVE) */
    {{'\xc5', '\x9e'}, 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {{'\xc4', '\x9e'}, 2, 0x011E}, /* (LATIN CAPITAL LETTER G WITH BREVE) */
    {{'\xc4', '\xb4'}, 2, 0x0134}, /* (LATIN CAPITAL LETTER J WITH CIRCUMFLEX) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc5', '\xbb'}, 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc4', '\xa7'}, 2, 0x0127}, /* (LATIN SMALL LETTER H WITH STROKE) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc4', '\xa5'}, 2, 0x0125}, /* (LATIN SMALL LETTER H WITH CIRCUMFLEX) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc4', '\xb1'}, 2, 0x0131}, /* (LATIN SMALL LETTER DOTLESS I) */
    {{'\xc5', '\x9f'}, 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {{'\xc4', '\x9f'}, 2, 0x011F}, /* (LATIN SMALL LETTER G WITH BREVE) */
    {{'\xc4', '\xb5'}, 2, 0x0135}, /* (LATIN SMALL LETTER J WITH CIRCUMFLEX) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc5', '\xbc'}, 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\x8a'}, 2, 0x010A}, /* (LATIN CAPITAL LETTER C WITH DOT ABOVE) */
    {{'\xc4', '\x88'}, 2, 0x0108}, /* (LATIN CAPITAL LETTER C WITH CIRCUMFLEX) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\x8c'}, 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc3', '\x91'}, 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {{'\xc3', '\x92'}, 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc4', '\xa0'}, 2, 0x0120}, /* (LATIN CAPITAL LETTER G WITH DOT ABOVE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc4', '\x9c'}, 2, 0x011C}, /* (LATIN CAPITAL LETTER G WITH CIRCUMFLEX) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xac'}, 2, 0x016C}, /* (LATIN CAPITAL LETTER U WITH BREVE) */
    {{'\xc5', '\x9c'}, 2, 0x015C}, /* (LATIN CAPITAL LETTER S WITH CIRCUMFLEX) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\x8b'}, 2, 0x010B}, /* (LATIN SMALL LETTER C WITH DOT ABOVE) */
    {{'\xc4', '\x89'}, 2, 0x0109}, /* (LATIN SMALL LETTER C WITH CIRCUMFLEX) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\xac'}, 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc3', '\xb1'}, 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {{'\xc3', '\xb2'}, 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc4', '\xa1'}, 2, 0x0121}, /* (LATIN SMALL LETTER G WITH DOT ABOVE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc4', '\x9d'}, 2, 0x011D}, /* (LATIN SMALL LETTER G WITH CIRCUMFLEX) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xad'}, 2, 0x016D}, /* (LATIN SMALL LETTER U WITH BREVE) */
    {{'\xc5', '\x9d'}, 2, 0x015D}, /* (LATIN SMALL LETTER S WITH CIRCUMFLEX) */
    {{'\xcb', '\x99'}, 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_4[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc4', '\x84'}, 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {{'\xc4', '\xb8'}, 2, 0x0138}, /* (LATIN SMALL LETTER KRA) */
    {{'\xc5', '\x96'}, 2, 0x0156}, /* (LATIN CAPITAL LETTER R WITH CEDILLA) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc4', '\xa8'}, 2, 0x0128}, /* (LATIN CAPITAL LETTER I WITH TILDE) */
    {{'\xc4', '\xbb'}, 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xc4', '\x92'}, 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {{'\xc4', '\xa2'}, 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {{'\xc5', '\xa6'}, 2, 0x0166}, /* (LATIN CAPITAL LETTER T WITH STROKE) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc4', '\x85'}, 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {{'\xcb', '\x9b'}, 2, 0x02DB}, /* (OGONEK) */
    {{'\xc5', '\x97'}, 2, 0x0157}, /* (LATIN SMALL LETTER R WITH CEDILLA) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc4', '\xa9'}, 2, 0x0129}, /* (LATIN SMALL LETTER I WITH TILDE) */
    {{'\xc4', '\xbc'}, 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {{'\xcb', '\x87'}, 2, 0x02C7}, /* (CARON) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xc4', '\x93'}, 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {{'\xc4', '\xa3'}, 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {{'\xc5', '\xa7'}, 2, 0x0167}, /* (LATIN SMALL LETTER T WITH STROKE) */
    {{'\xc5', '\x8a'}, 2, 0x014A}, /* (LATIN CAPITAL LETTER ENG) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xc5', '\x8b'}, 2, 0x014B}, /* (LATIN SMALL LETTER ENG) */
    {{'\xc4', '\x80'}, 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\x83'}, 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc4', '\xae'}, 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {{'\xc4', '\x8c'}, 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc4', '\x98'}, 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x96'}, 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc4', '\xaa'}, 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {{'\xc4', '\x90'}, 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {{'\xc5', '\x85'}, 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {{'\xc5', '\x8c'}, 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {{'\xc4', '\xb6'}, 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc5', '\xb2'}, 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xa8'}, 2, 0x0168}, /* (LATIN CAPITAL LETTER U WITH TILDE) */
    {{'\xc5', '\xaa'}, 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc4', '\x81'}, 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\xa3'}, 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc4', '\xaf'}, 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {{'\xc4', '\x8d'}, 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc4', '\x99'}, 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x97'}, 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc4', '\xab'}, 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {{'\xc4', '\x91'}, 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {{'\xc5', '\x86'}, 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {{'\xc5', '\x8d'}, 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {{'\xc4', '\xb7'}, 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc5', '\xb3'}, 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xa9'}, 2, 0x0169}, /* (LATIN SMALL LETTER U WITH TILDE) */
    {{'\xc5', '\xab'}, 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {{'\xcb', '\x99'}, 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_5[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xd0', '\x82'}, 2, 0x0402}, /* (CYRILLIC CAPITAL LETTER DJE) */
    {{'\xd0', '\x83'}, 2, 0x0403}, /* (CYRILLIC CAPITAL LETTER GJE) */
    {{'\xd0', '\x84'}, 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {{'\xd0', '\x85'}, 2, 0x0405}, /* (CYRILLIC CAPITAL LETTER DZE) */
    {{'\xd0', '\x86'}, 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xd0', '\x87'}, 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {{'\xd0', '\x88'}, 2, 0x0408}, /* (CYRILLIC CAPITAL LETTER JE) */
    {{'\xd0', '\x89'}, 2, 0x0409}, /* (CYRILLIC CAPITAL LETTER LJE) */
    {{'\xd0', '\x8a'}, 2, 0x040A}, /* (CYRILLIC CAPITAL LETTER NJE) */
    {{'\xd0', '\x8b'}, 2, 0x040B}, /* (CYRILLIC CAPITAL LETTER TSHE) */
    {{'\xd0', '\x8c'}, 2, 0x040C}, /* (CYRILLIC CAPITAL LETTER KJE) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xd0', '\x8e'}, 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {{'\xd0', '\x8f'}, 2, 0x040F}, /* (CYRILLIC CAPITAL LETTER DZHE) */
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {{'\xe2', '\x84', '\x96'}, 3, 0x2116}, /* (NUMERO SIGN) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xd1', '\x92'}, 2, 0x0452}, /* (CYRILLIC SMALL LETTER DJE) */
    {{'\xd1', '\x93'}, 2, 0x0453}, /* (CYRILLIC SMALL LETTER GJE) */
    {{'\xd1', '\x94'}, 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {{'\xd1', '\x95'}, 2, 0x0455}, /* (CYRILLIC SMALL LETTER DZE) */
    {{'\xd1', '\x96'}, 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xd1', '\x97'}, 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {{'\xd1', '\x98'}, 2, 0x0458}, /* (CYRILLIC SMALL LETTER JE) */
    {{'\xd1', '\x99'}, 2, 0x0459}, /* (CYRILLIC SMALL LETTER LJE) */
    {{'\xd1', '\x9a'}, 2, 0x045A}, /* (CYRILLIC SMALL LETTER NJE) */
    {{'\xd1', '\x9b'}, 2, 0x045B}, /* (CYRILLIC SMALL LETTER TSHE) */
    {{'\xd1', '\x9c'}, 2, 0x045C}, /* (CYRILLIC SMALL LETTER KJE) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xd1', '\x9e'}, 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {{'\xd1', '\x9f'}, 2, 0x045F}, /* (CYRILLIC SMALL LETTER DZHE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_6[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xd8', '\x8c'}, 2, 0x060C}, /* (ARABIC COMMA) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xd8', '\x9b'}, 2, 0x061B}, /* (ARABIC SEMICOLON) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xd8', '\x9f'}, 2, 0x061F}, /* (ARABIC QUESTION MARK) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xd8', '\xa1'}, 2, 0x0621}, /* (ARABIC LETTER HAMZA) */
    {{'\xd8', '\xa2'}, 2, 0x0622}, /* (ARABIC LETTER ALEF WITH MADDA ABOVE) */
    {{'\xd8', '\xa3'}, 2, 0x0623}, /* (ARABIC LETTER ALEF WITH HAMZA ABOVE) */
    {{'\xd8', '\xa4'}, 2, 0x0624}, /* (ARABIC LETTER WAW WITH HAMZA ABOVE) */
    {{'\xd8', '\xa5'}, 2, 0x0625}, /* (ARABIC LETTER ALEF WITH HAMZA BELOW) */
    {{'\xd8', '\xa6'}, 2, 0x0626}, /* (ARABIC LETTER YEH WITH HAMZA ABOVE) */
    {{'\xd8', '\xa7'}, 2, 0x0627}, /* (ARABIC LETTER ALEF) */
    {{'\xd8', '\xa8'}, 2, 0x0628}, /* (ARABIC LETTER BEH) */
    {{'\xd8', '\xa9'}, 2, 0x0629}, /* (ARABIC LETTER TEH MARBUTA) */
    {{'\xd8', '\xaa'}, 2, 0x062A}, /* (ARABIC LETTER TEH) */
    {{'\xd8', '\xab'}, 2, 0x062B}, /* (ARABIC LETTER THEH) */
    {{'\xd8', '\xac'}, 2, 0x062C}, /* (ARABIC LETTER JEEM) */
    {{'\xd8', '\xad'}, 2, 0x062D}, /* (ARABIC LETTER HAH) */
    {{'\xd8', '\xae'}, 2, 0x062E}, /* (ARABIC LETTER KHAH) */
    {{'\xd8', '\xaf'}, 2, 0x062F}, /* (ARABIC LETTER DAL) */
    {{'\xd8', '\xb0'}, 2, 0x0630}, /* (ARABIC LETTER THAL) */
    {{'\xd8', '\xb1'}, 2, 0x0631}, /* (ARABIC LETTER REH) */
    {{'\xd8', '\xb2'}, 2, 0x0632}, /* (ARABIC LETTER ZAIN) */
    {{'\xd8', '\xb3'}, 2, 0x0633}, /* (ARABIC LETTER SEEN) */
    {{'\xd8', '\xb4'}, 2, 0x0634}, /* (ARABIC LETTER SHEEN) */
    {{'\xd8', '\xb5'}, 2, 0x0635}, /* (ARABIC LETTER SAD) */
    {{'\xd8', '\xb6'}, 2, 0x0636}, /* (ARABIC LETTER DAD) */
    {{'\xd8', '\xb7'}, 2, 0x0637}, /* (ARABIC LETTER TAH) */
    {{'\xd8', '\xb8'}, 2, 0x0638}, /* (ARABIC LETTER ZAH) */
    {{'\xd8', '\xb9'}, 2, 0x0639}, /* (ARABIC LETTER AIN) */
    {{'\xd8', '\xba'}, 2, 0x063A}, /* (ARABIC LETTER GHAIN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xd9', '\x80'}, 2, 0x0640}, /* (ARABIC TATWEEL) */
    {{'\xd9', '\x81'}, 2, 0x0641}, /* (ARABIC LETTER FEH) */
    {{'\xd9', '\x82'}, 2, 0x0642}, /* (ARABIC LETTER QAF) */
    {{'\xd9', '\x83'}, 2, 0x0643}, /* (ARABIC LETTER KAF) */
    {{'\xd9', '\x84'}, 2, 0x0644}, /* (ARABIC LETTER LAM) */
    {{'\xd9', '\x85'}, 2, 0x0645}, /* (ARABIC LETTER MEEM) */
    {{'\xd9', '\x86'}, 2, 0x0646}, /* (ARABIC LETTER NOON) */
    {{'\xd9', '\x87'}, 2, 0x0647}, /* (ARABIC LETTER HEH) */
    {{'\xd9', '\x88'}, 2, 0x0648}, /* (ARABIC LETTER WAW) */
    {{'\xd9', '\x89'}, 2, 0x0649}, /* (ARABIC LETTER ALEF MAKSURA) */
    {{'\xd9', '\x8a'}, 2, 0x064A}, /* (ARABIC LETTER YEH) */
    {{'\xd9', '\x8b'}, 2, 0x064B}, /* (ARABIC FATHATAN) */
    {{'\xd9', '\x8c'}, 2, 0x064C}, /* (ARABIC DAMMATAN) */
    {{'\xd9', '\x8d'}, 2, 0x064D}, /* (ARABIC KASRATAN) */
    {{'\xd9', '\x8e'}, 2, 0x064E}, /* (ARABIC FATHA) */
    {{'\xd9', '\x8f'}, 2, 0x064F}, /* (ARABIC DAMMA) */
    {{'\xd9', '\x90'}, 2, 0x0650}, /* (ARABIC KASRA) */
    {{'\xd9', '\x91'}, 2, 0x0651}, /* (ARABIC SHADDA) */
    {{'\xd9', '\x92'}, 2, 0x0652}, /* (ARABIC SUKUN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_7[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xe2', '\x82', '\xaf'}, 3, 0x20AF}, /* (DRACHMA SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xcd', '\xba'}, 2, 0x037A}, /* (GREEK YPOGEGRAMMENI) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xe2', '\x80', '\x95'}, 3, 0x2015}, /* (HORIZONTAL BAR) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xce', '\x84'}, 2, 0x0384}, /* (GREEK TONOS) */
    {{'\xce', '\x85'}, 2, 0x0385}, /* (GREEK DIALYTIKA TONOS) */
    {{'\xce', '\x86'}, 2, 0x0386}, /* (GREEK CAPITAL LETTER ALPHA WITH TONOS) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xce', '\x88'}, 2, 0x0388}, /* (GREEK CAPITAL LETTER EPSILON WITH TONOS) */
    {{'\xce', '\x89'}, 2, 0x0389}, /* (GREEK CAPITAL LETTER ETA WITH TONOS) */
    {{'\xce', '\x8a'}, 2, 0x038A}, /* (GREEK CAPITAL LETTER IOTA WITH TONOS) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xce', '\x8c'}, 2, 0x038C}, /* (GREEK CAPITAL LETTER OMICRON WITH TONOS) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xce', '\x8e'}, 2, 0x038E}, /* (GREEK CAPITAL LETTER UPSILON WITH TONOS) */
    {{'\xce', '\x8f'}, 2, 0x038F}, /* (GREEK CAPITAL LETTER OMEGA WITH TONOS) */
    {{'\xce', '\x90'}, 2, 0x0390}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS) */
    {{'\xce', '\x91'}, 2, 0x0391}, /* (GREEK CAPITAL LETTER ALPHA) */
    {{'\xce', '\x92'}, 2, 0x0392}, /* (GREEK CAPITAL LETTER BETA) */
    {{'\xce', '\x93'}, 2, 0x0393}, /* (GREEK CAPITAL LETTER GAMMA) */
    {{'\xce', '\x94'}, 2, 0x0394}, /* (GREEK CAPITAL LETTER DELTA) */
    {{'\xce', '\x95'}, 2, 0x0395}, /* (GREEK CAPITAL LETTER EPSILON) */
    {{'\xce', '\x96'}, 2, 0x0396}, /* (GREEK CAPITAL LETTER ZETA) */
    {{'\xce', '\x97'}, 2, 0x0397}, /* (GREEK CAPITAL LETTER ETA) */
    {{'\xce', '\x98'}, 2, 0x0398}, /* (GREEK CAPITAL LETTER THETA) */
    {{'\xce', '\x99'}, 2, 0x0399}, /* (GREEK CAPITAL LETTER IOTA) */
    {{'\xce', '\x9a'}, 2, 0x039A}, /* (GREEK CAPITAL LETTER KAPPA) */
    {{'\xce', '\x9b'}, 2, 0x039B}, /* (GREEK CAPITAL LETTER LAMDA) */
    {{'\xce', '\x9c'}, 2, 0x039C}, /* (GREEK CAPITAL LETTER MU) */
    {{'\xce', '\x9d'}, 2, 0x039D}, /* (GREEK CAPITAL LETTER NU) */
    {{'\xce', '\x9e'}, 2, 0x039E}, /* (GREEK CAPITAL LETTER XI) */
    {{'\xce', '\x9f'}, 2, 0x039F}, /* (GREEK CAPITAL LETTER OMICRON) */
    {{'\xce', '\xa0'}, 2, 0x03A0}, /* (GREEK CAPITAL LETTER PI) */
    {{'\xce', '\xa1'}, 2, 0x03A1}, /* (GREEK CAPITAL LETTER RHO) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xce', '\xa3'}, 2, 0x03A3}, /* (GREEK CAPITAL LETTER SIGMA) */
    {{'\xce', '\xa4'}, 2, 0x03A4}, /* (GREEK CAPITAL LETTER TAU) */
    {{'\xce', '\xa5'}, 2, 0x03A5}, /* (GREEK CAPITAL LETTER UPSILON) */
    {{'\xce', '\xa6'}, 2, 0x03A6}, /* (GREEK CAPITAL LETTER PHI) */
    {{'\xce', '\xa7'}, 2, 0x03A7}, /* (GREEK CAPITAL LETTER CHI) */
    {{'\xce', '\xa8'}, 2, 0x03A8}, /* (GREEK CAPITAL LETTER PSI) */
    {{'\xce', '\xa9'}, 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {{'\xce', '\xaa'}, 2, 0x03AA}, /* (GREEK CAPITAL LETTER IOTA WITH DIALYTIKA) */
    {{'\xce', '\xab'}, 2, 0x03AB}, /* (GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA) */
    {{'\xce', '\xac'}, 2, 0x03AC}, /* (GREEK SMALL LETTER ALPHA WITH TONOS) */
    {{'\xce', '\xad'}, 2, 0x03AD}, /* (GREEK SMALL LETTER EPSILON WITH TONOS) */
    {{'\xce', '\xae'}, 2, 0x03AE}, /* (GREEK SMALL LETTER ETA WITH TONOS) */
    {{'\xce', '\xaf'}, 2, 0x03AF}, /* (GREEK SMALL LETTER IOTA WITH TONOS) */
    {{'\xce', '\xb0'}, 2, 0x03B0}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS) */
    {{'\xce', '\xb1'}, 2, 0x03B1}, /* (GREEK SMALL LETTER ALPHA) */
    {{'\xce', '\xb2'}, 2, 0x03B2}, /* (GREEK SMALL LETTER BETA) */
    {{'\xce', '\xb3'}, 2, 0x03B3}, /* (GREEK SMALL LETTER GAMMA) */
    {{'\xce', '\xb4'}, 2, 0x03B4}, /* (GREEK SMALL LETTER DELTA) */
    {{'\xce', '\xb5'}, 2, 0x03B5}, /* (GREEK SMALL LETTER EPSILON) */
    {{'\xce', '\xb6'}, 2, 0x03B6}, /* (GREEK SMALL LETTER ZETA) */
    {{'\xce', '\xb7'}, 2, 0x03B7}, /* (GREEK SMALL LETTER ETA) */
    {{'\xce', '\xb8'}, 2, 0x03B8}, /* (GREEK SMALL LETTER THETA) */
    {{'\xce', '\xb9'}, 2, 0x03B9}, /* (GREEK SMALL LETTER IOTA) */
    {{'\xce', '\xba'}, 2, 0x03BA}, /* (GREEK SMALL LETTER KAPPA) */
    {{'\xce', '\xbb'}, 2, 0x03BB}, /* (GREEK SMALL LETTER LAMDA) */
    {{'\xce', '\xbc'}, 2, 0x03BC}, /* (GREEK SMALL LETTER MU) */
    {{'\xce', '\xbd'}, 2, 0x03BD}, /* (GREEK SMALL LETTER NU) */
    {{'\xce', '\xbe'}, 2, 0x03BE}, /* (GREEK SMALL LETTER XI) */
    {{'\xce', '\xbf'}, 2, 0x03BF}, /* (GREEK SMALL LETTER OMICRON) */
    {{'\xcf', '\x80'}, 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {{'\xcf', '\x81'}, 2, 0x03C1}, /* (GREEK SMALL LETTER RHO) */
    {{'\xcf', '\x82'}, 2, 0x03C2}, /* (GREEK SMALL LETTER FINAL SIGMA) */
    {{'\xcf', '\x83'}, 2, 0x03C3}, /* (GREEK SMALL LETTER SIGMA) */
    {{'\xcf', '\x84'}, 2, 0x03C4}, /* (GREEK SMALL LETTER TAU) */
    {{'\xcf', '\x85'}, 2, 0x03C5}, /* (GREEK SMALL LETTER UPSILON) */
    {{'\xcf', '\x86'}, 2, 0x03C6}, /* (GREEK SMALL LETTER PHI) */
    {{'\xcf', '\x87'}, 2, 0x03C7}, /* (GREEK SMALL LETTER CHI) */
    {{'\xcf', '\x88'}, 2, 0x03C8}, /* (GREEK SMALL LETTER PSI) */
    {{'\xcf', '\x89'}, 2, 0x03C9}, /* (GREEK SMALL LETTER OMEGA) */
    {{'\xcf', '\x8a'}, 2, 0x03CA}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA) */
    {{'\xcf', '\x8b'}, 2, 0x03CB}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA) */
    {{'\xcf', '\x8c'}, 2, 0x03CC}, /* (GREEK SMALL LETTER OMICRON WITH TONOS) */
    {{'\xcf', '\x8d'}, 2, 0x03CD}, /* (GREEK SMALL LETTER UPSILON WITH TONOS) */
    {{'\xcf', '\x8e'}, 2, 0x03CE}, /* (GREEK SMALL LETTER OMEGA WITH TONOS) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_iso_8859_8[128] = 
{
    {{'\xc2', '\x80'}, 2, 0x0080}, /* (<control>) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xc2', '\x85'}, 2, 0x0085}, /* (<control>) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xc2', '\x91'}, 2, 0x0091}, /* (<control>) */
    {{'\xc2', '\x92'}, 2, 0x0092}, /* (<control>) */
    {{'\xc2', '\x93'}, 2, 0x0093}, /* (<control>) */
    {{'\xc2', '\x94'}, 2, 0x0094}, /* (<control>) */
    {{'\xc2', '\x95'}, 2, 0x0095}, /* (<control>) */
    {{'\xc2', '\x96'}, 2, 0x0096}, /* (<control>) */
    {{'\xc2', '\x97'}, 2, 0x0097}, /* (<control>) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xe2', '\x80', '\x97'}, 3, 0x2017}, /* (DOUBLE LOW LINE) */
    {{'\xd7', '\x90'}, 2, 0x05D0}, /* (HEBREW LETTER ALEF) */
    {{'\xd7', '\x91'}, 2, 0x05D1}, /* (HEBREW LETTER BET) */
    {{'\xd7', '\x92'}, 2, 0x05D2}, /* (HEBREW LETTER GIMEL) */
    {{'\xd7', '\x93'}, 2, 0x05D3}, /* (HEBREW LETTER DALET) */
    {{'\xd7', '\x94'}, 2, 0x05D4}, /* (HEBREW LETTER HE) */
    {{'\xd7', '\x95'}, 2, 0x05D5}, /* (HEBREW LETTER VAV) */
    {{'\xd7', '\x96'}, 2, 0x05D6}, /* (HEBREW LETTER ZAYIN) */
    {{'\xd7', '\x97'}, 2, 0x05D7}, /* (HEBREW LETTER HET) */
    {{'\xd7', '\x98'}, 2, 0x05D8}, /* (HEBREW LETTER TET) */
    {{'\xd7', '\x99'}, 2, 0x05D9}, /* (HEBREW LETTER YOD) */
    {{'\xd7', '\x9a'}, 2, 0x05DA}, /* (HEBREW LETTER FINAL KAF) */
    {{'\xd7', '\x9b'}, 2, 0x05DB}, /* (HEBREW LETTER KAF) */
    {{'\xd7', '\x9c'}, 2, 0x05DC}, /* (HEBREW LETTER LAMED) */
    {{'\xd7', '\x9d'}, 2, 0x05DD}, /* (HEBREW LETTER FINAL MEM) */
    {{'\xd7', '\x9e'}, 2, 0x05DE}, /* (HEBREW LETTER MEM) */
    {{'\xd7', '\x9f'}, 2, 0x05DF}, /* (HEBREW LETTER FINAL NUN) */
    {{'\xd7', '\xa0'}, 2, 0x05E0}, /* (HEBREW LETTER NUN) */
    {{'\xd7', '\xa1'}, 2, 0x05E1}, /* (HEBREW LETTER SAMEKH) */
    {{'\xd7', '\xa2'}, 2, 0x05E2}, /* (HEBREW LETTER AYIN) */
    {{'\xd7', '\xa3'}, 2, 0x05E3}, /* (HEBREW LETTER FINAL PE) */
    {{'\xd7', '\xa4'}, 2, 0x05E4}, /* (HEBREW LETTER PE) */
    {{'\xd7', '\xa5'}, 2, 0x05E5}, /* (HEBREW LETTER FINAL TSADI) */
    {{'\xd7', '\xa6'}, 2, 0x05E6}, /* (HEBREW LETTER TSADI) */
    {{'\xd7', '\xa7'}, 2, 0x05E7}, /* (HEBREW LETTER QOF) */
    {{'\xd7', '\xa8'}, 2, 0x05E8}, /* (HEBREW LETTER RESH) */
    {{'\xd7', '\xa9'}, 2, 0x05E9}, /* (HEBREW LETTER SHIN) */
    {{'\xd7', '\xaa'}, 2, 0x05EA}, /* (HEBREW LETTER TAV) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xe2', '\x80', '\x8e'}, 3, 0x200E}, /* (LEFT-TO-RIGHT MARK) */
    {{'\xe2', '\x80', '\x8f'}, 3, 0x200F}, /* (RIGHT-TO-LEFT MARK) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_koi8_r[128] = 
{
    {{'\xe2', '\x94', '\x80'}, 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {{'\xe2', '\x94', '\x82'}, 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {{'\xe2', '\x94', '\x8c'}, 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {{'\xe2', '\x94', '\x90'}, 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {{'\xe2', '\x94', '\x94'}, 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {{'\xe2', '\x94', '\x98'}, 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {{'\xe2', '\x94', '\x9c'}, 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {{'\xe2', '\x94', '\xa4'}, 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {{'\xe2', '\x94', '\xac'}, 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xb4'}, 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xbc'}, 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x96', '\x80'}, 3, 0x2580}, /* (UPPER HALF BLOCK) */
    {{'\xe2', '\x96', '\x84'}, 3, 0x2584}, /* (LOWER HALF BLOCK) */
    {{'\xe2', '\x96', '\x88'}, 3, 0x2588}, /* (FULL BLOCK) */
    {{'\xe2', '\x96', '\x8c'}, 3, 0x258C}, /* (LEFT HALF BLOCK) */
    {{'\xe2', '\x96', '\x90'}, 3, 0x2590}, /* (RIGHT HALF BLOCK) */
    {{'\xe2', '\x96', '\x91'}, 3, 0x2591}, /* (LIGHT SHADE) */
    {{'\xe2', '\x96', '\x92'}, 3, 0x2592}, /* (MEDIUM SHADE) */
    {{'\xe2', '\x96', '\x93'}, 3, 0x2593}, /* (DARK SHADE) */
    {{'\xe2', '\x8c', '\xa0'}, 3, 0x2320}, /* (TOP HALF INTEGRAL) */
    {{'\xe2', '\x96', '\xa0'}, 3, 0x25A0}, /* (BLACK SQUARE) */
    {{'\xe2', '\x88', '\x99'}, 3, 0x2219}, /* (BULLET OPERATOR) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xe2', '\x89', '\x88'}, 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {{'\xe2', '\x89', '\xa4'}, 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {{'\xe2', '\x89', '\xa5'}, 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xe2', '\x8c', '\xa1'}, 3, 0x2321}, /* (BOTTOM HALF INTEGRAL) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xe2', '\x95', '\x90'}, 3, 0x2550}, /* (BOX DRAWINGS DOUBLE HORIZONTAL) */
    {{'\xe2', '\x95', '\x91'}, 3, 0x2551}, /* (BOX DRAWINGS DOUBLE VERTICAL) */
    {{'\xe2', '\x95', '\x92'}, 3, 0x2552}, /* (BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xe2', '\x95', '\x93'}, 3, 0x2553}, /* (BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\x94'}, 3, 0x2554}, /* (BOX DRAWINGS DOUBLE DOWN AND RIGHT) */
    {{'\xe2', '\x95', '\x95'}, 3, 0x2555}, /* (BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE) */
    {{'\xe2', '\x95', '\x96'}, 3, 0x2556}, /* (BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE) */
    {{'\xe2', '\x95', '\x97'}, 3, 0x2557}, /* (BOX DRAWINGS DOUBLE DOWN AND LEFT) */
    {{'\xe2', '\x95', '\x98'}, 3, 0x2558}, /* (BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE) */
    {{'\xe2', '\x95', '\x99'}, 3, 0x2559}, /* (BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\x9a'}, 3, 0x255A}, /* (BOX DRAWINGS DOUBLE UP AND RIGHT) */
    {{'\xe2', '\x95', '\x9b'}, 3, 0x255B}, /* (BOX DRAWINGS UP SINGLE AND LEFT DOUBLE) */
    {{'\xe2', '\x95', '\x9c'}, 3, 0x255C}, /* (BOX DRAWINGS UP DOUBLE AND LEFT SINGLE) */
    {{'\xe2', '\x95', '\x9d'}, 3, 0x255D}, /* (BOX DRAWINGS DOUBLE UP AND LEFT) */
    {{'\xe2', '\x95', '\x9e'}, 3, 0x255E}, /* (BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE) */
    {{'\xe2', '\x95', '\x9f'}, 3, 0x255F}, /* (BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\xa0'}, 3, 0x2560}, /* (BOX DRAWINGS DOUBLE VERTICAL AND RIGHT) */
    {{'\xe2', '\x95', '\xa1'}, 3, 0x2561}, /* (BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xe2', '\x95', '\xa2'}, 3, 0x2562}, /* (BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE) */
    {{'\xe2', '\x95', '\xa3'}, 3, 0x2563}, /* (BOX DRAWINGS DOUBLE VERTICAL AND LEFT) */
    {{'\xe2', '\x95', '\xa4'}, 3, 0x2564}, /* (BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xe2', '\x95', '\xa5'}, 3, 0x2565}, /* (BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE) */
    {{'\xe2', '\x95', '\xa6'}, 3, 0x2566}, /* (BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL) */
    {{'\xe2', '\x95', '\xa7'}, 3, 0x2567}, /* (BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xe2', '\x95', '\xa8'}, 3, 0x2568}, /* (BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE) */
    {{'\xe2', '\x95', '\xa9'}, 3, 0x2569}, /* (BOX DRAWINGS DOUBLE UP AND HORIZONTAL) */
    {{'\xe2', '\x95', '\xaa'}, 3, 0x256A}, /* (BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xe2', '\x95', '\xab'}, 3, 0x256B}, /* (BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE) */
    {{'\xe2', '\x95', '\xac'}, 3, 0x256C}, /* (BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_koi8_u[128] = 
{
    {{'\xe2', '\x94', '\x80'}, 3, 0x2500}, /* (BOX DRAWINGS LIGHT HORIZONTAL) */
    {{'\xe2', '\x94', '\x82'}, 3, 0x2502}, /* (BOX DRAWINGS LIGHT VERTICAL) */
    {{'\xe2', '\x94', '\x8c'}, 3, 0x250C}, /* (BOX DRAWINGS LIGHT DOWN AND RIGHT) */
    {{'\xe2', '\x94', '\x90'}, 3, 0x2510}, /* (BOX DRAWINGS LIGHT DOWN AND LEFT) */
    {{'\xe2', '\x94', '\x94'}, 3, 0x2514}, /* (BOX DRAWINGS LIGHT UP AND RIGHT) */
    {{'\xe2', '\x94', '\x98'}, 3, 0x2518}, /* (BOX DRAWINGS LIGHT UP AND LEFT) */
    {{'\xe2', '\x94', '\x9c'}, 3, 0x251C}, /* (BOX DRAWINGS LIGHT VERTICAL AND RIGHT) */
    {{'\xe2', '\x94', '\xa4'}, 3, 0x2524}, /* (BOX DRAWINGS LIGHT VERTICAL AND LEFT) */
    {{'\xe2', '\x94', '\xac'}, 3, 0x252C}, /* (BOX DRAWINGS LIGHT DOWN AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xb4'}, 3, 0x2534}, /* (BOX DRAWINGS LIGHT UP AND HORIZONTAL) */
    {{'\xe2', '\x94', '\xbc'}, 3, 0x253C}, /* (BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL) */
    {{'\xe2', '\x96', '\x80'}, 3, 0x2580}, /* (UPPER HALF BLOCK) */
    {{'\xe2', '\x96', '\x84'}, 3, 0x2584}, /* (LOWER HALF BLOCK) */
    {{'\xe2', '\x96', '\x88'}, 3, 0x2588}, /* (FULL BLOCK) */
    {{'\xe2', '\x96', '\x8c'}, 3, 0x258C}, /* (LEFT HALF BLOCK) */
    {{'\xe2', '\x96', '\x90'}, 3, 0x2590}, /* (RIGHT HALF BLOCK) */
    {{'\xe2', '\x96', '\x91'}, 3, 0x2591}, /* (LIGHT SHADE) */
    {{'\xe2', '\x96', '\x92'}, 3, 0x2592}, /* (MEDIUM SHADE) */
    {{'\xe2', '\x96', '\x93'}, 3, 0x2593}, /* (DARK SHADE) */
    {{'\xe2', '\x8c', '\xa0'}, 3, 0x2320}, /* (TOP HALF INTEGRAL) */
    {{'\xe2', '\x96', '\xa0'}, 3, 0x25A0}, /* (BLACK SQUARE) */
    {{'\xe2', '\x88', '\x99'}, 3, 0x2219}, /* (BULLET OPERATOR) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xe2', '\x89', '\x88'}, 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {{'\xe2', '\x89', '\xa4'}, 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {{'\xe2', '\x89', '\xa5'}, 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xe2', '\x8c', '\xa1'}, 3, 0x2321}, /* (BOTTOM HALF INTEGRAL) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xe2', '\x95', '\x90'}, 3, 0x2550}, /* (BOX DRAWINGS DOUBLE HORIZONTAL) */
    {{'\xe2', '\x95', '\x91'}, 3, 0x2551}, /* (BOX DRAWINGS DOUBLE VERTICAL) */
    {{'\xe2', '\x95', '\x92'}, 3, 0x2552}, /* (BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xd1', '\x94'}, 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {{'\xe2', '\x95', '\x94'}, 3, 0x2554}, /* (BOX DRAWINGS DOUBLE DOWN AND RIGHT) */
    {{'\xd1', '\x96'}, 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xd1', '\x97'}, 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {{'\xe2', '\x95', '\x97'}, 3, 0x2557}, /* (BOX DRAWINGS DOUBLE DOWN AND LEFT) */
    {{'\xe2', '\x95', '\x98'}, 3, 0x2558}, /* (BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE) */
    {{'\xe2', '\x95', '\x99'}, 3, 0x2559}, /* (BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\x9a'}, 3, 0x255A}, /* (BOX DRAWINGS DOUBLE UP AND RIGHT) */
    {{'\xe2', '\x95', '\x9b'}, 3, 0x255B}, /* (BOX DRAWINGS UP SINGLE AND LEFT DOUBLE) */
    {{'\xd2', '\x91'}, 2, 0x0491}, /* (CYRILLIC SMALL LETTER GHE WITH UPTURN) */
    {{'\xd1', '\x9e'}, 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {{'\xe2', '\x95', '\x9e'}, 3, 0x255E}, /* (BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE) */
    {{'\xe2', '\x95', '\x9f'}, 3, 0x255F}, /* (BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE) */
    {{'\xe2', '\x95', '\xa0'}, 3, 0x2560}, /* (BOX DRAWINGS DOUBLE VERTICAL AND RIGHT) */
    {{'\xe2', '\x95', '\xa1'}, 3, 0x2561}, /* (BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xd0', '\x84'}, 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {{'\xe2', '\x95', '\xa3'}, 3, 0x2563}, /* (BOX DRAWINGS DOUBLE VERTICAL AND LEFT) */
    {{'\xd0', '\x86'}, 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xd0', '\x87'}, 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {{'\xe2', '\x95', '\xa6'}, 3, 0x2566}, /* (BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL) */
    {{'\xe2', '\x95', '\xa7'}, 3, 0x2567}, /* (BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xe2', '\x95', '\xa8'}, 3, 0x2568}, /* (BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE) */
    {{'\xe2', '\x95', '\xa9'}, 3, 0x2569}, /* (BOX DRAWINGS DOUBLE UP AND HORIZONTAL) */
    {{'\xe2', '\x95', '\xaa'}, 3, 0x256A}, /* (BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE) */
    {{'\xd2', '\x90'}, 2, 0x0490}, /* (CYRILLIC CAPITAL LETTER GHE WITH UPTURN) */
    {{'\xd0', '\x8e'}, 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_macintosh[128] = 
{
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x91'}, 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa3'}, 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xac'}, 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\xb1'}, 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb2'}, 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xe2', '\x89', '\xa0'}, 3, 0x2260}, /* (NOT EQUAL TO) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xe2', '\x88', '\x9e'}, 3, 0x221E}, /* (INFINITY) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xe2', '\x89', '\xa4'}, 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {{'\xe2', '\x89', '\xa5'}, 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xe2', '\x88', '\x82'}, 3, 0x2202}, /* (PARTIAL DIFFERENTIAL) */
    {{'\xe2', '\x88', '\x91'}, 3, 0x2211}, /* (N-ARY SUMMATION) */
    {{'\xe2', '\x88', '\x8f'}, 3, 0x220F}, /* (N-ARY PRODUCT) */
    {{'\xcf', '\x80'}, 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {{'\xe2', '\x88', '\xab'}, 3, 0x222B}, /* (INTEGRAL) */
    {{'\xc2', '\xaa'}, 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {{'\xc2', '\xba'}, 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {{'\xce', '\xa9'}, 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc2', '\xbf'}, 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {{'\xc2', '\xa1'}, 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x89', '\x88'}, 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {{'\xe2', '\x88', '\x86'}, 3, 0x2206}, /* (INCREMENT) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x83'}, 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xe2', '\x97', '\x8a'}, 3, 0x25CA}, /* (LOZENGE) */
    {{'\xc3', '\xbf'}, 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
    {{'\xc5', '\xb8'}, 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {{'\xe2', '\x81', '\x84'}, 3, 0x2044}, /* (FRACTION SLASH) */
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xef', '\xac', '\x81'}, 3, 0xFB01}, /* (LATIN SMALL LIGATURE FI) */
    {{'\xef', '\xac', '\x82'}, 3, 0xFB02}, /* (LATIN SMALL LIGATURE FL) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\x8c'}, 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xef', '\xa3', '\xbf'}, 3, 0xF8FF}, /* (<Private Use>) */
    {{'\xc3', '\x92'}, 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc4', '\xb1'}, 2, 0x0131}, /* (LATIN SMALL LETTER DOTLESS I) */
    {{'\xcb', '\x86'}, 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {{'\xcb', '\x9c'}, 2, 0x02DC}, /* (SMALL TILDE) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xcb', '\x98'}, 2, 0x02D8}, /* (BREVE) */
    {{'\xcb', '\x99'}, 2, 0x02D9}, /* (DOT ABOVE) */
    {{'\xcb', '\x9a'}, 2, 0x02DA}, /* (RING ABOVE) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xcb', '\x9d'}, 2, 0x02DD}, /* (DOUBLE ACUTE ACCENT) */
    {{'\xcb', '\x9b'}, 2, 0x02DB}, /* (OGONEK) */
    {{'\xcb', '\x87'}, 2, 0x02C7}, /* (CARON) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1250[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x9a'}, 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {{'\xc5', '\xa4'}, 2, 0x0164}, /* (LATIN CAPITAL LETTER T WITH CARON) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc5', '\xb9'}, 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x9b'}, 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {{'\xc5', '\xa5'}, 2, 0x0165}, /* (LATIN SMALL LETTER T WITH CARON) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xc5', '\xba'}, 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xcb', '\x87'}, 2, 0x02C7}, /* (CARON) */
    {{'\xcb', '\x98'}, 2, 0x02D8}, /* (BREVE) */
    {{'\xc5', '\x81'}, 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc4', '\x84'}, 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc5', '\x9e'}, 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc5', '\xbb'}, 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xcb', '\x9b'}, 2, 0x02DB}, /* (OGONEK) */
    {{'\xc5', '\x82'}, 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc4', '\x85'}, 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {{'\xc5', '\x9f'}, 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc4', '\xbd'}, 2, 0x013D}, /* (LATIN CAPITAL LETTER L WITH CARON) */
    {{'\xcb', '\x9d'}, 2, 0x02DD}, /* (DOUBLE ACUTE ACCENT) */
    {{'\xc4', '\xbe'}, 2, 0x013E}, /* (LATIN SMALL LETTER L WITH CARON) */
    {{'\xc5', '\xbc'}, 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {{'\xc5', '\x94'}, 2, 0x0154}, /* (LATIN CAPITAL LETTER R WITH ACUTE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x82'}, 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\xb9'}, 2, 0x0139}, /* (LATIN CAPITAL LETTER L WITH ACUTE) */
    {{'\xc4', '\x86'}, 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc4', '\x8c'}, 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc4', '\x98'}, 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x9a'}, 2, 0x011A}, /* (LATIN CAPITAL LETTER E WITH CARON) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc4', '\x8e'}, 2, 0x010E}, /* (LATIN CAPITAL LETTER D WITH CARON) */
    {{'\xc4', '\x90'}, 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {{'\xc5', '\x83'}, 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {{'\xc5', '\x87'}, 2, 0x0147}, /* (LATIN CAPITAL LETTER N WITH CARON) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc5', '\x90'}, 2, 0x0150}, /* (LATIN CAPITAL LETTER O WITH DOUBLE ACUTE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc5', '\x98'}, 2, 0x0158}, /* (LATIN CAPITAL LETTER R WITH CARON) */
    {{'\xc5', '\xae'}, 2, 0x016E}, /* (LATIN CAPITAL LETTER U WITH RING ABOVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc5', '\xb0'}, 2, 0x0170}, /* (LATIN CAPITAL LETTER U WITH DOUBLE ACUTE) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\x9d'}, 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {{'\xc5', '\xa2'}, 2, 0x0162}, /* (LATIN CAPITAL LETTER T WITH CEDILLA) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc5', '\x95'}, 2, 0x0155}, /* (LATIN SMALL LETTER R WITH ACUTE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x83'}, 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc4', '\xba'}, 2, 0x013A}, /* (LATIN SMALL LETTER L WITH ACUTE) */
    {{'\xc4', '\x87'}, 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc4', '\x8d'}, 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc4', '\x99'}, 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc4', '\x9b'}, 2, 0x011B}, /* (LATIN SMALL LETTER E WITH CARON) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc4', '\x8f'}, 2, 0x010F}, /* (LATIN SMALL LETTER D WITH CARON) */
    {{'\xc4', '\x91'}, 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {{'\xc5', '\x84'}, 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {{'\xc5', '\x88'}, 2, 0x0148}, /* (LATIN SMALL LETTER N WITH CARON) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc5', '\x91'}, 2, 0x0151}, /* (LATIN SMALL LETTER O WITH DOUBLE ACUTE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc5', '\x99'}, 2, 0x0159}, /* (LATIN SMALL LETTER R WITH CARON) */
    {{'\xc5', '\xaf'}, 2, 0x016F}, /* (LATIN SMALL LETTER U WITH RING ABOVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc5', '\xb1'}, 2, 0x0171}, /* (LATIN SMALL LETTER U WITH DOUBLE ACUTE) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\xbd'}, 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {{'\xc5', '\xa3'}, 2, 0x0163}, /* (LATIN SMALL LETTER T WITH CEDILLA) */
    {{'\xcb', '\x99'}, 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1251[128] = 
{
    {{'\xd0', '\x82'}, 2, 0x0402}, /* (CYRILLIC CAPITAL LETTER DJE) */
    {{'\xd0', '\x83'}, 2, 0x0403}, /* (CYRILLIC CAPITAL LETTER GJE) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xd1', '\x93'}, 2, 0x0453}, /* (CYRILLIC SMALL LETTER GJE) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xd0', '\x89'}, 2, 0x0409}, /* (CYRILLIC CAPITAL LETTER LJE) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xd0', '\x8a'}, 2, 0x040A}, /* (CYRILLIC CAPITAL LETTER NJE) */
    {{'\xd0', '\x8c'}, 2, 0x040C}, /* (CYRILLIC CAPITAL LETTER KJE) */
    {{'\xd0', '\x8b'}, 2, 0x040B}, /* (CYRILLIC CAPITAL LETTER TSHE) */
    {{'\xd0', '\x8f'}, 2, 0x040F}, /* (CYRILLIC CAPITAL LETTER DZHE) */
    {{'\xd1', '\x92'}, 2, 0x0452}, /* (CYRILLIC SMALL LETTER DJE) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xd1', '\x99'}, 2, 0x0459}, /* (CYRILLIC SMALL LETTER LJE) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xd1', '\x9a'}, 2, 0x045A}, /* (CYRILLIC SMALL LETTER NJE) */
    {{'\xd1', '\x9c'}, 2, 0x045C}, /* (CYRILLIC SMALL LETTER KJE) */
    {{'\xd1', '\x9b'}, 2, 0x045B}, /* (CYRILLIC SMALL LETTER TSHE) */
    {{'\xd1', '\x9f'}, 2, 0x045F}, /* (CYRILLIC SMALL LETTER DZHE) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xd0', '\x8e'}, 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {{'\xd1', '\x9e'}, 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {{'\xd0', '\x88'}, 2, 0x0408}, /* (CYRILLIC CAPITAL LETTER JE) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xd2', '\x90'}, 2, 0x0490}, /* (CYRILLIC CAPITAL LETTER GHE WITH UPTURN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xd0', '\x84'}, 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xd0', '\x87'}, 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xd0', '\x86'}, 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xd1', '\x96'}, 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xd2', '\x91'}, 2, 0x0491}, /* (CYRILLIC SMALL LETTER GHE WITH UPTURN) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xe2', '\x84', '\x96'}, 3, 0x2116}, /* (NUMERO SIGN) */
    {{'\xd1', '\x94'}, 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xd1', '\x98'}, 2, 0x0458}, /* (CYRILLIC SMALL LETTER JE) */
    {{'\xd0', '\x85'}, 2, 0x0405}, /* (CYRILLIC CAPITAL LETTER DZE) */
    {{'\xd1', '\x95'}, 2, 0x0455}, /* (CYRILLIC SMALL LETTER DZE) */
    {{'\xd1', '\x97'}, 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1252[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xcb', '\x86'}, 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xcb', '\x9c'}, 2, 0x02DC}, /* (SMALL TILDE) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xc5', '\xb8'}, 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc2', '\xa1'}, 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc2', '\xaa'}, 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc2', '\xba'}, 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xc2', '\xbf'}, 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\x83'}, 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\x8c'}, 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\x90'}, 2, 0x00D0}, /* (LATIN CAPITAL LETTER ETH) */
    {{'\xc3', '\x91'}, 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {{'\xc3', '\x92'}, 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\x9d'}, 2, 0x00DD}, /* (LATIN CAPITAL LETTER Y WITH ACUTE) */
    {{'\xc3', '\x9e'}, 2, 0x00DE}, /* (LATIN CAPITAL LETTER THORN) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\xa3'}, 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\xac'}, 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc3', '\xb0'}, 2, 0x00F0}, /* (LATIN SMALL LETTER ETH) */
    {{'\xc3', '\xb1'}, 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {{'\xc3', '\xb2'}, 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc3', '\xbd'}, 2, 0x00FD}, /* (LATIN SMALL LETTER Y WITH ACUTE) */
    {{'\xc3', '\xbe'}, 2, 0x00FE}, /* (LATIN SMALL LETTER THORN) */
    {{'\xc3', '\xbf'}, 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1253[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xce', '\x85'}, 2, 0x0385}, /* (GREEK DIALYTIKA TONOS) */
    {{'\xce', '\x86'}, 2, 0x0386}, /* (GREEK CAPITAL LETTER ALPHA WITH TONOS) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xe2', '\x80', '\x95'}, 3, 0x2015}, /* (HORIZONTAL BAR) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xce', '\x84'}, 2, 0x0384}, /* (GREEK TONOS) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xce', '\x88'}, 2, 0x0388}, /* (GREEK CAPITAL LETTER EPSILON WITH TONOS) */
    {{'\xce', '\x89'}, 2, 0x0389}, /* (GREEK CAPITAL LETTER ETA WITH TONOS) */
    {{'\xce', '\x8a'}, 2, 0x038A}, /* (GREEK CAPITAL LETTER IOTA WITH TONOS) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xce', '\x8c'}, 2, 0x038C}, /* (GREEK CAPITAL LETTER OMICRON WITH TONOS) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xce', '\x8e'}, 2, 0x038E}, /* (GREEK CAPITAL LETTER UPSILON WITH TONOS) */
    {{'\xce', '\x8f'}, 2, 0x038F}, /* (GREEK CAPITAL LETTER OMEGA WITH TONOS) */
    {{'\xce', '\x90'}, 2, 0x0390}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS) */
    {{'\xce', '\x91'}, 2, 0x0391}, /* (GREEK CAPITAL LETTER ALPHA) */
    {{'\xce', '\x92'}, 2, 0x0392}, /* (GREEK CAPITAL LETTER BETA) */
    {{'\xce', '\x93'}, 2, 0x0393}, /* (GREEK CAPITAL LETTER GAMMA) */
    {{'\xce', '\x94'}, 2, 0x0394}, /* (GREEK CAPITAL LETTER DELTA) */
    {{'\xce', '\x95'}, 2, 0x0395}, /* (GREEK CAPITAL LETTER EPSILON) */
    {{'\xce', '\x96'}, 2, 0x0396}, /* (GREEK CAPITAL LETTER ZETA) */
    {{'\xce', '\x97'}, 2, 0x0397}, /* (GREEK CAPITAL LETTER ETA) */
    {{'\xce', '\x98'}, 2, 0x0398}, /* (GREEK CAPITAL LETTER THETA) */
    {{'\xce', '\x99'}, 2, 0x0399}, /* (GREEK CAPITAL LETTER IOTA) */
    {{'\xce', '\x9a'}, 2, 0x039A}, /* (GREEK CAPITAL LETTER KAPPA) */
    {{'\xce', '\x9b'}, 2, 0x039B}, /* (GREEK CAPITAL LETTER LAMDA) */
    {{'\xce', '\x9c'}, 2, 0x039C}, /* (GREEK CAPITAL LETTER MU) */
    {{'\xce', '\x9d'}, 2, 0x039D}, /* (GREEK CAPITAL LETTER NU) */
    {{'\xce', '\x9e'}, 2, 0x039E}, /* (GREEK CAPITAL LETTER XI) */
    {{'\xce', '\x9f'}, 2, 0x039F}, /* (GREEK CAPITAL LETTER OMICRON) */
    {{'\xce', '\xa0'}, 2, 0x03A0}, /* (GREEK CAPITAL LETTER PI) */
    {{'\xce', '\xa1'}, 2, 0x03A1}, /* (GREEK CAPITAL LETTER RHO) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xce', '\xa3'}, 2, 0x03A3}, /* (GREEK CAPITAL LETTER SIGMA) */
    {{'\xce', '\xa4'}, 2, 0x03A4}, /* (GREEK CAPITAL LETTER TAU) */
    {{'\xce', '\xa5'}, 2, 0x03A5}, /* (GREEK CAPITAL LETTER UPSILON) */
    {{'\xce', '\xa6'}, 2, 0x03A6}, /* (GREEK CAPITAL LETTER PHI) */
    {{'\xce', '\xa7'}, 2, 0x03A7}, /* (GREEK CAPITAL LETTER CHI) */
    {{'\xce', '\xa8'}, 2, 0x03A8}, /* (GREEK CAPITAL LETTER PSI) */
    {{'\xce', '\xa9'}, 2, 0x03A9}, /* (GREEK CAPITAL LETTER OMEGA) */
    {{'\xce', '\xaa'}, 2, 0x03AA}, /* (GREEK CAPITAL LETTER IOTA WITH DIALYTIKA) */
    {{'\xce', '\xab'}, 2, 0x03AB}, /* (GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA) */
    {{'\xce', '\xac'}, 2, 0x03AC}, /* (GREEK SMALL LETTER ALPHA WITH TONOS) */
    {{'\xce', '\xad'}, 2, 0x03AD}, /* (GREEK SMALL LETTER EPSILON WITH TONOS) */
    {{'\xce', '\xae'}, 2, 0x03AE}, /* (GREEK SMALL LETTER ETA WITH TONOS) */
    {{'\xce', '\xaf'}, 2, 0x03AF}, /* (GREEK SMALL LETTER IOTA WITH TONOS) */
    {{'\xce', '\xb0'}, 2, 0x03B0}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS) */
    {{'\xce', '\xb1'}, 2, 0x03B1}, /* (GREEK SMALL LETTER ALPHA) */
    {{'\xce', '\xb2'}, 2, 0x03B2}, /* (GREEK SMALL LETTER BETA) */
    {{'\xce', '\xb3'}, 2, 0x03B3}, /* (GREEK SMALL LETTER GAMMA) */
    {{'\xce', '\xb4'}, 2, 0x03B4}, /* (GREEK SMALL LETTER DELTA) */
    {{'\xce', '\xb5'}, 2, 0x03B5}, /* (GREEK SMALL LETTER EPSILON) */
    {{'\xce', '\xb6'}, 2, 0x03B6}, /* (GREEK SMALL LETTER ZETA) */
    {{'\xce', '\xb7'}, 2, 0x03B7}, /* (GREEK SMALL LETTER ETA) */
    {{'\xce', '\xb8'}, 2, 0x03B8}, /* (GREEK SMALL LETTER THETA) */
    {{'\xce', '\xb9'}, 2, 0x03B9}, /* (GREEK SMALL LETTER IOTA) */
    {{'\xce', '\xba'}, 2, 0x03BA}, /* (GREEK SMALL LETTER KAPPA) */
    {{'\xce', '\xbb'}, 2, 0x03BB}, /* (GREEK SMALL LETTER LAMDA) */
    {{'\xce', '\xbc'}, 2, 0x03BC}, /* (GREEK SMALL LETTER MU) */
    {{'\xce', '\xbd'}, 2, 0x03BD}, /* (GREEK SMALL LETTER NU) */
    {{'\xce', '\xbe'}, 2, 0x03BE}, /* (GREEK SMALL LETTER XI) */
    {{'\xce', '\xbf'}, 2, 0x03BF}, /* (GREEK SMALL LETTER OMICRON) */
    {{'\xcf', '\x80'}, 2, 0x03C0}, /* (GREEK SMALL LETTER PI) */
    {{'\xcf', '\x81'}, 2, 0x03C1}, /* (GREEK SMALL LETTER RHO) */
    {{'\xcf', '\x82'}, 2, 0x03C2}, /* (GREEK SMALL LETTER FINAL SIGMA) */
    {{'\xcf', '\x83'}, 2, 0x03C3}, /* (GREEK SMALL LETTER SIGMA) */
    {{'\xcf', '\x84'}, 2, 0x03C4}, /* (GREEK SMALL LETTER TAU) */
    {{'\xcf', '\x85'}, 2, 0x03C5}, /* (GREEK SMALL LETTER UPSILON) */
    {{'\xcf', '\x86'}, 2, 0x03C6}, /* (GREEK SMALL LETTER PHI) */
    {{'\xcf', '\x87'}, 2, 0x03C7}, /* (GREEK SMALL LETTER CHI) */
    {{'\xcf', '\x88'}, 2, 0x03C8}, /* (GREEK SMALL LETTER PSI) */
    {{'\xcf', '\x89'}, 2, 0x03C9}, /* (GREEK SMALL LETTER OMEGA) */
    {{'\xcf', '\x8a'}, 2, 0x03CA}, /* (GREEK SMALL LETTER IOTA WITH DIALYTIKA) */
    {{'\xcf', '\x8b'}, 2, 0x03CB}, /* (GREEK SMALL LETTER UPSILON WITH DIALYTIKA) */
    {{'\xcf', '\x8c'}, 2, 0x03CC}, /* (GREEK SMALL LETTER OMICRON WITH TONOS) */
    {{'\xcf', '\x8d'}, 2, 0x03CD}, /* (GREEK SMALL LETTER UPSILON WITH TONOS) */
    {{'\xcf', '\x8e'}, 2, 0x03CE}, /* (GREEK SMALL LETTER OMEGA WITH TONOS) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1254[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xcb', '\x86'}, 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xcb', '\x9c'}, 2, 0x02DC}, /* (SMALL TILDE) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc5', '\xb8'}, 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc2', '\xa1'}, 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc2', '\xaa'}, 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc2', '\xba'}, 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xc2', '\xbf'}, 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\x83'}, 2, 0x00C3}, /* (LATIN CAPITAL LETTER A WITH TILDE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\x8c'}, 2, 0x00CC}, /* (LATIN CAPITAL LETTER I WITH GRAVE) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc4', '\x9e'}, 2, 0x011E}, /* (LATIN CAPITAL LETTER G WITH BREVE) */
    {{'\xc3', '\x91'}, 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {{'\xc3', '\x92'}, 2, 0x00D2}, /* (LATIN CAPITAL LETTER O WITH GRAVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc4', '\xb0'}, 2, 0x0130}, /* (LATIN CAPITAL LETTER I WITH DOT ABOVE) */
    {{'\xc5', '\x9e'}, 2, 0x015E}, /* (LATIN CAPITAL LETTER S WITH CEDILLA) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc3', '\xa3'}, 2, 0x00E3}, /* (LATIN SMALL LETTER A WITH TILDE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xc3', '\xac'}, 2, 0x00EC}, /* (LATIN SMALL LETTER I WITH GRAVE) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc4', '\x9f'}, 2, 0x011F}, /* (LATIN SMALL LETTER G WITH BREVE) */
    {{'\xc3', '\xb1'}, 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {{'\xc3', '\xb2'}, 2, 0x00F2}, /* (LATIN SMALL LETTER O WITH GRAVE) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc4', '\xb1'}, 2, 0x0131}, /* (LATIN SMALL LETTER DOTLESS I) */
    {{'\xc5', '\x9f'}, 2, 0x015F}, /* (LATIN SMALL LETTER S WITH CEDILLA) */
    {{'\xc3', '\xbf'}, 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1255[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xcb', '\x86'}, 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xcb', '\x9c'}, 2, 0x02DC}, /* (SMALL TILDE) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc2', '\xa1'}, 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xe2', '\x82', '\xaa'}, 3, 0x20AA}, /* (NEW SHEQEL SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xc2', '\xbf'}, 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {{'\xd6', '\xb0'}, 2, 0x05B0}, /* (HEBREW POINT SHEVA) */
    {{'\xd6', '\xb1'}, 2, 0x05B1}, /* (HEBREW POINT HATAF SEGOL) */
    {{'\xd6', '\xb2'}, 2, 0x05B2}, /* (HEBREW POINT HATAF PATAH) */
    {{'\xd6', '\xb3'}, 2, 0x05B3}, /* (HEBREW POINT HATAF QAMATS) */
    {{'\xd6', '\xb4'}, 2, 0x05B4}, /* (HEBREW POINT HIRIQ) */
    {{'\xd6', '\xb5'}, 2, 0x05B5}, /* (HEBREW POINT TSERE) */
    {{'\xd6', '\xb6'}, 2, 0x05B6}, /* (HEBREW POINT SEGOL) */
    {{'\xd6', '\xb7'}, 2, 0x05B7}, /* (HEBREW POINT PATAH) */
    {{'\xd6', '\xb8'}, 2, 0x05B8}, /* (HEBREW POINT QAMATS) */
    {{'\xd6', '\xb9'}, 2, 0x05B9}, /* (HEBREW POINT HOLAM) */
    {{'\xd6', '\xba'}, 2, 0x05BA}, /* (HEBREW POINT HOLAM HASER FOR VAV) */
    {{'\xd6', '\xbb'}, 2, 0x05BB}, /* (HEBREW POINT QUBUTS) */
    {{'\xd6', '\xbc'}, 2, 0x05BC}, /* (HEBREW POINT DAGESH OR MAPIQ) */
    {{'\xd6', '\xbd'}, 2, 0x05BD}, /* (HEBREW POINT METEG) */
    {{'\xd6', '\xbe'}, 2, 0x05BE}, /* (HEBREW PUNCTUATION MAQAF) */
    {{'\xd6', '\xbf'}, 2, 0x05BF}, /* (HEBREW POINT RAFE) */
    {{'\xd7', '\x80'}, 2, 0x05C0}, /* (HEBREW PUNCTUATION PASEQ) */
    {{'\xd7', '\x81'}, 2, 0x05C1}, /* (HEBREW POINT SHIN DOT) */
    {{'\xd7', '\x82'}, 2, 0x05C2}, /* (HEBREW POINT SIN DOT) */
    {{'\xd7', '\x83'}, 2, 0x05C3}, /* (HEBREW PUNCTUATION SOF PASUQ) */
    {{'\xd7', '\xb0'}, 2, 0x05F0}, /* (HEBREW LIGATURE YIDDISH DOUBLE VAV) */
    {{'\xd7', '\xb1'}, 2, 0x05F1}, /* (HEBREW LIGATURE YIDDISH VAV YOD) */
    {{'\xd7', '\xb2'}, 2, 0x05F2}, /* (HEBREW LIGATURE YIDDISH DOUBLE YOD) */
    {{'\xd7', '\xb3'}, 2, 0x05F3}, /* (HEBREW PUNCTUATION GERESH) */
    {{'\xd7', '\xb4'}, 2, 0x05F4}, /* (HEBREW PUNCTUATION GERSHAYIM) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xd7', '\x90'}, 2, 0x05D0}, /* (HEBREW LETTER ALEF) */
    {{'\xd7', '\x91'}, 2, 0x05D1}, /* (HEBREW LETTER BET) */
    {{'\xd7', '\x92'}, 2, 0x05D2}, /* (HEBREW LETTER GIMEL) */
    {{'\xd7', '\x93'}, 2, 0x05D3}, /* (HEBREW LETTER DALET) */
    {{'\xd7', '\x94'}, 2, 0x05D4}, /* (HEBREW LETTER HE) */
    {{'\xd7', '\x95'}, 2, 0x05D5}, /* (HEBREW LETTER VAV) */
    {{'\xd7', '\x96'}, 2, 0x05D6}, /* (HEBREW LETTER ZAYIN) */
    {{'\xd7', '\x97'}, 2, 0x05D7}, /* (HEBREW LETTER HET) */
    {{'\xd7', '\x98'}, 2, 0x05D8}, /* (HEBREW LETTER TET) */
    {{'\xd7', '\x99'}, 2, 0x05D9}, /* (HEBREW LETTER YOD) */
    {{'\xd7', '\x9a'}, 2, 0x05DA}, /* (HEBREW LETTER FINAL KAF) */
    {{'\xd7', '\x9b'}, 2, 0x05DB}, /* (HEBREW LETTER KAF) */
    {{'\xd7', '\x9c'}, 2, 0x05DC}, /* (HEBREW LETTER LAMED) */
    {{'\xd7', '\x9d'}, 2, 0x05DD}, /* (HEBREW LETTER FINAL MEM) */
    {{'\xd7', '\x9e'}, 2, 0x05DE}, /* (HEBREW LETTER MEM) */
    {{'\xd7', '\x9f'}, 2, 0x05DF}, /* (HEBREW LETTER FINAL NUN) */
    {{'\xd7', '\xa0'}, 2, 0x05E0}, /* (HEBREW LETTER NUN) */
    {{'\xd7', '\xa1'}, 2, 0x05E1}, /* (HEBREW LETTER SAMEKH) */
    {{'\xd7', '\xa2'}, 2, 0x05E2}, /* (HEBREW LETTER AYIN) */
    {{'\xd7', '\xa3'}, 2, 0x05E3}, /* (HEBREW LETTER FINAL PE) */
    {{'\xd7', '\xa4'}, 2, 0x05E4}, /* (HEBREW LETTER PE) */
    {{'\xd7', '\xa5'}, 2, 0x05E5}, /* (HEBREW LETTER FINAL TSADI) */
    {{'\xd7', '\xa6'}, 2, 0x05E6}, /* (HEBREW LETTER TSADI) */
    {{'\xd7', '\xa7'}, 2, 0x05E7}, /* (HEBREW LETTER QOF) */
    {{'\xd7', '\xa8'}, 2, 0x05E8}, /* (HEBREW LETTER RESH) */
    {{'\xd7', '\xa9'}, 2, 0x05E9}, /* (HEBREW LETTER SHIN) */
    {{'\xd7', '\xaa'}, 2, 0x05EA}, /* (HEBREW LETTER TAV) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xe2', '\x80', '\x8e'}, 3, 0x200E}, /* (LEFT-TO-RIGHT MARK) */
    {{'\xe2', '\x80', '\x8f'}, 3, 0x200F}, /* (RIGHT-TO-LEFT MARK) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1256[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xd9', '\xbe'}, 2, 0x067E}, /* (ARABIC LETTER PEH) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xcb', '\x86'}, 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xd9', '\xb9'}, 2, 0x0679}, /* (ARABIC LETTER TTEH) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xda', '\x86'}, 2, 0x0686}, /* (ARABIC LETTER TCHEH) */
    {{'\xda', '\x98'}, 2, 0x0698}, /* (ARABIC LETTER JEH) */
    {{'\xda', '\x88'}, 2, 0x0688}, /* (ARABIC LETTER DDAL) */
    {{'\xda', '\xaf'}, 2, 0x06AF}, /* (ARABIC LETTER GAF) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xda', '\xa9'}, 2, 0x06A9}, /* (ARABIC LETTER KEHEH) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xda', '\x91'}, 2, 0x0691}, /* (ARABIC LETTER RREH) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xe2', '\x80', '\x8c'}, 3, 0x200C}, /* (ZERO WIDTH NON-JOINER) */
    {{'\xe2', '\x80', '\x8d'}, 3, 0x200D}, /* (ZERO WIDTH JOINER) */
    {{'\xda', '\xba'}, 2, 0x06BA}, /* (ARABIC LETTER NOON GHUNNA) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xd8', '\x8c'}, 2, 0x060C}, /* (ARABIC COMMA) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xda', '\xbe'}, 2, 0x06BE}, /* (ARABIC LETTER HEH DOACHASHMEE) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xd8', '\x9b'}, 2, 0x061B}, /* (ARABIC SEMICOLON) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xd8', '\x9f'}, 2, 0x061F}, /* (ARABIC QUESTION MARK) */
    {{'\xdb', '\x81'}, 2, 0x06C1}, /* (ARABIC LETTER HEH GOAL) */
    {{'\xd8', '\xa1'}, 2, 0x0621}, /* (ARABIC LETTER HAMZA) */
    {{'\xd8', '\xa2'}, 2, 0x0622}, /* (ARABIC LETTER ALEF WITH MADDA ABOVE) */
    {{'\xd8', '\xa3'}, 2, 0x0623}, /* (ARABIC LETTER ALEF WITH HAMZA ABOVE) */
    {{'\xd8', '\xa4'}, 2, 0x0624}, /* (ARABIC LETTER WAW WITH HAMZA ABOVE) */
    {{'\xd8', '\xa5'}, 2, 0x0625}, /* (ARABIC LETTER ALEF WITH HAMZA BELOW) */
    {{'\xd8', '\xa6'}, 2, 0x0626}, /* (ARABIC LETTER YEH WITH HAMZA ABOVE) */
    {{'\xd8', '\xa7'}, 2, 0x0627}, /* (ARABIC LETTER ALEF) */
    {{'\xd8', '\xa8'}, 2, 0x0628}, /* (ARABIC LETTER BEH) */
    {{'\xd8', '\xa9'}, 2, 0x0629}, /* (ARABIC LETTER TEH MARBUTA) */
    {{'\xd8', '\xaa'}, 2, 0x062A}, /* (ARABIC LETTER TEH) */
    {{'\xd8', '\xab'}, 2, 0x062B}, /* (ARABIC LETTER THEH) */
    {{'\xd8', '\xac'}, 2, 0x062C}, /* (ARABIC LETTER JEEM) */
    {{'\xd8', '\xad'}, 2, 0x062D}, /* (ARABIC LETTER HAH) */
    {{'\xd8', '\xae'}, 2, 0x062E}, /* (ARABIC LETTER KHAH) */
    {{'\xd8', '\xaf'}, 2, 0x062F}, /* (ARABIC LETTER DAL) */
    {{'\xd8', '\xb0'}, 2, 0x0630}, /* (ARABIC LETTER THAL) */
    {{'\xd8', '\xb1'}, 2, 0x0631}, /* (ARABIC LETTER REH) */
    {{'\xd8', '\xb2'}, 2, 0x0632}, /* (ARABIC LETTER ZAIN) */
    {{'\xd8', '\xb3'}, 2, 0x0633}, /* (ARABIC LETTER SEEN) */
    {{'\xd8', '\xb4'}, 2, 0x0634}, /* (ARABIC LETTER SHEEN) */
    {{'\xd8', '\xb5'}, 2, 0x0635}, /* (ARABIC LETTER SAD) */
    {{'\xd8', '\xb6'}, 2, 0x0636}, /* (ARABIC LETTER DAD) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xd8', '\xb7'}, 2, 0x0637}, /* (ARABIC LETTER TAH) */
    {{'\xd8', '\xb8'}, 2, 0x0638}, /* (ARABIC LETTER ZAH) */
    {{'\xd8', '\xb9'}, 2, 0x0639}, /* (ARABIC LETTER AIN) */
    {{'\xd8', '\xba'}, 2, 0x063A}, /* (ARABIC LETTER GHAIN) */
    {{'\xd9', '\x80'}, 2, 0x0640}, /* (ARABIC TATWEEL) */
    {{'\xd9', '\x81'}, 2, 0x0641}, /* (ARABIC LETTER FEH) */
    {{'\xd9', '\x82'}, 2, 0x0642}, /* (ARABIC LETTER QAF) */
    {{'\xd9', '\x83'}, 2, 0x0643}, /* (ARABIC LETTER KAF) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xd9', '\x84'}, 2, 0x0644}, /* (ARABIC LETTER LAM) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xd9', '\x85'}, 2, 0x0645}, /* (ARABIC LETTER MEEM) */
    {{'\xd9', '\x86'}, 2, 0x0646}, /* (ARABIC LETTER NOON) */
    {{'\xd9', '\x87'}, 2, 0x0647}, /* (ARABIC LETTER HEH) */
    {{'\xd9', '\x88'}, 2, 0x0648}, /* (ARABIC LETTER WAW) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xd9', '\x89'}, 2, 0x0649}, /* (ARABIC LETTER ALEF MAKSURA) */
    {{'\xd9', '\x8a'}, 2, 0x064A}, /* (ARABIC LETTER YEH) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xd9', '\x8b'}, 2, 0x064B}, /* (ARABIC FATHATAN) */
    {{'\xd9', '\x8c'}, 2, 0x064C}, /* (ARABIC DAMMATAN) */
    {{'\xd9', '\x8d'}, 2, 0x064D}, /* (ARABIC KASRATAN) */
    {{'\xd9', '\x8e'}, 2, 0x064E}, /* (ARABIC FATHA) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xd9', '\x8f'}, 2, 0x064F}, /* (ARABIC DAMMA) */
    {{'\xd9', '\x90'}, 2, 0x0650}, /* (ARABIC KASRA) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xd9', '\x91'}, 2, 0x0651}, /* (ARABIC SHADDA) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xd9', '\x92'}, 2, 0x0652}, /* (ARABIC SUKUN) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xe2', '\x80', '\x8e'}, 3, 0x200E}, /* (LEFT-TO-RIGHT MARK) */
    {{'\xe2', '\x80', '\x8f'}, 3, 0x200F}, /* (RIGHT-TO-LEFT MARK) */
    {{'\xdb', '\x92'}, 2, 0x06D2}, /* (ARABIC LETTER YEH BARREE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1257[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xcb', '\x87'}, 2, 0x02C7}, /* (CARON) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xcb', '\x9b'}, 2, 0x02DB}, /* (OGONEK) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc5', '\x96'}, 2, 0x0156}, /* (LATIN CAPITAL LETTER R WITH CEDILLA) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc5', '\x97'}, 2, 0x0157}, /* (LATIN SMALL LETTER R WITH CEDILLA) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc4', '\x84'}, 2, 0x0104}, /* (LATIN CAPITAL LETTER A WITH OGONEK) */
    {{'\xc4', '\xae'}, 2, 0x012E}, /* (LATIN CAPITAL LETTER I WITH OGONEK) */
    {{'\xc4', '\x80'}, 2, 0x0100}, /* (LATIN CAPITAL LETTER A WITH MACRON) */
    {{'\xc4', '\x86'}, 2, 0x0106}, /* (LATIN CAPITAL LETTER C WITH ACUTE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc4', '\x98'}, 2, 0x0118}, /* (LATIN CAPITAL LETTER E WITH OGONEK) */
    {{'\xc4', '\x92'}, 2, 0x0112}, /* (LATIN CAPITAL LETTER E WITH MACRON) */
    {{'\xc4', '\x8c'}, 2, 0x010C}, /* (LATIN CAPITAL LETTER C WITH CARON) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc5', '\xb9'}, 2, 0x0179}, /* (LATIN CAPITAL LETTER Z WITH ACUTE) */
    {{'\xc4', '\x96'}, 2, 0x0116}, /* (LATIN CAPITAL LETTER E WITH DOT ABOVE) */
    {{'\xc4', '\xa2'}, 2, 0x0122}, /* (LATIN CAPITAL LETTER G WITH CEDILLA) */
    {{'\xc4', '\xb6'}, 2, 0x0136}, /* (LATIN CAPITAL LETTER K WITH CEDILLA) */
    {{'\xc4', '\xaa'}, 2, 0x012A}, /* (LATIN CAPITAL LETTER I WITH MACRON) */
    {{'\xc4', '\xbb'}, 2, 0x013B}, /* (LATIN CAPITAL LETTER L WITH CEDILLA) */
    {{'\xc5', '\xa0'}, 2, 0x0160}, /* (LATIN CAPITAL LETTER S WITH CARON) */
    {{'\xc5', '\x83'}, 2, 0x0143}, /* (LATIN CAPITAL LETTER N WITH ACUTE) */
    {{'\xc5', '\x85'}, 2, 0x0145}, /* (LATIN CAPITAL LETTER N WITH CEDILLA) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc5', '\x8c'}, 2, 0x014C}, /* (LATIN CAPITAL LETTER O WITH MACRON) */
    {{'\xc3', '\x95'}, 2, 0x00D5}, /* (LATIN CAPITAL LETTER O WITH TILDE) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc5', '\xb2'}, 2, 0x0172}, /* (LATIN CAPITAL LETTER U WITH OGONEK) */
    {{'\xc5', '\x81'}, 2, 0x0141}, /* (LATIN CAPITAL LETTER L WITH STROKE) */
    {{'\xc5', '\x9a'}, 2, 0x015A}, /* (LATIN CAPITAL LETTER S WITH ACUTE) */
    {{'\xc5', '\xaa'}, 2, 0x016A}, /* (LATIN CAPITAL LETTER U WITH MACRON) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xbb'}, 2, 0x017B}, /* (LATIN CAPITAL LETTER Z WITH DOT ABOVE) */
    {{'\xc5', '\xbd'}, 2, 0x017D}, /* (LATIN CAPITAL LETTER Z WITH CARON) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc4', '\x85'}, 2, 0x0105}, /* (LATIN SMALL LETTER A WITH OGONEK) */
    {{'\xc4', '\xaf'}, 2, 0x012F}, /* (LATIN SMALL LETTER I WITH OGONEK) */
    {{'\xc4', '\x81'}, 2, 0x0101}, /* (LATIN SMALL LETTER A WITH MACRON) */
    {{'\xc4', '\x87'}, 2, 0x0107}, /* (LATIN SMALL LETTER C WITH ACUTE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc4', '\x99'}, 2, 0x0119}, /* (LATIN SMALL LETTER E WITH OGONEK) */
    {{'\xc4', '\x93'}, 2, 0x0113}, /* (LATIN SMALL LETTER E WITH MACRON) */
    {{'\xc4', '\x8d'}, 2, 0x010D}, /* (LATIN SMALL LETTER C WITH CARON) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc5', '\xba'}, 2, 0x017A}, /* (LATIN SMALL LETTER Z WITH ACUTE) */
    {{'\xc4', '\x97'}, 2, 0x0117}, /* (LATIN SMALL LETTER E WITH DOT ABOVE) */
    {{'\xc4', '\xa3'}, 2, 0x0123}, /* (LATIN SMALL LETTER G WITH CEDILLA) */
    {{'\xc4', '\xb7'}, 2, 0x0137}, /* (LATIN SMALL LETTER K WITH CEDILLA) */
    {{'\xc4', '\xab'}, 2, 0x012B}, /* (LATIN SMALL LETTER I WITH MACRON) */
    {{'\xc4', '\xbc'}, 2, 0x013C}, /* (LATIN SMALL LETTER L WITH CEDILLA) */
    {{'\xc5', '\xa1'}, 2, 0x0161}, /* (LATIN SMALL LETTER S WITH CARON) */
    {{'\xc5', '\x84'}, 2, 0x0144}, /* (LATIN SMALL LETTER N WITH ACUTE) */
    {{'\xc5', '\x86'}, 2, 0x0146}, /* (LATIN SMALL LETTER N WITH CEDILLA) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc5', '\x8d'}, 2, 0x014D}, /* (LATIN SMALL LETTER O WITH MACRON) */
    {{'\xc3', '\xb5'}, 2, 0x00F5}, /* (LATIN SMALL LETTER O WITH TILDE) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc5', '\xb3'}, 2, 0x0173}, /* (LATIN SMALL LETTER U WITH OGONEK) */
    {{'\xc5', '\x82'}, 2, 0x0142}, /* (LATIN SMALL LETTER L WITH STROKE) */
    {{'\xc5', '\x9b'}, 2, 0x015B}, /* (LATIN SMALL LETTER S WITH ACUTE) */
    {{'\xc5', '\xab'}, 2, 0x016B}, /* (LATIN SMALL LETTER U WITH MACRON) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc5', '\xbc'}, 2, 0x017C}, /* (LATIN SMALL LETTER Z WITH DOT ABOVE) */
    {{'\xc5', '\xbe'}, 2, 0x017E}, /* (LATIN SMALL LETTER Z WITH CARON) */
    {{'\xcb', '\x99'}, 2, 0x02D9}, /* (DOT ABOVE) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_1258[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xe2', '\x80', '\x9a'}, 3, 0x201A}, /* (SINGLE LOW-9 QUOTATION MARK) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xe2', '\x80', '\xa1'}, 3, 0x2021}, /* (DOUBLE DAGGER) */
    {{'\xcb', '\x86'}, 2, 0x02C6}, /* (MODIFIER LETTER CIRCUMFLEX ACCENT) */
    {{'\xe2', '\x80', '\xb0'}, 3, 0x2030}, /* (PER MILLE SIGN) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xe2', '\x80', '\xb9'}, 3, 0x2039}, /* (SINGLE LEFT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x92'}, 2, 0x0152}, /* (LATIN CAPITAL LIGATURE OE) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xcb', '\x9c'}, 2, 0x02DC}, /* (SMALL TILDE) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xe2', '\x80', '\xba'}, 3, 0x203A}, /* (SINGLE RIGHT-POINTING ANGLE QUOTATION MARK) */
    {{'\xc5', '\x93'}, 2, 0x0153}, /* (LATIN SMALL LIGATURE OE) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc5', '\xb8'}, 2, 0x0178}, /* (LATIN CAPITAL LETTER Y WITH DIAERESIS) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xc2', '\xa1'}, 2, 0x00A1}, /* (INVERTED EXCLAMATION MARK) */
    {{'\xc2', '\xa2'}, 2, 0x00A2}, /* (CENT SIGN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa4'}, 2, 0x00A4}, /* (CURRENCY SIGN) */
    {{'\xc2', '\xa5'}, 2, 0x00A5}, /* (YEN SIGN) */
    {{'\xc2', '\xa6'}, 2, 0x00A6}, /* (BROKEN BAR) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xc2', '\xa8'}, 2, 0x00A8}, /* (DIAERESIS) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xc2', '\xaa'}, 2, 0x00AA}, /* (FEMININE ORDINAL INDICATOR) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xc2', '\xad'}, 2, 0x00AD}, /* (SOFT HYPHEN) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xaf'}, 2, 0x00AF}, /* (MACRON) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xc2', '\xb2'}, 2, 0x00B2}, /* (SUPERSCRIPT TWO) */
    {{'\xc2', '\xb3'}, 2, 0x00B3}, /* (SUPERSCRIPT THREE) */
    {{'\xc2', '\xb4'}, 2, 0x00B4}, /* (ACUTE ACCENT) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xc2', '\xb7'}, 2, 0x00B7}, /* (MIDDLE DOT) */
    {{'\xc2', '\xb8'}, 2, 0x00B8}, /* (CEDILLA) */
    {{'\xc2', '\xb9'}, 2, 0x00B9}, /* (SUPERSCRIPT ONE) */
    {{'\xc2', '\xba'}, 2, 0x00BA}, /* (MASCULINE ORDINAL INDICATOR) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbc'}, 2, 0x00BC}, /* (VULGAR FRACTION ONE QUARTER) */
    {{'\xc2', '\xbd'}, 2, 0x00BD}, /* (VULGAR FRACTION ONE HALF) */
    {{'\xc2', '\xbe'}, 2, 0x00BE}, /* (VULGAR FRACTION THREE QUARTERS) */
    {{'\xc2', '\xbf'}, 2, 0x00BF}, /* (INVERTED QUESTION MARK) */
    {{'\xc3', '\x80'}, 2, 0x00C0}, /* (LATIN CAPITAL LETTER A WITH GRAVE) */
    {{'\xc3', '\x81'}, 2, 0x00C1}, /* (LATIN CAPITAL LETTER A WITH ACUTE) */
    {{'\xc3', '\x82'}, 2, 0x00C2}, /* (LATIN CAPITAL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x82'}, 2, 0x0102}, /* (LATIN CAPITAL LETTER A WITH BREVE) */
    {{'\xc3', '\x84'}, 2, 0x00C4}, /* (LATIN CAPITAL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\x85'}, 2, 0x00C5}, /* (LATIN CAPITAL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\x86'}, 2, 0x00C6}, /* (LATIN CAPITAL LETTER AE) */
    {{'\xc3', '\x87'}, 2, 0x00C7}, /* (LATIN CAPITAL LETTER C WITH CEDILLA) */
    {{'\xc3', '\x88'}, 2, 0x00C8}, /* (LATIN CAPITAL LETTER E WITH GRAVE) */
    {{'\xc3', '\x89'}, 2, 0x00C9}, /* (LATIN CAPITAL LETTER E WITH ACUTE) */
    {{'\xc3', '\x8a'}, 2, 0x00CA}, /* (LATIN CAPITAL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\x8b'}, 2, 0x00CB}, /* (LATIN CAPITAL LETTER E WITH DIAERESIS) */
    {{'\xcc', '\x80'}, 2, 0x0300}, /* (COMBINING GRAVE ACCENT) */
    {{'\xc3', '\x8d'}, 2, 0x00CD}, /* (LATIN CAPITAL LETTER I WITH ACUTE) */
    {{'\xc3', '\x8e'}, 2, 0x00CE}, /* (LATIN CAPITAL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\x8f'}, 2, 0x00CF}, /* (LATIN CAPITAL LETTER I WITH DIAERESIS) */
    {{'\xc4', '\x90'}, 2, 0x0110}, /* (LATIN CAPITAL LETTER D WITH STROKE) */
    {{'\xc3', '\x91'}, 2, 0x00D1}, /* (LATIN CAPITAL LETTER N WITH TILDE) */
    {{'\xcc', '\x89'}, 2, 0x0309}, /* (COMBINING HOOK ABOVE) */
    {{'\xc3', '\x93'}, 2, 0x00D3}, /* (LATIN CAPITAL LETTER O WITH ACUTE) */
    {{'\xc3', '\x94'}, 2, 0x00D4}, /* (LATIN CAPITAL LETTER O WITH CIRCUMFLEX) */
    {{'\xc6', '\xa0'}, 2, 0x01A0}, /* (LATIN CAPITAL LETTER O WITH HORN) */
    {{'\xc3', '\x96'}, 2, 0x00D6}, /* (LATIN CAPITAL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\x97'}, 2, 0x00D7}, /* (MULTIPLICATION SIGN) */
    {{'\xc3', '\x98'}, 2, 0x00D8}, /* (LATIN CAPITAL LETTER O WITH STROKE) */
    {{'\xc3', '\x99'}, 2, 0x00D9}, /* (LATIN CAPITAL LETTER U WITH GRAVE) */
    {{'\xc3', '\x9a'}, 2, 0x00DA}, /* (LATIN CAPITAL LETTER U WITH ACUTE) */
    {{'\xc3', '\x9b'}, 2, 0x00DB}, /* (LATIN CAPITAL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\x9c'}, 2, 0x00DC}, /* (LATIN CAPITAL LETTER U WITH DIAERESIS) */
    {{'\xc6', '\xaf'}, 2, 0x01AF}, /* (LATIN CAPITAL LETTER U WITH HORN) */
    {{'\xcc', '\x83'}, 2, 0x0303}, /* (COMBINING TILDE) */
    {{'\xc3', '\x9f'}, 2, 0x00DF}, /* (LATIN SMALL LETTER SHARP S) */
    {{'\xc3', '\xa0'}, 2, 0x00E0}, /* (LATIN SMALL LETTER A WITH GRAVE) */
    {{'\xc3', '\xa1'}, 2, 0x00E1}, /* (LATIN SMALL LETTER A WITH ACUTE) */
    {{'\xc3', '\xa2'}, 2, 0x00E2}, /* (LATIN SMALL LETTER A WITH CIRCUMFLEX) */
    {{'\xc4', '\x83'}, 2, 0x0103}, /* (LATIN SMALL LETTER A WITH BREVE) */
    {{'\xc3', '\xa4'}, 2, 0x00E4}, /* (LATIN SMALL LETTER A WITH DIAERESIS) */
    {{'\xc3', '\xa5'}, 2, 0x00E5}, /* (LATIN SMALL LETTER A WITH RING ABOVE) */
    {{'\xc3', '\xa6'}, 2, 0x00E6}, /* (LATIN SMALL LETTER AE) */
    {{'\xc3', '\xa7'}, 2, 0x00E7}, /* (LATIN SMALL LETTER C WITH CEDILLA) */
    {{'\xc3', '\xa8'}, 2, 0x00E8}, /* (LATIN SMALL LETTER E WITH GRAVE) */
    {{'\xc3', '\xa9'}, 2, 0x00E9}, /* (LATIN SMALL LETTER E WITH ACUTE) */
    {{'\xc3', '\xaa'}, 2, 0x00EA}, /* (LATIN SMALL LETTER E WITH CIRCUMFLEX) */
    {{'\xc3', '\xab'}, 2, 0x00EB}, /* (LATIN SMALL LETTER E WITH DIAERESIS) */
    {{'\xcc', '\x81'}, 2, 0x0301}, /* (COMBINING ACUTE ACCENT) */
    {{'\xc3', '\xad'}, 2, 0x00ED}, /* (LATIN SMALL LETTER I WITH ACUTE) */
    {{'\xc3', '\xae'}, 2, 0x00EE}, /* (LATIN SMALL LETTER I WITH CIRCUMFLEX) */
    {{'\xc3', '\xaf'}, 2, 0x00EF}, /* (LATIN SMALL LETTER I WITH DIAERESIS) */
    {{'\xc4', '\x91'}, 2, 0x0111}, /* (LATIN SMALL LETTER D WITH STROKE) */
    {{'\xc3', '\xb1'}, 2, 0x00F1}, /* (LATIN SMALL LETTER N WITH TILDE) */
    {{'\xcc', '\xa3'}, 2, 0x0323}, /* (COMBINING DOT BELOW) */
    {{'\xc3', '\xb3'}, 2, 0x00F3}, /* (LATIN SMALL LETTER O WITH ACUTE) */
    {{'\xc3', '\xb4'}, 2, 0x00F4}, /* (LATIN SMALL LETTER O WITH CIRCUMFLEX) */
    {{'\xc6', '\xa1'}, 2, 0x01A1}, /* (LATIN SMALL LETTER O WITH HORN) */
    {{'\xc3', '\xb6'}, 2, 0x00F6}, /* (LATIN SMALL LETTER O WITH DIAERESIS) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xc3', '\xb8'}, 2, 0x00F8}, /* (LATIN SMALL LETTER O WITH STROKE) */
    {{'\xc3', '\xb9'}, 2, 0x00F9}, /* (LATIN SMALL LETTER U WITH GRAVE) */
    {{'\xc3', '\xba'}, 2, 0x00FA}, /* (LATIN SMALL LETTER U WITH ACUTE) */
    {{'\xc3', '\xbb'}, 2, 0x00FB}, /* (LATIN SMALL LETTER U WITH CIRCUMFLEX) */
    {{'\xc3', '\xbc'}, 2, 0x00FC}, /* (LATIN SMALL LETTER U WITH DIAERESIS) */
    {{'\xc6', '\xb0'}, 2, 0x01B0}, /* (LATIN SMALL LETTER U WITH HORN) */
    {{'\xe2', '\x82', '\xab'}, 3, 0x20AB}, /* (DONG SIGN) */
    {{'\xc3', '\xbf'}, 2, 0x00FF}, /* (LATIN SMALL LETTER Y WITH DIAERESIS) */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_windows_874[128] = 
{
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
    {{'\xc2', '\x81'}, 2, 0x0081}, /* (<control>) */
    {{'\xc2', '\x82'}, 2, 0x0082}, /* (<control>) */
    {{'\xc2', '\x83'}, 2, 0x0083}, /* (<control>) */
    {{'\xc2', '\x84'}, 2, 0x0084}, /* (<control>) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xc2', '\x86'}, 2, 0x0086}, /* (<control>) */
    {{'\xc2', '\x87'}, 2, 0x0087}, /* (<control>) */
    {{'\xc2', '\x88'}, 2, 0x0088}, /* (<control>) */
    {{'\xc2', '\x89'}, 2, 0x0089}, /* (<control>) */
    {{'\xc2', '\x8a'}, 2, 0x008A}, /* (<control>) */
    {{'\xc2', '\x8b'}, 2, 0x008B}, /* (<control>) */
    {{'\xc2', '\x8c'}, 2, 0x008C}, /* (<control>) */
    {{'\xc2', '\x8d'}, 2, 0x008D}, /* (<control>) */
    {{'\xc2', '\x8e'}, 2, 0x008E}, /* (<control>) */
    {{'\xc2', '\x8f'}, 2, 0x008F}, /* (<control>) */
    {{'\xc2', '\x90'}, 2, 0x0090}, /* (<control>) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xc2', '\x98'}, 2, 0x0098}, /* (<control>) */
    {{'\xc2', '\x99'}, 2, 0x0099}, /* (<control>) */
    {{'\xc2', '\x9a'}, 2, 0x009A}, /* (<control>) */
    {{'\xc2', '\x9b'}, 2, 0x009B}, /* (<control>) */
    {{'\xc2', '\x9c'}, 2, 0x009C}, /* (<control>) */
    {{'\xc2', '\x9d'}, 2, 0x009D}, /* (<control>) */
    {{'\xc2', '\x9e'}, 2, 0x009E}, /* (<control>) */
    {{'\xc2', '\x9f'}, 2, 0x009F}, /* (<control>) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xe0', '\xb8', '\x81'}, 3, 0x0E01}, /* (THAI CHARACTER KO KAI) */
    {{'\xe0', '\xb8', '\x82'}, 3, 0x0E02}, /* (THAI CHARACTER KHO KHAI) */
    {{'\xe0', '\xb8', '\x83'}, 3, 0x0E03}, /* (THAI CHARACTER KHO KHUAT) */
    {{'\xe0', '\xb8', '\x84'}, 3, 0x0E04}, /* (THAI CHARACTER KHO KHWAI) */
    {{'\xe0', '\xb8', '\x85'}, 3, 0x0E05}, /* (THAI CHARACTER KHO KHON) */
    {{'\xe0', '\xb8', '\x86'}, 3, 0x0E06}, /* (THAI CHARACTER KHO RAKHANG) */
    {{'\xe0', '\xb8', '\x87'}, 3, 0x0E07}, /* (THAI CHARACTER NGO NGU) */
    {{'\xe0', '\xb8', '\x88'}, 3, 0x0E08}, /* (THAI CHARACTER CHO CHAN) */
    {{'\xe0', '\xb8', '\x89'}, 3, 0x0E09}, /* (THAI CHARACTER CHO CHING) */
    {{'\xe0', '\xb8', '\x8a'}, 3, 0x0E0A}, /* (THAI CHARACTER CHO CHANG) */
    {{'\xe0', '\xb8', '\x8b'}, 3, 0x0E0B}, /* (THAI CHARACTER SO SO) */
    {{'\xe0', '\xb8', '\x8c'}, 3, 0x0E0C}, /* (THAI CHARACTER CHO CHOE) */
    {{'\xe0', '\xb8', '\x8d'}, 3, 0x0E0D}, /* (THAI CHARACTER YO YING) */
    {{'\xe0', '\xb8', '\x8e'}, 3, 0x0E0E}, /* (THAI CHARACTER DO CHADA) */
    {{'\xe0', '\xb8', '\x8f'}, 3, 0x0E0F}, /* (THAI CHARACTER TO PATAK) */
    {{'\xe0', '\xb8', '\x90'}, 3, 0x0E10}, /* (THAI CHARACTER THO THAN) */
    {{'\xe0', '\xb8', '\x91'}, 3, 0x0E11}, /* (THAI CHARACTER THO NANGMONTHO) */
    {{'\xe0', '\xb8', '\x92'}, 3, 0x0E12}, /* (THAI CHARACTER THO PHUTHAO) */
    {{'\xe0', '\xb8', '\x93'}, 3, 0x0E13}, /* (THAI CHARACTER NO NEN) */
    {{'\xe0', '\xb8', '\x94'}, 3, 0x0E14}, /* (THAI CHARACTER DO DEK) */
    {{'\xe0', '\xb8', '\x95'}, 3, 0x0E15}, /* (THAI CHARACTER TO TAO) */
    {{'\xe0', '\xb8', '\x96'}, 3, 0x0E16}, /* (THAI CHARACTER THO THUNG) */
    {{'\xe0', '\xb8', '\x97'}, 3, 0x0E17}, /* (THAI CHARACTER THO THAHAN) */
    {{'\xe0', '\xb8', '\x98'}, 3, 0x0E18}, /* (THAI CHARACTER THO THONG) */
    {{'\xe0', '\xb8', '\x99'}, 3, 0x0E19}, /* (THAI CHARACTER NO NU) */
    {{'\xe0', '\xb8', '\x9a'}, 3, 0x0E1A}, /* (THAI CHARACTER BO BAIMAI) */
    {{'\xe0', '\xb8', '\x9b'}, 3, 0x0E1B}, /* (THAI CHARACTER PO PLA) */
    {{'\xe0', '\xb8', '\x9c'}, 3, 0x0E1C}, /* (THAI CHARACTER PHO PHUNG) */
    {{'\xe0', '\xb8', '\x9d'}, 3, 0x0E1D}, /* (THAI CHARACTER FO FA) */
    {{'\xe0', '\xb8', '\x9e'}, 3, 0x0E1E}, /* (THAI CHARACTER PHO PHAN) */
    {{'\xe0', '\xb8', '\x9f'}, 3, 0x0E1F}, /* (THAI CHARACTER FO FAN) */
    {{'\xe0', '\xb8', '\xa0'}, 3, 0x0E20}, /* (THAI CHARACTER PHO SAMPHAO) */
    {{'\xe0', '\xb8', '\xa1'}, 3, 0x0E21}, /* (THAI CHARACTER MO MA) */
    {{'\xe0', '\xb8', '\xa2'}, 3, 0x0E22}, /* (THAI CHARACTER YO YAK) */
    {{'\xe0', '\xb8', '\xa3'}, 3, 0x0E23}, /* (THAI CHARACTER RO RUA) */
    {{'\xe0', '\xb8', '\xa4'}, 3, 0x0E24}, /* (THAI CHARACTER RU) */
    {{'\xe0', '\xb8', '\xa5'}, 3, 0x0E25}, /* (THAI CHARACTER LO LING) */
    {{'\xe0', '\xb8', '\xa6'}, 3, 0x0E26}, /* (THAI CHARACTER LU) */
    {{'\xe0', '\xb8', '\xa7'}, 3, 0x0E27}, /* (THAI CHARACTER WO WAEN) */
    {{'\xe0', '\xb8', '\xa8'}, 3, 0x0E28}, /* (THAI CHARACTER SO SALA) */
    {{'\xe0', '\xb8', '\xa9'}, 3, 0x0E29}, /* (THAI CHARACTER SO RUSI) */
    {{'\xe0', '\xb8', '\xaa'}, 3, 0x0E2A}, /* (THAI CHARACTER SO SUA) */
    {{'\xe0', '\xb8', '\xab'}, 3, 0x0E2B}, /* (THAI CHARACTER HO HIP) */
    {{'\xe0', '\xb8', '\xac'}, 3, 0x0E2C}, /* (THAI CHARACTER LO CHULA) */
    {{'\xe0', '\xb8', '\xad'}, 3, 0x0E2D}, /* (THAI CHARACTER O ANG) */
    {{'\xe0', '\xb8', '\xae'}, 3, 0x0E2E}, /* (THAI CHARACTER HO NOKHUK) */
    {{'\xe0', '\xb8', '\xaf'}, 3, 0x0E2F}, /* (THAI CHARACTER PAIYANNOI) */
    {{'\xe0', '\xb8', '\xb0'}, 3, 0x0E30}, /* (THAI CHARACTER SARA A) */
    {{'\xe0', '\xb8', '\xb1'}, 3, 0x0E31}, /* (THAI CHARACTER MAI HAN-AKAT) */
    {{'\xe0', '\xb8', '\xb2'}, 3, 0x0E32}, /* (THAI CHARACTER SARA AA) */
    {{'\xe0', '\xb8', '\xb3'}, 3, 0x0E33}, /* (THAI CHARACTER SARA AM) */
    {{'\xe0', '\xb8', '\xb4'}, 3, 0x0E34}, /* (THAI CHARACTER SARA I) */
    {{'\xe0', '\xb8', '\xb5'}, 3, 0x0E35}, /* (THAI CHARACTER SARA II) */
    {{'\xe0', '\xb8', '\xb6'}, 3, 0x0E36}, /* (THAI CHARACTER SARA UE) */
    {{'\xe0', '\xb8', '\xb7'}, 3, 0x0E37}, /* (THAI CHARACTER SARA UEE) */
    {{'\xe0', '\xb8', '\xb8'}, 3, 0x0E38}, /* (THAI CHARACTER SARA U) */
    {{'\xe0', '\xb8', '\xb9'}, 3, 0x0E39}, /* (THAI CHARACTER SARA UU) */
    {{'\xe0', '\xb8', '\xba'}, 3, 0x0E3A}, /* (THAI CHARACTER PHINTHU) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{'\xe0', '\xb8', '\xbf'}, 3, 0x0E3F}, /* (THAI CURRENCY SYMBOL BAHT) */
    {{'\xe0', '\xb9', '\x80'}, 3, 0x0E40}, /* (THAI CHARACTER SARA E) */
    {{'\xe0', '\xb9', '\x81'}, 3, 0x0E41}, /* (THAI CHARACTER SARA AE) */
    {{'\xe0', '\xb9', '\x82'}, 3, 0x0E42}, /* (THAI CHARACTER SARA O) */
    {{'\xe0', '\xb9', '\x83'}, 3, 0x0E43}, /* (THAI CHARACTER SARA AI MAIMUAN) */
    {{'\xe0', '\xb9', '\x84'}, 3, 0x0E44}, /* (THAI CHARACTER SARA AI MAIMALAI) */
    {{'\xe0', '\xb9', '\x85'}, 3, 0x0E45}, /* (THAI CHARACTER LAKKHANGYAO) */
    {{'\xe0', '\xb9', '\x86'}, 3, 0x0E46}, /* (THAI CHARACTER MAIYAMOK) */
    {{'\xe0', '\xb9', '\x87'}, 3, 0x0E47}, /* (THAI CHARACTER MAITAIKHU) */
    {{'\xe0', '\xb9', '\x88'}, 3, 0x0E48}, /* (THAI CHARACTER MAI EK) */
    {{'\xe0', '\xb9', '\x89'}, 3, 0x0E49}, /* (THAI CHARACTER MAI THO) */
    {{'\xe0', '\xb9', '\x8a'}, 3, 0x0E4A}, /* (THAI CHARACTER MAI TRI) */
    {{'\xe0', '\xb9', '\x8b'}, 3, 0x0E4B}, /* (THAI CHARACTER MAI CHATTAWA) */
    {{'\xe0', '\xb9', '\x8c'}, 3, 0x0E4C}, /* (THAI CHARACTER THANTHAKHAT) */
    {{'\xe0', '\xb9', '\x8d'}, 3, 0x0E4D}, /* (THAI CHARACTER NIKHAHIT) */
    {{'\xe0', '\xb9', '\x8e'}, 3, 0x0E4E}, /* (THAI CHARACTER YAMAKKAN) */
    {{'\xe0', '\xb9', '\x8f'}, 3, 0x0E4F}, /* (THAI CHARACTER FONGMAN) */
    {{'\xe0', '\xb9', '\x90'}, 3, 0x0E50}, /* (THAI DIGIT ZERO) */
    {{'\xe0', '\xb9', '\x91'}, 3, 0x0E51}, /* (THAI DIGIT ONE) */
    {{'\xe0', '\xb9', '\x92'}, 3, 0x0E52}, /* (THAI DIGIT TWO) */
    {{'\xe0', '\xb9', '\x93'}, 3, 0x0E53}, /* (THAI DIGIT THREE) */
    {{'\xe0', '\xb9', '\x94'}, 3, 0x0E54}, /* (THAI DIGIT FOUR) */
    {{'\xe0', '\xb9', '\x95'}, 3, 0x0E55}, /* (THAI DIGIT FIVE) */
    {{'\xe0', '\xb9', '\x96'}, 3, 0x0E56}, /* (THAI DIGIT SIX) */
    {{'\xe0', '\xb9', '\x97'}, 3, 0x0E57}, /* (THAI DIGIT SEVEN) */
    {{'\xe0', '\xb9', '\x98'}, 3, 0x0E58}, /* (THAI DIGIT EIGHT) */
    {{'\xe0', '\xb9', '\x99'}, 3, 0x0E59}, /* (THAI DIGIT NINE) */
    {{'\xe0', '\xb9', '\x9a'}, 3, 0x0E5A}, /* (THAI CHARACTER ANGKHANKHU) */
    {{'\xe0', '\xb9', '\x9b'}, 3, 0x0E5B}, /* (THAI CHARACTER KHOMUT) */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
    {{0}, 0, LXB_ENCODING_DECODE_ERROR}, /* Not defined */
};

LXB_API const lxb_encoding_single_index_t lxb_encoding_single_index_x_mac_cyrillic[128] = 
{
    {{'\xd0', '\x90'}, 2, 0x0410}, /* (CYRILLIC CAPITAL LETTER A) */
    {{'\xd0', '\x91'}, 2, 0x0411}, /* (CYRILLIC CAPITAL LETTER BE) */
    {{'\xd0', '\x92'}, 2, 0x0412}, /* (CYRILLIC CAPITAL LETTER VE) */
    {{'\xd0', '\x93'}, 2, 0x0413}, /* (CYRILLIC CAPITAL LETTER GHE) */
    {{'\xd0', '\x94'}, 2, 0x0414}, /* (CYRILLIC CAPITAL LETTER DE) */
    {{'\xd0', '\x95'}, 2, 0x0415}, /* (CYRILLIC CAPITAL LETTER IE) */
    {{'\xd0', '\x96'}, 2, 0x0416}, /* (CYRILLIC CAPITAL LETTER ZHE) */
    {{'\xd0', '\x97'}, 2, 0x0417}, /* (CYRILLIC CAPITAL LETTER ZE) */
    {{'\xd0', '\x98'}, 2, 0x0418}, /* (CYRILLIC CAPITAL LETTER I) */
    {{'\xd0', '\x99'}, 2, 0x0419}, /* (CYRILLIC CAPITAL LETTER SHORT I) */
    {{'\xd0', '\x9a'}, 2, 0x041A}, /* (CYRILLIC CAPITAL LETTER KA) */
    {{'\xd0', '\x9b'}, 2, 0x041B}, /* (CYRILLIC CAPITAL LETTER EL) */
    {{'\xd0', '\x9c'}, 2, 0x041C}, /* (CYRILLIC CAPITAL LETTER EM) */
    {{'\xd0', '\x9d'}, 2, 0x041D}, /* (CYRILLIC CAPITAL LETTER EN) */
    {{'\xd0', '\x9e'}, 2, 0x041E}, /* (CYRILLIC CAPITAL LETTER O) */
    {{'\xd0', '\x9f'}, 2, 0x041F}, /* (CYRILLIC CAPITAL LETTER PE) */
    {{'\xd0', '\xa0'}, 2, 0x0420}, /* (CYRILLIC CAPITAL LETTER ER) */
    {{'\xd0', '\xa1'}, 2, 0x0421}, /* (CYRILLIC CAPITAL LETTER ES) */
    {{'\xd0', '\xa2'}, 2, 0x0422}, /* (CYRILLIC CAPITAL LETTER TE) */
    {{'\xd0', '\xa3'}, 2, 0x0423}, /* (CYRILLIC CAPITAL LETTER U) */
    {{'\xd0', '\xa4'}, 2, 0x0424}, /* (CYRILLIC CAPITAL LETTER EF) */
    {{'\xd0', '\xa5'}, 2, 0x0425}, /* (CYRILLIC CAPITAL LETTER HA) */
    {{'\xd0', '\xa6'}, 2, 0x0426}, /* (CYRILLIC CAPITAL LETTER TSE) */
    {{'\xd0', '\xa7'}, 2, 0x0427}, /* (CYRILLIC CAPITAL LETTER CHE) */
    {{'\xd0', '\xa8'}, 2, 0x0428}, /* (CYRILLIC CAPITAL LETTER SHA) */
    {{'\xd0', '\xa9'}, 2, 0x0429}, /* (CYRILLIC CAPITAL LETTER SHCHA) */
    {{'\xd0', '\xaa'}, 2, 0x042A}, /* (CYRILLIC CAPITAL LETTER HARD SIGN) */
    {{'\xd0', '\xab'}, 2, 0x042B}, /* (CYRILLIC CAPITAL LETTER YERU) */
    {{'\xd0', '\xac'}, 2, 0x042C}, /* (CYRILLIC CAPITAL LETTER SOFT SIGN) */
    {{'\xd0', '\xad'}, 2, 0x042D}, /* (CYRILLIC CAPITAL LETTER E) */
    {{'\xd0', '\xae'}, 2, 0x042E}, /* (CYRILLIC CAPITAL LETTER YU) */
    {{'\xd0', '\xaf'}, 2, 0x042F}, /* (CYRILLIC CAPITAL LETTER YA) */
    {{'\xe2', '\x80', '\xa0'}, 3, 0x2020}, /* (DAGGER) */
    {{'\xc2', '\xb0'}, 2, 0x00B0}, /* (DEGREE SIGN) */
    {{'\xd2', '\x90'}, 2, 0x0490}, /* (CYRILLIC CAPITAL LETTER GHE WITH UPTURN) */
    {{'\xc2', '\xa3'}, 2, 0x00A3}, /* (POUND SIGN) */
    {{'\xc2', '\xa7'}, 2, 0x00A7}, /* (SECTION SIGN) */
    {{'\xe2', '\x80', '\xa2'}, 3, 0x2022}, /* (BULLET) */
    {{'\xc2', '\xb6'}, 2, 0x00B6}, /* (PILCROW SIGN) */
    {{'\xd0', '\x86'}, 2, 0x0406}, /* (CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xc2', '\xae'}, 2, 0x00AE}, /* (REGISTERED SIGN) */
    {{'\xc2', '\xa9'}, 2, 0x00A9}, /* (COPYRIGHT SIGN) */
    {{'\xe2', '\x84', '\xa2'}, 3, 0x2122}, /* (TRADE MARK SIGN) */
    {{'\xd0', '\x82'}, 2, 0x0402}, /* (CYRILLIC CAPITAL LETTER DJE) */
    {{'\xd1', '\x92'}, 2, 0x0452}, /* (CYRILLIC SMALL LETTER DJE) */
    {{'\xe2', '\x89', '\xa0'}, 3, 0x2260}, /* (NOT EQUAL TO) */
    {{'\xd0', '\x83'}, 2, 0x0403}, /* (CYRILLIC CAPITAL LETTER GJE) */
    {{'\xd1', '\x93'}, 2, 0x0453}, /* (CYRILLIC SMALL LETTER GJE) */
    {{'\xe2', '\x88', '\x9e'}, 3, 0x221E}, /* (INFINITY) */
    {{'\xc2', '\xb1'}, 2, 0x00B1}, /* (PLUS-MINUS SIGN) */
    {{'\xe2', '\x89', '\xa4'}, 3, 0x2264}, /* (LESS-THAN OR EQUAL TO) */
    {{'\xe2', '\x89', '\xa5'}, 3, 0x2265}, /* (GREATER-THAN OR EQUAL TO) */
    {{'\xd1', '\x96'}, 2, 0x0456}, /* (CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I) */
    {{'\xc2', '\xb5'}, 2, 0x00B5}, /* (MICRO SIGN) */
    {{'\xd2', '\x91'}, 2, 0x0491}, /* (CYRILLIC SMALL LETTER GHE WITH UPTURN) */
    {{'\xd0', '\x88'}, 2, 0x0408}, /* (CYRILLIC CAPITAL LETTER JE) */
    {{'\xd0', '\x84'}, 2, 0x0404}, /* (CYRILLIC CAPITAL LETTER UKRAINIAN IE) */
    {{'\xd1', '\x94'}, 2, 0x0454}, /* (CYRILLIC SMALL LETTER UKRAINIAN IE) */
    {{'\xd0', '\x87'}, 2, 0x0407}, /* (CYRILLIC CAPITAL LETTER YI) */
    {{'\xd1', '\x97'}, 2, 0x0457}, /* (CYRILLIC SMALL LETTER YI) */
    {{'\xd0', '\x89'}, 2, 0x0409}, /* (CYRILLIC CAPITAL LETTER LJE) */
    {{'\xd1', '\x99'}, 2, 0x0459}, /* (CYRILLIC SMALL LETTER LJE) */
    {{'\xd0', '\x8a'}, 2, 0x040A}, /* (CYRILLIC CAPITAL LETTER NJE) */
    {{'\xd1', '\x9a'}, 2, 0x045A}, /* (CYRILLIC SMALL LETTER NJE) */
    {{'\xd1', '\x98'}, 2, 0x0458}, /* (CYRILLIC SMALL LETTER JE) */
    {{'\xd0', '\x85'}, 2, 0x0405}, /* (CYRILLIC CAPITAL LETTER DZE) */
    {{'\xc2', '\xac'}, 2, 0x00AC}, /* (NOT SIGN) */
    {{'\xe2', '\x88', '\x9a'}, 3, 0x221A}, /* (SQUARE ROOT) */
    {{'\xc6', '\x92'}, 2, 0x0192}, /* (LATIN SMALL LETTER F WITH HOOK) */
    {{'\xe2', '\x89', '\x88'}, 3, 0x2248}, /* (ALMOST EQUAL TO) */
    {{'\xe2', '\x88', '\x86'}, 3, 0x2206}, /* (INCREMENT) */
    {{'\xc2', '\xab'}, 2, 0x00AB}, /* (LEFT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xc2', '\xbb'}, 2, 0x00BB}, /* (RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\xa6'}, 3, 0x2026}, /* (HORIZONTAL ELLIPSIS) */
    {{'\xc2', '\xa0'}, 2, 0x00A0}, /* (NO-BREAK SPACE) */
    {{'\xd0', '\x8b'}, 2, 0x040B}, /* (CYRILLIC CAPITAL LETTER TSHE) */
    {{'\xd1', '\x9b'}, 2, 0x045B}, /* (CYRILLIC SMALL LETTER TSHE) */
    {{'\xd0', '\x8c'}, 2, 0x040C}, /* (CYRILLIC CAPITAL LETTER KJE) */
    {{'\xd1', '\x9c'}, 2, 0x045C}, /* (CYRILLIC SMALL LETTER KJE) */
    {{'\xd1', '\x95'}, 2, 0x0455}, /* (CYRILLIC SMALL LETTER DZE) */
    {{'\xe2', '\x80', '\x93'}, 3, 0x2013}, /* (EN DASH) */
    {{'\xe2', '\x80', '\x94'}, 3, 0x2014}, /* (EM DASH) */
    {{'\xe2', '\x80', '\x9c'}, 3, 0x201C}, /* (LEFT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x9d'}, 3, 0x201D}, /* (RIGHT DOUBLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x98'}, 3, 0x2018}, /* (LEFT SINGLE QUOTATION MARK) */
    {{'\xe2', '\x80', '\x99'}, 3, 0x2019}, /* (RIGHT SINGLE QUOTATION MARK) */
    {{'\xc3', '\xb7'}, 2, 0x00F7}, /* (DIVISION SIGN) */
    {{'\xe2', '\x80', '\x9e'}, 3, 0x201E}, /* (DOUBLE LOW-9 QUOTATION MARK) */
    {{'\xd0', '\x8e'}, 2, 0x040E}, /* (CYRILLIC CAPITAL LETTER SHORT U) */
    {{'\xd1', '\x9e'}, 2, 0x045E}, /* (CYRILLIC SMALL LETTER SHORT U) */
    {{'\xd0', '\x8f'}, 2, 0x040F}, /* (CYRILLIC CAPITAL LETTER DZHE) */
    {{'\xd1', '\x9f'}, 2, 0x045F}, /* (CYRILLIC SMALL LETTER DZHE) */
    {{'\xe2', '\x84', '\x96'}, 3, 0x2116}, /* (NUMERO SIGN) */
    {{'\xd0', '\x81'}, 2, 0x0401}, /* (CYRILLIC CAPITAL LETTER IO) */
    {{'\xd1', '\x91'}, 2, 0x0451}, /* (CYRILLIC SMALL LETTER IO) */
    {{'\xd1', '\x8f'}, 2, 0x044F}, /* (CYRILLIC SMALL LETTER YA) */
    {{'\xd0', '\xb0'}, 2, 0x0430}, /* (CYRILLIC SMALL LETTER A) */
    {{'\xd0', '\xb1'}, 2, 0x0431}, /* (CYRILLIC SMALL LETTER BE) */
    {{'\xd0', '\xb2'}, 2, 0x0432}, /* (CYRILLIC SMALL LETTER VE) */
    {{'\xd0', '\xb3'}, 2, 0x0433}, /* (CYRILLIC SMALL LETTER GHE) */
    {{'\xd0', '\xb4'}, 2, 0x0434}, /* (CYRILLIC SMALL LETTER DE) */
    {{'\xd0', '\xb5'}, 2, 0x0435}, /* (CYRILLIC SMALL LETTER IE) */
    {{'\xd0', '\xb6'}, 2, 0x0436}, /* (CYRILLIC SMALL LETTER ZHE) */
    {{'\xd0', '\xb7'}, 2, 0x0437}, /* (CYRILLIC SMALL LETTER ZE) */
    {{'\xd0', '\xb8'}, 2, 0x0438}, /* (CYRILLIC SMALL LETTER I) */
    {{'\xd0', '\xb9'}, 2, 0x0439}, /* (CYRILLIC SMALL LETTER SHORT I) */
    {{'\xd0', '\xba'}, 2, 0x043A}, /* (CYRILLIC SMALL LETTER KA) */
    {{'\xd0', '\xbb'}, 2, 0x043B}, /* (CYRILLIC SMALL LETTER EL) */
    {{'\xd0', '\xbc'}, 2, 0x043C}, /* (CYRILLIC SMALL LETTER EM) */
    {{'\xd0', '\xbd'}, 2, 0x043D}, /* (CYRILLIC SMALL LETTER EN) */
    {{'\xd0', '\xbe'}, 2, 0x043E}, /* (CYRILLIC SMALL LETTER O) */
    {{'\xd0', '\xbf'}, 2, 0x043F}, /* (CYRILLIC SMALL LETTER PE) */
    {{'\xd1', '\x80'}, 2, 0x0440}, /* (CYRILLIC SMALL LETTER ER) */
    {{'\xd1', '\x81'}, 2, 0x0441}, /* (CYRILLIC SMALL LETTER ES) */
    {{'\xd1', '\x82'}, 2, 0x0442}, /* (CYRILLIC SMALL LETTER TE) */
    {{'\xd1', '\x83'}, 2, 0x0443}, /* (CYRILLIC SMALL LETTER U) */
    {{'\xd1', '\x84'}, 2, 0x0444}, /* (CYRILLIC SMALL LETTER EF) */
    {{'\xd1', '\x85'}, 2, 0x0445}, /* (CYRILLIC SMALL LETTER HA) */
    {{'\xd1', '\x86'}, 2, 0x0446}, /* (CYRILLIC SMALL LETTER TSE) */
    {{'\xd1', '\x87'}, 2, 0x0447}, /* (CYRILLIC SMALL LETTER CHE) */
    {{'\xd1', '\x88'}, 2, 0x0448}, /* (CYRILLIC SMALL LETTER SHA) */
    {{'\xd1', '\x89'}, 2, 0x0449}, /* (CYRILLIC SMALL LETTER SHCHA) */
    {{'\xd1', '\x8a'}, 2, 0x044A}, /* (CYRILLIC SMALL LETTER HARD SIGN) */
    {{'\xd1', '\x8b'}, 2, 0x044B}, /* (CYRILLIC SMALL LETTER YERU) */
    {{'\xd1', '\x8c'}, 2, 0x044C}, /* (CYRILLIC SMALL LETTER SOFT SIGN) */
    {{'\xd1', '\x8d'}, 2, 0x044D}, /* (CYRILLIC SMALL LETTER E) */
    {{'\xd1', '\x8e'}, 2, 0x044E}, /* (CYRILLIC SMALL LETTER YU) */
    {{'\xe2', '\x82', '\xac'}, 3, 0x20AC}, /* (EURO SIGN) */
};

/* Table size: 344; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_ibm866[345] = 
{
    {0, 0, 0},{9632, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1038, 246, 0},
    {0, 0, 0},
    {1040, 128, 0},
    {1041, 129, 0},
    {1042, 130, 0},
    {1043, 131, 0},
    {1044, 132, 0},
    {1045, 133, 0},
    {1046, 134, 0},
    {1047, 135, 0},
    {1048, 136, 0},
    {1049, 137, 0},
    {1050, 138, 0},
    {1051, 139, 0},
    {1052, 140, 0},
    {1053, 141, 0},
    {1054, 142, 0},
    {1055, 143, 0},
    {1056, 144, 0},
    {1057, 145, 0},
    {1058, 146, 0},
    {1059, 147, 0},
    {1060, 148, 0},
    {1061, 149, 0},
    {1062, 150, 0},
    {1063, 151, 0},
    {1064, 152, 0},
    {1065, 153, 0},
    {1066, 154, 0},
    {1067, 155, 0},
    {1068, 156, 0},
    {1069, 157, 0},
    {1070, 158, 0},
    {1071, 159, 0},
    {1072, 160, 0},
    {1073, 161, 0},
    {1074, 162, 0},
    {1075, 163, 0},
    {1076, 164, 0},
    {1077, 165, 0},
    {1078, 166, 0},
    {1079, 167, 0},
    {1080, 168, 0},
    {1081, 169, 0},
    {1082, 170, 0},
    {1083, 171, 0},
    {1084, 172, 0},
    {1085, 173, 0},
    {1086, 174, 0},
    {1087, 175, 0},
    {1088, 224, 0},
    {1089, 225, 0},
    {1090, 226, 0},
    {1091, 227, 0},
    {1092, 228, 0},
    {1093, 229, 0},
    {1094, 230, 0},
    {1095, 231, 0},
    {1096, 232, 0},
    {1097, 233, 0},
    {1098, 234, 0},
    {1099, 235, 0},
    {1100, 236, 0},
    {1101, 237, 0},
    {1102, 238, 0},
    {1103, 239, 0},
    {0, 0, 0},
    {1105, 241, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1108, 243, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1111, 245, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1118, 247, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8729, 249, 0},
    {8730, 251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {160, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {164, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 248, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {183, 250, 0},
    {9472, 196, 0},
    {0, 0, 0},
    {9474, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9484, 218, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9488, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9492, 192, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9496, 217, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9500, 195, 0},
    {0, 0, 0},
    {8470, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9508, 180, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9516, 194, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9524, 193, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9532, 197, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9552, 205, 0},
    {9553, 186, 0},
    {9554, 213, 0},
    {9555, 214, 0},
    {9556, 201, 0},
    {9557, 184, 0},
    {9558, 183, 0},
    {9559, 187, 0},
    {9560, 212, 0},
    {9561, 211, 0},
    {9562, 200, 0},
    {9563, 190, 0},
    {9564, 189, 0},
    {9565, 188, 0},
    {9566, 198, 0},
    {9567, 199, 0},
    {9568, 204, 0},
    {9569, 181, 0},
    {9570, 182, 0},
    {9571, 185, 0},
    {9572, 209, 0},
    {9573, 210, 0},
    {9574, 203, 0},
    {9575, 207, 0},
    {9576, 208, 0},
    {9577, 202, 0},
    {9578, 216, 0},
    {9579, 215, 0},
    {9580, 206, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9600, 223, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9604, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9608, 219, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9612, 221, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9616, 222, 0},
    {9617, 176, 0},
    {9618, 177, 0},
    {9619, 178, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1025, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1028, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1031, 244, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_10[344] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {352, 170, 0},
    {353, 186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {358, 171, 0},
    {359, 187, 0},
    {360, 215, 0},
    {361, 247, 0},
    {362, 174, 0},
    {363, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {370, 217, 0},
    {371, 249, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {381, 172, 0},
    {382, 188, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 167, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {173, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 176, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {183, 183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {193, 193, 0},
    {194, 194, 0},
    {195, 195, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 198, 0},
    {0, 0, 0},
    {0, 0, 0},
    {201, 201, 0},
    {0, 0, 0},
    {203, 203, 0},
    {0, 0, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {208, 208, 0},
    {0, 0, 0},
    {0, 0, 0},
    {211, 211, 0},
    {212, 212, 0},
    {213, 213, 0},
    {214, 214, 0},
    {0, 0, 0},
    {216, 216, 0},
    {0, 0, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {221, 221, 0},
    {222, 222, 0},
    {223, 223, 0},
    {0, 0, 0},
    {225, 225, 0},
    {226, 226, 0},
    {227, 227, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 230, 0},
    {0, 0, 0},
    {0, 0, 0},
    {233, 233, 0},
    {0, 0, 0},
    {235, 235, 0},
    {0, 0, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {240, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {243, 243, 0},
    {244, 244, 0},
    {245, 245, 0},
    {246, 246, 0},
    {0, 0, 0},
    {248, 248, 0},
    {0, 0, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {253, 253, 0},
    {254, 254, 0},
    {0, 0, 0},
    {256, 192, 0},
    {257, 224, 0},
    {0, 0, 0},
    {0, 0, 0},
    {260, 161, 0},
    {261, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {268, 200, 0},
    {269, 232, 0},
    {0, 0, 0},
    {0, 0, 0},
    {272, 169, 0},
    {273, 185, 0},
    {274, 162, 0},
    {275, 178, 0},
    {0, 0, 0},
    {0, 0, 0},
    {278, 204, 0},
    {279, 236, 0},
    {280, 202, 0},
    {281, 234, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {290, 163, 0},
    {291, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {296, 165, 0},
    {297, 181, 0},
    {298, 164, 0},
    {299, 180, 0},
    {0, 0, 0},
    {0, 0, 0},
    {302, 199, 0},
    {303, 231, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {310, 166, 0},
    {311, 182, 0},
    {312, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {315, 168, 0},
    {316, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8213, 189, 0},
    {325, 209, 0},
    {326, 241, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {330, 175, 0},
    {331, 191, 0},
    {332, 210, 0},
    {333, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 345; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_13[346] = 
{
    {0, 0, 0},{0, 0, 0},
    {346, 218, 0},
    {347, 250, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {352, 208, 0},
    {353, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {362, 219, 0},
    {363, 251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {370, 216, 0},
    {371, 248, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {377, 202, 0},
    {378, 234, 0},
    {379, 221, 0},
    {380, 253, 0},
    {381, 222, 0},
    {382, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {162, 162, 0},
    {163, 163, 0},
    {164, 164, 0},
    {0, 0, 0},
    {166, 166, 0},
    {167, 167, 0},
    {0, 0, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {0, 0, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {0, 0, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {0, 0, 0},
    {185, 185, 0},
    {0, 0, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 175, 0},
    {0, 0, 0},
    {0, 0, 0},
    {201, 201, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {211, 211, 0},
    {0, 0, 0},
    {213, 213, 0},
    {214, 214, 0},
    {215, 215, 0},
    {216, 168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {220, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {223, 223, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {233, 233, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {243, 243, 0},
    {0, 0, 0},
    {245, 245, 0},
    {246, 246, 0},
    {247, 247, 0},
    {248, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {256, 194, 0},
    {257, 226, 0},
    {0, 0, 0},
    {0, 0, 0},
    {260, 192, 0},
    {261, 224, 0},
    {262, 195, 0},
    {263, 227, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {268, 200, 0},
    {269, 232, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {274, 199, 0},
    {275, 231, 0},
    {0, 0, 0},
    {0, 0, 0},
    {278, 203, 0},
    {279, 235, 0},
    {280, 198, 0},
    {281, 230, 0},
    {8217, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8220, 180, 0},
    {8221, 161, 0},
    {8222, 165, 0},
    {0, 0, 0},
    {0, 0, 0},
    {290, 204, 0},
    {291, 236, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {298, 206, 0},
    {299, 238, 0},
    {0, 0, 0},
    {0, 0, 0},
    {302, 193, 0},
    {303, 225, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {310, 205, 0},
    {311, 237, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {315, 207, 0},
    {316, 239, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {321, 217, 0},
    {322, 249, 0},
    {323, 209, 0},
    {324, 241, 0},
    {325, 210, 0},
    {326, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {332, 212, 0},
    {333, 244, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {342, 170, 0},
    {343, 186, 0},
    {0, 0, 0}
};

/* Table size: 407; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_14[408] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7744, 180, 0},
    {7745, 181, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7766, 183, 0},
    {7767, 185, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7776, 187, 0},
    {7777, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7786, 215, 0},
    {7787, 247, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7808, 168, 0},
    {7809, 184, 0},
    {7810, 170, 0},
    {7811, 186, 0},
    {7812, 189, 0},
    {7813, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {163, 163, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 167, 0},
    {0, 0, 0},
    {169, 169, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {173, 173, 0},
    {174, 174, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {182, 182, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7922, 172, 0},
    {7923, 188, 0},
    {0, 0, 0},
    {192, 192, 0},
    {193, 193, 0},
    {194, 194, 0},
    {195, 195, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 198, 0},
    {199, 199, 0},
    {200, 200, 0},
    {201, 201, 0},
    {202, 202, 0},
    {203, 203, 0},
    {204, 204, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {0, 0, 0},
    {209, 209, 0},
    {210, 210, 0},
    {211, 211, 0},
    {212, 212, 0},
    {213, 213, 0},
    {214, 214, 0},
    {0, 0, 0},
    {216, 216, 0},
    {217, 217, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {221, 221, 0},
    {0, 0, 0},
    {223, 223, 0},
    {224, 224, 0},
    {225, 225, 0},
    {226, 226, 0},
    {227, 227, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 230, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {236, 236, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {0, 0, 0},
    {241, 241, 0},
    {242, 242, 0},
    {243, 243, 0},
    {244, 244, 0},
    {245, 245, 0},
    {246, 246, 0},
    {0, 0, 0},
    {248, 248, 0},
    {249, 249, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {253, 253, 0},
    {0, 0, 0},
    {255, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {266, 164, 0},
    {267, 165, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {288, 178, 0},
    {289, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7682, 161, 0},
    {7683, 162, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7690, 166, 0},
    {7691, 171, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {372, 208, 0},
    {373, 240, 0},
    {374, 222, 0},
    {375, 254, 0},
    {376, 175, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {7710, 176, 0},
    {7711, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 344; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_15[345] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {352, 166, 0},
    {353, 168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {376, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {381, 180, 0},
    {382, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 164, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {161, 161, 0},
    {162, 162, 0},
    {163, 163, 0},
    {0, 0, 0},
    {165, 165, 0},
    {0, 0, 0},
    {167, 167, 0},
    {0, 0, 0},
    {169, 169, 0},
    {170, 170, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 175, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {0, 0, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {0, 0, 0},
    {185, 185, 0},
    {186, 186, 0},
    {187, 187, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {191, 191, 0},
    {192, 192, 0},
    {193, 193, 0},
    {194, 194, 0},
    {195, 195, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 198, 0},
    {199, 199, 0},
    {200, 200, 0},
    {201, 201, 0},
    {202, 202, 0},
    {203, 203, 0},
    {204, 204, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {208, 208, 0},
    {209, 209, 0},
    {210, 210, 0},
    {211, 211, 0},
    {212, 212, 0},
    {213, 213, 0},
    {214, 214, 0},
    {215, 215, 0},
    {216, 216, 0},
    {217, 217, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {221, 221, 0},
    {222, 222, 0},
    {223, 223, 0},
    {224, 224, 0},
    {225, 225, 0},
    {226, 226, 0},
    {227, 227, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 230, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {236, 236, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {240, 240, 0},
    {241, 241, 0},
    {242, 242, 0},
    {243, 243, 0},
    {244, 244, 0},
    {245, 245, 0},
    {246, 246, 0},
    {247, 247, 0},
    {248, 248, 0},
    {249, 249, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {253, 253, 0},
    {254, 254, 0},
    {255, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {338, 188, 0},
    {339, 189, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 413; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_16[414] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 164, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {536, 170, 0},
    {537, 186, 0},
    {538, 222, 0},
    {539, 254, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 167, 0},
    {0, 0, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {0, 0, 0},
    {173, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 176, 0},
    {177, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {182, 182, 0},
    {183, 183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {187, 187, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {192, 192, 0},
    {193, 193, 0},
    {194, 194, 0},
    {0, 0, 0},
    {196, 196, 0},
    {0, 0, 0},
    {198, 198, 0},
    {199, 199, 0},
    {200, 200, 0},
    {201, 201, 0},
    {202, 202, 0},
    {203, 203, 0},
    {204, 204, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {0, 0, 0},
    {0, 0, 0},
    {210, 210, 0},
    {211, 211, 0},
    {212, 212, 0},
    {0, 0, 0},
    {214, 214, 0},
    {0, 0, 0},
    {0, 0, 0},
    {217, 217, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {223, 223, 0},
    {224, 224, 0},
    {225, 225, 0},
    {226, 226, 0},
    {0, 0, 0},
    {228, 228, 0},
    {0, 0, 0},
    {230, 230, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {236, 236, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {0, 0, 0},
    {0, 0, 0},
    {242, 242, 0},
    {243, 243, 0},
    {244, 244, 0},
    {0, 0, 0},
    {246, 246, 0},
    {0, 0, 0},
    {0, 0, 0},
    {249, 249, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {255, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {258, 195, 0},
    {259, 227, 0},
    {260, 161, 0},
    {261, 162, 0},
    {262, 197, 0},
    {263, 229, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {268, 178, 0},
    {269, 185, 0},
    {0, 0, 0},
    {0, 0, 0},
    {272, 208, 0},
    {273, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {280, 221, 0},
    {281, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {321, 163, 0},
    {322, 179, 0},
    {323, 209, 0},
    {324, 241, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {336, 213, 0},
    {337, 245, 0},
    {338, 188, 0},
    {339, 189, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {346, 215, 0},
    {347, 247, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {352, 166, 0},
    {353, 168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {368, 216, 0},
    {369, 248, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8221, 181, 0},
    {8222, 165, 0},
    {376, 190, 0},
    {377, 172, 0},
    {378, 174, 0},
    {379, 175, 0},
    {380, 191, 0},
    {381, 180, 0},
    {382, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 368; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_2[369] = 
{
    {0, 0, 0},{368, 219, 0},
    {369, 251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {377, 172, 0},
    {378, 188, 0},
    {379, 175, 0},
    {380, 191, 0},
    {381, 174, 0},
    {382, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {164, 164, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 167, 0},
    {168, 168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {173, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 176, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {180, 180, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {184, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {193, 193, 0},
    {194, 194, 0},
    {0, 0, 0},
    {196, 196, 0},
    {0, 0, 0},
    {0, 0, 0},
    {199, 199, 0},
    {0, 0, 0},
    {201, 201, 0},
    {0, 0, 0},
    {203, 203, 0},
    {0, 0, 0},
    {205, 205, 0},
    {206, 206, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {211, 211, 0},
    {212, 212, 0},
    {0, 0, 0},
    {214, 214, 0},
    {215, 215, 0},
    {0, 0, 0},
    {0, 0, 0},
    {218, 218, 0},
    {0, 0, 0},
    {220, 220, 0},
    {221, 221, 0},
    {0, 0, 0},
    {223, 223, 0},
    {0, 0, 0},
    {225, 225, 0},
    {226, 226, 0},
    {0, 0, 0},
    {228, 228, 0},
    {0, 0, 0},
    {0, 0, 0},
    {231, 231, 0},
    {0, 0, 0},
    {233, 233, 0},
    {0, 0, 0},
    {235, 235, 0},
    {0, 0, 0},
    {237, 237, 0},
    {238, 238, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {243, 243, 0},
    {244, 244, 0},
    {0, 0, 0},
    {246, 246, 0},
    {247, 247, 0},
    {0, 0, 0},
    {0, 0, 0},
    {250, 250, 0},
    {0, 0, 0},
    {252, 252, 0},
    {253, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {258, 195, 0},
    {259, 227, 0},
    {260, 161, 0},
    {261, 177, 0},
    {262, 198, 0},
    {263, 230, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {268, 200, 0},
    {269, 232, 0},
    {270, 207, 0},
    {271, 239, 0},
    {272, 208, 0},
    {273, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {280, 202, 0},
    {281, 234, 0},
    {282, 204, 0},
    {283, 236, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {313, 197, 0},
    {314, 229, 0},
    {0, 0, 0},
    {0, 0, 0},
    {317, 165, 0},
    {318, 181, 0},
    {0, 0, 0},
    {0, 0, 0},
    {321, 163, 0},
    {322, 179, 0},
    {323, 209, 0},
    {324, 241, 0},
    {0, 0, 0},
    {0, 0, 0},
    {327, 210, 0},
    {328, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {336, 213, 0},
    {337, 245, 0},
    {0, 0, 0},
    {0, 0, 0},
    {340, 192, 0},
    {341, 224, 0},
    {0, 0, 0},
    {711, 183, 0},
    {344, 216, 0},
    {345, 248, 0},
    {346, 166, 0},
    {347, 182, 0},
    {0, 0, 0},
    {0, 0, 0},
    {350, 170, 0},
    {351, 186, 0},
    {352, 169, 0},
    {353, 185, 0},
    {354, 222, 0},
    {355, 254, 0},
    {356, 171, 0},
    {357, 187, 0},
    {0, 0, 0},
    {0, 0, 0},
    {728, 162, 0},
    {729, 255, 0},
    {0, 0, 0},
    {731, 178, 0},
    {0, 0, 0},
    {733, 189, 0},
    {366, 217, 0},
    {367, 249, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_3[344] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {348, 222, 0},
    {349, 254, 0},
    {350, 170, 0},
    {351, 186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {364, 221, 0},
    {365, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {379, 175, 0},
    {380, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {728, 162, 0},
    {729, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {163, 163, 0},
    {164, 164, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 167, 0},
    {168, 168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {173, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 176, 0},
    {0, 0, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {0, 0, 0},
    {183, 183, 0},
    {184, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {189, 189, 0},
    {0, 0, 0},
    {0, 0, 0},
    {192, 192, 0},
    {193, 193, 0},
    {194, 194, 0},
    {0, 0, 0},
    {196, 196, 0},
    {0, 0, 0},
    {0, 0, 0},
    {199, 199, 0},
    {200, 200, 0},
    {201, 201, 0},
    {202, 202, 0},
    {203, 203, 0},
    {204, 204, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {0, 0, 0},
    {209, 209, 0},
    {210, 210, 0},
    {211, 211, 0},
    {212, 212, 0},
    {0, 0, 0},
    {214, 214, 0},
    {215, 215, 0},
    {0, 0, 0},
    {217, 217, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {223, 223, 0},
    {224, 224, 0},
    {225, 225, 0},
    {226, 226, 0},
    {0, 0, 0},
    {228, 228, 0},
    {0, 0, 0},
    {0, 0, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {236, 236, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {0, 0, 0},
    {241, 241, 0},
    {242, 242, 0},
    {243, 243, 0},
    {244, 244, 0},
    {0, 0, 0},
    {246, 246, 0},
    {247, 247, 0},
    {0, 0, 0},
    {249, 249, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {264, 198, 0},
    {265, 230, 0},
    {266, 197, 0},
    {267, 229, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {284, 216, 0},
    {285, 248, 0},
    {286, 171, 0},
    {287, 187, 0},
    {288, 213, 0},
    {289, 245, 0},
    {0, 0, 0},
    {0, 0, 0},
    {292, 166, 0},
    {293, 182, 0},
    {294, 161, 0},
    {295, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {304, 169, 0},
    {305, 185, 0},
    {0, 0, 0},
    {0, 0, 0},
    {308, 172, 0},
    {309, 188, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_4[344] = 
{
    {0, 0, 0},{343, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {352, 169, 0},
    {353, 185, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {358, 172, 0},
    {359, 188, 0},
    {360, 221, 0},
    {361, 253, 0},
    {362, 222, 0},
    {363, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {711, 183, 0},
    {0, 0, 0},
    {370, 217, 0},
    {371, 249, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {381, 174, 0},
    {382, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {729, 255, 0},
    {0, 0, 0},
    {731, 178, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {164, 164, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 167, 0},
    {168, 168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {173, 173, 0},
    {0, 0, 0},
    {175, 175, 0},
    {176, 176, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {180, 180, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {184, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {193, 193, 0},
    {194, 194, 0},
    {195, 195, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 198, 0},
    {0, 0, 0},
    {0, 0, 0},
    {201, 201, 0},
    {0, 0, 0},
    {203, 203, 0},
    {0, 0, 0},
    {205, 205, 0},
    {206, 206, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {212, 212, 0},
    {213, 213, 0},
    {214, 214, 0},
    {215, 215, 0},
    {216, 216, 0},
    {0, 0, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {223, 223, 0},
    {0, 0, 0},
    {225, 225, 0},
    {226, 226, 0},
    {227, 227, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 230, 0},
    {0, 0, 0},
    {0, 0, 0},
    {233, 233, 0},
    {0, 0, 0},
    {235, 235, 0},
    {0, 0, 0},
    {237, 237, 0},
    {238, 238, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {244, 244, 0},
    {245, 245, 0},
    {246, 246, 0},
    {247, 247, 0},
    {248, 248, 0},
    {0, 0, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {256, 192, 0},
    {257, 224, 0},
    {0, 0, 0},
    {0, 0, 0},
    {260, 161, 0},
    {261, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {268, 200, 0},
    {269, 232, 0},
    {0, 0, 0},
    {0, 0, 0},
    {272, 208, 0},
    {273, 240, 0},
    {274, 170, 0},
    {275, 186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {278, 204, 0},
    {279, 236, 0},
    {280, 202, 0},
    {281, 234, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {290, 171, 0},
    {291, 187, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {296, 165, 0},
    {297, 181, 0},
    {298, 207, 0},
    {299, 239, 0},
    {0, 0, 0},
    {0, 0, 0},
    {302, 199, 0},
    {303, 231, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {310, 211, 0},
    {311, 243, 0},
    {312, 162, 0},
    {0, 0, 0},
    {0, 0, 0},
    {315, 166, 0},
    {316, 182, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {325, 209, 0},
    {326, 241, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {330, 189, 0},
    {331, 191, 0},
    {332, 210, 0},
    {333, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {342, 163, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_5[344] = 
{
    {0, 0, 0},{1029, 165, 0},
    {1030, 166, 0},
    {1031, 167, 0},
    {1032, 168, 0},
    {1033, 169, 0},
    {1034, 170, 0},
    {1035, 171, 0},
    {1036, 172, 0},
    {0, 0, 0},
    {1038, 174, 0},
    {1039, 175, 0},
    {1040, 176, 0},
    {1041, 177, 0},
    {1042, 178, 0},
    {1043, 179, 0},
    {1044, 180, 0},
    {1045, 181, 0},
    {1046, 182, 0},
    {1047, 183, 0},
    {1048, 184, 0},
    {1049, 185, 0},
    {1050, 186, 0},
    {1051, 187, 0},
    {1052, 188, 0},
    {1053, 189, 0},
    {1054, 190, 0},
    {1055, 191, 0},
    {1056, 192, 0},
    {1057, 193, 0},
    {1058, 194, 0},
    {1059, 195, 0},
    {1060, 196, 0},
    {1061, 197, 0},
    {1062, 198, 0},
    {1063, 199, 0},
    {1064, 200, 0},
    {1065, 201, 0},
    {1066, 202, 0},
    {1067, 203, 0},
    {1068, 204, 0},
    {1069, 205, 0},
    {1070, 206, 0},
    {1071, 207, 0},
    {1072, 208, 0},
    {1073, 209, 0},
    {1074, 210, 0},
    {1075, 211, 0},
    {1076, 212, 0},
    {1077, 213, 0},
    {1078, 214, 0},
    {1079, 215, 0},
    {1080, 216, 0},
    {1081, 217, 0},
    {1082, 218, 0},
    {1083, 219, 0},
    {1084, 220, 0},
    {1085, 221, 0},
    {1086, 222, 0},
    {1087, 223, 0},
    {1088, 224, 0},
    {1089, 225, 0},
    {1090, 226, 0},
    {1091, 227, 0},
    {1092, 228, 0},
    {1093, 229, 0},
    {1094, 230, 0},
    {1095, 231, 0},
    {1096, 232, 0},
    {1097, 233, 0},
    {1098, 234, 0},
    {1099, 235, 0},
    {1100, 236, 0},
    {1101, 237, 0},
    {1102, 238, 0},
    {1103, 239, 0},
    {0, 0, 0},
    {1105, 241, 0},
    {1106, 242, 0},
    {1107, 243, 0},
    {1108, 244, 0},
    {1109, 245, 0},
    {1110, 246, 0},
    {1111, 247, 0},
    {1112, 248, 0},
    {1113, 249, 0},
    {1114, 250, 0},
    {1115, 251, 0},
    {1116, 252, 0},
    {0, 0, 0},
    {1118, 254, 0},
    {1119, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {173, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8470, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1025, 161, 0},
    {1026, 162, 0},
    {1027, 163, 0},
    {1028, 164, 0}
};

/* Table size: 343; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_6[344] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {164, 164, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {173, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1548, 172, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1563, 187, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1567, 191, 0},
    {0, 0, 0},
    {1569, 193, 0},
    {1570, 194, 0},
    {1571, 195, 0},
    {1572, 196, 0},
    {1573, 197, 0},
    {1574, 198, 0},
    {1575, 199, 0},
    {1576, 200, 0},
    {1577, 201, 0},
    {1578, 202, 0},
    {1579, 203, 0},
    {1580, 204, 0},
    {1581, 205, 0},
    {1582, 206, 0},
    {1583, 207, 0},
    {1584, 208, 0},
    {1585, 209, 0},
    {1586, 210, 0},
    {1587, 211, 0},
    {1588, 212, 0},
    {1589, 213, 0},
    {1590, 214, 0},
    {1591, 215, 0},
    {1592, 216, 0},
    {1593, 217, 0},
    {1594, 218, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1600, 224, 0},
    {1601, 225, 0},
    {1602, 226, 0},
    {1603, 227, 0},
    {1604, 228, 0},
    {1605, 229, 0},
    {1606, 230, 0},
    {1607, 231, 0},
    {1608, 232, 0},
    {1609, 233, 0},
    {1610, 234, 0},
    {1611, 235, 0},
    {1612, 236, 0},
    {1613, 237, 0},
    {1614, 238, 0},
    {1615, 239, 0},
    {1616, 240, 0},
    {1617, 241, 0},
    {1618, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 344; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_7[345] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 164, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8367, 165, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {163, 163, 0},
    {0, 0, 0},
    {0, 0, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {183, 183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {187, 187, 0},
    {0, 0, 0},
    {189, 189, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {890, 170, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {900, 180, 0},
    {901, 181, 0},
    {902, 182, 0},
    {0, 0, 0},
    {904, 184, 0},
    {905, 185, 0},
    {906, 186, 0},
    {0, 0, 0},
    {908, 188, 0},
    {0, 0, 0},
    {910, 190, 0},
    {911, 191, 0},
    {912, 192, 0},
    {913, 193, 0},
    {914, 194, 0},
    {915, 195, 0},
    {916, 196, 0},
    {917, 197, 0},
    {918, 198, 0},
    {919, 199, 0},
    {920, 200, 0},
    {921, 201, 0},
    {922, 202, 0},
    {923, 203, 0},
    {924, 204, 0},
    {925, 205, 0},
    {926, 206, 0},
    {927, 207, 0},
    {928, 208, 0},
    {929, 209, 0},
    {0, 0, 0},
    {931, 211, 0},
    {932, 212, 0},
    {933, 213, 0},
    {934, 214, 0},
    {935, 215, 0},
    {936, 216, 0},
    {937, 217, 0},
    {938, 218, 0},
    {939, 219, 0},
    {940, 220, 0},
    {941, 221, 0},
    {942, 222, 0},
    {943, 223, 0},
    {944, 224, 0},
    {945, 225, 0},
    {946, 226, 0},
    {947, 227, 0},
    {948, 228, 0},
    {949, 229, 0},
    {950, 230, 0},
    {951, 231, 0},
    {952, 232, 0},
    {953, 233, 0},
    {954, 234, 0},
    {955, 235, 0},
    {956, 236, 0},
    {957, 237, 0},
    {958, 238, 0},
    {959, 239, 0},
    {960, 240, 0},
    {961, 241, 0},
    {962, 242, 0},
    {963, 243, 0},
    {964, 244, 0},
    {965, 245, 0},
    {966, 246, 0},
    {967, 247, 0},
    {968, 248, 0},
    {969, 249, 0},
    {970, 250, 0},
    {971, 251, 0},
    {972, 252, 0},
    {973, 253, 0},
    {974, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8213, 175, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 161, 0},
    {8217, 162, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 347; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_iso_8859_8[348] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1488, 224, 0},
    {1489, 225, 0},
    {1490, 226, 0},
    {1491, 227, 0},
    {1492, 228, 0},
    {1493, 229, 0},
    {1494, 230, 0},
    {1495, 231, 0},
    {1496, 232, 0},
    {1497, 233, 0},
    {1498, 234, 0},
    {1499, 235, 0},
    {1500, 236, 0},
    {1501, 237, 0},
    {1502, 238, 0},
    {1503, 239, 0},
    {1504, 240, 0},
    {1505, 241, 0},
    {1506, 242, 0},
    {1507, 243, 0},
    {1508, 244, 0},
    {1509, 245, 0},
    {1510, 246, 0},
    {1511, 247, 0},
    {1512, 248, 0},
    {1513, 249, 0},
    {1514, 250, 0},
    {0, 0, 0},
    {128, 128, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {133, 133, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {145, 145, 0},
    {146, 146, 0},
    {147, 147, 0},
    {148, 148, 0},
    {149, 149, 0},
    {150, 150, 0},
    {151, 151, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {162, 162, 0},
    {163, 163, 0},
    {164, 164, 0},
    {165, 165, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 175, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 184, 0},
    {185, 185, 0},
    {0, 0, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {215, 170, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8206, 253, 0},
    {8207, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8215, 223, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {247, 186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 486; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_koi8_r[487] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8776, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1025, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8804, 152, 0},
    {8805, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1040, 225, 0},
    {1041, 226, 0},
    {1042, 247, 0},
    {1043, 231, 0},
    {1044, 228, 0},
    {1045, 229, 0},
    {1046, 246, 0},
    {1047, 250, 0},
    {1048, 233, 0},
    {1049, 234, 0},
    {1050, 235, 0},
    {1051, 236, 0},
    {1052, 237, 0},
    {1053, 238, 0},
    {1054, 239, 0},
    {1055, 240, 0},
    {1056, 242, 0},
    {1057, 243, 0},
    {1058, 244, 0},
    {1059, 245, 0},
    {1060, 230, 0},
    {1061, 232, 0},
    {1062, 227, 0},
    {1063, 254, 0},
    {1064, 251, 0},
    {1065, 253, 0},
    {1066, 255, 0},
    {1067, 249, 0},
    {1068, 248, 0},
    {1069, 252, 0},
    {1070, 224, 0},
    {1071, 241, 0},
    {1072, 193, 0},
    {1073, 194, 0},
    {1074, 215, 0},
    {1075, 199, 0},
    {1076, 196, 0},
    {1077, 197, 0},
    {1078, 214, 0},
    {1079, 218, 0},
    {1080, 201, 0},
    {1081, 202, 0},
    {1082, 203, 0},
    {1083, 204, 0},
    {1084, 205, 0},
    {1085, 206, 0},
    {1086, 207, 0},
    {1087, 208, 0},
    {1088, 210, 0},
    {1089, 211, 0},
    {1090, 212, 0},
    {1091, 213, 0},
    {1092, 198, 0},
    {1093, 200, 0},
    {1094, 195, 0},
    {1095, 222, 0},
    {1096, 219, 0},
    {1097, 221, 0},
    {1098, 223, 0},
    {1099, 217, 0},
    {1100, 216, 0},
    {1101, 220, 0},
    {1102, 192, 0},
    {1103, 209, 0},
    {0, 0, 0},
    {1105, 163, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {160, 154, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {169, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 156, 0},
    {0, 0, 0},
    {178, 157, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {183, 158, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9472, 128, 0},
    {0, 0, 0},
    {9474, 129, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8992, 147, 0},
    {8993, 155, 0},
    {0, 0, 0},
    {247, 159, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9484, 130, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9488, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9492, 132, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9496, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9500, 134, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9508, 135, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9516, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9524, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9532, 138, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9552, 160, 0},
    {9553, 161, 0},
    {9554, 162, 0},
    {9555, 164, 0},
    {9556, 165, 0},
    {9557, 166, 0},
    {9558, 167, 0},
    {9559, 168, 0},
    {9560, 169, 0},
    {9561, 170, 0},
    {9562, 171, 0},
    {9563, 172, 0},
    {9564, 173, 0},
    {9565, 174, 0},
    {9566, 175, 0},
    {9567, 176, 0},
    {9568, 177, 0},
    {9569, 178, 0},
    {9570, 180, 0},
    {9571, 181, 0},
    {9572, 182, 0},
    {9573, 183, 0},
    {9574, 184, 0},
    {9575, 185, 0},
    {9576, 186, 0},
    {9577, 187, 0},
    {9578, 188, 0},
    {9579, 189, 0},
    {9580, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9600, 139, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9604, 140, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9608, 141, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9612, 142, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9616, 143, 0},
    {9617, 144, 0},
    {9618, 145, 0},
    {9619, 146, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9632, 148, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8729, 149, 0},
    {8730, 150, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 380; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_koi8_u[381] = 
{
    {0, 0, 0},{9500, 134, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9508, 135, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9516, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9524, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1168, 189, 0},
    {1169, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9532, 138, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8776, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9552, 160, 0},
    {9553, 161, 0},
    {9554, 162, 0},
    {0, 0, 0},
    {9556, 165, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9559, 168, 0},
    {9560, 169, 0},
    {9561, 170, 0},
    {9562, 171, 0},
    {9563, 172, 0},
    {8804, 152, 0},
    {8805, 153, 0},
    {9566, 175, 0},
    {9567, 176, 0},
    {9568, 177, 0},
    {9569, 178, 0},
    {0, 0, 0},
    {9571, 181, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9574, 184, 0},
    {9575, 185, 0},
    {9576, 186, 0},
    {9577, 187, 0},
    {9578, 188, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9600, 139, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9604, 140, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9608, 141, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9612, 142, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9616, 143, 0},
    {9617, 144, 0},
    {9618, 145, 0},
    {9619, 146, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9632, 148, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {160, 154, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {169, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {176, 156, 0},
    {0, 0, 0},
    {178, 157, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {183, 158, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {247, 159, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8992, 147, 0},
    {8993, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1025, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1028, 180, 0},
    {0, 0, 0},
    {1030, 182, 0},
    {1031, 183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1038, 190, 0},
    {0, 0, 0},
    {1040, 225, 0},
    {1041, 226, 0},
    {1042, 247, 0},
    {1043, 231, 0},
    {1044, 228, 0},
    {1045, 229, 0},
    {1046, 246, 0},
    {1047, 250, 0},
    {1048, 233, 0},
    {1049, 234, 0},
    {1050, 235, 0},
    {1051, 236, 0},
    {1052, 237, 0},
    {1053, 238, 0},
    {1054, 239, 0},
    {1055, 240, 0},
    {1056, 242, 0},
    {1057, 243, 0},
    {1058, 244, 0},
    {1059, 245, 0},
    {1060, 230, 0},
    {1061, 232, 0},
    {1062, 227, 0},
    {1063, 254, 0},
    {1064, 251, 0},
    {1065, 253, 0},
    {1066, 255, 0},
    {1067, 249, 0},
    {1068, 248, 0},
    {1069, 252, 0},
    {1070, 224, 0},
    {1071, 241, 0},
    {1072, 193, 0},
    {1073, 194, 0},
    {1074, 215, 0},
    {1075, 199, 0},
    {1076, 196, 0},
    {1077, 197, 0},
    {1078, 214, 0},
    {1079, 218, 0},
    {1080, 201, 0},
    {1081, 202, 0},
    {1082, 203, 0},
    {1083, 204, 0},
    {1084, 205, 0},
    {1085, 206, 0},
    {1086, 207, 0},
    {1087, 208, 0},
    {1088, 210, 0},
    {1089, 211, 0},
    {1090, 212, 0},
    {1091, 213, 0},
    {1092, 198, 0},
    {1093, 200, 0},
    {1094, 195, 0},
    {1095, 222, 0},
    {1096, 219, 0},
    {1097, 221, 0},
    {1098, 223, 0},
    {1099, 217, 0},
    {1100, 216, 0},
    {1101, 220, 0},
    {1102, 192, 0},
    {1103, 209, 0},
    {0, 0, 0},
    {1105, 163, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1108, 164, 0},
    {0, 0, 0},
    {1110, 166, 0},
    {1111, 167, 0},
    {9472, 128, 0},
    {0, 0, 0},
    {9474, 129, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1118, 174, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9484, 130, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9488, 131, 0},
    {8729, 149, 0},
    {8730, 150, 0},
    {0, 0, 0},
    {9492, 132, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9496, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 343; Max deep: 2 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_macintosh[351] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 228, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 220, 0},
    {8250, 221, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {710, 246, 0},
    {711, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8260, 218, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {376, 217, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {728, 249, 0},
    {729, 250, 0},
    {730, 251, 0},
    {731, 254, 0},
    {732, 247, 0},
    {733, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 196, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {9674, 215, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {64257, 222, 0},
    {64258, 223, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8706, 182, 0},
    {8364, 219, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8710, 198, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8719, 184, 0},
    {0, 0, 0},
    {8721, 183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8730, 195, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8734, 176, 0},
    {160, 202, 0},
    {161, 193, 0},
    {162, 162, 0},
    {163, 163, 0},
    {0, 0, 0},
    {165, 180, 0},
    {0, 0, 0},
    {167, 164, 0},
    {168, 172, 0},
    {169, 169, 0},
    {170, 187, 0},
    {171, 199, 0},
    {8747, 186, 349},
    {0, 0, 0},
    {174, 168, 0},
    {175, 248, 0},
    {176, 161, 0},
    {177, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {180, 171, 0},
    {181, 181, 0},
    {182, 166, 0},
    {183, 225, 0},
    {184, 252, 0},
    {0, 0, 0},
    {186, 188, 0},
    {187, 200, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {191, 192, 0},
    {192, 203, 0},
    {193, 231, 0},
    {194, 229, 0},
    {195, 204, 0},
    {196, 128, 0},
    {197, 129, 0},
    {198, 174, 0},
    {199, 130, 0},
    {200, 233, 0},
    {201, 131, 350},
    {202, 230, 0},
    {203, 232, 0},
    {204, 237, 0},
    {205, 234, 0},
    {206, 235, 0},
    {207, 236, 0},
    {0, 0, 0},
    {209, 132, 0},
    {210, 241, 0},
    {211, 238, 0},
    {212, 239, 0},
    {213, 205, 0},
    {214, 133, 0},
    {0, 0, 0},
    {216, 175, 0},
    {217, 244, 0},
    {218, 242, 0},
    {219, 243, 0},
    {220, 134, 0},
    {0, 0, 0},
    {0, 0, 0},
    {223, 167, 0},
    {224, 136, 0},
    {225, 135, 345},
    {226, 137, 0},
    {227, 139, 0},
    {228, 138, 0},
    {229, 140, 346},
    {8805, 179, 348},
    {231, 141, 0},
    {232, 143, 0},
    {233, 142, 0},
    {234, 144, 0},
    {235, 145, 0},
    {236, 147, 0},
    {237, 146, 0},
    {238, 148, 0},
    {239, 149, 0},
    {0, 0, 0},
    {241, 150, 0},
    {242, 152, 0},
    {243, 151, 0},
    {244, 153, 0},
    {245, 155, 0},
    {246, 154, 0},
    {247, 214, 0},
    {248, 191, 0},
    {249, 157, 0},
    {250, 156, 344},
    {251, 158, 347},
    {252, 159, 0},
    {0, 0, 0},
    {0, 0, 0},
    {255, 216, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {960, 185, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {63743, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {305, 245, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 208, 0},
    {8212, 209, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 212, 0},
    {8217, 213, 0},
    {8218, 226, 0},
    {0, 0, 0},
    {8220, 210, 0},
    {8221, 211, 0},
    {8222, 227, 0},
    {0, 0, 0},
    {8224, 160, 0},
    {8225, 224, 0},
    {8226, 165, 0},
    {338, 206, 0},
    {339, 207, 0},
    {0, 0, 0},
    {8230, 201, 0},
    {0, 0, 0},
    {8482, 170, 0},
    {8800, 173, 0},
    {8804, 178, 0},
    {937, 189, 0},
    {230, 190, 0},
    {172, 194, 0},
    {8776, 197, 0}
};

/* Table size: 432; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1250[433] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {0, 0, 0},
    {131, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {136, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {152, 152, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 128, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {164, 164, 0},
    {0, 0, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {0, 0, 0},
    {176, 176, 0},
    {177, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {187, 187, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {193, 193, 0},
    {194, 194, 0},
    {0, 0, 0},
    {196, 196, 0},
    {0, 0, 0},
    {0, 0, 0},
    {199, 199, 0},
    {0, 0, 0},
    {201, 201, 0},
    {0, 0, 0},
    {203, 203, 0},
    {0, 0, 0},
    {205, 205, 0},
    {206, 206, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {211, 211, 0},
    {212, 212, 0},
    {0, 0, 0},
    {214, 214, 0},
    {215, 215, 0},
    {0, 0, 0},
    {0, 0, 0},
    {218, 218, 0},
    {0, 0, 0},
    {220, 220, 0},
    {221, 221, 0},
    {0, 0, 0},
    {223, 223, 0},
    {0, 0, 0},
    {225, 225, 0},
    {226, 226, 0},
    {0, 0, 0},
    {228, 228, 0},
    {0, 0, 0},
    {0, 0, 0},
    {231, 231, 0},
    {0, 0, 0},
    {233, 233, 0},
    {0, 0, 0},
    {235, 235, 0},
    {0, 0, 0},
    {237, 237, 0},
    {238, 238, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {243, 243, 0},
    {244, 244, 0},
    {0, 0, 0},
    {246, 246, 0},
    {247, 247, 0},
    {0, 0, 0},
    {0, 0, 0},
    {250, 250, 0},
    {0, 0, 0},
    {252, 252, 0},
    {253, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {258, 195, 0},
    {259, 227, 0},
    {260, 165, 0},
    {261, 185, 0},
    {262, 198, 0},
    {263, 230, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {268, 200, 0},
    {269, 232, 0},
    {270, 207, 0},
    {271, 239, 0},
    {272, 208, 0},
    {273, 240, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {711, 161, 0},
    {280, 202, 0},
    {281, 234, 0},
    {282, 204, 0},
    {283, 236, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {728, 162, 0},
    {729, 255, 0},
    {0, 0, 0},
    {731, 178, 0},
    {0, 0, 0},
    {733, 189, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {313, 197, 0},
    {314, 229, 0},
    {0, 0, 0},
    {0, 0, 0},
    {317, 188, 0},
    {318, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {321, 163, 0},
    {322, 179, 0},
    {323, 209, 0},
    {324, 241, 0},
    {0, 0, 0},
    {0, 0, 0},
    {327, 210, 0},
    {328, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {336, 213, 0},
    {337, 245, 0},
    {0, 0, 0},
    {0, 0, 0},
    {340, 192, 0},
    {341, 224, 0},
    {0, 0, 0},
    {0, 0, 0},
    {344, 216, 0},
    {345, 248, 0},
    {346, 140, 0},
    {347, 156, 0},
    {0, 0, 0},
    {0, 0, 0},
    {350, 170, 0},
    {351, 186, 0},
    {352, 138, 0},
    {353, 154, 0},
    {354, 222, 0},
    {355, 254, 0},
    {356, 141, 0},
    {357, 157, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {366, 217, 0},
    {367, 249, 0},
    {368, 219, 0},
    {369, 251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {377, 143, 0},
    {378, 159, 0},
    {379, 175, 0},
    {380, 191, 0},
    {381, 142, 0},
    {382, 158, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 362; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1251[363] = 
{
    {0, 0, 0},{1086, 238, 0},
    {1087, 239, 0},
    {1088, 240, 0},
    {1089, 241, 0},
    {1090, 242, 0},
    {1091, 243, 0},
    {1092, 244, 0},
    {1093, 245, 0},
    {1094, 246, 0},
    {1095, 247, 0},
    {1096, 248, 0},
    {1097, 249, 0},
    {1098, 250, 0},
    {1099, 251, 0},
    {1100, 252, 0},
    {1101, 253, 0},
    {1102, 254, 0},
    {1103, 255, 0},
    {0, 0, 0},
    {1105, 184, 0},
    {1106, 144, 0},
    {1107, 131, 0},
    {1108, 186, 0},
    {1109, 190, 0},
    {1110, 179, 0},
    {1111, 191, 0},
    {1112, 188, 0},
    {1113, 154, 0},
    {1114, 156, 0},
    {1115, 158, 0},
    {1116, 157, 0},
    {0, 0, 0},
    {1118, 162, 0},
    {1119, 159, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1168, 165, 0},
    {1169, 180, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8470, 185, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {152, 152, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {164, 164, 0},
    {0, 0, 0},
    {166, 166, 0},
    {167, 167, 0},
    {0, 0, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {0, 0, 0},
    {176, 176, 0},
    {177, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {187, 187, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1025, 168, 0},
    {1026, 128, 0},
    {1027, 129, 0},
    {1028, 170, 0},
    {1029, 189, 0},
    {1030, 178, 0},
    {1031, 175, 0},
    {1032, 163, 0},
    {1033, 138, 0},
    {1034, 140, 0},
    {1035, 142, 0},
    {1036, 141, 0},
    {0, 0, 0},
    {1038, 161, 0},
    {1039, 143, 0},
    {1040, 192, 0},
    {1041, 193, 0},
    {1042, 194, 0},
    {1043, 195, 0},
    {1044, 196, 0},
    {1045, 197, 0},
    {1046, 198, 0},
    {1047, 199, 0},
    {1048, 200, 0},
    {1049, 201, 0},
    {1050, 202, 0},
    {1051, 203, 0},
    {1052, 204, 0},
    {1053, 205, 0},
    {1054, 206, 0},
    {1055, 207, 0},
    {1056, 208, 0},
    {1057, 209, 0},
    {1058, 210, 0},
    {1059, 211, 0},
    {1060, 212, 0},
    {1061, 213, 0},
    {1062, 214, 0},
    {1063, 215, 0},
    {1064, 216, 0},
    {1065, 217, 0},
    {1066, 218, 0},
    {1067, 219, 0},
    {1068, 220, 0},
    {1069, 221, 0},
    {1070, 222, 0},
    {1071, 223, 0},
    {1072, 224, 0},
    {1073, 225, 0},
    {1074, 226, 0},
    {1075, 227, 0},
    {1076, 228, 0},
    {1077, 229, 0},
    {1078, 230, 0},
    {1079, 231, 0},
    {1080, 232, 0},
    {1081, 233, 0},
    {1082, 234, 0},
    {1083, 235, 0},
    {1084, 236, 0},
    {1085, 237, 0}
};

/* Table size: 373; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1252[374] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {376, 159, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {381, 142, 0},
    {382, 158, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {141, 141, 0},
    {0, 0, 0},
    {143, 143, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {157, 157, 0},
    {8364, 128, 0},
    {0, 0, 0},
    {160, 160, 0},
    {161, 161, 0},
    {162, 162, 0},
    {163, 163, 0},
    {164, 164, 0},
    {165, 165, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {170, 170, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 175, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 184, 0},
    {185, 185, 0},
    {186, 186, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {191, 191, 0},
    {192, 192, 0},
    {193, 193, 0},
    {194, 194, 0},
    {195, 195, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 198, 0},
    {199, 199, 0},
    {200, 200, 0},
    {201, 201, 0},
    {202, 202, 0},
    {203, 203, 0},
    {204, 204, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {208, 208, 0},
    {209, 209, 0},
    {210, 210, 0},
    {211, 211, 0},
    {212, 212, 0},
    {213, 213, 0},
    {214, 214, 0},
    {215, 215, 0},
    {216, 216, 0},
    {217, 217, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {221, 221, 0},
    {222, 222, 0},
    {223, 223, 0},
    {224, 224, 0},
    {225, 225, 0},
    {226, 226, 0},
    {227, 227, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 230, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {236, 236, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {240, 240, 0},
    {241, 241, 0},
    {242, 242, 0},
    {243, 243, 0},
    {244, 244, 0},
    {245, 245, 0},
    {246, 246, 0},
    {247, 247, 0},
    {248, 248, 0},
    {249, 249, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {253, 253, 0},
    {254, 254, 0},
    {255, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {710, 136, 0},
    {338, 140, 0},
    {339, 156, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {352, 138, 0},
    {353, 154, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {732, 152, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 354; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1253[355] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {8213, 175, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {136, 136, 0},
    {0, 0, 0},
    {138, 138, 0},
    {0, 0, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {152, 152, 0},
    {0, 0, 0},
    {154, 154, 0},
    {0, 0, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {163, 163, 0},
    {164, 164, 0},
    {165, 165, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {0, 0, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {0, 0, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {187, 187, 0},
    {0, 0, 0},
    {189, 189, 0},
    {0, 0, 0},
    {0, 0, 0},
    {900, 180, 0},
    {901, 161, 0},
    {902, 162, 0},
    {0, 0, 0},
    {904, 184, 0},
    {905, 185, 0},
    {906, 186, 0},
    {0, 0, 0},
    {908, 188, 0},
    {0, 0, 0},
    {910, 190, 0},
    {911, 191, 0},
    {912, 192, 0},
    {913, 193, 0},
    {914, 194, 0},
    {915, 195, 0},
    {916, 196, 0},
    {917, 197, 0},
    {918, 198, 0},
    {919, 199, 0},
    {920, 200, 0},
    {921, 201, 0},
    {922, 202, 0},
    {923, 203, 0},
    {924, 204, 0},
    {925, 205, 0},
    {926, 206, 0},
    {927, 207, 0},
    {928, 208, 0},
    {929, 209, 0},
    {8364, 128, 0},
    {931, 211, 0},
    {932, 212, 0},
    {933, 213, 0},
    {934, 214, 0},
    {935, 215, 0},
    {936, 216, 0},
    {937, 217, 0},
    {938, 218, 0},
    {939, 219, 0},
    {940, 220, 0},
    {941, 221, 0},
    {942, 222, 0},
    {943, 223, 0},
    {944, 224, 0},
    {945, 225, 0},
    {946, 226, 0},
    {947, 227, 0},
    {948, 228, 0},
    {949, 229, 0},
    {950, 230, 0},
    {951, 231, 0},
    {952, 232, 0},
    {953, 233, 0},
    {954, 234, 0},
    {955, 235, 0},
    {956, 236, 0},
    {957, 237, 0},
    {958, 238, 0},
    {959, 239, 0},
    {960, 240, 0},
    {961, 241, 0},
    {962, 242, 0},
    {963, 243, 0},
    {964, 244, 0},
    {965, 245, 0},
    {966, 246, 0},
    {967, 247, 0},
    {968, 248, 0},
    {969, 249, 0},
    {970, 250, 0},
    {971, 251, 0},
    {972, 252, 0},
    {973, 253, 0},
    {974, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 354; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1254[355] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {710, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {376, 159, 0},
    {0, 0, 0},
    {732, 152, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {157, 157, 0},
    {158, 158, 0},
    {0, 0, 0},
    {160, 160, 0},
    {161, 161, 0},
    {162, 162, 0},
    {163, 163, 0},
    {164, 164, 0},
    {165, 165, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {170, 170, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 175, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 184, 0},
    {185, 185, 0},
    {186, 186, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {191, 191, 0},
    {192, 192, 0},
    {193, 193, 0},
    {194, 194, 0},
    {195, 195, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 198, 0},
    {199, 199, 0},
    {200, 200, 0},
    {201, 201, 0},
    {202, 202, 0},
    {203, 203, 0},
    {204, 204, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {0, 0, 0},
    {209, 209, 0},
    {210, 210, 0},
    {211, 211, 0},
    {212, 212, 0},
    {213, 213, 0},
    {214, 214, 0},
    {215, 215, 0},
    {216, 216, 0},
    {217, 217, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {0, 0, 0},
    {8364, 128, 0},
    {223, 223, 0},
    {224, 224, 0},
    {225, 225, 0},
    {226, 226, 0},
    {227, 227, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 230, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {236, 236, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {0, 0, 0},
    {241, 241, 0},
    {242, 242, 0},
    {243, 243, 0},
    {244, 244, 0},
    {245, 245, 0},
    {246, 246, 0},
    {247, 247, 0},
    {248, 248, 0},
    {249, 249, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {255, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {286, 208, 0},
    {287, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {304, 221, 0},
    {305, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {338, 140, 0},
    {339, 156, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {350, 222, 0},
    {351, 254, 0},
    {352, 138, 0},
    {353, 154, 0}
};

/* Table size: 467; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1255[468] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1456, 192, 0},
    {1457, 193, 0},
    {1458, 194, 0},
    {1459, 195, 0},
    {1460, 196, 0},
    {1461, 197, 0},
    {1462, 198, 0},
    {1463, 199, 0},
    {1464, 200, 0},
    {1465, 201, 0},
    {1466, 202, 0},
    {1467, 203, 0},
    {1468, 204, 0},
    {1469, 205, 0},
    {1470, 206, 0},
    {1471, 207, 0},
    {1472, 208, 0},
    {1473, 209, 0},
    {1474, 210, 0},
    {1475, 211, 0},
    {0, 0, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1488, 224, 0},
    {1489, 225, 0},
    {1490, 226, 0},
    {1491, 227, 0},
    {1492, 228, 0},
    {1493, 229, 0},
    {1494, 230, 0},
    {1495, 231, 0},
    {1496, 232, 0},
    {1497, 233, 0},
    {1498, 234, 0},
    {1499, 235, 0},
    {1500, 236, 0},
    {1501, 237, 0},
    {1502, 238, 0},
    {1503, 239, 0},
    {1504, 240, 0},
    {1505, 241, 0},
    {1506, 242, 0},
    {1507, 243, 0},
    {1508, 244, 0},
    {1509, 245, 0},
    {1510, 246, 0},
    {1511, 247, 0},
    {1512, 248, 0},
    {1513, 249, 0},
    {1514, 250, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1520, 212, 0},
    {1521, 213, 0},
    {1522, 214, 0},
    {1523, 215, 0},
    {1524, 216, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {138, 138, 0},
    {0, 0, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {154, 154, 0},
    {0, 0, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {161, 161, 0},
    {162, 162, 0},
    {163, 163, 0},
    {0, 0, 0},
    {165, 165, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 175, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 184, 0},
    {185, 185, 0},
    {0, 0, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {191, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {215, 170, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {710, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {247, 186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {732, 152, 0},
    {0, 0, 0},
    {8206, 253, 0},
    {8207, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8362, 164, 0},
    {0, 0, 0},
    {8364, 128, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 343; Max deep: 2 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1256[357] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1722, 159, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1726, 170, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1729, 192, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {710, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1746, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 128, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {160, 160, 0},
    {0, 0, 0},
    {162, 162, 0},
    {163, 163, 0},
    {164, 164, 0},
    {165, 165, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 175, 0},
    {1548, 161, 347},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 184, 0},
    {185, 185, 0},
    {0, 0, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {1563, 186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1567, 191, 0},
    {0, 0, 0},
    {1569, 193, 0},
    {1570, 194, 0},
    {1571, 195, 0},
    {1572, 196, 0},
    {1573, 197, 0},
    {1574, 198, 0},
    {1575, 199, 0},
    {1576, 200, 0},
    {1577, 201, 0},
    {1578, 202, 0},
    {1579, 203, 0},
    {1580, 204, 0},
    {1581, 205, 0},
    {1582, 206, 0},
    {1583, 207, 0},
    {1584, 208, 0},
    {1585, 209, 0},
    {1586, 210, 0},
    {1587, 211, 348},
    {1588, 212, 0},
    {1589, 213, 0},
    {1590, 214, 0},
    {1591, 216, 0},
    {1592, 217, 0},
    {1593, 218, 0},
    {1594, 219, 0},
    {0, 0, 0},
    {224, 224, 0},
    {0, 0, 0},
    {226, 226, 0},
    {0, 0, 0},
    {1600, 220, 0},
    {1601, 221, 0},
    {1602, 222, 0},
    {1603, 223, 349},
    {1604, 225, 350},
    {1605, 227, 351},
    {1606, 228, 352},
    {1607, 229, 353},
    {1608, 230, 0},
    {1609, 236, 0},
    {1610, 237, 354},
    {239, 239, 355},
    {1612, 241, 0},
    {1613, 242, 0},
    {1614, 243, 0},
    {1615, 245, 0},
    {244, 244, 356},
    {1617, 248, 0},
    {1618, 250, 0},
    {247, 247, 0},
    {0, 0, 0},
    {249, 249, 0},
    {8482, 153, 0},
    {251, 251, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1657, 138, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1662, 129, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1670, 141, 0},
    {0, 0, 0},
    {1672, 143, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1681, 154, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8204, 157, 0},
    {1688, 142, 346},
    {8206, 253, 0},
    {8207, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 344},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {338, 140, 0},
    {1711, 144, 345},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {1705, 152, 0},
    {339, 156, 0},
    {8205, 158, 0},
    {176, 176, 0},
    {215, 215, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {238, 238, 0},
    {1611, 240, 0},
    {1616, 246, 0}
};

/* Table size: 355; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1257[356] = 
{
    {0, 0, 0},{0, 0, 0},
    {711, 142, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {362, 219, 0},
    {363, 251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {370, 216, 0},
    {371, 248, 0},
    {0, 0, 0},
    {0, 0, 0},
    {729, 255, 0},
    {0, 0, 0},
    {731, 158, 0},
    {377, 202, 0},
    {378, 234, 0},
    {379, 221, 0},
    {380, 253, 0},
    {381, 222, 0},
    {382, 254, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {0, 0, 0},
    {131, 131, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {136, 136, 0},
    {0, 0, 0},
    {138, 138, 0},
    {0, 0, 0},
    {140, 140, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {152, 152, 0},
    {0, 0, 0},
    {154, 154, 0},
    {0, 0, 0},
    {156, 156, 0},
    {0, 0, 0},
    {0, 0, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {162, 162, 0},
    {163, 163, 0},
    {164, 164, 0},
    {0, 0, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 141, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 157, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 143, 0},
    {185, 185, 0},
    {0, 0, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 175, 0},
    {8364, 128, 0},
    {0, 0, 0},
    {201, 201, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {211, 211, 0},
    {0, 0, 0},
    {213, 213, 0},
    {214, 214, 0},
    {215, 215, 0},
    {216, 168, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {220, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {223, 223, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 191, 0},
    {0, 0, 0},
    {0, 0, 0},
    {233, 233, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {243, 243, 0},
    {0, 0, 0},
    {245, 245, 0},
    {246, 246, 0},
    {247, 247, 0},
    {248, 184, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {256, 194, 0},
    {257, 226, 0},
    {0, 0, 0},
    {0, 0, 0},
    {260, 192, 0},
    {261, 224, 0},
    {262, 195, 0},
    {263, 227, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {268, 200, 0},
    {269, 232, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {274, 199, 0},
    {275, 231, 0},
    {0, 0, 0},
    {0, 0, 0},
    {278, 203, 0},
    {279, 235, 0},
    {280, 198, 0},
    {281, 230, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {290, 204, 0},
    {291, 236, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {298, 206, 0},
    {299, 238, 0},
    {0, 0, 0},
    {0, 0, 0},
    {302, 193, 0},
    {303, 225, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {310, 205, 0},
    {311, 237, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {315, 207, 0},
    {316, 239, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {321, 217, 0},
    {322, 249, 0},
    {323, 209, 0},
    {324, 241, 0},
    {325, 210, 0},
    {326, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {332, 212, 0},
    {333, 244, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {342, 170, 0},
    {343, 186, 0},
    {0, 0, 0},
    {0, 0, 0},
    {346, 218, 0},
    {347, 250, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {352, 208, 0},
    {353, 240, 0},
    {0, 0, 0}
};

/* Table size: 405; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_1258[406] = 
{
    {0, 0, 0},{0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {416, 213, 0},
    {417, 245, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {431, 221, 0},
    {432, 253, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {8218, 130, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {8222, 132, 0},
    {0, 0, 0},
    {8224, 134, 0},
    {8225, 135, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {138, 138, 0},
    {0, 0, 0},
    {8240, 137, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8249, 139, 0},
    {8250, 155, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {154, 154, 0},
    {0, 0, 0},
    {0, 0, 0},
    {157, 157, 0},
    {158, 158, 0},
    {0, 0, 0},
    {160, 160, 0},
    {161, 161, 0},
    {162, 162, 0},
    {163, 163, 0},
    {164, 164, 0},
    {165, 165, 0},
    {166, 166, 0},
    {167, 167, 0},
    {168, 168, 0},
    {169, 169, 0},
    {170, 170, 0},
    {171, 171, 0},
    {172, 172, 0},
    {173, 173, 0},
    {174, 174, 0},
    {175, 175, 0},
    {176, 176, 0},
    {177, 177, 0},
    {178, 178, 0},
    {179, 179, 0},
    {180, 180, 0},
    {181, 181, 0},
    {182, 182, 0},
    {183, 183, 0},
    {184, 184, 0},
    {185, 185, 0},
    {186, 186, 0},
    {187, 187, 0},
    {188, 188, 0},
    {189, 189, 0},
    {190, 190, 0},
    {191, 191, 0},
    {192, 192, 0},
    {193, 193, 0},
    {194, 194, 0},
    {0, 0, 0},
    {196, 196, 0},
    {197, 197, 0},
    {198, 198, 0},
    {199, 199, 0},
    {200, 200, 0},
    {201, 201, 0},
    {202, 202, 0},
    {203, 203, 0},
    {0, 0, 0},
    {205, 205, 0},
    {206, 206, 0},
    {207, 207, 0},
    {0, 0, 0},
    {209, 209, 0},
    {0, 0, 0},
    {211, 211, 0},
    {212, 212, 0},
    {0, 0, 0},
    {214, 214, 0},
    {215, 215, 0},
    {216, 216, 0},
    {217, 217, 0},
    {218, 218, 0},
    {219, 219, 0},
    {220, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {223, 223, 0},
    {224, 224, 0},
    {225, 225, 0},
    {226, 226, 0},
    {0, 0, 0},
    {228, 228, 0},
    {229, 229, 0},
    {230, 230, 0},
    {231, 231, 0},
    {232, 232, 0},
    {233, 233, 0},
    {234, 234, 0},
    {235, 235, 0},
    {0, 0, 0},
    {237, 237, 0},
    {238, 238, 0},
    {239, 239, 0},
    {0, 0, 0},
    {241, 241, 0},
    {0, 0, 0},
    {243, 243, 0},
    {244, 244, 0},
    {0, 0, 0},
    {246, 246, 0},
    {247, 247, 0},
    {248, 248, 0},
    {249, 249, 0},
    {250, 250, 0},
    {251, 251, 0},
    {252, 252, 0},
    {0, 0, 0},
    {0, 0, 0},
    {255, 255, 0},
    {0, 0, 0},
    {0, 0, 0},
    {258, 195, 0},
    {259, 227, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8363, 254, 0},
    {8364, 128, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {272, 208, 0},
    {273, 240, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {710, 136, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {732, 152, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {338, 140, 0},
    {339, 156, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {768, 204, 0},
    {769, 236, 0},
    {0, 0, 0},
    {771, 222, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {777, 210, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {376, 159, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8482, 153, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {803, 242, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 131, 0},
    {0, 0, 0},
    {0, 0, 0}
};

/* Table size: 359; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_windows_874[360] = 
{
    {0, 0, 0},{3590, 166, 0},
    {3591, 167, 0},
    {3592, 168, 0},
    {3593, 169, 0},
    {3594, 170, 0},
    {3595, 171, 0},
    {3596, 172, 0},
    {3597, 173, 0},
    {3598, 174, 0},
    {3599, 175, 0},
    {3600, 176, 0},
    {3601, 177, 0},
    {3602, 178, 0},
    {3603, 179, 0},
    {3604, 180, 0},
    {3605, 181, 0},
    {3606, 182, 0},
    {3607, 183, 0},
    {3608, 184, 0},
    {3609, 185, 0},
    {3610, 186, 0},
    {3611, 187, 0},
    {3612, 188, 0},
    {3613, 189, 0},
    {3614, 190, 0},
    {3615, 191, 0},
    {3616, 192, 0},
    {3617, 193, 0},
    {3618, 194, 0},
    {3619, 195, 0},
    {3620, 196, 0},
    {3621, 197, 0},
    {3622, 198, 0},
    {3623, 199, 0},
    {3624, 200, 0},
    {3625, 201, 0},
    {3626, 202, 0},
    {3627, 203, 0},
    {3628, 204, 0},
    {3629, 205, 0},
    {3630, 206, 0},
    {3631, 207, 0},
    {3632, 208, 0},
    {3633, 209, 0},
    {3634, 210, 0},
    {3635, 211, 0},
    {3636, 212, 0},
    {3637, 213, 0},
    {3638, 214, 0},
    {3639, 215, 0},
    {3640, 216, 0},
    {3641, 217, 0},
    {3642, 218, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {3647, 223, 0},
    {3648, 224, 0},
    {3649, 225, 0},
    {3650, 226, 0},
    {3651, 227, 0},
    {3652, 228, 0},
    {3653, 229, 0},
    {3654, 230, 0},
    {3655, 231, 0},
    {3656, 232, 0},
    {3657, 233, 0},
    {3658, 234, 0},
    {3659, 235, 0},
    {3660, 236, 0},
    {3661, 237, 0},
    {3662, 238, 0},
    {3663, 239, 0},
    {3664, 240, 0},
    {3665, 241, 0},
    {3666, 242, 0},
    {3667, 243, 0},
    {3668, 244, 0},
    {3669, 245, 0},
    {3670, 246, 0},
    {3671, 247, 0},
    {3672, 248, 0},
    {3673, 249, 0},
    {3674, 250, 0},
    {3675, 251, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 128, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {129, 129, 0},
    {130, 130, 0},
    {131, 131, 0},
    {132, 132, 0},
    {0, 0, 0},
    {134, 134, 0},
    {135, 135, 0},
    {136, 136, 0},
    {137, 137, 0},
    {138, 138, 0},
    {139, 139, 0},
    {140, 140, 0},
    {141, 141, 0},
    {142, 142, 0},
    {143, 143, 0},
    {144, 144, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {152, 152, 0},
    {153, 153, 0},
    {154, 154, 0},
    {155, 155, 0},
    {156, 156, 0},
    {157, 157, 0},
    {158, 158, 0},
    {159, 159, 0},
    {160, 160, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 150, 0},
    {8212, 151, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 145, 0},
    {8217, 146, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8220, 147, 0},
    {8221, 148, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8226, 149, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 133, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {3585, 161, 0},
    {3586, 162, 0},
    {3587, 163, 0},
    {3588, 164, 0},
    {3589, 165, 0}
};

/* Table size: 373; Max deep: 1 */
LXB_API const lexbor_shs_hash_t lxb_encoding_single_hash_x_mac_cyrillic[374] = 
{
    {0, 0, 0},{1119, 219, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8211, 208, 0},
    {8212, 209, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8216, 212, 0},
    {8217, 213, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8220, 210, 0},
    {8221, 211, 0},
    {8222, 215, 0},
    {0, 0, 0},
    {8224, 160, 0},
    {0, 0, 0},
    {8226, 165, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8230, 201, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {402, 196, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1168, 162, 0},
    {1169, 182, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8710, 198, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8730, 195, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8734, 176, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8364, 255, 0},
    {0, 0, 0},
    {160, 202, 0},
    {0, 0, 0},
    {0, 0, 0},
    {163, 163, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {167, 164, 0},
    {0, 0, 0},
    {169, 169, 0},
    {0, 0, 0},
    {171, 199, 0},
    {172, 194, 0},
    {0, 0, 0},
    {174, 168, 0},
    {0, 0, 0},
    {176, 161, 0},
    {177, 177, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {181, 181, 0},
    {182, 166, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {187, 200, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8776, 197, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8800, 173, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8804, 178, 0},
    {8805, 179, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {247, 214, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8470, 220, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {8482, 170, 0},
    {0, 0, 0},
    {0, 0, 0},
    {1025, 221, 0},
    {1026, 171, 0},
    {1027, 174, 0},
    {1028, 184, 0},
    {1029, 193, 0},
    {1030, 167, 0},
    {1031, 186, 0},
    {1032, 183, 0},
    {1033, 188, 0},
    {1034, 190, 0},
    {1035, 203, 0},
    {1036, 205, 0},
    {0, 0, 0},
    {1038, 216, 0},
    {1039, 218, 0},
    {1040, 128, 0},
    {1041, 129, 0},
    {1042, 130, 0},
    {1043, 131, 0},
    {1044, 132, 0},
    {1045, 133, 0},
    {1046, 134, 0},
    {1047, 135, 0},
    {1048, 136, 0},
    {1049, 137, 0},
    {1050, 138, 0},
    {1051, 139, 0},
    {1052, 140, 0},
    {1053, 141, 0},
    {1054, 142, 0},
    {1055, 143, 0},
    {1056, 144, 0},
    {1057, 145, 0},
    {1058, 146, 0},
    {1059, 147, 0},
    {1060, 148, 0},
    {1061, 149, 0},
    {1062, 150, 0},
    {1063, 151, 0},
    {1064, 152, 0},
    {1065, 153, 0},
    {1066, 154, 0},
    {1067, 155, 0},
    {1068, 156, 0},
    {1069, 157, 0},
    {1070, 158, 0},
    {1071, 159, 0},
    {1072, 224, 0},
    {1073, 225, 0},
    {1074, 226, 0},
    {1075, 227, 0},
    {1076, 228, 0},
    {1077, 229, 0},
    {1078, 230, 0},
    {1079, 231, 0},
    {1080, 232, 0},
    {1081, 233, 0},
    {1082, 234, 0},
    {1083, 235, 0},
    {1084, 236, 0},
    {1085, 237, 0},
    {1086, 238, 0},
    {1087, 239, 0},
    {1088, 240, 0},
    {1089, 241, 0},
    {1090, 242, 0},
    {1091, 243, 0},
    {1092, 244, 0},
    {1093, 245, 0},
    {1094, 246, 0},
    {1095, 247, 0},
    {1096, 248, 0},
    {1097, 249, 0},
    {1098, 250, 0},
    {1099, 251, 0},
    {1100, 252, 0},
    {1101, 253, 0},
    {1102, 254, 0},
    {1103, 223, 0},
    {0, 0, 0},
    {1105, 222, 0},
    {1106, 172, 0},
    {1107, 175, 0},
    {1108, 185, 0},
    {1109, 207, 0},
    {1110, 180, 0},
    {1111, 187, 0},
    {1112, 192, 0},
    {1113, 189, 0},
    {1114, 191, 0},
    {1115, 204, 0},
    {1116, 206, 0},
    {0, 0, 0},
    {1118, 217, 0}
};
