/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.util.stax.JDOMStreamReader;
import org.jdom.Element;

public class ClientFaultConverter
extends AbstractHandler {
    public void invoke(MessageContext context) throws Exception {
        XFireFault fault = (XFireFault)context.getExchange().getFaultMessage().getBody();
        if (fault.getDetail() != null && fault.getDetail().getChildren().size() > 0) {
            this.processFaultDetail(fault, context);
        }
    }

    protected void processFaultDetail(XFireFault fault, MessageContext context) throws Exception {
        Element exDetail = (Element)fault.getDetail().getChildren().get(0);
        MessagePartInfo faultPart = this.getFaultPart(context.getExchange().getOperation(), exDetail);
        if (faultPart == null || faultPart.getTypeClass() == null) {
            return;
        }
        BindingProvider provider = context.getService().getBindingProvider();
        JDOMStreamReader reader = new JDOMStreamReader(exDetail);
        reader.nextTag();
        Object e = provider.readParameter(faultPart, reader, context);
        if (!(e instanceof Exception)) {
            Class exClass = ((FaultInfo)faultPart.getContainer()).getExceptionClass();
            Constructor constructor = exClass.getConstructor(String.class, faultPart.getTypeClass());
            e = constructor.newInstance(fault.getMessage(), e);
        }
        context.getExchange().getFaultMessage().setBody(e);
    }

    protected MessagePartInfo getFaultPart(OperationInfo operation, Element exDetail) {
        QName qname = new QName(exDetail.getNamespaceURI(), exDetail.getName());
        Iterator itr = operation.getFaults().iterator();
        while (itr.hasNext()) {
            FaultInfo faultInfo = (FaultInfo)itr.next();
            MessagePartInfo part = faultInfo.getMessagePart(qname);
            if (part == null) continue;
            return part;
        }
        return null;
    }
}

