#!/usr/bin/env python
#
#
#    This file is part of DvdRip Queue
#    
#    DvdRip Queue is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#    
#    DvdRip Queue is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#    
#    You should have received a copy of the GNU General Public License
#    along with DvdRip Queue.  If not, see <http://www.gnu.org/licenses/>.
#    

import gtk, os
from ConfigParser import ConfigParser

from dvdrip_lib import getPref

class prefsWindow:
    def __init__(self, app):
        
        self.app = app
        
        # Set Glade File  
        self.gladefile = "./gui/dvdrip-queue-prefs.glade"
        self.wTree = gtk.glade.XML(self.gladefile) 
 
        # Get the Main window and connect the "destroy" event
        self.Window = self.wTree.get_widget("prefsWindow")
        
        # Define which function gets called for each signal (from the gui)
        dic = {    "on_prefsApplyButton_clicked" : self.applyPrefs,
                "on_prefsCancelButton_clicked" : self.cancelPrefs,
                "on_prefsWindow_destroy_event" : self.cancelPrefs,
                "on_btn2_clicked" : self.btn2_clicked,
                "on_btn4_clicked" : self.btn4_clicked,
                "on_btn6_clicked" : self.btn6_clicked,
                "on_btn12_clicked" : self.btn12_clicked,
                "on_btnResetData_clicked" : self.resetDataDir,
                "on_btnResetTime_clicked" : self.resetMaxEncodeTime,
                "on_btnResetAll_clicked" : self.resetAll
              }
        
        self.wTree.signal_autoconnect(dic)
        
        self.loadPrefsDataToWidgets()
        
        self.Window.show()
        
    def loadPrefsDataToWidgets(self):
        # Set up the Data Directory fileChooser widget
        self.fileChooser = self.wTree.get_widget("prefsFileChooser")
        self.fileChooser.set_action(2) #Set the filechooser to choose a Directory
        self.fileChooser.set_current_folder( getPref("datadirectory") ) #Set current value
        
        # Set up the Max Encode Time SpinButton Widget
        self.prefsWaitTimeChooser = self.wTree.get_widget("prefsWaitTimeChooser")
        self.prefsWaitTimeChooser.set_value( float(getPref("maxencodetime")) ) #Set current value
        
    def resetDataDir(self, widget):
        self.fileChooser.set_current_folder(getPref("datadirectory", True))
        
    def resetMaxEncodeTime(self, widget):
        self.prefsWaitTimeChooser.set_value( float(getPref("maxencodetime", True)) )
        
    def resetAll(self, widget):
        self.resetDataDir(None)
        self.resetMaxEncodeTime(None)
        
    def btnX_clicked(self, time):
        self.prefsWaitTimeChooser.set_value(time*60)
        
    def btn2_clicked(self, widget):
        self.btnX_clicked(2)
        
    def btn4_clicked(self, widget):
        self.btnX_clicked(4)
        
    def btn6_clicked(self, widget):
        self.btnX_clicked(6)
        
    def btn12_clicked(self, widget):
        self.btnX_clicked(12)
        
    def applyPrefs(self, widget):
        # set new data directory
        datadirectory = self.fileChooser.get_current_folder()
        maxEncodeTime = self.prefsWaitTimeChooser.get_value()
        
        # Try to open the config file. If it doesn't exist, create it
        try:
            configFile = open(os.path.expanduser("~/.dvdrip-queue"), "r")
        except:
            configFile = open(os.path.expanduser("~/.dvdrip-queue"), "w")
            configFile.close()
            configFile = open(os.path.expanduser("~/.dvdrip-queue"), "r")
            
        #make a ConfigParser instance and load the config file into it
        config = ConfigParser()
        config.readfp(configFile, ".dvdrip-queue")
        
        # close the config file so we can write to it
        configFile.close()
        
        #if the config file doesn't have a 'default' section make one
        if (not config.has_section("DEFAULT")):
            config.add_section("DEFAULT")
            
        #add 'datadirectory = /wherever/the/data/directory/is' to config file            
        config.set("DEFAULT", "datadirectory", datadirectory)
        config.set("DEFAULT", "maxEncodeTime", maxEncodeTime)
        
        configFile = open(os.path.expanduser("~/.dvdrip-queue"), "w")
        config.write(configFile)
        configFile.close()
        
        # Tell the main window to reload the *.rip files with the new data directory
        self.app.loadRipFiles()
        
        # Close the Preferences dialog
        self.closePrefs()
        
        
    def cancelPrefs(self, widget):
        self.closePrefs()    
        
    def closePrefs(self):
        self.Window.hide()
        self.Window.destroy()