/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io;

import com.sun.cdc.io.ConnectionBaseAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class BaseInputStream
extends InputStream {
    private ConnectionBaseAdapter parent;
    byte[] buf = new byte[1];
    byte[] markBuf = null;
    int markSize = 0;
    int markPos = 0;
    boolean isReadFromBuffer = false;

    BaseInputStream(ConnectionBaseAdapter connectionBaseAdapter) throws IOException {
        this.parent = connectionBaseAdapter;
    }

    private void ensureOpen() throws InterruptedIOException {
        if (this.parent == null) {
            throw new InterruptedIOException("Stream closed");
        }
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.parent.available();
    }

    public int read() throws IOException {
        if (this.read(this.buf, 0, 1) > 0) {
            return this.buf[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.ensureOpen();
        if (n2 == 0) {
            return 0;
        }
        int n4 = byArray[n] + byArray[n2 - 1] + byArray[n + n2 - 1];
        if (this.parent.markSupported()) {
            return this.parent.readBytes(byArray, n, n2);
        }
        if (this.isReadFromBuffer) {
            n3 = this.markSize - this.markPos;
            if (n3 > 0) {
                int n5 = n3 > n2 ? n2 : n3;
                System.arraycopy(this.markBuf, this.markPos, byArray, n, n5);
                this.markPos += n5;
                int n6 = 0;
                if (n5 < n2) {
                    n6 = this.parent.readBytes(byArray, n + n5, n2 - n5);
                    if (n6 == -1) {
                        n6 = 0;
                    } else if (this.markSize + n6 > this.markBuf.length) {
                        this.markBuf = null;
                    } else {
                        System.arraycopy(byArray, n + n5, this.markBuf, this.markSize, n6);
                        this.markSize += n6;
                    }
                    this.isReadFromBuffer = false;
                }
                return n5 + n6;
            }
            this.isReadFromBuffer = false;
        }
        n3 = this.parent.readBytes(byArray, n, n2);
        if (this.markBuf != null && n3 > 0) {
            if (this.markSize + n3 > this.markBuf.length) {
                this.markBuf = null;
            } else {
                System.arraycopy(byArray, n, this.markBuf, this.markSize, n3);
                this.markSize += n3;
            }
        }
        return n3;
    }

    public void close() throws IOException {
        if (this.parent != null) {
            this.parent.closeInputStream();
            this.parent = null;
        }
        this.markBuf = null;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        if (this.parent == null) {
            return;
        }
        if (this.parent.markSupported()) {
            this.parent.mark(n);
        } else {
            byte[] byArray = this.markBuf;
            if (this.isReadFromBuffer) {
                int n2 = this.markSize - this.markPos;
                if (n < n2) {
                    n = n2;
                }
                this.markBuf = new byte[n];
                System.arraycopy(byArray, this.markPos, this.markBuf, 0, n2);
                this.markSize = n2;
            } else {
                this.markBuf = new byte[n];
                this.markSize = 0;
            }
            this.markPos = 0;
        }
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.parent.markSupported()) {
            this.parent.reset();
        } else {
            if (this.markBuf == null) {
                throw new IOException("Invalid mark position");
            }
            this.markPos = 0;
            this.isReadFromBuffer = true;
        }
    }
}

