//  This software code is made available "AS IS" without warranties of any
//  kind.  You may copy, display, modify and redistribute the software
//  code either by itself or as incorporated into your code; provided that
//  you do not remove any proprietary notices.  Your use of this software
//  code is at your own risk and you waive any claim against Amazon
//  Digital Services, Inc. or its affiliates with respect to your use of
//  this software code. (c) 2006-2007 Amazon Digital Services, Inc. or its
//  affiliates.

package net.noderunner.amazon.s3;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class UrlEncoder {
	
	private UrlEncoder() {}
	
    static String encode(String unencoded) {
	    try {
	        return URLEncoder.encode(unencoded, "UTF-8");
	    } catch (UnsupportedEncodingException e) {
	        // should never happen
	        throw new RuntimeException("Could not url encode to UTF-8", e);
	    }
	}

}
