# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class DeliveryPackageInformation(_serialization.Model):
    """Contains information about the delivery package being shipped by the customer to the Microsoft data center.

    All required parameters must be populated in order to send to Azure.

    :ivar carrier_name: The name of the carrier that is used to ship the import or export drives.
     Required.
    :vartype carrier_name: str
    :ivar tracking_number: The tracking number of the package. Required.
    :vartype tracking_number: str
    :ivar drive_count: The number of drives included in the package.
    :vartype drive_count: int
    :ivar ship_date: The date when the package is shipped.
    :vartype ship_date: str
    """

    _validation = {
        "carrier_name": {"required": True},
        "tracking_number": {"required": True},
    }

    _attribute_map = {
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_number": {"key": "trackingNumber", "type": "str"},
        "drive_count": {"key": "driveCount", "type": "int"},
        "ship_date": {"key": "shipDate", "type": "str"},
    }

    def __init__(
        self,
        *,
        carrier_name: str,
        tracking_number: str,
        drive_count: Optional[int] = None,
        ship_date: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword carrier_name: The name of the carrier that is used to ship the import or export
         drives. Required.
        :paramtype carrier_name: str
        :keyword tracking_number: The tracking number of the package. Required.
        :paramtype tracking_number: str
        :keyword drive_count: The number of drives included in the package.
        :paramtype drive_count: int
        :keyword ship_date: The date when the package is shipped.
        :paramtype ship_date: str
        """
        super().__init__(**kwargs)
        self.carrier_name = carrier_name
        self.tracking_number = tracking_number
        self.drive_count = drive_count
        self.ship_date = ship_date


class DriveBitLockerKey(_serialization.Model):
    """BitLocker recovery key or password to the specified drive.

    :ivar bit_locker_key: BitLocker recovery key or password.
    :vartype bit_locker_key: str
    :ivar drive_id: Drive ID.
    :vartype drive_id: str
    """

    _attribute_map = {
        "bit_locker_key": {"key": "bitLockerKey", "type": "str"},
        "drive_id": {"key": "driveId", "type": "str"},
    }

    def __init__(self, *, bit_locker_key: Optional[str] = None, drive_id: Optional[str] = None, **kwargs):
        """
        :keyword bit_locker_key: BitLocker recovery key or password.
        :paramtype bit_locker_key: str
        :keyword drive_id: Drive ID.
        :paramtype drive_id: str
        """
        super().__init__(**kwargs)
        self.bit_locker_key = bit_locker_key
        self.drive_id = drive_id


class DriveStatus(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Provides information about the drive's status.

    :ivar drive_id: The drive's hardware serial number, without spaces.
    :vartype drive_id: str
    :ivar bit_locker_key: The BitLocker key used to encrypt the drive.
    :vartype bit_locker_key: str
    :ivar manifest_file: The relative path of the manifest file on the drive.
    :vartype manifest_file: str
    :ivar manifest_hash: The Base16-encoded MD5 hash of the manifest file on the drive.
    :vartype manifest_hash: str
    :ivar drive_header_hash: The drive header hash value.
    :vartype drive_header_hash: str
    :ivar state: The drive's current state. Known values are: "Specified", "Received",
     "NeverReceived", "Transferring", "Completed", "CompletedMoreInfo", and "ShippedBack".
    :vartype state: str or ~azure.mgmt.storageimportexport.models.DriveState
    :ivar copy_status: Detailed status about the data transfer process. This field is not returned
     in the response until the drive is in the Transferring state.
    :vartype copy_status: str
    :ivar percent_complete: Percentage completed for the drive.
    :vartype percent_complete: int
    :ivar verbose_log_uri: A URI that points to the blob containing the verbose log for the data
     transfer operation.
    :vartype verbose_log_uri: str
    :ivar error_log_uri: A URI that points to the blob containing the error log for the data
     transfer operation.
    :vartype error_log_uri: str
    :ivar manifest_uri: A URI that points to the blob containing the drive manifest file.
    :vartype manifest_uri: str
    :ivar bytes_succeeded: Bytes successfully transferred for the drive.
    :vartype bytes_succeeded: int
    """

    _attribute_map = {
        "drive_id": {"key": "driveId", "type": "str"},
        "bit_locker_key": {"key": "bitLockerKey", "type": "str"},
        "manifest_file": {"key": "manifestFile", "type": "str"},
        "manifest_hash": {"key": "manifestHash", "type": "str"},
        "drive_header_hash": {"key": "driveHeaderHash", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "copy_status": {"key": "copyStatus", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "verbose_log_uri": {"key": "verboseLogUri", "type": "str"},
        "error_log_uri": {"key": "errorLogUri", "type": "str"},
        "manifest_uri": {"key": "manifestUri", "type": "str"},
        "bytes_succeeded": {"key": "bytesSucceeded", "type": "int"},
    }

    def __init__(
        self,
        *,
        drive_id: Optional[str] = None,
        bit_locker_key: Optional[str] = None,
        manifest_file: Optional[str] = None,
        manifest_hash: Optional[str] = None,
        drive_header_hash: Optional[str] = None,
        state: Union[str, "_models.DriveState"] = "Specified",
        copy_status: Optional[str] = None,
        percent_complete: Optional[int] = None,
        verbose_log_uri: Optional[str] = None,
        error_log_uri: Optional[str] = None,
        manifest_uri: Optional[str] = None,
        bytes_succeeded: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword drive_id: The drive's hardware serial number, without spaces.
        :paramtype drive_id: str
        :keyword bit_locker_key: The BitLocker key used to encrypt the drive.
        :paramtype bit_locker_key: str
        :keyword manifest_file: The relative path of the manifest file on the drive.
        :paramtype manifest_file: str
        :keyword manifest_hash: The Base16-encoded MD5 hash of the manifest file on the drive.
        :paramtype manifest_hash: str
        :keyword drive_header_hash: The drive header hash value.
        :paramtype drive_header_hash: str
        :keyword state: The drive's current state. Known values are: "Specified", "Received",
         "NeverReceived", "Transferring", "Completed", "CompletedMoreInfo", and "ShippedBack".
        :paramtype state: str or ~azure.mgmt.storageimportexport.models.DriveState
        :keyword copy_status: Detailed status about the data transfer process. This field is not
         returned in the response until the drive is in the Transferring state.
        :paramtype copy_status: str
        :keyword percent_complete: Percentage completed for the drive.
        :paramtype percent_complete: int
        :keyword verbose_log_uri: A URI that points to the blob containing the verbose log for the data
         transfer operation.
        :paramtype verbose_log_uri: str
        :keyword error_log_uri: A URI that points to the blob containing the error log for the data
         transfer operation.
        :paramtype error_log_uri: str
        :keyword manifest_uri: A URI that points to the blob containing the drive manifest file.
        :paramtype manifest_uri: str
        :keyword bytes_succeeded: Bytes successfully transferred for the drive.
        :paramtype bytes_succeeded: int
        """
        super().__init__(**kwargs)
        self.drive_id = drive_id
        self.bit_locker_key = bit_locker_key
        self.manifest_file = manifest_file
        self.manifest_hash = manifest_hash
        self.drive_header_hash = drive_header_hash
        self.state = state
        self.copy_status = copy_status
        self.percent_complete = percent_complete
        self.verbose_log_uri = verbose_log_uri
        self.error_log_uri = error_log_uri
        self.manifest_uri = manifest_uri
        self.bytes_succeeded = bytes_succeeded


class EncryptionKeyDetails(_serialization.Model):
    """Specifies the encryption key properties.

    :ivar kek_type: The type of kek encryption key. Known values are: "MicrosoftManaged" and
     "CustomerManaged".
    :vartype kek_type: str or ~azure.mgmt.storageimportexport.models.EncryptionKekType
    :ivar kek_url: Specifies the url for kek encryption key.
    :vartype kek_url: str
    :ivar kek_vault_resource_id: Specifies the keyvault resource id for kek encryption key.
    :vartype kek_vault_resource_id: str
    """

    _attribute_map = {
        "kek_type": {"key": "kekType", "type": "str"},
        "kek_url": {"key": "kekUrl", "type": "str"},
        "kek_vault_resource_id": {"key": "kekVaultResourceID", "type": "str"},
    }

    def __init__(
        self,
        *,
        kek_type: Union[str, "_models.EncryptionKekType"] = "MicrosoftManaged",
        kek_url: Optional[str] = None,
        kek_vault_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kek_type: The type of kek encryption key. Known values are: "MicrosoftManaged" and
         "CustomerManaged".
        :paramtype kek_type: str or ~azure.mgmt.storageimportexport.models.EncryptionKekType
        :keyword kek_url: Specifies the url for kek encryption key.
        :paramtype kek_url: str
        :keyword kek_vault_resource_id: Specifies the keyvault resource id for kek encryption key.
        :paramtype kek_vault_resource_id: str
        """
        super().__init__(**kwargs)
        self.kek_type = kek_type
        self.kek_url = kek_url
        self.kek_vault_resource_id = kek_vault_resource_id


class ErrorResponse(_serialization.Model):
    """Response when errors occurred.

    :ivar code: Provides information about the error code.
    :vartype code: str
    :ivar message: Provides information about the error message.
    :vartype message: str
    :ivar target: Provides information about the error target.
    :vartype target: str
    :ivar details: Describes the error details if present.
    :vartype details: list[~azure.mgmt.storageimportexport.models.ErrorResponseErrorDetailsItem]
    :ivar innererror: Inner error object if present.
    :vartype innererror: JSON
    """

    _attribute_map = {
        "code": {"key": "error.code", "type": "str"},
        "message": {"key": "error.message", "type": "str"},
        "target": {"key": "error.target", "type": "str"},
        "details": {"key": "error.details", "type": "[ErrorResponseErrorDetailsItem]"},
        "innererror": {"key": "error.innererror", "type": "object"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorResponseErrorDetailsItem"]] = None,
        innererror: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword code: Provides information about the error code.
        :paramtype code: str
        :keyword message: Provides information about the error message.
        :paramtype message: str
        :keyword target: Provides information about the error target.
        :paramtype target: str
        :keyword details: Describes the error details if present.
        :paramtype details: list[~azure.mgmt.storageimportexport.models.ErrorResponseErrorDetailsItem]
        :keyword innererror: Inner error object if present.
        :paramtype innererror: JSON
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponseErrorDetailsItem(_serialization.Model):
    """ErrorResponseErrorDetailsItem.

    :ivar code: Provides information about the error code.
    :vartype code: str
    :ivar target: Provides information about the error target.
    :vartype target: str
    :ivar message: Provides information about the error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs
    ):
        """
        :keyword code: Provides information about the error code.
        :paramtype code: str
        :keyword target: Provides information about the error target.
        :paramtype target: str
        :keyword message: Provides information about the error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class Export(_serialization.Model):
    """A property containing information about the blobs to be exported for an export job. This property is required for export jobs, but must not be specified for import jobs.

    :ivar blob_list_blob_path: The relative URI to the block blob that contains the list of blob
     paths or blob path prefixes as defined above, beginning with the container name. If the blob is
     in root container, the URI must begin with $root.
    :vartype blob_list_blob_path: str
    :ivar blob_path: A collection of blob-path strings.
    :vartype blob_path: list[str]
    :ivar blob_path_prefix: A collection of blob-prefix strings.
    :vartype blob_path_prefix: list[str]
    """

    _attribute_map = {
        "blob_list_blob_path": {"key": "blobListBlobPath", "type": "str"},
        "blob_path": {"key": "blobList.blobPath", "type": "[str]"},
        "blob_path_prefix": {"key": "blobList.blobPathPrefix", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        blob_list_blob_path: Optional[str] = None,
        blob_path: Optional[List[str]] = None,
        blob_path_prefix: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword blob_list_blob_path: The relative URI to the block blob that contains the list of blob
         paths or blob path prefixes as defined above, beginning with the container name. If the blob is
         in root container, the URI must begin with $root.
        :paramtype blob_list_blob_path: str
        :keyword blob_path: A collection of blob-path strings.
        :paramtype blob_path: list[str]
        :keyword blob_path_prefix: A collection of blob-prefix strings.
        :paramtype blob_path_prefix: list[str]
        """
        super().__init__(**kwargs)
        self.blob_list_blob_path = blob_list_blob_path
        self.blob_path = blob_path
        self.blob_path_prefix = blob_path_prefix


class GetBitLockerKeysResponse(_serialization.Model):
    """GetBitLockerKeys response.

    :ivar value: drive status.
    :vartype value: list[~azure.mgmt.storageimportexport.models.DriveBitLockerKey]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DriveBitLockerKey]"},
    }

    def __init__(self, *, value: Optional[List["_models.DriveBitLockerKey"]] = None, **kwargs):
        """
        :keyword value: drive status.
        :paramtype value: list[~azure.mgmt.storageimportexport.models.DriveBitLockerKey]
        """
        super().__init__(**kwargs)
        self.value = value


class IdentityDetails(_serialization.Model):
    """Specifies the identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of identity. Known values are: "None", "SystemAssigned", and
     "UserAssigned".
    :vartype type: str or ~azure.mgmt.storageimportexport.models.IdentityType
    :ivar principal_id: Specifies the principal id for the identity for the job.
    :vartype principal_id: str
    :ivar tenant_id: Specifies the tenant id for the identity for the job.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, type: Union[str, "_models.IdentityType"] = "None", **kwargs):
        """
        :keyword type: The type of identity. Known values are: "None", "SystemAssigned", and
         "UserAssigned".
        :paramtype type: str or ~azure.mgmt.storageimportexport.models.IdentityType
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class JobDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Specifies the job properties.

    :ivar storage_account_id: The resource identifier of the storage account where data will be
     imported to or exported from.
    :vartype storage_account_id: str
    :ivar job_type: The type of job.
    :vartype job_type: str
    :ivar return_address: Specifies the return address information for the job.
    :vartype return_address: ~azure.mgmt.storageimportexport.models.ReturnAddress
    :ivar return_shipping: Specifies the return carrier and customer's account with the carrier.
    :vartype return_shipping: ~azure.mgmt.storageimportexport.models.ReturnShipping
    :ivar shipping_information: Contains information about the Microsoft datacenter to which the
     drives should be shipped.
    :vartype shipping_information: ~azure.mgmt.storageimportexport.models.ShippingInformation
    :ivar delivery_package: Contains information about the package being shipped by the customer to
     the Microsoft data center.
    :vartype delivery_package: ~azure.mgmt.storageimportexport.models.DeliveryPackageInformation
    :ivar return_package: Contains information about the package being shipped from the Microsoft
     data center to the customer to return the drives. The format is the same as the deliveryPackage
     property above. This property is not included if the drives have not yet been returned.
    :vartype return_package: ~azure.mgmt.storageimportexport.models.PackageInformation
    :ivar diagnostics_path: The virtual blob directory to which the copy logs and backups of drive
     manifest files (if enabled) will be stored.
    :vartype diagnostics_path: str
    :ivar log_level: Default value is Error. Indicates whether error logging or verbose logging
     will be enabled.
    :vartype log_level: str
    :ivar backup_drive_manifest: Default value is false. Indicates whether the manifest files on
     the drives should be copied to block blobs.
    :vartype backup_drive_manifest: bool
    :ivar state: Current state of the job.
    :vartype state: str
    :ivar cancel_requested: Indicates whether a request has been submitted to cancel the job.
    :vartype cancel_requested: bool
    :ivar percent_complete: Overall percentage completed for the job.
    :vartype percent_complete: int
    :ivar incomplete_blob_list_uri: A blob path that points to a block blob containing a list of
     blob names that were not exported due to insufficient drive space. If all blobs were exported
     successfully, then this element is not included in the response.
    :vartype incomplete_blob_list_uri: str
    :ivar drive_list: List of up to ten drives that comprise the job. The drive list is a required
     element for an import job; it is not specified for export jobs.
    :vartype drive_list: list[~azure.mgmt.storageimportexport.models.DriveStatus]
    :ivar export: A property containing information about the blobs to be exported for an export
     job. This property is included for export jobs only.
    :vartype export: ~azure.mgmt.storageimportexport.models.Export
    :ivar provisioning_state: Specifies the provisioning state of the job.
    :vartype provisioning_state: str
    :ivar encryption_key: Contains information about the encryption key.
    :vartype encryption_key: ~azure.mgmt.storageimportexport.models.EncryptionKeyDetails
    """

    _attribute_map = {
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "return_address": {"key": "returnAddress", "type": "ReturnAddress"},
        "return_shipping": {"key": "returnShipping", "type": "ReturnShipping"},
        "shipping_information": {"key": "shippingInformation", "type": "ShippingInformation"},
        "delivery_package": {"key": "deliveryPackage", "type": "DeliveryPackageInformation"},
        "return_package": {"key": "returnPackage", "type": "PackageInformation"},
        "diagnostics_path": {"key": "diagnosticsPath", "type": "str"},
        "log_level": {"key": "logLevel", "type": "str"},
        "backup_drive_manifest": {"key": "backupDriveManifest", "type": "bool"},
        "state": {"key": "state", "type": "str"},
        "cancel_requested": {"key": "cancelRequested", "type": "bool"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "incomplete_blob_list_uri": {"key": "incompleteBlobListUri", "type": "str"},
        "drive_list": {"key": "driveList", "type": "[DriveStatus]"},
        "export": {"key": "export", "type": "Export"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "encryption_key": {"key": "encryptionKey", "type": "EncryptionKeyDetails"},
    }

    def __init__(
        self,
        *,
        storage_account_id: Optional[str] = None,
        job_type: Optional[str] = None,
        return_address: Optional["_models.ReturnAddress"] = None,
        return_shipping: Optional["_models.ReturnShipping"] = None,
        shipping_information: Optional["_models.ShippingInformation"] = None,
        delivery_package: Optional["_models.DeliveryPackageInformation"] = None,
        return_package: Optional["_models.PackageInformation"] = None,
        diagnostics_path: Optional[str] = None,
        log_level: Optional[str] = None,
        backup_drive_manifest: bool = False,
        state: str = "Creating",
        cancel_requested: bool = False,
        percent_complete: Optional[int] = None,
        incomplete_blob_list_uri: Optional[str] = None,
        drive_list: Optional[List["_models.DriveStatus"]] = None,
        export: Optional["_models.Export"] = None,
        provisioning_state: Optional[str] = None,
        encryption_key: Optional["_models.EncryptionKeyDetails"] = None,
        **kwargs
    ):
        """
        :keyword storage_account_id: The resource identifier of the storage account where data will be
         imported to or exported from.
        :paramtype storage_account_id: str
        :keyword job_type: The type of job.
        :paramtype job_type: str
        :keyword return_address: Specifies the return address information for the job.
        :paramtype return_address: ~azure.mgmt.storageimportexport.models.ReturnAddress
        :keyword return_shipping: Specifies the return carrier and customer's account with the carrier.
        :paramtype return_shipping: ~azure.mgmt.storageimportexport.models.ReturnShipping
        :keyword shipping_information: Contains information about the Microsoft datacenter to which the
         drives should be shipped.
        :paramtype shipping_information: ~azure.mgmt.storageimportexport.models.ShippingInformation
        :keyword delivery_package: Contains information about the package being shipped by the customer
         to the Microsoft data center.
        :paramtype delivery_package: ~azure.mgmt.storageimportexport.models.DeliveryPackageInformation
        :keyword return_package: Contains information about the package being shipped from the
         Microsoft data center to the customer to return the drives. The format is the same as the
         deliveryPackage property above. This property is not included if the drives have not yet been
         returned.
        :paramtype return_package: ~azure.mgmt.storageimportexport.models.PackageInformation
        :keyword diagnostics_path: The virtual blob directory to which the copy logs and backups of
         drive manifest files (if enabled) will be stored.
        :paramtype diagnostics_path: str
        :keyword log_level: Default value is Error. Indicates whether error logging or verbose logging
         will be enabled.
        :paramtype log_level: str
        :keyword backup_drive_manifest: Default value is false. Indicates whether the manifest files on
         the drives should be copied to block blobs.
        :paramtype backup_drive_manifest: bool
        :keyword state: Current state of the job.
        :paramtype state: str
        :keyword cancel_requested: Indicates whether a request has been submitted to cancel the job.
        :paramtype cancel_requested: bool
        :keyword percent_complete: Overall percentage completed for the job.
        :paramtype percent_complete: int
        :keyword incomplete_blob_list_uri: A blob path that points to a block blob containing a list of
         blob names that were not exported due to insufficient drive space. If all blobs were exported
         successfully, then this element is not included in the response.
        :paramtype incomplete_blob_list_uri: str
        :keyword drive_list: List of up to ten drives that comprise the job. The drive list is a
         required element for an import job; it is not specified for export jobs.
        :paramtype drive_list: list[~azure.mgmt.storageimportexport.models.DriveStatus]
        :keyword export: A property containing information about the blobs to be exported for an export
         job. This property is included for export jobs only.
        :paramtype export: ~azure.mgmt.storageimportexport.models.Export
        :keyword provisioning_state: Specifies the provisioning state of the job.
        :paramtype provisioning_state: str
        :keyword encryption_key: Contains information about the encryption key.
        :paramtype encryption_key: ~azure.mgmt.storageimportexport.models.EncryptionKeyDetails
        """
        super().__init__(**kwargs)
        self.storage_account_id = storage_account_id
        self.job_type = job_type
        self.return_address = return_address
        self.return_shipping = return_shipping
        self.shipping_information = shipping_information
        self.delivery_package = delivery_package
        self.return_package = return_package
        self.diagnostics_path = diagnostics_path
        self.log_level = log_level
        self.backup_drive_manifest = backup_drive_manifest
        self.state = state
        self.cancel_requested = cancel_requested
        self.percent_complete = percent_complete
        self.incomplete_blob_list_uri = incomplete_blob_list_uri
        self.drive_list = drive_list
        self.export = export
        self.provisioning_state = provisioning_state
        self.encryption_key = encryption_key


class JobResponse(_serialization.Model):
    """Contains the job information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_data: SystemData of ImportExport Jobs.
    :vartype system_data: ~azure.mgmt.storageimportexport.models.SystemData
    :ivar id: Specifies the resource identifier of the job.
    :vartype id: str
    :ivar name: Specifies the name of the job.
    :vartype name: str
    :ivar type: Specifies the type of the job resource.
    :vartype type: str
    :ivar location: Specifies the Azure location where the job is created.
    :vartype location: str
    :ivar tags: Specifies the tags that are assigned to the job.
    :vartype tags: JSON
    :ivar properties: Specifies the job properties.
    :vartype properties: ~azure.mgmt.storageimportexport.models.JobDetails
    :ivar identity: Specifies the job identity details.
    :vartype identity: ~azure.mgmt.storageimportexport.models.IdentityDetails
    """

    _validation = {
        "system_data": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "object"},
        "properties": {"key": "properties", "type": "JobDetails"},
        "identity": {"key": "identity", "type": "IdentityDetails"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[JSON] = None,
        properties: Optional["_models.JobDetails"] = None,
        identity: Optional["_models.IdentityDetails"] = None,
        **kwargs
    ):
        """
        :keyword location: Specifies the Azure location where the job is created.
        :paramtype location: str
        :keyword tags: Specifies the tags that are assigned to the job.
        :paramtype tags: JSON
        :keyword properties: Specifies the job properties.
        :paramtype properties: ~azure.mgmt.storageimportexport.models.JobDetails
        :keyword identity: Specifies the job identity details.
        :paramtype identity: ~azure.mgmt.storageimportexport.models.IdentityDetails
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.properties = properties
        self.identity = identity


class ListJobsResponse(_serialization.Model):
    """List jobs response.

    :ivar next_link: link to next batch of jobs.
    :vartype next_link: str
    :ivar value: Job list.
    :vartype value: list[~azure.mgmt.storageimportexport.models.JobResponse]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[JobResponse]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.JobResponse"]] = None, **kwargs
    ):
        """
        :keyword next_link: link to next batch of jobs.
        :paramtype next_link: str
        :keyword value: Job list.
        :paramtype value: list[~azure.mgmt.storageimportexport.models.JobResponse]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ListOperationsResponse(_serialization.Model):
    """List operations response.

    :ivar value: operations.
    :vartype value: list[~azure.mgmt.storageimportexport.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: operations.
        :paramtype value: list[~azure.mgmt.storageimportexport.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class Location(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Provides information about an Azure data center location.

    :ivar id: Specifies the resource identifier of the location.
    :vartype id: str
    :ivar name: Specifies the name of the location. Use List Locations to get all supported
     locations.
    :vartype name: str
    :ivar type: Specifies the type of the location.
    :vartype type: str
    :ivar recipient_name: The recipient name to use when shipping the drives to the Azure data
     center.
    :vartype recipient_name: str
    :ivar street_address1: The first line of the street address to use when shipping the drives to
     the Azure data center.
    :vartype street_address1: str
    :ivar street_address2: The second line of the street address to use when shipping the drives to
     the Azure data center.
    :vartype street_address2: str
    :ivar city: The city name to use when shipping the drives to the Azure data center.
    :vartype city: str
    :ivar state_or_province: The state or province to use when shipping the drives to the Azure
     data center.
    :vartype state_or_province: str
    :ivar postal_code: The postal code to use when shipping the drives to the Azure data center.
    :vartype postal_code: str
    :ivar country_or_region: The country or region to use when shipping the drives to the Azure
     data center.
    :vartype country_or_region: str
    :ivar phone: The phone number for the Azure data center.
    :vartype phone: str
    :ivar additional_shipping_information: Additional shipping information for customer, specific
     to datacenter to which customer should send their disks.
    :vartype additional_shipping_information: str
    :ivar supported_carriers: A list of carriers that are supported at this location.
    :vartype supported_carriers: list[str]
    :ivar alternate_locations: A list of location IDs that should be used to ship shipping drives
     to for jobs created against the current location. If the current location is active, it will be
     part of the list. If it is temporarily closed due to maintenance, this list may contain other
     locations.
    :vartype alternate_locations: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "recipient_name": {"key": "properties.recipientName", "type": "str"},
        "street_address1": {"key": "properties.streetAddress1", "type": "str"},
        "street_address2": {"key": "properties.streetAddress2", "type": "str"},
        "city": {"key": "properties.city", "type": "str"},
        "state_or_province": {"key": "properties.stateOrProvince", "type": "str"},
        "postal_code": {"key": "properties.postalCode", "type": "str"},
        "country_or_region": {"key": "properties.countryOrRegion", "type": "str"},
        "phone": {"key": "properties.phone", "type": "str"},
        "additional_shipping_information": {"key": "properties.additionalShippingInformation", "type": "str"},
        "supported_carriers": {"key": "properties.supportedCarriers", "type": "[str]"},
        "alternate_locations": {"key": "properties.alternateLocations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        recipient_name: Optional[str] = None,
        street_address1: Optional[str] = None,
        street_address2: Optional[str] = None,
        city: Optional[str] = None,
        state_or_province: Optional[str] = None,
        postal_code: Optional[str] = None,
        country_or_region: Optional[str] = None,
        phone: Optional[str] = None,
        additional_shipping_information: Optional[str] = None,
        supported_carriers: Optional[List[str]] = None,
        alternate_locations: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Specifies the resource identifier of the location.
        :paramtype id: str
        :keyword name: Specifies the name of the location. Use List Locations to get all supported
         locations.
        :paramtype name: str
        :keyword type: Specifies the type of the location.
        :paramtype type: str
        :keyword recipient_name: The recipient name to use when shipping the drives to the Azure data
         center.
        :paramtype recipient_name: str
        :keyword street_address1: The first line of the street address to use when shipping the drives
         to the Azure data center.
        :paramtype street_address1: str
        :keyword street_address2: The second line of the street address to use when shipping the drives
         to the Azure data center.
        :paramtype street_address2: str
        :keyword city: The city name to use when shipping the drives to the Azure data center.
        :paramtype city: str
        :keyword state_or_province: The state or province to use when shipping the drives to the Azure
         data center.
        :paramtype state_or_province: str
        :keyword postal_code: The postal code to use when shipping the drives to the Azure data center.
        :paramtype postal_code: str
        :keyword country_or_region: The country or region to use when shipping the drives to the Azure
         data center.
        :paramtype country_or_region: str
        :keyword phone: The phone number for the Azure data center.
        :paramtype phone: str
        :keyword additional_shipping_information: Additional shipping information for customer,
         specific to datacenter to which customer should send their disks.
        :paramtype additional_shipping_information: str
        :keyword supported_carriers: A list of carriers that are supported at this location.
        :paramtype supported_carriers: list[str]
        :keyword alternate_locations: A list of location IDs that should be used to ship shipping
         drives to for jobs created against the current location. If the current location is active, it
         will be part of the list. If it is temporarily closed due to maintenance, this list may contain
         other locations.
        :paramtype alternate_locations: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.recipient_name = recipient_name
        self.street_address1 = street_address1
        self.street_address2 = street_address2
        self.city = city
        self.state_or_province = state_or_province
        self.postal_code = postal_code
        self.country_or_region = country_or_region
        self.phone = phone
        self.additional_shipping_information = additional_shipping_information
        self.supported_carriers = supported_carriers
        self.alternate_locations = alternate_locations


class LocationsResponse(_serialization.Model):
    """Locations response.

    :ivar value: locations.
    :vartype value: list[~azure.mgmt.storageimportexport.models.Location]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Location]"},
    }

    def __init__(self, *, value: Optional[List["_models.Location"]] = None, **kwargs):
        """
        :keyword value: locations.
        :paramtype value: list[~azure.mgmt.storageimportexport.models.Location]
        """
        super().__init__(**kwargs)
        self.value = value


class Operation(_serialization.Model):
    """Describes a supported operation by the Storage Import/Export job API.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the operation. Required.
    :vartype name: str
    :ivar provider: The resource provider name to which the operation belongs.
    :vartype provider: str
    :ivar resource: The name of the resource to which the operation belongs.
    :vartype resource: str
    :ivar operation: The display name of the operation.
    :vartype operation: str
    :ivar description: Short description of the operation.
    :vartype description: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "provider": {"key": "display.provider", "type": "str"},
        "resource": {"key": "display.resource", "type": "str"},
        "operation": {"key": "display.operation", "type": "str"},
        "description": {"key": "display.description", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the operation. Required.
        :paramtype name: str
        :keyword provider: The resource provider name to which the operation belongs.
        :paramtype provider: str
        :keyword resource: The name of the resource to which the operation belongs.
        :paramtype resource: str
        :keyword operation: The display name of the operation.
        :paramtype operation: str
        :keyword description: Short description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class PackageInformation(_serialization.Model):
    """Contains information about the package being shipped by the customer to the Microsoft data center.

    All required parameters must be populated in order to send to Azure.

    :ivar carrier_name: The name of the carrier that is used to ship the import or export drives.
     Required.
    :vartype carrier_name: str
    :ivar tracking_number: The tracking number of the package. Required.
    :vartype tracking_number: str
    :ivar drive_count: The number of drives included in the package. Required.
    :vartype drive_count: int
    :ivar ship_date: The date when the package is shipped. Required.
    :vartype ship_date: str
    """

    _validation = {
        "carrier_name": {"required": True},
        "tracking_number": {"required": True},
        "drive_count": {"required": True},
        "ship_date": {"required": True},
    }

    _attribute_map = {
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_number": {"key": "trackingNumber", "type": "str"},
        "drive_count": {"key": "driveCount", "type": "int"},
        "ship_date": {"key": "shipDate", "type": "str"},
    }

    def __init__(self, *, carrier_name: str, tracking_number: str, drive_count: int, ship_date: str, **kwargs):
        """
        :keyword carrier_name: The name of the carrier that is used to ship the import or export
         drives. Required.
        :paramtype carrier_name: str
        :keyword tracking_number: The tracking number of the package. Required.
        :paramtype tracking_number: str
        :keyword drive_count: The number of drives included in the package. Required.
        :paramtype drive_count: int
        :keyword ship_date: The date when the package is shipped. Required.
        :paramtype ship_date: str
        """
        super().__init__(**kwargs)
        self.carrier_name = carrier_name
        self.tracking_number = tracking_number
        self.drive_count = drive_count
        self.ship_date = ship_date


class PutJobParameters(_serialization.Model):
    """Put Job parameters.

    :ivar location: Specifies the supported Azure location where the job should be created.
    :vartype location: str
    :ivar tags: Specifies the tags that will be assigned to the job.
    :vartype tags: JSON
    :ivar properties: Specifies the job properties.
    :vartype properties: ~azure.mgmt.storageimportexport.models.JobDetails
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "object"},
        "properties": {"key": "properties", "type": "JobDetails"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[JSON] = None,
        properties: Optional["_models.JobDetails"] = None,
        **kwargs
    ):
        """
        :keyword location: Specifies the supported Azure location where the job should be created.
        :paramtype location: str
        :keyword tags: Specifies the tags that will be assigned to the job.
        :paramtype tags: JSON
        :keyword properties: Specifies the job properties.
        :paramtype properties: ~azure.mgmt.storageimportexport.models.JobDetails
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class ReturnAddress(_serialization.Model):
    """Specifies the return address information for the job.

    All required parameters must be populated in order to send to Azure.

    :ivar recipient_name: The name of the recipient who will receive the hard drives when they are
     returned. Required.
    :vartype recipient_name: str
    :ivar street_address1: The first line of the street address to use when returning the drives.
     Required.
    :vartype street_address1: str
    :ivar street_address2: The second line of the street address to use when returning the drives.
    :vartype street_address2: str
    :ivar city: The city name to use when returning the drives. Required.
    :vartype city: str
    :ivar state_or_province: The state or province to use when returning the drives.
    :vartype state_or_province: str
    :ivar postal_code: The postal code to use when returning the drives. Required.
    :vartype postal_code: str
    :ivar country_or_region: The country or region to use when returning the drives. Required.
    :vartype country_or_region: str
    :ivar phone: Phone number of the recipient of the returned drives. Required.
    :vartype phone: str
    :ivar email: Email address of the recipient of the returned drives. Required.
    :vartype email: str
    """

    _validation = {
        "recipient_name": {"required": True},
        "street_address1": {"required": True},
        "city": {"required": True},
        "postal_code": {"required": True},
        "country_or_region": {"required": True},
        "phone": {"required": True},
        "email": {"required": True},
    }

    _attribute_map = {
        "recipient_name": {"key": "recipientName", "type": "str"},
        "street_address1": {"key": "streetAddress1", "type": "str"},
        "street_address2": {"key": "streetAddress2", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state_or_province": {"key": "stateOrProvince", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "country_or_region": {"key": "countryOrRegion", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(
        self,
        *,
        recipient_name: str,
        street_address1: str,
        city: str,
        postal_code: str,
        country_or_region: str,
        phone: str,
        email: str,
        street_address2: Optional[str] = None,
        state_or_province: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recipient_name: The name of the recipient who will receive the hard drives when they
         are returned. Required.
        :paramtype recipient_name: str
        :keyword street_address1: The first line of the street address to use when returning the
         drives. Required.
        :paramtype street_address1: str
        :keyword street_address2: The second line of the street address to use when returning the
         drives.
        :paramtype street_address2: str
        :keyword city: The city name to use when returning the drives. Required.
        :paramtype city: str
        :keyword state_or_province: The state or province to use when returning the drives.
        :paramtype state_or_province: str
        :keyword postal_code: The postal code to use when returning the drives. Required.
        :paramtype postal_code: str
        :keyword country_or_region: The country or region to use when returning the drives. Required.
        :paramtype country_or_region: str
        :keyword phone: Phone number of the recipient of the returned drives. Required.
        :paramtype phone: str
        :keyword email: Email address of the recipient of the returned drives. Required.
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.recipient_name = recipient_name
        self.street_address1 = street_address1
        self.street_address2 = street_address2
        self.city = city
        self.state_or_province = state_or_province
        self.postal_code = postal_code
        self.country_or_region = country_or_region
        self.phone = phone
        self.email = email


class ReturnShipping(_serialization.Model):
    """Specifies the return carrier and customer's account with the carrier.

    All required parameters must be populated in order to send to Azure.

    :ivar carrier_name: The carrier's name. Required.
    :vartype carrier_name: str
    :ivar carrier_account_number: The customer's account number with the carrier. Required.
    :vartype carrier_account_number: str
    """

    _validation = {
        "carrier_name": {"required": True},
        "carrier_account_number": {"required": True},
    }

    _attribute_map = {
        "carrier_name": {"key": "carrierName", "type": "str"},
        "carrier_account_number": {"key": "carrierAccountNumber", "type": "str"},
    }

    def __init__(self, *, carrier_name: str, carrier_account_number: str, **kwargs):
        """
        :keyword carrier_name: The carrier's name. Required.
        :paramtype carrier_name: str
        :keyword carrier_account_number: The customer's account number with the carrier. Required.
        :paramtype carrier_account_number: str
        """
        super().__init__(**kwargs)
        self.carrier_name = carrier_name
        self.carrier_account_number = carrier_account_number


class ShippingInformation(_serialization.Model):
    """Contains information about the Microsoft datacenter to which the drives should be shipped.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recipient_name: The name of the recipient who will receive the hard drives when they are
     returned.
    :vartype recipient_name: str
    :ivar street_address1: The first line of the street address to use when returning the drives.
    :vartype street_address1: str
    :ivar street_address2: The second line of the street address to use when returning the drives.
    :vartype street_address2: str
    :ivar city: The city name to use when returning the drives.
    :vartype city: str
    :ivar state_or_province: The state or province to use when returning the drives.
    :vartype state_or_province: str
    :ivar postal_code: The postal code to use when returning the drives.
    :vartype postal_code: str
    :ivar country_or_region: The country or region to use when returning the drives.
    :vartype country_or_region: str
    :ivar phone: Phone number of the recipient of the returned drives.
    :vartype phone: str
    :ivar additional_information: Additional shipping information for customer, specific to
     datacenter to which customer should send their disks.
    :vartype additional_information: str
    """

    _validation = {
        "additional_information": {"readonly": True},
    }

    _attribute_map = {
        "recipient_name": {"key": "recipientName", "type": "str"},
        "street_address1": {"key": "streetAddress1", "type": "str"},
        "street_address2": {"key": "streetAddress2", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state_or_province": {"key": "stateOrProvince", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "country_or_region": {"key": "countryOrRegion", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "additional_information": {"key": "additionalInformation", "type": "str"},
    }

    def __init__(
        self,
        *,
        recipient_name: Optional[str] = None,
        street_address1: Optional[str] = None,
        street_address2: Optional[str] = None,
        city: Optional[str] = None,
        state_or_province: Optional[str] = None,
        postal_code: Optional[str] = None,
        country_or_region: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword recipient_name: The name of the recipient who will receive the hard drives when they
         are returned.
        :paramtype recipient_name: str
        :keyword street_address1: The first line of the street address to use when returning the
         drives.
        :paramtype street_address1: str
        :keyword street_address2: The second line of the street address to use when returning the
         drives.
        :paramtype street_address2: str
        :keyword city: The city name to use when returning the drives.
        :paramtype city: str
        :keyword state_or_province: The state or province to use when returning the drives.
        :paramtype state_or_province: str
        :keyword postal_code: The postal code to use when returning the drives.
        :paramtype postal_code: str
        :keyword country_or_region: The country or region to use when returning the drives.
        :paramtype country_or_region: str
        :keyword phone: Phone number of the recipient of the returned drives.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.recipient_name = recipient_name
        self.street_address1 = street_address1
        self.street_address2 = street_address2
        self.city = city
        self.state_or_province = state_or_province
        self.postal_code = postal_code
        self.country_or_region = country_or_region
        self.phone = phone
        self.additional_information = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.storageimportexport.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.storageimportexport.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.storageimportexport.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.storageimportexport.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UpdateJobParameters(_serialization.Model):
    """Update Job parameters.

    :ivar tags: Specifies the tags that will be assigned to the job.
    :vartype tags: JSON
    :ivar cancel_requested: If specified, the value must be true. The service will attempt to
     cancel the job.
    :vartype cancel_requested: bool
    :ivar state: If specified, the value must be Shipping, which tells the Import/Export service
     that the package for the job has been shipped. The ReturnAddress and DeliveryPackage properties
     must have been set either in this request or in a previous request, otherwise the request will
     fail.
    :vartype state: str
    :ivar return_address: Specifies the return address information for the job.
    :vartype return_address: ~azure.mgmt.storageimportexport.models.ReturnAddress
    :ivar return_shipping: Specifies the return carrier and customer's account with the carrier.
    :vartype return_shipping: ~azure.mgmt.storageimportexport.models.ReturnShipping
    :ivar delivery_package: Contains information about the package being shipped by the customer to
     the Microsoft data center.
    :vartype delivery_package: ~azure.mgmt.storageimportexport.models.DeliveryPackageInformation
    :ivar log_level: Indicates whether error logging or verbose logging is enabled.
    :vartype log_level: str
    :ivar backup_drive_manifest: Indicates whether the manifest files on the drives should be
     copied to block blobs.
    :vartype backup_drive_manifest: bool
    :ivar drive_list: List of drives that comprise the job.
    :vartype drive_list: list[~azure.mgmt.storageimportexport.models.DriveStatus]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "object"},
        "cancel_requested": {"key": "properties.cancelRequested", "type": "bool"},
        "state": {"key": "properties.state", "type": "str"},
        "return_address": {"key": "properties.returnAddress", "type": "ReturnAddress"},
        "return_shipping": {"key": "properties.returnShipping", "type": "ReturnShipping"},
        "delivery_package": {"key": "properties.deliveryPackage", "type": "DeliveryPackageInformation"},
        "log_level": {"key": "properties.logLevel", "type": "str"},
        "backup_drive_manifest": {"key": "properties.backupDriveManifest", "type": "bool"},
        "drive_list": {"key": "properties.driveList", "type": "[DriveStatus]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[JSON] = None,
        cancel_requested: bool = False,
        state: Optional[str] = None,
        return_address: Optional["_models.ReturnAddress"] = None,
        return_shipping: Optional["_models.ReturnShipping"] = None,
        delivery_package: Optional["_models.DeliveryPackageInformation"] = None,
        log_level: Optional[str] = None,
        backup_drive_manifest: bool = False,
        drive_list: Optional[List["_models.DriveStatus"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Specifies the tags that will be assigned to the job.
        :paramtype tags: JSON
        :keyword cancel_requested: If specified, the value must be true. The service will attempt to
         cancel the job.
        :paramtype cancel_requested: bool
        :keyword state: If specified, the value must be Shipping, which tells the Import/Export service
         that the package for the job has been shipped. The ReturnAddress and DeliveryPackage properties
         must have been set either in this request or in a previous request, otherwise the request will
         fail.
        :paramtype state: str
        :keyword return_address: Specifies the return address information for the job.
        :paramtype return_address: ~azure.mgmt.storageimportexport.models.ReturnAddress
        :keyword return_shipping: Specifies the return carrier and customer's account with the carrier.
        :paramtype return_shipping: ~azure.mgmt.storageimportexport.models.ReturnShipping
        :keyword delivery_package: Contains information about the package being shipped by the customer
         to the Microsoft data center.
        :paramtype delivery_package: ~azure.mgmt.storageimportexport.models.DeliveryPackageInformation
        :keyword log_level: Indicates whether error logging or verbose logging is enabled.
        :paramtype log_level: str
        :keyword backup_drive_manifest: Indicates whether the manifest files on the drives should be
         copied to block blobs.
        :paramtype backup_drive_manifest: bool
        :keyword drive_list: List of drives that comprise the job.
        :paramtype drive_list: list[~azure.mgmt.storageimportexport.models.DriveStatus]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.cancel_requested = cancel_requested
        self.state = state
        self.return_address = return_address
        self.return_shipping = return_shipping
        self.delivery_package = delivery_package
        self.log_level = log_level
        self.backup_drive_manifest = backup_drive_manifest
        self.drive_list = drive_list
