#!/bin/bash

FAIL=
TOPDIR=`pwd`
TMPCHECK=${TOPDIR}/tmpcheck

if [ -d ${TMPCHECK} ]; then
    rm -rf ${TMPCHECK}/*
else
    mkdir ${TMPCHECK}
fi

cd test

for t in `ls test*`; do
    #cd ${TMPCHECK}
    echo -n "Running test ${t}... "
    python3 ${t}
    if [ "$?" -ne 0 ]; then
       FAIL=1
       echo "FAILED"
       echo "LOG:"
       tail -100 ${LOGFILE}
    else
       echo "OK"
    fi
done

cd ${TOPDIR}

if [ -z "$FAIL" ]; then
    rm -rf tmpcheck
    echo "All tests passed"
    exit 0
else
    echo "Some tests failed"
    exit 1
fi
