// SPDX-License-Identifier: MIT
/*
 * Copyright (C) 2021 Advanced Micro Devices, Inc.
 *
 * Authors: AMD
 */

#ifndef _dcn_3_0_3_OFFSET_HEADER
#define _dcn_3_0_3_OFFSET_HEADER

// addressBlock: dce_dc_mmhubbub_vga_dispdec
// base address: 0x0
#define mmVGA_MEM_WRITE_PAGE_ADDR                                                                      0x0000
#define mmVGA_MEM_WRITE_PAGE_ADDR_BASE_IDX                                                             0
#define mmVGA_MEM_READ_PAGE_ADDR                                                                       0x0001
#define mmVGA_MEM_READ_PAGE_ADDR_BASE_IDX                                                              0
#define mmVGA_RENDER_CONTROL                                                                           0x0000
#define mmVGA_RENDER_CONTROL_BASE_IDX                                                                  1
#define mmVGA_SEQUENCER_RESET_CONTROL                                                                  0x0001
#define mmVGA_SEQUENCER_RESET_CONTROL_BASE_IDX                                                         1
#define mmVGA_MODE_CONTROL                                                                             0x0002
#define mmVGA_MODE_CONTROL_BASE_IDX                                                                    1
#define mmVGA_SURFACE_PITCH_SELECT                                                                     0x0003
#define mmVGA_SURFACE_PITCH_SELECT_BASE_IDX                                                            1
#define mmVGA_MEMORY_BASE_ADDRESS                                                                      0x0004
#define mmVGA_MEMORY_BASE_ADDRESS_BASE_IDX                                                             1
#define mmVGA_DISPBUF1_SURFACE_ADDR                                                                    0x0006
#define mmVGA_DISPBUF1_SURFACE_ADDR_BASE_IDX                                                           1
#define mmVGA_DISPBUF2_SURFACE_ADDR                                                                    0x0008
#define mmVGA_DISPBUF2_SURFACE_ADDR_BASE_IDX                                                           1
#define mmVGA_MEMORY_BASE_ADDRESS_HIGH                                                                 0x0009
#define mmVGA_MEMORY_BASE_ADDRESS_HIGH_BASE_IDX                                                        1
#define mmVGA_HDP_CONTROL                                                                              0x000a
#define mmVGA_HDP_CONTROL_BASE_IDX                                                                     1
#define mmVGA_CACHE_CONTROL                                                                            0x000b
#define mmVGA_CACHE_CONTROL_BASE_IDX                                                                   1
#define mmD1VGA_CONTROL                                                                                0x000c
#define mmD1VGA_CONTROL_BASE_IDX                                                                       1
#define mmD2VGA_CONTROL                                                                                0x000e
#define mmD2VGA_CONTROL_BASE_IDX                                                                       1
#define mmVGA_STATUS                                                                                   0x0010
#define mmVGA_STATUS_BASE_IDX                                                                          1
#define mmVGA_INTERRUPT_CONTROL                                                                        0x0011
#define mmVGA_INTERRUPT_CONTROL_BASE_IDX                                                               1
#define mmVGA_STATUS_CLEAR                                                                             0x0012
#define mmVGA_STATUS_CLEAR_BASE_IDX                                                                    1
#define mmVGA_INTERRUPT_STATUS                                                                         0x0013
#define mmVGA_INTERRUPT_STATUS_BASE_IDX                                                                1
#define mmVGA_MAIN_CONTROL                                                                             0x0014
#define mmVGA_MAIN_CONTROL_BASE_IDX                                                                    1
#define mmVGA_TEST_CONTROL                                                                             0x0015
#define mmVGA_TEST_CONTROL_BASE_IDX                                                                    1
#define mmVGA_QOS_CTRL                                                                                 0x0018
#define mmVGA_QOS_CTRL_BASE_IDX                                                                        1
#define mmCRTC8_IDX                                                                                    0x002d
#define mmCRTC8_IDX_BASE_IDX                                                                           1
#define mmCRTC8_DATA                                                                                   0x002d
#define mmCRTC8_DATA_BASE_IDX                                                                          1
#define mmGENFC_WT                                                                                     0x002e
#define mmGENFC_WT_BASE_IDX                                                                            1
#define mmGENS1                                                                                        0x002e
#define mmGENS1_BASE_IDX                                                                               1
#define mmATTRDW                                                                                       0x0030
#define mmATTRDW_BASE_IDX                                                                              1
#define mmATTRX                                                                                        0x0030
#define mmATTRX_BASE_IDX                                                                               1
#define mmATTRDR                                                                                       0x0030
#define mmATTRDR_BASE_IDX                                                                              1
#define mmGENMO_WT                                                                                     0x0030
#define mmGENMO_WT_BASE_IDX                                                                            1
#define mmGENS0                                                                                        0x0030
#define mmGENS0_BASE_IDX                                                                               1
#define mmGENENB                                                                                       0x0030
#define mmGENENB_BASE_IDX                                                                              1
#define mmSEQ8_IDX                                                                                     0x0031
#define mmSEQ8_IDX_BASE_IDX                                                                            1
#define mmSEQ8_DATA                                                                                    0x0031
#define mmSEQ8_DATA_BASE_IDX                                                                           1
#define mmDAC_MASK                                                                                     0x0031
#define mmDAC_MASK_BASE_IDX                                                                            1
#define mmDAC_R_INDEX                                                                                  0x0031
#define mmDAC_R_INDEX_BASE_IDX                                                                         1
#define mmDAC_W_INDEX                                                                                  0x0032
#define mmDAC_W_INDEX_BASE_IDX                                                                         1
#define mmDAC_DATA                                                                                     0x0032
#define mmDAC_DATA_BASE_IDX                                                                            1
#define mmGENFC_RD                                                                                     0x0032
#define mmGENFC_RD_BASE_IDX                                                                            1
#define mmGENMO_RD                                                                                     0x0033
#define mmGENMO_RD_BASE_IDX                                                                            1
#define mmGRPH8_IDX                                                                                    0x0033
#define mmGRPH8_IDX_BASE_IDX                                                                           1
#define mmGRPH8_DATA                                                                                   0x0033
#define mmGRPH8_DATA_BASE_IDX                                                                          1
#define mmCRTC8_IDX_1                                                                                  0x0035
#define mmCRTC8_IDX_1_BASE_IDX                                                                         1
#define mmCRTC8_DATA_1                                                                                 0x0035
#define mmCRTC8_DATA_1_BASE_IDX                                                                        1
#define mmGENFC_WT_1                                                                                   0x0036
#define mmGENFC_WT_1_BASE_IDX                                                                          1
#define mmGENS1_1                                                                                      0x0036
#define mmGENS1_1_BASE_IDX                                                                             1
#define mmD3VGA_CONTROL                                                                                0x0038
#define mmD3VGA_CONTROL_BASE_IDX                                                                       1
#define mmD4VGA_CONTROL                                                                                0x0039
#define mmD4VGA_CONTROL_BASE_IDX                                                                       1
#define mmD5VGA_CONTROL                                                                                0x003a
#define mmD5VGA_CONTROL_BASE_IDX                                                                       1
#define mmD6VGA_CONTROL                                                                                0x003b
#define mmD6VGA_CONTROL_BASE_IDX                                                                       1
#define mmVGA_SOURCE_SELECT                                                                            0x003c
#define mmVGA_SOURCE_SELECT_BASE_IDX                                                                   1


// addressBlock: dce_dc_dccg_dccg_dispdec
// base address: 0x0
#define mmPHYPLLA_PIXCLK_RESYNC_CNTL                                                                   0x0040
#define mmPHYPLLA_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmPHYPLLB_PIXCLK_RESYNC_CNTL                                                                   0x0041
#define mmPHYPLLB_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmDP_DTO_DBUF_EN                                                                               0x0044
#define mmDP_DTO_DBUF_EN_BASE_IDX                                                                      1
#define mmDPREFCLK_CGTT_BLK_CTRL_REG                                                                   0x0048
#define mmDPREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                          1
#define mmREFCLK_CNTL                                                                                  0x0049
#define mmREFCLK_CNTL_BASE_IDX                                                                         1
#define mmREFCLK_CGTT_BLK_CTRL_REG                                                                     0x004b
#define mmREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDCCG_PERFMON_CNTL2                                                                           0x004e
#define mmDCCG_PERFMON_CNTL2_BASE_IDX                                                                  1
#define mmDCCG_DS_DTO_INCR                                                                             0x0053
#define mmDCCG_DS_DTO_INCR_BASE_IDX                                                                    1
#define mmDCCG_DS_DTO_MODULO                                                                           0x0054
#define mmDCCG_DS_DTO_MODULO_BASE_IDX                                                                  1
#define mmDCCG_DS_CNTL                                                                                 0x0055
#define mmDCCG_DS_CNTL_BASE_IDX                                                                        1
#define mmDCCG_DS_HW_CAL_INTERVAL                                                                      0x0056
#define mmDCCG_DS_HW_CAL_INTERVAL_BASE_IDX                                                             1
#define mmDPREFCLK_CNTL                                                                                0x0058
#define mmDPREFCLK_CNTL_BASE_IDX                                                                       1
#define mmDCE_VERSION                                                                                  0x005e
#define mmDCE_VERSION_BASE_IDX                                                                         1
#define mmDCCG_GTC_CNTL                                                                                0x0060
#define mmDCCG_GTC_CNTL_BASE_IDX                                                                       1
#define mmDCCG_GTC_DTO_INCR                                                                            0x0061
#define mmDCCG_GTC_DTO_INCR_BASE_IDX                                                                   1
#define mmDCCG_GTC_DTO_MODULO                                                                          0x0062
#define mmDCCG_GTC_DTO_MODULO_BASE_IDX                                                                 1
#define mmDCCG_GTC_CURRENT                                                                             0x0063
#define mmDCCG_GTC_CURRENT_BASE_IDX                                                                    1
#define mmDSCCLK0_DTO_PARAM                                                                            0x006c
#define mmDSCCLK0_DTO_PARAM_BASE_IDX                                                                   1
#define mmDSCCLK1_DTO_PARAM                                                                            0x006d
#define mmDSCCLK1_DTO_PARAM_BASE_IDX                                                                   1
#define mmMILLISECOND_TIME_BASE_DIV                                                                    0x0070
#define mmMILLISECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define mmDISPCLK_FREQ_CHANGE_CNTL                                                                     0x0071
#define mmDISPCLK_FREQ_CHANGE_CNTL_BASE_IDX                                                            1
#define mmDC_MEM_GLOBAL_PWR_REQ_CNTL                                                                   0x0072
#define mmDC_MEM_GLOBAL_PWR_REQ_CNTL_BASE_IDX                                                          1
#define mmDCCG_PERFMON_CNTL                                                                            0x0073
#define mmDCCG_PERFMON_CNTL_BASE_IDX                                                                   1
#define mmDCCG_GATE_DISABLE_CNTL                                                                       0x0074
#define mmDCCG_GATE_DISABLE_CNTL_BASE_IDX                                                              1
#define mmDISPCLK_CGTT_BLK_CTRL_REG                                                                    0x0075
#define mmDISPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                           1
#define mmSOCCLK_CGTT_BLK_CTRL_REG                                                                     0x0076
#define mmSOCCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDCCG_CAC_STATUS                                                                              0x0077
#define mmDCCG_CAC_STATUS_BASE_IDX                                                                     1
#define mmMICROSECOND_TIME_BASE_DIV                                                                    0x007b
#define mmMICROSECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define mmDCCG_GATE_DISABLE_CNTL2                                                                      0x007c
#define mmDCCG_GATE_DISABLE_CNTL2_BASE_IDX                                                             1
#define mmSYMCLK_CGTT_BLK_CTRL_REG                                                                     0x007d
#define mmSYMCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDCCG_DISP_CNTL_REG                                                                           0x007f
#define mmDCCG_DISP_CNTL_REG_BASE_IDX                                                                  1
#define mmOTG0_PIXEL_RATE_CNTL                                                                         0x0080
#define mmOTG0_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define mmDP_DTO0_PHASE                                                                                0x0081
#define mmDP_DTO0_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO0_MODULO                                                                               0x0082
#define mmDP_DTO0_MODULO_BASE_IDX                                                                      1
#define mmOTG0_PHYPLL_PIXEL_RATE_CNTL                                                                  0x0083
#define mmOTG0_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmOTG1_PIXEL_RATE_CNTL                                                                         0x0084
#define mmOTG1_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define mmDP_DTO1_PHASE                                                                                0x0085
#define mmDP_DTO1_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO1_MODULO                                                                               0x0086
#define mmDP_DTO1_MODULO_BASE_IDX                                                                      1
#define mmOTG1_PHYPLL_PIXEL_RATE_CNTL                                                                  0x0087
#define mmOTG1_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmDPPCLK_CGTT_BLK_CTRL_REG                                                                     0x0098
#define mmDPPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDPPCLK0_DTO_PARAM                                                                            0x0099
#define mmDPPCLK0_DTO_PARAM_BASE_IDX                                                                   1
#define mmDPPCLK1_DTO_PARAM                                                                            0x009a
#define mmDPPCLK1_DTO_PARAM_BASE_IDX                                                                   1
#define mmDCCG_CAC_STATUS2                                                                             0x009f
#define mmDCCG_CAC_STATUS2_BASE_IDX                                                                    1
#define mmSYMCLKA_CLOCK_ENABLE                                                                         0x00a0
#define mmSYMCLKA_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKB_CLOCK_ENABLE                                                                         0x00a1
#define mmSYMCLKB_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmDCCG_SOFT_RESET                                                                              0x00a6
#define mmDCCG_SOFT_RESET_BASE_IDX                                                                     1
#define mmDSCCLK_DTO_CTRL                                                                              0x00a7
#define mmDSCCLK_DTO_CTRL_BASE_IDX                                                                     1
#define mmDCCG_AUDIO_DTO_SOURCE                                                                        0x00ab
#define mmDCCG_AUDIO_DTO_SOURCE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO0_PHASE                                                                        0x00ac
#define mmDCCG_AUDIO_DTO0_PHASE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO0_MODULE                                                                       0x00ad
#define mmDCCG_AUDIO_DTO0_MODULE_BASE_IDX                                                              1
#define mmDCCG_AUDIO_DTO1_PHASE                                                                        0x00ae
#define mmDCCG_AUDIO_DTO1_PHASE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO1_MODULE                                                                       0x00af
#define mmDCCG_AUDIO_DTO1_MODULE_BASE_IDX                                                              1
#define mmDCCG_VSYNC_OTG0_LATCH_VALUE                                                                  0x00b0
#define mmDCCG_VSYNC_OTG0_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG1_LATCH_VALUE                                                                  0x00b1
#define mmDCCG_VSYNC_OTG1_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG2_LATCH_VALUE                                                                  0x00b2
#define mmDCCG_VSYNC_OTG2_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG3_LATCH_VALUE                                                                  0x00b3
#define mmDCCG_VSYNC_OTG3_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG4_LATCH_VALUE                                                                  0x00b4
#define mmDCCG_VSYNC_OTG4_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG5_LATCH_VALUE                                                                  0x00b5
#define mmDCCG_VSYNC_OTG5_LATCH_VALUE_BASE_IDX                                                         1
#define mmDPPCLK_DTO_CTRL                                                                              0x00b6
#define mmDPPCLK_DTO_CTRL_BASE_IDX                                                                     1
#define mmDCCG_VSYNC_CNT_CTRL                                                                          0x00b8
#define mmDCCG_VSYNC_CNT_CTRL_BASE_IDX                                                                 1
#define mmDCCG_VSYNC_CNT_INT_CTRL                                                                      0x00b9
#define mmDCCG_VSYNC_CNT_INT_CTRL_BASE_IDX                                                             1
#define mmFORCE_SYMCLK_DISABLE                                                                         0x00ba
#define mmFORCE_SYMCLK_DISABLE_BASE_IDX                                                                1
#define mmPHYASYMCLK_CLOCK_CNTL                                                                        0x0052
#define mmPHYASYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define mmPHYBSYMCLK_CLOCK_CNTL                                                                        0x0053
#define mmPHYBSYMCLK_CLOCK_CNTL_BASE_IDX                                                               2


// addressBlock: dce_dc_dccg_dccg_dfs_dispdec
// base address: 0x0
#define mmDENTIST_DISPCLK_CNTL                                                                         0x0064
#define mmDENTIST_DISPCLK_CNTL_BASE_IDX                                                                1


// addressBlock: dce_dc_dccg_dccg_dcperfmon0_dc_perfmon_dispdec
// base address: 0x0
#define mmDC_PERFMON0_PERFCOUNTER_CNTL                                                                 0x0000
#define mmDC_PERFMON0_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON0_PERFCOUNTER_CNTL2                                                                0x0001
#define mmDC_PERFMON0_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON0_PERFCOUNTER_STATE                                                                0x0002
#define mmDC_PERFMON0_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON0_PERFMON_CNTL                                                                     0x0003
#define mmDC_PERFMON0_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON0_PERFMON_CNTL2                                                                    0x0004
#define mmDC_PERFMON0_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC                                                          0x0005
#define mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON0_PERFMON_CVALUE_LOW                                                               0x0006
#define mmDC_PERFMON0_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON0_PERFMON_HI                                                                       0x0007
#define mmDC_PERFMON0_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON0_PERFMON_LOW                                                                      0x0008
#define mmDC_PERFMON0_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dmu_dcperfmon_dc_perfmon_dispdec
// base address: 0x2f8
#define mmDC_PERFMON1_PERFCOUNTER_CNTL                                                                 0x00be
#define mmDC_PERFMON1_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON1_PERFCOUNTER_CNTL2                                                                0x00bf
#define mmDC_PERFMON1_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON1_PERFCOUNTER_STATE                                                                0x00c0
#define mmDC_PERFMON1_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON1_PERFMON_CNTL                                                                     0x00c1
#define mmDC_PERFMON1_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON1_PERFMON_CNTL2                                                                    0x00c2
#define mmDC_PERFMON1_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC                                                          0x00c3
#define mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON1_PERFMON_CVALUE_LOW                                                               0x00c4
#define mmDC_PERFMON1_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON1_PERFMON_HI                                                                       0x00c5
#define mmDC_PERFMON1_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON1_PERFMON_LOW                                                                      0x00c6
#define mmDC_PERFMON1_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dmu_misc_dispdec
// base address: 0x0
#define mmCC_DC_PIPE_DIS                                                                               0x00ca
#define mmCC_DC_PIPE_DIS_BASE_IDX                                                                      2
#define mmDMU_CLK_CNTL                                                                                 0x00cb
#define mmDMU_CLK_CNTL_BASE_IDX                                                                        2
#define mmDMU_MEM_PWR_CNTL                                                                             0x00cc
#define mmDMU_MEM_PWR_CNTL_BASE_IDX                                                                    2
#define mmDMCU_SMU_INTERRUPT_CNTL                                                                      0x00cd
#define mmDMCU_SMU_INTERRUPT_CNTL_BASE_IDX                                                             2
#define mmSMU_INTERRUPT_CONTROL                                                                        0x00ce
#define mmSMU_INTERRUPT_CONTROL_BASE_IDX                                                               2
#define mmDMU_MISC_ALLOW_DS_FORCE                                                                      0x00d6
#define mmDMU_MISC_ALLOW_DS_FORCE_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dmcu_dispdec
// base address: 0x0
#define mmDMCU_CTRL                                                                                    0x00da
#define mmDMCU_CTRL_BASE_IDX                                                                           2
#define mmDMCU_STATUS                                                                                  0x00db
#define mmDMCU_STATUS_BASE_IDX                                                                         2
#define mmDMCU_PC_START_ADDR                                                                           0x00dc
#define mmDMCU_PC_START_ADDR_BASE_IDX                                                                  2
#define mmDMCU_FW_START_ADDR                                                                           0x00dd
#define mmDMCU_FW_START_ADDR_BASE_IDX                                                                  2
#define mmDMCU_FW_END_ADDR                                                                             0x00de
#define mmDMCU_FW_END_ADDR_BASE_IDX                                                                    2
#define mmDMCU_FW_ISR_START_ADDR                                                                       0x00df
#define mmDMCU_FW_ISR_START_ADDR_BASE_IDX                                                              2
#define mmDMCU_FW_CS_HI                                                                                0x00e0
#define mmDMCU_FW_CS_HI_BASE_IDX                                                                       2
#define mmDMCU_FW_CS_LO                                                                                0x00e1
#define mmDMCU_FW_CS_LO_BASE_IDX                                                                       2
#define mmDMCU_RAM_ACCESS_CTRL                                                                         0x00e2
#define mmDMCU_RAM_ACCESS_CTRL_BASE_IDX                                                                2
#define mmDMCU_ERAM_WR_CTRL                                                                            0x00e3
#define mmDMCU_ERAM_WR_CTRL_BASE_IDX                                                                   2
#define mmDMCU_ERAM_WR_DATA                                                                            0x00e4
#define mmDMCU_ERAM_WR_DATA_BASE_IDX                                                                   2
#define mmDMCU_ERAM_RD_CTRL                                                                            0x00e5
#define mmDMCU_ERAM_RD_CTRL_BASE_IDX                                                                   2
#define mmDMCU_ERAM_RD_DATA                                                                            0x00e6
#define mmDMCU_ERAM_RD_DATA_BASE_IDX                                                                   2
#define mmDMCU_IRAM_WR_CTRL                                                                            0x00e7
#define mmDMCU_IRAM_WR_CTRL_BASE_IDX                                                                   2
#define mmDMCU_IRAM_WR_DATA                                                                            0x00e8
#define mmDMCU_IRAM_WR_DATA_BASE_IDX                                                                   2
#define mmDMCU_IRAM_RD_CTRL                                                                            0x00e9
#define mmDMCU_IRAM_RD_CTRL_BASE_IDX                                                                   2
#define mmDMCU_IRAM_RD_DATA                                                                            0x00ea
#define mmDMCU_IRAM_RD_DATA_BASE_IDX                                                                   2
#define mmDMCU_EVENT_TRIGGER                                                                           0x00eb
#define mmDMCU_EVENT_TRIGGER_BASE_IDX                                                                  2
#define mmDMCU_UC_INTERNAL_INT_STATUS                                                                  0x00ec
#define mmDMCU_UC_INTERNAL_INT_STATUS_BASE_IDX                                                         2
#define mmDMCU_SS_INTERRUPT_CNTL_STATUS                                                                0x00ed
#define mmDMCU_SS_INTERRUPT_CNTL_STATUS_BASE_IDX                                                       2
#define mmDMCU_INTERRUPT_STATUS                                                                        0x00ee
#define mmDMCU_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDMCU_INTERRUPT_STATUS_1                                                                      0x00ef
#define mmDMCU_INTERRUPT_STATUS_1_BASE_IDX                                                             2
#define mmDMCU_INTERRUPT_TO_HOST_EN_MASK                                                               0x00f0
#define mmDMCU_INTERRUPT_TO_HOST_EN_MASK_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK                                                                 0x00f1
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_BASE_IDX                                                        2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_1                                                               0x00f2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_1_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL                                                            0x00f3
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_BASE_IDX                                                   2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1                                                          0x00f4
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1_BASE_IDX                                                 2
#define mmDC_DMCU_SCRATCH                                                                              0x00f5
#define mmDC_DMCU_SCRATCH_BASE_IDX                                                                     2
#define mmDMCU_INT_CNT                                                                                 0x00f6
#define mmDMCU_INT_CNT_BASE_IDX                                                                        2
#define mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS                                                               0x00f7
#define mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS_BASE_IDX                                                      2
#define mmDMCU_UC_CLK_GATING_CNTL                                                                      0x00f8
#define mmDMCU_UC_CLK_GATING_CNTL_BASE_IDX                                                             2
#define mmMASTER_COMM_DATA_REG1                                                                        0x00f9
#define mmMASTER_COMM_DATA_REG1_BASE_IDX                                                               2
#define mmMASTER_COMM_DATA_REG2                                                                        0x00fa
#define mmMASTER_COMM_DATA_REG2_BASE_IDX                                                               2
#define mmMASTER_COMM_DATA_REG3                                                                        0x00fb
#define mmMASTER_COMM_DATA_REG3_BASE_IDX                                                               2
#define mmMASTER_COMM_CMD_REG                                                                          0x00fc
#define mmMASTER_COMM_CMD_REG_BASE_IDX                                                                 2
#define mmMASTER_COMM_CNTL_REG                                                                         0x00fd
#define mmMASTER_COMM_CNTL_REG_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG1                                                                         0x00fe
#define mmSLAVE_COMM_DATA_REG1_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG2                                                                         0x00ff
#define mmSLAVE_COMM_DATA_REG2_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG3                                                                         0x0100
#define mmSLAVE_COMM_DATA_REG3_BASE_IDX                                                                2
#define mmSLAVE_COMM_CMD_REG                                                                           0x0101
#define mmSLAVE_COMM_CMD_REG_BASE_IDX                                                                  2
#define mmSLAVE_COMM_CNTL_REG                                                                          0x0102
#define mmSLAVE_COMM_CNTL_REG_BASE_IDX                                                                 2
#define mmDMCU_PERFMON_INTERRUPT_STATUS1                                                               0x0105
#define mmDMCU_PERFMON_INTERRUPT_STATUS1_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS2                                                               0x0106
#define mmDMCU_PERFMON_INTERRUPT_STATUS2_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS3                                                               0x0107
#define mmDMCU_PERFMON_INTERRUPT_STATUS3_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS4                                                               0x0108
#define mmDMCU_PERFMON_INTERRUPT_STATUS4_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS5                                                               0x0109
#define mmDMCU_PERFMON_INTERRUPT_STATUS5_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1                                                        0x010a
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2                                                        0x010b
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3                                                        0x010c
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4                                                        0x010d
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5                                                        0x010e
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1                                                   0x010f
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2                                                   0x0110
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3                                                   0x0111
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4                                                   0x0112
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5                                                   0x0113
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5_BASE_IDX                                          2
#define mmDMCU_DPRX_INTERRUPT_STATUS1                                                                  0x0114
#define mmDMCU_DPRX_INTERRUPT_STATUS1_BASE_IDX                                                         2
#define mmDMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1                                                           0x0115
#define mmDMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1_BASE_IDX                                                  2
#define mmDMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1                                                      0x0116
#define mmDMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1_BASE_IDX                                             2
#define mmDMCU_INTERRUPT_STATUS_CONTINUE                                                               0x0119
#define mmDMCU_INTERRUPT_STATUS_CONTINUE_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE                                                        0x011a
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE_BASE_IDX                                               2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE                                                   0x011b
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE_BASE_IDX                                          2
#define mmDMCU_INT_CNT_CONTINUE                                                                        0x011c
#define mmDMCU_INT_CNT_CONTINUE_BASE_IDX                                                               2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONT2                                                      0x011d
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONT2_BASE_IDX                                             2
#define mmDMCU_INTERRUPT_STATUS_2                                                                      0x011e
#define mmDMCU_INTERRUPT_STATUS_2_BASE_IDX                                                             2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_2                                                               0x011f
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_2_BASE_IDX                                                      2


// addressBlock: dce_dc_dmu_ihc_dispdec
// base address: 0x0
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE                                                         0x0126
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE_BASE_IDX                                                2
#define mmDC_GPU_TIMER_START_POSITION_VSTARTUP                                                         0x0127
#define mmDC_GPU_TIMER_START_POSITION_VSTARTUP_BASE_IDX                                                2
#define mmDC_GPU_TIMER_READ                                                                            0x0128
#define mmDC_GPU_TIMER_READ_BASE_IDX                                                                   2
#define mmDC_GPU_TIMER_READ_CNTL                                                                       0x0129
#define mmDC_GPU_TIMER_READ_CNTL_BASE_IDX                                                              2
#define mmDISP_INTERRUPT_STATUS                                                                        0x012a
#define mmDISP_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDISP_INTERRUPT_STATUS_CONTINUE                                                               0x012b
#define mmDISP_INTERRUPT_STATUS_CONTINUE_BASE_IDX                                                      2
#define mmDISP_INTERRUPT_STATUS_CONTINUE2                                                              0x012c
#define mmDISP_INTERRUPT_STATUS_CONTINUE2_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE3                                                              0x012d
#define mmDISP_INTERRUPT_STATUS_CONTINUE3_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE4                                                              0x012e
#define mmDISP_INTERRUPT_STATUS_CONTINUE4_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE5                                                              0x012f
#define mmDISP_INTERRUPT_STATUS_CONTINUE5_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE6                                                              0x0130
#define mmDISP_INTERRUPT_STATUS_CONTINUE6_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE7                                                              0x0131
#define mmDISP_INTERRUPT_STATUS_CONTINUE7_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE8                                                              0x0132
#define mmDISP_INTERRUPT_STATUS_CONTINUE8_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE9                                                              0x0133
#define mmDISP_INTERRUPT_STATUS_CONTINUE9_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE10                                                             0x0134
#define mmDISP_INTERRUPT_STATUS_CONTINUE10_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE11                                                             0x0135
#define mmDISP_INTERRUPT_STATUS_CONTINUE11_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE12                                                             0x0136
#define mmDISP_INTERRUPT_STATUS_CONTINUE12_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE13                                                             0x0137
#define mmDISP_INTERRUPT_STATUS_CONTINUE13_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE14                                                             0x0138
#define mmDISP_INTERRUPT_STATUS_CONTINUE14_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE15                                                             0x0139
#define mmDISP_INTERRUPT_STATUS_CONTINUE15_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE16                                                             0x013a
#define mmDISP_INTERRUPT_STATUS_CONTINUE16_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE17                                                             0x013b
#define mmDISP_INTERRUPT_STATUS_CONTINUE17_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE18                                                             0x013c
#define mmDISP_INTERRUPT_STATUS_CONTINUE18_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE19                                                             0x013d
#define mmDISP_INTERRUPT_STATUS_CONTINUE19_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE20                                                             0x013e
#define mmDISP_INTERRUPT_STATUS_CONTINUE20_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE21                                                             0x013f
#define mmDISP_INTERRUPT_STATUS_CONTINUE21_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE22                                                             0x0140
#define mmDISP_INTERRUPT_STATUS_CONTINUE22_BASE_IDX                                                    2
#define mmDC_GPU_TIMER_START_POSITION_VREADY                                                           0x0141
#define mmDC_GPU_TIMER_START_POSITION_VREADY_BASE_IDX                                                  2
#define mmDC_GPU_TIMER_START_POSITION_FLIP                                                             0x0142
#define mmDC_GPU_TIMER_START_POSITION_FLIP_BASE_IDX                                                    2
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK                                                 0x0143
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK_BASE_IDX                                        2
#define mmDC_GPU_TIMER_START_POSITION_FLIP_AWAY                                                        0x0144
#define mmDC_GPU_TIMER_START_POSITION_FLIP_AWAY_BASE_IDX                                               2
#define mmDISP_INTERRUPT_STATUS_CONTINUE23                                                             0x0145
#define mmDISP_INTERRUPT_STATUS_CONTINUE23_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE24                                                             0x0146
#define mmDISP_INTERRUPT_STATUS_CONTINUE24_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE25                                                             0x0147
#define mmDISP_INTERRUPT_STATUS_CONTINUE25_BASE_IDX                                                    2
#define mmDCCG_INTERRUPT_DEST                                                                          0x0148
#define mmDCCG_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmDMU_INTERRUPT_DEST                                                                           0x0149
#define mmDMU_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmDMU_INTERRUPT_DEST2                                                                          0x014a
#define mmDMU_INTERRUPT_DEST2_BASE_IDX                                                                 2
#define mmDCPG_INTERRUPT_DEST                                                                          0x014b
#define mmDCPG_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmDCPG_INTERRUPT_DEST2                                                                         0x014c
#define mmDCPG_INTERRUPT_DEST2_BASE_IDX                                                                2
#define mmMMHUBBUB_INTERRUPT_DEST                                                                      0x014d
#define mmMMHUBBUB_INTERRUPT_DEST_BASE_IDX                                                             2
#define mmWB_INTERRUPT_DEST                                                                            0x014e
#define mmWB_INTERRUPT_DEST_BASE_IDX                                                                   2
#define mmDCHUB_INTERRUPT_DEST                                                                         0x014f
#define mmDCHUB_INTERRUPT_DEST_BASE_IDX                                                                2
#define mmDCHUB_PERFCOUNTER_INTERRUPT_DEST                                                             0x0150
#define mmDCHUB_PERFCOUNTER_INTERRUPT_DEST_BASE_IDX                                                    2
#define mmDCHUB_INTERRUPT_DEST2                                                                        0x0151
#define mmDCHUB_INTERRUPT_DEST2_BASE_IDX                                                               2
#define mmDPP_PERFCOUNTER_INTERRUPT_DEST                                                               0x0152
#define mmDPP_PERFCOUNTER_INTERRUPT_DEST_BASE_IDX                                                      2
#define mmMPC_INTERRUPT_DEST                                                                           0x0153
#define mmMPC_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmOPP_INTERRUPT_DEST                                                                           0x0154
#define mmOPP_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmOPTC_INTERRUPT_DEST                                                                          0x0155
#define mmOPTC_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG0_INTERRUPT_DEST                                                                          0x0156
#define mmOTG0_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG1_INTERRUPT_DEST                                                                          0x0157
#define mmOTG1_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG2_INTERRUPT_DEST                                                                          0x0158
#define mmOTG2_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG3_INTERRUPT_DEST                                                                          0x0159
#define mmOTG3_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG4_INTERRUPT_DEST                                                                          0x015a
#define mmOTG4_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG5_INTERRUPT_DEST                                                                          0x015b
#define mmOTG5_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmDIG_INTERRUPT_DEST                                                                           0x015c
#define mmDIG_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmI2C_DDC_HPD_INTERRUPT_DEST                                                                   0x015d
#define mmI2C_DDC_HPD_INTERRUPT_DEST_BASE_IDX                                                          2
#define mmDIO_INTERRUPT_DEST                                                                           0x015f
#define mmDIO_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmDCIO_INTERRUPT_DEST                                                                          0x0160
#define mmDCIO_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmHPD_INTERRUPT_DEST                                                                           0x0161
#define mmHPD_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmAZ_INTERRUPT_DEST                                                                            0x0162
#define mmAZ_INTERRUPT_DEST_BASE_IDX                                                                   2
#define mmAUX_INTERRUPT_DEST                                                                           0x0163
#define mmAUX_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmDSC_INTERRUPT_DEST                                                                           0x0164
#define mmDSC_INTERRUPT_DEST_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_fgsec_dispdec
// base address: 0x0
#define mmDMCUB_RBBMIF_SEC_CNTL                                                                        0x017a
#define mmDMCUB_RBBMIF_SEC_CNTL_BASE_IDX                                                               2


// addressBlock: dce_dc_dmu_rbbmif_dispdec
// base address: 0x0
#define mmRBBMIF_TIMEOUT                                                                               0x017f
#define mmRBBMIF_TIMEOUT_BASE_IDX                                                                      2
#define mmRBBMIF_STATUS                                                                                0x0180
#define mmRBBMIF_STATUS_BASE_IDX                                                                       2
#define mmRBBMIF_STATUS_2                                                                              0x0181
#define mmRBBMIF_STATUS_2_BASE_IDX                                                                     2
#define mmRBBMIF_INT_STATUS                                                                            0x0182
#define mmRBBMIF_INT_STATUS_BASE_IDX                                                                   2
#define mmRBBMIF_TIMEOUT_DIS                                                                           0x0183
#define mmRBBMIF_TIMEOUT_DIS_BASE_IDX                                                                  2
#define mmRBBMIF_TIMEOUT_DIS_2                                                                         0x0184
#define mmRBBMIF_TIMEOUT_DIS_2_BASE_IDX                                                                2
#define mmRBBMIF_STATUS_FLAG                                                                           0x0185
#define mmRBBMIF_STATUS_FLAG_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_dmcub_dispdec
// base address: 0x0
#define mmDMCUB_REGION0_OFFSET                                                                         0x018e
#define mmDMCUB_REGION0_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION0_OFFSET_HIGH                                                                    0x018f
#define mmDMCUB_REGION0_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION1_OFFSET                                                                         0x0190
#define mmDMCUB_REGION1_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION1_OFFSET_HIGH                                                                    0x0191
#define mmDMCUB_REGION1_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION2_OFFSET                                                                         0x0192
#define mmDMCUB_REGION2_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION2_OFFSET_HIGH                                                                    0x0193
#define mmDMCUB_REGION2_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION4_OFFSET                                                                         0x0196
#define mmDMCUB_REGION4_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION4_OFFSET_HIGH                                                                    0x0197
#define mmDMCUB_REGION4_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION5_OFFSET                                                                         0x0198
#define mmDMCUB_REGION5_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION5_OFFSET_HIGH                                                                    0x0199
#define mmDMCUB_REGION5_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION6_OFFSET                                                                         0x019a
#define mmDMCUB_REGION6_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION6_OFFSET_HIGH                                                                    0x019b
#define mmDMCUB_REGION6_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION7_OFFSET                                                                         0x019c
#define mmDMCUB_REGION7_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION7_OFFSET_HIGH                                                                    0x019d
#define mmDMCUB_REGION7_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION0_TOP_ADDRESS                                                                    0x019e
#define mmDMCUB_REGION0_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION1_TOP_ADDRESS                                                                    0x019f
#define mmDMCUB_REGION1_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION2_TOP_ADDRESS                                                                    0x01a0
#define mmDMCUB_REGION2_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION4_TOP_ADDRESS                                                                    0x01a1
#define mmDMCUB_REGION4_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION5_TOP_ADDRESS                                                                    0x01a2
#define mmDMCUB_REGION5_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION6_TOP_ADDRESS                                                                    0x01a3
#define mmDMCUB_REGION6_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION7_TOP_ADDRESS                                                                    0x01a4
#define mmDMCUB_REGION7_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION3_CW0_BASE_ADDRESS                                                               0x01a5
#define mmDMCUB_REGION3_CW0_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW1_BASE_ADDRESS                                                               0x01a6
#define mmDMCUB_REGION3_CW1_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW2_BASE_ADDRESS                                                               0x01a7
#define mmDMCUB_REGION3_CW2_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW3_BASE_ADDRESS                                                               0x01a8
#define mmDMCUB_REGION3_CW3_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW4_BASE_ADDRESS                                                               0x01a9
#define mmDMCUB_REGION3_CW4_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW5_BASE_ADDRESS                                                               0x01aa
#define mmDMCUB_REGION3_CW5_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW6_BASE_ADDRESS                                                               0x01ab
#define mmDMCUB_REGION3_CW6_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW7_BASE_ADDRESS                                                               0x01ac
#define mmDMCUB_REGION3_CW7_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW0_TOP_ADDRESS                                                                0x01ad
#define mmDMCUB_REGION3_CW0_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW1_TOP_ADDRESS                                                                0x01ae
#define mmDMCUB_REGION3_CW1_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW2_TOP_ADDRESS                                                                0x01af
#define mmDMCUB_REGION3_CW2_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW3_TOP_ADDRESS                                                                0x01b0
#define mmDMCUB_REGION3_CW3_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW4_TOP_ADDRESS                                                                0x01b1
#define mmDMCUB_REGION3_CW4_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW5_TOP_ADDRESS                                                                0x01b2
#define mmDMCUB_REGION3_CW5_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW6_TOP_ADDRESS                                                                0x01b3
#define mmDMCUB_REGION3_CW6_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW7_TOP_ADDRESS                                                                0x01b4
#define mmDMCUB_REGION3_CW7_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW0_OFFSET                                                                     0x01b5
#define mmDMCUB_REGION3_CW0_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW0_OFFSET_HIGH                                                                0x01b6
#define mmDMCUB_REGION3_CW0_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW1_OFFSET                                                                     0x01b7
#define mmDMCUB_REGION3_CW1_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW1_OFFSET_HIGH                                                                0x01b8
#define mmDMCUB_REGION3_CW1_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW2_OFFSET                                                                     0x01b9
#define mmDMCUB_REGION3_CW2_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW2_OFFSET_HIGH                                                                0x01ba
#define mmDMCUB_REGION3_CW2_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW3_OFFSET                                                                     0x01bb
#define mmDMCUB_REGION3_CW3_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW3_OFFSET_HIGH                                                                0x01bc
#define mmDMCUB_REGION3_CW3_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW4_OFFSET                                                                     0x01bd
#define mmDMCUB_REGION3_CW4_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW4_OFFSET_HIGH                                                                0x01be
#define mmDMCUB_REGION3_CW4_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW5_OFFSET                                                                     0x01bf
#define mmDMCUB_REGION3_CW5_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW5_OFFSET_HIGH                                                                0x01c0
#define mmDMCUB_REGION3_CW5_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW6_OFFSET                                                                     0x01c1
#define mmDMCUB_REGION3_CW6_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW6_OFFSET_HIGH                                                                0x01c2
#define mmDMCUB_REGION3_CW6_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW7_OFFSET                                                                     0x01c3
#define mmDMCUB_REGION3_CW7_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW7_OFFSET_HIGH                                                                0x01c4
#define mmDMCUB_REGION3_CW7_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_INTERRUPT_ENABLE                                                                       0x01c5
#define mmDMCUB_INTERRUPT_ENABLE_BASE_IDX                                                              2
#define mmDMCUB_INTERRUPT_ACK                                                                          0x01c6
#define mmDMCUB_INTERRUPT_ACK_BASE_IDX                                                                 2
#define mmDMCUB_INTERRUPT_STATUS                                                                       0x01c7
#define mmDMCUB_INTERRUPT_STATUS_BASE_IDX                                                              2
#define mmDMCUB_INTERRUPT_TYPE                                                                         0x01c8
#define mmDMCUB_INTERRUPT_TYPE_BASE_IDX                                                                2
#define mmDMCUB_EXT_INTERRUPT_STATUS                                                                   0x01c9
#define mmDMCUB_EXT_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDMCUB_EXT_INTERRUPT_CTXID                                                                    0x01ca
#define mmDMCUB_EXT_INTERRUPT_CTXID_BASE_IDX                                                           2
#define mmDMCUB_EXT_INTERRUPT_ACK                                                                      0x01cb
#define mmDMCUB_EXT_INTERRUPT_ACK_BASE_IDX                                                             2
#define mmDMCUB_INST_FETCH_FAULT_ADDR                                                                  0x01cc
#define mmDMCUB_INST_FETCH_FAULT_ADDR_BASE_IDX                                                         2
#define mmDMCUB_DATA_WRITE_FAULT_ADDR                                                                  0x01cd
#define mmDMCUB_DATA_WRITE_FAULT_ADDR_BASE_IDX                                                         2
#define mmDMCUB_SEC_CNTL                                                                               0x01ce
#define mmDMCUB_SEC_CNTL_BASE_IDX                                                                      2
#define mmDMCUB_MEM_CNTL                                                                               0x01cf
#define mmDMCUB_MEM_CNTL_BASE_IDX                                                                      2
#define mmDMCUB_INBOX0_BASE_ADDRESS                                                                    0x01d0
#define mmDMCUB_INBOX0_BASE_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_INBOX0_SIZE                                                                            0x01d1
#define mmDMCUB_INBOX0_SIZE_BASE_IDX                                                                   2
#define mmDMCUB_INBOX0_WPTR                                                                            0x01d2
#define mmDMCUB_INBOX0_WPTR_BASE_IDX                                                                   2
#define mmDMCUB_INBOX0_RPTR                                                                            0x01d3
#define mmDMCUB_INBOX0_RPTR_BASE_IDX                                                                   2
#define mmDMCUB_INBOX1_BASE_ADDRESS                                                                    0x01d4
#define mmDMCUB_INBOX1_BASE_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_INBOX1_SIZE                                                                            0x01d5
#define mmDMCUB_INBOX1_SIZE_BASE_IDX                                                                   2
#define mmDMCUB_INBOX1_WPTR                                                                            0x01d6
#define mmDMCUB_INBOX1_WPTR_BASE_IDX                                                                   2
#define mmDMCUB_INBOX1_RPTR                                                                            0x01d7
#define mmDMCUB_INBOX1_RPTR_BASE_IDX                                                                   2
#define mmDMCUB_OUTBOX0_BASE_ADDRESS                                                                   0x01d8
#define mmDMCUB_OUTBOX0_BASE_ADDRESS_BASE_IDX                                                          2
#define mmDMCUB_OUTBOX0_SIZE                                                                           0x01d9
#define mmDMCUB_OUTBOX0_SIZE_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX0_WPTR                                                                           0x01da
#define mmDMCUB_OUTBOX0_WPTR_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX0_RPTR                                                                           0x01db
#define mmDMCUB_OUTBOX0_RPTR_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX1_BASE_ADDRESS                                                                   0x01dc
#define mmDMCUB_OUTBOX1_BASE_ADDRESS_BASE_IDX                                                          2
#define mmDMCUB_OUTBOX1_SIZE                                                                           0x01dd
#define mmDMCUB_OUTBOX1_SIZE_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX1_WPTR                                                                           0x01de
#define mmDMCUB_OUTBOX1_WPTR_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX1_RPTR                                                                           0x01df
#define mmDMCUB_OUTBOX1_RPTR_BASE_IDX                                                                  2
#define mmDMCUB_TIMER_TRIGGER0                                                                         0x01e0
#define mmDMCUB_TIMER_TRIGGER0_BASE_IDX                                                                2
#define mmDMCUB_TIMER_TRIGGER1                                                                         0x01e1
#define mmDMCUB_TIMER_TRIGGER1_BASE_IDX                                                                2
#define mmDMCUB_TIMER_WINDOW                                                                           0x01e2
#define mmDMCUB_TIMER_WINDOW_BASE_IDX                                                                  2
#define mmDMCUB_SCRATCH0                                                                               0x01e3
#define mmDMCUB_SCRATCH0_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH1                                                                               0x01e4
#define mmDMCUB_SCRATCH1_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH2                                                                               0x01e5
#define mmDMCUB_SCRATCH2_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH3                                                                               0x01e6
#define mmDMCUB_SCRATCH3_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH4                                                                               0x01e7
#define mmDMCUB_SCRATCH4_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH5                                                                               0x01e8
#define mmDMCUB_SCRATCH5_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH6                                                                               0x01e9
#define mmDMCUB_SCRATCH6_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH7                                                                               0x01ea
#define mmDMCUB_SCRATCH7_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH8                                                                               0x01eb
#define mmDMCUB_SCRATCH8_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH9                                                                               0x01ec
#define mmDMCUB_SCRATCH9_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH10                                                                              0x01ed
#define mmDMCUB_SCRATCH10_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH11                                                                              0x01ee
#define mmDMCUB_SCRATCH11_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH12                                                                              0x01ef
#define mmDMCUB_SCRATCH12_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH13                                                                              0x01f0
#define mmDMCUB_SCRATCH13_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH14                                                                              0x01f1
#define mmDMCUB_SCRATCH14_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH15                                                                              0x01f2
#define mmDMCUB_SCRATCH15_BASE_IDX                                                                     2
#define mmDMCUB_CNTL                                                                                   0x01f6
#define mmDMCUB_CNTL_BASE_IDX                                                                          2
#define mmDMCUB_GPINT_DATAIN0                                                                          0x01f7
#define mmDMCUB_GPINT_DATAIN0_BASE_IDX                                                                 2
#define mmDMCUB_GPINT_DATAIN1                                                                          0x01f8
#define mmDMCUB_GPINT_DATAIN1_BASE_IDX                                                                 2
#define mmDMCUB_GPINT_DATAOUT                                                                          0x01f9
#define mmDMCUB_GPINT_DATAOUT_BASE_IDX                                                                 2
#define mmDMCUB_UNDEFINED_ADDRESS_FAULT_ADDR                                                           0x01fa
#define mmDMCUB_UNDEFINED_ADDRESS_FAULT_ADDR_BASE_IDX                                                  2
#define mmDMCUB_LS_WAKE_INT_ENABLE                                                                     0x01fb
#define mmDMCUB_LS_WAKE_INT_ENABLE_BASE_IDX                                                            2
#define mmDMCUB_MEM_PWR_CNTL                                                                           0x01fc
#define mmDMCUB_MEM_PWR_CNTL_BASE_IDX                                                                  2
#define mmDMCUB_TIMER_CURRENT                                                                          0x01fd
#define mmDMCUB_TIMER_CURRENT_BASE_IDX                                                                 2
#define mmDMCUB_PROC_ID                                                                                0x01ff
#define mmDMCUB_PROC_ID_BASE_IDX                                                                       2


// addressBlock: dce_dc_mmhubbub_mcif_wb0_dispdec
// base address: 0x0
#define mmMCIF_WB_BUFMGR_SW_CONTROL                                                                    0x0272
#define mmMCIF_WB_BUFMGR_SW_CONTROL_BASE_IDX                                                           2
#define mmMCIF_WB_BUFMGR_STATUS                                                                        0x0274
#define mmMCIF_WB_BUFMGR_STATUS_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_PITCH                                                                            0x0275
#define mmMCIF_WB_BUF_PITCH_BASE_IDX                                                                   2
#define mmMCIF_WB_BUF_1_STATUS                                                                         0x0276
#define mmMCIF_WB_BUF_1_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_1_STATUS2                                                                        0x0277
#define mmMCIF_WB_BUF_1_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_2_STATUS                                                                         0x0278
#define mmMCIF_WB_BUF_2_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_2_STATUS2                                                                        0x0279
#define mmMCIF_WB_BUF_2_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_3_STATUS                                                                         0x027a
#define mmMCIF_WB_BUF_3_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_3_STATUS2                                                                        0x027b
#define mmMCIF_WB_BUF_3_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_4_STATUS                                                                         0x027c
#define mmMCIF_WB_BUF_4_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_4_STATUS2                                                                        0x027d
#define mmMCIF_WB_BUF_4_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_ARBITRATION_CONTROL                                                                  0x027e
#define mmMCIF_WB_ARBITRATION_CONTROL_BASE_IDX                                                         2
#define mmMCIF_WB_SCLK_CHANGE                                                                          0x027f
#define mmMCIF_WB_SCLK_CHANGE_BASE_IDX                                                                 2
#define mmMCIF_WB_BUF_1_ADDR_Y                                                                         0x0282
#define mmMCIF_WB_BUF_1_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_1_ADDR_C                                                                         0x0284
#define mmMCIF_WB_BUF_1_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_2_ADDR_Y                                                                         0x0286
#define mmMCIF_WB_BUF_2_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_2_ADDR_C                                                                         0x0288
#define mmMCIF_WB_BUF_2_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_3_ADDR_Y                                                                         0x028a
#define mmMCIF_WB_BUF_3_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_3_ADDR_C                                                                         0x028c
#define mmMCIF_WB_BUF_3_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_4_ADDR_Y                                                                         0x028e
#define mmMCIF_WB_BUF_4_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_4_ADDR_C                                                                         0x0290
#define mmMCIF_WB_BUF_4_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUFMGR_VCE_CONTROL                                                                   0x0292
#define mmMCIF_WB_BUFMGR_VCE_CONTROL_BASE_IDX                                                          2
#define mmMCIF_WB_NB_PSTATE_CONTROL                                                                    0x0293
#define mmMCIF_WB_NB_PSTATE_CONTROL_BASE_IDX                                                           2
#define mmMCIF_WB_CLOCK_GATER_CONTROL                                                                  0x0294
#define mmMCIF_WB_CLOCK_GATER_CONTROL_BASE_IDX                                                         2
#define mmMCIF_WB_SELF_REFRESH_CONTROL                                                                 0x0296
#define mmMCIF_WB_SELF_REFRESH_CONTROL_BASE_IDX                                                        2
#define mmMULTI_LEVEL_QOS_CTRL                                                                         0x0297
#define mmMULTI_LEVEL_QOS_CTRL_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_LUMA_SIZE                                                                        0x0299
#define mmMCIF_WB_BUF_LUMA_SIZE_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_CHROMA_SIZE                                                                      0x029a
#define mmMCIF_WB_BUF_CHROMA_SIZE_BASE_IDX                                                             2
#define mmMCIF_WB_BUF_1_ADDR_Y_HIGH                                                                    0x029b
#define mmMCIF_WB_BUF_1_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_1_ADDR_C_HIGH                                                                    0x029c
#define mmMCIF_WB_BUF_1_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_2_ADDR_Y_HIGH                                                                    0x029d
#define mmMCIF_WB_BUF_2_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_2_ADDR_C_HIGH                                                                    0x029e
#define mmMCIF_WB_BUF_2_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_3_ADDR_Y_HIGH                                                                    0x029f
#define mmMCIF_WB_BUF_3_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_3_ADDR_C_HIGH                                                                    0x02a0
#define mmMCIF_WB_BUF_3_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_4_ADDR_Y_HIGH                                                                    0x02a1
#define mmMCIF_WB_BUF_4_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_4_ADDR_C_HIGH                                                                    0x02a2
#define mmMCIF_WB_BUF_4_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_1_RESOLUTION                                                                     0x02a3
#define mmMCIF_WB_BUF_1_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_BUF_2_RESOLUTION                                                                     0x02a4
#define mmMCIF_WB_BUF_2_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_BUF_3_RESOLUTION                                                                     0x02a5
#define mmMCIF_WB_BUF_3_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_BUF_4_RESOLUTION                                                                     0x02a6
#define mmMCIF_WB_BUF_4_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_DRAM_SPEED_CHANGE_DURATION_VBI                                                       0x02a7
#define mmMCIF_WB_DRAM_SPEED_CHANGE_DURATION_VBI_BASE_IDX                                              2
#define mmMCIF_WB_VMID_CONTROL                                                                         0x02a8
#define mmMCIF_WB_VMID_CONTROL_BASE_IDX                                                                2
#define mmMCIF_WB_MIN_TTO                                                                              0x02a9
#define mmMCIF_WB_MIN_TTO_BASE_IDX                                                                     2


// addressBlock: dce_dc_mmhubbub_mmhubbub_dispdec
// base address: 0x0
#define mmMCIF_WB_NB_PSTATE_LATENCY_WATERMARK                                                          0x02aa
#define mmMCIF_WB_NB_PSTATE_LATENCY_WATERMARK_BASE_IDX                                                 2
#define mmMCIF_WB_WATERMARK                                                                            0x02ab
#define mmMCIF_WB_WATERMARK_BASE_IDX                                                                   2
#define mmMMHUBBUB_WARMUP_CONFIG                                                                       0x02ac
#define mmMMHUBBUB_WARMUP_CONFIG_BASE_IDX                                                              2
#define mmMMHUBBUB_WARMUP_CONTROL_STATUS                                                               0x02ad
#define mmMMHUBBUB_WARMUP_CONTROL_STATUS_BASE_IDX                                                      2
#define mmMMHUBBUB_WARMUP_BASE_ADDR_LOW                                                                0x02ae
#define mmMMHUBBUB_WARMUP_BASE_ADDR_LOW_BASE_IDX                                                       2
#define mmMMHUBBUB_WARMUP_BASE_ADDR_HIGH                                                               0x02af
#define mmMMHUBBUB_WARMUP_BASE_ADDR_HIGH_BASE_IDX                                                      2
#define mmMMHUBBUB_WARMUP_ADDR_REGION                                                                  0x02b0
#define mmMMHUBBUB_WARMUP_ADDR_REGION_BASE_IDX                                                         2
#define mmMMHUBBUB_MIN_TTO                                                                             0x02b1
#define mmMMHUBBUB_MIN_TTO_BASE_IDX                                                                    2
#define mmWBIF_SMU_WM_CONTROL                                                                          0x0333
#define mmWBIF_SMU_WM_CONTROL_BASE_IDX                                                                 2
#define mmWBIF0_MISC_CTRL                                                                              0x0334
#define mmWBIF0_MISC_CTRL_BASE_IDX                                                                     2
#define mmWBIF0_PHASE0_OUTSTANDING_COUNTER                                                             0x0335
#define mmWBIF0_PHASE0_OUTSTANDING_COUNTER_BASE_IDX                                                    2
#define mmWBIF0_PHASE1_OUTSTANDING_COUNTER                                                             0x0336
#define mmWBIF0_PHASE1_OUTSTANDING_COUNTER_BASE_IDX                                                    2
#define mmVGA_SRC_SPLIT_CNTL                                                                           0x033d
#define mmVGA_SRC_SPLIT_CNTL_BASE_IDX                                                                  2
#define mmMMHUBBUB_MEM_PWR_STATUS                                                                      0x033e
#define mmMMHUBBUB_MEM_PWR_STATUS_BASE_IDX                                                             2
#define mmMMHUBBUB_MEM_PWR_CNTL                                                                        0x033f
#define mmMMHUBBUB_MEM_PWR_CNTL_BASE_IDX                                                               2
#define mmMMHUBBUB_CLOCK_CNTL                                                                          0x0340
#define mmMMHUBBUB_CLOCK_CNTL_BASE_IDX                                                                 2
#define mmMMHUBBUB_SOFT_RESET                                                                          0x0341
#define mmMMHUBBUB_SOFT_RESET_BASE_IDX                                                                 2
#define mmDMU_IF_ERR_STATUS                                                                            0x0345
#define mmDMU_IF_ERR_STATUS_BASE_IDX                                                                   2
#define mmMMHUBBUB_CLIENT_UNIT_ID                                                                      0x0346
#define mmMMHUBBUB_CLIENT_UNIT_ID_BASE_IDX                                                             2
#define mmMMHUBBUB_WARMUP_VMID_CONTROL                                                                 0x0348
#define mmMMHUBBUB_WARMUP_VMID_CONTROL_BASE_IDX                                                        2


// addressBlock: dce_dc_mmhubbub_vgaif_dispdec
// base address: 0x0
#define mmMCIF_CONTROL                                                                                 0x034a
#define mmMCIF_CONTROL_BASE_IDX                                                                        2
#define mmMCIF_WRITE_COMBINE_CONTROL                                                                   0x034b
#define mmMCIF_WRITE_COMBINE_CONTROL_BASE_IDX                                                          2
#define mmMCIF_PHASE0_OUTSTANDING_COUNTER                                                              0x034e
#define mmMCIF_PHASE0_OUTSTANDING_COUNTER_BASE_IDX                                                     2
#define mmMCIF_PHASE1_OUTSTANDING_COUNTER                                                              0x034f
#define mmMCIF_PHASE1_OUTSTANDING_COUNTER_BASE_IDX                                                     2
#define mmMCIF_PHASE2_OUTSTANDING_COUNTER                                                              0x0350
#define mmMCIF_PHASE2_OUTSTANDING_COUNTER_BASE_IDX                                                     2


// addressBlock: dce_dc_mmhubbub_mmhubbub_dcperfmon_dc_perfmon_dispdec
// base address: 0xd48
#define mmDC_PERFMON2_PERFCOUNTER_CNTL                                                                 0x0352
#define mmDC_PERFMON2_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON2_PERFCOUNTER_CNTL2                                                                0x0353
#define mmDC_PERFMON2_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON2_PERFCOUNTER_STATE                                                                0x0354
#define mmDC_PERFMON2_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON2_PERFMON_CNTL                                                                     0x0355
#define mmDC_PERFMON2_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON2_PERFMON_CNTL2                                                                    0x0356
#define mmDC_PERFMON2_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON2_PERFMON_CVALUE_INT_MISC                                                          0x0357
#define mmDC_PERFMON2_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON2_PERFMON_CVALUE_LOW                                                               0x0358
#define mmDC_PERFMON2_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON2_PERFMON_HI                                                                       0x0359
#define mmDC_PERFMON2_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON2_PERFMON_LOW                                                                      0x035a
#define mmDC_PERFMON2_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_hda_azf0stream0_dispdec
// base address: 0x0
#define mmAZF0STREAM0_AZALIA_STREAM_INDEX                                                              0x035e
#define mmAZF0STREAM0_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM0_AZALIA_STREAM_DATA                                                               0x035f
#define mmAZF0STREAM0_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream1_dispdec
// base address: 0x8
#define mmAZF0STREAM1_AZALIA_STREAM_INDEX                                                              0x0360
#define mmAZF0STREAM1_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM1_AZALIA_STREAM_DATA                                                               0x0361
#define mmAZF0STREAM1_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream2_dispdec
// base address: 0x10
#define mmAZF0STREAM2_AZALIA_STREAM_INDEX                                                              0x0362
#define mmAZF0STREAM2_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM2_AZALIA_STREAM_DATA                                                               0x0363
#define mmAZF0STREAM2_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream3_dispdec
// base address: 0x18
#define mmAZF0STREAM3_AZALIA_STREAM_INDEX                                                              0x0364
#define mmAZF0STREAM3_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM3_AZALIA_STREAM_DATA                                                               0x0365
#define mmAZF0STREAM3_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream4_dispdec
// base address: 0x20
#define mmAZF0STREAM4_AZALIA_STREAM_INDEX                                                              0x0366
#define mmAZF0STREAM4_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM4_AZALIA_STREAM_DATA                                                               0x0367
#define mmAZF0STREAM4_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream5_dispdec
// base address: 0x28
#define mmAZF0STREAM5_AZALIA_STREAM_INDEX                                                              0x0368
#define mmAZF0STREAM5_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM5_AZALIA_STREAM_DATA                                                               0x0369
#define mmAZF0STREAM5_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream6_dispdec
// base address: 0x30
#define mmAZF0STREAM6_AZALIA_STREAM_INDEX                                                              0x036a
#define mmAZF0STREAM6_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM6_AZALIA_STREAM_DATA                                                               0x036b
#define mmAZF0STREAM6_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream7_dispdec
// base address: 0x38
#define mmAZF0STREAM7_AZALIA_STREAM_INDEX                                                              0x036c
#define mmAZF0STREAM7_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM7_AZALIA_STREAM_DATA                                                               0x036d
#define mmAZF0STREAM7_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_az_misc_dispdec
// base address: 0x0
#define mmAZ_CLOCK_CNTL                                                                                0x0372
#define mmAZ_CLOCK_CNTL_BASE_IDX                                                                       2


// addressBlock: dce_dc_hda_az_dcperfmon_dc_perfmon_dispdec
// base address: 0xde8
#define mmDC_PERFMON3_PERFCOUNTER_CNTL                                                                 0x037a
#define mmDC_PERFMON3_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON3_PERFCOUNTER_CNTL2                                                                0x037b
#define mmDC_PERFMON3_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON3_PERFCOUNTER_STATE                                                                0x037c
#define mmDC_PERFMON3_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON3_PERFMON_CNTL                                                                     0x037d
#define mmDC_PERFMON3_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON3_PERFMON_CNTL2                                                                    0x037e
#define mmDC_PERFMON3_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC                                                          0x037f
#define mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON3_PERFMON_CVALUE_LOW                                                               0x0380
#define mmDC_PERFMON3_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON3_PERFMON_HI                                                                       0x0381
#define mmDC_PERFMON3_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON3_PERFMON_LOW                                                                      0x0382
#define mmDC_PERFMON3_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_hda_azf0endpoint0_dispdec
// base address: 0x0
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0386
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0387
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint1_dispdec
// base address: 0x18
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x038c
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x038d
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint2_dispdec
// base address: 0x30
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0392
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0393
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint3_dispdec
// base address: 0x48
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0398
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0399
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint4_dispdec
// base address: 0x60
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x039e
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x039f
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint5_dispdec
// base address: 0x78
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03a4
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03a5
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint6_dispdec
// base address: 0x90
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03aa
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03ab
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint7_dispdec
// base address: 0xa8
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03b0
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03b1
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0controller_dispdec
// base address: 0x0
#define mmAZALIA_CONTROLLER_CLOCK_GATING                                                               0x03c2
#define mmAZALIA_CONTROLLER_CLOCK_GATING_BASE_IDX                                                      2
#define mmAZALIA_AUDIO_DTO                                                                             0x03c3
#define mmAZALIA_AUDIO_DTO_BASE_IDX                                                                    2
#define mmAZALIA_AUDIO_DTO_CONTROL                                                                     0x03c4
#define mmAZALIA_AUDIO_DTO_CONTROL_BASE_IDX                                                            2
#define mmAZALIA_SOCCLK_CONTROL                                                                        0x03c5
#define mmAZALIA_SOCCLK_CONTROL_BASE_IDX                                                               2
#define mmAZALIA_UNDERFLOW_FILLER_SAMPLE                                                               0x03c6
#define mmAZALIA_UNDERFLOW_FILLER_SAMPLE_BASE_IDX                                                      2
#define mmAZALIA_DATA_DMA_CONTROL                                                                      0x03c7
#define mmAZALIA_DATA_DMA_CONTROL_BASE_IDX                                                             2
#define mmAZALIA_BDL_DMA_CONTROL                                                                       0x03c8
#define mmAZALIA_BDL_DMA_CONTROL_BASE_IDX                                                              2
#define mmAZALIA_RIRB_AND_DP_CONTROL                                                                   0x03c9
#define mmAZALIA_RIRB_AND_DP_CONTROL_BASE_IDX                                                          2
#define mmAZALIA_CORB_DMA_CONTROL                                                                      0x03ca
#define mmAZALIA_CORB_DMA_CONTROL_BASE_IDX                                                             2
#define mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER                                                 0x03d1
#define mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER_BASE_IDX                                        2
#define mmAZALIA_CYCLIC_BUFFER_SYNC                                                                    0x03d2
#define mmAZALIA_CYCLIC_BUFFER_SYNC_BASE_IDX                                                           2
#define mmAZALIA_GLOBAL_CAPABILITIES                                                                   0x03d3
#define mmAZALIA_GLOBAL_CAPABILITIES_BASE_IDX                                                          2
#define mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY                                                             0x03d4
#define mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                    2
#define mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL                                                         0x03d5
#define mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL_BASE_IDX                                                2
#define mmAZALIA_INPUT_PAYLOAD_CAPABILITY                                                              0x03d6
#define mmAZALIA_INPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                     2
#define mmAZALIA_INPUT_CRC0_CONTROL0                                                                   0x03d9
#define mmAZALIA_INPUT_CRC0_CONTROL0_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL1                                                                   0x03da
#define mmAZALIA_INPUT_CRC0_CONTROL1_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL2                                                                   0x03db
#define mmAZALIA_INPUT_CRC0_CONTROL2_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL3                                                                   0x03dc
#define mmAZALIA_INPUT_CRC0_CONTROL3_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_RESULT                                                                     0x03dd
#define mmAZALIA_INPUT_CRC0_RESULT_BASE_IDX                                                            2
#define mmAZALIA_INPUT_CRC1_CONTROL0                                                                   0x03de
#define mmAZALIA_INPUT_CRC1_CONTROL0_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL1                                                                   0x03df
#define mmAZALIA_INPUT_CRC1_CONTROL1_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL2                                                                   0x03e0
#define mmAZALIA_INPUT_CRC1_CONTROL2_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL3                                                                   0x03e1
#define mmAZALIA_INPUT_CRC1_CONTROL3_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_RESULT                                                                     0x03e2
#define mmAZALIA_INPUT_CRC1_RESULT_BASE_IDX                                                            2
#define mmAZALIA_CRC0_CONTROL0                                                                         0x03e3
#define mmAZALIA_CRC0_CONTROL0_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL1                                                                         0x03e4
#define mmAZALIA_CRC0_CONTROL1_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL2                                                                         0x03e5
#define mmAZALIA_CRC0_CONTROL2_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL3                                                                         0x03e6
#define mmAZALIA_CRC0_CONTROL3_BASE_IDX                                                                2
#define mmAZALIA_CRC0_RESULT                                                                           0x03e7
#define mmAZALIA_CRC0_RESULT_BASE_IDX                                                                  2
#define mmAZALIA_CRC1_CONTROL0                                                                         0x03e8
#define mmAZALIA_CRC1_CONTROL0_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL1                                                                         0x03e9
#define mmAZALIA_CRC1_CONTROL1_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL2                                                                         0x03ea
#define mmAZALIA_CRC1_CONTROL2_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL3                                                                         0x03eb
#define mmAZALIA_CRC1_CONTROL3_BASE_IDX                                                                2
#define mmAZALIA_CRC1_RESULT                                                                           0x03ec
#define mmAZALIA_CRC1_RESULT_BASE_IDX                                                                  2
#define mmAZALIA_MEM_PWR_CTRL                                                                          0x03ee
#define mmAZALIA_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmAZALIA_MEM_PWR_STATUS                                                                        0x03ef
#define mmAZALIA_MEM_PWR_STATUS_BASE_IDX                                                               2


// addressBlock: dce_dc_hda_azf0root_dispdec
// base address: 0x0
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                                          0x0406
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID_BASE_IDX                                 2
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID                                                   0x0407
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID_BASE_IDX                                          2
#define mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL                                                        0x0408
#define mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL_BASE_IDX                                               2
#define mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL                                                          0x0409
#define mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL_BASE_IDX                                                 2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                                                0x040a
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE_BASE_IDX                                       2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES                                      0x040b
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES_BASE_IDX                             2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                                            0x040c
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS_BASE_IDX                                   2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES                                              0x040d
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES_BASE_IDX                                     2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE                                                 0x040e
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE_BASE_IDX                                        2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET                                                       0x040f
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET_BASE_IDX                                              2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                                       0x0410
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_BASE_IDX                              2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION                                   0x0411
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION_BASE_IDX                          2
#define mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY                                                            0x0412
#define mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                   2
#define mmCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                      0x0413
#define mmCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                             2
#define mmAZALIA_F0_GTC_GROUP_OFFSET0                                                                  0x0415
#define mmAZALIA_F0_GTC_GROUP_OFFSET0_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET1                                                                  0x0416
#define mmAZALIA_F0_GTC_GROUP_OFFSET1_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET2                                                                  0x0417
#define mmAZALIA_F0_GTC_GROUP_OFFSET2_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET3                                                                  0x0418
#define mmAZALIA_F0_GTC_GROUP_OFFSET3_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET4                                                                  0x0419
#define mmAZALIA_F0_GTC_GROUP_OFFSET4_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET5                                                                  0x041a
#define mmAZALIA_F0_GTC_GROUP_OFFSET5_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET6                                                                  0x041b
#define mmAZALIA_F0_GTC_GROUP_OFFSET6_BASE_IDX                                                         2
#define mmREG_DC_AUDIO_PORT_CONNECTIVITY                                                               0x041c
#define mmREG_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                      2
#define mmREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                         0x041d
#define mmREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                                2


// addressBlock: dce_dc_hda_azf0stream8_dispdec
// base address: 0x320
#define mmAZF0STREAM8_AZALIA_STREAM_INDEX                                                              0x0426
#define mmAZF0STREAM8_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM8_AZALIA_STREAM_DATA                                                               0x0427
#define mmAZF0STREAM8_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream9_dispdec
// base address: 0x328
#define mmAZF0STREAM9_AZALIA_STREAM_INDEX                                                              0x0428
#define mmAZF0STREAM9_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM9_AZALIA_STREAM_DATA                                                               0x0429
#define mmAZF0STREAM9_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream10_dispdec
// base address: 0x330
#define mmAZF0STREAM10_AZALIA_STREAM_INDEX                                                             0x042a
#define mmAZF0STREAM10_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM10_AZALIA_STREAM_DATA                                                              0x042b
#define mmAZF0STREAM10_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream11_dispdec
// base address: 0x338
#define mmAZF0STREAM11_AZALIA_STREAM_INDEX                                                             0x042c
#define mmAZF0STREAM11_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM11_AZALIA_STREAM_DATA                                                              0x042d
#define mmAZF0STREAM11_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream12_dispdec
// base address: 0x340
#define mmAZF0STREAM12_AZALIA_STREAM_INDEX                                                             0x042e
#define mmAZF0STREAM12_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM12_AZALIA_STREAM_DATA                                                              0x042f
#define mmAZF0STREAM12_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream13_dispdec
// base address: 0x348
#define mmAZF0STREAM13_AZALIA_STREAM_INDEX                                                             0x0430
#define mmAZF0STREAM13_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM13_AZALIA_STREAM_DATA                                                              0x0431
#define mmAZF0STREAM13_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream14_dispdec
// base address: 0x350
#define mmAZF0STREAM14_AZALIA_STREAM_INDEX                                                             0x0432
#define mmAZF0STREAM14_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM14_AZALIA_STREAM_DATA                                                              0x0433
#define mmAZF0STREAM14_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream15_dispdec
// base address: 0x358
#define mmAZF0STREAM15_AZALIA_STREAM_INDEX                                                             0x0434
#define mmAZF0STREAM15_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM15_AZALIA_STREAM_DATA                                                              0x0435
#define mmAZF0STREAM15_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0inputendpoint0_dispdec
// base address: 0x0
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x043a
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x043b
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint1_dispdec
// base address: 0x10
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x043e
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x043f
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint2_dispdec
// base address: 0x20
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0442
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0443
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint3_dispdec
// base address: 0x30
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0446
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0447
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint4_dispdec
// base address: 0x40
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x044a
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x044b
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint5_dispdec
// base address: 0x50
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x044e
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x044f
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint6_dispdec
// base address: 0x60
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0452
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0453
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint7_dispdec
// base address: 0x70
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0456
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0457
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_dchubbub_hubbub_sdpif_dispdec
// base address: 0x0
#define mmDCHUBBUB_SDPIF_CFG0                                                                          0x048f
#define mmDCHUBBUB_SDPIF_CFG0_BASE_IDX                                                                 2
#define mmVM_REQUEST_PHYSICAL                                                                          0x0490
#define mmVM_REQUEST_PHYSICAL_BASE_IDX                                                                 2
#define mmDCHUBBUB_FORCE_IO_STATUS_0                                                                   0x0491
#define mmDCHUBBUB_FORCE_IO_STATUS_0_BASE_IDX                                                          2
#define mmDCHUBBUB_FORCE_IO_STATUS_1                                                                   0x0492
#define mmDCHUBBUB_FORCE_IO_STATUS_1_BASE_IDX                                                          2
#define mmDCN_VM_FB_LOCATION_BASE                                                                      0x0493
#define mmDCN_VM_FB_LOCATION_BASE_BASE_IDX                                                             2
#define mmDCN_VM_FB_LOCATION_TOP                                                                       0x0494
#define mmDCN_VM_FB_LOCATION_TOP_BASE_IDX                                                              2
#define mmDCN_VM_FB_OFFSET                                                                             0x0495
#define mmDCN_VM_FB_OFFSET_BASE_IDX                                                                    2
#define mmDCN_VM_AGP_BOT                                                                               0x0496
#define mmDCN_VM_AGP_BOT_BASE_IDX                                                                      2
#define mmDCN_VM_AGP_TOP                                                                               0x0497
#define mmDCN_VM_AGP_TOP_BASE_IDX                                                                      2
#define mmDCN_VM_AGP_BASE                                                                              0x0498
#define mmDCN_VM_AGP_BASE_BASE_IDX                                                                     2
#define mmDCN_VM_LOCAL_HBM_ADDRESS_START                                                               0x0499
#define mmDCN_VM_LOCAL_HBM_ADDRESS_START_BASE_IDX                                                      2
#define mmDCN_VM_LOCAL_HBM_ADDRESS_END                                                                 0x049a
#define mmDCN_VM_LOCAL_HBM_ADDRESS_END_BASE_IDX                                                        2
#define mmDCN_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL                                                           0x049b
#define mmDCN_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL_BASE_IDX                                                  2
#define mmDCHUBBUB_SDPIF_MEM_PWR_CTRL                                                                  0x04ba
#define mmDCHUBBUB_SDPIF_MEM_PWR_CTRL_BASE_IDX                                                         2
#define mmDCHUBBUB_SDPIF_MEM_PWR_STATUS                                                                0x04bb
#define mmDCHUBBUB_SDPIF_MEM_PWR_STATUS_BASE_IDX                                                       2
#define mmDCHUBBUB_SDPIF_CFG1                                                                          0x04bf
#define mmDCHUBBUB_SDPIF_CFG1_BASE_IDX                                                                 2
#define mmDCHUBBUB_SDPIF_CFG2                                                                          0x04c0
#define mmDCHUBBUB_SDPIF_CFG2_BASE_IDX                                                                 2


// addressBlock: dce_dc_dchubbub_hubbub_ret_path_dispdec
// base address: 0x0
#define mmDCHUBBUB_RET_PATH_DCC_CFG                                                                    0x04cf
#define mmDCHUBBUB_RET_PATH_DCC_CFG_BASE_IDX                                                           2
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_0                                                                 0x04d0
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_1                                                                 0x04d1
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_0                                                                 0x04d2
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_1                                                                 0x04d3
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_0                                                                 0x04d4
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_1                                                                 0x04d5
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_0                                                                 0x04d6
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_1                                                                 0x04d7
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_MEM_PWR_CTRL                                                               0x04ef
#define mmDCHUBBUB_RET_PATH_MEM_PWR_CTRL_BASE_IDX                                                      2
#define mmDCHUBBUB_RET_PATH_MEM_PWR_STATUS                                                             0x04f0
#define mmDCHUBBUB_RET_PATH_MEM_PWR_STATUS_BASE_IDX                                                    2
#define mmDCHUBBUB_CRC_CTRL                                                                            0x04f1
#define mmDCHUBBUB_CRC_CTRL_BASE_IDX                                                                   2
#define mmDCHUBBUB_CRC0_VAL_R_G                                                                        0x04f2
#define mmDCHUBBUB_CRC0_VAL_R_G_BASE_IDX                                                               2
#define mmDCHUBBUB_CRC0_VAL_B_A                                                                        0x04f3
#define mmDCHUBBUB_CRC0_VAL_B_A_BASE_IDX                                                               2
#define mmDCHUBBUB_CRC1_VAL_R_G                                                                        0x04f4
#define mmDCHUBBUB_CRC1_VAL_R_G_BASE_IDX                                                               2
#define mmDCHUBBUB_CRC1_VAL_B_A                                                                        0x04f5
#define mmDCHUBBUB_CRC1_VAL_B_A_BASE_IDX                                                               2


// addressBlock: dce_dc_dchubbub_hubbub_dispdec
// base address: 0x0
#define mmDCHUBBUB_ARB_DF_REQ_OUTSTAND                                                                 0x0505
#define mmDCHUBBUB_ARB_DF_REQ_OUTSTAND_BASE_IDX                                                        2
#define mmDCHUBBUB_ARB_SAT_LEVEL                                                                       0x0506
#define mmDCHUBBUB_ARB_SAT_LEVEL_BASE_IDX                                                              2
#define mmDCHUBBUB_ARB_QOS_FORCE                                                                       0x0507
#define mmDCHUBBUB_ARB_QOS_FORCE_BASE_IDX                                                              2
#define mmDCHUBBUB_ARB_DRAM_STATE_CNTL                                                                 0x0508
#define mmDCHUBBUB_ARB_DRAM_STATE_CNTL_BASE_IDX                                                        2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A                                                        0x0509
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_A                                                     0x050a
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_A_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A                                                      0x050b
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A                                                       0x050c
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A                                               0x050d
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B                                                        0x050e
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_B                                                     0x050f
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_B_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B                                                      0x0510
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B                                                       0x0511
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B                                               0x0512
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C                                                        0x0513
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_C                                                     0x0514
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_C_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C                                                      0x0515
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C                                                       0x0516
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C                                               0x0517
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D                                                        0x0518
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_D                                                     0x0519
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_D_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D                                                      0x051a
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D                                                       0x051b
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D                                               0x051c
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_WATERMARK_CHANGE_CNTL                                                           0x051d
#define mmDCHUBBUB_ARB_WATERMARK_CHANGE_CNTL_BASE_IDX                                                  2
#define mmDCHUBBUB_ARB_TIMEOUT_ENABLE                                                                  0x051e
#define mmDCHUBBUB_ARB_TIMEOUT_ENABLE_BASE_IDX                                                         2
#define mmDCHUBBUB_GLOBAL_TIMER_CNTL                                                                   0x051f
#define mmDCHUBBUB_GLOBAL_TIMER_CNTL_BASE_IDX                                                          2
#define mmSURFACE_CHECK0_ADDRESS_LSB                                                                   0x0520
#define mmSURFACE_CHECK0_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK0_ADDRESS_MSB                                                                   0x0521
#define mmSURFACE_CHECK0_ADDRESS_MSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK1_ADDRESS_LSB                                                                   0x0522
#define mmSURFACE_CHECK1_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK1_ADDRESS_MSB                                                                   0x0523
#define mmSURFACE_CHECK1_ADDRESS_MSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK2_ADDRESS_LSB                                                                   0x0524
#define mmSURFACE_CHECK2_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK2_ADDRESS_MSB                                                                   0x0525
#define mmSURFACE_CHECK2_ADDRESS_MSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK3_ADDRESS_LSB                                                                   0x0526
#define mmSURFACE_CHECK3_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK3_ADDRESS_MSB                                                                   0x0527
#define mmSURFACE_CHECK3_ADDRESS_MSB_BASE_IDX                                                          2
#define mmVTG0_CONTROL                                                                                 0x0528
#define mmVTG0_CONTROL_BASE_IDX                                                                        2
#define mmVTG1_CONTROL                                                                                 0x0529
#define mmVTG1_CONTROL_BASE_IDX                                                                        2
#define mmDCHUBBUB_SOFT_RESET                                                                          0x052e
#define mmDCHUBBUB_SOFT_RESET_BASE_IDX                                                                 2
#define mmDCHUBBUB_CLOCK_CNTL                                                                          0x052f
#define mmDCHUBBUB_CLOCK_CNTL_BASE_IDX                                                                 2
#define mmDCFCLK_CNTL                                                                                  0x0530
#define mmDCFCLK_CNTL_BASE_IDX                                                                         2
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL                                                        0x0531
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL_BASE_IDX                                               2
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2                                                       0x0532
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2_BASE_IDX                                              2
#define mmDCHUBBUB_VLINE_SNAPSHOT                                                                      0x0533
#define mmDCHUBBUB_VLINE_SNAPSHOT_BASE_IDX                                                             2
#define mmDCHUBBUB_CTRL_STATUS                                                                         0x0534
#define mmDCHUBBUB_CTRL_STATUS_BASE_IDX                                                                2
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL1                                                             0x053a
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL1_BASE_IDX                                                    2
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL2                                                             0x053b
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL2_BASE_IDX                                                    2
#define mmDCHUBBUB_TIMEOUT_INTERRUPT_STATUS                                                            0x053c
#define mmDCHUBBUB_TIMEOUT_INTERRUPT_STATUS_BASE_IDX                                                   2
#define mmDCHUBBUB_TEST_DEBUG_INDEX                                                                    0x053d
#define mmDCHUBBUB_TEST_DEBUG_INDEX_BASE_IDX                                                           2
#define mmDCHUBBUB_TEST_DEBUG_DATA                                                                     0x053e
#define mmDCHUBBUB_TEST_DEBUG_DATA_BASE_IDX                                                            2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_A                                                               0x053f
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_A_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_A                                                              0x0540
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_A_BASE_IDX                                                     2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_B                                                               0x0541
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_B_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_B                                                              0x0542
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_B_BASE_IDX                                                     2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_C                                                               0x0543
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_C_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_C                                                              0x0544
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_C_BASE_IDX                                                     2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_D                                                               0x0545
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_D_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_D                                                              0x0546
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_D_BASE_IDX                                                     2
#define mmFMON_CTRL                                                                                    0x0548
#define mmFMON_CTRL_BASE_IDX                                                                           2
#define mmFMON_CTRL_1                                                                                  0x0548
#define mmFMON_CTRL_1_BASE_IDX                                                                         2


// addressBlock: dce_dc_dchubbub_dchubbub_dcperfmon_dc_perfmon_dispdec
// base address: 0x1534
#define mmDC_PERFMON4_PERFCOUNTER_CNTL                                                                 0x054d
#define mmDC_PERFMON4_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON4_PERFCOUNTER_CNTL2                                                                0x054e
#define mmDC_PERFMON4_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON4_PERFCOUNTER_STATE                                                                0x054f
#define mmDC_PERFMON4_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON4_PERFMON_CNTL                                                                     0x0550
#define mmDC_PERFMON4_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON4_PERFMON_CNTL2                                                                    0x0551
#define mmDC_PERFMON4_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC                                                          0x0552
#define mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON4_PERFMON_CVALUE_LOW                                                               0x0553
#define mmDC_PERFMON4_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON4_PERFMON_HI                                                                       0x0554
#define mmDC_PERFMON4_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON4_PERFMON_LOW                                                                      0x0555
#define mmDC_PERFMON4_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dchubbub_hubbub_vmrq_if_dispdec
// base address: 0x0
#define mmDCN_VM_CONTEXT0_CNTL                                                                         0x0559
#define mmDCN_VM_CONTEXT0_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                    0x055a
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                    0x055b
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                   0x055c
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                   0x055d
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                     0x055e
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                     0x055f
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT1_CNTL                                                                         0x0560
#define mmDCN_VM_CONTEXT1_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0561
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0562
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                   0x0563
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                   0x0564
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                     0x0565
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                     0x0566
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT2_CNTL                                                                         0x0567
#define mmDCN_VM_CONTEXT2_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0568
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0569
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                   0x056a
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                   0x056b
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                     0x056c
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                     0x056d
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT3_CNTL                                                                         0x056e
#define mmDCN_VM_CONTEXT3_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                    0x056f
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0570
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                   0x0571
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                   0x0572
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                     0x0573
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                     0x0574
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT4_CNTL                                                                         0x0575
#define mmDCN_VM_CONTEXT4_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0576
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0577
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                   0x0578
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                   0x0579
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                     0x057a
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                     0x057b
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT5_CNTL                                                                         0x057c
#define mmDCN_VM_CONTEXT5_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                    0x057d
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                    0x057e
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                   0x057f
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                   0x0580
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                     0x0581
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                     0x0582
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT6_CNTL                                                                         0x0583
#define mmDCN_VM_CONTEXT6_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0584
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0585
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                   0x0586
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                   0x0587
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                     0x0588
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                     0x0589
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT7_CNTL                                                                         0x058a
#define mmDCN_VM_CONTEXT7_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                    0x058b
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                    0x058c
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                   0x058d
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                   0x058e
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                     0x058f
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                     0x0590
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT8_CNTL                                                                         0x0591
#define mmDCN_VM_CONTEXT8_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0592
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0593
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                   0x0594
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                   0x0595
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                     0x0596
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                     0x0597
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT9_CNTL                                                                         0x0598
#define mmDCN_VM_CONTEXT9_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0599
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                    0x059a
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                   0x059b
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                   0x059c
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                     0x059d
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                     0x059e
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT10_CNTL                                                                        0x059f
#define mmDCN_VM_CONTEXT10_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05a0
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05a1
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                  0x05a2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                  0x05a3
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                    0x05a4
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                    0x05a5
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT11_CNTL                                                                        0x05a6
#define mmDCN_VM_CONTEXT11_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05a7
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05a8
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                  0x05a9
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                  0x05aa
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                    0x05ab
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                    0x05ac
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT12_CNTL                                                                        0x05ad
#define mmDCN_VM_CONTEXT12_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05ae
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05af
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                  0x05b0
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                  0x05b1
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                    0x05b2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                    0x05b3
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT13_CNTL                                                                        0x05b4
#define mmDCN_VM_CONTEXT13_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05b5
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05b6
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                  0x05b7
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                  0x05b8
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                    0x05b9
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                    0x05ba
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT14_CNTL                                                                        0x05bb
#define mmDCN_VM_CONTEXT14_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05bc
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05bd
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                  0x05be
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                  0x05bf
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                    0x05c0
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                    0x05c1
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT15_CNTL                                                                        0x05c2
#define mmDCN_VM_CONTEXT15_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05c3
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05c4
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                  0x05c5
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                  0x05c6
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                    0x05c7
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                    0x05c8
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_DEFAULT_ADDR_MSB                                                                      0x05c9
#define mmDCN_VM_DEFAULT_ADDR_MSB_BASE_IDX                                                             2
#define mmDCN_VM_DEFAULT_ADDR_LSB                                                                      0x05ca
#define mmDCN_VM_DEFAULT_ADDR_LSB_BASE_IDX                                                             2
#define mmDCN_VM_FAULT_CNTL                                                                            0x05cb
#define mmDCN_VM_FAULT_CNTL_BASE_IDX                                                                   2
#define mmDCN_VM_FAULT_STATUS                                                                          0x05cc
#define mmDCN_VM_FAULT_STATUS_BASE_IDX                                                                 2
#define mmDCN_VM_FAULT_ADDR_MSB                                                                        0x05cd
#define mmDCN_VM_FAULT_ADDR_MSB_BASE_IDX                                                               2
#define mmDCN_VM_FAULT_ADDR_LSB                                                                        0x05ce
#define mmDCN_VM_FAULT_ADDR_LSB_BASE_IDX                                                               2


// addressBlock: dce_dc_dcbubp0_dispdec_hubp_dispdec
// base address: 0x0
#define mmHUBP0_DCSURF_SURFACE_CONFIG                                                                  0x05e5
#define mmHUBP0_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP0_DCSURF_ADDR_CONFIG                                                                     0x05e6
#define mmHUBP0_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP0_DCSURF_TILING_CONFIG                                                                   0x05e7
#define mmHUBP0_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START                                                              0x05e9
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x05ea
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START_C                                                            0x05eb
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x05ec
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START                                                              0x05ed
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x05ee
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START_C                                                            0x05ef
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x05f0
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG                                                                 0x05f1
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x05f2
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP0_DCHUBP_CNTL                                                                            0x05f3
#define mmHUBP0_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP0_HUBP_CLK_CNTL                                                                          0x05f4
#define mmHUBP0_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP0_DCHUBP_VMPG_CONFIG                                                                     0x05f5
#define mmHUBP0_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP0_HUBPREQ_DEBUG_DB 								       0x05f6
#define mmHUBP0_HUBPREQ_DEBUG_DB_BASE_IDX							       2
#define mmHUBP0_HUBPREQ_DEBUG 									       0x05f7
#define mmHUBP0_HUBPREQ_DEBUG_BASE_IDX								       2
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x05fb
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x05fc
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2


// addressBlock: dce_dc_dcbubp0_dispdec_hubpreq_dispdec
// base address: 0x0
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH                                                                0x0607
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH_C                                                              0x0608
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ0_VMID_SETTINGS_0                                                                     0x0609
#define mmHUBPREQ0_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x060a
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x060b
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x060c
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x060d
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x060e
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x060f
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x0610
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x0611
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x0612
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x0613
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x0614
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x0615
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x0616
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x0617
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x0618
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x0619
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ0_DCSURF_SURFACE_CONTROL                                                              0x061a
#define mmHUBPREQ0_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL                                                                 0x061b
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL2                                                                0x061c
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x0620
#define mmHUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE                                                                0x0621
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH                                                           0x0622
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_C                                                              0x0623
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x0624
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0625
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0626
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0627
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0628
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ0_DCN_EXPANSION_MODE                                                                  0x0629
#define mmHUBPREQ0_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_TTU_QOS_WM                                                                      0x062a
#define mmHUBPREQ0_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ0_DCN_GLOBAL_TTU_CNTL                                                                 0x062b
#define mmHUBPREQ0_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL0                                                                 0x062c
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL1                                                                 0x062d
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL0                                                                 0x062e
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL1                                                                 0x062f
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL0                                                                  0x0630
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL1                                                                  0x0631
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL0                                                                  0x0632
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL1                                                                  0x0633
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_DMDATA_VM_CNTL                                                                  0x0634
#define mmHUBPREQ0_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x0635
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x0636
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ0_DCN_VM_MX_L1_TLB_CNTL                                                               0x0643
#define mmHUBPREQ0_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ0_BLANK_OFFSET_0                                                                      0x0644
#define mmHUBPREQ0_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ0_BLANK_OFFSET_1                                                                      0x0645
#define mmHUBPREQ0_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ0_DST_DIMENSIONS                                                                      0x0646
#define mmHUBPREQ0_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ0_DST_AFTER_SCALER                                                                    0x0647
#define mmHUBPREQ0_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ0_PREFETCH_SETTINGS                                                                   0x0648
#define mmHUBPREQ0_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ0_PREFETCH_SETTINGS_C                                                                 0x0649
#define mmHUBPREQ0_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_0                                                                 0x064a
#define mmHUBPREQ0_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_1                                                                 0x064b
#define mmHUBPREQ0_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_2                                                                 0x064c
#define mmHUBPREQ0_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_3                                                                 0x064d
#define mmHUBPREQ0_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_4                                                                 0x064e
#define mmHUBPREQ0_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ0_FLIP_PARAMETERS_0                                                                   0x064f
#define mmHUBPREQ0_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_1                                                                   0x0650
#define mmHUBPREQ0_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_2                                                                   0x0651
#define mmHUBPREQ0_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ0_NOM_PARAMETERS_0                                                                    0x0652
#define mmHUBPREQ0_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_1                                                                    0x0653
#define mmHUBPREQ0_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_2                                                                    0x0654
#define mmHUBPREQ0_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_3                                                                    0x0655
#define mmHUBPREQ0_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_4                                                                    0x0656
#define mmHUBPREQ0_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_5                                                                    0x0657
#define mmHUBPREQ0_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_6                                                                    0x0658
#define mmHUBPREQ0_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_7                                                                    0x0659
#define mmHUBPREQ0_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ0_PER_LINE_DELIVERY_PRE                                                               0x065a
#define mmHUBPREQ0_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ0_PER_LINE_DELIVERY                                                                   0x065b
#define mmHUBPREQ0_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ0_CURSOR_SETTINGS                                                                     0x065c
#define mmHUBPREQ0_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ0_REF_FREQ_TO_PIX_FREQ                                                                0x065d
#define mmHUBPREQ0_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ0_DST_Y_DELTA_DRQ_LIMIT                                                               0x065e
#define mmHUBPREQ0_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_CTRL                                                                0x065f
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_STATUS                                                              0x0660
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ0_VBLANK_PARAMETERS_5                                                                 0x0663
#define mmHUBPREQ0_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_6                                                                 0x0664
#define mmHUBPREQ0_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ0_FLIP_PARAMETERS_3                                                                   0x0665
#define mmHUBPREQ0_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_4                                                                   0x0666
#define mmHUBPREQ0_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_5                                                                   0x0667
#define mmHUBPREQ0_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_6                                                                   0x0668
#define mmHUBPREQ0_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp0_dispdec_hubpret_dispdec
// base address: 0x0
#define mmHUBPRET0_HUBPRET_CONTROL                                                                     0x066c
#define mmHUBPRET0_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET0_HUBPRET_MEM_PWR_CTRL                                                                0x066d
#define mmHUBPRET0_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET0_HUBPRET_MEM_PWR_STATUS                                                              0x066e
#define mmHUBPRET0_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL0                                                             0x066f
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL1                                                             0x0670
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET0_HUBPRET_READ_LINE0                                                                  0x0671
#define mmHUBPRET0_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET0_HUBPRET_READ_LINE1                                                                  0x0672
#define mmHUBPRET0_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET0_HUBPRET_INTERRUPT                                                                   0x0673
#define mmHUBPRET0_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET0_HUBPRET_READ_LINE_VALUE                                                             0x0674
#define mmHUBPRET0_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET0_HUBPRET_READ_LINE_STATUS                                                            0x0675
#define mmHUBPRET0_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp0_dispdec_cursor0_dispdec
// base address: 0x0
#define mmCURSOR0_0_CURSOR_CONTROL                                                                     0x0678
#define mmCURSOR0_0_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS                                                             0x0679
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x067a
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_0_CURSOR_SIZE                                                                        0x067b
#define mmCURSOR0_0_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_0_CURSOR_POSITION                                                                    0x067c
#define mmCURSOR0_0_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_0_CURSOR_HOT_SPOT                                                                    0x067d
#define mmCURSOR0_0_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_0_CURSOR_STEREO_CONTROL                                                              0x067e
#define mmCURSOR0_0_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_0_CURSOR_DST_OFFSET                                                                  0x067f
#define mmCURSOR0_0_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_0_CURSOR_MEM_PWR_CTRL                                                                0x0680
#define mmCURSOR0_0_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_0_CURSOR_MEM_PWR_STATUS                                                              0x0681
#define mmCURSOR0_0_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_0_DMDATA_ADDRESS_HIGH                                                                0x0682
#define mmCURSOR0_0_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_0_DMDATA_ADDRESS_LOW                                                                 0x0683
#define mmCURSOR0_0_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_0_DMDATA_CNTL                                                                        0x0684
#define mmCURSOR0_0_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_0_DMDATA_QOS_CNTL                                                                    0x0685
#define mmCURSOR0_0_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_0_DMDATA_STATUS                                                                      0x0686
#define mmCURSOR0_0_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_0_DMDATA_SW_CNTL                                                                     0x0687
#define mmCURSOR0_0_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_0_DMDATA_SW_DATA                                                                     0x0688
#define mmCURSOR0_0_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp0_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x1a74
#define mmDC_PERFMON5_PERFCOUNTER_CNTL                                                                 0x069d
#define mmDC_PERFMON5_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON5_PERFCOUNTER_CNTL2                                                                0x069e
#define mmDC_PERFMON5_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON5_PERFCOUNTER_STATE                                                                0x069f
#define mmDC_PERFMON5_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON5_PERFMON_CNTL                                                                     0x06a0
#define mmDC_PERFMON5_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON5_PERFMON_CNTL2                                                                    0x06a1
#define mmDC_PERFMON5_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC                                                          0x06a2
#define mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON5_PERFMON_CVALUE_LOW                                                               0x06a3
#define mmDC_PERFMON5_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON5_PERFMON_HI                                                                       0x06a4
#define mmDC_PERFMON5_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON5_PERFMON_LOW                                                                      0x06a5
#define mmDC_PERFMON5_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp1_dispdec_hubp_dispdec
// base address: 0x370
#define mmHUBP1_DCSURF_SURFACE_CONFIG                                                                  0x06c1
#define mmHUBP1_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP1_DCSURF_ADDR_CONFIG                                                                     0x06c2
#define mmHUBP1_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP1_DCSURF_TILING_CONFIG                                                                   0x06c3
#define mmHUBP1_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START                                                              0x06c5
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x06c6
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START_C                                                            0x06c7
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x06c8
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START                                                              0x06c9
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x06ca
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START_C                                                            0x06cb
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x06cc
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG                                                                 0x06cd
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x06ce
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP1_DCHUBP_CNTL                                                                            0x06cf
#define mmHUBP1_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP1_HUBP_CLK_CNTL                                                                          0x06d0
#define mmHUBP1_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP1_DCHUBP_VMPG_CONFIG                                                                     0x06d1
#define mmHUBP1_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP1_HUBPREQ_DEBUG_DB                                                                       0x06d2
#define mmHUBP1_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define mmHUBP1_HUBPREQ_DEBUG                                                                          0x06d3
#define mmHUBP1_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x06d7
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x06d8
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2


// addressBlock: dce_dc_dcbubp1_dispdec_hubpreq_dispdec
// base address: 0x370
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH                                                                0x06e3
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH_C                                                              0x06e4
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ1_VMID_SETTINGS_0                                                                     0x06e5
#define mmHUBPREQ1_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x06e6
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x06e7
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x06e8
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x06e9
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x06ea
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x06eb
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x06ec
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x06ed
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x06ee
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x06ef
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x06f0
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x06f1
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x06f2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x06f3
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x06f4
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x06f5
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ1_DCSURF_SURFACE_CONTROL                                                              0x06f6
#define mmHUBPREQ1_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL                                                                 0x06f7
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL2                                                                0x06f8
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ1_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x06fc
#define mmHUBPREQ1_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE                                                                0x06fd
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH                                                           0x06fe
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_C                                                              0x06ff
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x0700
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0701
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0702
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0703
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0704
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ1_DCN_EXPANSION_MODE                                                                  0x0705
#define mmHUBPREQ1_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_TTU_QOS_WM                                                                      0x0706
#define mmHUBPREQ1_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ1_DCN_GLOBAL_TTU_CNTL                                                                 0x0707
#define mmHUBPREQ1_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL0                                                                 0x0708
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL1                                                                 0x0709
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL0                                                                 0x070a
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL1                                                                 0x070b
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL0                                                                  0x070c
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL1                                                                  0x070d
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL0                                                                  0x070e
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL1                                                                  0x070f
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_DMDATA_VM_CNTL                                                                  0x0710
#define mmHUBPREQ1_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x0711
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x0712
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ1_DCN_VM_MX_L1_TLB_CNTL                                                               0x071f
#define mmHUBPREQ1_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ1_BLANK_OFFSET_0                                                                      0x0720
#define mmHUBPREQ1_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ1_BLANK_OFFSET_1                                                                      0x0721
#define mmHUBPREQ1_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ1_DST_DIMENSIONS                                                                      0x0722
#define mmHUBPREQ1_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ1_DST_AFTER_SCALER                                                                    0x0723
#define mmHUBPREQ1_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ1_PREFETCH_SETTINGS                                                                   0x0724
#define mmHUBPREQ1_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ1_PREFETCH_SETTINGS_C                                                                 0x0725
#define mmHUBPREQ1_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_0                                                                 0x0726
#define mmHUBPREQ1_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_1                                                                 0x0727
#define mmHUBPREQ1_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_2                                                                 0x0728
#define mmHUBPREQ1_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_3                                                                 0x0729
#define mmHUBPREQ1_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_4                                                                 0x072a
#define mmHUBPREQ1_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ1_FLIP_PARAMETERS_0                                                                   0x072b
#define mmHUBPREQ1_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_1                                                                   0x072c
#define mmHUBPREQ1_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_2                                                                   0x072d
#define mmHUBPREQ1_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ1_NOM_PARAMETERS_0                                                                    0x072e
#define mmHUBPREQ1_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_1                                                                    0x072f
#define mmHUBPREQ1_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_2                                                                    0x0730
#define mmHUBPREQ1_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_3                                                                    0x0731
#define mmHUBPREQ1_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_4                                                                    0x0732
#define mmHUBPREQ1_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_5                                                                    0x0733
#define mmHUBPREQ1_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_6                                                                    0x0734
#define mmHUBPREQ1_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_7                                                                    0x0735
#define mmHUBPREQ1_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ1_PER_LINE_DELIVERY_PRE                                                               0x0736
#define mmHUBPREQ1_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ1_PER_LINE_DELIVERY                                                                   0x0737
#define mmHUBPREQ1_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ1_CURSOR_SETTINGS                                                                     0x0738
#define mmHUBPREQ1_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ1_REF_FREQ_TO_PIX_FREQ                                                                0x0739
#define mmHUBPREQ1_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ1_DST_Y_DELTA_DRQ_LIMIT                                                               0x073a
#define mmHUBPREQ1_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_CTRL                                                                0x073b
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_STATUS                                                              0x073c
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ1_VBLANK_PARAMETERS_5                                                                 0x073f
#define mmHUBPREQ1_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_6                                                                 0x0740
#define mmHUBPREQ1_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ1_FLIP_PARAMETERS_3                                                                   0x0741
#define mmHUBPREQ1_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_4                                                                   0x0742
#define mmHUBPREQ1_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_5                                                                   0x0743
#define mmHUBPREQ1_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_6                                                                   0x0744
#define mmHUBPREQ1_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp1_dispdec_hubpret_dispdec
// base address: 0x370
#define mmHUBPRET1_HUBPRET_CONTROL                                                                     0x0748
#define mmHUBPRET1_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET1_HUBPRET_MEM_PWR_CTRL                                                                0x0749
#define mmHUBPRET1_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET1_HUBPRET_MEM_PWR_STATUS                                                              0x074a
#define mmHUBPRET1_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL0                                                             0x074b
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL1                                                             0x074c
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET1_HUBPRET_READ_LINE0                                                                  0x074d
#define mmHUBPRET1_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET1_HUBPRET_READ_LINE1                                                                  0x074e
#define mmHUBPRET1_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET1_HUBPRET_INTERRUPT                                                                   0x074f
#define mmHUBPRET1_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET1_HUBPRET_READ_LINE_VALUE                                                             0x0750
#define mmHUBPRET1_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET1_HUBPRET_READ_LINE_STATUS                                                            0x0751
#define mmHUBPRET1_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp1_dispdec_cursor0_dispdec
// base address: 0x370
#define mmCURSOR0_1_CURSOR_CONTROL                                                                     0x0754
#define mmCURSOR0_1_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS                                                             0x0755
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x0756
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_1_CURSOR_SIZE                                                                        0x0757
#define mmCURSOR0_1_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_1_CURSOR_POSITION                                                                    0x0758
#define mmCURSOR0_1_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_1_CURSOR_HOT_SPOT                                                                    0x0759
#define mmCURSOR0_1_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_1_CURSOR_STEREO_CONTROL                                                              0x075a
#define mmCURSOR0_1_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_1_CURSOR_DST_OFFSET                                                                  0x075b
#define mmCURSOR0_1_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_1_CURSOR_MEM_PWR_CTRL                                                                0x075c
#define mmCURSOR0_1_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_1_CURSOR_MEM_PWR_STATUS                                                              0x075d
#define mmCURSOR0_1_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_1_DMDATA_ADDRESS_HIGH                                                                0x075e
#define mmCURSOR0_1_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_1_DMDATA_ADDRESS_LOW                                                                 0x075f
#define mmCURSOR0_1_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_1_DMDATA_CNTL                                                                        0x0760
#define mmCURSOR0_1_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_1_DMDATA_QOS_CNTL                                                                    0x0761
#define mmCURSOR0_1_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_1_DMDATA_STATUS                                                                      0x0762
#define mmCURSOR0_1_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_1_DMDATA_SW_CNTL                                                                     0x0763
#define mmCURSOR0_1_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_1_DMDATA_SW_DATA                                                                     0x0764
#define mmCURSOR0_1_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp1_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x1de4
#define mmDC_PERFMON6_PERFCOUNTER_CNTL                                                                 0x0779
#define mmDC_PERFMON6_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON6_PERFCOUNTER_CNTL2                                                                0x077a
#define mmDC_PERFMON6_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON6_PERFCOUNTER_STATE                                                                0x077b
#define mmDC_PERFMON6_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON6_PERFMON_CNTL                                                                     0x077c
#define mmDC_PERFMON6_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON6_PERFMON_CNTL2                                                                    0x077d
#define mmDC_PERFMON6_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC                                                          0x077e
#define mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON6_PERFMON_CVALUE_LOW                                                               0x077f
#define mmDC_PERFMON6_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON6_PERFMON_HI                                                                       0x0780
#define mmDC_PERFMON6_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON6_PERFMON_LOW                                                                      0x0781
#define mmDC_PERFMON6_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp0_dispdec_dpp_top_dispdec
// base address: 0x0
#define mmDPP_TOP0_DPP_CONTROL                                                                         0x0cc5
#define mmDPP_TOP0_DPP_CONTROL_BASE_IDX                                                                2
#define mmDPP_TOP0_DPP_SOFT_RESET                                                                      0x0cc6
#define mmDPP_TOP0_DPP_SOFT_RESET_BASE_IDX                                                             2
#define mmDPP_TOP0_DPP_CRC_VAL_R_G                                                                     0x0cc7
#define mmDPP_TOP0_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define mmDPP_TOP0_DPP_CRC_VAL_B_A                                                                     0x0cc8
#define mmDPP_TOP0_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define mmDPP_TOP0_DPP_CRC_CTRL                                                                        0x0cc9
#define mmDPP_TOP0_DPP_CRC_CTRL_BASE_IDX                                                               2
#define mmDPP_TOP0_HOST_READ_CONTROL                                                                   0x0cca
#define mmDPP_TOP0_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp0_dispdec_cnvc_cfg_dispdec
// base address: 0x0
#define mmCNVC_CFG0_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0ccf
#define mmCNVC_CFG0_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define mmCNVC_CFG0_FORMAT_CONTROL                                                                     0x0cd0
#define mmCNVC_CFG0_FORMAT_CONTROL_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_BIAS_R                                                                     0x0cd1
#define mmCNVC_CFG0_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_BIAS_G                                                                     0x0cd2
#define mmCNVC_CFG0_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_BIAS_B                                                                     0x0cd3
#define mmCNVC_CFG0_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_SCALE_R                                                                    0x0cd4
#define mmCNVC_CFG0_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define mmCNVC_CFG0_FCNV_FP_SCALE_G                                                                    0x0cd5
#define mmCNVC_CFG0_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define mmCNVC_CFG0_FCNV_FP_SCALE_B                                                                    0x0cd6
#define mmCNVC_CFG0_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define mmCNVC_CFG0_COLOR_KEYER_CONTROL                                                                0x0cd7
#define mmCNVC_CFG0_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define mmCNVC_CFG0_COLOR_KEYER_ALPHA                                                                  0x0cd8
#define mmCNVC_CFG0_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define mmCNVC_CFG0_COLOR_KEYER_RED                                                                    0x0cd9
#define mmCNVC_CFG0_COLOR_KEYER_RED_BASE_IDX                                                           2
#define mmCNVC_CFG0_COLOR_KEYER_GREEN                                                                  0x0cda
#define mmCNVC_CFG0_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define mmCNVC_CFG0_COLOR_KEYER_BLUE                                                                   0x0cdb
#define mmCNVC_CFG0_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define mmCNVC_CFG0_ALPHA_2BIT_LUT                                                                     0x0cdd
#define mmCNVC_CFG0_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define mmCNVC_CFG0_PRE_DEALPHA                                                                        0x0cde
#define mmCNVC_CFG0_PRE_DEALPHA_BASE_IDX                                                               2
#define mmCNVC_CFG0_PRE_CSC_MODE                                                                       0x0cdf
#define mmCNVC_CFG0_PRE_CSC_MODE_BASE_IDX                                                              2
#define mmCNVC_CFG0_PRE_CSC_C11_C12                                                                    0x0ce0
#define mmCNVC_CFG0_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C13_C14                                                                    0x0ce1
#define mmCNVC_CFG0_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C21_C22                                                                    0x0ce2
#define mmCNVC_CFG0_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C23_C24                                                                    0x0ce3
#define mmCNVC_CFG0_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C31_C32                                                                    0x0ce4
#define mmCNVC_CFG0_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C33_C34                                                                    0x0ce5
#define mmCNVC_CFG0_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_B_C11_C12                                                                  0x0ce6
#define mmCNVC_CFG0_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C13_C14                                                                  0x0ce7
#define mmCNVC_CFG0_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C21_C22                                                                  0x0ce8
#define mmCNVC_CFG0_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C23_C24                                                                  0x0ce9
#define mmCNVC_CFG0_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C31_C32                                                                  0x0cea
#define mmCNVC_CFG0_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C33_C34                                                                  0x0ceb
#define mmCNVC_CFG0_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define mmCNVC_CFG0_CNVC_COEF_FORMAT                                                                   0x0cec
#define mmCNVC_CFG0_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define mmCNVC_CFG0_PRE_DEGAM                                                                          0x0ced
#define mmCNVC_CFG0_PRE_DEGAM_BASE_IDX                                                                 2
#define mmCNVC_CFG0_PRE_REALPHA                                                                        0x0cee
#define mmCNVC_CFG0_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp0_dispdec_cnvc_cur_dispdec
// base address: 0x0
#define mmCNVC_CUR0_CURSOR0_CONTROL                                                                    0x0cf1
#define mmCNVC_CUR0_CURSOR0_CONTROL_BASE_IDX                                                           2
#define mmCNVC_CUR0_CURSOR0_COLOR0                                                                     0x0cf2
#define mmCNVC_CUR0_CURSOR0_COLOR0_BASE_IDX                                                            2
#define mmCNVC_CUR0_CURSOR0_COLOR1                                                                     0x0cf3
#define mmCNVC_CUR0_CURSOR0_COLOR1_BASE_IDX                                                            2
#define mmCNVC_CUR0_CURSOR0_FP_SCALE_BIAS                                                              0x0cf4
#define mmCNVC_CUR0_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp0_dispdec_dscl_dispdec
// base address: 0x0
#define mmDSCL0_SCL_COEF_RAM_TAP_SELECT                                                                0x0cf9
#define mmDSCL0_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define mmDSCL0_SCL_COEF_RAM_TAP_DATA                                                                  0x0cfa
#define mmDSCL0_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define mmDSCL0_SCL_MODE                                                                               0x0cfb
#define mmDSCL0_SCL_MODE_BASE_IDX                                                                      2
#define mmDSCL0_SCL_TAP_CONTROL                                                                        0x0cfc
#define mmDSCL0_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define mmDSCL0_DSCL_CONTROL                                                                           0x0cfd
#define mmDSCL0_DSCL_CONTROL_BASE_IDX                                                                  2
#define mmDSCL0_DSCL_2TAP_CONTROL                                                                      0x0cfe
#define mmDSCL0_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define mmDSCL0_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0cff
#define mmDSCL0_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0d00
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL0_SCL_HORZ_FILTER_INIT                                                                   0x0d01
#define mmDSCL0_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0d02
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL0_SCL_HORZ_FILTER_INIT_C                                                                 0x0d03
#define mmDSCL0_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0d04
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL0_SCL_VERT_FILTER_INIT                                                                   0x0d05
#define mmDSCL0_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT                                                               0x0d06
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0d07
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL0_SCL_VERT_FILTER_INIT_C                                                                 0x0d08
#define mmDSCL0_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0d09
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define mmDSCL0_SCL_BLACK_COLOR                                                                        0x0d0a
#define mmDSCL0_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define mmDSCL0_DSCL_UPDATE                                                                            0x0d0b
#define mmDSCL0_DSCL_UPDATE_BASE_IDX                                                                   2
#define mmDSCL0_DSCL_AUTOCAL                                                                           0x0d0c
#define mmDSCL0_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define mmDSCL0_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0d0d
#define mmDSCL0_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmDSCL0_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0d0e
#define mmDSCL0_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmDSCL0_OTG_H_BLANK                                                                            0x0d0f
#define mmDSCL0_OTG_H_BLANK_BASE_IDX                                                                   2
#define mmDSCL0_OTG_V_BLANK                                                                            0x0d10
#define mmDSCL0_OTG_V_BLANK_BASE_IDX                                                                   2
#define mmDSCL0_RECOUT_START                                                                           0x0d11
#define mmDSCL0_RECOUT_START_BASE_IDX                                                                  2
#define mmDSCL0_RECOUT_SIZE                                                                            0x0d12
#define mmDSCL0_RECOUT_SIZE_BASE_IDX                                                                   2
#define mmDSCL0_MPC_SIZE                                                                               0x0d13
#define mmDSCL0_MPC_SIZE_BASE_IDX                                                                      2
#define mmDSCL0_LB_DATA_FORMAT                                                                         0x0d14
#define mmDSCL0_LB_DATA_FORMAT_BASE_IDX                                                                2
#define mmDSCL0_LB_MEMORY_CTRL                                                                         0x0d15
#define mmDSCL0_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define mmDSCL0_LB_V_COUNTER                                                                           0x0d16
#define mmDSCL0_LB_V_COUNTER_BASE_IDX                                                                  2
#define mmDSCL0_DSCL_MEM_PWR_CTRL                                                                      0x0d17
#define mmDSCL0_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDSCL0_DSCL_MEM_PWR_STATUS                                                                    0x0d18
#define mmDSCL0_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDSCL0_OBUF_CONTROL                                                                           0x0d19
#define mmDSCL0_OBUF_CONTROL_BASE_IDX                                                                  2
#define mmDSCL0_OBUF_MEM_PWR_CTRL                                                                      0x0d1a
#define mmDSCL0_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp0_dispdec_cm_dispdec
// base address: 0x0
#define mmCM0_CM_CONTROL                                                                               0x0d20
#define mmCM0_CM_CONTROL_BASE_IDX                                                                      2
#define mmCM0_CM_POST_CSC_CONTROL                                                                      0x0d21
#define mmCM0_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C11_C12                                                                      0x0d22
#define mmCM0_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C13_C14                                                                      0x0d23
#define mmCM0_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C21_C22                                                                      0x0d24
#define mmCM0_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C23_C24                                                                      0x0d25
#define mmCM0_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C31_C32                                                                      0x0d26
#define mmCM0_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C33_C34                                                                      0x0d27
#define mmCM0_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_B_C11_C12                                                                    0x0d28
#define mmCM0_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C13_C14                                                                    0x0d29
#define mmCM0_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C21_C22                                                                    0x0d2a
#define mmCM0_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C23_C24                                                                    0x0d2b
#define mmCM0_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C31_C32                                                                    0x0d2c
#define mmCM0_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C33_C34                                                                    0x0d2d
#define mmCM0_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define mmCM0_CM_GAMUT_REMAP_CONTROL                                                                   0x0d2e
#define mmCM0_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C11_C12                                                                   0x0d2f
#define mmCM0_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C13_C14                                                                   0x0d30
#define mmCM0_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C21_C22                                                                   0x0d31
#define mmCM0_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C23_C24                                                                   0x0d32
#define mmCM0_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C31_C32                                                                   0x0d33
#define mmCM0_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C33_C34                                                                   0x0d34
#define mmCM0_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_B_C11_C12                                                                 0x0d35
#define mmCM0_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C13_C14                                                                 0x0d36
#define mmCM0_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C21_C22                                                                 0x0d37
#define mmCM0_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C23_C24                                                                 0x0d38
#define mmCM0_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C31_C32                                                                 0x0d39
#define mmCM0_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C33_C34                                                                 0x0d3a
#define mmCM0_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define mmCM0_CM_BIAS_CR_R                                                                             0x0d3b
#define mmCM0_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define mmCM0_CM_BIAS_Y_G_CB_B                                                                         0x0d3c
#define mmCM0_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define mmCM0_CM_GAMCOR_CONTROL                                                                        0x0d3d
#define mmCM0_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define mmCM0_CM_GAMCOR_LUT_INDEX                                                                      0x0d3e
#define mmCM0_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define mmCM0_CM_GAMCOR_LUT_DATA                                                                       0x0d3f
#define mmCM0_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define mmCM0_CM_GAMCOR_LUT_CONTROL                                                                    0x0d40
#define mmCM0_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x0d41
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x0d42
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x0d43
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x0d44
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x0d45
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x0d46
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x0d47
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x0d48
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x0d49
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x0d4a
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x0d4b
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x0d4c
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x0d4d
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x0d4e
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x0d4f
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x0d50
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x0d51
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x0d52
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMA_REGION_0_1                                                                0x0d53
#define mmCM0_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_2_3                                                                0x0d54
#define mmCM0_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_4_5                                                                0x0d55
#define mmCM0_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_6_7                                                                0x0d56
#define mmCM0_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_8_9                                                                0x0d57
#define mmCM0_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_10_11                                                              0x0d58
#define mmCM0_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_12_13                                                              0x0d59
#define mmCM0_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_14_15                                                              0x0d5a
#define mmCM0_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_16_17                                                              0x0d5b
#define mmCM0_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_18_19                                                              0x0d5c
#define mmCM0_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_20_21                                                              0x0d5d
#define mmCM0_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_22_23                                                              0x0d5e
#define mmCM0_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_24_25                                                              0x0d5f
#define mmCM0_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_26_27                                                              0x0d60
#define mmCM0_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_28_29                                                              0x0d61
#define mmCM0_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_30_31                                                              0x0d62
#define mmCM0_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_32_33                                                              0x0d63
#define mmCM0_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x0d64
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x0d65
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x0d66
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x0d67
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x0d68
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x0d69
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x0d6a
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x0d6b
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x0d6c
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x0d6d
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x0d6e
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x0d6f
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x0d70
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x0d71
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x0d72
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x0d73
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x0d74
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x0d75
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMB_REGION_0_1                                                                0x0d76
#define mmCM0_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_2_3                                                                0x0d77
#define mmCM0_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_4_5                                                                0x0d78
#define mmCM0_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_6_7                                                                0x0d79
#define mmCM0_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_8_9                                                                0x0d7a
#define mmCM0_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_10_11                                                              0x0d7b
#define mmCM0_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_12_13                                                              0x0d7c
#define mmCM0_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_14_15                                                              0x0d7d
#define mmCM0_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_16_17                                                              0x0d7e
#define mmCM0_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_18_19                                                              0x0d7f
#define mmCM0_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_20_21                                                              0x0d80
#define mmCM0_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_22_23                                                              0x0d81
#define mmCM0_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_24_25                                                              0x0d82
#define mmCM0_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_26_27                                                              0x0d83
#define mmCM0_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_28_29                                                              0x0d84
#define mmCM0_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_30_31                                                              0x0d85
#define mmCM0_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_32_33                                                              0x0d86
#define mmCM0_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_CONTROL                                                                       0x0d87
#define mmCM0_CM_BLNDGAM_CONTROL_BASE_IDX                                                              2
#define mmCM0_CM_BLNDGAM_LUT_INDEX                                                                     0x0d88
#define mmCM0_CM_BLNDGAM_LUT_INDEX_BASE_IDX                                                            2
#define mmCM0_CM_BLNDGAM_LUT_DATA                                                                      0x0d89
#define mmCM0_CM_BLNDGAM_LUT_DATA_BASE_IDX                                                             2
#define mmCM0_CM_BLNDGAM_LUT_CONTROL                                                                   0x0d8a
#define mmCM0_CM_BLNDGAM_LUT_CONTROL_BASE_IDX                                                          2
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_B                                                             0x0d8b
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_B_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_G                                                             0x0d8c
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_G_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_R                                                             0x0d8d
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_R_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B                                                       0x0d8e
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G                                                       0x0d8f
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R                                                       0x0d90
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_B                                                        0x0d91
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_G                                                        0x0d92
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_R                                                        0x0d93
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_B                                                              0x0d94
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_B                                                              0x0d95
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_G                                                              0x0d96
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_G                                                              0x0d97
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_R                                                              0x0d98
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_R                                                              0x0d99
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_B                                                                 0x0d9a
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_B_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_G                                                                 0x0d9b
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_G_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_R                                                                 0x0d9c
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_R_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_0_1                                                               0x0d9d
#define mmCM0_CM_BLNDGAM_RAMA_REGION_0_1_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_2_3                                                               0x0d9e
#define mmCM0_CM_BLNDGAM_RAMA_REGION_2_3_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_4_5                                                               0x0d9f
#define mmCM0_CM_BLNDGAM_RAMA_REGION_4_5_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_6_7                                                               0x0da0
#define mmCM0_CM_BLNDGAM_RAMA_REGION_6_7_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_8_9                                                               0x0da1
#define mmCM0_CM_BLNDGAM_RAMA_REGION_8_9_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_10_11                                                             0x0da2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_10_11_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_12_13                                                             0x0da3
#define mmCM0_CM_BLNDGAM_RAMA_REGION_12_13_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_14_15                                                             0x0da4
#define mmCM0_CM_BLNDGAM_RAMA_REGION_14_15_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_16_17                                                             0x0da5
#define mmCM0_CM_BLNDGAM_RAMA_REGION_16_17_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_18_19                                                             0x0da6
#define mmCM0_CM_BLNDGAM_RAMA_REGION_18_19_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_20_21                                                             0x0da7
#define mmCM0_CM_BLNDGAM_RAMA_REGION_20_21_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_22_23                                                             0x0da8
#define mmCM0_CM_BLNDGAM_RAMA_REGION_22_23_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_24_25                                                             0x0da9
#define mmCM0_CM_BLNDGAM_RAMA_REGION_24_25_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_26_27                                                             0x0daa
#define mmCM0_CM_BLNDGAM_RAMA_REGION_26_27_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_28_29                                                             0x0dab
#define mmCM0_CM_BLNDGAM_RAMA_REGION_28_29_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_30_31                                                             0x0dac
#define mmCM0_CM_BLNDGAM_RAMA_REGION_30_31_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_32_33                                                             0x0dad
#define mmCM0_CM_BLNDGAM_RAMA_REGION_32_33_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_B                                                             0x0dae
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_B_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_G                                                             0x0daf
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_G_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_R                                                             0x0db0
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_R_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B                                                       0x0db1
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G                                                       0x0db2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R                                                       0x0db3
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_B                                                        0x0db4
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_G                                                        0x0db5
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_R                                                        0x0db6
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_B                                                              0x0db7
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_B                                                              0x0db8
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_G                                                              0x0db9
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_G                                                              0x0dba
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_R                                                              0x0dbb
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_R                                                              0x0dbc
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_B                                                                 0x0dbd
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_B_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_G                                                                 0x0dbe
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_G_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_R                                                                 0x0dbf
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_R_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_0_1                                                               0x0dc0
#define mmCM0_CM_BLNDGAM_RAMB_REGION_0_1_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_2_3                                                               0x0dc1
#define mmCM0_CM_BLNDGAM_RAMB_REGION_2_3_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_4_5                                                               0x0dc2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_4_5_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_6_7                                                               0x0dc3
#define mmCM0_CM_BLNDGAM_RAMB_REGION_6_7_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_8_9                                                               0x0dc4
#define mmCM0_CM_BLNDGAM_RAMB_REGION_8_9_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_10_11                                                             0x0dc5
#define mmCM0_CM_BLNDGAM_RAMB_REGION_10_11_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_12_13                                                             0x0dc6
#define mmCM0_CM_BLNDGAM_RAMB_REGION_12_13_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_14_15                                                             0x0dc7
#define mmCM0_CM_BLNDGAM_RAMB_REGION_14_15_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_16_17                                                             0x0dc8
#define mmCM0_CM_BLNDGAM_RAMB_REGION_16_17_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_18_19                                                             0x0dc9
#define mmCM0_CM_BLNDGAM_RAMB_REGION_18_19_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_20_21                                                             0x0dca
#define mmCM0_CM_BLNDGAM_RAMB_REGION_20_21_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_22_23                                                             0x0dcb
#define mmCM0_CM_BLNDGAM_RAMB_REGION_22_23_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_24_25                                                             0x0dcc
#define mmCM0_CM_BLNDGAM_RAMB_REGION_24_25_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_26_27                                                             0x0dcd
#define mmCM0_CM_BLNDGAM_RAMB_REGION_26_27_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_28_29                                                             0x0dce
#define mmCM0_CM_BLNDGAM_RAMB_REGION_28_29_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_30_31                                                             0x0dcf
#define mmCM0_CM_BLNDGAM_RAMB_REGION_30_31_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_32_33                                                             0x0dd0
#define mmCM0_CM_BLNDGAM_RAMB_REGION_32_33_BASE_IDX                                                    2
#define mmCM0_CM_HDR_MULT_COEF                                                                         0x0dd1
#define mmCM0_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define mmCM0_CM_MEM_PWR_CTRL                                                                          0x0dd2
#define mmCM0_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmCM0_CM_MEM_PWR_STATUS                                                                        0x0dd3
#define mmCM0_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmCM0_CM_DEALPHA                                                                               0x0dd5
#define mmCM0_CM_DEALPHA_BASE_IDX                                                                      2
#define mmCM0_CM_COEF_FORMAT                                                                           0x0dd6
#define mmCM0_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define mmCM0_CM_SHAPER_CONTROL                                                                        0x0dd7
#define mmCM0_CM_SHAPER_CONTROL_BASE_IDX                                                               2
#define mmCM0_CM_SHAPER_OFFSET_R                                                                       0x0dd8
#define mmCM0_CM_SHAPER_OFFSET_R_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_OFFSET_G                                                                       0x0dd9
#define mmCM0_CM_SHAPER_OFFSET_G_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_OFFSET_B                                                                       0x0dda
#define mmCM0_CM_SHAPER_OFFSET_B_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_SCALE_R                                                                        0x0ddb
#define mmCM0_CM_SHAPER_SCALE_R_BASE_IDX                                                               2
#define mmCM0_CM_SHAPER_SCALE_G_B                                                                      0x0ddc
#define mmCM0_CM_SHAPER_SCALE_G_B_BASE_IDX                                                             2
#define mmCM0_CM_SHAPER_LUT_INDEX                                                                      0x0ddd
#define mmCM0_CM_SHAPER_LUT_INDEX_BASE_IDX                                                             2
#define mmCM0_CM_SHAPER_LUT_DATA                                                                       0x0dde
#define mmCM0_CM_SHAPER_LUT_DATA_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_LUT_WRITE_EN_MASK                                                              0x0ddf
#define mmCM0_CM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_B                                                              0x0de0
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_G                                                              0x0de1
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_R                                                              0x0de2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_B                                                                0x0de3
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_G                                                                0x0de4
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_R                                                                0x0de5
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_0_1                                                                0x0de6
#define mmCM0_CM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_2_3                                                                0x0de7
#define mmCM0_CM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_4_5                                                                0x0de8
#define mmCM0_CM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_6_7                                                                0x0de9
#define mmCM0_CM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_8_9                                                                0x0dea
#define mmCM0_CM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_10_11                                                              0x0deb
#define mmCM0_CM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_12_13                                                              0x0dec
#define mmCM0_CM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_14_15                                                              0x0ded
#define mmCM0_CM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_16_17                                                              0x0dee
#define mmCM0_CM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_18_19                                                              0x0def
#define mmCM0_CM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_20_21                                                              0x0df0
#define mmCM0_CM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_22_23                                                              0x0df1
#define mmCM0_CM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_24_25                                                              0x0df2
#define mmCM0_CM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_26_27                                                              0x0df3
#define mmCM0_CM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_28_29                                                              0x0df4
#define mmCM0_CM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_30_31                                                              0x0df5
#define mmCM0_CM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_32_33                                                              0x0df6
#define mmCM0_CM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_B                                                              0x0df7
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_G                                                              0x0df8
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_R                                                              0x0df9
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_B                                                                0x0dfa
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_G                                                                0x0dfb
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_R                                                                0x0dfc
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_0_1                                                                0x0dfd
#define mmCM0_CM_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_2_3                                                                0x0dfe
#define mmCM0_CM_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_4_5                                                                0x0dff
#define mmCM0_CM_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_6_7                                                                0x0e00
#define mmCM0_CM_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_8_9                                                                0x0e01
#define mmCM0_CM_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_10_11                                                              0x0e02
#define mmCM0_CM_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_12_13                                                              0x0e03
#define mmCM0_CM_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_14_15                                                              0x0e04
#define mmCM0_CM_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_16_17                                                              0x0e05
#define mmCM0_CM_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_18_19                                                              0x0e06
#define mmCM0_CM_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_20_21                                                              0x0e07
#define mmCM0_CM_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_22_23                                                              0x0e08
#define mmCM0_CM_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_24_25                                                              0x0e09
#define mmCM0_CM_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_26_27                                                              0x0e0a
#define mmCM0_CM_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_28_29                                                              0x0e0b
#define mmCM0_CM_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_30_31                                                              0x0e0c
#define mmCM0_CM_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_32_33                                                              0x0e0d
#define mmCM0_CM_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_MEM_PWR_CTRL2                                                                         0x0e0e
#define mmCM0_CM_MEM_PWR_CTRL2_BASE_IDX                                                                2
#define mmCM0_CM_MEM_PWR_STATUS2                                                                       0x0e0f
#define mmCM0_CM_MEM_PWR_STATUS2_BASE_IDX                                                              2
#define mmCM0_CM_3DLUT_MODE                                                                            0x0e10
#define mmCM0_CM_3DLUT_MODE_BASE_IDX                                                                   2
#define mmCM0_CM_3DLUT_INDEX                                                                           0x0e11
#define mmCM0_CM_3DLUT_INDEX_BASE_IDX                                                                  2
#define mmCM0_CM_3DLUT_DATA                                                                            0x0e12
#define mmCM0_CM_3DLUT_DATA_BASE_IDX                                                                   2
#define mmCM0_CM_3DLUT_DATA_30BIT                                                                      0x0e13
#define mmCM0_CM_3DLUT_DATA_30BIT_BASE_IDX                                                             2
#define mmCM0_CM_3DLUT_READ_WRITE_CONTROL                                                              0x0e14
#define mmCM0_CM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                     2
#define mmCM0_CM_3DLUT_OUT_NORM_FACTOR                                                                 0x0e15
#define mmCM0_CM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                        2
#define mmCM0_CM_3DLUT_OUT_OFFSET_R                                                                    0x0e16
#define mmCM0_CM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                           2
#define mmCM0_CM_3DLUT_OUT_OFFSET_G                                                                    0x0e17
#define mmCM0_CM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                           2
#define mmCM0_CM_3DLUT_OUT_OFFSET_B                                                                    0x0e18
#define mmCM0_CM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                           2


// addressBlock: dce_dc_dpp0_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x3890
#define mmDC_PERFMON7_PERFCOUNTER_CNTL                                                                 0x0e24
#define mmDC_PERFMON7_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON7_PERFCOUNTER_CNTL2                                                                0x0e25
#define mmDC_PERFMON7_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON7_PERFCOUNTER_STATE                                                                0x0e26
#define mmDC_PERFMON7_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON7_PERFMON_CNTL                                                                     0x0e27
#define mmDC_PERFMON7_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON7_PERFMON_CNTL2                                                                    0x0e28
#define mmDC_PERFMON7_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC                                                          0x0e29
#define mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON7_PERFMON_CVALUE_LOW                                                               0x0e2a
#define mmDC_PERFMON7_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON7_PERFMON_HI                                                                       0x0e2b
#define mmDC_PERFMON7_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON7_PERFMON_LOW                                                                      0x0e2c
#define mmDC_PERFMON7_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp1_dispdec_dpp_top_dispdec
// base address: 0x5ac
#define mmDPP_TOP1_DPP_CONTROL                                                                         0x0e30
#define mmDPP_TOP1_DPP_CONTROL_BASE_IDX                                                                2
#define mmDPP_TOP1_DPP_SOFT_RESET                                                                      0x0e31
#define mmDPP_TOP1_DPP_SOFT_RESET_BASE_IDX                                                             2
#define mmDPP_TOP1_DPP_CRC_VAL_R_G                                                                     0x0e32
#define mmDPP_TOP1_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define mmDPP_TOP1_DPP_CRC_VAL_B_A                                                                     0x0e33
#define mmDPP_TOP1_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define mmDPP_TOP1_DPP_CRC_CTRL                                                                        0x0e34
#define mmDPP_TOP1_DPP_CRC_CTRL_BASE_IDX                                                               2
#define mmDPP_TOP1_HOST_READ_CONTROL                                                                   0x0e35
#define mmDPP_TOP1_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp1_dispdec_cnvc_cfg_dispdec
// base address: 0x5ac
#define mmCNVC_CFG1_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0e3a
#define mmCNVC_CFG1_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define mmCNVC_CFG1_FORMAT_CONTROL                                                                     0x0e3b
#define mmCNVC_CFG1_FORMAT_CONTROL_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_BIAS_R                                                                     0x0e3c
#define mmCNVC_CFG1_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_BIAS_G                                                                     0x0e3d
#define mmCNVC_CFG1_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_BIAS_B                                                                     0x0e3e
#define mmCNVC_CFG1_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_SCALE_R                                                                    0x0e3f
#define mmCNVC_CFG1_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define mmCNVC_CFG1_FCNV_FP_SCALE_G                                                                    0x0e40
#define mmCNVC_CFG1_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define mmCNVC_CFG1_FCNV_FP_SCALE_B                                                                    0x0e41
#define mmCNVC_CFG1_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define mmCNVC_CFG1_COLOR_KEYER_CONTROL                                                                0x0e42
#define mmCNVC_CFG1_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define mmCNVC_CFG1_COLOR_KEYER_ALPHA                                                                  0x0e43
#define mmCNVC_CFG1_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define mmCNVC_CFG1_COLOR_KEYER_RED                                                                    0x0e44
#define mmCNVC_CFG1_COLOR_KEYER_RED_BASE_IDX                                                           2
#define mmCNVC_CFG1_COLOR_KEYER_GREEN                                                                  0x0e45
#define mmCNVC_CFG1_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define mmCNVC_CFG1_COLOR_KEYER_BLUE                                                                   0x0e46
#define mmCNVC_CFG1_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define mmCNVC_CFG1_ALPHA_2BIT_LUT                                                                     0x0e48
#define mmCNVC_CFG1_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define mmCNVC_CFG1_PRE_DEALPHA                                                                        0x0e49
#define mmCNVC_CFG1_PRE_DEALPHA_BASE_IDX                                                               2
#define mmCNVC_CFG1_PRE_CSC_MODE                                                                       0x0e4a
#define mmCNVC_CFG1_PRE_CSC_MODE_BASE_IDX                                                              2
#define mmCNVC_CFG1_PRE_CSC_C11_C12                                                                    0x0e4b
#define mmCNVC_CFG1_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C13_C14                                                                    0x0e4c
#define mmCNVC_CFG1_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C21_C22                                                                    0x0e4d
#define mmCNVC_CFG1_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C23_C24                                                                    0x0e4e
#define mmCNVC_CFG1_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C31_C32                                                                    0x0e4f
#define mmCNVC_CFG1_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C33_C34                                                                    0x0e50
#define mmCNVC_CFG1_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_B_C11_C12                                                                  0x0e51
#define mmCNVC_CFG1_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C13_C14                                                                  0x0e52
#define mmCNVC_CFG1_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C21_C22                                                                  0x0e53
#define mmCNVC_CFG1_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C23_C24                                                                  0x0e54
#define mmCNVC_CFG1_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C31_C32                                                                  0x0e55
#define mmCNVC_CFG1_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C33_C34                                                                  0x0e56
#define mmCNVC_CFG1_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define mmCNVC_CFG1_CNVC_COEF_FORMAT                                                                   0x0e57
#define mmCNVC_CFG1_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define mmCNVC_CFG1_PRE_DEGAM                                                                          0x0e58
#define mmCNVC_CFG1_PRE_DEGAM_BASE_IDX                                                                 2
#define mmCNVC_CFG1_PRE_REALPHA                                                                        0x0e59
#define mmCNVC_CFG1_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp1_dispdec_cnvc_cur_dispdec
// base address: 0x5ac
#define mmCNVC_CUR1_CURSOR0_CONTROL                                                                    0x0e5c
#define mmCNVC_CUR1_CURSOR0_CONTROL_BASE_IDX                                                           2
#define mmCNVC_CUR1_CURSOR0_COLOR0                                                                     0x0e5d
#define mmCNVC_CUR1_CURSOR0_COLOR0_BASE_IDX                                                            2
#define mmCNVC_CUR1_CURSOR0_COLOR1                                                                     0x0e5e
#define mmCNVC_CUR1_CURSOR0_COLOR1_BASE_IDX                                                            2
#define mmCNVC_CUR1_CURSOR0_FP_SCALE_BIAS                                                              0x0e5f
#define mmCNVC_CUR1_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp1_dispdec_dscl_dispdec
// base address: 0x5ac
#define mmDSCL1_SCL_COEF_RAM_TAP_SELECT                                                                0x0e64
#define mmDSCL1_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define mmDSCL1_SCL_COEF_RAM_TAP_DATA                                                                  0x0e65
#define mmDSCL1_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define mmDSCL1_SCL_MODE                                                                               0x0e66
#define mmDSCL1_SCL_MODE_BASE_IDX                                                                      2
#define mmDSCL1_SCL_TAP_CONTROL                                                                        0x0e67
#define mmDSCL1_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define mmDSCL1_DSCL_CONTROL                                                                           0x0e68
#define mmDSCL1_DSCL_CONTROL_BASE_IDX                                                                  2
#define mmDSCL1_DSCL_2TAP_CONTROL                                                                      0x0e69
#define mmDSCL1_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define mmDSCL1_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0e6a
#define mmDSCL1_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0e6b
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL1_SCL_HORZ_FILTER_INIT                                                                   0x0e6c
#define mmDSCL1_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0e6d
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL1_SCL_HORZ_FILTER_INIT_C                                                                 0x0e6e
#define mmDSCL1_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0e6f
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL1_SCL_VERT_FILTER_INIT                                                                   0x0e70
#define mmDSCL1_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT                                                               0x0e71
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0e72
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL1_SCL_VERT_FILTER_INIT_C                                                                 0x0e73
#define mmDSCL1_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0e74
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define mmDSCL1_SCL_BLACK_COLOR                                                                        0x0e75
#define mmDSCL1_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define mmDSCL1_DSCL_UPDATE                                                                            0x0e76
#define mmDSCL1_DSCL_UPDATE_BASE_IDX                                                                   2
#define mmDSCL1_DSCL_AUTOCAL                                                                           0x0e77
#define mmDSCL1_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define mmDSCL1_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0e78
#define mmDSCL1_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmDSCL1_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0e79
#define mmDSCL1_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmDSCL1_OTG_H_BLANK                                                                            0x0e7a
#define mmDSCL1_OTG_H_BLANK_BASE_IDX                                                                   2
#define mmDSCL1_OTG_V_BLANK                                                                            0x0e7b
#define mmDSCL1_OTG_V_BLANK_BASE_IDX                                                                   2
#define mmDSCL1_RECOUT_START                                                                           0x0e7c
#define mmDSCL1_RECOUT_START_BASE_IDX                                                                  2
#define mmDSCL1_RECOUT_SIZE                                                                            0x0e7d
#define mmDSCL1_RECOUT_SIZE_BASE_IDX                                                                   2
#define mmDSCL1_MPC_SIZE                                                                               0x0e7e
#define mmDSCL1_MPC_SIZE_BASE_IDX                                                                      2
#define mmDSCL1_LB_DATA_FORMAT                                                                         0x0e7f
#define mmDSCL1_LB_DATA_FORMAT_BASE_IDX                                                                2
#define mmDSCL1_LB_MEMORY_CTRL                                                                         0x0e80
#define mmDSCL1_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define mmDSCL1_LB_V_COUNTER                                                                           0x0e81
#define mmDSCL1_LB_V_COUNTER_BASE_IDX                                                                  2
#define mmDSCL1_DSCL_MEM_PWR_CTRL                                                                      0x0e82
#define mmDSCL1_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDSCL1_DSCL_MEM_PWR_STATUS                                                                    0x0e83
#define mmDSCL1_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDSCL1_OBUF_CONTROL                                                                           0x0e84
#define mmDSCL1_OBUF_CONTROL_BASE_IDX                                                                  2
#define mmDSCL1_OBUF_MEM_PWR_CTRL                                                                      0x0e85
#define mmDSCL1_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp1_dispdec_cm_dispdec
// base address: 0x5ac
#define mmCM1_CM_CONTROL                                                                               0x0e8b
#define mmCM1_CM_CONTROL_BASE_IDX                                                                      2
#define mmCM1_CM_POST_CSC_CONTROL                                                                      0x0e8c
#define mmCM1_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C11_C12                                                                      0x0e8d
#define mmCM1_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C13_C14                                                                      0x0e8e
#define mmCM1_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C21_C22                                                                      0x0e8f
#define mmCM1_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C23_C24                                                                      0x0e90
#define mmCM1_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C31_C32                                                                      0x0e91
#define mmCM1_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C33_C34                                                                      0x0e92
#define mmCM1_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_B_C11_C12                                                                    0x0e93
#define mmCM1_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C13_C14                                                                    0x0e94
#define mmCM1_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C21_C22                                                                    0x0e95
#define mmCM1_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C23_C24                                                                    0x0e96
#define mmCM1_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C31_C32                                                                    0x0e97
#define mmCM1_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C33_C34                                                                    0x0e98
#define mmCM1_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define mmCM1_CM_GAMUT_REMAP_CONTROL                                                                   0x0e99
#define mmCM1_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C11_C12                                                                   0x0e9a
#define mmCM1_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C13_C14                                                                   0x0e9b
#define mmCM1_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C21_C22                                                                   0x0e9c
#define mmCM1_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C23_C24                                                                   0x0e9d
#define mmCM1_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C31_C32                                                                   0x0e9e
#define mmCM1_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C33_C34                                                                   0x0e9f
#define mmCM1_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_B_C11_C12                                                                 0x0ea0
#define mmCM1_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C13_C14                                                                 0x0ea1
#define mmCM1_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C21_C22                                                                 0x0ea2
#define mmCM1_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C23_C24                                                                 0x0ea3
#define mmCM1_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C31_C32                                                                 0x0ea4
#define mmCM1_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C33_C34                                                                 0x0ea5
#define mmCM1_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define mmCM1_CM_BIAS_CR_R                                                                             0x0ea6
#define mmCM1_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define mmCM1_CM_BIAS_Y_G_CB_B                                                                         0x0ea7
#define mmCM1_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define mmCM1_CM_GAMCOR_CONTROL                                                                        0x0ea8
#define mmCM1_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define mmCM1_CM_GAMCOR_LUT_INDEX                                                                      0x0ea9
#define mmCM1_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define mmCM1_CM_GAMCOR_LUT_DATA                                                                       0x0eaa
#define mmCM1_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define mmCM1_CM_GAMCOR_LUT_CONTROL                                                                    0x0eab
#define mmCM1_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x0eac
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x0ead
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x0eae
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x0eaf
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x0eb0
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x0eb1
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x0eb2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x0eb3
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x0eb4
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x0eb5
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x0eb6
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x0eb7
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x0eb8
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x0eb9
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x0eba
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x0ebb
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x0ebc
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x0ebd
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMA_REGION_0_1                                                                0x0ebe
#define mmCM1_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_2_3                                                                0x0ebf
#define mmCM1_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_4_5                                                                0x0ec0
#define mmCM1_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_6_7                                                                0x0ec1
#define mmCM1_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_8_9                                                                0x0ec2
#define mmCM1_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_10_11                                                              0x0ec3
#define mmCM1_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_12_13                                                              0x0ec4
#define mmCM1_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_14_15                                                              0x0ec5
#define mmCM1_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_16_17                                                              0x0ec6
#define mmCM1_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_18_19                                                              0x0ec7
#define mmCM1_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_20_21                                                              0x0ec8
#define mmCM1_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_22_23                                                              0x0ec9
#define mmCM1_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_24_25                                                              0x0eca
#define mmCM1_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_26_27                                                              0x0ecb
#define mmCM1_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_28_29                                                              0x0ecc
#define mmCM1_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_30_31                                                              0x0ecd
#define mmCM1_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_32_33                                                              0x0ece
#define mmCM1_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x0ecf
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x0ed0
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x0ed1
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x0ed2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x0ed3
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x0ed4
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x0ed5
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x0ed6
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x0ed7
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x0ed8
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x0ed9
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x0eda
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x0edb
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x0edc
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x0edd
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x0ede
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x0edf
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x0ee0
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMB_REGION_0_1                                                                0x0ee1
#define mmCM1_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_2_3                                                                0x0ee2
#define mmCM1_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_4_5                                                                0x0ee3
#define mmCM1_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_6_7                                                                0x0ee4
#define mmCM1_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_8_9                                                                0x0ee5
#define mmCM1_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_10_11                                                              0x0ee6
#define mmCM1_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_12_13                                                              0x0ee7
#define mmCM1_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_14_15                                                              0x0ee8
#define mmCM1_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_16_17                                                              0x0ee9
#define mmCM1_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_18_19                                                              0x0eea
#define mmCM1_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_20_21                                                              0x0eeb
#define mmCM1_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_22_23                                                              0x0eec
#define mmCM1_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_24_25                                                              0x0eed
#define mmCM1_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_26_27                                                              0x0eee
#define mmCM1_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_28_29                                                              0x0eef
#define mmCM1_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_30_31                                                              0x0ef0
#define mmCM1_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_32_33                                                              0x0ef1
#define mmCM1_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_CONTROL                                                                       0x0ef2
#define mmCM1_CM_BLNDGAM_CONTROL_BASE_IDX                                                              2
#define mmCM1_CM_BLNDGAM_LUT_INDEX                                                                     0x0ef3
#define mmCM1_CM_BLNDGAM_LUT_INDEX_BASE_IDX                                                            2
#define mmCM1_CM_BLNDGAM_LUT_DATA                                                                      0x0ef4
#define mmCM1_CM_BLNDGAM_LUT_DATA_BASE_IDX                                                             2
#define mmCM1_CM_BLNDGAM_LUT_CONTROL                                                                   0x0ef5
#define mmCM1_CM_BLNDGAM_LUT_CONTROL_BASE_IDX                                                          2
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_B                                                             0x0ef6
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_B_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_G                                                             0x0ef7
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_G_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_R                                                             0x0ef8
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_R_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B                                                       0x0ef9
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G                                                       0x0efa
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R                                                       0x0efb
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_B                                                        0x0efc
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_G                                                        0x0efd
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_R                                                        0x0efe
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_B                                                              0x0eff
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_B                                                              0x0f00
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_G                                                              0x0f01
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_G                                                              0x0f02
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_R                                                              0x0f03
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_R                                                              0x0f04
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_B                                                                 0x0f05
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_B_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_G                                                                 0x0f06
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_G_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_R                                                                 0x0f07
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_R_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_0_1                                                               0x0f08
#define mmCM1_CM_BLNDGAM_RAMA_REGION_0_1_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_2_3                                                               0x0f09
#define mmCM1_CM_BLNDGAM_RAMA_REGION_2_3_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_4_5                                                               0x0f0a
#define mmCM1_CM_BLNDGAM_RAMA_REGION_4_5_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_6_7                                                               0x0f0b
#define mmCM1_CM_BLNDGAM_RAMA_REGION_6_7_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_8_9                                                               0x0f0c
#define mmCM1_CM_BLNDGAM_RAMA_REGION_8_9_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_10_11                                                             0x0f0d
#define mmCM1_CM_BLNDGAM_RAMA_REGION_10_11_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_12_13                                                             0x0f0e
#define mmCM1_CM_BLNDGAM_RAMA_REGION_12_13_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_14_15                                                             0x0f0f
#define mmCM1_CM_BLNDGAM_RAMA_REGION_14_15_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_16_17                                                             0x0f10
#define mmCM1_CM_BLNDGAM_RAMA_REGION_16_17_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_18_19                                                             0x0f11
#define mmCM1_CM_BLNDGAM_RAMA_REGION_18_19_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_20_21                                                             0x0f12
#define mmCM1_CM_BLNDGAM_RAMA_REGION_20_21_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_22_23                                                             0x0f13
#define mmCM1_CM_BLNDGAM_RAMA_REGION_22_23_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_24_25                                                             0x0f14
#define mmCM1_CM_BLNDGAM_RAMA_REGION_24_25_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_26_27                                                             0x0f15
#define mmCM1_CM_BLNDGAM_RAMA_REGION_26_27_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_28_29                                                             0x0f16
#define mmCM1_CM_BLNDGAM_RAMA_REGION_28_29_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_30_31                                                             0x0f17
#define mmCM1_CM_BLNDGAM_RAMA_REGION_30_31_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_32_33                                                             0x0f18
#define mmCM1_CM_BLNDGAM_RAMA_REGION_32_33_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_B                                                             0x0f19
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_B_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_G                                                             0x0f1a
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_G_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_R                                                             0x0f1b
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_R_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B                                                       0x0f1c
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G                                                       0x0f1d
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R                                                       0x0f1e
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_B                                                        0x0f1f
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_G                                                        0x0f20
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_R                                                        0x0f21
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_B                                                              0x0f22
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_B                                                              0x0f23
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_G                                                              0x0f24
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_G                                                              0x0f25
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_R                                                              0x0f26
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_R                                                              0x0f27
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_B                                                                 0x0f28
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_B_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_G                                                                 0x0f29
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_G_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_R                                                                 0x0f2a
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_R_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_0_1                                                               0x0f2b
#define mmCM1_CM_BLNDGAM_RAMB_REGION_0_1_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_2_3                                                               0x0f2c
#define mmCM1_CM_BLNDGAM_RAMB_REGION_2_3_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_4_5                                                               0x0f2d
#define mmCM1_CM_BLNDGAM_RAMB_REGION_4_5_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_6_7                                                               0x0f2e
#define mmCM1_CM_BLNDGAM_RAMB_REGION_6_7_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_8_9                                                               0x0f2f
#define mmCM1_CM_BLNDGAM_RAMB_REGION_8_9_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_10_11                                                             0x0f30
#define mmCM1_CM_BLNDGAM_RAMB_REGION_10_11_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_12_13                                                             0x0f31
#define mmCM1_CM_BLNDGAM_RAMB_REGION_12_13_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_14_15                                                             0x0f32
#define mmCM1_CM_BLNDGAM_RAMB_REGION_14_15_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_16_17                                                             0x0f33
#define mmCM1_CM_BLNDGAM_RAMB_REGION_16_17_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_18_19                                                             0x0f34
#define mmCM1_CM_BLNDGAM_RAMB_REGION_18_19_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_20_21                                                             0x0f35
#define mmCM1_CM_BLNDGAM_RAMB_REGION_20_21_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_22_23                                                             0x0f36
#define mmCM1_CM_BLNDGAM_RAMB_REGION_22_23_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_24_25                                                             0x0f37
#define mmCM1_CM_BLNDGAM_RAMB_REGION_24_25_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_26_27                                                             0x0f38
#define mmCM1_CM_BLNDGAM_RAMB_REGION_26_27_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_28_29                                                             0x0f39
#define mmCM1_CM_BLNDGAM_RAMB_REGION_28_29_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_30_31                                                             0x0f3a
#define mmCM1_CM_BLNDGAM_RAMB_REGION_30_31_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_32_33                                                             0x0f3b
#define mmCM1_CM_BLNDGAM_RAMB_REGION_32_33_BASE_IDX                                                    2
#define mmCM1_CM_HDR_MULT_COEF                                                                         0x0f3c
#define mmCM1_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define mmCM1_CM_MEM_PWR_CTRL                                                                          0x0f3d
#define mmCM1_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmCM1_CM_MEM_PWR_STATUS                                                                        0x0f3e
#define mmCM1_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmCM1_CM_DEALPHA                                                                               0x0f40
#define mmCM1_CM_DEALPHA_BASE_IDX                                                                      2
#define mmCM1_CM_COEF_FORMAT                                                                           0x0f41
#define mmCM1_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define mmCM1_CM_SHAPER_CONTROL                                                                        0x0f42
#define mmCM1_CM_SHAPER_CONTROL_BASE_IDX                                                               2
#define mmCM1_CM_SHAPER_OFFSET_R                                                                       0x0f43
#define mmCM1_CM_SHAPER_OFFSET_R_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_OFFSET_G                                                                       0x0f44
#define mmCM1_CM_SHAPER_OFFSET_G_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_OFFSET_B                                                                       0x0f45
#define mmCM1_CM_SHAPER_OFFSET_B_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_SCALE_R                                                                        0x0f46
#define mmCM1_CM_SHAPER_SCALE_R_BASE_IDX                                                               2
#define mmCM1_CM_SHAPER_SCALE_G_B                                                                      0x0f47
#define mmCM1_CM_SHAPER_SCALE_G_B_BASE_IDX                                                             2
#define mmCM1_CM_SHAPER_LUT_INDEX                                                                      0x0f48
#define mmCM1_CM_SHAPER_LUT_INDEX_BASE_IDX                                                             2
#define mmCM1_CM_SHAPER_LUT_DATA                                                                       0x0f49
#define mmCM1_CM_SHAPER_LUT_DATA_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_LUT_WRITE_EN_MASK                                                              0x0f4a
#define mmCM1_CM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_B                                                              0x0f4b
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_G                                                              0x0f4c
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_R                                                              0x0f4d
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_B                                                                0x0f4e
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_G                                                                0x0f4f
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_R                                                                0x0f50
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_0_1                                                                0x0f51
#define mmCM1_CM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_2_3                                                                0x0f52
#define mmCM1_CM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_4_5                                                                0x0f53
#define mmCM1_CM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_6_7                                                                0x0f54
#define mmCM1_CM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_8_9                                                                0x0f55
#define mmCM1_CM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_10_11                                                              0x0f56
#define mmCM1_CM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_12_13                                                              0x0f57
#define mmCM1_CM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_14_15                                                              0x0f58
#define mmCM1_CM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_16_17                                                              0x0f59
#define mmCM1_CM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_18_19                                                              0x0f5a
#define mmCM1_CM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_20_21                                                              0x0f5b
#define mmCM1_CM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_22_23                                                              0x0f5c
#define mmCM1_CM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_24_25                                                              0x0f5d
#define mmCM1_CM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_26_27                                                              0x0f5e
#define mmCM1_CM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_28_29                                                              0x0f5f
#define mmCM1_CM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_30_31                                                              0x0f60
#define mmCM1_CM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_32_33                                                              0x0f61
#define mmCM1_CM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_B                                                              0x0f62
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_G                                                              0x0f63
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_R                                                              0x0f64
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_B                                                                0x0f65
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_G                                                                0x0f66
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_R                                                                0x0f67
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_0_1                                                                0x0f68
#define mmCM1_CM_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_2_3                                                                0x0f69
#define mmCM1_CM_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_4_5                                                                0x0f6a
#define mmCM1_CM_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_6_7                                                                0x0f6b
#define mmCM1_CM_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_8_9                                                                0x0f6c
#define mmCM1_CM_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_10_11                                                              0x0f6d
#define mmCM1_CM_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_12_13                                                              0x0f6e
#define mmCM1_CM_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_14_15                                                              0x0f6f
#define mmCM1_CM_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_16_17                                                              0x0f70
#define mmCM1_CM_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_18_19                                                              0x0f71
#define mmCM1_CM_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_20_21                                                              0x0f72
#define mmCM1_CM_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_22_23                                                              0x0f73
#define mmCM1_CM_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_24_25                                                              0x0f74
#define mmCM1_CM_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_26_27                                                              0x0f75
#define mmCM1_CM_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_28_29                                                              0x0f76
#define mmCM1_CM_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_30_31                                                              0x0f77
#define mmCM1_CM_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_32_33                                                              0x0f78
#define mmCM1_CM_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_MEM_PWR_CTRL2                                                                         0x0f79
#define mmCM1_CM_MEM_PWR_CTRL2_BASE_IDX                                                                2
#define mmCM1_CM_MEM_PWR_STATUS2                                                                       0x0f7a
#define mmCM1_CM_MEM_PWR_STATUS2_BASE_IDX                                                              2
#define mmCM1_CM_3DLUT_MODE                                                                            0x0f7b
#define mmCM1_CM_3DLUT_MODE_BASE_IDX                                                                   2
#define mmCM1_CM_3DLUT_INDEX                                                                           0x0f7c
#define mmCM1_CM_3DLUT_INDEX_BASE_IDX                                                                  2
#define mmCM1_CM_3DLUT_DATA                                                                            0x0f7d
#define mmCM1_CM_3DLUT_DATA_BASE_IDX                                                                   2
#define mmCM1_CM_3DLUT_DATA_30BIT                                                                      0x0f7e
#define mmCM1_CM_3DLUT_DATA_30BIT_BASE_IDX                                                             2
#define mmCM1_CM_3DLUT_READ_WRITE_CONTROL                                                              0x0f7f
#define mmCM1_CM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                     2
#define mmCM1_CM_3DLUT_OUT_NORM_FACTOR                                                                 0x0f80
#define mmCM1_CM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                        2
#define mmCM1_CM_3DLUT_OUT_OFFSET_R                                                                    0x0f81
#define mmCM1_CM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                           2
#define mmCM1_CM_3DLUT_OUT_OFFSET_G                                                                    0x0f82
#define mmCM1_CM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                           2
#define mmCM1_CM_3DLUT_OUT_OFFSET_B                                                                    0x0f83
#define mmCM1_CM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                           2


// addressBlock: dce_dc_dpp1_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x3e3c
#define mmDC_PERFMON8_PERFCOUNTER_CNTL                                                                 0x0f8f
#define mmDC_PERFMON8_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON8_PERFCOUNTER_CNTL2                                                                0x0f90
#define mmDC_PERFMON8_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON8_PERFCOUNTER_STATE                                                                0x0f91
#define mmDC_PERFMON8_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON8_PERFMON_CNTL                                                                     0x0f92
#define mmDC_PERFMON8_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON8_PERFMON_CNTL2                                                                    0x0f93
#define mmDC_PERFMON8_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC                                                          0x0f94
#define mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON8_PERFMON_CVALUE_LOW                                                               0x0f95
#define mmDC_PERFMON8_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON8_PERFMON_HI                                                                       0x0f96
#define mmDC_PERFMON8_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON8_PERFMON_LOW                                                                      0x0f97
#define mmDC_PERFMON8_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_fmt0_dispdec
// base address: 0x0
#define mmFMT0_FMT_CLAMP_COMPONENT_R                                                                   0x183c
#define mmFMT0_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT0_FMT_CLAMP_COMPONENT_G                                                                   0x183d
#define mmFMT0_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT0_FMT_CLAMP_COMPONENT_B                                                                   0x183e
#define mmFMT0_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT0_FMT_DYNAMIC_EXP_CNTL                                                                    0x183f
#define mmFMT0_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT0_FMT_CONTROL                                                                             0x1840
#define mmFMT0_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT0_FMT_BIT_DEPTH_CONTROL                                                                   0x1841
#define mmFMT0_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT0_FMT_DITHER_RAND_R_SEED                                                                  0x1842
#define mmFMT0_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_DITHER_RAND_G_SEED                                                                  0x1843
#define mmFMT0_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_DITHER_RAND_B_SEED                                                                  0x1844
#define mmFMT0_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_CLAMP_CNTL                                                                          0x1845
#define mmFMT0_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x1846
#define mmFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT0_FMT_MAP420_MEMORY_CONTROL                                                               0x1847
#define mmFMT0_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define mmFMT0_FMT_422_CONTROL                                                                         0x1849
#define mmFMT0_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg0_dispdec
// base address: 0x0
#define mmDPG0_DPG_CONTROL                                                                             0x1854
#define mmDPG0_DPG_CONTROL_BASE_IDX                                                                    2
#define mmDPG0_DPG_RAMP_CONTROL                                                                        0x1855
#define mmDPG0_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define mmDPG0_DPG_DIMENSIONS                                                                          0x1856
#define mmDPG0_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define mmDPG0_DPG_COLOUR_R_CR                                                                         0x1857
#define mmDPG0_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define mmDPG0_DPG_COLOUR_G_Y                                                                          0x1858
#define mmDPG0_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define mmDPG0_DPG_COLOUR_B_CB                                                                         0x1859
#define mmDPG0_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define mmDPG0_DPG_OFFSET_SEGMENT                                                                      0x185a
#define mmDPG0_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define mmDPG0_DPG_STATUS                                                                              0x185b
#define mmDPG0_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf0_dispdec
// base address: 0x0
#define mmOPPBUF0_OPPBUF_CONTROL                                                                       0x1884
#define mmOPPBUF0_OPPBUF_CONTROL_BASE_IDX                                                              2
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_0                                                               0x1885
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_1                                                               0x1886
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define mmOPPBUF0_OPPBUF_CONTROL1                                                                      0x1889
#define mmOPPBUF0_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe0_dispdec
// base address: 0x0
#define mmOPP_PIPE0_OPP_PIPE_CONTROL                                                                   0x188c
#define mmOPP_PIPE0_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc0_dispdec
// base address: 0x0
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_CONTROL                                                           0x1891
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_MASK                                                              0x1892
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT0                                                           0x1893
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT1                                                           0x1894
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT2                                                           0x1895
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt1_dispdec
// base address: 0x168
#define mmFMT1_FMT_CLAMP_COMPONENT_R                                                                   0x1896
#define mmFMT1_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT1_FMT_CLAMP_COMPONENT_G                                                                   0x1897
#define mmFMT1_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT1_FMT_CLAMP_COMPONENT_B                                                                   0x1898
#define mmFMT1_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT1_FMT_DYNAMIC_EXP_CNTL                                                                    0x1899
#define mmFMT1_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT1_FMT_CONTROL                                                                             0x189a
#define mmFMT1_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT1_FMT_BIT_DEPTH_CONTROL                                                                   0x189b
#define mmFMT1_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT1_FMT_DITHER_RAND_R_SEED                                                                  0x189c
#define mmFMT1_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_DITHER_RAND_G_SEED                                                                  0x189d
#define mmFMT1_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_DITHER_RAND_B_SEED                                                                  0x189e
#define mmFMT1_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_CLAMP_CNTL                                                                          0x189f
#define mmFMT1_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x18a0
#define mmFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT1_FMT_MAP420_MEMORY_CONTROL                                                               0x18a1
#define mmFMT1_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define mmFMT1_FMT_422_CONTROL                                                                         0x18a3
#define mmFMT1_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg1_dispdec
// base address: 0x168
#define mmDPG1_DPG_CONTROL                                                                             0x18ae
#define mmDPG1_DPG_CONTROL_BASE_IDX                                                                    2
#define mmDPG1_DPG_RAMP_CONTROL                                                                        0x18af
#define mmDPG1_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define mmDPG1_DPG_DIMENSIONS                                                                          0x18b0
#define mmDPG1_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define mmDPG1_DPG_COLOUR_R_CR                                                                         0x18b1
#define mmDPG1_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define mmDPG1_DPG_COLOUR_G_Y                                                                          0x18b2
#define mmDPG1_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define mmDPG1_DPG_COLOUR_B_CB                                                                         0x18b3
#define mmDPG1_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define mmDPG1_DPG_OFFSET_SEGMENT                                                                      0x18b4
#define mmDPG1_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define mmDPG1_DPG_STATUS                                                                              0x18b5
#define mmDPG1_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf1_dispdec
// base address: 0x168
#define mmOPPBUF1_OPPBUF_CONTROL                                                                       0x18de
#define mmOPPBUF1_OPPBUF_CONTROL_BASE_IDX                                                              2
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_0                                                               0x18df
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_1                                                               0x18e0
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define mmOPPBUF1_OPPBUF_CONTROL1                                                                      0x18e3
#define mmOPPBUF1_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe1_dispdec
// base address: 0x168
#define mmOPP_PIPE1_OPP_PIPE_CONTROL                                                                   0x18e6
#define mmOPP_PIPE1_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc1_dispdec
// base address: 0x168
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_CONTROL                                                           0x18eb
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_MASK                                                              0x18ec
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT0                                                           0x18ed
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT1                                                           0x18ee
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT2                                                           0x18ef
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_opp_top_dispdec
// base address: 0x0
#define mmOPP_TOP_CLK_CONTROL                                                                          0x1a5e
#define mmOPP_TOP_CLK_CONTROL_BASE_IDX                                                                 2
#define mmOPP_ABM_CONTROL                                                                              0x1a60
#define mmOPP_ABM_CONTROL_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_dscrm0_dispdec
// base address: 0x0
#define mmDSCRM0_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a64
#define mmDSCRM0_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm1_dispdec
// base address: 0x4
#define mmDSCRM1_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a65
#define mmDSCRM1_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_opp_dcperfmon_dc_perfmon_dispdec
// base address: 0x6af8
#define mmDC_PERFMON9_PERFCOUNTER_CNTL                                                                 0x1abe
#define mmDC_PERFMON9_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON9_PERFCOUNTER_CNTL2                                                                0x1abf
#define mmDC_PERFMON9_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON9_PERFCOUNTER_STATE                                                                0x1ac0
#define mmDC_PERFMON9_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON9_PERFMON_CNTL                                                                     0x1ac1
#define mmDC_PERFMON9_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON9_PERFMON_CNTL2                                                                    0x1ac2
#define mmDC_PERFMON9_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC                                                          0x1ac3
#define mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON9_PERFMON_CVALUE_LOW                                                               0x1ac4
#define mmDC_PERFMON9_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON9_PERFMON_HI                                                                       0x1ac5
#define mmDC_PERFMON9_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON9_PERFMON_LOW                                                                      0x1ac6
#define mmDC_PERFMON9_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_odm0_dispdec
// base address: 0x0
#define mmODM0_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1aca
#define mmODM0_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define mmODM0_OPTC_DATA_SOURCE_SELECT                                                                 0x1acb
#define mmODM0_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define mmODM0_OPTC_DATA_FORMAT_CONTROL                                                                0x1acc
#define mmODM0_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define mmODM0_OPTC_BYTES_PER_PIXEL                                                                    0x1acd
#define mmODM0_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define mmODM0_OPTC_WIDTH_CONTROL                                                                      0x1ace
#define mmODM0_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define mmODM0_OPTC_INPUT_CLOCK_CONTROL                                                                0x1acf
#define mmODM0_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define mmODM0_OPTC_MEMORY_CONFIG                                                                      0x1ad0
#define mmODM0_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define mmODM0_OPTC_INPUT_SPARE_REGISTER                                                               0x1ad1
#define mmODM0_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm1_dispdec
// base address: 0x40
#define mmODM1_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1ada
#define mmODM1_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define mmODM1_OPTC_DATA_SOURCE_SELECT                                                                 0x1adb
#define mmODM1_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define mmODM1_OPTC_DATA_FORMAT_CONTROL                                                                0x1adc
#define mmODM1_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define mmODM1_OPTC_BYTES_PER_PIXEL                                                                    0x1add
#define mmODM1_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define mmODM1_OPTC_WIDTH_CONTROL                                                                      0x1ade
#define mmODM1_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define mmODM1_OPTC_INPUT_CLOCK_CONTROL                                                                0x1adf
#define mmODM1_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define mmODM1_OPTC_MEMORY_CONFIG                                                                      0x1ae0
#define mmODM1_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define mmODM1_OPTC_INPUT_SPARE_REGISTER                                                               0x1ae1
#define mmODM1_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_otg0_dispdec
// base address: 0x0
#define mmOTG0_OTG_H_TOTAL                                                                             0x1b2a
#define mmOTG0_OTG_H_TOTAL_BASE_IDX                                                                    2
#define mmOTG0_OTG_H_BLANK_START_END                                                                   0x1b2b
#define mmOTG0_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG0_OTG_H_SYNC_A                                                                            0x1b2c
#define mmOTG0_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define mmOTG0_OTG_H_SYNC_A_CNTL                                                                       0x1b2d
#define mmOTG0_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG0_OTG_H_TIMING_CNTL                                                                       0x1b2e
#define mmOTG0_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define mmOTG0_OTG_V_TOTAL                                                                             0x1b2f
#define mmOTG0_OTG_V_TOTAL_BASE_IDX                                                                    2
#define mmOTG0_OTG_V_TOTAL_MIN                                                                         0x1b30
#define mmOTG0_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define mmOTG0_OTG_V_TOTAL_MAX                                                                         0x1b31
#define mmOTG0_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define mmOTG0_OTG_V_TOTAL_MID                                                                         0x1b32
#define mmOTG0_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define mmOTG0_OTG_V_TOTAL_CONTROL                                                                     0x1b33
#define mmOTG0_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define mmOTG0_OTG_V_TOTAL_INT_STATUS                                                                  0x1b34
#define mmOTG0_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define mmOTG0_OTG_VSYNC_NOM_INT_STATUS                                                                0x1b35
#define mmOTG0_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define mmOTG0_OTG_V_BLANK_START_END                                                                   0x1b36
#define mmOTG0_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG0_OTG_V_SYNC_A                                                                            0x1b37
#define mmOTG0_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define mmOTG0_OTG_V_SYNC_A_CNTL                                                                       0x1b38
#define mmOTG0_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG0_OTG_TRIGA_CNTL                                                                          0x1b39
#define mmOTG0_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define mmOTG0_OTG_TRIGA_MANUAL_TRIG                                                                   0x1b3a
#define mmOTG0_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG0_OTG_TRIGB_CNTL                                                                          0x1b3b
#define mmOTG0_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define mmOTG0_OTG_TRIGB_MANUAL_TRIG                                                                   0x1b3c
#define mmOTG0_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG0_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1b3d
#define mmOTG0_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define mmOTG0_OTG_FLOW_CONTROL                                                                        0x1b3e
#define mmOTG0_OTG_FLOW_CONTROL_BASE_IDX                                                               2
#define mmOTG0_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1b3f
#define mmOTG0_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define mmOTG0_OTG_CONTROL                                                                             0x1b41
#define mmOTG0_OTG_CONTROL_BASE_IDX                                                                    2
#define mmOTG0_OTG_INTERLACE_CONTROL                                                                   0x1b44
#define mmOTG0_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define mmOTG0_OTG_INTERLACE_STATUS                                                                    0x1b45
#define mmOTG0_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define mmOTG0_OTG_PIXEL_DATA_READBACK0                                                                0x1b47
#define mmOTG0_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define mmOTG0_OTG_PIXEL_DATA_READBACK1                                                                0x1b48
#define mmOTG0_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define mmOTG0_OTG_STATUS                                                                              0x1b49
#define mmOTG0_OTG_STATUS_BASE_IDX                                                                     2
#define mmOTG0_OTG_STATUS_POSITION                                                                     0x1b4a
#define mmOTG0_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define mmOTG0_OTG_NOM_VERT_POSITION                                                                   0x1b4b
#define mmOTG0_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define mmOTG0_OTG_STATUS_FRAME_COUNT                                                                  0x1b4c
#define mmOTG0_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define mmOTG0_OTG_STATUS_VF_COUNT                                                                     0x1b4d
#define mmOTG0_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define mmOTG0_OTG_STATUS_HV_COUNT                                                                     0x1b4e
#define mmOTG0_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define mmOTG0_OTG_COUNT_CONTROL                                                                       0x1b4f
#define mmOTG0_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define mmOTG0_OTG_COUNT_RESET                                                                         0x1b50
#define mmOTG0_OTG_COUNT_RESET_BASE_IDX                                                                2
#define mmOTG0_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1b51
#define mmOTG0_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define mmOTG0_OTG_VERT_SYNC_CONTROL                                                                   0x1b52
#define mmOTG0_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define mmOTG0_OTG_STEREO_STATUS                                                                       0x1b53
#define mmOTG0_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define mmOTG0_OTG_STEREO_CONTROL                                                                      0x1b54
#define mmOTG0_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define mmOTG0_OTG_SNAPSHOT_STATUS                                                                     0x1b55
#define mmOTG0_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define mmOTG0_OTG_SNAPSHOT_CONTROL                                                                    0x1b56
#define mmOTG0_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define mmOTG0_OTG_SNAPSHOT_POSITION                                                                   0x1b57
#define mmOTG0_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define mmOTG0_OTG_SNAPSHOT_FRAME                                                                      0x1b58
#define mmOTG0_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define mmOTG0_OTG_INTERRUPT_CONTROL                                                                   0x1b59
#define mmOTG0_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define mmOTG0_OTG_UPDATE_LOCK                                                                         0x1b5a
#define mmOTG0_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define mmOTG0_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1b5b
#define mmOTG0_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define mmOTG0_OTG_MASTER_EN                                                                           0x1b5c
#define mmOTG0_OTG_MASTER_EN_BASE_IDX                                                                  2
#define mmOTG0_OTG_BLANK_DATA_COLOR                                                                    0x1b5e
#define mmOTG0_OTG_BLANK_DATA_COLOR_BASE_IDX                                                           2
#define mmOTG0_OTG_BLANK_DATA_COLOR_EXT                                                                0x1b5f
#define mmOTG0_OTG_BLANK_DATA_COLOR_EXT_BASE_IDX                                                       2
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1b62
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1b63
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1b64
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1b65
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1b66
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1b67
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define mmOTG0_OTG_CRC_CNTL                                                                            0x1b68
#define mmOTG0_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define mmOTG0_OTG_CRC_CNTL2                                                                           0x1b69
#define mmOTG0_OTG_CRC_CNTL2_BASE_IDX                                                                  2
#define mmOTG0_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1b6a
#define mmOTG0_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1b6b
#define mmOTG0_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1b6c
#define mmOTG0_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1b6d
#define mmOTG0_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_DATA_RG                                                                        0x1b6e
#define mmOTG0_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC0_DATA_B                                                                         0x1b6f
#define mmOTG0_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1b70
#define mmOTG0_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1b71
#define mmOTG0_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1b72
#define mmOTG0_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1b73
#define mmOTG0_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_DATA_RG                                                                        0x1b74
#define mmOTG0_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC1_DATA_B                                                                         0x1b75
#define mmOTG0_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC2_DATA_RG                                                                        0x1b76
#define mmOTG0_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC2_DATA_B                                                                         0x1b77
#define mmOTG0_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC3_DATA_RG                                                                        0x1b78
#define mmOTG0_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC3_DATA_B                                                                         0x1b79
#define mmOTG0_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1b7a
#define mmOTG0_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1b7b
#define mmOTG0_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmOTG0_OTG_STATIC_SCREEN_CONTROL                                                               0x1b82
#define mmOTG0_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define mmOTG0_OTG_3D_STRUCTURE_CONTROL                                                                0x1b83
#define mmOTG0_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define mmOTG0_OTG_GSL_VSYNC_GAP                                                                       0x1b84
#define mmOTG0_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define mmOTG0_OTG_MASTER_UPDATE_MODE                                                                  0x1b85
#define mmOTG0_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define mmOTG0_OTG_CLOCK_CONTROL                                                                       0x1b86
#define mmOTG0_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define mmOTG0_OTG_VSTARTUP_PARAM                                                                      0x1b87
#define mmOTG0_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define mmOTG0_OTG_VUPDATE_PARAM                                                                       0x1b88
#define mmOTG0_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define mmOTG0_OTG_VREADY_PARAM                                                                        0x1b89
#define mmOTG0_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define mmOTG0_OTG_GLOBAL_SYNC_STATUS                                                                  0x1b8a
#define mmOTG0_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define mmOTG0_OTG_MASTER_UPDATE_LOCK                                                                  0x1b8b
#define mmOTG0_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define mmOTG0_OTG_GSL_CONTROL                                                                         0x1b8c
#define mmOTG0_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define mmOTG0_OTG_GSL_WINDOW_X                                                                        0x1b8d
#define mmOTG0_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define mmOTG0_OTG_GSL_WINDOW_Y                                                                        0x1b8e
#define mmOTG0_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define mmOTG0_OTG_VUPDATE_KEEPOUT                                                                     0x1b8f
#define mmOTG0_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL0                                                                     0x1b90
#define mmOTG0_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL1                                                                     0x1b91
#define mmOTG0_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL2                                                                     0x1b92
#define mmOTG0_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL3                                                                     0x1b93
#define mmOTG0_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL4                                                                     0x1b94
#define mmOTG0_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define mmOTG0_OTG_TRIG_MANUAL_CONTROL                                                                 0x1b95
#define mmOTG0_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define mmOTG0_OTG_MANUAL_FLOW_CONTROL                                                                 0x1b96
#define mmOTG0_OTG_MANUAL_FLOW_CONTROL_BASE_IDX                                                        2
#define mmOTG0_OTG_DRR_TIMING_INT_STATUS                                                               0x1b97
#define mmOTG0_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define mmOTG0_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1b98
#define mmOTG0_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define mmOTG0_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1b99
#define mmOTG0_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define mmOTG0_OTG_DRR_TRIGGER_WINDOW                                                                  0x1b9a
#define mmOTG0_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define mmOTG0_OTG_DRR_CONTROL                                                                         0x1b9b
#define mmOTG0_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define mmOTG0_OTG_M_CONST_DTO0                                                                        0x1b9c
#define mmOTG0_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define mmOTG0_OTG_M_CONST_DTO1                                                                        0x1b9d
#define mmOTG0_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define mmOTG0_OTG_REQUEST_CONTROL                                                                     0x1b9e
#define mmOTG0_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define mmOTG0_OTG_DSC_START_POSITION                                                                  0x1b9f
#define mmOTG0_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define mmOTG0_OTG_PIPE_UPDATE_STATUS                                                                  0x1ba0
#define mmOTG0_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define mmOTG0_OTG_SPARE_REGISTER                                                                      0x1ba2
#define mmOTG0_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg1_dispdec
// base address: 0x200
#define mmOTG1_OTG_H_TOTAL                                                                             0x1baa
#define mmOTG1_OTG_H_TOTAL_BASE_IDX                                                                    2
#define mmOTG1_OTG_H_BLANK_START_END                                                                   0x1bab
#define mmOTG1_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG1_OTG_H_SYNC_A                                                                            0x1bac
#define mmOTG1_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define mmOTG1_OTG_H_SYNC_A_CNTL                                                                       0x1bad
#define mmOTG1_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG1_OTG_H_TIMING_CNTL                                                                       0x1bae
#define mmOTG1_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define mmOTG1_OTG_V_TOTAL                                                                             0x1baf
#define mmOTG1_OTG_V_TOTAL_BASE_IDX                                                                    2
#define mmOTG1_OTG_V_TOTAL_MIN                                                                         0x1bb0
#define mmOTG1_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define mmOTG1_OTG_V_TOTAL_MAX                                                                         0x1bb1
#define mmOTG1_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define mmOTG1_OTG_V_TOTAL_MID                                                                         0x1bb2
#define mmOTG1_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define mmOTG1_OTG_V_TOTAL_CONTROL                                                                     0x1bb3
#define mmOTG1_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define mmOTG1_OTG_V_TOTAL_INT_STATUS                                                                  0x1bb4
#define mmOTG1_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define mmOTG1_OTG_VSYNC_NOM_INT_STATUS                                                                0x1bb5
#define mmOTG1_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define mmOTG1_OTG_V_BLANK_START_END                                                                   0x1bb6
#define mmOTG1_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG1_OTG_V_SYNC_A                                                                            0x1bb7
#define mmOTG1_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define mmOTG1_OTG_V_SYNC_A_CNTL                                                                       0x1bb8
#define mmOTG1_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG1_OTG_TRIGA_CNTL                                                                          0x1bb9
#define mmOTG1_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define mmOTG1_OTG_TRIGA_MANUAL_TRIG                                                                   0x1bba
#define mmOTG1_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG1_OTG_TRIGB_CNTL                                                                          0x1bbb
#define mmOTG1_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define mmOTG1_OTG_TRIGB_MANUAL_TRIG                                                                   0x1bbc
#define mmOTG1_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG1_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1bbd
#define mmOTG1_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define mmOTG1_OTG_FLOW_CONTROL                                                                        0x1bbe
#define mmOTG1_OTG_FLOW_CONTROL_BASE_IDX                                                               2
#define mmOTG1_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1bbf
#define mmOTG1_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define mmOTG1_OTG_CONTROL                                                                             0x1bc1
#define mmOTG1_OTG_CONTROL_BASE_IDX                                                                    2
#define mmOTG1_OTG_INTERLACE_CONTROL                                                                   0x1bc4
#define mmOTG1_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define mmOTG1_OTG_INTERLACE_STATUS                                                                    0x1bc5
#define mmOTG1_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define mmOTG1_OTG_PIXEL_DATA_READBACK0                                                                0x1bc7
#define mmOTG1_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define mmOTG1_OTG_PIXEL_DATA_READBACK1                                                                0x1bc8
#define mmOTG1_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define mmOTG1_OTG_STATUS                                                                              0x1bc9
#define mmOTG1_OTG_STATUS_BASE_IDX                                                                     2
#define mmOTG1_OTG_STATUS_POSITION                                                                     0x1bca
#define mmOTG1_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define mmOTG1_OTG_NOM_VERT_POSITION                                                                   0x1bcb
#define mmOTG1_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define mmOTG1_OTG_STATUS_FRAME_COUNT                                                                  0x1bcc
#define mmOTG1_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define mmOTG1_OTG_STATUS_VF_COUNT                                                                     0x1bcd
#define mmOTG1_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define mmOTG1_OTG_STATUS_HV_COUNT                                                                     0x1bce
#define mmOTG1_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define mmOTG1_OTG_COUNT_CONTROL                                                                       0x1bcf
#define mmOTG1_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define mmOTG1_OTG_COUNT_RESET                                                                         0x1bd0
#define mmOTG1_OTG_COUNT_RESET_BASE_IDX                                                                2
#define mmOTG1_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1bd1
#define mmOTG1_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define mmOTG1_OTG_VERT_SYNC_CONTROL                                                                   0x1bd2
#define mmOTG1_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define mmOTG1_OTG_STEREO_STATUS                                                                       0x1bd3
#define mmOTG1_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define mmOTG1_OTG_STEREO_CONTROL                                                                      0x1bd4
#define mmOTG1_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define mmOTG1_OTG_SNAPSHOT_STATUS                                                                     0x1bd5
#define mmOTG1_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define mmOTG1_OTG_SNAPSHOT_CONTROL                                                                    0x1bd6
#define mmOTG1_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define mmOTG1_OTG_SNAPSHOT_POSITION                                                                   0x1bd7
#define mmOTG1_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define mmOTG1_OTG_SNAPSHOT_FRAME                                                                      0x1bd8
#define mmOTG1_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define mmOTG1_OTG_INTERRUPT_CONTROL                                                                   0x1bd9
#define mmOTG1_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define mmOTG1_OTG_UPDATE_LOCK                                                                         0x1bda
#define mmOTG1_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define mmOTG1_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1bdb
#define mmOTG1_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define mmOTG1_OTG_MASTER_EN                                                                           0x1bdc
#define mmOTG1_OTG_MASTER_EN_BASE_IDX                                                                  2
#define mmOTG1_OTG_BLANK_DATA_COLOR                                                                    0x1bde
#define mmOTG1_OTG_BLANK_DATA_COLOR_BASE_IDX                                                           2
#define mmOTG1_OTG_BLANK_DATA_COLOR_EXT                                                                0x1bdf
#define mmOTG1_OTG_BLANK_DATA_COLOR_EXT_BASE_IDX                                                       2
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1be2
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1be3
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1be4
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1be5
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1be6
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1be7
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define mmOTG1_OTG_CRC_CNTL                                                                            0x1be8
#define mmOTG1_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define mmOTG1_OTG_CRC_CNTL2                                                                           0x1be9
#define mmOTG1_OTG_CRC_CNTL2_BASE_IDX                                                                  2
#define mmOTG1_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1bea
#define mmOTG1_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1beb
#define mmOTG1_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1bec
#define mmOTG1_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1bed
#define mmOTG1_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_DATA_RG                                                                        0x1bee
#define mmOTG1_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC0_DATA_B                                                                         0x1bef
#define mmOTG1_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1bf0
#define mmOTG1_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1bf1
#define mmOTG1_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1bf2
#define mmOTG1_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1bf3
#define mmOTG1_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_DATA_RG                                                                        0x1bf4
#define mmOTG1_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC1_DATA_B                                                                         0x1bf5
#define mmOTG1_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC2_DATA_RG                                                                        0x1bf6
#define mmOTG1_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC2_DATA_B                                                                         0x1bf7
#define mmOTG1_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC3_DATA_RG                                                                        0x1bf8
#define mmOTG1_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC3_DATA_B                                                                         0x1bf9
#define mmOTG1_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1bfa
#define mmOTG1_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1bfb
#define mmOTG1_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmOTG1_OTG_STATIC_SCREEN_CONTROL                                                               0x1c02
#define mmOTG1_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define mmOTG1_OTG_3D_STRUCTURE_CONTROL                                                                0x1c03
#define mmOTG1_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define mmOTG1_OTG_GSL_VSYNC_GAP                                                                       0x1c04
#define mmOTG1_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define mmOTG1_OTG_MASTER_UPDATE_MODE                                                                  0x1c05
#define mmOTG1_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define mmOTG1_OTG_CLOCK_CONTROL                                                                       0x1c06
#define mmOTG1_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define mmOTG1_OTG_VSTARTUP_PARAM                                                                      0x1c07
#define mmOTG1_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define mmOTG1_OTG_VUPDATE_PARAM                                                                       0x1c08
#define mmOTG1_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define mmOTG1_OTG_VREADY_PARAM                                                                        0x1c09
#define mmOTG1_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define mmOTG1_OTG_GLOBAL_SYNC_STATUS                                                                  0x1c0a
#define mmOTG1_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define mmOTG1_OTG_MASTER_UPDATE_LOCK                                                                  0x1c0b
#define mmOTG1_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define mmOTG1_OTG_GSL_CONTROL                                                                         0x1c0c
#define mmOTG1_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define mmOTG1_OTG_GSL_WINDOW_X                                                                        0x1c0d
#define mmOTG1_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define mmOTG1_OTG_GSL_WINDOW_Y                                                                        0x1c0e
#define mmOTG1_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define mmOTG1_OTG_VUPDATE_KEEPOUT                                                                     0x1c0f
#define mmOTG1_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL0                                                                     0x1c10
#define mmOTG1_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL1                                                                     0x1c11
#define mmOTG1_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL2                                                                     0x1c12
#define mmOTG1_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL3                                                                     0x1c13
#define mmOTG1_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL4                                                                     0x1c14
#define mmOTG1_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define mmOTG1_OTG_TRIG_MANUAL_CONTROL                                                                 0x1c15
#define mmOTG1_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define mmOTG1_OTG_MANUAL_FLOW_CONTROL                                                                 0x1c16
#define mmOTG1_OTG_MANUAL_FLOW_CONTROL_BASE_IDX                                                        2
#define mmOTG1_OTG_DRR_TIMING_INT_STATUS                                                               0x1c17
#define mmOTG1_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define mmOTG1_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1c18
#define mmOTG1_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define mmOTG1_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1c19
#define mmOTG1_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define mmOTG1_OTG_DRR_TRIGGER_WINDOW                                                                  0x1c1a
#define mmOTG1_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define mmOTG1_OTG_DRR_CONTROL                                                                         0x1c1b
#define mmOTG1_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define mmOTG1_OTG_M_CONST_DTO0                                                                        0x1c1c
#define mmOTG1_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define mmOTG1_OTG_M_CONST_DTO1                                                                        0x1c1d
#define mmOTG1_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define mmOTG1_OTG_REQUEST_CONTROL                                                                     0x1c1e
#define mmOTG1_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define mmOTG1_OTG_DSC_START_POSITION                                                                  0x1c1f
#define mmOTG1_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define mmOTG1_OTG_PIPE_UPDATE_STATUS                                                                  0x1c20
#define mmOTG1_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define mmOTG1_OTG_SPARE_REGISTER                                                                      0x1c22
#define mmOTG1_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_optc_misc_dispdec
// base address: 0x0
#define mmDWB_SOURCE_SELECT                                                                            0x1e2a
#define mmDWB_SOURCE_SELECT_BASE_IDX                                                                   2
#define mmGSL_SOURCE_SELECT                                                                            0x1e2b
#define mmGSL_SOURCE_SELECT_BASE_IDX                                                                   2
#define mmOPTC_CLOCK_CONTROL                                                                           0x1e2c
#define mmOPTC_CLOCK_CONTROL_BASE_IDX                                                                  2
#define mmODM_MEM_PWR_CTRL                                                                             0x1e2d
#define mmODM_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define mmODM_MEM_PWR_CTRL2                                                                            0x1e2e
#define mmODM_MEM_PWR_CTRL2_BASE_IDX                                                                   2
#define mmODM_MEM_PWR_CTRL3                                                                            0x1e2f
#define mmODM_MEM_PWR_CTRL3_BASE_IDX                                                                   2
#define mmODM_MEM_PWR_STATUS                                                                           0x1e30
#define mmODM_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define mmOPTC_MISC_SPARE_REGISTER                                                                     0x1e31
#define mmOPTC_MISC_SPARE_REGISTER_BASE_IDX                                                            2


// addressBlock: dce_dc_optc_optc_dcperfmon_dc_perfmon_dispdec
// base address: 0x79a8
#define mmDC_PERFMON10_PERFCOUNTER_CNTL                                                                0x1e6a
#define mmDC_PERFMON10_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON10_PERFCOUNTER_CNTL2                                                               0x1e6b
#define mmDC_PERFMON10_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON10_PERFCOUNTER_STATE                                                               0x1e6c
#define mmDC_PERFMON10_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON10_PERFMON_CNTL                                                                    0x1e6d
#define mmDC_PERFMON10_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON10_PERFMON_CNTL2                                                                   0x1e6e
#define mmDC_PERFMON10_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON10_PERFMON_CVALUE_INT_MISC                                                         0x1e6f
#define mmDC_PERFMON10_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON10_PERFMON_CVALUE_LOW                                                              0x1e70
#define mmDC_PERFMON10_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON10_PERFMON_HI                                                                      0x1e71
#define mmDC_PERFMON10_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON10_PERFMON_LOW                                                                     0x1e72
#define mmDC_PERFMON10_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dio_dout_i2c_dispdec
// base address: 0x0
#define mmDC_I2C_CONTROL                                                                               0x1e98
#define mmDC_I2C_CONTROL_BASE_IDX                                                                      2
#define mmDC_I2C_ARBITRATION                                                                           0x1e99
#define mmDC_I2C_ARBITRATION_BASE_IDX                                                                  2
#define mmDC_I2C_INTERRUPT_CONTROL                                                                     0x1e9a
#define mmDC_I2C_INTERRUPT_CONTROL_BASE_IDX                                                            2
#define mmDC_I2C_SW_STATUS                                                                             0x1e9b
#define mmDC_I2C_SW_STATUS_BASE_IDX                                                                    2
#define mmDC_I2C_DDC1_HW_STATUS                                                                        0x1e9c
#define mmDC_I2C_DDC1_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC2_HW_STATUS                                                                        0x1e9d
#define mmDC_I2C_DDC2_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC1_SPEED                                                                            0x1ea2
#define mmDC_I2C_DDC1_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC1_SETUP                                                                            0x1ea3
#define mmDC_I2C_DDC1_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC2_SPEED                                                                            0x1ea4
#define mmDC_I2C_DDC2_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC2_SETUP                                                                            0x1ea5
#define mmDC_I2C_DDC2_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_TRANSACTION0                                                                          0x1eae
#define mmDC_I2C_TRANSACTION0_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION1                                                                          0x1eaf
#define mmDC_I2C_TRANSACTION1_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION2                                                                          0x1eb0
#define mmDC_I2C_TRANSACTION2_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION3                                                                          0x1eb1
#define mmDC_I2C_TRANSACTION3_BASE_IDX                                                                 2
#define mmDC_I2C_DATA                                                                                  0x1eb2
#define mmDC_I2C_DATA_BASE_IDX                                                                         2
#define mmDC_I2C_EDID_DETECT_CTRL                                                                      0x1eb6
#define mmDC_I2C_EDID_DETECT_CTRL_BASE_IDX                                                             2
#define mmDC_I2C_READ_REQUEST_INTERRUPT                                                                0x1eb7
#define mmDC_I2C_READ_REQUEST_INTERRUPT_BASE_IDX                                                       2


// addressBlock: dce_dc_dio_dio_misc_dispdec
// base address: 0x0
#define mmDIO_SCRATCH0                                                                                 0x1eca
#define mmDIO_SCRATCH0_BASE_IDX                                                                        2
#define mmDIO_SCRATCH1                                                                                 0x1ecb
#define mmDIO_SCRATCH1_BASE_IDX                                                                        2
#define mmDIO_SCRATCH2                                                                                 0x1ecc
#define mmDIO_SCRATCH2_BASE_IDX                                                                        2
#define mmDIO_SCRATCH3                                                                                 0x1ecd
#define mmDIO_SCRATCH3_BASE_IDX                                                                        2
#define mmDIO_SCRATCH4                                                                                 0x1ece
#define mmDIO_SCRATCH4_BASE_IDX                                                                        2
#define mmDIO_SCRATCH5                                                                                 0x1ecf
#define mmDIO_SCRATCH5_BASE_IDX                                                                        2
#define mmDIO_SCRATCH6                                                                                 0x1ed0
#define mmDIO_SCRATCH6_BASE_IDX                                                                        2
#define mmDIO_SCRATCH7                                                                                 0x1ed1
#define mmDIO_SCRATCH7_BASE_IDX                                                                        2
#define mmDIO_MEM_PWR_STATUS                                                                           0x1edd
#define mmDIO_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define mmDIO_MEM_PWR_CTRL                                                                             0x1ede
#define mmDIO_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define mmDIO_MEM_PWR_CTRL2                                                                            0x1edf
#define mmDIO_MEM_PWR_CTRL2_BASE_IDX                                                                   2
#define mmDIO_CLK_CNTL                                                                                 0x1ee0
#define mmDIO_CLK_CNTL_BASE_IDX                                                                        2
#define mmDIO_POWER_MANAGEMENT_CNTL                                                                    0x1ee4
#define mmDIO_POWER_MANAGEMENT_CNTL_BASE_IDX                                                           2
#define mmDIG_SOFT_RESET                                                                               0x1eee
#define mmDIG_SOFT_RESET_BASE_IDX                                                                      2
#define mmDIO_CLK_CNTL2                                                                                0x1ef2
#define mmDIO_CLK_CNTL2_BASE_IDX                                                                       2
#define mmDIO_CLK_CNTL3                                                                                0x1ef3
#define mmDIO_CLK_CNTL3_BASE_IDX                                                                       2
#define mmDIO_HDMI_RXSTATUS_TIMER_CONTROL                                                              0x1eff
#define mmDIO_HDMI_RXSTATUS_TIMER_CONTROL_BASE_IDX                                                     2
#define mmDIO_GENERIC_INTERRUPT_MESSAGE                                                                0x1f02
#define mmDIO_GENERIC_INTERRUPT_MESSAGE_BASE_IDX                                                       2
#define mmDIO_GENERIC_INTERRUPT_CLEAR                                                                  0x1f03
#define mmDIO_GENERIC_INTERRUPT_CLEAR_BASE_IDX                                                         2


// addressBlock: dce_dc_dio_hpd0_dispdec
// base address: 0x0
#define mmHPD0_DC_HPD_INT_STATUS                                                                       0x1f14
#define mmHPD0_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD0_DC_HPD_INT_CONTROL                                                                      0x1f15
#define mmHPD0_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD0_DC_HPD_CONTROL                                                                          0x1f16
#define mmHPD0_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD0_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f17
#define mmHPD0_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD0_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f18
#define mmHPD0_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd1_dispdec
// base address: 0x20
#define mmHPD1_DC_HPD_INT_STATUS                                                                       0x1f1c
#define mmHPD1_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD1_DC_HPD_INT_CONTROL                                                                      0x1f1d
#define mmHPD1_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD1_DC_HPD_CONTROL                                                                          0x1f1e
#define mmHPD1_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD1_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f1f
#define mmHPD1_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD1_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f20
#define mmHPD1_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_dio_dcperfmon_dc_perfmon_dispdec
// base address: 0x7d10
#define mmDC_PERFMON11_PERFCOUNTER_CNTL                                                                0x1f44
#define mmDC_PERFMON11_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON11_PERFCOUNTER_CNTL2                                                               0x1f45
#define mmDC_PERFMON11_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON11_PERFCOUNTER_STATE                                                               0x1f46
#define mmDC_PERFMON11_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON11_PERFMON_CNTL                                                                    0x1f47
#define mmDC_PERFMON11_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON11_PERFMON_CNTL2                                                                   0x1f48
#define mmDC_PERFMON11_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON11_PERFMON_CVALUE_INT_MISC                                                         0x1f49
#define mmDC_PERFMON11_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON11_PERFMON_CVALUE_LOW                                                              0x1f4a
#define mmDC_PERFMON11_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON11_PERFMON_HI                                                                      0x1f4b
#define mmDC_PERFMON11_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON11_PERFMON_LOW                                                                     0x1f4c
#define mmDC_PERFMON11_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dio_dp_aux0_dispdec
// base address: 0x0
#define mmDP_AUX0_AUX_CONTROL                                                                          0x1f50
#define mmDP_AUX0_AUX_CONTROL_BASE_IDX                                                                 2
#define mmDP_AUX0_AUX_SW_CONTROL                                                                       0x1f51
#define mmDP_AUX0_AUX_SW_CONTROL_BASE_IDX                                                              2
#define mmDP_AUX0_AUX_ARB_CONTROL                                                                      0x1f52
#define mmDP_AUX0_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define mmDP_AUX0_AUX_INTERRUPT_CONTROL                                                                0x1f53
#define mmDP_AUX0_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmDP_AUX0_AUX_SW_STATUS                                                                        0x1f54
#define mmDP_AUX0_AUX_SW_STATUS_BASE_IDX                                                               2
#define mmDP_AUX0_AUX_LS_STATUS                                                                        0x1f55
#define mmDP_AUX0_AUX_LS_STATUS_BASE_IDX                                                               2
#define mmDP_AUX0_AUX_SW_DATA                                                                          0x1f56
#define mmDP_AUX0_AUX_SW_DATA_BASE_IDX                                                                 2
#define mmDP_AUX0_AUX_LS_DATA                                                                          0x1f57
#define mmDP_AUX0_AUX_LS_DATA_BASE_IDX                                                                 2
#define mmDP_AUX0_AUX_DPHY_TX_REF_CONTROL                                                              0x1f58
#define mmDP_AUX0_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define mmDP_AUX0_AUX_DPHY_TX_CONTROL                                                                  0x1f59
#define mmDP_AUX0_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL0                                                                 0x1f5a
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL1                                                                 0x1f5b
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define mmDP_AUX0_AUX_DPHY_TX_STATUS                                                                   0x1f5c
#define mmDP_AUX0_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX0_AUX_DPHY_RX_STATUS                                                                   0x1f5d
#define mmDP_AUX0_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROL                                                                 0x1f5e
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define mmDP_AUX0_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f5f
#define mmDP_AUX0_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f60
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define mmDP_AUX0_AUX_GTC_SYNC_STATUS                                                                  0x1f61
#define mmDP_AUX0_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define mmDP_AUX0_AUX_PHY_WAKE_CNTL                                                                    0x1f66
#define mmDP_AUX0_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux1_dispdec
// base address: 0x70
#define mmDP_AUX1_AUX_CONTROL                                                                          0x1f6c
#define mmDP_AUX1_AUX_CONTROL_BASE_IDX                                                                 2
#define mmDP_AUX1_AUX_SW_CONTROL                                                                       0x1f6d
#define mmDP_AUX1_AUX_SW_CONTROL_BASE_IDX                                                              2
#define mmDP_AUX1_AUX_ARB_CONTROL                                                                      0x1f6e
#define mmDP_AUX1_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define mmDP_AUX1_AUX_INTERRUPT_CONTROL                                                                0x1f6f
#define mmDP_AUX1_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmDP_AUX1_AUX_SW_STATUS                                                                        0x1f70
#define mmDP_AUX1_AUX_SW_STATUS_BASE_IDX                                                               2
#define mmDP_AUX1_AUX_LS_STATUS                                                                        0x1f71
#define mmDP_AUX1_AUX_LS_STATUS_BASE_IDX                                                               2
#define mmDP_AUX1_AUX_SW_DATA                                                                          0x1f72
#define mmDP_AUX1_AUX_SW_DATA_BASE_IDX                                                                 2
#define mmDP_AUX1_AUX_LS_DATA                                                                          0x1f73
#define mmDP_AUX1_AUX_LS_DATA_BASE_IDX                                                                 2
#define mmDP_AUX1_AUX_DPHY_TX_REF_CONTROL                                                              0x1f74
#define mmDP_AUX1_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define mmDP_AUX1_AUX_DPHY_TX_CONTROL                                                                  0x1f75
#define mmDP_AUX1_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL0                                                                 0x1f76
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL1                                                                 0x1f77
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define mmDP_AUX1_AUX_DPHY_TX_STATUS                                                                   0x1f78
#define mmDP_AUX1_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX1_AUX_DPHY_RX_STATUS                                                                   0x1f79
#define mmDP_AUX1_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROL                                                                 0x1f7a
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define mmDP_AUX1_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f7b
#define mmDP_AUX1_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f7c
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define mmDP_AUX1_AUX_GTC_SYNC_STATUS                                                                  0x1f7d
#define mmDP_AUX1_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define mmDP_AUX1_AUX_PHY_WAKE_CNTL                                                                    0x1f82
#define mmDP_AUX1_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dig0_vpg_vpg_dispdec
// base address: 0x154a0
#define mmVPG0_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x2068
#define mmVPG0_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define mmVPG0_VPG_GENERIC_PACKET_DATA                                                                 0x2069
#define mmVPG0_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define mmVPG0_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x206a
#define mmVPG0_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define mmVPG0_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x206b
#define mmVPG0_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define mmVPG0_VPG_GENERIC_STATUS                                                                      0x206c
#define mmVPG0_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define mmVPG0_VPG_MEM_PWR                                                                             0x206d
#define mmVPG0_VPG_MEM_PWR_BASE_IDX                                                                    2
#define mmVPG0_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x206e
#define mmVPG0_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define mmVPG0_VPG_ISRC1_2_DATA                                                                        0x206f
#define mmVPG0_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define mmVPG0_VPG_MPEG_INFO0                                                                          0x2070
#define mmVPG0_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define mmVPG0_VPG_MPEG_INFO1                                                                          0x2071
#define mmVPG0_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig0_afmt_afmt_dispdec
// base address: 0x154cc
#define mmAFMT0_AFMT_VBI_PACKET_CONTROL                                                                0x2074
#define mmAFMT0_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL2                                                             0x2075
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define mmAFMT0_AFMT_AUDIO_INFO0                                                                       0x2076
#define mmAFMT0_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define mmAFMT0_AFMT_AUDIO_INFO1                                                                       0x2077
#define mmAFMT0_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define mmAFMT0_AFMT_60958_0                                                                           0x2078
#define mmAFMT0_AFMT_60958_0_BASE_IDX                                                                  2
#define mmAFMT0_AFMT_60958_1                                                                           0x2079
#define mmAFMT0_AFMT_60958_1_BASE_IDX                                                                  2
#define mmAFMT0_AFMT_AUDIO_CRC_CONTROL                                                                 0x207a
#define mmAFMT0_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT0_AFMT_RAMP_CONTROL0                                                                     0x207b
#define mmAFMT0_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define mmAFMT0_AFMT_RAMP_CONTROL1                                                                     0x207c
#define mmAFMT0_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define mmAFMT0_AFMT_RAMP_CONTROL2                                                                     0x207d
#define mmAFMT0_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define mmAFMT0_AFMT_RAMP_CONTROL3                                                                     0x207e
#define mmAFMT0_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define mmAFMT0_AFMT_60958_2                                                                           0x207f
#define mmAFMT0_AFMT_60958_2_BASE_IDX                                                                  2
#define mmAFMT0_AFMT_AUDIO_CRC_RESULT                                                                  0x2080
#define mmAFMT0_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define mmAFMT0_AFMT_STATUS                                                                            0x2081
#define mmAFMT0_AFMT_STATUS_BASE_IDX                                                                   2
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL                                                              0x2082
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define mmAFMT0_AFMT_INFOFRAME_CONTROL0                                                                0x2083
#define mmAFMT0_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define mmAFMT0_AFMT_INTERRUPT_STATUS                                                                  0x2084
#define mmAFMT0_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define mmAFMT0_AFMT_AUDIO_SRC_CONTROL                                                                 0x2085
#define mmAFMT0_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT0_AFMT_MEM_PWR                                                                           0x2087
#define mmAFMT0_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig0_dme_dme_dispdec
// base address: 0x15524
#define mmDME0_DME_CONTROL                                                                             0x2089
#define mmDME0_DME_CONTROL_BASE_IDX                                                                    2
#define mmDME0_DME_MEMORY_CONTROL                                                                      0x208a
#define mmDME0_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig0_dispdec
// base address: 0x0
#define mmDIG0_DIG_FE_CNTL                                                                             0x208b
#define mmDIG0_DIG_FE_CNTL_BASE_IDX                                                                    2
#define mmDIG0_DIG_OUTPUT_CRC_CNTL                                                                     0x208c
#define mmDIG0_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define mmDIG0_DIG_OUTPUT_CRC_RESULT                                                                   0x208d
#define mmDIG0_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define mmDIG0_DIG_CLOCK_PATTERN                                                                       0x208e
#define mmDIG0_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define mmDIG0_DIG_TEST_PATTERN                                                                        0x208f
#define mmDIG0_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define mmDIG0_DIG_RANDOM_PATTERN_SEED                                                                 0x2090
#define mmDIG0_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define mmDIG0_DIG_FIFO_STATUS                                                                         0x2091
#define mmDIG0_DIG_FIFO_STATUS_BASE_IDX                                                                2
#define mmDIG0_HDMI_METADATA_PACKET_CONTROL                                                            0x2092
#define mmDIG0_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define mmDIG0_HDMI_CONTROL                                                                            0x2093
#define mmDIG0_HDMI_CONTROL_BASE_IDX                                                                   2
#define mmDIG0_HDMI_STATUS                                                                             0x2094
#define mmDIG0_HDMI_STATUS_BASE_IDX                                                                    2
#define mmDIG0_HDMI_AUDIO_PACKET_CONTROL                                                               0x2095
#define mmDIG0_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define mmDIG0_HDMI_ACR_PACKET_CONTROL                                                                 0x2096
#define mmDIG0_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG0_HDMI_VBI_PACKET_CONTROL                                                                 0x2097
#define mmDIG0_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG0_HDMI_INFOFRAME_CONTROL0                                                                 0x2098
#define mmDIG0_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define mmDIG0_HDMI_INFOFRAME_CONTROL1                                                                 0x2099
#define mmDIG0_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL0                                                            0x209a
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL6                                                            0x209b
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL5                                                            0x209c
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define mmDIG0_HDMI_GC                                                                                 0x209d
#define mmDIG0_HDMI_GC_BASE_IDX                                                                        2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL1                                                            0x209e
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL2                                                            0x209f
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL3                                                            0x20a0
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL4                                                            0x20a1
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL7                                                            0x20a2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL8                                                            0x20a3
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL9                                                            0x20a4
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL10                                                           0x20a5
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define mmDIG0_HDMI_DB_CONTROL                                                                         0x20a6
#define mmDIG0_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define mmDIG0_HDMI_ACR_32_0                                                                           0x20a7
#define mmDIG0_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_32_1                                                                           0x20a8
#define mmDIG0_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_44_0                                                                           0x20a9
#define mmDIG0_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_44_1                                                                           0x20aa
#define mmDIG0_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_48_0                                                                           0x20ab
#define mmDIG0_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_48_1                                                                           0x20ac
#define mmDIG0_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_STATUS_0                                                                       0x20ad
#define mmDIG0_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define mmDIG0_HDMI_ACR_STATUS_1                                                                       0x20ae
#define mmDIG0_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define mmDIG0_AFMT_CNTL                                                                               0x20af
#define mmDIG0_AFMT_CNTL_BASE_IDX                                                                      2
#define mmDIG0_DIG_BE_CNTL                                                                             0x20b0
#define mmDIG0_DIG_BE_CNTL_BASE_IDX                                                                    2
#define mmDIG0_DIG_BE_EN_CNTL                                                                          0x20b1
#define mmDIG0_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define mmDIG0_TMDS_CNTL                                                                               0x20d7
#define mmDIG0_TMDS_CNTL_BASE_IDX                                                                      2
#define mmDIG0_TMDS_CONTROL_CHAR                                                                       0x20d8
#define mmDIG0_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define mmDIG0_TMDS_CONTROL0_FEEDBACK                                                                  0x20d9
#define mmDIG0_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define mmDIG0_TMDS_STEREOSYNC_CTL_SEL                                                                 0x20da
#define mmDIG0_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x20db
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x20dc
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define mmDIG0_TMDS_CTL_BITS                                                                           0x20de
#define mmDIG0_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define mmDIG0_TMDS_DCBALANCER_CONTROL                                                                 0x20df
#define mmDIG0_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define mmDIG0_TMDS_SYNC_DCBALANCE_CHAR                                                                0x20e0
#define mmDIG0_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define mmDIG0_TMDS_CTL0_1_GEN_CNTL                                                                    0x20e1
#define mmDIG0_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG0_TMDS_CTL2_3_GEN_CNTL                                                                    0x20e2
#define mmDIG0_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG0_DIG_VERSION                                                                             0x20e4
#define mmDIG0_DIG_VERSION_BASE_IDX                                                                    2
#define mmDIG0_DIG_LANE_ENABLE                                                                         0x20e5
#define mmDIG0_DIG_LANE_ENABLE_BASE_IDX                                                                2
#define mmDIG0_FORCE_DIG_DISABLE                                                                       0x20e6
#define mmDIG0_FORCE_DIG_DISABLE_BASE_IDX                                                              2

// addressBlock: dce_dc_dio_dp0_dispdec
// base address: 0x0
#define mmDP0_DP_LINK_CNTL                                                                             0x2108
#define mmDP0_DP_LINK_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_PIXEL_FORMAT                                                                          0x2109
#define mmDP0_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define mmDP0_DP_MSA_COLORIMETRY                                                                       0x210a
#define mmDP0_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define mmDP0_DP_CONFIG                                                                                0x210b
#define mmDP0_DP_CONFIG_BASE_IDX                                                                       2
#define mmDP0_DP_VID_STREAM_CNTL                                                                       0x210c
#define mmDP0_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_STEER_FIFO                                                                            0x210d
#define mmDP0_DP_STEER_FIFO_BASE_IDX                                                                   2
#define mmDP0_DP_MSA_MISC                                                                              0x210e
#define mmDP0_DP_MSA_MISC_BASE_IDX                                                                     2
#define mmDP0_DP_DPHY_INTERNAL_CTRL                                                                    0x210f
#define mmDP0_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define mmDP0_DP_VID_TIMING                                                                            0x2110
#define mmDP0_DP_VID_TIMING_BASE_IDX                                                                   2
#define mmDP0_DP_VID_N                                                                                 0x2111
#define mmDP0_DP_VID_N_BASE_IDX                                                                        2
#define mmDP0_DP_VID_M                                                                                 0x2112
#define mmDP0_DP_VID_M_BASE_IDX                                                                        2
#define mmDP0_DP_LINK_FRAMING_CNTL                                                                     0x2113
#define mmDP0_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define mmDP0_DP_HBR2_EYE_PATTERN                                                                      0x2114
#define mmDP0_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define mmDP0_DP_VID_MSA_VBID                                                                          0x2115
#define mmDP0_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define mmDP0_DP_VID_INTERRUPT_CNTL                                                                    0x2116
#define mmDP0_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define mmDP0_DP_DPHY_CNTL                                                                             0x2117
#define mmDP0_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x2118
#define mmDP0_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define mmDP0_DP_DPHY_SYM0                                                                             0x2119
#define mmDP0_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_SYM1                                                                             0x211a
#define mmDP0_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_SYM2                                                                             0x211b
#define mmDP0_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_8B10B_CNTL                                                                       0x211c
#define mmDP0_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_DPHY_PRBS_CNTL                                                                        0x211d
#define mmDP0_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define mmDP0_DP_DPHY_SCRAM_CNTL                                                                       0x211e
#define mmDP0_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_DPHY_CRC_EN                                                                           0x211f
#define mmDP0_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define mmDP0_DP_DPHY_CRC_CNTL                                                                         0x2120
#define mmDP0_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define mmDP0_DP_DPHY_CRC_RESULT                                                                       0x2121
#define mmDP0_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define mmDP0_DP_DPHY_CRC_MST_CNTL                                                                     0x2122
#define mmDP0_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define mmDP0_DP_DPHY_CRC_MST_STATUS                                                                   0x2123
#define mmDP0_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define mmDP0_DP_DPHY_FAST_TRAINING                                                                    0x2124
#define mmDP0_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define mmDP0_DP_DPHY_FAST_TRAINING_STATUS                                                             0x2125
#define mmDP0_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define mmDP0_DP_SEC_CNTL                                                                              0x212b
#define mmDP0_DP_SEC_CNTL_BASE_IDX                                                                     2
#define mmDP0_DP_SEC_CNTL1                                                                             0x212c
#define mmDP0_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_FRAMING1                                                                          0x212d
#define mmDP0_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_FRAMING2                                                                          0x212e
#define mmDP0_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_FRAMING3                                                                          0x212f
#define mmDP0_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_FRAMING4                                                                          0x2130
#define mmDP0_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_AUD_N                                                                             0x2131
#define mmDP0_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_AUD_N_READBACK                                                                    0x2132
#define mmDP0_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define mmDP0_DP_SEC_AUD_M                                                                             0x2133
#define mmDP0_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_AUD_M_READBACK                                                                    0x2134
#define mmDP0_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define mmDP0_DP_SEC_TIMESTAMP                                                                         0x2135
#define mmDP0_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define mmDP0_DP_SEC_PACKET_CNTL                                                                       0x2136
#define mmDP0_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_MSE_RATE_CNTL                                                                         0x2137
#define mmDP0_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define mmDP0_DP_MSE_RATE_UPDATE                                                                       0x2139
#define mmDP0_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define mmDP0_DP_MSE_SAT0                                                                              0x213a
#define mmDP0_DP_MSE_SAT0_BASE_IDX                                                                     2
#define mmDP0_DP_MSE_SAT1                                                                              0x213b
#define mmDP0_DP_MSE_SAT1_BASE_IDX                                                                     2
#define mmDP0_DP_MSE_SAT2                                                                              0x213c
#define mmDP0_DP_MSE_SAT2_BASE_IDX                                                                     2
#define mmDP0_DP_MSE_SAT_UPDATE                                                                        0x213d
#define mmDP0_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define mmDP0_DP_MSE_LINK_TIMING                                                                       0x213e
#define mmDP0_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define mmDP0_DP_MSE_MISC_CNTL                                                                         0x213f
#define mmDP0_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define mmDP0_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x2144
#define mmDP0_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define mmDP0_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x2145
#define mmDP0_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define mmDP0_DP_MSE_SAT0_STATUS                                                                       0x2147
#define mmDP0_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define mmDP0_DP_MSE_SAT1_STATUS                                                                       0x2148
#define mmDP0_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define mmDP0_DP_MSE_SAT2_STATUS                                                                       0x2149
#define mmDP0_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define mmDP0_DP_MSA_TIMING_PARAM1                                                                     0x214c
#define mmDP0_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define mmDP0_DP_MSA_TIMING_PARAM2                                                                     0x214d
#define mmDP0_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define mmDP0_DP_MSA_TIMING_PARAM3                                                                     0x214e
#define mmDP0_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define mmDP0_DP_MSA_TIMING_PARAM4                                                                     0x214f
#define mmDP0_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define mmDP0_DP_MSO_CNTL                                                                              0x2150
#define mmDP0_DP_MSO_CNTL_BASE_IDX                                                                     2
#define mmDP0_DP_MSO_CNTL1                                                                             0x2151
#define mmDP0_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define mmDP0_DP_DSC_CNTL                                                                              0x2152
#define mmDP0_DP_DSC_CNTL_BASE_IDX                                                                     2
#define mmDP0_DP_SEC_CNTL2                                                                             0x2153
#define mmDP0_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL3                                                                             0x2154
#define mmDP0_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL4                                                                             0x2155
#define mmDP0_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL5                                                                             0x2156
#define mmDP0_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL6                                                                             0x2157
#define mmDP0_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL7                                                                             0x2158
#define mmDP0_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define mmDP0_DP_DB_CNTL                                                                               0x2159
#define mmDP0_DP_DB_CNTL_BASE_IDX                                                                      2
#define mmDP0_DP_MSA_VBID_MISC                                                                         0x215a
#define mmDP0_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define mmDP0_DP_SEC_METADATA_TRANSMISSION                                                             0x215b
#define mmDP0_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define mmDP0_DP_DSC_BYTES_PER_PIXEL                                                                   0x215c
#define mmDP0_DP_DSC_BYTES_PER_PIXEL_BASE_IDX                                                          2
#define mmDP0_DP_ALPM_CNTL                                                                             0x215d
#define mmDP0_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_GSP8_CNTL                                                                             0x215e
#define mmDP0_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_GSP9_CNTL                                                                             0x215f
#define mmDP0_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_GSP10_CNTL                                                                            0x2160
#define mmDP0_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define mmDP0_DP_GSP11_CNTL                                                                            0x2161
#define mmDP0_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define mmDP0_DP_GSP_EN_DB_STATUS                                                                      0x2162
#define mmDP0_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig1_vpg_vpg_dispdec
// base address: 0x158a0
#define mmVPG1_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x2168
#define mmVPG1_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define mmVPG1_VPG_GENERIC_PACKET_DATA                                                                 0x2169
#define mmVPG1_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define mmVPG1_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x216a
#define mmVPG1_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define mmVPG1_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x216b
#define mmVPG1_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define mmVPG1_VPG_GENERIC_STATUS                                                                      0x216c
#define mmVPG1_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define mmVPG1_VPG_MEM_PWR                                                                             0x216d
#define mmVPG1_VPG_MEM_PWR_BASE_IDX                                                                    2
#define mmVPG1_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x216e
#define mmVPG1_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define mmVPG1_VPG_ISRC1_2_DATA                                                                        0x216f
#define mmVPG1_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define mmVPG1_VPG_MPEG_INFO0                                                                          0x2170
#define mmVPG1_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define mmVPG1_VPG_MPEG_INFO1                                                                          0x2171
#define mmVPG1_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig1_afmt_afmt_dispdec
// base address: 0x158cc
#define mmAFMT1_AFMT_VBI_PACKET_CONTROL                                                                0x2174
#define mmAFMT1_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL2                                                             0x2175
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define mmAFMT1_AFMT_AUDIO_INFO0                                                                       0x2176
#define mmAFMT1_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define mmAFMT1_AFMT_AUDIO_INFO1                                                                       0x2177
#define mmAFMT1_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define mmAFMT1_AFMT_60958_0                                                                           0x2178
#define mmAFMT1_AFMT_60958_0_BASE_IDX                                                                  2
#define mmAFMT1_AFMT_60958_1                                                                           0x2179
#define mmAFMT1_AFMT_60958_1_BASE_IDX                                                                  2
#define mmAFMT1_AFMT_AUDIO_CRC_CONTROL                                                                 0x217a
#define mmAFMT1_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT1_AFMT_RAMP_CONTROL0                                                                     0x217b
#define mmAFMT1_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define mmAFMT1_AFMT_RAMP_CONTROL1                                                                     0x217c
#define mmAFMT1_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define mmAFMT1_AFMT_RAMP_CONTROL2                                                                     0x217d
#define mmAFMT1_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define mmAFMT1_AFMT_RAMP_CONTROL3                                                                     0x217e
#define mmAFMT1_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define mmAFMT1_AFMT_60958_2                                                                           0x217f
#define mmAFMT1_AFMT_60958_2_BASE_IDX                                                                  2
#define mmAFMT1_AFMT_AUDIO_CRC_RESULT                                                                  0x2180
#define mmAFMT1_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define mmAFMT1_AFMT_STATUS                                                                            0x2181
#define mmAFMT1_AFMT_STATUS_BASE_IDX                                                                   2
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL                                                              0x2182
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define mmAFMT1_AFMT_INFOFRAME_CONTROL0                                                                0x2183
#define mmAFMT1_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define mmAFMT1_AFMT_INTERRUPT_STATUS                                                                  0x2184
#define mmAFMT1_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define mmAFMT1_AFMT_AUDIO_SRC_CONTROL                                                                 0x2185
#define mmAFMT1_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT1_AFMT_MEM_PWR                                                                           0x2187
#define mmAFMT1_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig1_dme_dme_dispdec
// base address: 0x15924
#define mmDME1_DME_CONTROL                                                                             0x2189
#define mmDME1_DME_CONTROL_BASE_IDX                                                                    2
#define mmDME1_DME_MEMORY_CONTROL                                                                      0x218a
#define mmDME1_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig1_dispdec
// base address: 0x400
#define mmDIG1_DIG_FE_CNTL                                                                             0x218b
#define mmDIG1_DIG_FE_CNTL_BASE_IDX                                                                    2
#define mmDIG1_DIG_OUTPUT_CRC_CNTL                                                                     0x218c
#define mmDIG1_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define mmDIG1_DIG_OUTPUT_CRC_RESULT                                                                   0x218d
#define mmDIG1_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define mmDIG1_DIG_CLOCK_PATTERN                                                                       0x218e
#define mmDIG1_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define mmDIG1_DIG_TEST_PATTERN                                                                        0x218f
#define mmDIG1_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define mmDIG1_DIG_RANDOM_PATTERN_SEED                                                                 0x2190
#define mmDIG1_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define mmDIG1_DIG_FIFO_STATUS                                                                         0x2191
#define mmDIG1_DIG_FIFO_STATUS_BASE_IDX                                                                2
#define mmDIG1_HDMI_METADATA_PACKET_CONTROL                                                            0x2192
#define mmDIG1_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define mmDIG1_HDMI_CONTROL                                                                            0x2193
#define mmDIG1_HDMI_CONTROL_BASE_IDX                                                                   2
#define mmDIG1_HDMI_STATUS                                                                             0x2194
#define mmDIG1_HDMI_STATUS_BASE_IDX                                                                    2
#define mmDIG1_HDMI_AUDIO_PACKET_CONTROL                                                               0x2195
#define mmDIG1_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define mmDIG1_HDMI_ACR_PACKET_CONTROL                                                                 0x2196
#define mmDIG1_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG1_HDMI_VBI_PACKET_CONTROL                                                                 0x2197
#define mmDIG1_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG1_HDMI_INFOFRAME_CONTROL0                                                                 0x2198
#define mmDIG1_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define mmDIG1_HDMI_INFOFRAME_CONTROL1                                                                 0x2199
#define mmDIG1_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL0                                                            0x219a
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL6                                                            0x219b
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL5                                                            0x219c
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define mmDIG1_HDMI_GC                                                                                 0x219d
#define mmDIG1_HDMI_GC_BASE_IDX                                                                        2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL1                                                            0x219e
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL2                                                            0x219f
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL3                                                            0x21a0
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL4                                                            0x21a1
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL7                                                            0x21a2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL8                                                            0x21a3
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL9                                                            0x21a4
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL10                                                           0x21a5
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define mmDIG1_HDMI_DB_CONTROL                                                                         0x21a6
#define mmDIG1_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define mmDIG1_HDMI_ACR_32_0                                                                           0x21a7
#define mmDIG1_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_32_1                                                                           0x21a8
#define mmDIG1_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_44_0                                                                           0x21a9
#define mmDIG1_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_44_1                                                                           0x21aa
#define mmDIG1_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_48_0                                                                           0x21ab
#define mmDIG1_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_48_1                                                                           0x21ac
#define mmDIG1_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_STATUS_0                                                                       0x21ad
#define mmDIG1_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define mmDIG1_HDMI_ACR_STATUS_1                                                                       0x21ae
#define mmDIG1_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define mmDIG1_AFMT_CNTL                                                                               0x21af
#define mmDIG1_AFMT_CNTL_BASE_IDX                                                                      2
#define mmDIG1_DIG_BE_CNTL                                                                             0x21b0
#define mmDIG1_DIG_BE_CNTL_BASE_IDX                                                                    2
#define mmDIG1_DIG_BE_EN_CNTL                                                                          0x21b1
#define mmDIG1_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define mmDIG1_TMDS_CNTL                                                                               0x21d7
#define mmDIG1_TMDS_CNTL_BASE_IDX                                                                      2
#define mmDIG1_TMDS_CONTROL_CHAR                                                                       0x21d8
#define mmDIG1_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define mmDIG1_TMDS_CONTROL0_FEEDBACK                                                                  0x21d9
#define mmDIG1_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define mmDIG1_TMDS_STEREOSYNC_CTL_SEL                                                                 0x21da
#define mmDIG1_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x21db
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x21dc
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define mmDIG1_TMDS_CTL_BITS                                                                           0x21de
#define mmDIG1_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define mmDIG1_TMDS_DCBALANCER_CONTROL                                                                 0x21df
#define mmDIG1_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define mmDIG1_TMDS_SYNC_DCBALANCE_CHAR                                                                0x21e0
#define mmDIG1_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define mmDIG1_TMDS_CTL0_1_GEN_CNTL                                                                    0x21e1
#define mmDIG1_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG1_TMDS_CTL2_3_GEN_CNTL                                                                    0x21e2
#define mmDIG1_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG1_DIG_VERSION                                                                             0x21e4
#define mmDIG1_DIG_VERSION_BASE_IDX                                                                    2
#define mmDIG1_DIG_LANE_ENABLE                                                                         0x21e5
#define mmDIG1_DIG_LANE_ENABLE_BASE_IDX                                                                2
#define mmDIG1_FORCE_DIG_DISABLE                                                                       0x21e6
#define mmDIG1_FORCE_DIG_DISABLE_BASE_IDX                                                              2

// addressBlock: dce_dc_dio_dp1_dispdec
// base address: 0x400
#define mmDP1_DP_LINK_CNTL                                                                             0x2208
#define mmDP1_DP_LINK_CNTL_BASE_IDX                                                                    2
#define mmDP1_DP_PIXEL_FORMAT                                                                          0x2209
#define mmDP1_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define mmDP1_DP_MSA_COLORIMETRY                                                                       0x220a
#define mmDP1_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define mmDP1_DP_CONFIG                                                                                0x220b
#define mmDP1_DP_CONFIG_BASE_IDX                                                                       2
#define mmDP1_DP_VID_STREAM_CNTL                                                                       0x220c
#define mmDP1_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define mmDP1_DP_STEER_FIFO                                                                            0x220d
#define mmDP1_DP_STEER_FIFO_BASE_IDX                                                                   2
#define mmDP1_DP_MSA_MISC                                                                              0x220e
#define mmDP1_DP_MSA_MISC_BASE_IDX                                                                     2
#define mmDP1_DP_DPHY_INTERNAL_CTRL                                                                    0x220f
#define mmDP1_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define mmDP1_DP_VID_TIMING                                                                            0x2210
#define mmDP1_DP_VID_TIMING_BASE_IDX                                                                   2
#define mmDP1_DP_VID_N                                                                                 0x2211
#define mmDP1_DP_VID_N_BASE_IDX                                                                        2
#define mmDP1_DP_VID_M                                                                                 0x2212
#define mmDP1_DP_VID_M_BASE_IDX                                                                        2
#define mmDP1_DP_LINK_FRAMING_CNTL                                                                     0x2213
#define mmDP1_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define mmDP1_DP_HBR2_EYE_PATTERN                                                                      0x2214
#define mmDP1_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define mmDP1_DP_VID_MSA_VBID                                                                          0x2215
#define mmDP1_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define mmDP1_DP_VID_INTERRUPT_CNTL                                                                    0x2216
#define mmDP1_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define mmDP1_DP_DPHY_CNTL                                                                             0x2217
#define mmDP1_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define mmDP1_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x2218
#define mmDP1_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define mmDP1_DP_DPHY_SYM0                                                                             0x2219
#define mmDP1_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define mmDP1_DP_DPHY_SYM1                                                                             0x221a
#define mmDP1_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define mmDP1_DP_DPHY_SYM2                                                                             0x221b
#define mmDP1_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define mmDP1_DP_DPHY_8B10B_CNTL                                                                       0x221c
#define mmDP1_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define mmDP1_DP_DPHY_PRBS_CNTL                                                                        0x221d
#define mmDP1_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define mmDP1_DP_DPHY_SCRAM_CNTL                                                                       0x221e
#define mmDP1_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define mmDP1_DP_DPHY_CRC_EN                                                                           0x221f
#define mmDP1_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define mmDP1_DP_DPHY_CRC_CNTL                                                                         0x2220
#define mmDP1_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define mmDP1_DP_DPHY_CRC_RESULT                                                                       0x2221
#define mmDP1_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define mmDP1_DP_DPHY_CRC_MST_CNTL                                                                     0x2222
#define mmDP1_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define mmDP1_DP_DPHY_CRC_MST_STATUS                                                                   0x2223
#define mmDP1_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define mmDP1_DP_DPHY_FAST_TRAINING                                                                    0x2224
#define mmDP1_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define mmDP1_DP_DPHY_FAST_TRAINING_STATUS                                                             0x2225
#define mmDP1_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define mmDP1_DP_SEC_CNTL                                                                              0x222b
#define mmDP1_DP_SEC_CNTL_BASE_IDX                                                                     2
#define mmDP1_DP_SEC_CNTL1                                                                             0x222c
#define mmDP1_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_FRAMING1                                                                          0x222d
#define mmDP1_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define mmDP1_DP_SEC_FRAMING2                                                                          0x222e
#define mmDP1_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define mmDP1_DP_SEC_FRAMING3                                                                          0x222f
#define mmDP1_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define mmDP1_DP_SEC_FRAMING4                                                                          0x2230
#define mmDP1_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define mmDP1_DP_SEC_AUD_N                                                                             0x2231
#define mmDP1_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_AUD_N_READBACK                                                                    0x2232
#define mmDP1_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define mmDP1_DP_SEC_AUD_M                                                                             0x2233
#define mmDP1_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_AUD_M_READBACK                                                                    0x2234
#define mmDP1_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define mmDP1_DP_SEC_TIMESTAMP                                                                         0x2235
#define mmDP1_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define mmDP1_DP_SEC_PACKET_CNTL                                                                       0x2236
#define mmDP1_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define mmDP1_DP_MSE_RATE_CNTL                                                                         0x2237
#define mmDP1_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define mmDP1_DP_MSE_RATE_UPDATE                                                                       0x2239
#define mmDP1_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define mmDP1_DP_MSE_SAT0                                                                              0x223a
#define mmDP1_DP_MSE_SAT0_BASE_IDX                                                                     2
#define mmDP1_DP_MSE_SAT1                                                                              0x223b
#define mmDP1_DP_MSE_SAT1_BASE_IDX                                                                     2
#define mmDP1_DP_MSE_SAT2                                                                              0x223c
#define mmDP1_DP_MSE_SAT2_BASE_IDX                                                                     2
#define mmDP1_DP_MSE_SAT_UPDATE                                                                        0x223d
#define mmDP1_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define mmDP1_DP_MSE_LINK_TIMING                                                                       0x223e
#define mmDP1_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define mmDP1_DP_MSE_MISC_CNTL                                                                         0x223f
#define mmDP1_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define mmDP1_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x2244
#define mmDP1_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define mmDP1_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x2245
#define mmDP1_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define mmDP1_DP_MSE_SAT0_STATUS                                                                       0x2247
#define mmDP1_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define mmDP1_DP_MSE_SAT1_STATUS                                                                       0x2248
#define mmDP1_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define mmDP1_DP_MSE_SAT2_STATUS                                                                       0x2249
#define mmDP1_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define mmDP1_DP_MSA_TIMING_PARAM1                                                                     0x224c
#define mmDP1_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define mmDP1_DP_MSA_TIMING_PARAM2                                                                     0x224d
#define mmDP1_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define mmDP1_DP_MSA_TIMING_PARAM3                                                                     0x224e
#define mmDP1_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define mmDP1_DP_MSA_TIMING_PARAM4                                                                     0x224f
#define mmDP1_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define mmDP1_DP_MSO_CNTL                                                                              0x2250
#define mmDP1_DP_MSO_CNTL_BASE_IDX                                                                     2
#define mmDP1_DP_MSO_CNTL1                                                                             0x2251
#define mmDP1_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define mmDP1_DP_DSC_CNTL                                                                              0x2252
#define mmDP1_DP_DSC_CNTL_BASE_IDX                                                                     2
#define mmDP1_DP_SEC_CNTL2                                                                             0x2253
#define mmDP1_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_CNTL3                                                                             0x2254
#define mmDP1_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_CNTL4                                                                             0x2255
#define mmDP1_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_CNTL5                                                                             0x2256
#define mmDP1_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_CNTL6                                                                             0x2257
#define mmDP1_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define mmDP1_DP_SEC_CNTL7                                                                             0x2258
#define mmDP1_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define mmDP1_DP_DB_CNTL                                                                               0x2259
#define mmDP1_DP_DB_CNTL_BASE_IDX                                                                      2
#define mmDP1_DP_MSA_VBID_MISC                                                                         0x225a
#define mmDP1_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define mmDP1_DP_SEC_METADATA_TRANSMISSION                                                             0x225b
#define mmDP1_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define mmDP1_DP_DSC_BYTES_PER_PIXEL                                                                   0x225c
#define mmDP1_DP_DSC_BYTES_PER_PIXEL_BASE_IDX                                                          2
#define mmDP1_DP_ALPM_CNTL                                                                             0x225d
#define mmDP1_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define mmDP1_DP_GSP8_CNTL                                                                             0x225e
#define mmDP1_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define mmDP1_DP_GSP9_CNTL                                                                             0x225f
#define mmDP1_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define mmDP1_DP_GSP10_CNTL                                                                            0x2260
#define mmDP1_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define mmDP1_DP_GSP11_CNTL                                                                            0x2261
#define mmDP1_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define mmDP1_DP_GSP_EN_DB_STATUS                                                                      0x2262
#define mmDP1_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2


// addressBlock: dce_dc_dcio_dcio_dispdec
// base address: 0x0
#define mmDC_GENERICA                                                                                  0x2868
#define mmDC_GENERICA_BASE_IDX                                                                         2
#define mmDC_GENERICB                                                                                  0x2869
#define mmDC_GENERICB_BASE_IDX                                                                         2
#define mmDCIO_CLOCK_CNTL                                                                              0x286a
#define mmDCIO_CLOCK_CNTL_BASE_IDX                                                                     2
#define mmDC_REF_CLK_CNTL                                                                              0x286b
#define mmDC_REF_CLK_CNTL_BASE_IDX                                                                     2
#define mmUNIPHYA_LINK_CNTL                                                                            0x286d
#define mmUNIPHYA_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYA_CHANNEL_XBAR_CNTL                                                                    0x286e
#define mmUNIPHYA_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmUNIPHYB_LINK_CNTL                                                                            0x286f
#define mmUNIPHYB_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYB_CHANNEL_XBAR_CNTL                                                                    0x2870
#define mmUNIPHYB_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmDCIO_WRCMD_DELAY                                                                             0x287e
#define mmDCIO_WRCMD_DELAY_BASE_IDX                                                                    2
#define mmDC_PINSTRAPS                                                                                 0x2880
#define mmDC_PINSTRAPS_BASE_IDX                                                                        2
#define mmLVTMA_PWRSEQ_CNTL                                                                            0x2883
#define mmLVTMA_PWRSEQ_CNTL_BASE_IDX                                                                   2
#define mmLVTMA_PWRSEQ_STATE                                                                           0x2884
#define mmLVTMA_PWRSEQ_STATE_BASE_IDX                                                                  2
#define mmLVTMA_PWRSEQ_REF_DIV                                                                         0x2885
#define mmLVTMA_PWRSEQ_REF_DIV_BASE_IDX                                                                2
#define mmLVTMA_PWRSEQ_DELAY1                                                                          0x2886
#define mmLVTMA_PWRSEQ_DELAY1_BASE_IDX                                                                 2
#define mmLVTMA_PWRSEQ_DELAY2                                                                          0x2887
#define mmLVTMA_PWRSEQ_DELAY2_BASE_IDX                                                                 2
#define mmBL_PWM_CNTL                                                                                  0x2888
#define mmBL_PWM_CNTL_BASE_IDX                                                                         2
#define mmBL_PWM_CNTL2                                                                                 0x2889
#define mmBL_PWM_CNTL2_BASE_IDX                                                                        2
#define mmBL_PWM_PERIOD_CNTL                                                                           0x288a
#define mmBL_PWM_PERIOD_CNTL_BASE_IDX                                                                  2
#define mmBL_PWM_GRP1_REG_LOCK                                                                         0x288b
#define mmBL_PWM_GRP1_REG_LOCK_BASE_IDX                                                                2
#define mmDCIO_GSL_GENLK_PAD_CNTL                                                                      0x288c
#define mmDCIO_GSL_GENLK_PAD_CNTL_BASE_IDX                                                             2
#define mmDCIO_GSL_SWAPLOCK_PAD_CNTL                                                                   0x288d
#define mmDCIO_GSL_SWAPLOCK_PAD_CNTL_BASE_IDX                                                          2
#define mmDCIO_SOFT_RESET                                                                              0x289e
#define mmDCIO_SOFT_RESET_BASE_IDX                                                                     2


// addressBlock: dce_dc_dcio_dcio_chip_dispdec
// base address: 0x0
#define mmDC_GPIO_GENERIC_MASK                                                                         0x28c8
#define mmDC_GPIO_GENERIC_MASK_BASE_IDX                                                                2
#define mmDC_GPIO_GENERIC_A                                                                            0x28c9
#define mmDC_GPIO_GENERIC_A_BASE_IDX                                                                   2
#define mmDC_GPIO_GENERIC_EN                                                                           0x28ca
#define mmDC_GPIO_GENERIC_EN_BASE_IDX                                                                  2
#define mmDC_GPIO_GENERIC_Y                                                                            0x28cb
#define mmDC_GPIO_GENERIC_Y_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC1_MASK                                                                            0x28d0
#define mmDC_GPIO_DDC1_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC1_A                                                                               0x28d1
#define mmDC_GPIO_DDC1_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC1_EN                                                                              0x28d2
#define mmDC_GPIO_DDC1_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC1_Y                                                                               0x28d3
#define mmDC_GPIO_DDC1_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC2_MASK                                                                            0x28d4
#define mmDC_GPIO_DDC2_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC2_A                                                                               0x28d5
#define mmDC_GPIO_DDC2_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC2_EN                                                                              0x28d6
#define mmDC_GPIO_DDC2_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC2_Y                                                                               0x28d7
#define mmDC_GPIO_DDC2_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDCVGA_MASK                                                                          0x28e8
#define mmDC_GPIO_DDCVGA_MASK_BASE_IDX                                                                 2
#define mmDC_GPIO_DDCVGA_A                                                                             0x28e9
#define mmDC_GPIO_DDCVGA_A_BASE_IDX                                                                    2
#define mmDC_GPIO_DDCVGA_EN                                                                            0x28ea
#define mmDC_GPIO_DDCVGA_EN_BASE_IDX                                                                   2
#define mmDC_GPIO_DDCVGA_Y                                                                             0x28eb
#define mmDC_GPIO_DDCVGA_Y_BASE_IDX                                                                    2
#define mmDC_GPIO_GENLK_MASK                                                                           0x28f0
#define mmDC_GPIO_GENLK_MASK_BASE_IDX                                                                  2
#define mmDC_GPIO_GENLK_A                                                                              0x28f1
#define mmDC_GPIO_GENLK_A_BASE_IDX                                                                     2
#define mmDC_GPIO_GENLK_EN                                                                             0x28f2
#define mmDC_GPIO_GENLK_EN_BASE_IDX                                                                    2
#define mmDC_GPIO_GENLK_Y                                                                              0x28f3
#define mmDC_GPIO_GENLK_Y_BASE_IDX                                                                     2
#define mmDC_GPIO_HPD_MASK                                                                             0x28f4
#define mmDC_GPIO_HPD_MASK_BASE_IDX                                                                    2
#define mmDC_GPIO_HPD_A                                                                                0x28f5
#define mmDC_GPIO_HPD_A_BASE_IDX                                                                       2
#define mmDC_GPIO_HPD_EN                                                                               0x28f6
#define mmDC_GPIO_HPD_EN_BASE_IDX                                                                      2
#define mmDC_GPIO_HPD_Y                                                                                0x28f7
#define mmDC_GPIO_HPD_Y_BASE_IDX                                                                       2
#define mmDC_GPIO_PWRSEQ_MASK                                                                          0x28f8
#define mmDC_GPIO_PWRSEQ_MASK_BASE_IDX                                                                 2
#define mmDC_GPIO_PWRSEQ_A                                                                             0x28f9
#define mmDC_GPIO_PWRSEQ_A_BASE_IDX                                                                    2
#define mmDC_GPIO_PWRSEQ_EN                                                                            0x28fa
#define mmDC_GPIO_PWRSEQ_EN_BASE_IDX                                                                   2
#define mmDC_GPIO_PWRSEQ_Y                                                                             0x28fb
#define mmDC_GPIO_PWRSEQ_Y_BASE_IDX                                                                    2
#define mmDC_GPIO_PAD_STRENGTH_1                                                                       0x28fc
#define mmDC_GPIO_PAD_STRENGTH_1_BASE_IDX                                                              2
#define mmDC_GPIO_PAD_STRENGTH_2                                                                       0x28fd
#define mmDC_GPIO_PAD_STRENGTH_2_BASE_IDX                                                              2
#define mmPHY_AUX_CNTL                                                                                 0x28ff
#define mmPHY_AUX_CNTL_BASE_IDX                                                                        2
#define mmDC_GPIO_TX12_EN                                                                              0x2915
#define mmDC_GPIO_TX12_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_AUX_CTRL_0                                                                           0x2916
#define mmDC_GPIO_AUX_CTRL_0_BASE_IDX                                                                  2
#define mmDC_GPIO_AUX_CTRL_1                                                                           0x2917
#define mmDC_GPIO_AUX_CTRL_1_BASE_IDX                                                                  2
#define mmDC_GPIO_AUX_CTRL_2                                                                           0x2918
#define mmDC_GPIO_AUX_CTRL_2_BASE_IDX                                                                  2
#define mmDC_GPIO_RXEN                                                                                 0x2919
#define mmDC_GPIO_RXEN_BASE_IDX                                                                        2
#define mmDC_GPIO_PULLUPEN                                                                             0x291a
#define mmDC_GPIO_PULLUPEN_BASE_IDX                                                                    2
#define mmDC_GPIO_AUX_CTRL_3                                                                           0x291b
#define mmDC_GPIO_AUX_CTRL_3_BASE_IDX                                                                  2
#define mmDC_GPIO_AUX_CTRL_4                                                                           0x291c
#define mmDC_GPIO_AUX_CTRL_4_BASE_IDX                                                                  2
#define mmDC_GPIO_AUX_CTRL_5                                                                           0x291d
#define mmDC_GPIO_AUX_CTRL_5_BASE_IDX                                                                  2
#define mmAUXI2C_PAD_ALL_PWR_OK                                                                        0x291e
#define mmAUXI2C_PAD_ALL_PWR_OK_BASE_IDX                                                               2



// addressBlock: dce_dc_dsc0_dispdec_dsc_top_dispdec
// base address: 0x0
#define mmDSC_TOP0_DSC_TOP_CONTROL                                                                     0x3000
#define mmDSC_TOP0_DSC_TOP_CONTROL_BASE_IDX                                                            2
#define mmDSC_TOP0_DSC_DEBUG_CONTROL                                                                   0x3001
#define mmDSC_TOP0_DSC_DEBUG_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dsc0_dispdec_dsccif_dispdec
// base address: 0x0
#define mmDSCCIF0_DSCCIF_CONFIG0                                                                       0x3005
#define mmDSCCIF0_DSCCIF_CONFIG0_BASE_IDX                                                              2
#define mmDSCCIF0_DSCCIF_CONFIG1                                                                       0x3006
#define mmDSCCIF0_DSCCIF_CONFIG1_BASE_IDX                                                              2


// addressBlock: dce_dc_dsc0_dispdec_dscc_dispdec
// base address: 0x0
#define mmDSCC0_DSCC_CONFIG0                                                                           0x300a
#define mmDSCC0_DSCC_CONFIG0_BASE_IDX                                                                  2
#define mmDSCC0_DSCC_CONFIG1                                                                           0x300b
#define mmDSCC0_DSCC_CONFIG1_BASE_IDX                                                                  2
#define mmDSCC0_DSCC_STATUS                                                                            0x300c
#define mmDSCC0_DSCC_STATUS_BASE_IDX                                                                   2
#define mmDSCC0_DSCC_INTERRUPT_CONTROL_STATUS                                                          0x300d
#define mmDSCC0_DSCC_INTERRUPT_CONTROL_STATUS_BASE_IDX                                                 2
#define mmDSCC0_DSCC_PPS_CONFIG0                                                                       0x300e
#define mmDSCC0_DSCC_PPS_CONFIG0_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG1                                                                       0x300f
#define mmDSCC0_DSCC_PPS_CONFIG1_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG2                                                                       0x3010
#define mmDSCC0_DSCC_PPS_CONFIG2_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG3                                                                       0x3011
#define mmDSCC0_DSCC_PPS_CONFIG3_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG4                                                                       0x3012
#define mmDSCC0_DSCC_PPS_CONFIG4_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG5                                                                       0x3013
#define mmDSCC0_DSCC_PPS_CONFIG5_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG6                                                                       0x3014
#define mmDSCC0_DSCC_PPS_CONFIG6_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG7                                                                       0x3015
#define mmDSCC0_DSCC_PPS_CONFIG7_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG8                                                                       0x3016
#define mmDSCC0_DSCC_PPS_CONFIG8_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG9                                                                       0x3017
#define mmDSCC0_DSCC_PPS_CONFIG9_BASE_IDX                                                              2
#define mmDSCC0_DSCC_PPS_CONFIG10                                                                      0x3018
#define mmDSCC0_DSCC_PPS_CONFIG10_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG11                                                                      0x3019
#define mmDSCC0_DSCC_PPS_CONFIG11_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG12                                                                      0x301a
#define mmDSCC0_DSCC_PPS_CONFIG12_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG13                                                                      0x301b
#define mmDSCC0_DSCC_PPS_CONFIG13_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG14                                                                      0x301c
#define mmDSCC0_DSCC_PPS_CONFIG14_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG15                                                                      0x301d
#define mmDSCC0_DSCC_PPS_CONFIG15_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG16                                                                      0x301e
#define mmDSCC0_DSCC_PPS_CONFIG16_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG17                                                                      0x301f
#define mmDSCC0_DSCC_PPS_CONFIG17_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG18                                                                      0x3020
#define mmDSCC0_DSCC_PPS_CONFIG18_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG19                                                                      0x3021
#define mmDSCC0_DSCC_PPS_CONFIG19_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG20                                                                      0x3022
#define mmDSCC0_DSCC_PPS_CONFIG20_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG21                                                                      0x3023
#define mmDSCC0_DSCC_PPS_CONFIG21_BASE_IDX                                                             2
#define mmDSCC0_DSCC_PPS_CONFIG22                                                                      0x3024
#define mmDSCC0_DSCC_PPS_CONFIG22_BASE_IDX                                                             2
#define mmDSCC0_DSCC_MEM_POWER_CONTROL                                                                 0x3025
#define mmDSCC0_DSCC_MEM_POWER_CONTROL_BASE_IDX                                                        2
#define mmDSCC0_DSCC_R_Y_SQUARED_ERROR_LOWER                                                           0x3026
#define mmDSCC0_DSCC_R_Y_SQUARED_ERROR_LOWER_BASE_IDX                                                  2
#define mmDSCC0_DSCC_R_Y_SQUARED_ERROR_UPPER                                                           0x3027
#define mmDSCC0_DSCC_R_Y_SQUARED_ERROR_UPPER_BASE_IDX                                                  2
#define mmDSCC0_DSCC_G_CB_SQUARED_ERROR_LOWER                                                          0x3028
#define mmDSCC0_DSCC_G_CB_SQUARED_ERROR_LOWER_BASE_IDX                                                 2
#define mmDSCC0_DSCC_G_CB_SQUARED_ERROR_UPPER                                                          0x3029
#define mmDSCC0_DSCC_G_CB_SQUARED_ERROR_UPPER_BASE_IDX                                                 2
#define mmDSCC0_DSCC_B_CR_SQUARED_ERROR_LOWER                                                          0x302a
#define mmDSCC0_DSCC_B_CR_SQUARED_ERROR_LOWER_BASE_IDX                                                 2
#define mmDSCC0_DSCC_B_CR_SQUARED_ERROR_UPPER                                                          0x302b
#define mmDSCC0_DSCC_B_CR_SQUARED_ERROR_UPPER_BASE_IDX                                                 2
#define mmDSCC0_DSCC_MAX_ABS_ERROR0                                                                    0x302c
#define mmDSCC0_DSCC_MAX_ABS_ERROR0_BASE_IDX                                                           2
#define mmDSCC0_DSCC_MAX_ABS_ERROR1                                                                    0x302d
#define mmDSCC0_DSCC_MAX_ABS_ERROR1_BASE_IDX                                                           2
#define mmDSCC0_DSCC_RATE_BUFFER0_MAX_FULLNESS_LEVEL                                                   0x302e
#define mmDSCC0_DSCC_RATE_BUFFER0_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC0_DSCC_RATE_BUFFER1_MAX_FULLNESS_LEVEL                                                   0x302f
#define mmDSCC0_DSCC_RATE_BUFFER1_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC0_DSCC_RATE_BUFFER2_MAX_FULLNESS_LEVEL                                                   0x3030
#define mmDSCC0_DSCC_RATE_BUFFER2_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC0_DSCC_RATE_BUFFER3_MAX_FULLNESS_LEVEL                                                   0x3031
#define mmDSCC0_DSCC_RATE_BUFFER3_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER0_MAX_FULLNESS_LEVEL                                           0x3032
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER0_MAX_FULLNESS_LEVEL_BASE_IDX                                  2
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER1_MAX_FULLNESS_LEVEL                                           0x3033
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER1_MAX_FULLNESS_LEVEL_BASE_IDX                                  2
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER2_MAX_FULLNESS_LEVEL                                           0x3034
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER2_MAX_FULLNESS_LEVEL_BASE_IDX                                  2
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER3_MAX_FULLNESS_LEVEL                                           0x3035
#define mmDSCC0_DSCC_RATE_CONTROL_BUFFER3_MAX_FULLNESS_LEVEL_BASE_IDX                                  2


// addressBlock: dce_dc_dsc0_dispdec_dsc_dcperfmon_dc_perfmon_dispdec
// base address: 0xc140
#define mmDC_PERFMON12_PERFCOUNTER_CNTL                                                                0x3050
#define mmDC_PERFMON12_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON12_PERFCOUNTER_CNTL2                                                               0x3051
#define mmDC_PERFMON12_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON12_PERFCOUNTER_STATE                                                               0x3052
#define mmDC_PERFMON12_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON12_PERFMON_CNTL                                                                    0x3053
#define mmDC_PERFMON12_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON12_PERFMON_CNTL2                                                                   0x3054
#define mmDC_PERFMON12_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON12_PERFMON_CVALUE_INT_MISC                                                         0x3055
#define mmDC_PERFMON12_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON12_PERFMON_CVALUE_LOW                                                              0x3056
#define mmDC_PERFMON12_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON12_PERFMON_HI                                                                      0x3057
#define mmDC_PERFMON12_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON12_PERFMON_LOW                                                                     0x3058
#define mmDC_PERFMON12_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dsc1_dispdec_dsc_top_dispdec
// base address: 0x170
#define mmDSC_TOP1_DSC_TOP_CONTROL                                                                     0x305c
#define mmDSC_TOP1_DSC_TOP_CONTROL_BASE_IDX                                                            2
#define mmDSC_TOP1_DSC_DEBUG_CONTROL                                                                   0x305d
#define mmDSC_TOP1_DSC_DEBUG_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dsc1_dispdec_dsccif_dispdec
// base address: 0x170
#define mmDSCCIF1_DSCCIF_CONFIG0                                                                       0x3061
#define mmDSCCIF1_DSCCIF_CONFIG0_BASE_IDX                                                              2
#define mmDSCCIF1_DSCCIF_CONFIG1                                                                       0x3062
#define mmDSCCIF1_DSCCIF_CONFIG1_BASE_IDX                                                              2


// addressBlock: dce_dc_dsc1_dispdec_dscc_dispdec
// base address: 0x170
#define mmDSCC1_DSCC_CONFIG0                                                                           0x3066
#define mmDSCC1_DSCC_CONFIG0_BASE_IDX                                                                  2
#define mmDSCC1_DSCC_CONFIG1                                                                           0x3067
#define mmDSCC1_DSCC_CONFIG1_BASE_IDX                                                                  2
#define mmDSCC1_DSCC_STATUS                                                                            0x3068
#define mmDSCC1_DSCC_STATUS_BASE_IDX                                                                   2
#define mmDSCC1_DSCC_INTERRUPT_CONTROL_STATUS                                                          0x3069
#define mmDSCC1_DSCC_INTERRUPT_CONTROL_STATUS_BASE_IDX                                                 2
#define mmDSCC1_DSCC_PPS_CONFIG0                                                                       0x306a
#define mmDSCC1_DSCC_PPS_CONFIG0_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG1                                                                       0x306b
#define mmDSCC1_DSCC_PPS_CONFIG1_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG2                                                                       0x306c
#define mmDSCC1_DSCC_PPS_CONFIG2_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG3                                                                       0x306d
#define mmDSCC1_DSCC_PPS_CONFIG3_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG4                                                                       0x306e
#define mmDSCC1_DSCC_PPS_CONFIG4_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG5                                                                       0x306f
#define mmDSCC1_DSCC_PPS_CONFIG5_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG6                                                                       0x3070
#define mmDSCC1_DSCC_PPS_CONFIG6_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG7                                                                       0x3071
#define mmDSCC1_DSCC_PPS_CONFIG7_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG8                                                                       0x3072
#define mmDSCC1_DSCC_PPS_CONFIG8_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG9                                                                       0x3073
#define mmDSCC1_DSCC_PPS_CONFIG9_BASE_IDX                                                              2
#define mmDSCC1_DSCC_PPS_CONFIG10                                                                      0x3074
#define mmDSCC1_DSCC_PPS_CONFIG10_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG11                                                                      0x3075
#define mmDSCC1_DSCC_PPS_CONFIG11_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG12                                                                      0x3076
#define mmDSCC1_DSCC_PPS_CONFIG12_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG13                                                                      0x3077
#define mmDSCC1_DSCC_PPS_CONFIG13_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG14                                                                      0x3078
#define mmDSCC1_DSCC_PPS_CONFIG14_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG15                                                                      0x3079
#define mmDSCC1_DSCC_PPS_CONFIG15_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG16                                                                      0x307a
#define mmDSCC1_DSCC_PPS_CONFIG16_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG17                                                                      0x307b
#define mmDSCC1_DSCC_PPS_CONFIG17_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG18                                                                      0x307c
#define mmDSCC1_DSCC_PPS_CONFIG18_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG19                                                                      0x307d
#define mmDSCC1_DSCC_PPS_CONFIG19_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG20                                                                      0x307e
#define mmDSCC1_DSCC_PPS_CONFIG20_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG21                                                                      0x307f
#define mmDSCC1_DSCC_PPS_CONFIG21_BASE_IDX                                                             2
#define mmDSCC1_DSCC_PPS_CONFIG22                                                                      0x3080
#define mmDSCC1_DSCC_PPS_CONFIG22_BASE_IDX                                                             2
#define mmDSCC1_DSCC_MEM_POWER_CONTROL                                                                 0x3081
#define mmDSCC1_DSCC_MEM_POWER_CONTROL_BASE_IDX                                                        2
#define mmDSCC1_DSCC_R_Y_SQUARED_ERROR_LOWER                                                           0x3082
#define mmDSCC1_DSCC_R_Y_SQUARED_ERROR_LOWER_BASE_IDX                                                  2
#define mmDSCC1_DSCC_R_Y_SQUARED_ERROR_UPPER                                                           0x3083
#define mmDSCC1_DSCC_R_Y_SQUARED_ERROR_UPPER_BASE_IDX                                                  2
#define mmDSCC1_DSCC_G_CB_SQUARED_ERROR_LOWER                                                          0x3084
#define mmDSCC1_DSCC_G_CB_SQUARED_ERROR_LOWER_BASE_IDX                                                 2
#define mmDSCC1_DSCC_G_CB_SQUARED_ERROR_UPPER                                                          0x3085
#define mmDSCC1_DSCC_G_CB_SQUARED_ERROR_UPPER_BASE_IDX                                                 2
#define mmDSCC1_DSCC_B_CR_SQUARED_ERROR_LOWER                                                          0x3086
#define mmDSCC1_DSCC_B_CR_SQUARED_ERROR_LOWER_BASE_IDX                                                 2
#define mmDSCC1_DSCC_B_CR_SQUARED_ERROR_UPPER                                                          0x3087
#define mmDSCC1_DSCC_B_CR_SQUARED_ERROR_UPPER_BASE_IDX                                                 2
#define mmDSCC1_DSCC_MAX_ABS_ERROR0                                                                    0x3088
#define mmDSCC1_DSCC_MAX_ABS_ERROR0_BASE_IDX                                                           2
#define mmDSCC1_DSCC_MAX_ABS_ERROR1                                                                    0x3089
#define mmDSCC1_DSCC_MAX_ABS_ERROR1_BASE_IDX                                                           2
#define mmDSCC1_DSCC_RATE_BUFFER0_MAX_FULLNESS_LEVEL                                                   0x308a
#define mmDSCC1_DSCC_RATE_BUFFER0_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC1_DSCC_RATE_BUFFER1_MAX_FULLNESS_LEVEL                                                   0x308b
#define mmDSCC1_DSCC_RATE_BUFFER1_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC1_DSCC_RATE_BUFFER2_MAX_FULLNESS_LEVEL                                                   0x308c
#define mmDSCC1_DSCC_RATE_BUFFER2_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC1_DSCC_RATE_BUFFER3_MAX_FULLNESS_LEVEL                                                   0x308d
#define mmDSCC1_DSCC_RATE_BUFFER3_MAX_FULLNESS_LEVEL_BASE_IDX                                          2
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER0_MAX_FULLNESS_LEVEL                                           0x308e
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER0_MAX_FULLNESS_LEVEL_BASE_IDX                                  2
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER1_MAX_FULLNESS_LEVEL                                           0x308f
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER1_MAX_FULLNESS_LEVEL_BASE_IDX                                  2
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER2_MAX_FULLNESS_LEVEL                                           0x3090
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER2_MAX_FULLNESS_LEVEL_BASE_IDX                                  2
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER3_MAX_FULLNESS_LEVEL                                           0x3091
#define mmDSCC1_DSCC_RATE_CONTROL_BUFFER3_MAX_FULLNESS_LEVEL_BASE_IDX                                  2


// addressBlock: dce_dc_dsc1_dispdec_dsc_dcperfmon_dc_perfmon_dispdec
// base address: 0xc2b0
#define mmDC_PERFMON13_PERFCOUNTER_CNTL                                                                0x30ac
#define mmDC_PERFMON13_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON13_PERFCOUNTER_CNTL2                                                               0x30ad
#define mmDC_PERFMON13_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON13_PERFCOUNTER_STATE                                                               0x30ae
#define mmDC_PERFMON13_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON13_PERFMON_CNTL                                                                    0x30af
#define mmDC_PERFMON13_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON13_PERFMON_CNTL2                                                                   0x30b0
#define mmDC_PERFMON13_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON13_PERFMON_CVALUE_INT_MISC                                                         0x30b1
#define mmDC_PERFMON13_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON13_PERFMON_CVALUE_LOW                                                              0x30b2
#define mmDC_PERFMON13_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON13_PERFMON_HI                                                                      0x30b3
#define mmDC_PERFMON13_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON13_PERFMON_LOW                                                                     0x30b4
#define mmDC_PERFMON13_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_wb0_dispdec_dwb_top_dispdec
// base address: 0x0
#define mmDWB_ENABLE_CLK_CTRL                                                                          0x3228
#define mmDWB_ENABLE_CLK_CTRL_BASE_IDX                                                                 2
#define mmDWB_MEM_PWR_CTRL                                                                             0x3229
#define mmDWB_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define mmFC_MODE_CTRL                                                                                 0x322a
#define mmFC_MODE_CTRL_BASE_IDX                                                                        2
#define mmFC_FLOW_CTRL                                                                                 0x322b
#define mmFC_FLOW_CTRL_BASE_IDX                                                                        2
#define mmFC_WINDOW_START                                                                              0x322c
#define mmFC_WINDOW_START_BASE_IDX                                                                     2
#define mmFC_WINDOW_SIZE                                                                               0x322d
#define mmFC_WINDOW_SIZE_BASE_IDX                                                                      2
#define mmFC_SOURCE_SIZE                                                                               0x322e
#define mmFC_SOURCE_SIZE_BASE_IDX                                                                      2
#define mmDWB_UPDATE_CTRL                                                                              0x322f
#define mmDWB_UPDATE_CTRL_BASE_IDX                                                                     2
#define mmDWB_CRC_CTRL                                                                                 0x3230
#define mmDWB_CRC_CTRL_BASE_IDX                                                                        2
#define mmDWB_CRC_MASK_R_G                                                                             0x3231
#define mmDWB_CRC_MASK_R_G_BASE_IDX                                                                    2
#define mmDWB_CRC_MASK_B_A                                                                             0x3232
#define mmDWB_CRC_MASK_B_A_BASE_IDX                                                                    2
#define mmDWB_CRC_VAL_R_G                                                                              0x3233
#define mmDWB_CRC_VAL_R_G_BASE_IDX                                                                     2
#define mmDWB_CRC_VAL_B_A                                                                              0x3234
#define mmDWB_CRC_VAL_B_A_BASE_IDX                                                                     2
#define mmDWB_OUT_CTRL                                                                                 0x3235
#define mmDWB_OUT_CTRL_BASE_IDX                                                                        2
#define mmDWB_MMHUBBUB_BACKPRESSURE_CNT_EN                                                             0x3236
#define mmDWB_MMHUBBUB_BACKPRESSURE_CNT_EN_BASE_IDX                                                    2
#define mmDWB_MMHUBBUB_BACKPRESSURE_CNT                                                                0x3237
#define mmDWB_MMHUBBUB_BACKPRESSURE_CNT_BASE_IDX                                                       2
#define mmDWB_HOST_READ_CONTROL                                                                        0x3238
#define mmDWB_HOST_READ_CONTROL_BASE_IDX                                                               2
#define mmDWB_OVERFLOW_STATUS                                                                          0x3239
#define mmDWB_OVERFLOW_STATUS_BASE_IDX                                                                 2
#define mmDWB_OVERFLOW_COUNTER                                                                         0x323a
#define mmDWB_OVERFLOW_COUNTER_BASE_IDX                                                                2
#define mmDWB_SOFT_RESET                                                                               0x323b
#define mmDWB_SOFT_RESET_BASE_IDX                                                                      2


// addressBlock: dce_dc_wb0_dispdec_wb_dcperfmon_dc_perfmon_dispdec
// base address: 0xca20
#define mmDC_PERFMON14_PERFCOUNTER_CNTL                                                                0x3288
#define mmDC_PERFMON14_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON14_PERFCOUNTER_CNTL2                                                               0x3289
#define mmDC_PERFMON14_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON14_PERFCOUNTER_STATE                                                               0x328a
#define mmDC_PERFMON14_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON14_PERFMON_CNTL                                                                    0x328b
#define mmDC_PERFMON14_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON14_PERFMON_CNTL2                                                                   0x328c
#define mmDC_PERFMON14_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON14_PERFMON_CVALUE_INT_MISC                                                         0x328d
#define mmDC_PERFMON14_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON14_PERFMON_CVALUE_LOW                                                              0x328e
#define mmDC_PERFMON14_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON14_PERFMON_HI                                                                      0x328f
#define mmDC_PERFMON14_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON14_PERFMON_LOW                                                                     0x3290
#define mmDC_PERFMON14_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_wb0_dispdec_dwbcp_dispdec
// base address: 0x0
#define mmDWB_HDR_MULT_COEF                                                                            0x3294
#define mmDWB_HDR_MULT_COEF_BASE_IDX                                                                   2
#define mmDWB_GAMUT_REMAP_MODE                                                                         0x3295
#define mmDWB_GAMUT_REMAP_MODE_BASE_IDX                                                                2
#define mmDWB_GAMUT_REMAP_COEF_FORMAT                                                                  0x3296
#define mmDWB_GAMUT_REMAP_COEF_FORMAT_BASE_IDX                                                         2
#define mmDWB_GAMUT_REMAPA_C11_C12                                                                     0x3297
#define mmDWB_GAMUT_REMAPA_C11_C12_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPA_C13_C14                                                                     0x3298
#define mmDWB_GAMUT_REMAPA_C13_C14_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPA_C21_C22                                                                     0x3299
#define mmDWB_GAMUT_REMAPA_C21_C22_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPA_C23_C24                                                                     0x329a
#define mmDWB_GAMUT_REMAPA_C23_C24_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPA_C31_C32                                                                     0x329b
#define mmDWB_GAMUT_REMAPA_C31_C32_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPA_C33_C34                                                                     0x329c
#define mmDWB_GAMUT_REMAPA_C33_C34_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPB_C11_C12                                                                     0x329d
#define mmDWB_GAMUT_REMAPB_C11_C12_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPB_C13_C14                                                                     0x329e
#define mmDWB_GAMUT_REMAPB_C13_C14_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPB_C21_C22                                                                     0x329f
#define mmDWB_GAMUT_REMAPB_C21_C22_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPB_C23_C24                                                                     0x32a0
#define mmDWB_GAMUT_REMAPB_C23_C24_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPB_C31_C32                                                                     0x32a1
#define mmDWB_GAMUT_REMAPB_C31_C32_BASE_IDX                                                            2
#define mmDWB_GAMUT_REMAPB_C33_C34                                                                     0x32a2
#define mmDWB_GAMUT_REMAPB_C33_C34_BASE_IDX                                                            2
#define mmDWB_OGAM_CONTROL                                                                             0x32a3
#define mmDWB_OGAM_CONTROL_BASE_IDX                                                                    2
#define mmDWB_OGAM_LUT_INDEX                                                                           0x32a4
#define mmDWB_OGAM_LUT_INDEX_BASE_IDX                                                                  2
#define mmDWB_OGAM_LUT_DATA                                                                            0x32a5
#define mmDWB_OGAM_LUT_DATA_BASE_IDX                                                                   2
#define mmDWB_OGAM_LUT_CONTROL                                                                         0x32a6
#define mmDWB_OGAM_LUT_CONTROL_BASE_IDX                                                                2
#define mmDWB_OGAM_RAMA_START_CNTL_B                                                                   0x32a7
#define mmDWB_OGAM_RAMA_START_CNTL_B_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_START_CNTL_G                                                                   0x32a8
#define mmDWB_OGAM_RAMA_START_CNTL_G_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_START_CNTL_R                                                                   0x32a9
#define mmDWB_OGAM_RAMA_START_CNTL_R_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_START_BASE_CNTL_B                                                              0x32aa
#define mmDWB_OGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                                     2
#define mmDWB_OGAM_RAMA_START_SLOPE_CNTL_B                                                             0x32ab
#define mmDWB_OGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                                    2
#define mmDWB_OGAM_RAMA_START_BASE_CNTL_G                                                              0x32ac
#define mmDWB_OGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                                     2
#define mmDWB_OGAM_RAMA_START_SLOPE_CNTL_G                                                             0x32ad
#define mmDWB_OGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                                    2
#define mmDWB_OGAM_RAMA_START_BASE_CNTL_R                                                              0x32ae
#define mmDWB_OGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                                     2
#define mmDWB_OGAM_RAMA_START_SLOPE_CNTL_R                                                             0x32af
#define mmDWB_OGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                                    2
#define mmDWB_OGAM_RAMA_END_CNTL1_B                                                                    0x32b0
#define mmDWB_OGAM_RAMA_END_CNTL1_B_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMA_END_CNTL2_B                                                                    0x32b1
#define mmDWB_OGAM_RAMA_END_CNTL2_B_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMA_END_CNTL1_G                                                                    0x32b2
#define mmDWB_OGAM_RAMA_END_CNTL1_G_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMA_END_CNTL2_G                                                                    0x32b3
#define mmDWB_OGAM_RAMA_END_CNTL2_G_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMA_END_CNTL1_R                                                                    0x32b4
#define mmDWB_OGAM_RAMA_END_CNTL1_R_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMA_END_CNTL2_R                                                                    0x32b5
#define mmDWB_OGAM_RAMA_END_CNTL2_R_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMA_OFFSET_B                                                                       0x32b6
#define mmDWB_OGAM_RAMA_OFFSET_B_BASE_IDX                                                              2
#define mmDWB_OGAM_RAMA_OFFSET_G                                                                       0x32b7
#define mmDWB_OGAM_RAMA_OFFSET_G_BASE_IDX                                                              2
#define mmDWB_OGAM_RAMA_OFFSET_R                                                                       0x32b8
#define mmDWB_OGAM_RAMA_OFFSET_R_BASE_IDX                                                              2
#define mmDWB_OGAM_RAMA_REGION_0_1                                                                     0x32b9
#define mmDWB_OGAM_RAMA_REGION_0_1_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMA_REGION_2_3                                                                     0x32ba
#define mmDWB_OGAM_RAMA_REGION_2_3_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMA_REGION_4_5                                                                     0x32bb
#define mmDWB_OGAM_RAMA_REGION_4_5_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMA_REGION_6_7                                                                     0x32bc
#define mmDWB_OGAM_RAMA_REGION_6_7_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMA_REGION_8_9                                                                     0x32bd
#define mmDWB_OGAM_RAMA_REGION_8_9_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMA_REGION_10_11                                                                   0x32be
#define mmDWB_OGAM_RAMA_REGION_10_11_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_12_13                                                                   0x32bf
#define mmDWB_OGAM_RAMA_REGION_12_13_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_14_15                                                                   0x32c0
#define mmDWB_OGAM_RAMA_REGION_14_15_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_16_17                                                                   0x32c1
#define mmDWB_OGAM_RAMA_REGION_16_17_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_18_19                                                                   0x32c2
#define mmDWB_OGAM_RAMA_REGION_18_19_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_20_21                                                                   0x32c3
#define mmDWB_OGAM_RAMA_REGION_20_21_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_22_23                                                                   0x32c4
#define mmDWB_OGAM_RAMA_REGION_22_23_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_24_25                                                                   0x32c5
#define mmDWB_OGAM_RAMA_REGION_24_25_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_26_27                                                                   0x32c6
#define mmDWB_OGAM_RAMA_REGION_26_27_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_28_29                                                                   0x32c7
#define mmDWB_OGAM_RAMA_REGION_28_29_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_30_31                                                                   0x32c8
#define mmDWB_OGAM_RAMA_REGION_30_31_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMA_REGION_32_33                                                                   0x32c9
#define mmDWB_OGAM_RAMA_REGION_32_33_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_START_CNTL_B                                                                   0x32ca
#define mmDWB_OGAM_RAMB_START_CNTL_B_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_START_CNTL_G                                                                   0x32cb
#define mmDWB_OGAM_RAMB_START_CNTL_G_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_START_CNTL_R                                                                   0x32cc
#define mmDWB_OGAM_RAMB_START_CNTL_R_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_START_BASE_CNTL_B                                                              0x32cd
#define mmDWB_OGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                                     2
#define mmDWB_OGAM_RAMB_START_SLOPE_CNTL_B                                                             0x32ce
#define mmDWB_OGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                                    2
#define mmDWB_OGAM_RAMB_START_BASE_CNTL_G                                                              0x32cf
#define mmDWB_OGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                                     2
#define mmDWB_OGAM_RAMB_START_SLOPE_CNTL_G                                                             0x32d0
#define mmDWB_OGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                                    2
#define mmDWB_OGAM_RAMB_START_BASE_CNTL_R                                                              0x32d1
#define mmDWB_OGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                                     2
#define mmDWB_OGAM_RAMB_START_SLOPE_CNTL_R                                                             0x32d2
#define mmDWB_OGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                                    2
#define mmDWB_OGAM_RAMB_END_CNTL1_B                                                                    0x32d3
#define mmDWB_OGAM_RAMB_END_CNTL1_B_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMB_END_CNTL2_B                                                                    0x32d4
#define mmDWB_OGAM_RAMB_END_CNTL2_B_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMB_END_CNTL1_G                                                                    0x32d5
#define mmDWB_OGAM_RAMB_END_CNTL1_G_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMB_END_CNTL2_G                                                                    0x32d6
#define mmDWB_OGAM_RAMB_END_CNTL2_G_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMB_END_CNTL1_R                                                                    0x32d7
#define mmDWB_OGAM_RAMB_END_CNTL1_R_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMB_END_CNTL2_R                                                                    0x32d8
#define mmDWB_OGAM_RAMB_END_CNTL2_R_BASE_IDX                                                           2
#define mmDWB_OGAM_RAMB_OFFSET_B                                                                       0x32d9
#define mmDWB_OGAM_RAMB_OFFSET_B_BASE_IDX                                                              2
#define mmDWB_OGAM_RAMB_OFFSET_G                                                                       0x32da
#define mmDWB_OGAM_RAMB_OFFSET_G_BASE_IDX                                                              2
#define mmDWB_OGAM_RAMB_OFFSET_R                                                                       0x32db
#define mmDWB_OGAM_RAMB_OFFSET_R_BASE_IDX                                                              2
#define mmDWB_OGAM_RAMB_REGION_0_1                                                                     0x32dc
#define mmDWB_OGAM_RAMB_REGION_0_1_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMB_REGION_2_3                                                                     0x32dd
#define mmDWB_OGAM_RAMB_REGION_2_3_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMB_REGION_4_5                                                                     0x32de
#define mmDWB_OGAM_RAMB_REGION_4_5_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMB_REGION_6_7                                                                     0x32df
#define mmDWB_OGAM_RAMB_REGION_6_7_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMB_REGION_8_9                                                                     0x32e0
#define mmDWB_OGAM_RAMB_REGION_8_9_BASE_IDX                                                            2
#define mmDWB_OGAM_RAMB_REGION_10_11                                                                   0x32e1
#define mmDWB_OGAM_RAMB_REGION_10_11_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_12_13                                                                   0x32e2
#define mmDWB_OGAM_RAMB_REGION_12_13_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_14_15                                                                   0x32e3
#define mmDWB_OGAM_RAMB_REGION_14_15_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_16_17                                                                   0x32e4
#define mmDWB_OGAM_RAMB_REGION_16_17_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_18_19                                                                   0x32e5
#define mmDWB_OGAM_RAMB_REGION_18_19_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_20_21                                                                   0x32e6
#define mmDWB_OGAM_RAMB_REGION_20_21_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_22_23                                                                   0x32e7
#define mmDWB_OGAM_RAMB_REGION_22_23_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_24_25                                                                   0x32e8
#define mmDWB_OGAM_RAMB_REGION_24_25_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_26_27                                                                   0x32e9
#define mmDWB_OGAM_RAMB_REGION_26_27_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_28_29                                                                   0x32ea
#define mmDWB_OGAM_RAMB_REGION_28_29_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_30_31                                                                   0x32eb
#define mmDWB_OGAM_RAMB_REGION_30_31_BASE_IDX                                                          2
#define mmDWB_OGAM_RAMB_REGION_32_33                                                                   0x32ec
#define mmDWB_OGAM_RAMB_REGION_32_33_BASE_IDX                                                          2


// addressBlock: dce_dc_mpc_mpcc0_dispdec
// base address: 0x0
#define mmMPCC0_MPCC_TOP_SEL                                                                           0x0000
#define mmMPCC0_MPCC_TOP_SEL_BASE_IDX                                                                  3
#define mmMPCC0_MPCC_BOT_SEL                                                                           0x0001
#define mmMPCC0_MPCC_BOT_SEL_BASE_IDX                                                                  3
#define mmMPCC0_MPCC_OPP_ID                                                                            0x0002
#define mmMPCC0_MPCC_OPP_ID_BASE_IDX                                                                   3
#define mmMPCC0_MPCC_CONTROL                                                                           0x0003
#define mmMPCC0_MPCC_CONTROL_BASE_IDX                                                                  3
#define mmMPCC0_MPCC_SM_CONTROL                                                                        0x0004
#define mmMPCC0_MPCC_SM_CONTROL_BASE_IDX                                                               3
#define mmMPCC0_MPCC_UPDATE_LOCK_SEL                                                                   0x0005
#define mmMPCC0_MPCC_UPDATE_LOCK_SEL_BASE_IDX                                                          3
#define mmMPCC0_MPCC_TOP_GAIN                                                                          0x0006
#define mmMPCC0_MPCC_TOP_GAIN_BASE_IDX                                                                 3
#define mmMPCC0_MPCC_BOT_GAIN_INSIDE                                                                   0x0007
#define mmMPCC0_MPCC_BOT_GAIN_INSIDE_BASE_IDX                                                          3
#define mmMPCC0_MPCC_BOT_GAIN_OUTSIDE                                                                  0x0008
#define mmMPCC0_MPCC_BOT_GAIN_OUTSIDE_BASE_IDX                                                         3
#define mmMPCC0_MPCC_BG_R_CR                                                                           0x0009
#define mmMPCC0_MPCC_BG_R_CR_BASE_IDX                                                                  3
#define mmMPCC0_MPCC_BG_G_Y                                                                            0x000a
#define mmMPCC0_MPCC_BG_G_Y_BASE_IDX                                                                   3
#define mmMPCC0_MPCC_BG_B_CB                                                                           0x000b
#define mmMPCC0_MPCC_BG_B_CB_BASE_IDX                                                                  3
#define mmMPCC0_MPCC_MEM_PWR_CTRL                                                                      0x000c
#define mmMPCC0_MPCC_MEM_PWR_CTRL_BASE_IDX                                                             3
#define mmMPCC0_MPCC_STATUS                                                                            0x000d
#define mmMPCC0_MPCC_STATUS_BASE_IDX                                                                   3


// addressBlock: dce_dc_mpc_mpcc1_dispdec
// base address: 0x80
#define mmMPCC1_MPCC_TOP_SEL                                                                           0x0020
#define mmMPCC1_MPCC_TOP_SEL_BASE_IDX                                                                  3
#define mmMPCC1_MPCC_BOT_SEL                                                                           0x0021
#define mmMPCC1_MPCC_BOT_SEL_BASE_IDX                                                                  3
#define mmMPCC1_MPCC_OPP_ID                                                                            0x0022
#define mmMPCC1_MPCC_OPP_ID_BASE_IDX                                                                   3
#define mmMPCC1_MPCC_CONTROL                                                                           0x0023
#define mmMPCC1_MPCC_CONTROL_BASE_IDX                                                                  3
#define mmMPCC1_MPCC_SM_CONTROL                                                                        0x0024
#define mmMPCC1_MPCC_SM_CONTROL_BASE_IDX                                                               3
#define mmMPCC1_MPCC_UPDATE_LOCK_SEL                                                                   0x0025
#define mmMPCC1_MPCC_UPDATE_LOCK_SEL_BASE_IDX                                                          3
#define mmMPCC1_MPCC_TOP_GAIN                                                                          0x0026
#define mmMPCC1_MPCC_TOP_GAIN_BASE_IDX                                                                 3
#define mmMPCC1_MPCC_BOT_GAIN_INSIDE                                                                   0x0027
#define mmMPCC1_MPCC_BOT_GAIN_INSIDE_BASE_IDX                                                          3
#define mmMPCC1_MPCC_BOT_GAIN_OUTSIDE                                                                  0x0028
#define mmMPCC1_MPCC_BOT_GAIN_OUTSIDE_BASE_IDX                                                         3
#define mmMPCC1_MPCC_BG_R_CR                                                                           0x0029
#define mmMPCC1_MPCC_BG_R_CR_BASE_IDX                                                                  3
#define mmMPCC1_MPCC_BG_G_Y                                                                            0x002a
#define mmMPCC1_MPCC_BG_G_Y_BASE_IDX                                                                   3
#define mmMPCC1_MPCC_BG_B_CB                                                                           0x002b
#define mmMPCC1_MPCC_BG_B_CB_BASE_IDX                                                                  3
#define mmMPCC1_MPCC_MEM_PWR_CTRL                                                                      0x002c
#define mmMPCC1_MPCC_MEM_PWR_CTRL_BASE_IDX                                                             3
#define mmMPCC1_MPCC_STATUS                                                                            0x002d
#define mmMPCC1_MPCC_STATUS_BASE_IDX                                                                   3


// addressBlock: dce_dc_mpc_mpcc_ogam0_dispdec
// base address: 0x0
#define mmMPCC_OGAM0_MPCC_OGAM_CONTROL                                                                 0x0100
#define mmMPCC_OGAM0_MPCC_OGAM_CONTROL_BASE_IDX                                                        3
#define mmMPCC_OGAM0_MPCC_OGAM_LUT_INDEX                                                               0x0101
#define mmMPCC_OGAM0_MPCC_OGAM_LUT_INDEX_BASE_IDX                                                      3
#define mmMPCC_OGAM0_MPCC_OGAM_LUT_DATA                                                                0x0102
#define mmMPCC_OGAM0_MPCC_OGAM_LUT_DATA_BASE_IDX                                                       3
#define mmMPCC_OGAM0_MPCC_OGAM_LUT_CONTROL                                                             0x0103
#define mmMPCC_OGAM0_MPCC_OGAM_LUT_CONTROL_BASE_IDX                                                    3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_CNTL_B                                                       0x0104
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_CNTL_B_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_CNTL_G                                                       0x0105
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_CNTL_G_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_CNTL_R                                                       0x0106
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_CNTL_R_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_SLOPE_CNTL_B                                                 0x0107
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                        3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_SLOPE_CNTL_G                                                 0x0108
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                        3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_SLOPE_CNTL_R                                                 0x0109
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                        3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_BASE_CNTL_B                                                  0x010a
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                         3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_BASE_CNTL_G                                                  0x010b
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                         3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_BASE_CNTL_R                                                  0x010c
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                         3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL1_B                                                        0x010d
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL1_B_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL2_B                                                        0x010e
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL2_B_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL1_G                                                        0x010f
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL1_G_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL2_G                                                        0x0110
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL2_G_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL1_R                                                        0x0111
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL1_R_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL2_R                                                        0x0112
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_END_CNTL2_R_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_OFFSET_B                                                           0x0113
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_OFFSET_B_BASE_IDX                                                  3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_OFFSET_G                                                           0x0114
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_OFFSET_G_BASE_IDX                                                  3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_OFFSET_R                                                           0x0115
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_OFFSET_R_BASE_IDX                                                  3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_0_1                                                         0x0116
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_0_1_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_2_3                                                         0x0117
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_2_3_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_4_5                                                         0x0118
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_4_5_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_6_7                                                         0x0119
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_6_7_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_8_9                                                         0x011a
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_8_9_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_10_11                                                       0x011b
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_10_11_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_12_13                                                       0x011c
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_12_13_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_14_15                                                       0x011d
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_14_15_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_16_17                                                       0x011e
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_16_17_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_18_19                                                       0x011f
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_18_19_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_20_21                                                       0x0120
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_20_21_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_22_23                                                       0x0121
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_22_23_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_24_25                                                       0x0122
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_24_25_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_26_27                                                       0x0123
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_26_27_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_28_29                                                       0x0124
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_28_29_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_30_31                                                       0x0125
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_30_31_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_32_33                                                       0x0126
#define mmMPCC_OGAM0_MPCC_OGAM_RAMA_REGION_32_33_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_CNTL_B                                                       0x0127
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_CNTL_B_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_CNTL_G                                                       0x0128
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_CNTL_G_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_CNTL_R                                                       0x0129
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_CNTL_R_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_SLOPE_CNTL_B                                                 0x012a
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                        3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_SLOPE_CNTL_G                                                 0x012b
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                        3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_SLOPE_CNTL_R                                                 0x012c
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                        3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_BASE_CNTL_B                                                  0x012d
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                         3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_BASE_CNTL_G                                                  0x012e
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                         3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_BASE_CNTL_R                                                  0x012f
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                         3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL1_B                                                        0x0130
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL1_B_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL2_B                                                        0x0131
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL2_B_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL1_G                                                        0x0132
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL1_G_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL2_G                                                        0x0133
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL2_G_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL1_R                                                        0x0134
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL1_R_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL2_R                                                        0x0135
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_END_CNTL2_R_BASE_IDX                                               3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_OFFSET_B                                                           0x0136
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_OFFSET_B_BASE_IDX                                                  3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_OFFSET_G                                                           0x0137
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_OFFSET_G_BASE_IDX                                                  3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_OFFSET_R                                                           0x0138
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_OFFSET_R_BASE_IDX                                                  3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_0_1                                                         0x0139
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_0_1_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_2_3                                                         0x013a
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_2_3_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_4_5                                                         0x013b
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_4_5_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_6_7                                                         0x013c
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_6_7_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_8_9                                                         0x013d
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_8_9_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_10_11                                                       0x013e
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_10_11_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_12_13                                                       0x013f
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_12_13_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_14_15                                                       0x0140
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_14_15_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_16_17                                                       0x0141
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_16_17_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_18_19                                                       0x0142
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_18_19_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_20_21                                                       0x0143
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_20_21_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_22_23                                                       0x0144
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_22_23_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_24_25                                                       0x0145
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_24_25_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_26_27                                                       0x0146
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_26_27_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_28_29                                                       0x0147
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_28_29_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_30_31                                                       0x0148
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_30_31_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_32_33                                                       0x0149
#define mmMPCC_OGAM0_MPCC_OGAM_RAMB_REGION_32_33_BASE_IDX                                              3
#define mmMPCC_OGAM0_MPCC_GAMUT_REMAP_COEF_FORMAT                                                      0x014a
#define mmMPCC_OGAM0_MPCC_GAMUT_REMAP_COEF_FORMAT_BASE_IDX                                             3
#define mmMPCC_OGAM0_MPCC_GAMUT_REMAP_MODE                                                             0x014b
#define mmMPCC_OGAM0_MPCC_GAMUT_REMAP_MODE_BASE_IDX                                                    3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C11_C12_A                                                         0x014c
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C11_C12_A_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C13_C14_A                                                         0x014d
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C13_C14_A_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C21_C22_A                                                         0x014e
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C21_C22_A_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C23_C24_A                                                         0x014f
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C23_C24_A_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C31_C32_A                                                         0x0150
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C31_C32_A_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C33_C34_A                                                         0x0151
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C33_C34_A_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C11_C12_B                                                         0x0152
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C11_C12_B_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C13_C14_B                                                         0x0153
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C13_C14_B_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C21_C22_B                                                         0x0154
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C21_C22_B_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C23_C24_B                                                         0x0155
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C23_C24_B_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C31_C32_B                                                         0x0156
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C31_C32_B_BASE_IDX                                                3
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C33_C34_B                                                         0x0157
#define mmMPCC_OGAM0_MPC_GAMUT_REMAP_C33_C34_B_BASE_IDX                                                3


// addressBlock: dce_dc_mpc_mpcc_ogam1_dispdec
// base address: 0x200
#define mmMPCC_OGAM1_MPCC_OGAM_CONTROL                                                                 0x0180
#define mmMPCC_OGAM1_MPCC_OGAM_CONTROL_BASE_IDX                                                        3
#define mmMPCC_OGAM1_MPCC_OGAM_LUT_INDEX                                                               0x0181
#define mmMPCC_OGAM1_MPCC_OGAM_LUT_INDEX_BASE_IDX                                                      3
#define mmMPCC_OGAM1_MPCC_OGAM_LUT_DATA                                                                0x0182
#define mmMPCC_OGAM1_MPCC_OGAM_LUT_DATA_BASE_IDX                                                       3
#define mmMPCC_OGAM1_MPCC_OGAM_LUT_CONTROL                                                             0x0183
#define mmMPCC_OGAM1_MPCC_OGAM_LUT_CONTROL_BASE_IDX                                                    3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_CNTL_B                                                       0x0184
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_CNTL_B_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_CNTL_G                                                       0x0185
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_CNTL_G_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_CNTL_R                                                       0x0186
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_CNTL_R_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_SLOPE_CNTL_B                                                 0x0187
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                        3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_SLOPE_CNTL_G                                                 0x0188
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                        3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_SLOPE_CNTL_R                                                 0x0189
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                        3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_BASE_CNTL_B                                                  0x018a
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                         3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_BASE_CNTL_G                                                  0x018b
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                         3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_BASE_CNTL_R                                                  0x018c
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                         3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL1_B                                                        0x018d
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL1_B_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL2_B                                                        0x018e
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL2_B_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL1_G                                                        0x018f
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL1_G_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL2_G                                                        0x0190
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL2_G_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL1_R                                                        0x0191
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL1_R_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL2_R                                                        0x0192
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_END_CNTL2_R_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_OFFSET_B                                                           0x0193
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_OFFSET_B_BASE_IDX                                                  3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_OFFSET_G                                                           0x0194
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_OFFSET_G_BASE_IDX                                                  3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_OFFSET_R                                                           0x0195
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_OFFSET_R_BASE_IDX                                                  3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_0_1                                                         0x0196
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_0_1_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_2_3                                                         0x0197
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_2_3_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_4_5                                                         0x0198
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_4_5_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_6_7                                                         0x0199
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_6_7_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_8_9                                                         0x019a
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_8_9_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_10_11                                                       0x019b
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_10_11_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_12_13                                                       0x019c
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_12_13_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_14_15                                                       0x019d
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_14_15_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_16_17                                                       0x019e
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_16_17_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_18_19                                                       0x019f
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_18_19_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_20_21                                                       0x01a0
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_20_21_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_22_23                                                       0x01a1
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_22_23_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_24_25                                                       0x01a2
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_24_25_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_26_27                                                       0x01a3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_26_27_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_28_29                                                       0x01a4
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_28_29_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_30_31                                                       0x01a5
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_30_31_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_32_33                                                       0x01a6
#define mmMPCC_OGAM1_MPCC_OGAM_RAMA_REGION_32_33_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_CNTL_B                                                       0x01a7
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_CNTL_B_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_CNTL_G                                                       0x01a8
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_CNTL_G_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_CNTL_R                                                       0x01a9
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_CNTL_R_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_SLOPE_CNTL_B                                                 0x01aa
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                        3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_SLOPE_CNTL_G                                                 0x01ab
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                        3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_SLOPE_CNTL_R                                                 0x01ac
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                        3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_BASE_CNTL_B                                                  0x01ad
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                         3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_BASE_CNTL_G                                                  0x01ae
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                         3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_BASE_CNTL_R                                                  0x01af
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                         3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL1_B                                                        0x01b0
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL1_B_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL2_B                                                        0x01b1
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL2_B_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL1_G                                                        0x01b2
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL1_G_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL2_G                                                        0x01b3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL2_G_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL1_R                                                        0x01b4
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL1_R_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL2_R                                                        0x01b5
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_END_CNTL2_R_BASE_IDX                                               3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_OFFSET_B                                                           0x01b6
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_OFFSET_B_BASE_IDX                                                  3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_OFFSET_G                                                           0x01b7
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_OFFSET_G_BASE_IDX                                                  3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_OFFSET_R                                                           0x01b8
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_OFFSET_R_BASE_IDX                                                  3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_0_1                                                         0x01b9
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_0_1_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_2_3                                                         0x01ba
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_2_3_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_4_5                                                         0x01bb
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_4_5_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_6_7                                                         0x01bc
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_6_7_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_8_9                                                         0x01bd
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_8_9_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_10_11                                                       0x01be
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_10_11_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_12_13                                                       0x01bf
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_12_13_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_14_15                                                       0x01c0
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_14_15_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_16_17                                                       0x01c1
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_16_17_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_18_19                                                       0x01c2
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_18_19_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_20_21                                                       0x01c3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_20_21_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_22_23                                                       0x01c4
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_22_23_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_24_25                                                       0x01c5
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_24_25_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_26_27                                                       0x01c6
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_26_27_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_28_29                                                       0x01c7
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_28_29_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_30_31                                                       0x01c8
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_30_31_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_32_33                                                       0x01c9
#define mmMPCC_OGAM1_MPCC_OGAM_RAMB_REGION_32_33_BASE_IDX                                              3
#define mmMPCC_OGAM1_MPCC_GAMUT_REMAP_COEF_FORMAT                                                      0x01ca
#define mmMPCC_OGAM1_MPCC_GAMUT_REMAP_COEF_FORMAT_BASE_IDX                                             3
#define mmMPCC_OGAM1_MPCC_GAMUT_REMAP_MODE                                                             0x01cb
#define mmMPCC_OGAM1_MPCC_GAMUT_REMAP_MODE_BASE_IDX                                                    3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C11_C12_A                                                         0x01cc
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C11_C12_A_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C13_C14_A                                                         0x01cd
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C13_C14_A_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C21_C22_A                                                         0x01ce
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C21_C22_A_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C23_C24_A                                                         0x01cf
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C23_C24_A_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C31_C32_A                                                         0x01d0
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C31_C32_A_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C33_C34_A                                                         0x01d1
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C33_C34_A_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C11_C12_B                                                         0x01d2
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C11_C12_B_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C13_C14_B                                                         0x01d3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C13_C14_B_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C21_C22_B                                                         0x01d4
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C21_C22_B_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C23_C24_B                                                         0x01d5
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C23_C24_B_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C31_C32_B                                                         0x01d6
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C31_C32_B_BASE_IDX                                                3
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C33_C34_B                                                         0x01d7
#define mmMPCC_OGAM1_MPC_GAMUT_REMAP_C33_C34_B_BASE_IDX                                                3


// addressBlock: dce_dc_mpc_mpc_cfg_dispdec
// base address: 0x0
#define mmMPC_CLOCK_CONTROL                                                                            0x0500
#define mmMPC_CLOCK_CONTROL_BASE_IDX                                                                   3
#define mmMPC_SOFT_RESET                                                                               0x0501
#define mmMPC_SOFT_RESET_BASE_IDX                                                                      3
#define mmMPC_CRC_CTRL                                                                                 0x0502
#define mmMPC_CRC_CTRL_BASE_IDX                                                                        3
#define mmMPC_CRC_SEL_CONTROL                                                                          0x0503
#define mmMPC_CRC_SEL_CONTROL_BASE_IDX                                                                 3
#define mmMPC_CRC_RESULT_AR                                                                            0x0504
#define mmMPC_CRC_RESULT_AR_BASE_IDX                                                                   3
#define mmMPC_CRC_RESULT_GB                                                                            0x0505
#define mmMPC_CRC_RESULT_GB_BASE_IDX                                                                   3
#define mmMPC_CRC_RESULT_C                                                                             0x0506
#define mmMPC_CRC_RESULT_C_BASE_IDX                                                                    3
#define mmMPC_PERFMON_EVENT_CTRL                                                                       0x0509
#define mmMPC_PERFMON_EVENT_CTRL_BASE_IDX                                                              3
#define mmMPC_BYPASS_BG_AR                                                                             0x050a
#define mmMPC_BYPASS_BG_AR_BASE_IDX                                                                    3
#define mmMPC_BYPASS_BG_GB                                                                             0x050b
#define mmMPC_BYPASS_BG_GB_BASE_IDX                                                                    3
#define mmMPC_HOST_READ_CONTROL                                                                        0x050c
#define mmMPC_HOST_READ_CONTROL_BASE_IDX                                                               3
#define mmMPC_DPP_PENDING_STATUS                                                                       0x050d
#define mmMPC_DPP_PENDING_STATUS_BASE_IDX                                                              3
#define mmMPC_PENDING_STATUS_MISC                                                                      0x050e
#define mmMPC_PENDING_STATUS_MISC_BASE_IDX                                                             3
#define mmADR_CFG_CUR_VUPDATE_LOCK_SET0                                                                0x050f
#define mmADR_CFG_CUR_VUPDATE_LOCK_SET0_BASE_IDX                                                       3
#define mmADR_CFG_VUPDATE_LOCK_SET0                                                                    0x0510
#define mmADR_CFG_VUPDATE_LOCK_SET0_BASE_IDX                                                           3
#define mmADR_VUPDATE_LOCK_SET0                                                                        0x0511
#define mmADR_VUPDATE_LOCK_SET0_BASE_IDX                                                               3
#define mmCFG_VUPDATE_LOCK_SET0                                                                        0x0512
#define mmCFG_VUPDATE_LOCK_SET0_BASE_IDX                                                               3
#define mmCUR_VUPDATE_LOCK_SET0                                                                        0x0513
#define mmCUR_VUPDATE_LOCK_SET0_BASE_IDX                                                               3
#define mmADR_CFG_CUR_VUPDATE_LOCK_SET1                                                                0x0514
#define mmADR_CFG_CUR_VUPDATE_LOCK_SET1_BASE_IDX                                                       3
#define mmADR_CFG_VUPDATE_LOCK_SET1                                                                    0x0515
#define mmADR_CFG_VUPDATE_LOCK_SET1_BASE_IDX                                                           3
#define mmADR_VUPDATE_LOCK_SET1                                                                        0x0516
#define mmADR_VUPDATE_LOCK_SET1_BASE_IDX                                                               3
#define mmCFG_VUPDATE_LOCK_SET1                                                                        0x0517
#define mmCFG_VUPDATE_LOCK_SET1_BASE_IDX                                                               3
#define mmCUR_VUPDATE_LOCK_SET1                                                                        0x0518
#define mmCUR_VUPDATE_LOCK_SET1_BASE_IDX                                                               3
#define mmMPC_DWB0_MUX                                                                                 0x055c
#define mmMPC_DWB0_MUX_BASE_IDX                                                                        3


// addressBlock: dce_dc_mpc_mpc_ocsc_dispdec
// base address: 0x0
#define mmMPC_OUT0_MUX                                                                                 0x0580
#define mmMPC_OUT0_MUX_BASE_IDX                                                                        3
#define mmMPC_OUT0_DENORM_CONTROL                                                                      0x0581
#define mmMPC_OUT0_DENORM_CONTROL_BASE_IDX                                                             3
#define mmMPC_OUT0_DENORM_CLAMP_G_Y                                                                    0x0582
#define mmMPC_OUT0_DENORM_CLAMP_G_Y_BASE_IDX                                                           3
#define mmMPC_OUT0_DENORM_CLAMP_B_CB                                                                   0x0583
#define mmMPC_OUT0_DENORM_CLAMP_B_CB_BASE_IDX                                                          3
#define mmMPC_OUT1_MUX                                                                                 0x0584
#define mmMPC_OUT1_MUX_BASE_IDX                                                                        3
#define mmMPC_OUT1_DENORM_CONTROL                                                                      0x0585
#define mmMPC_OUT1_DENORM_CONTROL_BASE_IDX                                                             3
#define mmMPC_OUT1_DENORM_CLAMP_G_Y                                                                    0x0586
#define mmMPC_OUT1_DENORM_CLAMP_G_Y_BASE_IDX                                                           3
#define mmMPC_OUT1_DENORM_CLAMP_B_CB                                                                   0x0587
#define mmMPC_OUT1_DENORM_CLAMP_B_CB_BASE_IDX                                                          3
#define mmMPC_OUT_CSC_COEF_FORMAT                                                                      0x0598
#define mmMPC_OUT_CSC_COEF_FORMAT_BASE_IDX                                                             3
#define mmMPC_OUT0_CSC_MODE                                                                            0x0599
#define mmMPC_OUT0_CSC_MODE_BASE_IDX                                                                   3
#define mmMPC_OUT0_CSC_C11_C12_A                                                                       0x059a
#define mmMPC_OUT0_CSC_C11_C12_A_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C13_C14_A                                                                       0x059b
#define mmMPC_OUT0_CSC_C13_C14_A_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C21_C22_A                                                                       0x059c
#define mmMPC_OUT0_CSC_C21_C22_A_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C23_C24_A                                                                       0x059d
#define mmMPC_OUT0_CSC_C23_C24_A_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C31_C32_A                                                                       0x059e
#define mmMPC_OUT0_CSC_C31_C32_A_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C33_C34_A                                                                       0x059f
#define mmMPC_OUT0_CSC_C33_C34_A_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C11_C12_B                                                                       0x05a0
#define mmMPC_OUT0_CSC_C11_C12_B_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C13_C14_B                                                                       0x05a1
#define mmMPC_OUT0_CSC_C13_C14_B_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C21_C22_B                                                                       0x05a2
#define mmMPC_OUT0_CSC_C21_C22_B_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C23_C24_B                                                                       0x05a3
#define mmMPC_OUT0_CSC_C23_C24_B_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C31_C32_B                                                                       0x05a4
#define mmMPC_OUT0_CSC_C31_C32_B_BASE_IDX                                                              3
#define mmMPC_OUT0_CSC_C33_C34_B                                                                       0x05a5
#define mmMPC_OUT0_CSC_C33_C34_B_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_MODE                                                                            0x05a6
#define mmMPC_OUT1_CSC_MODE_BASE_IDX                                                                   3
#define mmMPC_OUT1_CSC_C11_C12_A                                                                       0x05a7
#define mmMPC_OUT1_CSC_C11_C12_A_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C13_C14_A                                                                       0x05a8
#define mmMPC_OUT1_CSC_C13_C14_A_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C21_C22_A                                                                       0x05a9
#define mmMPC_OUT1_CSC_C21_C22_A_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C23_C24_A                                                                       0x05aa
#define mmMPC_OUT1_CSC_C23_C24_A_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C31_C32_A                                                                       0x05ab
#define mmMPC_OUT1_CSC_C31_C32_A_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C33_C34_A                                                                       0x05ac
#define mmMPC_OUT1_CSC_C33_C34_A_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C11_C12_B                                                                       0x05ad
#define mmMPC_OUT1_CSC_C11_C12_B_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C13_C14_B                                                                       0x05ae
#define mmMPC_OUT1_CSC_C13_C14_B_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C21_C22_B                                                                       0x05af
#define mmMPC_OUT1_CSC_C21_C22_B_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C23_C24_B                                                                       0x05b0
#define mmMPC_OUT1_CSC_C23_C24_B_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C31_C32_B                                                                       0x05b1
#define mmMPC_OUT1_CSC_C31_C32_B_BASE_IDX                                                              3
#define mmMPC_OUT1_CSC_C33_C34_B                                                                       0x05b2
#define mmMPC_OUT1_CSC_C33_C34_B_BASE_IDX                                                              3


// addressBlock: dce_dc_mpc_mpc_rmu_dispdec
// base address: 0x0
#define mmMPC_RMU_CONTROL                                                                              0x0680
#define mmMPC_RMU_CONTROL_BASE_IDX                                                                     3
#define mmMPC_RMU_MEM_PWR_CTRL                                                                         0x0681
#define mmMPC_RMU_MEM_PWR_CTRL_BASE_IDX                                                                3
#define mmMPC_RMU0_SHAPER_CONTROL                                                                      0x0682
#define mmMPC_RMU0_SHAPER_CONTROL_BASE_IDX                                                             3
#define mmMPC_RMU0_SHAPER_OFFSET_R                                                                     0x0683
#define mmMPC_RMU0_SHAPER_OFFSET_R_BASE_IDX                                                            3
#define mmMPC_RMU0_SHAPER_OFFSET_G                                                                     0x0684
#define mmMPC_RMU0_SHAPER_OFFSET_G_BASE_IDX                                                            3
#define mmMPC_RMU0_SHAPER_OFFSET_B                                                                     0x0685
#define mmMPC_RMU0_SHAPER_OFFSET_B_BASE_IDX                                                            3
#define mmMPC_RMU0_SHAPER_SCALE_R                                                                      0x0686
#define mmMPC_RMU0_SHAPER_SCALE_R_BASE_IDX                                                             3
#define mmMPC_RMU0_SHAPER_SCALE_G_B                                                                    0x0687
#define mmMPC_RMU0_SHAPER_SCALE_G_B_BASE_IDX                                                           3
#define mmMPC_RMU0_SHAPER_LUT_INDEX                                                                    0x0688
#define mmMPC_RMU0_SHAPER_LUT_INDEX_BASE_IDX                                                           3
#define mmMPC_RMU0_SHAPER_LUT_DATA                                                                     0x0689
#define mmMPC_RMU0_SHAPER_LUT_DATA_BASE_IDX                                                            3
#define mmMPC_RMU0_SHAPER_LUT_WRITE_EN_MASK                                                            0x068a
#define mmMPC_RMU0_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_START_CNTL_B                                                            0x068b
#define mmMPC_RMU0_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_START_CNTL_G                                                            0x068c
#define mmMPC_RMU0_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_START_CNTL_R                                                            0x068d
#define mmMPC_RMU0_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_END_CNTL_B                                                              0x068e
#define mmMPC_RMU0_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_END_CNTL_G                                                              0x068f
#define mmMPC_RMU0_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_END_CNTL_R                                                              0x0690
#define mmMPC_RMU0_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_0_1                                                              0x0691
#define mmMPC_RMU0_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_2_3                                                              0x0692
#define mmMPC_RMU0_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_4_5                                                              0x0693
#define mmMPC_RMU0_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_6_7                                                              0x0694
#define mmMPC_RMU0_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_8_9                                                              0x0695
#define mmMPC_RMU0_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_10_11                                                            0x0696
#define mmMPC_RMU0_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_12_13                                                            0x0697
#define mmMPC_RMU0_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_14_15                                                            0x0698
#define mmMPC_RMU0_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_16_17                                                            0x0699
#define mmMPC_RMU0_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_18_19                                                            0x069a
#define mmMPC_RMU0_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_20_21                                                            0x069b
#define mmMPC_RMU0_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_22_23                                                            0x069c
#define mmMPC_RMU0_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_24_25                                                            0x069d
#define mmMPC_RMU0_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_26_27                                                            0x069e
#define mmMPC_RMU0_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_28_29                                                            0x069f
#define mmMPC_RMU0_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_30_31                                                            0x06a0
#define mmMPC_RMU0_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMA_REGION_32_33                                                            0x06a1
#define mmMPC_RMU0_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_START_CNTL_B                                                            0x06a2
#define mmMPC_RMU0_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_START_CNTL_G                                                            0x06a3
#define mmMPC_RMU0_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_START_CNTL_R                                                            0x06a4
#define mmMPC_RMU0_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_END_CNTL_B                                                              0x06a5
#define mmMPC_RMU0_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_END_CNTL_G                                                              0x06a6
#define mmMPC_RMU0_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_END_CNTL_R                                                              0x06a7
#define mmMPC_RMU0_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_0_1                                                              0x06a8
#define mmMPC_RMU0_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_2_3                                                              0x06a9
#define mmMPC_RMU0_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_4_5                                                              0x06aa
#define mmMPC_RMU0_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_6_7                                                              0x06ab
#define mmMPC_RMU0_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_8_9                                                              0x06ac
#define mmMPC_RMU0_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                     3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_10_11                                                            0x06ad
#define mmMPC_RMU0_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_12_13                                                            0x06ae
#define mmMPC_RMU0_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_14_15                                                            0x06af
#define mmMPC_RMU0_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_16_17                                                            0x06b0
#define mmMPC_RMU0_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_18_19                                                            0x06b1
#define mmMPC_RMU0_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_20_21                                                            0x06b2
#define mmMPC_RMU0_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_22_23                                                            0x06b3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_24_25                                                            0x06b4
#define mmMPC_RMU0_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_26_27                                                            0x06b5
#define mmMPC_RMU0_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_28_29                                                            0x06b6
#define mmMPC_RMU0_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_30_31                                                            0x06b7
#define mmMPC_RMU0_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                   3
#define mmMPC_RMU0_SHAPER_RAMB_REGION_32_33                                                            0x06b8
#define mmMPC_RMU0_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                   3
#define mmMPC_RMU0_3DLUT_MODE                                                                          0x06b9
#define mmMPC_RMU0_3DLUT_MODE_BASE_IDX                                                                 3
#define mmMPC_RMU0_3DLUT_INDEX                                                                         0x06ba
#define mmMPC_RMU0_3DLUT_INDEX_BASE_IDX                                                                3
#define mmMPC_RMU0_3DLUT_DATA                                                                          0x06bb
#define mmMPC_RMU0_3DLUT_DATA_BASE_IDX                                                                 3
#define mmMPC_RMU0_3DLUT_DATA_30BIT                                                                    0x06bc
#define mmMPC_RMU0_3DLUT_DATA_30BIT_BASE_IDX                                                           3
#define mmMPC_RMU0_3DLUT_READ_WRITE_CONTROL                                                            0x06bd
#define mmMPC_RMU0_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                   3
#define mmMPC_RMU0_3DLUT_OUT_NORM_FACTOR                                                               0x06be
#define mmMPC_RMU0_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                      3
#define mmMPC_RMU0_3DLUT_OUT_OFFSET_R                                                                  0x06bf
#define mmMPC_RMU0_3DLUT_OUT_OFFSET_R_BASE_IDX                                                         3
#define mmMPC_RMU0_3DLUT_OUT_OFFSET_G                                                                  0x06c0
#define mmMPC_RMU0_3DLUT_OUT_OFFSET_G_BASE_IDX                                                         3
#define mmMPC_RMU0_3DLUT_OUT_OFFSET_B                                                                  0x06c1
#define mmMPC_RMU0_3DLUT_OUT_OFFSET_B_BASE_IDX                                                         3
// addressBlock: dce_dc_mpc_mpc_dcperfmon_dc_perfmon_dispdec
// base address: 0x1901c
#define mmDC_PERFMON15_PERFCOUNTER_CNTL                                                                0x08c7
#define mmDC_PERFMON15_PERFCOUNTER_CNTL_BASE_IDX                                                       3
#define mmDC_PERFMON15_PERFCOUNTER_CNTL2                                                               0x08c8
#define mmDC_PERFMON15_PERFCOUNTER_CNTL2_BASE_IDX                                                      3
#define mmDC_PERFMON15_PERFCOUNTER_STATE                                                               0x08c9
#define mmDC_PERFMON15_PERFCOUNTER_STATE_BASE_IDX                                                      3
#define mmDC_PERFMON15_PERFMON_CNTL                                                                    0x08ca
#define mmDC_PERFMON15_PERFMON_CNTL_BASE_IDX                                                           3
#define mmDC_PERFMON15_PERFMON_CNTL2                                                                   0x08cb
#define mmDC_PERFMON15_PERFMON_CNTL2_BASE_IDX                                                          3
#define mmDC_PERFMON15_PERFMON_CVALUE_INT_MISC                                                         0x08cc
#define mmDC_PERFMON15_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                3
#define mmDC_PERFMON15_PERFMON_CVALUE_LOW                                                              0x08cd
#define mmDC_PERFMON15_PERFMON_CVALUE_LOW_BASE_IDX                                                     3
#define mmDC_PERFMON15_PERFMON_HI                                                                      0x08ce
#define mmDC_PERFMON15_PERFMON_HI_BASE_IDX                                                             3
#define mmDC_PERFMON15_PERFMON_LOW                                                                     0x08cf
#define mmDC_PERFMON15_PERFMON_LOW_BASE_IDX                                                            3


// addressBlock: dce_dc_hpo_hdmi_stream_enc0_afmt_afmt_dispdec
// base address: 0x2646c
#define mmAFMT2_AFMT_VBI_PACKET_CONTROL                                                                0x091c
#define mmAFMT2_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       3
#define mmAFMT2_AFMT_AUDIO_PACKET_CONTROL2                                                             0x091d
#define mmAFMT2_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    3
#define mmAFMT2_AFMT_60958_0                                                                           0x0920
#define mmAFMT2_AFMT_60958_0_BASE_IDX                                                                  3
#define mmAFMT2_AFMT_60958_1                                                                           0x0921
#define mmAFMT2_AFMT_60958_1_BASE_IDX                                                                  3
#define mmAFMT2_AFMT_60958_2                                                                           0x0927
#define mmAFMT2_AFMT_60958_2_BASE_IDX                                                                  3
#define mmAFMT2_AFMT_AUDIO_PACKET_CONTROL                                                              0x092a
#define mmAFMT2_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     3
#define mmAFMT2_AFMT_INFOFRAME_CONTROL0                                                                0x092b
#define mmAFMT2_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       3
#define mmAFMT2_AFMT_AUDIO_SRC_CONTROL                                                                 0x092d
#define mmAFMT2_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        3
#define mmAFMT2_AFMT_MEM_PWR                                                                           0x092f
#define mmAFMT2_AFMT_MEM_PWR_BASE_IDX                                                                  3


// addressBlock: dce_dc_hpo_hdmi_stream_enc0_vpg_vpg_dispdec
// base address: 0x264c4
#define mmVPG2_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x0931
#define mmVPG2_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 3
#define mmVPG2_VPG_GENERIC_PACKET_DATA                                                                 0x0932
#define mmVPG2_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        3
#define mmVPG2_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x0933
#define mmVPG2_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      3
#define mmVPG2_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x0934
#define mmVPG2_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  3
#define mmVPG2_VPG_GENERIC_STATUS                                                                      0x0935
#define mmVPG2_VPG_GENERIC_STATUS_BASE_IDX                                                             3


// addressBlock: dce_dc_hpo_hdmi_stream_enc0_dme_dme_dispdec
// base address: 0x264f0
#define mmDME2_DME_CONTROL                                                                             0x093c
#define mmDME2_DME_CONTROL_BASE_IDX                                                                    3
#define mmDME2_DME_MEMORY_CONTROL                                                                      0x093d
#define mmDME2_DME_MEMORY_CONTROL_BASE_IDX                                                             3


// addressBlock: dce_dc_hpo_hpo_top_dispdec
// base address: 0x0
#define mmHPO_TOP_CLOCK_CONTROL                                                                        0x0e43
#define mmHPO_TOP_CLOCK_CONTROL_BASE_IDX                                                               3


// addressBlock: dce_dc_hpo_hpo_dcperfmon_dc_perfmon_dispdec
// base address: 0x1a698
#define mmDC_PERFMON16_PERFCOUNTER_CNTL                                                                0x0e66
#define mmDC_PERFMON16_PERFCOUNTER_CNTL_BASE_IDX                                                       3
#define mmDC_PERFMON16_PERFCOUNTER_CNTL2                                                               0x0e67
#define mmDC_PERFMON16_PERFCOUNTER_CNTL2_BASE_IDX                                                      3
#define mmDC_PERFMON16_PERFCOUNTER_STATE                                                               0x0e68
#define mmDC_PERFMON16_PERFCOUNTER_STATE_BASE_IDX                                                      3
#define mmDC_PERFMON16_PERFMON_CNTL                                                                    0x0e69
#define mmDC_PERFMON16_PERFMON_CNTL_BASE_IDX                                                           3
#define mmDC_PERFMON16_PERFMON_CNTL2                                                                   0x0e6a
#define mmDC_PERFMON16_PERFMON_CNTL2_BASE_IDX                                                          3
#define mmDC_PERFMON16_PERFMON_CVALUE_INT_MISC                                                         0x0e6b
#define mmDC_PERFMON16_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                3
#define mmDC_PERFMON16_PERFMON_CVALUE_LOW                                                              0x0e6c
#define mmDC_PERFMON16_PERFMON_CVALUE_LOW_BASE_IDX                                                     3
#define mmDC_PERFMON16_PERFMON_HI                                                                      0x0e6d
#define mmDC_PERFMON16_PERFMON_HI_BASE_IDX                                                             3
#define mmDC_PERFMON16_PERFMON_LOW                                                                     0x0e6e
#define mmDC_PERFMON16_PERFMON_LOW_BASE_IDX                                                            3


// addressBlock: dce_dc_opp_abm0_dispdec
// base address: 0x0
#define mmABM0_BL1_PWM_AMBIENT_LIGHT_LEVEL                                                             0x0e7a
#define mmABM0_BL1_PWM_AMBIENT_LIGHT_LEVEL_BASE_IDX                                                    3
#define mmABM0_BL1_PWM_USER_LEVEL                                                                      0x0e7b
#define mmABM0_BL1_PWM_USER_LEVEL_BASE_IDX                                                             3
#define mmABM0_BL1_PWM_TARGET_ABM_LEVEL                                                                0x0e7c
#define mmABM0_BL1_PWM_TARGET_ABM_LEVEL_BASE_IDX                                                       3
#define mmABM0_BL1_PWM_CURRENT_ABM_LEVEL                                                               0x0e7d
#define mmABM0_BL1_PWM_CURRENT_ABM_LEVEL_BASE_IDX                                                      3
#define mmABM0_BL1_PWM_FINAL_DUTY_CYCLE                                                                0x0e7e
#define mmABM0_BL1_PWM_FINAL_DUTY_CYCLE_BASE_IDX                                                       3
#define mmABM0_BL1_PWM_MINIMUM_DUTY_CYCLE                                                              0x0e7f
#define mmABM0_BL1_PWM_MINIMUM_DUTY_CYCLE_BASE_IDX                                                     3
#define mmABM0_BL1_PWM_ABM_CNTL                                                                        0x0e80
#define mmABM0_BL1_PWM_ABM_CNTL_BASE_IDX                                                               3
#define mmABM0_BL1_PWM_BL_UPDATE_SAMPLE_RATE                                                           0x0e81
#define mmABM0_BL1_PWM_BL_UPDATE_SAMPLE_RATE_BASE_IDX                                                  3
#define mmABM0_BL1_PWM_GRP2_REG_LOCK                                                                   0x0e82
#define mmABM0_BL1_PWM_GRP2_REG_LOCK_BASE_IDX                                                          3
#define mmABM0_DC_ABM1_CNTL                                                                            0x0e83
#define mmABM0_DC_ABM1_CNTL_BASE_IDX                                                                   3
#define mmABM0_DC_ABM1_IPCSC_COEFF_SEL                                                                 0x0e84
#define mmABM0_DC_ABM1_IPCSC_COEFF_SEL_BASE_IDX                                                        3
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_0                                                              0x0e85
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_0_BASE_IDX                                                     3
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_1                                                              0x0e86
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_1_BASE_IDX                                                     3
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_2                                                              0x0e87
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_2_BASE_IDX                                                     3
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_3                                                              0x0e88
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_3_BASE_IDX                                                     3
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_4                                                              0x0e89
#define mmABM0_DC_ABM1_ACE_OFFSET_SLOPE_4_BASE_IDX                                                     3
#define mmABM0_DC_ABM1_ACE_THRES_12                                                                    0x0e8a
#define mmABM0_DC_ABM1_ACE_THRES_12_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_ACE_THRES_34                                                                    0x0e8b
#define mmABM0_DC_ABM1_ACE_THRES_34_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_ACE_CNTL_MISC                                                                   0x0e8c
#define mmABM0_DC_ABM1_ACE_CNTL_MISC_BASE_IDX                                                          3
#define mmABM0_DC_ABM1_HGLS_REG_READ_PROGRESS                                                          0x0e8e
#define mmABM0_DC_ABM1_HGLS_REG_READ_PROGRESS_BASE_IDX                                                 3
#define mmABM0_DC_ABM1_HG_MISC_CTRL                                                                    0x0e8f
#define mmABM0_DC_ABM1_HG_MISC_CTRL_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_LS_SUM_OF_LUMA                                                                  0x0e90
#define mmABM0_DC_ABM1_LS_SUM_OF_LUMA_BASE_IDX                                                         3
#define mmABM0_DC_ABM1_LS_MIN_MAX_LUMA                                                                 0x0e91
#define mmABM0_DC_ABM1_LS_MIN_MAX_LUMA_BASE_IDX                                                        3
#define mmABM0_DC_ABM1_LS_FILTERED_MIN_MAX_LUMA                                                        0x0e92
#define mmABM0_DC_ABM1_LS_FILTERED_MIN_MAX_LUMA_BASE_IDX                                               3
#define mmABM0_DC_ABM1_LS_PIXEL_COUNT                                                                  0x0e93
#define mmABM0_DC_ABM1_LS_PIXEL_COUNT_BASE_IDX                                                         3
#define mmABM0_DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES                                                    0x0e94
#define mmABM0_DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES_BASE_IDX                                           3
#define mmABM0_DC_ABM1_LS_MIN_PIXEL_VALUE_COUNT                                                        0x0e95
#define mmABM0_DC_ABM1_LS_MIN_PIXEL_VALUE_COUNT_BASE_IDX                                               3
#define mmABM0_DC_ABM1_LS_MAX_PIXEL_VALUE_COUNT                                                        0x0e96
#define mmABM0_DC_ABM1_LS_MAX_PIXEL_VALUE_COUNT_BASE_IDX                                               3
#define mmABM0_DC_ABM1_HG_SAMPLE_RATE                                                                  0x0e97
#define mmABM0_DC_ABM1_HG_SAMPLE_RATE_BASE_IDX                                                         3
#define mmABM0_DC_ABM1_LS_SAMPLE_RATE                                                                  0x0e98
#define mmABM0_DC_ABM1_LS_SAMPLE_RATE_BASE_IDX                                                         3
#define mmABM0_DC_ABM1_HG_BIN_1_32_SHIFT_FLAG                                                          0x0e99
#define mmABM0_DC_ABM1_HG_BIN_1_32_SHIFT_FLAG_BASE_IDX                                                 3
#define mmABM0_DC_ABM1_HG_BIN_1_8_SHIFT_INDEX                                                          0x0e9a
#define mmABM0_DC_ABM1_HG_BIN_1_8_SHIFT_INDEX_BASE_IDX                                                 3
#define mmABM0_DC_ABM1_HG_BIN_9_16_SHIFT_INDEX                                                         0x0e9b
#define mmABM0_DC_ABM1_HG_BIN_9_16_SHIFT_INDEX_BASE_IDX                                                3
#define mmABM0_DC_ABM1_HG_BIN_17_24_SHIFT_INDEX                                                        0x0e9c
#define mmABM0_DC_ABM1_HG_BIN_17_24_SHIFT_INDEX_BASE_IDX                                               3
#define mmABM0_DC_ABM1_HG_BIN_25_32_SHIFT_INDEX                                                        0x0e9d
#define mmABM0_DC_ABM1_HG_BIN_25_32_SHIFT_INDEX_BASE_IDX                                               3
#define mmABM0_DC_ABM1_HG_RESULT_1                                                                     0x0e9e
#define mmABM0_DC_ABM1_HG_RESULT_1_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_2                                                                     0x0e9f
#define mmABM0_DC_ABM1_HG_RESULT_2_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_3                                                                     0x0ea0
#define mmABM0_DC_ABM1_HG_RESULT_3_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_4                                                                     0x0ea1
#define mmABM0_DC_ABM1_HG_RESULT_4_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_5                                                                     0x0ea2
#define mmABM0_DC_ABM1_HG_RESULT_5_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_6                                                                     0x0ea3
#define mmABM0_DC_ABM1_HG_RESULT_6_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_7                                                                     0x0ea4
#define mmABM0_DC_ABM1_HG_RESULT_7_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_8                                                                     0x0ea5
#define mmABM0_DC_ABM1_HG_RESULT_8_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_9                                                                     0x0ea6
#define mmABM0_DC_ABM1_HG_RESULT_9_BASE_IDX                                                            3
#define mmABM0_DC_ABM1_HG_RESULT_10                                                                    0x0ea7
#define mmABM0_DC_ABM1_HG_RESULT_10_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_11                                                                    0x0ea8
#define mmABM0_DC_ABM1_HG_RESULT_11_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_12                                                                    0x0ea9
#define mmABM0_DC_ABM1_HG_RESULT_12_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_13                                                                    0x0eaa
#define mmABM0_DC_ABM1_HG_RESULT_13_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_14                                                                    0x0eab
#define mmABM0_DC_ABM1_HG_RESULT_14_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_15                                                                    0x0eac
#define mmABM0_DC_ABM1_HG_RESULT_15_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_16                                                                    0x0ead
#define mmABM0_DC_ABM1_HG_RESULT_16_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_17                                                                    0x0eae
#define mmABM0_DC_ABM1_HG_RESULT_17_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_18                                                                    0x0eaf
#define mmABM0_DC_ABM1_HG_RESULT_18_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_19                                                                    0x0eb0
#define mmABM0_DC_ABM1_HG_RESULT_19_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_20                                                                    0x0eb1
#define mmABM0_DC_ABM1_HG_RESULT_20_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_21                                                                    0x0eb2
#define mmABM0_DC_ABM1_HG_RESULT_21_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_22                                                                    0x0eb3
#define mmABM0_DC_ABM1_HG_RESULT_22_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_23                                                                    0x0eb4
#define mmABM0_DC_ABM1_HG_RESULT_23_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_HG_RESULT_24                                                                    0x0eb5
#define mmABM0_DC_ABM1_HG_RESULT_24_BASE_IDX                                                           3
#define mmABM0_DC_ABM1_BL_MASTER_LOCK                                                                  0x0eb6
#define mmABM0_DC_ABM1_BL_MASTER_LOCK_BASE_IDX                                                         3


// addressBlock: dce_dc_opp_abm1_dispdec
// base address: 0x104
#define mmABM1_BL1_PWM_AMBIENT_LIGHT_LEVEL                                                             0x0ebb
#define mmABM1_BL1_PWM_AMBIENT_LIGHT_LEVEL_BASE_IDX                                                    3
#define mmABM1_BL1_PWM_USER_LEVEL                                                                      0x0ebc
#define mmABM1_BL1_PWM_USER_LEVEL_BASE_IDX                                                             3
#define mmABM1_BL1_PWM_TARGET_ABM_LEVEL                                                                0x0ebd
#define mmABM1_BL1_PWM_TARGET_ABM_LEVEL_BASE_IDX                                                       3
#define mmABM1_BL1_PWM_CURRENT_ABM_LEVEL                                                               0x0ebe
#define mmABM1_BL1_PWM_CURRENT_ABM_LEVEL_BASE_IDX                                                      3
#define mmABM1_BL1_PWM_FINAL_DUTY_CYCLE                                                                0x0ebf
#define mmABM1_BL1_PWM_FINAL_DUTY_CYCLE_BASE_IDX                                                       3
#define mmABM1_BL1_PWM_MINIMUM_DUTY_CYCLE                                                              0x0ec0
#define mmABM1_BL1_PWM_MINIMUM_DUTY_CYCLE_BASE_IDX                                                     3
#define mmABM1_BL1_PWM_ABM_CNTL                                                                        0x0ec1
#define mmABM1_BL1_PWM_ABM_CNTL_BASE_IDX                                                               3
#define mmABM1_BL1_PWM_BL_UPDATE_SAMPLE_RATE                                                           0x0ec2
#define mmABM1_BL1_PWM_BL_UPDATE_SAMPLE_RATE_BASE_IDX                                                  3
#define mmABM1_BL1_PWM_GRP2_REG_LOCK                                                                   0x0ec3
#define mmABM1_BL1_PWM_GRP2_REG_LOCK_BASE_IDX                                                          3
#define mmABM1_DC_ABM1_CNTL                                                                            0x0ec4
#define mmABM1_DC_ABM1_CNTL_BASE_IDX                                                                   3
#define mmABM1_DC_ABM1_IPCSC_COEFF_SEL                                                                 0x0ec5
#define mmABM1_DC_ABM1_IPCSC_COEFF_SEL_BASE_IDX                                                        3
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_0                                                              0x0ec6
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_0_BASE_IDX                                                     3
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_1                                                              0x0ec7
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_1_BASE_IDX                                                     3
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_2                                                              0x0ec8
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_2_BASE_IDX                                                     3
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_3                                                              0x0ec9
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_3_BASE_IDX                                                     3
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_4                                                              0x0eca
#define mmABM1_DC_ABM1_ACE_OFFSET_SLOPE_4_BASE_IDX                                                     3
#define mmABM1_DC_ABM1_ACE_THRES_12                                                                    0x0ecb
#define mmABM1_DC_ABM1_ACE_THRES_12_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_ACE_THRES_34                                                                    0x0ecc
#define mmABM1_DC_ABM1_ACE_THRES_34_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_ACE_CNTL_MISC                                                                   0x0ecd
#define mmABM1_DC_ABM1_ACE_CNTL_MISC_BASE_IDX                                                          3
#define mmABM1_DC_ABM1_HGLS_REG_READ_PROGRESS                                                          0x0ecf
#define mmABM1_DC_ABM1_HGLS_REG_READ_PROGRESS_BASE_IDX                                                 3
#define mmABM1_DC_ABM1_HG_MISC_CTRL                                                                    0x0ed0
#define mmABM1_DC_ABM1_HG_MISC_CTRL_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_LS_SUM_OF_LUMA                                                                  0x0ed1
#define mmABM1_DC_ABM1_LS_SUM_OF_LUMA_BASE_IDX                                                         3
#define mmABM1_DC_ABM1_LS_MIN_MAX_LUMA                                                                 0x0ed2
#define mmABM1_DC_ABM1_LS_MIN_MAX_LUMA_BASE_IDX                                                        3
#define mmABM1_DC_ABM1_LS_FILTERED_MIN_MAX_LUMA                                                        0x0ed3
#define mmABM1_DC_ABM1_LS_FILTERED_MIN_MAX_LUMA_BASE_IDX                                               3
#define mmABM1_DC_ABM1_LS_PIXEL_COUNT                                                                  0x0ed4
#define mmABM1_DC_ABM1_LS_PIXEL_COUNT_BASE_IDX                                                         3
#define mmABM1_DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES                                                    0x0ed5
#define mmABM1_DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES_BASE_IDX                                           3
#define mmABM1_DC_ABM1_LS_MIN_PIXEL_VALUE_COUNT                                                        0x0ed6
#define mmABM1_DC_ABM1_LS_MIN_PIXEL_VALUE_COUNT_BASE_IDX                                               3
#define mmABM1_DC_ABM1_LS_MAX_PIXEL_VALUE_COUNT                                                        0x0ed7
#define mmABM1_DC_ABM1_LS_MAX_PIXEL_VALUE_COUNT_BASE_IDX                                               3
#define mmABM1_DC_ABM1_HG_SAMPLE_RATE                                                                  0x0ed8
#define mmABM1_DC_ABM1_HG_SAMPLE_RATE_BASE_IDX                                                         3
#define mmABM1_DC_ABM1_LS_SAMPLE_RATE                                                                  0x0ed9
#define mmABM1_DC_ABM1_LS_SAMPLE_RATE_BASE_IDX                                                         3
#define mmABM1_DC_ABM1_HG_BIN_1_32_SHIFT_FLAG                                                          0x0eda
#define mmABM1_DC_ABM1_HG_BIN_1_32_SHIFT_FLAG_BASE_IDX                                                 3
#define mmABM1_DC_ABM1_HG_BIN_1_8_SHIFT_INDEX                                                          0x0edb
#define mmABM1_DC_ABM1_HG_BIN_1_8_SHIFT_INDEX_BASE_IDX                                                 3
#define mmABM1_DC_ABM1_HG_BIN_9_16_SHIFT_INDEX                                                         0x0edc
#define mmABM1_DC_ABM1_HG_BIN_9_16_SHIFT_INDEX_BASE_IDX                                                3
#define mmABM1_DC_ABM1_HG_BIN_17_24_SHIFT_INDEX                                                        0x0edd
#define mmABM1_DC_ABM1_HG_BIN_17_24_SHIFT_INDEX_BASE_IDX                                               3
#define mmABM1_DC_ABM1_HG_BIN_25_32_SHIFT_INDEX                                                        0x0ede
#define mmABM1_DC_ABM1_HG_BIN_25_32_SHIFT_INDEX_BASE_IDX                                               3
#define mmABM1_DC_ABM1_HG_RESULT_1                                                                     0x0edf
#define mmABM1_DC_ABM1_HG_RESULT_1_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_2                                                                     0x0ee0
#define mmABM1_DC_ABM1_HG_RESULT_2_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_3                                                                     0x0ee1
#define mmABM1_DC_ABM1_HG_RESULT_3_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_4                                                                     0x0ee2
#define mmABM1_DC_ABM1_HG_RESULT_4_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_5                                                                     0x0ee3
#define mmABM1_DC_ABM1_HG_RESULT_5_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_6                                                                     0x0ee4
#define mmABM1_DC_ABM1_HG_RESULT_6_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_7                                                                     0x0ee5
#define mmABM1_DC_ABM1_HG_RESULT_7_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_8                                                                     0x0ee6
#define mmABM1_DC_ABM1_HG_RESULT_8_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_9                                                                     0x0ee7
#define mmABM1_DC_ABM1_HG_RESULT_9_BASE_IDX                                                            3
#define mmABM1_DC_ABM1_HG_RESULT_10                                                                    0x0ee8
#define mmABM1_DC_ABM1_HG_RESULT_10_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_11                                                                    0x0ee9
#define mmABM1_DC_ABM1_HG_RESULT_11_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_12                                                                    0x0eea
#define mmABM1_DC_ABM1_HG_RESULT_12_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_13                                                                    0x0eeb
#define mmABM1_DC_ABM1_HG_RESULT_13_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_14                                                                    0x0eec
#define mmABM1_DC_ABM1_HG_RESULT_14_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_15                                                                    0x0eed
#define mmABM1_DC_ABM1_HG_RESULT_15_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_16                                                                    0x0eee
#define mmABM1_DC_ABM1_HG_RESULT_16_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_17                                                                    0x0eef
#define mmABM1_DC_ABM1_HG_RESULT_17_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_18                                                                    0x0ef0
#define mmABM1_DC_ABM1_HG_RESULT_18_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_19                                                                    0x0ef1
#define mmABM1_DC_ABM1_HG_RESULT_19_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_20                                                                    0x0ef2
#define mmABM1_DC_ABM1_HG_RESULT_20_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_21                                                                    0x0ef3
#define mmABM1_DC_ABM1_HG_RESULT_21_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_22                                                                    0x0ef4
#define mmABM1_DC_ABM1_HG_RESULT_22_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_23                                                                    0x0ef5
#define mmABM1_DC_ABM1_HG_RESULT_23_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_HG_RESULT_24                                                                    0x0ef6
#define mmABM1_DC_ABM1_HG_RESULT_24_BASE_IDX                                                           3
#define mmABM1_DC_ABM1_BL_MASTER_LOCK                                                                  0x0ef7
#define mmABM1_DC_ABM1_BL_MASTER_LOCK_BASE_IDX                                                         3


// addressBlock: dce_dc_hda_azcontroller_azdec
// base address: 0x0
#define mmCORB_WRITE_POINTER                                                                           0x0000
#define mmCORB_WRITE_POINTER_BASE_IDX                                                                  0
#define mmCORB_READ_POINTER                                                                            0x0000
#define mmCORB_READ_POINTER_BASE_IDX                                                                   0
#define mmCORB_CONTROL                                                                                 0x0001
#define mmCORB_CONTROL_BASE_IDX                                                                        0
#define mmCORB_STATUS                                                                                  0x0001
#define mmCORB_STATUS_BASE_IDX                                                                         0
#define mmCORB_SIZE                                                                                    0x0001
#define mmCORB_SIZE_BASE_IDX                                                                           0
#define mmRIRB_LOWER_BASE_ADDRESS                                                                      0x0002
#define mmRIRB_LOWER_BASE_ADDRESS_BASE_IDX                                                             0
#define mmRIRB_UPPER_BASE_ADDRESS                                                                      0x0003
#define mmRIRB_UPPER_BASE_ADDRESS_BASE_IDX                                                             0
#define mmRIRB_WRITE_POINTER                                                                           0x0004
#define mmRIRB_WRITE_POINTER_BASE_IDX                                                                  0
#define mmRESPONSE_INTERRUPT_COUNT                                                                     0x0004
#define mmRESPONSE_INTERRUPT_COUNT_BASE_IDX                                                            0
#define mmRIRB_CONTROL                                                                                 0x0005
#define mmRIRB_CONTROL_BASE_IDX                                                                        0
#define mmRIRB_STATUS                                                                                  0x0005
#define mmRIRB_STATUS_BASE_IDX                                                                         0
#define mmRIRB_SIZE                                                                                    0x0005
#define mmRIRB_SIZE_BASE_IDX                                                                           0
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE                                                           0x0006
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE_BASE_IDX                                                  0
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA                                                      0x0006
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA_BASE_IDX                                             0
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX                                                     0x0006
#define mmIMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX_BASE_IDX                                            0
#define mmIMMEDIATE_RESPONSE_INPUT_INTERFACE                                                           0x0007
#define mmIMMEDIATE_RESPONSE_INPUT_INTERFACE_BASE_IDX                                                  0
#define mmIMMEDIATE_COMMAND_STATUS                                                                     0x0008
#define mmIMMEDIATE_COMMAND_STATUS_BASE_IDX                                                            0
#define mmDMA_POSITION_LOWER_BASE_ADDRESS                                                              0x000a
#define mmDMA_POSITION_LOWER_BASE_ADDRESS_BASE_IDX                                                     0
#define mmDMA_POSITION_UPPER_BASE_ADDRESS                                                              0x000b
#define mmDMA_POSITION_UPPER_BASE_ADDRESS_BASE_IDX                                                     0
#define mmWALL_CLOCK_COUNTER_ALIAS                                                                     0x074c
#define mmWALL_CLOCK_COUNTER_ALIAS_BASE_IDX                                                            1


// addressBlock: dce_dc_hda_azendpoint_azdec
// base address: 0x0
#define mmAZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA                                           0x0006
#define mmAZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_DATA_BASE_IDX                                  0
#define mmAZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX                                          0x0006
#define mmAZENDPOINT_IMMEDIATE_COMMAND_OUTPUT_INTERFACE_INDEX_BASE_IDX                                 0


// addressBlock: dce_dc_hda_azinputendpoint_azdec
// base address: 0x0
#define mmAZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA                                            0x0006
#define mmAZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_DATA_BASE_IDX                                   0
#define mmAZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX                                           0x0006
#define mmAZENDPOINT_IMMEDIATE_COMMAND_INPUT_INTERFACE_INDEX_BASE_IDX                                  0



// addressBlock: vga_vgaseqind
// base address: 0x0
#define ixSEQ00                                                                                        0x0000
#define ixSEQ01                                                                                        0x0001
#define ixSEQ02                                                                                        0x0002
#define ixSEQ03                                                                                        0x0003
#define ixSEQ04                                                                                        0x0004


// addressBlock: vga_vgacrtind
// base address: 0x0
#define ixCRT00                                                                                        0x0000
#define ixCRT01                                                                                        0x0001
#define ixCRT02                                                                                        0x0002
#define ixCRT03                                                                                        0x0003
#define ixCRT04                                                                                        0x0004
#define ixCRT05                                                                                        0x0005
#define ixCRT06                                                                                        0x0006
#define ixCRT07                                                                                        0x0007
#define ixCRT08                                                                                        0x0008
#define ixCRT09                                                                                        0x0009
#define ixCRT0A                                                                                        0x000a
#define ixCRT0B                                                                                        0x000b
#define ixCRT0C                                                                                        0x000c
#define ixCRT0D                                                                                        0x000d
#define ixCRT0E                                                                                        0x000e
#define ixCRT0F                                                                                        0x000f
#define ixCRT10                                                                                        0x0010
#define ixCRT11                                                                                        0x0011
#define ixCRT12                                                                                        0x0012
#define ixCRT13                                                                                        0x0013
#define ixCRT14                                                                                        0x0014
#define ixCRT15                                                                                        0x0015
#define ixCRT16                                                                                        0x0016
#define ixCRT17                                                                                        0x0017
#define ixCRT18                                                                                        0x0018
#define ixCRT1E                                                                                        0x001e
#define ixCRT1F                                                                                        0x001f
#define ixCRT22                                                                                        0x0022


// addressBlock: vga_vgagrphind
// base address: 0x0
#define ixGRA00                                                                                        0x0000
#define ixGRA01                                                                                        0x0001
#define ixGRA02                                                                                        0x0002
#define ixGRA03                                                                                        0x0003
#define ixGRA04                                                                                        0x0004
#define ixGRA05                                                                                        0x0005
#define ixGRA06                                                                                        0x0006
#define ixGRA07                                                                                        0x0007
#define ixGRA08                                                                                        0x0008


// addressBlock: vga_vgaattrind
// base address: 0x0
#define ixATTR00                                                                                       0x0000
#define ixATTR01                                                                                       0x0001
#define ixATTR02                                                                                       0x0002
#define ixATTR03                                                                                       0x0003
#define ixATTR04                                                                                       0x0004
#define ixATTR05                                                                                       0x0005
#define ixATTR06                                                                                       0x0006
#define ixATTR07                                                                                       0x0007
#define ixATTR08                                                                                       0x0008
#define ixATTR09                                                                                       0x0009
#define ixATTR0A                                                                                       0x000a
#define ixATTR0B                                                                                       0x000b
#define ixATTR0C                                                                                       0x000c
#define ixATTR0D                                                                                       0x000d
#define ixATTR0E                                                                                       0x000e
#define ixATTR0F                                                                                       0x000f
#define ixATTR10                                                                                       0x0010
#define ixATTR11                                                                                       0x0011
#define ixATTR12                                                                                       0x0012
#define ixATTR13                                                                                       0x0013
#define ixATTR14                                                                                       0x0014


// addressBlock: azendpoint_f2codecind
// base address: 0x0
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                                           0x2200
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                                          0x2706
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                                          0x270d
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_2                                        0x270e
#define ixAZALIA_F2_CODEC_CONVERTER_STRIPE_CONTROL                                                     0x2724
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER_3                                        0x273e
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_RAMP_RATE                                                  0x2770
#define ixAZALIA_F2_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                              0x2771
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                                0x2f09
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                                     0x2f0a
#define ixAZALIA_F2_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                                           0x2f0b
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONNECTION_LIST_ENTRY                                   0x3702
#define ixAZALIA_F2_CODEC_PIN_CONTROL_WIDGET_CONTROL                                                   0x3707
#define ixAZALIA_F2_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                                             0x3708
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                               0x3709
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                                   0x371c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_2                                 0x371d
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_3                                 0x371e
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_4                                 0x371f
#define ixAZALIA_F2_CODEC_PIN_CONTROL_RESPONSE_SPEAKER_ALLOCATION                                      0x3770
#define ixAZALIA_F2_CODEC_PIN_CONTROL_CHANNEL_ALLOCATION                                               0x3771
#define ixAZALIA_F2_CODEC_PIN_CONTROL_DOWN_MIX_INFO                                                    0x3772
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR                                                 0x3776
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR_DATA                                            0x3776
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL01_ENABLE                                            0x3777
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL23_ENABLE                                            0x3778
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL45_ENABLE                                            0x3779
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL67_ENABLE                                            0x377a
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LIPSYNC                                                          0x377b
#define ixAZALIA_F2_CODEC_PIN_CONTROL_HBR                                                              0x377c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_SINK_INFO_INDEX                                            0x3780
#define ixAZALIA_F2_CODEC_PIN_CONTROL_AUDIO_SINK_INFO_DATA                                             0x3781
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL1_ENABLE                                             0x3785
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL3_ENABLE                                             0x3786
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL5_ENABLE                                             0x3787
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL7_ENABLE                                             0x3788
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                                0x3789
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                                    0x378a
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                                    0x378b
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                                    0x378c
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                                    0x378d
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                                    0x378e
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                                    0x378f
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                                    0x3790
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                                    0x3791
#define ixAZALIA_F2_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                                    0x3792
#define ixAZALIA_F2_CODEC_PIN_ASSOCIATION_INFO                                                         0x3793
#define ixAZALIA_F2_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                                            0x3797
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                                            0x3798
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LPIB                                                             0x3799
#define ixAZALIA_F2_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                              0x379a
#define ixAZALIA_F2_CODEC_PIN_CONTROL_CODING_TYPE                                                      0x379b
#define ixAZALIA_F2_CODEC_PIN_CONTROL_FORMAT_CHANGED                                                   0x379c
#define ixAZALIA_F2_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                                  0x379d
#define ixAZALIA_F2_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                                 0x379e
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                                      0x3f09
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_CAPABILITIES                                                   0x3f0c
#define ixAZALIA_F2_CODEC_PIN_PARAMETER_CONNECTION_LIST_LENGTH                                         0x3f0e


// addressBlock: azendpoint_descriptorind
// base address: 0x0
#define ixAUDIO_DESCRIPTOR0                                                                            0x0001
#define ixAUDIO_DESCRIPTOR1                                                                            0x0002
#define ixAUDIO_DESCRIPTOR2                                                                            0x0003
#define ixAUDIO_DESCRIPTOR3                                                                            0x0004
#define ixAUDIO_DESCRIPTOR4                                                                            0x0005
#define ixAUDIO_DESCRIPTOR5                                                                            0x0006
#define ixAUDIO_DESCRIPTOR6                                                                            0x0007
#define ixAUDIO_DESCRIPTOR7                                                                            0x0008
#define ixAUDIO_DESCRIPTOR8                                                                            0x0009
#define ixAUDIO_DESCRIPTOR9                                                                            0x000a
#define ixAUDIO_DESCRIPTOR10                                                                           0x000b
#define ixAUDIO_DESCRIPTOR11                                                                           0x000c
#define ixAUDIO_DESCRIPTOR12                                                                           0x000d
#define ixAUDIO_DESCRIPTOR13                                                                           0x000e


// addressBlock: azendpoint_sinkinfoind
// base address: 0x0
#define ixAZALIA_F2_CODEC_PIN_CONTROL_MANUFACTURER_ID                                                  0x0000
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PRODUCT_ID                                                       0x0001
#define ixAZALIA_F2_CODEC_PIN_CONTROL_SINK_DESCRIPTION_LEN                                             0x0002
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PORTID0                                                          0x0003
#define ixAZALIA_F2_CODEC_PIN_CONTROL_PORTID1                                                          0x0004
#define ixSINK_DESCRIPTION0                                                                            0x0005
#define ixSINK_DESCRIPTION1                                                                            0x0006
#define ixSINK_DESCRIPTION2                                                                            0x0007
#define ixSINK_DESCRIPTION3                                                                            0x0008
#define ixSINK_DESCRIPTION4                                                                            0x0009
#define ixSINK_DESCRIPTION5                                                                            0x000a
#define ixSINK_DESCRIPTION6                                                                            0x000b
#define ixSINK_DESCRIPTION7                                                                            0x000c
#define ixSINK_DESCRIPTION8                                                                            0x000d
#define ixSINK_DESCRIPTION9                                                                            0x000e
#define ixSINK_DESCRIPTION10                                                                           0x000f
#define ixSINK_DESCRIPTION11                                                                           0x0010
#define ixSINK_DESCRIPTION12                                                                           0x0011
#define ixSINK_DESCRIPTION13                                                                           0x0012
#define ixSINK_DESCRIPTION14                                                                           0x0013
#define ixSINK_DESCRIPTION15                                                                           0x0014
#define ixSINK_DESCRIPTION16                                                                           0x0015
#define ixSINK_DESCRIPTION17                                                                           0x0016


// addressBlock: azf0controller_azinputcrc0resultind
// base address: 0x0
#define ixAZALIA_INPUT_CRC0_CHANNEL0                                                                   0x0000
#define ixAZALIA_INPUT_CRC0_CHANNEL1                                                                   0x0001
#define ixAZALIA_INPUT_CRC0_CHANNEL2                                                                   0x0002
#define ixAZALIA_INPUT_CRC0_CHANNEL3                                                                   0x0003
#define ixAZALIA_INPUT_CRC0_CHANNEL4                                                                   0x0004
#define ixAZALIA_INPUT_CRC0_CHANNEL5                                                                   0x0005
#define ixAZALIA_INPUT_CRC0_CHANNEL6                                                                   0x0006
#define ixAZALIA_INPUT_CRC0_CHANNEL7                                                                   0x0007


// addressBlock: azf0controller_azinputcrc1resultind
// base address: 0x0
#define ixAZALIA_INPUT_CRC1_CHANNEL0                                                                   0x0000
#define ixAZALIA_INPUT_CRC1_CHANNEL1                                                                   0x0001
#define ixAZALIA_INPUT_CRC1_CHANNEL2                                                                   0x0002
#define ixAZALIA_INPUT_CRC1_CHANNEL3                                                                   0x0003
#define ixAZALIA_INPUT_CRC1_CHANNEL4                                                                   0x0004
#define ixAZALIA_INPUT_CRC1_CHANNEL5                                                                   0x0005
#define ixAZALIA_INPUT_CRC1_CHANNEL6                                                                   0x0006
#define ixAZALIA_INPUT_CRC1_CHANNEL7                                                                   0x0007


// addressBlock: azf0controller_azcrc0resultind
// base address: 0x0
#define ixAZALIA_CRC0_CHANNEL0                                                                         0x0000
#define ixAZALIA_CRC0_CHANNEL1                                                                         0x0001
#define ixAZALIA_CRC0_CHANNEL2                                                                         0x0002
#define ixAZALIA_CRC0_CHANNEL3                                                                         0x0003
#define ixAZALIA_CRC0_CHANNEL4                                                                         0x0004
#define ixAZALIA_CRC0_CHANNEL5                                                                         0x0005
#define ixAZALIA_CRC0_CHANNEL6                                                                         0x0006
#define ixAZALIA_CRC0_CHANNEL7                                                                         0x0007


// addressBlock: azf0controller_azcrc1resultind
// base address: 0x0
#define ixAZALIA_CRC1_CHANNEL0                                                                         0x0000
#define ixAZALIA_CRC1_CHANNEL1                                                                         0x0001
#define ixAZALIA_CRC1_CHANNEL2                                                                         0x0002
#define ixAZALIA_CRC1_CHANNEL3                                                                         0x0003
#define ixAZALIA_CRC1_CHANNEL4                                                                         0x0004
#define ixAZALIA_CRC1_CHANNEL5                                                                         0x0005
#define ixAZALIA_CRC1_CHANNEL6                                                                         0x0006
#define ixAZALIA_CRC1_CHANNEL7                                                                         0x0007


// addressBlock: azinputendpoint_f2codecind
// base address: 0x0
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                                     0x6200
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                                    0x6706
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                                    0x670d
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                          0x6f09
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                               0x6f0a
#define ixAZALIA_F2_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                                     0x6f0b
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                                             0x7707
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                                       0x7708
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_PIN_SENSE                                         0x7709
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                             0x771c
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_2                           0x771d
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_3                           0x771e
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT_4                           0x771f
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                                         0x7771
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL0_ENABLE                                       0x7777
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL2_ENABLE                                       0x7778
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL4_ENABLE                                       0x7779
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL6_ENABLE                                       0x777a
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_HBR                                                        0x777c
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL1_ENABLE                                       0x7785
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL3_ENABLE                                       0x7786
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL5_ENABLE                                       0x7787
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL7_ENABLE                                       0x7788
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                                      0x7798
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_LPIB                                                       0x7799
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                        0x779a
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                                       0x779b
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_INFOFRAME                                                  0x779c
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_CHANNEL_STATUS_L                                           0x779d
#define ixAZALIA_F2_CODEC_INPUT_PIN_CONTROL_CHANNEL_STATUS_H                                           0x779e
#define ixAZALIA_F2_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                                0x7f09
#define ixAZALIA_F2_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                                             0x7f0c


// addressBlock: azroot_f2codecind
// base address: 0x0
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                                          0x0f00
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_REVISION_ID                                                   0x0f02
#define ixAZALIA_F2_CODEC_ROOT_PARAMETER_SUBORDINATE_NODE_COUNT                                        0x0f04
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_POWER_STATE                                                 0x1705
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                                       0x1720
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_2                                     0x1721
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_3                                     0x1722
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_4                                     0x1723
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION                                   0x1770
#define ixAZALIA_F2_CODEC_FUNCTION_CONTROL_RESET                                                       0x17ff
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_SUBORDINATE_NODE_COUNT                                    0x1f04
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                                                0x1f05
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES                                      0x1f0a
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                                            0x1f0b
#define ixAZALIA_F2_CODEC_FUNCTION_PARAMETER_POWER_STATES                                              0x1f0f


// addressBlock: azf0stream0_streamind
// base address: 0x0
#define ixAZF0STREAM0_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM0_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM0_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM0_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM0_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream1_streamind
// base address: 0x0
#define ixAZF0STREAM1_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM1_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM1_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM1_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM1_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream2_streamind
// base address: 0x0
#define ixAZF0STREAM2_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM2_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM2_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM2_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM2_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream3_streamind
// base address: 0x0
#define ixAZF0STREAM3_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM3_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM3_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM3_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM3_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream4_streamind
// base address: 0x0
#define ixAZF0STREAM4_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM4_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM4_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM4_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM4_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream5_streamind
// base address: 0x0
#define ixAZF0STREAM5_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM5_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM5_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM5_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM5_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream6_streamind
// base address: 0x0
#define ixAZF0STREAM6_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM6_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM6_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM6_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM6_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream7_streamind
// base address: 0x0
#define ixAZF0STREAM7_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM7_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM7_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM7_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM7_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream8_streamind
// base address: 0x0
#define ixAZF0STREAM8_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM8_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM8_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM8_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM8_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream9_streamind
// base address: 0x0
#define ixAZF0STREAM9_AZALIA_FIFO_SIZE_CONTROL                                                         0x0000
#define ixAZF0STREAM9_AZALIA_LATENCY_COUNTER_CONTROL                                                   0x0001
#define ixAZF0STREAM9_AZALIA_WORSTCASE_LATENCY_COUNT                                                   0x0002
#define ixAZF0STREAM9_AZALIA_CUMULATIVE_LATENCY_COUNT                                                  0x0003
#define ixAZF0STREAM9_AZALIA_CUMULATIVE_REQUEST_COUNT                                                  0x0004


// addressBlock: azf0stream10_streamind
// base address: 0x0
#define ixAZF0STREAM10_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM10_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM10_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM10_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM10_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream11_streamind
// base address: 0x0
#define ixAZF0STREAM11_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM11_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM11_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM11_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM11_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream12_streamind
// base address: 0x0
#define ixAZF0STREAM12_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM12_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM12_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM12_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM12_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream13_streamind
// base address: 0x0
#define ixAZF0STREAM13_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM13_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM13_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM13_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM13_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream14_streamind
// base address: 0x0
#define ixAZF0STREAM14_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM14_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM14_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM14_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM14_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0stream15_streamind
// base address: 0x0
#define ixAZF0STREAM15_AZALIA_FIFO_SIZE_CONTROL                                                        0x0000
#define ixAZF0STREAM15_AZALIA_LATENCY_COUNTER_CONTROL                                                  0x0001
#define ixAZF0STREAM15_AZALIA_WORSTCASE_LATENCY_COUNT                                                  0x0002
#define ixAZF0STREAM15_AZALIA_CUMULATIVE_LATENCY_COUNT                                                 0x0003
#define ixAZF0STREAM15_AZALIA_CUMULATIVE_REQUEST_COUNT                                                 0x0004


// addressBlock: azf0endpoint0_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT0_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT0_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT0_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0endpoint1_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT1_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT1_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT1_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0endpoint2_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT2_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT2_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT2_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0endpoint3_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT3_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT3_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT3_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0endpoint4_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT4_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT4_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT4_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0endpoint5_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT5_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT5_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT5_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0endpoint6_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT6_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT6_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT6_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0endpoint7_endpointind
// base address: 0x0
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES                  0x0001
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_CONVERTER_FORMAT                             0x0002
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_CHANNEL_STREAM_ID                            0x0003
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_DIGITAL_CONVERTER                            0x0004
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_PARAMETER_STREAM_FORMATS                             0x0005
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES                       0x0006
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_STRIPE_CONTROL                                       0x0007
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_RAMP_RATE                                    0x0008
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_CONTROL_GTC_EMBEDDING                                0x0009
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA                                    0x000c
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MIN                                0x000d
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_CONVERTER_GTC_COUNTER_DELTA_MAX                                0x000e
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES                        0x0020
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_PARAMETER_CAPABILITIES                                     0x0021
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE                               0x0022
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_PIN_SENSE                                 0x0023
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_WIDGET_CONTROL                                     0x0024
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_CHANNEL_SPEAKER                                    0x0025
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR0                                  0x0028
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR1                                  0x0029
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR2                                  0x002a
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR3                                  0x002b
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR4                                  0x002c
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR5                                  0x002d
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR6                                  0x002e
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR7                                  0x002f
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR8                                  0x0030
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR9                                  0x0031
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR10                                 0x0032
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR11                                 0x0033
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR12                                 0x0034
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_AUDIO_DESCRIPTOR13                                 0x0035
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE                                0x0036
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_LIPSYNC                                   0x0037
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_HBR                                       0x0038
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO0                                         0x003a
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO1                                         0x003b
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO2                                         0x003c
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO3                                         0x003d
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO4                                         0x003e
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO5                                         0x003f
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO6                                         0x0040
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO7                                         0x0041
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_SINK_INFO8                                         0x0042
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_HOT_PLUG_CONTROL                                   0x0054
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE                         0x0055
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT                     0x0056
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_ENABLE2                               0x0057
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_MULTICHANNEL_MODE                                  0x0058
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_0                                      0x0059
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_1                                      0x005a
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_2                                      0x005b
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_3                                      0x005c
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_4                                      0x005d
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_5                                      0x005e
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_6                                      0x005f
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_7                                      0x0060
#define ixAZF0ENDPOINT7_AZALIA_F0_PIN_CONTROL_CODEC_CS_OVERRIDE_8                                      0x0061
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_ASSOCIATION_INFO                                           0x0062
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_DIGITAL_OUTPUT_STATUS                              0x0063
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                              0x0064
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_LPIB                                               0x0065
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                                0x0066
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_CODING_TYPE                                        0x0067
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_FORMAT_CHANGED                                     0x0068
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_WIRELESS_DISPLAY_IDENTIFICATION                    0x0069
#define ixAZF0ENDPOINT7_AZALIA_F0_CODEC_PIN_CONTROL_REMOTE_KEEPALIVE                                   0x006a
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_ENABLE_STATUS                                                  0x006b
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_ENABLED_INT_STATUS                                             0x006c
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_DISABLED_INT_STATUS                                            0x006d
#define ixAZF0ENDPOINT7_AZALIA_F0_AUDIO_FORMAT_CHANGED_INT_STATUS                                      0x006e


// addressBlock: azf0inputendpoint0_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint1_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint2_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint3_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint4_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint5_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint6_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068


// addressBlock: azf0inputendpoint7_inputendpointind
// base address: 0x0
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_AUDIO_WIDGET_CAPABILITIES       0x0001
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CONVERTER_FORMAT                  0x0002
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_CHANNEL_STREAM_ID                 0x0003
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_CONTROL_DIGITAL_CONVERTER                 0x0004
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_STREAM_FORMATS                  0x0005
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_CONVERTER_PARAMETER_SUPPORTED_SIZE_RATES            0x0006
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_AUDIO_WIDGET_CAPABILITIES             0x0020
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_PARAMETER_CAPABILITIES                          0x0021
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE                    0x0022
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_INPUT_PIN_SENSE                0x0023
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_WIDGET_CONTROL                          0x0024
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE                     0x0036
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_MULTICHANNEL_ENABLE2                    0x0037
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_HBR                            0x0038
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_CHANNEL_ALLOCATION                      0x0053
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_HOT_PLUG_CONTROL                        0x0054
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_UNSOLICITED_RESPONSE_FORCE              0x0055
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_RESPONSE_CONFIGURATION_DEFAULT          0x0056
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_SNAPSHOT_CONTROL                   0x0064
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB                                    0x0065
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_LPIB_TIMER_SNAPSHOT                     0x0066
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INPUT_STATUS_CONTROL                    0x0067
#define ixAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_PIN_CONTROL_INFOFRAME                               0x0068

#endif
