/*
 * r8a7792 processor support - PFC hardware block.
 *
 * Copyright (C) 2013-2014 Renesas Electronics Corporation
 * Copyright (C) 2016 Cogent Embedded, Inc., <source@cogentembedded.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 */

#include <linux/kernel.h>

#include "core.h"
#include "sh_pfc.h"

#define CPU_ALL_PORT(fn, sfx)						\
	PORT_GP_29(0, fn, sfx),						\
	PORT_GP_23(1, fn, sfx),						\
	PORT_GP_32(2, fn, sfx),						\
	PORT_GP_28(3, fn, sfx),						\
	PORT_GP_17(4, fn, sfx),						\
	PORT_GP_17(5, fn, sfx),						\
	PORT_GP_17(6, fn, sfx),						\
	PORT_GP_17(7, fn, sfx),						\
	PORT_GP_17(8, fn, sfx),						\
	PORT_GP_17(9, fn, sfx),						\
	PORT_GP_32(10, fn, sfx),					\
	PORT_GP_30(11, fn, sfx)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA),
	PINMUX_DATA_END,

	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN),

	/* GPSR0 */
	FN_IP0_0, FN_IP0_1, FN_IP0_2, FN_IP0_3, FN_IP0_4, FN_IP0_5,
	FN_IP0_6, FN_IP0_7, FN_IP0_8, FN_IP0_9, FN_IP0_10, FN_IP0_11,
	FN_IP0_12, FN_IP0_13, FN_IP0_14, FN_IP0_15, FN_IP0_16,
	FN_IP0_17, FN_IP0_18, FN_IP0_19, FN_IP0_20, FN_IP0_21,
	FN_IP0_22, FN_IP0_23, FN_IP1_0, FN_IP1_1, FN_IP1_2,
	FN_IP1_3, FN_IP1_4,

	/* GPSR1 */
	FN_IP1_5, FN_IP1_6, FN_IP1_7, FN_IP1_8, FN_IP1_9, FN_IP1_10,
	FN_IP1_11, FN_IP1_12, FN_IP1_13, FN_IP1_14, FN_IP1_15, FN_IP1_16,
	FN_DU1_DB2_C0_DATA12, FN_DU1_DB3_C1_DATA13, FN_DU1_DB4_C2_DATA14,
	FN_DU1_DB5_C3_DATA15, FN_DU1_DB6_C4, FN_DU1_DB7_C5,
	FN_DU1_EXHSYNC_DU1_HSYNC, FN_DU1_EXVSYNC_DU1_VSYNC,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE, FN_DU1_DISP, FN_DU1_CDE,

	/* GPSR2 */
	FN_D0, FN_D1, FN_D2, FN_D3, FN_D4, FN_D5, FN_D6, FN_D7,
	FN_D8, FN_D9, FN_D10, FN_D11, FN_D12, FN_D13, FN_D14, FN_D15,
	FN_A0, FN_A1, FN_A2, FN_A3, FN_A4, FN_A5, FN_A6, FN_A7,
	FN_A8, FN_A9, FN_A10, FN_A11, FN_A12, FN_A13, FN_A14, FN_A15,

	/* GPSR3 */
	FN_A16, FN_A17, FN_A18, FN_A19, FN_IP1_17, FN_IP1_18,
	FN_CS1_N_A26, FN_EX_CS0_N, FN_EX_CS1_N, FN_EX_CS2_N, FN_EX_CS3_N,
	FN_EX_CS4_N, FN_EX_CS5_N, FN_BS_N, FN_RD_N, FN_RD_WR_N,
	FN_WE0_N, FN_WE1_N, FN_EX_WAIT0, FN_IRQ0, FN_IRQ1, FN_IRQ2, FN_IRQ3,
	FN_IP1_19, FN_IP1_20, FN_IP1_21, FN_IP1_22, FN_CS0_N,

	/* GPSR4 */
	FN_VI0_CLK, FN_VI0_CLKENB, FN_VI0_HSYNC_N, FN_VI0_VSYNC_N,
	FN_VI0_D0_B0_C0, FN_VI0_D1_B1_C1, FN_VI0_D2_B2_C2, FN_VI0_D3_B3_C3,
	FN_VI0_D4_B4_C4, FN_VI0_D5_B5_C5, FN_VI0_D6_B6_C6, FN_VI0_D7_B7_C7,
	FN_VI0_D8_G0_Y0, FN_VI0_D9_G1_Y1, FN_VI0_D10_G2_Y2, FN_VI0_D11_G3_Y3,
	FN_VI0_FIELD,

	/* GPSR5 */
	FN_VI1_CLK, FN_VI1_CLKENB, FN_VI1_HSYNC_N, FN_VI1_VSYNC_N,
	FN_VI1_D0_B0_C0, FN_VI1_D1_B1_C1, FN_VI1_D2_B2_C2, FN_VI1_D3_B3_C3,
	FN_VI1_D4_B4_C4, FN_VI1_D5_B5_C5, FN_VI1_D6_B6_C6, FN_VI1_D7_B7_C7,
	FN_VI1_D8_G0_Y0, FN_VI1_D9_G1_Y1, FN_VI1_D10_G2_Y2, FN_VI1_D11_G3_Y3,
	FN_VI1_FIELD,

	/* GPSR6 */
	FN_IP2_0, FN_IP2_1, FN_IP2_2, FN_IP2_3, FN_IP2_4, FN_IP2_5, FN_IP2_6,
	FN_IP2_7, FN_IP2_8, FN_IP2_9, FN_IP2_10, FN_IP2_11, FN_IP2_12,
	FN_IP2_13, FN_IP2_14, FN_IP2_15, FN_IP2_16,

	/* GPSR7 */
	FN_IP3_0, FN_IP3_1, FN_IP3_2, FN_IP3_3, FN_IP3_4, FN_IP3_5, FN_IP3_6,
	FN_IP3_7, FN_IP3_8, FN_IP3_9, FN_IP3_10, FN_IP3_11, FN_IP3_12,
	FN_IP3_13, FN_VI3_D10_Y2, FN_IP3_14, FN_VI3_FIELD,

	/* GPSR8 */
	FN_VI4_CLK, FN_IP4_0, FN_IP4_1, FN_IP4_3_2, FN_IP4_4, FN_IP4_6_5,
	FN_IP4_8_7, FN_IP4_10_9, FN_IP4_12_11, FN_IP4_14_13, FN_IP4_16_15,
	FN_IP4_18_17, FN_IP4_20_19, FN_IP4_21, FN_IP4_22, FN_IP4_23, FN_IP4_24,

	/* GPSR9 */
	FN_VI5_CLK, FN_IP5_0, FN_IP5_1, FN_IP5_2, FN_IP5_3, FN_IP5_4, FN_IP5_5,
	FN_IP5_6, FN_IP5_7, FN_IP5_8, FN_IP5_9, FN_IP5_10, FN_IP5_11,
	FN_VI5_D9_Y1, FN_VI5_D10_Y2, FN_VI5_D11_Y3, FN_VI5_FIELD,

	/* GPSR10 */
	FN_IP6_0, FN_IP6_1, FN_HRTS0_N, FN_IP6_2, FN_IP6_3, FN_IP6_4, FN_IP6_5,
	FN_HCTS1_N, FN_IP6_6, FN_IP6_7,	FN_SCK0, FN_CTS0_N, FN_RTS0_N,
	FN_TX0, FN_RX0, FN_SCK1, FN_CTS1_N, FN_RTS1_N, FN_TX1, FN_RX1,
	FN_IP6_9_8, FN_IP6_11_10, FN_IP6_13_12, FN_IP6_15_14, FN_IP6_16,
	FN_IP6_18_17, FN_SCIF_CLK, FN_CAN0_TX, FN_CAN0_RX, FN_CAN_CLK,
	FN_CAN1_TX, FN_CAN1_RX,

	/* GPSR11 */
	FN_IP7_1_0, FN_IP7_3_2, FN_IP7_5_4, FN_IP7_6, FN_IP7_7, FN_SD0_CLK,
	FN_SD0_CMD, FN_SD0_DAT0, FN_SD0_DAT1, FN_SD0_DAT2, FN_SD0_DAT3,
	FN_SD0_CD, FN_SD0_WP, FN_IP7_9_8, FN_IP7_11_10, FN_IP7_13_12,
	FN_IP7_15_14, FN_IP7_16, FN_IP7_17, FN_IP7_18, FN_IP7_19, FN_IP7_20,
	FN_ADICLK, FN_ADICS_SAMP, FN_ADIDATA, FN_ADICHS0, FN_ADICHS1,
	FN_ADICHS2, FN_AVS1, FN_AVS2,

	/* IPSR0 */
	FN_DU0_DR0_DATA0, FN_DU0_DR1_DATA1, FN_DU0_DR2_Y4_DATA2,
	FN_DU0_DR3_Y5_DATA3, FN_DU0_DR4_Y6_DATA4, FN_DU0_DR5_Y7_DATA5,
	FN_DU0_DR6_Y8_DATA6, FN_DU0_DR7_Y9_DATA7, FN_DU0_DG0_DATA8,
	FN_DU0_DG1_DATA9, FN_DU0_DG2_C6_DATA10, FN_DU0_DG3_C7_DATA11,
	FN_DU0_DG4_Y0_DATA12, FN_DU0_DG5_Y1_DATA13, FN_DU0_DG6_Y2_DATA14,
	FN_DU0_DG7_Y3_DATA15, FN_DU0_DB0, FN_DU0_DB1, FN_DU0_DB2_C0,
	FN_DU0_DB3_C1, FN_DU0_DB4_C2, FN_DU0_DB5_C3, FN_DU0_DB6_C4,
	FN_DU0_DB7_C5,

	/* IPSR1 */
	FN_DU0_EXHSYNC_DU0_HSYNC, FN_DU0_EXVSYNC_DU0_VSYNC,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, FN_DU0_DISP, FN_DU0_CDE,
	FN_DU1_DR2_Y4_DATA0, FN_DU1_DR3_Y5_DATA1, FN_DU1_DR4_Y6_DATA2,
	FN_DU1_DR5_Y7_DATA3, FN_DU1_DR6_DATA4, FN_DU1_DR7_DATA5,
	FN_DU1_DG2_C6_DATA6, FN_DU1_DG3_C7_DATA7, FN_DU1_DG4_Y0_DATA8,
	FN_DU1_DG5_Y1_DATA9, FN_DU1_DG6_Y2_DATA10, FN_DU1_DG7_Y3_DATA11,
	FN_A20, FN_MOSI_IO0, FN_A21, FN_MISO_IO1, FN_A22, FN_IO2,
	FN_A23, FN_IO3, FN_A24, FN_SPCLK, FN_A25, FN_SSL,

	/* IPSR2 */
	FN_VI2_CLK, FN_AVB_RX_CLK, FN_VI2_CLKENB, FN_AVB_RX_DV,
	FN_VI2_HSYNC_N, FN_AVB_RXD0, FN_VI2_VSYNC_N, FN_AVB_RXD1,
	FN_VI2_D0_C0, FN_AVB_RXD2, FN_VI2_D1_C1, FN_AVB_RXD3,
	FN_VI2_D2_C2, FN_AVB_RXD4, FN_VI2_D3_C3, FN_AVB_RXD5,
	FN_VI2_D4_C4, FN_AVB_RXD6, FN_VI2_D5_C5, FN_AVB_RXD7,
	FN_VI2_D6_C6, FN_AVB_RX_ER, FN_VI2_D7_C7, FN_AVB_COL,
	FN_VI2_D8_Y0, FN_AVB_TXD3, FN_VI2_D9_Y1, FN_AVB_TX_EN,
	FN_VI2_D10_Y2, FN_AVB_TXD0, FN_VI2_D11_Y3, FN_AVB_TXD1,
	FN_VI2_FIELD, FN_AVB_TXD2,

	/* IPSR3 */
	FN_VI3_CLK, FN_AVB_TX_CLK, FN_VI3_CLKENB, FN_AVB_TXD4,
	FN_VI3_HSYNC_N, FN_AVB_TXD5, FN_VI3_VSYNC_N, FN_AVB_TXD6,
	FN_VI3_D0_C0, FN_AVB_TXD7, FN_VI3_D1_C1, FN_AVB_TX_ER,
	FN_VI3_D2_C2, FN_AVB_GTX_CLK, FN_VI3_D3_C3, FN_AVB_MDC,
	FN_VI3_D4_C4, FN_AVB_MDIO, FN_VI3_D5_C5, FN_AVB_LINK,
	FN_VI3_D6_C6, FN_AVB_MAGIC, FN_VI3_D7_C7, FN_AVB_PHY_INT,
	FN_VI3_D8_Y0, FN_AVB_CRS, FN_VI3_D9_Y1, FN_AVB_GTXREFCLK,
	FN_VI3_D11_Y3, FN_AVB_AVTP_MATCH,

	/* IPSR4 */
	FN_VI4_CLKENB, FN_VI0_D12_G4_Y4, FN_VI4_HSYNC_N, FN_VI0_D13_G5_Y5,
	FN_VI4_VSYNC_N, FN_VI0_D14_G6_Y6, FN_RDR_CLKOUT,
	FN_VI4_D0_C0, FN_VI0_D15_G7_Y7,
	FN_VI4_D1_C1, FN_VI0_D16_R0, FN_VI1_D12_G4_Y4,
	FN_VI4_D2_C2, FN_VI0_D17_R1, FN_VI1_D13_G5_Y5,
	FN_VI4_D3_C3, FN_VI0_D18_R2, FN_VI1_D14_G6_Y6,
	FN_VI4_D4_C4, FN_VI0_D19_R3, FN_VI1_D15_G7_Y7,
	FN_VI4_D5_C5, FN_VI0_D20_R4, FN_VI2_D12_Y4,
	FN_VI4_D6_C6, FN_VI0_D21_R5, FN_VI2_D13_Y5,
	FN_VI4_D7_C7, FN_VI0_D22_R6, FN_VI2_D14_Y6,
	FN_VI4_D8_Y0, FN_VI0_D23_R7, FN_VI2_D15_Y7,
	FN_VI4_D9_Y1, FN_VI3_D12_Y4, FN_VI4_D10_Y2, FN_VI3_D13_Y5,
	FN_VI4_D11_Y3, FN_VI3_D14_Y6, FN_VI4_FIELD, FN_VI3_D15_Y7,

	/* IPSR5 */
	FN_VI5_CLKENB, FN_VI1_D12_G4_Y4_B, FN_VI5_HSYNC_N, FN_VI1_D13_G5_Y5_B,
	FN_VI5_VSYNC_N, FN_VI1_D14_G6_Y6_B, FN_VI5_D0_C0, FN_VI1_D15_G7_Y7_B,
	FN_VI5_D1_C1, FN_VI1_D16_R0, FN_VI5_D2_C2, FN_VI1_D17_R1,
	FN_VI5_D3_C3, FN_VI1_D18_R2, FN_VI5_D4_C4, FN_VI1_D19_R3,
	FN_VI5_D5_C5, FN_VI1_D20_R4, FN_VI5_D6_C6, FN_VI1_D21_R5,
	FN_VI5_D7_C7, FN_VI1_D22_R6, FN_VI5_D8_Y0, FN_VI1_D23_R7,

	/* IPSR6 */
	FN_MSIOF0_SCK, FN_HSCK0, FN_MSIOF0_SYNC, FN_HCTS0_N,
	FN_MSIOF0_TXD, FN_HTX0, FN_MSIOF0_RXD, FN_HRX0,
	FN_MSIOF1_SCK, FN_HSCK1, FN_MSIOF1_SYNC, FN_HRTS1_N,
	FN_MSIOF1_TXD, FN_HTX1, FN_MSIOF1_RXD, FN_HRX1,
	FN_DRACK0, FN_SCK2, FN_DACK0, FN_TX2, FN_DREQ0_N, FN_RX2,
	FN_DACK1, FN_SCK3, FN_TX3, FN_DREQ1_N, FN_RX3,

	/* IPSR7 */
	FN_PWM0, FN_TCLK1, FN_FSO_CFE_0, FN_PWM1, FN_TCLK2, FN_FSO_CFE_1,
	FN_PWM2, FN_TCLK3, FN_FSO_TOE, FN_PWM3, FN_PWM4,
	FN_SSI_SCK34, FN_TPU0TO0, FN_SSI_WS34, FN_TPU0TO1,
	FN_SSI_SDATA3, FN_TPU0TO2, FN_SSI_SCK4, FN_TPU0TO3,
	FN_SSI_WS4, FN_SSI_SDATA4, FN_AUDIO_CLKOUT,
	FN_AUDIO_CLKA, FN_AUDIO_CLKB,

	/* MOD_SEL */
	FN_SEL_VI1_0, FN_SEL_VI1_1,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	DU1_DB2_C0_DATA12_MARK, DU1_DB3_C1_DATA13_MARK,
	DU1_DB4_C2_DATA14_MARK, DU1_DB5_C3_DATA15_MARK,
	DU1_DB6_C4_MARK, DU1_DB7_C5_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK,
	DU1_EXVSYNC_DU1_VSYNC_MARK, DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK,
	DU1_DISP_MARK, DU1_CDE_MARK,

	D0_MARK, D1_MARK, D2_MARK, D3_MARK, D4_MARK, D5_MARK, D6_MARK,
	D7_MARK, D8_MARK, D9_MARK, D10_MARK, D11_MARK, D12_MARK, D13_MARK,
	D14_MARK, D15_MARK, A0_MARK, A1_MARK, A2_MARK, A3_MARK, A4_MARK,
	A5_MARK, A6_MARK, A7_MARK, A8_MARK, A9_MARK, A10_MARK, A11_MARK,
	A12_MARK, A13_MARK, A14_MARK, A15_MARK,

	A16_MARK, A17_MARK, A18_MARK, A19_MARK, CS1_N_A26_MARK,
	EX_CS0_N_MARK, EX_CS1_N_MARK, EX_CS2_N_MARK, EX_CS3_N_MARK,
	EX_CS4_N_MARK, EX_CS5_N_MARK, BS_N_MARK, RD_N_MARK, RD_WR_N_MARK,
	WE0_N_MARK, WE1_N_MARK, EX_WAIT0_MARK,
	IRQ0_MARK, IRQ1_MARK, IRQ2_MARK, IRQ3_MARK, CS0_N_MARK,

	VI0_CLK_MARK, VI0_CLKENB_MARK, VI0_HSYNC_N_MARK, VI0_VSYNC_N_MARK,
	VI0_D0_B0_C0_MARK, VI0_D1_B1_C1_MARK, VI0_D2_B2_C2_MARK,
	VI0_D3_B3_C3_MARK, VI0_D4_B4_C4_MARK, VI0_D5_B5_C5_MARK,
	VI0_D6_B6_C6_MARK, VI0_D7_B7_C7_MARK, VI0_D8_G0_Y0_MARK,
	VI0_D9_G1_Y1_MARK, VI0_D10_G2_Y2_MARK, VI0_D11_G3_Y3_MARK,
	VI0_FIELD_MARK,

	VI1_CLK_MARK, VI1_CLKENB_MARK, VI1_HSYNC_N_MARK, VI1_VSYNC_N_MARK,
	VI1_D0_B0_C0_MARK, VI1_D1_B1_C1_MARK, VI1_D2_B2_C2_MARK,
	VI1_D3_B3_C3_MARK, VI1_D4_B4_C4_MARK, VI1_D5_B5_C5_MARK,
	VI1_D6_B6_C6_MARK, VI1_D7_B7_C7_MARK, VI1_D8_G0_Y0_MARK,
	VI1_D9_G1_Y1_MARK, VI1_D10_G2_Y2_MARK, VI1_D11_G3_Y3_MARK,
	VI1_FIELD_MARK,

	VI3_D10_Y2_MARK, VI3_FIELD_MARK,

	VI4_CLK_MARK,

	VI5_CLK_MARK, VI5_D9_Y1_MARK, VI5_D10_Y2_MARK, VI5_D11_Y3_MARK,
	VI5_FIELD_MARK,

	HRTS0_N_MARK, HCTS1_N_MARK, SCK0_MARK, CTS0_N_MARK, RTS0_N_MARK,
	TX0_MARK, RX0_MARK, SCK1_MARK, CTS1_N_MARK, RTS1_N_MARK,
	TX1_MARK, RX1_MARK, SCIF_CLK_MARK, CAN0_TX_MARK, CAN0_RX_MARK,
	CAN_CLK_MARK, CAN1_TX_MARK, CAN1_RX_MARK,

	SD0_CLK_MARK, SD0_CMD_MARK, SD0_DAT0_MARK, SD0_DAT1_MARK,
	SD0_DAT2_MARK, SD0_DAT3_MARK, SD0_CD_MARK, SD0_WP_MARK,
	ADICLK_MARK, ADICS_SAMP_MARK, ADIDATA_MARK, ADICHS0_MARK,
	ADICHS1_MARK, ADICHS2_MARK, AVS1_MARK, AVS2_MARK,

	/* IPSR0 */
	DU0_DR0_DATA0_MARK, DU0_DR1_DATA1_MARK, DU0_DR2_Y4_DATA2_MARK,
	DU0_DR3_Y5_DATA3_MARK, DU0_DR4_Y6_DATA4_MARK, DU0_DR5_Y7_DATA5_MARK,
	DU0_DR6_Y8_DATA6_MARK, DU0_DR7_Y9_DATA7_MARK, DU0_DG0_DATA8_MARK,
	DU0_DG1_DATA9_MARK, DU0_DG2_C6_DATA10_MARK, DU0_DG3_C7_DATA11_MARK,
	DU0_DG4_Y0_DATA12_MARK, DU0_DG5_Y1_DATA13_MARK, DU0_DG6_Y2_DATA14_MARK,
	DU0_DG7_Y3_DATA15_MARK, DU0_DB0_MARK, DU0_DB1_MARK,
	DU0_DB2_C0_MARK, DU0_DB3_C1_MARK, DU0_DB4_C2_MARK, DU0_DB5_C3_MARK,
	DU0_DB6_C4_MARK, DU0_DB7_C5_MARK,

	/* IPSR1 */
	DU0_EXHSYNC_DU0_HSYNC_MARK, DU0_EXVSYNC_DU0_VSYNC_MARK,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK, DU0_DISP_MARK, DU0_CDE_MARK,
	DU1_DR2_Y4_DATA0_MARK, DU1_DR3_Y5_DATA1_MARK, DU1_DR4_Y6_DATA2_MARK,
	DU1_DR5_Y7_DATA3_MARK, DU1_DR6_DATA4_MARK, DU1_DR7_DATA5_MARK,
	DU1_DG2_C6_DATA6_MARK, DU1_DG3_C7_DATA7_MARK, DU1_DG4_Y0_DATA8_MARK,
	DU1_DG5_Y1_DATA9_MARK, DU1_DG6_Y2_DATA10_MARK, DU1_DG7_Y3_DATA11_MARK,
	A20_MARK, MOSI_IO0_MARK, A21_MARK, MISO_IO1_MARK, A22_MARK, IO2_MARK,
	A23_MARK, IO3_MARK, A24_MARK, SPCLK_MARK, A25_MARK, SSL_MARK,

	/* IPSR2 */
	VI2_CLK_MARK, AVB_RX_CLK_MARK, VI2_CLKENB_MARK, AVB_RX_DV_MARK,
	VI2_HSYNC_N_MARK, AVB_RXD0_MARK, VI2_VSYNC_N_MARK, AVB_RXD1_MARK,
	VI2_D0_C0_MARK, AVB_RXD2_MARK, VI2_D1_C1_MARK, AVB_TX_CLK_MARK,
	VI2_D2_C2_MARK, AVB_RXD4_MARK, VI2_D3_C3_MARK, AVB_RXD5_MARK,
	VI2_D4_C4_MARK, AVB_RXD6_MARK, VI2_D5_C5_MARK, AVB_RXD7_MARK,
	VI2_D6_C6_MARK, AVB_RX_ER_MARK, VI2_D7_C7_MARK, AVB_COL_MARK,
	VI2_D8_Y0_MARK, AVB_RXD3_MARK, VI2_D9_Y1_MARK, AVB_TX_EN_MARK,
	VI2_D10_Y2_MARK, AVB_TXD0_MARK,
	VI2_D11_Y3_MARK, AVB_TXD1_MARK, VI2_FIELD_MARK, AVB_TXD2_MARK,

	/* IPSR3 */
	VI3_CLK_MARK, AVB_TXD3_MARK, VI3_CLKENB_MARK, AVB_TXD4_MARK,
	VI3_HSYNC_N_MARK, AVB_TXD5_MARK, VI3_VSYNC_N_MARK, AVB_TXD6_MARK,
	VI3_D0_C0_MARK, AVB_TXD7_MARK, VI3_D1_C1_MARK, AVB_TX_ER_MARK,
	VI3_D2_C2_MARK, AVB_GTX_CLK_MARK, VI3_D3_C3_MARK, AVB_MDC_MARK,
	VI3_D4_C4_MARK, AVB_MDIO_MARK, VI3_D5_C5_MARK, AVB_LINK_MARK,
	VI3_D6_C6_MARK, AVB_MAGIC_MARK, VI3_D7_C7_MARK, AVB_PHY_INT_MARK,
	VI3_D8_Y0_MARK, AVB_CRS_MARK, VI3_D9_Y1_MARK, AVB_GTXREFCLK_MARK,
	VI3_D11_Y3_MARK, AVB_AVTP_MATCH_MARK,

	/* IPSR4 */
	VI4_CLKENB_MARK, VI0_D12_G4_Y4_MARK, VI4_HSYNC_N_MARK,
	VI0_D13_G5_Y5_MARK, VI4_VSYNC_N_MARK, VI0_D14_G6_Y6_MARK,
	RDR_CLKOUT_MARK, VI4_D0_C0_MARK, VI0_D15_G7_Y7_MARK, VI4_D1_C1_MARK,
	VI0_D16_R0_MARK, VI1_D12_G4_Y4_MARK, VI4_D2_C2_MARK, VI0_D17_R1_MARK,
	VI1_D13_G5_Y5_MARK, VI4_D3_C3_MARK, VI0_D18_R2_MARK, VI1_D14_G6_Y6_MARK,
	VI4_D4_C4_MARK,	VI0_D19_R3_MARK, VI1_D15_G7_Y7_MARK, VI4_D5_C5_MARK,
	VI0_D20_R4_MARK, VI2_D12_Y4_MARK, VI4_D6_C6_MARK, VI0_D21_R5_MARK,
	VI2_D13_Y5_MARK, VI4_D7_C7_MARK, VI0_D22_R6_MARK, VI2_D14_Y6_MARK,
	VI4_D8_Y0_MARK, VI0_D23_R7_MARK, VI2_D15_Y7_MARK, VI4_D9_Y1_MARK,
	VI3_D12_Y4_MARK, VI4_D10_Y2_MARK, VI3_D13_Y5_MARK, VI4_D11_Y3_MARK,
	VI3_D14_Y6_MARK, VI4_FIELD_MARK, VI3_D15_Y7_MARK,

	/* IPSR5 */
	VI5_CLKENB_MARK, VI1_D12_G4_Y4_B_MARK, VI5_HSYNC_N_MARK,
	VI1_D13_G5_Y5_B_MARK, VI5_VSYNC_N_MARK, VI1_D14_G6_Y6_B_MARK,
	VI5_D0_C0_MARK, VI1_D15_G7_Y7_B_MARK, VI5_D1_C1_MARK, VI1_D16_R0_MARK,
	VI5_D2_C2_MARK, VI1_D17_R1_MARK, VI5_D3_C3_MARK, VI1_D18_R2_MARK,
	VI5_D4_C4_MARK, VI1_D19_R3_MARK, VI5_D5_C5_MARK, VI1_D20_R4_MARK,
	VI5_D6_C6_MARK, VI1_D21_R5_MARK, VI5_D7_C7_MARK, VI1_D22_R6_MARK,
	VI5_D8_Y0_MARK, VI1_D23_R7_MARK,

	/* IPSR6 */
	MSIOF0_SCK_MARK, HSCK0_MARK, MSIOF0_SYNC_MARK, HCTS0_N_MARK,
	MSIOF0_TXD_MARK, HTX0_MARK, MSIOF0_RXD_MARK, HRX0_MARK,
	MSIOF1_SCK_MARK, HSCK1_MARK, MSIOF1_SYNC_MARK, HRTS1_N_MARK,
	MSIOF1_TXD_MARK, HTX1_MARK, MSIOF1_RXD_MARK, HRX1_MARK,
	DRACK0_MARK, SCK2_MARK, DACK0_MARK, TX2_MARK, DREQ0_N_MARK,
	RX2_MARK, DACK1_MARK, SCK3_MARK, TX3_MARK, DREQ1_N_MARK,
	RX3_MARK,

	/* IPSR7 */
	PWM0_MARK, TCLK1_MARK, FSO_CFE_0_MARK, PWM1_MARK, TCLK2_MARK,
	FSO_CFE_1_MARK, PWM2_MARK, TCLK3_MARK, FSO_TOE_MARK, PWM3_MARK,
	PWM4_MARK, SSI_SCK34_MARK, TPU0TO0_MARK, SSI_WS34_MARK, TPU0TO1_MARK,
	SSI_SDATA3_MARK, TPU0TO2_MARK, SSI_SCK4_MARK, TPU0TO3_MARK,
	SSI_WS4_MARK, SSI_SDATA4_MARK, AUDIO_CLKOUT_MARK, AUDIO_CLKA_MARK,
	AUDIO_CLKB_MARK,
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	PINMUX_DATA_GP_ALL(), /* PINMUX_DATA(GP_M_N_DATA, GP_M_N_FN...), */

	PINMUX_SINGLE(DU1_DB2_C0_DATA12),
	PINMUX_SINGLE(DU1_DB3_C1_DATA13),
	PINMUX_SINGLE(DU1_DB4_C2_DATA14),
	PINMUX_SINGLE(DU1_DB5_C3_DATA15),
	PINMUX_SINGLE(DU1_DB6_C4),
	PINMUX_SINGLE(DU1_DB7_C5),
	PINMUX_SINGLE(DU1_EXHSYNC_DU1_HSYNC),
	PINMUX_SINGLE(DU1_EXVSYNC_DU1_VSYNC),
	PINMUX_SINGLE(DU1_EXODDF_DU1_ODDF_DISP_CDE),
	PINMUX_SINGLE(DU1_DISP),
	PINMUX_SINGLE(DU1_CDE),
	PINMUX_SINGLE(D0),
	PINMUX_SINGLE(D1),
	PINMUX_SINGLE(D2),
	PINMUX_SINGLE(D3),
	PINMUX_SINGLE(D4),
	PINMUX_SINGLE(D5),
	PINMUX_SINGLE(D6),
	PINMUX_SINGLE(D7),
	PINMUX_SINGLE(D8),
	PINMUX_SINGLE(D9),
	PINMUX_SINGLE(D10),
	PINMUX_SINGLE(D11),
	PINMUX_SINGLE(D12),
	PINMUX_SINGLE(D13),
	PINMUX_SINGLE(D14),
	PINMUX_SINGLE(D15),
	PINMUX_SINGLE(A0),
	PINMUX_SINGLE(A1),
	PINMUX_SINGLE(A2),
	PINMUX_SINGLE(A3),
	PINMUX_SINGLE(A4),
	PINMUX_SINGLE(A5),
	PINMUX_SINGLE(A6),
	PINMUX_SINGLE(A7),
	PINMUX_SINGLE(A8),
	PINMUX_SINGLE(A9),
	PINMUX_SINGLE(A10),
	PINMUX_SINGLE(A11),
	PINMUX_SINGLE(A12),
	PINMUX_SINGLE(A13),
	PINMUX_SINGLE(A14),
	PINMUX_SINGLE(A15),
	PINMUX_SINGLE(A16),
	PINMUX_SINGLE(A17),
	PINMUX_SINGLE(A18),
	PINMUX_SINGLE(A19),
	PINMUX_SINGLE(CS1_N_A26),
	PINMUX_SINGLE(EX_CS0_N),
	PINMUX_SINGLE(EX_CS1_N),
	PINMUX_SINGLE(EX_CS2_N),
	PINMUX_SINGLE(EX_CS3_N),
	PINMUX_SINGLE(EX_CS4_N),
	PINMUX_SINGLE(EX_CS5_N),
	PINMUX_SINGLE(BS_N),
	PINMUX_SINGLE(RD_N),
	PINMUX_SINGLE(RD_WR_N),
	PINMUX_SINGLE(WE0_N),
	PINMUX_SINGLE(WE1_N),
	PINMUX_SINGLE(EX_WAIT0),
	PINMUX_SINGLE(IRQ0),
	PINMUX_SINGLE(IRQ1),
	PINMUX_SINGLE(IRQ2),
	PINMUX_SINGLE(IRQ3),
	PINMUX_SINGLE(CS0_N),
	PINMUX_SINGLE(VI0_CLK),
	PINMUX_SINGLE(VI0_CLKENB),
	PINMUX_SINGLE(VI0_HSYNC_N),
	PINMUX_SINGLE(VI0_VSYNC_N),
	PINMUX_SINGLE(VI0_D0_B0_C0),
	PINMUX_SINGLE(VI0_D1_B1_C1),
	PINMUX_SINGLE(VI0_D2_B2_C2),
	PINMUX_SINGLE(VI0_D3_B3_C3),
	PINMUX_SINGLE(VI0_D4_B4_C4),
	PINMUX_SINGLE(VI0_D5_B5_C5),
	PINMUX_SINGLE(VI0_D6_B6_C6),
	PINMUX_SINGLE(VI0_D7_B7_C7),
	PINMUX_SINGLE(VI0_D8_G0_Y0),
	PINMUX_SINGLE(VI0_D9_G1_Y1),
	PINMUX_SINGLE(VI0_D10_G2_Y2),
	PINMUX_SINGLE(VI0_D11_G3_Y3),
	PINMUX_SINGLE(VI0_FIELD),
	PINMUX_SINGLE(VI1_CLK),
	PINMUX_SINGLE(VI1_CLKENB),
	PINMUX_SINGLE(VI1_HSYNC_N),
	PINMUX_SINGLE(VI1_VSYNC_N),
	PINMUX_SINGLE(VI1_D0_B0_C0),
	PINMUX_SINGLE(VI1_D1_B1_C1),
	PINMUX_SINGLE(VI1_D2_B2_C2),
	PINMUX_SINGLE(VI1_D3_B3_C3),
	PINMUX_SINGLE(VI1_D4_B4_C4),
	PINMUX_SINGLE(VI1_D5_B5_C5),
	PINMUX_SINGLE(VI1_D6_B6_C6),
	PINMUX_SINGLE(VI1_D7_B7_C7),
	PINMUX_SINGLE(VI1_D8_G0_Y0),
	PINMUX_SINGLE(VI1_D9_G1_Y1),
	PINMUX_SINGLE(VI1_D10_G2_Y2),
	PINMUX_SINGLE(VI1_D11_G3_Y3),
	PINMUX_SINGLE(VI1_FIELD),
	PINMUX_SINGLE(VI3_D10_Y2),
	PINMUX_SINGLE(VI3_FIELD),
	PINMUX_SINGLE(VI4_CLK),
	PINMUX_SINGLE(VI5_CLK),
	PINMUX_SINGLE(VI5_D9_Y1),
	PINMUX_SINGLE(VI5_D10_Y2),
	PINMUX_SINGLE(VI5_D11_Y3),
	PINMUX_SINGLE(VI5_FIELD),
	PINMUX_SINGLE(HRTS0_N),
	PINMUX_SINGLE(HCTS1_N),
	PINMUX_SINGLE(SCK0),
	PINMUX_SINGLE(CTS0_N),
	PINMUX_SINGLE(RTS0_N),
	PINMUX_SINGLE(TX0),
	PINMUX_SINGLE(RX0),
	PINMUX_SINGLE(SCK1),
	PINMUX_SINGLE(CTS1_N),
	PINMUX_SINGLE(RTS1_N),
	PINMUX_SINGLE(TX1),
	PINMUX_SINGLE(RX1),
	PINMUX_SINGLE(SCIF_CLK),
	PINMUX_SINGLE(CAN0_TX),
	PINMUX_SINGLE(CAN0_RX),
	PINMUX_SINGLE(CAN_CLK),
	PINMUX_SINGLE(CAN1_TX),
	PINMUX_SINGLE(CAN1_RX),
	PINMUX_SINGLE(SD0_CLK),
	PINMUX_SINGLE(SD0_CMD),
	PINMUX_SINGLE(SD0_DAT0),
	PINMUX_SINGLE(SD0_DAT1),
	PINMUX_SINGLE(SD0_DAT2),
	PINMUX_SINGLE(SD0_DAT3),
	PINMUX_SINGLE(SD0_CD),
	PINMUX_SINGLE(SD0_WP),
	PINMUX_SINGLE(ADICLK),
	PINMUX_SINGLE(ADICS_SAMP),
	PINMUX_SINGLE(ADIDATA),
	PINMUX_SINGLE(ADICHS0),
	PINMUX_SINGLE(ADICHS1),
	PINMUX_SINGLE(ADICHS2),
	PINMUX_SINGLE(AVS1),
	PINMUX_SINGLE(AVS2),

	/* IPSR0 */
	PINMUX_IPSR_GPSR(IP0_0, DU0_DR0_DATA0),
	PINMUX_IPSR_GPSR(IP0_1, DU0_DR1_DATA1),
	PINMUX_IPSR_GPSR(IP0_2, DU0_DR2_Y4_DATA2),
	PINMUX_IPSR_GPSR(IP0_3, DU0_DR3_Y5_DATA3),
	PINMUX_IPSR_GPSR(IP0_4, DU0_DR4_Y6_DATA4),
	PINMUX_IPSR_GPSR(IP0_5, DU0_DR5_Y7_DATA5),
	PINMUX_IPSR_GPSR(IP0_6, DU0_DR6_Y8_DATA6),
	PINMUX_IPSR_GPSR(IP0_7, DU0_DR7_Y9_DATA7),
	PINMUX_IPSR_GPSR(IP0_8, DU0_DG0_DATA8),
	PINMUX_IPSR_GPSR(IP0_9, DU0_DG1_DATA9),
	PINMUX_IPSR_GPSR(IP0_10, DU0_DG2_C6_DATA10),
	PINMUX_IPSR_GPSR(IP0_11, DU0_DG3_C7_DATA11),
	PINMUX_IPSR_GPSR(IP0_12, DU0_DG4_Y0_DATA12),
	PINMUX_IPSR_GPSR(IP0_13, DU0_DG5_Y1_DATA13),
	PINMUX_IPSR_GPSR(IP0_14, DU0_DG6_Y2_DATA14),
	PINMUX_IPSR_GPSR(IP0_15, DU0_DG7_Y3_DATA15),
	PINMUX_IPSR_GPSR(IP0_16, DU0_DB0),
	PINMUX_IPSR_GPSR(IP0_17, DU0_DB1),
	PINMUX_IPSR_GPSR(IP0_18, DU0_DB2_C0),
	PINMUX_IPSR_GPSR(IP0_19, DU0_DB3_C1),
	PINMUX_IPSR_GPSR(IP0_20, DU0_DB4_C2),
	PINMUX_IPSR_GPSR(IP0_21, DU0_DB5_C3),
	PINMUX_IPSR_GPSR(IP0_22, DU0_DB6_C4),
	PINMUX_IPSR_GPSR(IP0_23, DU0_DB7_C5),

	/* IPSR1 */
	PINMUX_IPSR_GPSR(IP1_0, DU0_EXHSYNC_DU0_HSYNC),
	PINMUX_IPSR_GPSR(IP1_1, DU0_EXVSYNC_DU0_VSYNC),
	PINMUX_IPSR_GPSR(IP1_2, DU0_EXODDF_DU0_ODDF_DISP_CDE),
	PINMUX_IPSR_GPSR(IP1_3, DU0_DISP),
	PINMUX_IPSR_GPSR(IP1_4, DU0_CDE),
	PINMUX_IPSR_GPSR(IP1_5, DU1_DR2_Y4_DATA0),
	PINMUX_IPSR_GPSR(IP1_6, DU1_DR3_Y5_DATA1),
	PINMUX_IPSR_GPSR(IP1_7, DU1_DR4_Y6_DATA2),
	PINMUX_IPSR_GPSR(IP1_8, DU1_DR5_Y7_DATA3),
	PINMUX_IPSR_GPSR(IP1_9, DU1_DR6_DATA4),
	PINMUX_IPSR_GPSR(IP1_10, DU1_DR7_DATA5),
	PINMUX_IPSR_GPSR(IP1_11, DU1_DG2_C6_DATA6),
	PINMUX_IPSR_GPSR(IP1_12, DU1_DG3_C7_DATA7),
	PINMUX_IPSR_GPSR(IP1_13, DU1_DG4_Y0_DATA8),
	PINMUX_IPSR_GPSR(IP1_14, DU1_DG5_Y1_DATA9),
	PINMUX_IPSR_GPSR(IP1_15, DU1_DG6_Y2_DATA10),
	PINMUX_IPSR_GPSR(IP1_16, DU1_DG7_Y3_DATA11),
	PINMUX_IPSR_GPSR(IP1_17, A20),
	PINMUX_IPSR_GPSR(IP1_17, MOSI_IO0),
	PINMUX_IPSR_GPSR(IP1_18, A21),
	PINMUX_IPSR_GPSR(IP1_18, MISO_IO1),
	PINMUX_IPSR_GPSR(IP1_19, A22),
	PINMUX_IPSR_GPSR(IP1_19, IO2),
	PINMUX_IPSR_GPSR(IP1_20, A23),
	PINMUX_IPSR_GPSR(IP1_20, IO3),
	PINMUX_IPSR_GPSR(IP1_21, A24),
	PINMUX_IPSR_GPSR(IP1_21, SPCLK),
	PINMUX_IPSR_GPSR(IP1_22, A25),
	PINMUX_IPSR_GPSR(IP1_22, SSL),

	/* IPSR2 */
	PINMUX_IPSR_GPSR(IP2_0, VI2_CLK),
	PINMUX_IPSR_GPSR(IP2_0, AVB_RX_CLK),
	PINMUX_IPSR_GPSR(IP2_1, VI2_CLKENB),
	PINMUX_IPSR_GPSR(IP2_1, AVB_RX_DV),
	PINMUX_IPSR_GPSR(IP2_2, VI2_HSYNC_N),
	PINMUX_IPSR_GPSR(IP2_2, AVB_RXD0),
	PINMUX_IPSR_GPSR(IP2_3, VI2_VSYNC_N),
	PINMUX_IPSR_GPSR(IP2_3, AVB_RXD1),
	PINMUX_IPSR_GPSR(IP2_4, VI2_D0_C0),
	PINMUX_IPSR_GPSR(IP2_4, AVB_RXD2),
	PINMUX_IPSR_GPSR(IP2_5, VI2_D1_C1),
	PINMUX_IPSR_GPSR(IP2_5, AVB_RXD3),
	PINMUX_IPSR_GPSR(IP2_6, VI2_D2_C2),
	PINMUX_IPSR_GPSR(IP2_6, AVB_RXD4),
	PINMUX_IPSR_GPSR(IP2_7, VI2_D3_C3),
	PINMUX_IPSR_GPSR(IP2_7, AVB_RXD5),
	PINMUX_IPSR_GPSR(IP2_8, VI2_D4_C4),
	PINMUX_IPSR_GPSR(IP2_8, AVB_RXD6),
	PINMUX_IPSR_GPSR(IP2_9, VI2_D5_C5),
	PINMUX_IPSR_GPSR(IP2_9, AVB_RXD7),
	PINMUX_IPSR_GPSR(IP2_10, VI2_D6_C6),
	PINMUX_IPSR_GPSR(IP2_10, AVB_RX_ER),
	PINMUX_IPSR_GPSR(IP2_11, VI2_D7_C7),
	PINMUX_IPSR_GPSR(IP2_11, AVB_COL),
	PINMUX_IPSR_GPSR(IP2_12, VI2_D8_Y0),
	PINMUX_IPSR_GPSR(IP2_12, AVB_TXD3),
	PINMUX_IPSR_GPSR(IP2_13, VI2_D9_Y1),
	PINMUX_IPSR_GPSR(IP2_13, AVB_TX_EN),
	PINMUX_IPSR_GPSR(IP2_14, VI2_D10_Y2),
	PINMUX_IPSR_GPSR(IP2_14, AVB_TXD0),
	PINMUX_IPSR_GPSR(IP2_15, VI2_D11_Y3),
	PINMUX_IPSR_GPSR(IP2_15, AVB_TXD1),
	PINMUX_IPSR_GPSR(IP2_16, VI2_FIELD),
	PINMUX_IPSR_GPSR(IP2_16, AVB_TXD2),

	/* IPSR3 */
	PINMUX_IPSR_GPSR(IP3_0, VI3_CLK),
	PINMUX_IPSR_GPSR(IP3_0, AVB_TX_CLK),
	PINMUX_IPSR_GPSR(IP3_1, VI3_CLKENB),
	PINMUX_IPSR_GPSR(IP3_1, AVB_TXD4),
	PINMUX_IPSR_GPSR(IP3_2, VI3_HSYNC_N),
	PINMUX_IPSR_GPSR(IP3_2, AVB_TXD5),
	PINMUX_IPSR_GPSR(IP3_3, VI3_VSYNC_N),
	PINMUX_IPSR_GPSR(IP3_3, AVB_TXD6),
	PINMUX_IPSR_GPSR(IP3_4, VI3_D0_C0),
	PINMUX_IPSR_GPSR(IP3_4, AVB_TXD7),
	PINMUX_IPSR_GPSR(IP3_5, VI3_D1_C1),
	PINMUX_IPSR_GPSR(IP3_5, AVB_TX_ER),
	PINMUX_IPSR_GPSR(IP3_6, VI3_D2_C2),
	PINMUX_IPSR_GPSR(IP3_6, AVB_GTX_CLK),
	PINMUX_IPSR_GPSR(IP3_7, VI3_D3_C3),
	PINMUX_IPSR_GPSR(IP3_7, AVB_MDC),
	PINMUX_IPSR_GPSR(IP3_8, VI3_D4_C4),
	PINMUX_IPSR_GPSR(IP3_8, AVB_MDIO),
	PINMUX_IPSR_GPSR(IP3_9, VI3_D5_C5),
	PINMUX_IPSR_GPSR(IP3_9, AVB_LINK),
	PINMUX_IPSR_GPSR(IP3_10, VI3_D6_C6),
	PINMUX_IPSR_GPSR(IP3_10, AVB_MAGIC),
	PINMUX_IPSR_GPSR(IP3_11, VI3_D7_C7),
	PINMUX_IPSR_GPSR(IP3_11, AVB_PHY_INT),
	PINMUX_IPSR_GPSR(IP3_12, VI3_D8_Y0),
	PINMUX_IPSR_GPSR(IP3_12, AVB_CRS),
	PINMUX_IPSR_GPSR(IP3_13, VI3_D9_Y1),
	PINMUX_IPSR_GPSR(IP3_13, AVB_GTXREFCLK),
	PINMUX_IPSR_GPSR(IP3_14, VI3_D11_Y3),
	PINMUX_IPSR_GPSR(IP3_14, AVB_AVTP_MATCH),

	/* IPSR4 */
	PINMUX_IPSR_GPSR(IP4_0, VI4_CLKENB),
	PINMUX_IPSR_GPSR(IP4_0, VI0_D12_G4_Y4),
	PINMUX_IPSR_GPSR(IP4_1, VI4_HSYNC_N),
	PINMUX_IPSR_GPSR(IP4_1, VI0_D13_G5_Y5),
	PINMUX_IPSR_GPSR(IP4_3_2, VI4_VSYNC_N),
	PINMUX_IPSR_GPSR(IP4_3_2, VI0_D14_G6_Y6),
	PINMUX_IPSR_GPSR(IP4_4, VI4_D0_C0),
	PINMUX_IPSR_GPSR(IP4_4, VI0_D15_G7_Y7),
	PINMUX_IPSR_GPSR(IP4_6_5, VI4_D1_C1),
	PINMUX_IPSR_GPSR(IP4_6_5, VI0_D16_R0),
	PINMUX_IPSR_MSEL(IP4_6_5, VI1_D12_G4_Y4, SEL_VI1_0),
	PINMUX_IPSR_GPSR(IP4_8_7, VI4_D2_C2),
	PINMUX_IPSR_GPSR(IP4_8_7, VI0_D17_R1),
	PINMUX_IPSR_MSEL(IP4_8_7, VI1_D13_G5_Y5, SEL_VI1_0),
	PINMUX_IPSR_GPSR(IP4_10_9, VI4_D3_C3),
	PINMUX_IPSR_GPSR(IP4_10_9, VI0_D18_R2),
	PINMUX_IPSR_MSEL(IP4_10_9, VI1_D14_G6_Y6, SEL_VI1_0),
	PINMUX_IPSR_GPSR(IP4_12_11, VI4_D4_C4),
	PINMUX_IPSR_GPSR(IP4_12_11, VI0_D19_R3),
	PINMUX_IPSR_MSEL(IP4_12_11, VI1_D15_G7_Y7, SEL_VI1_0),
	PINMUX_IPSR_GPSR(IP4_14_13, VI4_D5_C5),
	PINMUX_IPSR_GPSR(IP4_14_13, VI0_D20_R4),
	PINMUX_IPSR_GPSR(IP4_14_13, VI2_D12_Y4),
	PINMUX_IPSR_GPSR(IP4_16_15, VI4_D6_C6),
	PINMUX_IPSR_GPSR(IP4_16_15, VI0_D21_R5),
	PINMUX_IPSR_GPSR(IP4_16_15, VI2_D13_Y5),
	PINMUX_IPSR_GPSR(IP4_18_17, VI4_D7_C7),
	PINMUX_IPSR_GPSR(IP4_18_17, VI0_D22_R6),
	PINMUX_IPSR_GPSR(IP4_18_17, VI2_D14_Y6),
	PINMUX_IPSR_GPSR(IP4_20_19, VI4_D8_Y0),
	PINMUX_IPSR_GPSR(IP4_20_19, VI0_D23_R7),
	PINMUX_IPSR_GPSR(IP4_20_19, VI2_D15_Y7),
	PINMUX_IPSR_GPSR(IP4_21, VI4_D9_Y1),
	PINMUX_IPSR_GPSR(IP4_21, VI3_D12_Y4),
	PINMUX_IPSR_GPSR(IP4_22, VI4_D10_Y2),
	PINMUX_IPSR_GPSR(IP4_22, VI3_D13_Y5),
	PINMUX_IPSR_GPSR(IP4_23, VI4_D11_Y3),
	PINMUX_IPSR_GPSR(IP4_23, VI3_D14_Y6),
	PINMUX_IPSR_GPSR(IP4_24, VI4_FIELD),
	PINMUX_IPSR_GPSR(IP4_24, VI3_D15_Y7),

	/* IPSR5 */
	PINMUX_IPSR_GPSR(IP5_0, VI5_CLKENB),
	PINMUX_IPSR_MSEL(IP5_0, VI1_D12_G4_Y4_B, SEL_VI1_1),
	PINMUX_IPSR_GPSR(IP5_1, VI5_HSYNC_N),
	PINMUX_IPSR_MSEL(IP5_1, VI1_D13_G5_Y5_B, SEL_VI1_1),
	PINMUX_IPSR_GPSR(IP5_2, VI5_VSYNC_N),
	PINMUX_IPSR_MSEL(IP5_2, VI1_D14_G6_Y6_B, SEL_VI1_1),
	PINMUX_IPSR_GPSR(IP5_3, VI5_D0_C0),
	PINMUX_IPSR_MSEL(IP5_3, VI1_D15_G7_Y7_B, SEL_VI1_1),
	PINMUX_IPSR_GPSR(IP5_4, VI5_D1_C1),
	PINMUX_IPSR_GPSR(IP5_4, VI1_D16_R0),
	PINMUX_IPSR_GPSR(IP5_5, VI5_D2_C2),
	PINMUX_IPSR_GPSR(IP5_5, VI1_D17_R1),
	PINMUX_IPSR_GPSR(IP5_6, VI5_D3_C3),
	PINMUX_IPSR_GPSR(IP5_6, VI1_D18_R2),
	PINMUX_IPSR_GPSR(IP5_7, VI5_D4_C4),
	PINMUX_IPSR_GPSR(IP5_7, VI1_D19_R3),
	PINMUX_IPSR_GPSR(IP5_8, VI5_D5_C5),
	PINMUX_IPSR_GPSR(IP5_8, VI1_D20_R4),
	PINMUX_IPSR_GPSR(IP5_9, VI5_D6_C6),
	PINMUX_IPSR_GPSR(IP5_9, VI1_D21_R5),
	PINMUX_IPSR_GPSR(IP5_10, VI5_D7_C7),
	PINMUX_IPSR_GPSR(IP5_10, VI1_D22_R6),
	PINMUX_IPSR_GPSR(IP5_11, VI5_D8_Y0),
	PINMUX_IPSR_GPSR(IP5_11, VI1_D23_R7),

	/* IPSR6 */
	PINMUX_IPSR_GPSR(IP6_0, MSIOF0_SCK),
	PINMUX_IPSR_GPSR(IP6_0, HSCK0),
	PINMUX_IPSR_GPSR(IP6_1, MSIOF0_SYNC),
	PINMUX_IPSR_GPSR(IP6_1, HCTS0_N),
	PINMUX_IPSR_GPSR(IP6_2, MSIOF0_TXD),
	PINMUX_IPSR_GPSR(IP6_2, HTX0),
	PINMUX_IPSR_GPSR(IP6_3, MSIOF0_RXD),
	PINMUX_IPSR_GPSR(IP6_3, HRX0),
	PINMUX_IPSR_GPSR(IP6_4, MSIOF1_SCK),
	PINMUX_IPSR_GPSR(IP6_4, HSCK1),
	PINMUX_IPSR_GPSR(IP6_5, MSIOF1_SYNC),
	PINMUX_IPSR_GPSR(IP6_5, HRTS1_N),
	PINMUX_IPSR_GPSR(IP6_6, MSIOF1_TXD),
	PINMUX_IPSR_GPSR(IP6_6, HTX1),
	PINMUX_IPSR_GPSR(IP6_7, MSIOF1_RXD),
	PINMUX_IPSR_GPSR(IP6_7, HRX1),
	PINMUX_IPSR_GPSR(IP6_9_8, DRACK0),
	PINMUX_IPSR_GPSR(IP6_9_8, SCK2),
	PINMUX_IPSR_GPSR(IP6_11_10, DACK0),
	PINMUX_IPSR_GPSR(IP6_11_10, TX2),
	PINMUX_IPSR_GPSR(IP6_13_12, DREQ0_N),
	PINMUX_IPSR_GPSR(IP6_13_12, RX2),
	PINMUX_IPSR_GPSR(IP6_15_14, DACK1),
	PINMUX_IPSR_GPSR(IP6_15_14, SCK3),
	PINMUX_IPSR_GPSR(IP6_16, TX3),
	PINMUX_IPSR_GPSR(IP6_18_17, DREQ1_N),
	PINMUX_IPSR_GPSR(IP6_18_17, RX3),

	/* IPSR7 */
	PINMUX_IPSR_GPSR(IP7_1_0, PWM0),
	PINMUX_IPSR_GPSR(IP7_1_0, TCLK1),
	PINMUX_IPSR_GPSR(IP7_1_0, FSO_CFE_0),
	PINMUX_IPSR_GPSR(IP7_3_2, PWM1),
	PINMUX_IPSR_GPSR(IP7_3_2, TCLK2),
	PINMUX_IPSR_GPSR(IP7_3_2, FSO_CFE_1),
	PINMUX_IPSR_GPSR(IP7_5_4, PWM2),
	PINMUX_IPSR_GPSR(IP7_5_4, TCLK3),
	PINMUX_IPSR_GPSR(IP7_5_4, FSO_TOE),
	PINMUX_IPSR_GPSR(IP7_6, PWM3),
	PINMUX_IPSR_GPSR(IP7_7, PWM4),
	PINMUX_IPSR_GPSR(IP7_9_8, SSI_SCK34),
	PINMUX_IPSR_GPSR(IP7_9_8, TPU0TO0),
	PINMUX_IPSR_GPSR(IP7_11_10, SSI_WS34),
	PINMUX_IPSR_GPSR(IP7_11_10, TPU0TO1),
	PINMUX_IPSR_GPSR(IP7_13_12, SSI_SDATA3),
	PINMUX_IPSR_GPSR(IP7_13_12, TPU0TO2),
	PINMUX_IPSR_GPSR(IP7_15_14, SSI_SCK4),
	PINMUX_IPSR_GPSR(IP7_15_14, TPU0TO3),
	PINMUX_IPSR_GPSR(IP7_16, SSI_WS4),
	PINMUX_IPSR_GPSR(IP7_17, SSI_SDATA4),
	PINMUX_IPSR_GPSR(IP7_18, AUDIO_CLKOUT),
	PINMUX_IPSR_GPSR(IP7_19, AUDIO_CLKA),
	PINMUX_IPSR_GPSR(IP7_20, AUDIO_CLKB),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	PINMUX_GPIO_GP_ALL(),
};

/* - AVB -------------------------------------------------------------------- */
static const unsigned int avb_link_pins[] = {
	RCAR_GP_PIN(7, 9),
};
static const unsigned int avb_link_mux[] = {
	AVB_LINK_MARK,
};
static const unsigned int avb_magic_pins[] = {
	RCAR_GP_PIN(7, 10),
};
static const unsigned int avb_magic_mux[] = {
	AVB_MAGIC_MARK,
};
static const unsigned int avb_phy_int_pins[] = {
	RCAR_GP_PIN(7, 11),
};
static const unsigned int avb_phy_int_mux[] = {
	AVB_PHY_INT_MARK,
};
static const unsigned int avb_mdio_pins[] = {
	RCAR_GP_PIN(7, 7), RCAR_GP_PIN(7, 8),
};
static const unsigned int avb_mdio_mux[] = {
	AVB_MDC_MARK, AVB_MDIO_MARK,
};
static const unsigned int avb_mii_pins[] = {
	RCAR_GP_PIN(6, 14), RCAR_GP_PIN(6, 15), RCAR_GP_PIN(6, 16),
	RCAR_GP_PIN(6, 12),

	RCAR_GP_PIN(6, 2),  RCAR_GP_PIN(6, 3),  RCAR_GP_PIN(6, 4),
	RCAR_GP_PIN(6, 5),

	RCAR_GP_PIN(6, 10), RCAR_GP_PIN(6, 0),  RCAR_GP_PIN(6, 1),
	RCAR_GP_PIN(7, 12), RCAR_GP_PIN(6, 13), RCAR_GP_PIN(7, 5),
	RCAR_GP_PIN(7, 0),  RCAR_GP_PIN(6, 11),
};
static const unsigned int avb_mii_mux[] = {
	AVB_TXD0_MARK, AVB_TXD1_MARK, AVB_TXD2_MARK,
	AVB_TXD3_MARK,

	AVB_RXD0_MARK, AVB_RXD1_MARK, AVB_RXD2_MARK,
	AVB_RXD3_MARK,

	AVB_RX_ER_MARK, AVB_RX_CLK_MARK, AVB_RX_DV_MARK,
	AVB_CRS_MARK, AVB_TX_EN_MARK, AVB_TX_ER_MARK,
	AVB_TX_CLK_MARK, AVB_COL_MARK,
};
static const unsigned int avb_gmii_pins[] = {
	RCAR_GP_PIN(6, 14), RCAR_GP_PIN(6, 15), RCAR_GP_PIN(6, 16),
	RCAR_GP_PIN(6, 12), RCAR_GP_PIN(7, 1),  RCAR_GP_PIN(7, 2),
	RCAR_GP_PIN(7, 3),  RCAR_GP_PIN(7, 4),

	RCAR_GP_PIN(6, 2),  RCAR_GP_PIN(6, 3), RCAR_GP_PIN(6, 4),
	RCAR_GP_PIN(6, 5),  RCAR_GP_PIN(6, 6), RCAR_GP_PIN(6, 7),
	RCAR_GP_PIN(6, 8),  RCAR_GP_PIN(6, 9),

	RCAR_GP_PIN(6, 10), RCAR_GP_PIN(6, 0), RCAR_GP_PIN(6, 1),
	RCAR_GP_PIN(7, 12), RCAR_GP_PIN(7, 6), RCAR_GP_PIN(7, 13),
	RCAR_GP_PIN(6, 13), RCAR_GP_PIN(7, 5), RCAR_GP_PIN(7, 0),
	RCAR_GP_PIN(6, 11),
};
static const unsigned int avb_gmii_mux[] = {
	AVB_TXD0_MARK, AVB_TXD1_MARK, AVB_TXD2_MARK,
	AVB_TXD3_MARK, AVB_TXD4_MARK, AVB_TXD5_MARK,
	AVB_TXD6_MARK, AVB_TXD7_MARK,

	AVB_RXD0_MARK, AVB_RXD1_MARK, AVB_RXD2_MARK,
	AVB_RXD3_MARK, AVB_RXD4_MARK, AVB_RXD5_MARK,
	AVB_RXD6_MARK, AVB_RXD7_MARK,

	AVB_RX_ER_MARK, AVB_RX_CLK_MARK, AVB_RX_DV_MARK,
	AVB_CRS_MARK, AVB_GTX_CLK_MARK, AVB_GTXREFCLK_MARK,
	AVB_TX_EN_MARK, AVB_TX_ER_MARK, AVB_TX_CLK_MARK,
	AVB_COL_MARK,
};
static const unsigned int avb_avtp_match_pins[] = {
	RCAR_GP_PIN(7, 15),
};
static const unsigned int avb_avtp_match_mux[] = {
	AVB_AVTP_MATCH_MARK,
};
/* - CAN -------------------------------------------------------------------- */
static const unsigned int can0_data_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(10, 27), RCAR_GP_PIN(10, 28),
};
static const unsigned int can0_data_mux[] = {
	CAN0_TX_MARK, CAN0_RX_MARK,
};
static const unsigned int can1_data_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(10, 30), RCAR_GP_PIN(10, 31),
};
static const unsigned int can1_data_mux[] = {
	CAN1_TX_MARK, CAN1_RX_MARK,
};
static const unsigned int can_clk_pins[] = {
	/* CAN_CLK */
	RCAR_GP_PIN(10, 29),
};
static const unsigned int can_clk_mux[] = {
	CAN_CLK_MARK,
};
/* - DU --------------------------------------------------------------------- */
static const unsigned int du0_rgb666_pins[] = {
	/* R[7:2], G[7:2], B[7:2] */
	RCAR_GP_PIN(0, 7), RCAR_GP_PIN(0, 6), RCAR_GP_PIN(0, 5),
	RCAR_GP_PIN(0, 4), RCAR_GP_PIN(0, 3), RCAR_GP_PIN(0, 2),
	RCAR_GP_PIN(0, 15), RCAR_GP_PIN(0, 14), RCAR_GP_PIN(0, 13),
	RCAR_GP_PIN(0, 12), RCAR_GP_PIN(0, 11), RCAR_GP_PIN(0, 10),
	RCAR_GP_PIN(0, 23), RCAR_GP_PIN(0, 22), RCAR_GP_PIN(0, 21),
	RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 19), RCAR_GP_PIN(0, 18),
};
static const unsigned int du0_rgb666_mux[] = {
	DU0_DR7_Y9_DATA7_MARK, DU0_DR6_Y8_DATA6_MARK, DU0_DR5_Y7_DATA5_MARK,
	DU0_DR4_Y6_DATA4_MARK, DU0_DR3_Y5_DATA3_MARK, DU0_DR2_Y4_DATA2_MARK,
	DU0_DG7_Y3_DATA15_MARK, DU0_DG6_Y2_DATA14_MARK, DU0_DG5_Y1_DATA13_MARK,
	DU0_DG4_Y0_DATA12_MARK, DU0_DG3_C7_DATA11_MARK, DU0_DG2_C6_DATA10_MARK,
	DU0_DB7_C5_MARK, DU0_DB6_C4_MARK, DU0_DB5_C3_MARK,
	DU0_DB4_C2_MARK, DU0_DB3_C1_MARK, DU0_DB2_C0_MARK,
};
static const unsigned int du0_rgb888_pins[] = {
	/* R[7:0], G[7:0], B[7:0] */
	RCAR_GP_PIN(0, 7), RCAR_GP_PIN(0, 6), RCAR_GP_PIN(0, 5),
	RCAR_GP_PIN(0, 4), RCAR_GP_PIN(0, 3), RCAR_GP_PIN(0, 2),
	RCAR_GP_PIN(0, 1), RCAR_GP_PIN(0, 0),
	RCAR_GP_PIN(0, 15), RCAR_GP_PIN(0, 14), RCAR_GP_PIN(0, 13),
	RCAR_GP_PIN(0, 12), RCAR_GP_PIN(0, 11), RCAR_GP_PIN(0, 10),
	RCAR_GP_PIN(0, 9), RCAR_GP_PIN(0, 8),
	RCAR_GP_PIN(0, 23), RCAR_GP_PIN(0, 22), RCAR_GP_PIN(0, 21),
	RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 19), RCAR_GP_PIN(0, 18),
	RCAR_GP_PIN(0, 17), RCAR_GP_PIN(0, 16),
};
static const unsigned int du0_rgb888_mux[] = {
	DU0_DR7_Y9_DATA7_MARK, DU0_DR6_Y8_DATA6_MARK, DU0_DR5_Y7_DATA5_MARK,
	DU0_DR4_Y6_DATA4_MARK, DU0_DR3_Y5_DATA3_MARK, DU0_DR2_Y4_DATA2_MARK,
	DU0_DR1_DATA1_MARK, DU0_DR0_DATA0_MARK,
	DU0_DG7_Y3_DATA15_MARK, DU0_DG6_Y2_DATA14_MARK, DU0_DG5_Y1_DATA13_MARK,
	DU0_DG4_Y0_DATA12_MARK, DU0_DG3_C7_DATA11_MARK, DU0_DG2_C6_DATA10_MARK,
	DU0_DG1_DATA9_MARK, DU0_DG0_DATA8_MARK,
	DU0_DB7_C5_MARK, DU0_DB6_C4_MARK, DU0_DB5_C3_MARK,
	DU0_DB4_C2_MARK, DU0_DB3_C1_MARK, DU0_DB2_C0_MARK,
	DU0_DB1_MARK, DU0_DB0_MARK,
};
static const unsigned int du0_sync_pins[] = {
	/* EXVSYNC/VSYNC, EXHSYNC/HSYNC */
	RCAR_GP_PIN(0, 25), RCAR_GP_PIN(0, 24),
};
static const unsigned int du0_sync_mux[] = {
	DU0_EXVSYNC_DU0_VSYNC_MARK, DU0_EXHSYNC_DU0_HSYNC_MARK,
};
static const unsigned int du0_oddf_pins[] = {
	/* EXODDF/ODDF/DISP/CDE */
	RCAR_GP_PIN(0, 26),
};
static const unsigned int du0_oddf_mux[] = {
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK
};
static const unsigned int du0_disp_pins[] = {
	/* DISP */
	RCAR_GP_PIN(0, 27),
};
static const unsigned int du0_disp_mux[] = {
	DU0_DISP_MARK,
};
static const unsigned int du0_cde_pins[] = {
	/* CDE */
	RCAR_GP_PIN(0, 28),
};
static const unsigned int du0_cde_mux[] = {
	DU0_CDE_MARK,
};
static const unsigned int du1_rgb666_pins[] = {
	/* R[7:2], G[7:2], B[7:2] */
	RCAR_GP_PIN(1, 5), RCAR_GP_PIN(1, 4), RCAR_GP_PIN(1, 3),
	RCAR_GP_PIN(1, 2), RCAR_GP_PIN(1, 1), RCAR_GP_PIN(1, 0),
	RCAR_GP_PIN(1, 11), RCAR_GP_PIN(1, 10), RCAR_GP_PIN(1, 9),
	RCAR_GP_PIN(1, 8), RCAR_GP_PIN(1, 7), RCAR_GP_PIN(1, 6),
	RCAR_GP_PIN(1, 17), RCAR_GP_PIN(1, 16), RCAR_GP_PIN(1, 15),
	RCAR_GP_PIN(1, 14), RCAR_GP_PIN(1, 13), RCAR_GP_PIN(1, 12),
};
static const unsigned int du1_rgb666_mux[] = {
	DU1_DR7_DATA5_MARK, DU1_DR6_DATA4_MARK, DU1_DR5_Y7_DATA3_MARK,
	DU1_DR4_Y6_DATA2_MARK, DU1_DR3_Y5_DATA1_MARK, DU1_DR2_Y4_DATA0_MARK,
	DU1_DG7_Y3_DATA11_MARK, DU1_DG6_Y2_DATA10_MARK, DU1_DG5_Y1_DATA9_MARK,
	DU1_DG4_Y0_DATA8_MARK, DU1_DG3_C7_DATA7_MARK, DU1_DG2_C6_DATA6_MARK,
	DU1_DB7_C5_MARK, DU1_DB6_C4_MARK, DU1_DB5_C3_DATA15_MARK,
	DU1_DB4_C2_DATA14_MARK, DU1_DB3_C1_DATA13_MARK, DU1_DB2_C0_DATA12_MARK,
};
static const unsigned int du1_sync_pins[] = {
	/* EXVSYNC/VSYNC, EXHSYNC/HSYNC */
	RCAR_GP_PIN(1, 19), RCAR_GP_PIN(1, 18),
};
static const unsigned int du1_sync_mux[] = {
	DU1_EXVSYNC_DU1_VSYNC_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK,
};
static const unsigned int du1_oddf_pins[] = {
	/* EXODDF/ODDF/DISP/CDE */
	RCAR_GP_PIN(1, 20),
};
static const unsigned int du1_oddf_mux[] = {
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK
};
static const unsigned int du1_disp_pins[] = {
	/* DISP */
	RCAR_GP_PIN(1, 21),
};
static const unsigned int du1_disp_mux[] = {
	DU1_DISP_MARK,
};
static const unsigned int du1_cde_pins[] = {
	/* CDE */
	RCAR_GP_PIN(1, 22),
};
static const unsigned int du1_cde_mux[] = {
	DU1_CDE_MARK,
};
/* - INTC ------------------------------------------------------------------- */
static const unsigned int intc_irq0_pins[] = {
	/* IRQ0 */
	RCAR_GP_PIN(3, 19),
};
static const unsigned int intc_irq0_mux[] = {
	IRQ0_MARK,
};
static const unsigned int intc_irq1_pins[] = {
	/* IRQ1 */
	RCAR_GP_PIN(3, 20),
};
static const unsigned int intc_irq1_mux[] = {
	IRQ1_MARK,
};
static const unsigned int intc_irq2_pins[] = {
	/* IRQ2 */
	RCAR_GP_PIN(3, 21),
};
static const unsigned int intc_irq2_mux[] = {
	IRQ2_MARK,
};
static const unsigned int intc_irq3_pins[] = {
	/* IRQ3 */
	RCAR_GP_PIN(3, 22),
};
static const unsigned int intc_irq3_mux[] = {
	IRQ3_MARK,
};
/* - LBSC ------------------------------------------------------------------- */
static const unsigned int lbsc_cs0_pins[] = {
	/* CS0# */
	RCAR_GP_PIN(3, 27),
};
static const unsigned int lbsc_cs0_mux[] = {
	CS0_N_MARK,
};
static const unsigned int lbsc_cs1_pins[] = {
	/* CS1#_A26 */
	RCAR_GP_PIN(3, 6),
};
static const unsigned int lbsc_cs1_mux[] = {
	CS1_N_A26_MARK,
};
static const unsigned int lbsc_ex_cs0_pins[] = {
	/* EX_CS0# */
	RCAR_GP_PIN(3, 7),
};
static const unsigned int lbsc_ex_cs0_mux[] = {
	EX_CS0_N_MARK,
};
static const unsigned int lbsc_ex_cs1_pins[] = {
	/* EX_CS1# */
	RCAR_GP_PIN(3, 8),
};
static const unsigned int lbsc_ex_cs1_mux[] = {
	EX_CS1_N_MARK,
};
static const unsigned int lbsc_ex_cs2_pins[] = {
	/* EX_CS2# */
	RCAR_GP_PIN(3, 9),
};
static const unsigned int lbsc_ex_cs2_mux[] = {
	EX_CS2_N_MARK,
};
static const unsigned int lbsc_ex_cs3_pins[] = {
	/* EX_CS3# */
	RCAR_GP_PIN(3, 10),
};
static const unsigned int lbsc_ex_cs3_mux[] = {
	EX_CS3_N_MARK,
};
static const unsigned int lbsc_ex_cs4_pins[] = {
	/* EX_CS4# */
	RCAR_GP_PIN(3, 11),
};
static const unsigned int lbsc_ex_cs4_mux[] = {
	EX_CS4_N_MARK,
};
static const unsigned int lbsc_ex_cs5_pins[] = {
	/* EX_CS5# */
	RCAR_GP_PIN(3, 12),
};
static const unsigned int lbsc_ex_cs5_mux[] = {
	EX_CS5_N_MARK,
};
/* - MSIOF0 ----------------------------------------------------------------- */
static const unsigned int msiof0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(10, 0),
};
static const unsigned int msiof0_clk_mux[] = {
	MSIOF0_SCK_MARK,
};
static const unsigned int msiof0_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(10, 1),
};
static const unsigned int msiof0_sync_mux[] = {
	MSIOF0_SYNC_MARK,
};
static const unsigned int msiof0_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(10, 4),
};
static const unsigned int msiof0_rx_mux[] = {
	MSIOF0_RXD_MARK,
};
static const unsigned int msiof0_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(10, 3),
};
static const unsigned int msiof0_tx_mux[] = {
	MSIOF0_TXD_MARK,
};
/* - MSIOF1 ----------------------------------------------------------------- */
static const unsigned int msiof1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(10, 5),
};
static const unsigned int msiof1_clk_mux[] = {
	MSIOF1_SCK_MARK,
};
static const unsigned int msiof1_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(10, 6),
};
static const unsigned int msiof1_sync_mux[] = {
	MSIOF1_SYNC_MARK,
};
static const unsigned int msiof1_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(10, 9),
};
static const unsigned int msiof1_rx_mux[] = {
	MSIOF1_RXD_MARK,
};
static const unsigned int msiof1_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(10, 8),
};
static const unsigned int msiof1_tx_mux[] = {
	MSIOF1_TXD_MARK,
};
/* - QSPI ------------------------------------------------------------------- */
static const unsigned int qspi_ctrl_pins[] = {
	/* SPCLK, SSL */
	RCAR_GP_PIN(3, 25), RCAR_GP_PIN(3, 26),
};
static const unsigned int qspi_ctrl_mux[] = {
	SPCLK_MARK, SSL_MARK,
};
static const unsigned int qspi_data2_pins[] = {
	/* MOSI_IO0, MISO_IO1 */
	RCAR_GP_PIN(3, 4), RCAR_GP_PIN(3, 5),
};
static const unsigned int qspi_data2_mux[] = {
	MOSI_IO0_MARK, MISO_IO1_MARK,
};
static const unsigned int qspi_data4_pins[] = {
	/* MOSI_IO0, MISO_IO1, IO2, IO3 */
	RCAR_GP_PIN(3, 4), RCAR_GP_PIN(3, 5), RCAR_GP_PIN(3, 23),
	RCAR_GP_PIN(3, 24),
};
static const unsigned int qspi_data4_mux[] = {
	MOSI_IO0_MARK, MISO_IO1_MARK, IO2_MARK,	IO3_MARK,
};
/* - SCIF0 ------------------------------------------------------------------ */
static const unsigned int scif0_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(10, 14), RCAR_GP_PIN(10, 13),
};
static const unsigned int scif0_data_mux[] = {
	RX0_MARK, TX0_MARK,
};
static const unsigned int scif0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(10, 10),
};
static const unsigned int scif0_clk_mux[] = {
	SCK0_MARK,
};
static const unsigned int scif0_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(10, 12), RCAR_GP_PIN(10, 11),
};
static const unsigned int scif0_ctrl_mux[] = {
	RTS0_N_MARK, CTS0_N_MARK,
};
/* - SCIF1 ------------------------------------------------------------------ */
static const unsigned int scif1_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(10, 19), RCAR_GP_PIN(10, 18),
};
static const unsigned int scif1_data_mux[] = {
	RX1_MARK, TX1_MARK,
};
static const unsigned int scif1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(10, 15),
};
static const unsigned int scif1_clk_mux[] = {
	SCK1_MARK,
};
static const unsigned int scif1_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(10, 17), RCAR_GP_PIN(10, 16),
};
static const unsigned int scif1_ctrl_mux[] = {
	RTS1_N_MARK, CTS1_N_MARK,
};
/* - SCIF2 ------------------------------------------------------------------ */
static const unsigned int scif2_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(10, 22), RCAR_GP_PIN(10, 21),
};
static const unsigned int scif2_data_mux[] = {
	RX2_MARK, TX2_MARK,
};
static const unsigned int scif2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(10, 20),
};
static const unsigned int scif2_clk_mux[] = {
	SCK2_MARK,
};
/* - SCIF3 ------------------------------------------------------------------ */
static const unsigned int scif3_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(10, 25), RCAR_GP_PIN(10, 24),
};
static const unsigned int scif3_data_mux[] = {
	RX3_MARK, TX3_MARK,
};
static const unsigned int scif3_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(10, 23),
};
static const unsigned int scif3_clk_mux[] = {
	SCK3_MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* DAT0 */
	RCAR_GP_PIN(11, 7),
};
static const unsigned int sdhi0_data1_mux[] = {
	SD0_DAT0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* DAT[0-3] */
	RCAR_GP_PIN(11, 7), RCAR_GP_PIN(11, 8),
	RCAR_GP_PIN(11, 9), RCAR_GP_PIN(11, 10),
};
static const unsigned int sdhi0_data4_mux[] = {
	SD0_DAT0_MARK, SD0_DAT1_MARK, SD0_DAT2_MARK, SD0_DAT3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(11, 5), RCAR_GP_PIN(11, 6),
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SD0_CLK_MARK, SD0_CMD_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(11, 11),
};
static const unsigned int sdhi0_cd_mux[] = {
	SD0_CD_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(11, 12),
};
static const unsigned int sdhi0_wp_mux[] = {
	SD0_WP_MARK,
};
/* - VIN0 ------------------------------------------------------------------- */
static const union vin_data vin0_data_pins = {
	.data24 = {
		/* B */
		RCAR_GP_PIN(4, 4), RCAR_GP_PIN(4, 5),
		RCAR_GP_PIN(4, 6), RCAR_GP_PIN(4, 7),
		RCAR_GP_PIN(4, 8), RCAR_GP_PIN(4, 9),
		RCAR_GP_PIN(4, 10), RCAR_GP_PIN(4, 11),
		/* G */
		RCAR_GP_PIN(4, 12), RCAR_GP_PIN(4, 13),
		RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 15),
		RCAR_GP_PIN(8, 1), RCAR_GP_PIN(8, 2),
		RCAR_GP_PIN(8, 3), RCAR_GP_PIN(8, 4),
		/* R */
		RCAR_GP_PIN(8, 5), RCAR_GP_PIN(8, 6),
		RCAR_GP_PIN(8, 7), RCAR_GP_PIN(8, 8),
		RCAR_GP_PIN(8, 9), RCAR_GP_PIN(8, 10),
		RCAR_GP_PIN(8, 11), RCAR_GP_PIN(8, 12),
	},
};
static const union vin_data vin0_data_mux = {
	.data24 = {
		/* B */
		VI0_D0_B0_C0_MARK, VI0_D1_B1_C1_MARK,
		VI0_D2_B2_C2_MARK, VI0_D3_B3_C3_MARK,
		VI0_D4_B4_C4_MARK, VI0_D5_B5_C5_MARK,
		VI0_D6_B6_C6_MARK, VI0_D7_B7_C7_MARK,
		/* G */
		VI0_D8_G0_Y0_MARK, VI0_D9_G1_Y1_MARK,
		VI0_D10_G2_Y2_MARK, VI0_D11_G3_Y3_MARK,
		VI0_D12_G4_Y4_MARK, VI0_D13_G5_Y5_MARK,
		VI0_D14_G6_Y6_MARK, VI0_D15_G7_Y7_MARK,
		/* R */
		VI0_D16_R0_MARK, VI0_D17_R1_MARK,
		VI0_D18_R2_MARK, VI0_D19_R3_MARK,
		VI0_D20_R4_MARK, VI0_D21_R5_MARK,
		VI0_D22_R6_MARK, VI0_D23_R7_MARK,
	},
};
static const unsigned int vin0_data18_pins[] = {
	/* B */
	RCAR_GP_PIN(4, 6), RCAR_GP_PIN(4, 7),
	RCAR_GP_PIN(4, 8), RCAR_GP_PIN(4, 9),
	RCAR_GP_PIN(4, 10), RCAR_GP_PIN(4, 11),
	/* G */
	RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 15),
	RCAR_GP_PIN(8, 1), RCAR_GP_PIN(8, 2),
	RCAR_GP_PIN(8, 3), RCAR_GP_PIN(8, 4),
	/* R */
	RCAR_GP_PIN(8, 7), RCAR_GP_PIN(8, 8),
	RCAR_GP_PIN(8, 9), RCAR_GP_PIN(8, 10),
	RCAR_GP_PIN(8, 11), RCAR_GP_PIN(8, 12),
};
static const unsigned int vin0_data18_mux[] = {
	/* B */
	VI0_D2_B2_C2_MARK, VI0_D3_B3_C3_MARK,
	VI0_D4_B4_C4_MARK, VI0_D5_B5_C5_MARK,
	VI0_D6_B6_C6_MARK, VI0_D7_B7_C7_MARK,
	/* G */
	VI0_D10_G2_Y2_MARK, VI0_D11_G3_Y3_MARK,
	VI0_D12_G4_Y4_MARK, VI0_D13_G5_Y5_MARK,
	VI0_D14_G6_Y6_MARK, VI0_D15_G7_Y7_MARK,
	/* R */
	VI0_D18_R2_MARK, VI0_D19_R3_MARK,
	VI0_D20_R4_MARK, VI0_D21_R5_MARK,
	VI0_D22_R6_MARK, VI0_D23_R7_MARK,
};
static const unsigned int vin0_sync_pins[] = {
	/* HSYNC#, VSYNC# */
	RCAR_GP_PIN(4, 2), RCAR_GP_PIN(4, 3),
};
static const unsigned int vin0_sync_mux[] = {
	VI0_HSYNC_N_MARK, VI0_VSYNC_N_MARK,
};
static const unsigned int vin0_field_pins[] = {
	RCAR_GP_PIN(4, 16),
};
static const unsigned int vin0_field_mux[] = {
	VI0_FIELD_MARK,
};
static const unsigned int vin0_clkenb_pins[] = {
	RCAR_GP_PIN(4, 1),
};
static const unsigned int vin0_clkenb_mux[] = {
	VI0_CLKENB_MARK,
};
static const unsigned int vin0_clk_pins[] = {
	RCAR_GP_PIN(4, 0),
};
static const unsigned int vin0_clk_mux[] = {
	VI0_CLK_MARK,
};
/* - VIN1 ------------------------------------------------------------------- */
static const union vin_data vin1_data_pins = {
	.data24 = {
		/* B */
		RCAR_GP_PIN(5, 4), RCAR_GP_PIN(5, 5),
		RCAR_GP_PIN(5, 6), RCAR_GP_PIN(5, 7),
		RCAR_GP_PIN(5, 8), RCAR_GP_PIN(5, 9),
		RCAR_GP_PIN(5, 10), RCAR_GP_PIN(5, 11),
		/* G */
		RCAR_GP_PIN(5, 12), RCAR_GP_PIN(5, 13),
		RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 15),
		RCAR_GP_PIN(8, 5), RCAR_GP_PIN(8, 6),
		RCAR_GP_PIN(8, 7), RCAR_GP_PIN(8, 8),
		/* R */
		RCAR_GP_PIN(9, 5), RCAR_GP_PIN(9, 6),
		RCAR_GP_PIN(9, 7), RCAR_GP_PIN(9, 8),
		RCAR_GP_PIN(9, 9), RCAR_GP_PIN(9, 10),
		RCAR_GP_PIN(9, 11), RCAR_GP_PIN(9, 12),
	},
};
static const union vin_data vin1_data_mux = {
	.data24 = {
		/* B */
		VI1_D0_B0_C0_MARK, VI1_D1_B1_C1_MARK,
		VI1_D2_B2_C2_MARK, VI1_D3_B3_C3_MARK,
		VI1_D4_B4_C4_MARK, VI1_D5_B5_C5_MARK,
		VI1_D6_B6_C6_MARK, VI1_D7_B7_C7_MARK,
		/* G */
		VI1_D8_G0_Y0_MARK, VI1_D9_G1_Y1_MARK,
		VI1_D10_G2_Y2_MARK, VI1_D11_G3_Y3_MARK,
		VI1_D12_G4_Y4_MARK, VI1_D13_G5_Y5_MARK,
		VI1_D14_G6_Y6_MARK, VI1_D15_G7_Y7_MARK,
		/* R */
		VI1_D16_R0_MARK, VI1_D17_R1_MARK,
		VI1_D18_R2_MARK, VI1_D19_R3_MARK,
		VI1_D20_R4_MARK, VI1_D21_R5_MARK,
		VI1_D22_R6_MARK, VI1_D23_R7_MARK,
	},
};
static const unsigned int vin1_data18_pins[] = {
	/* B */
	RCAR_GP_PIN(5, 6), RCAR_GP_PIN(5, 7),
	RCAR_GP_PIN(5, 8), RCAR_GP_PIN(5, 9),
	RCAR_GP_PIN(5, 10), RCAR_GP_PIN(5, 11),
	/* G */
	RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 15),
	RCAR_GP_PIN(8, 5), RCAR_GP_PIN(8, 6),
	RCAR_GP_PIN(8, 7), RCAR_GP_PIN(8, 8),
	/* R */
	RCAR_GP_PIN(9, 7), RCAR_GP_PIN(9, 8),
	RCAR_GP_PIN(9, 9), RCAR_GP_PIN(9, 10),
	RCAR_GP_PIN(9, 11), RCAR_GP_PIN(9, 12),
};
static const unsigned int vin1_data18_mux[] = {
	/* B */
	VI1_D2_B2_C2_MARK, VI1_D3_B3_C3_MARK,
	VI1_D4_B4_C4_MARK, VI1_D5_B5_C5_MARK,
	VI1_D6_B6_C6_MARK, VI1_D7_B7_C7_MARK,
	/* G */
	VI1_D10_G2_Y2_MARK, VI1_D11_G3_Y3_MARK,
	VI1_D12_G4_Y4_MARK, VI1_D13_G5_Y5_MARK,
	VI1_D14_G6_Y6_MARK, VI1_D15_G7_Y7_MARK,
	/* R */
	VI1_D18_R2_MARK, VI1_D19_R3_MARK,
	VI1_D20_R4_MARK, VI1_D21_R5_MARK,
	VI1_D22_R6_MARK, VI1_D23_R7_MARK,
};
static const union vin_data vin1_data_b_pins = {
	.data24 = {
		/* B */
		RCAR_GP_PIN(5, 4), RCAR_GP_PIN(5, 5),
		RCAR_GP_PIN(5, 6), RCAR_GP_PIN(5, 7),
		RCAR_GP_PIN(5, 8), RCAR_GP_PIN(5, 9),
		RCAR_GP_PIN(5, 10), RCAR_GP_PIN(5, 11),
		/* G */
		RCAR_GP_PIN(5, 12), RCAR_GP_PIN(5, 13),
		RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 15),
		RCAR_GP_PIN(9, 1), RCAR_GP_PIN(9, 2),
		RCAR_GP_PIN(9, 3), RCAR_GP_PIN(9, 4),
		/* R */
		RCAR_GP_PIN(9, 5), RCAR_GP_PIN(9, 6),
		RCAR_GP_PIN(9, 7), RCAR_GP_PIN(9, 8),
		RCAR_GP_PIN(9, 9), RCAR_GP_PIN(9, 10),
		RCAR_GP_PIN(9, 11), RCAR_GP_PIN(9, 12),
	},
};
static const union vin_data vin1_data_b_mux = {
	.data24 = {
		/* B */
		VI1_D0_B0_C0_MARK, VI1_D1_B1_C1_MARK,
		VI1_D2_B2_C2_MARK, VI1_D3_B3_C3_MARK,
		VI1_D4_B4_C4_MARK, VI1_D5_B5_C5_MARK,
		VI1_D6_B6_C6_MARK, VI1_D7_B7_C7_MARK,
		/* G */
		VI1_D8_G0_Y0_MARK, VI1_D9_G1_Y1_MARK,
		VI1_D10_G2_Y2_MARK, VI1_D11_G3_Y3_MARK,
		VI1_D12_G4_Y4_B_MARK, VI1_D13_G5_Y5_B_MARK,
		VI1_D14_G6_Y6_B_MARK, VI1_D15_G7_Y7_B_MARK,
		/* R */
		VI1_D16_R0_MARK, VI1_D17_R1_MARK,
		VI1_D18_R2_MARK, VI1_D19_R3_MARK,
		VI1_D20_R4_MARK, VI1_D21_R5_MARK,
		VI1_D22_R6_MARK, VI1_D23_R7_MARK,
	},
};
static const unsigned int vin1_data18_b_pins[] = {
	/* B */
	RCAR_GP_PIN(5, 6), RCAR_GP_PIN(5, 7),
	RCAR_GP_PIN(5, 8), RCAR_GP_PIN(5, 9),
	RCAR_GP_PIN(5, 10), RCAR_GP_PIN(5, 11),
	/* G */
	RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 15),
	RCAR_GP_PIN(9, 1), RCAR_GP_PIN(9, 2),
	RCAR_GP_PIN(9, 3), RCAR_GP_PIN(9, 4),
	/* R */
	RCAR_GP_PIN(9, 7), RCAR_GP_PIN(9, 8),
	RCAR_GP_PIN(9, 9), RCAR_GP_PIN(9, 10),
	RCAR_GP_PIN(9, 11), RCAR_GP_PIN(9, 12),
};
static const unsigned int vin1_data18_b_mux[] = {
	/* B */
	VI1_D2_B2_C2_MARK, VI1_D3_B3_C3_MARK,
	VI1_D4_B4_C4_MARK, VI1_D5_B5_C5_MARK,
	VI1_D6_B6_C6_MARK, VI1_D7_B7_C7_MARK,
	/* G */
	VI1_D10_G2_Y2_MARK, VI1_D11_G3_Y3_MARK,
	VI1_D12_G4_Y4_B_MARK, VI1_D13_G5_Y5_B_MARK,
	VI1_D14_G6_Y6_B_MARK, VI1_D15_G7_Y7_B_MARK,
	/* R */
	VI1_D18_R2_MARK, VI1_D19_R3_MARK,
	VI1_D20_R4_MARK, VI1_D21_R5_MARK,
	VI1_D22_R6_MARK, VI1_D23_R7_MARK,
};
static const unsigned int vin1_sync_pins[] = {
	/* HSYNC#, VSYNC# */
	RCAR_GP_PIN(5, 2), RCAR_GP_PIN(5, 3),
};
static const unsigned int vin1_sync_mux[] = {
	VI1_HSYNC_N_MARK, VI1_VSYNC_N_MARK,
};
static const unsigned int vin1_field_pins[] = {
	RCAR_GP_PIN(5, 16),
};
static const unsigned int vin1_field_mux[] = {
	VI1_FIELD_MARK,
};
static const unsigned int vin1_clkenb_pins[] = {
	RCAR_GP_PIN(5, 1),
};
static const unsigned int vin1_clkenb_mux[] = {
	VI1_CLKENB_MARK,
};
static const unsigned int vin1_clk_pins[] = {
	RCAR_GP_PIN(5, 0),
};
static const unsigned int vin1_clk_mux[] = {
	VI1_CLK_MARK,
};
/* - VIN2 ------------------------------------------------------------------- */
static const union vin_data16 vin2_data_pins = {
	.data16 = {
		RCAR_GP_PIN(6, 4), RCAR_GP_PIN(6, 5),
		RCAR_GP_PIN(6, 6), RCAR_GP_PIN(6, 7),
		RCAR_GP_PIN(6, 8), RCAR_GP_PIN(6, 9),
		RCAR_GP_PIN(6, 10), RCAR_GP_PIN(6, 11),
		RCAR_GP_PIN(6, 12), RCAR_GP_PIN(6, 13),
		RCAR_GP_PIN(6, 14), RCAR_GP_PIN(6, 15),
		RCAR_GP_PIN(8, 9), RCAR_GP_PIN(8, 10),
		RCAR_GP_PIN(8, 11), RCAR_GP_PIN(8, 12),
	},
};
static const union vin_data16 vin2_data_mux = {
	.data16 = {
		VI2_D0_C0_MARK, VI2_D1_C1_MARK,
		VI2_D2_C2_MARK,	VI2_D3_C3_MARK,
		VI2_D4_C4_MARK, VI2_D5_C5_MARK,
		VI2_D6_C6_MARK, VI2_D7_C7_MARK,
		VI2_D8_Y0_MARK,	VI2_D9_Y1_MARK,
		VI2_D10_Y2_MARK, VI2_D11_Y3_MARK,
		VI2_D12_Y4_MARK, VI2_D13_Y5_MARK,
		VI2_D14_Y6_MARK, VI2_D15_Y7_MARK,
	},
};
static const unsigned int vin2_sync_pins[] = {
	/* HSYNC#, VSYNC# */
	RCAR_GP_PIN(6, 2), RCAR_GP_PIN(6, 3),
};
static const unsigned int vin2_sync_mux[] = {
	VI2_HSYNC_N_MARK, VI2_VSYNC_N_MARK,
};
static const unsigned int vin2_field_pins[] = {
	RCAR_GP_PIN(6, 16),
};
static const unsigned int vin2_field_mux[] = {
	VI2_FIELD_MARK,
};
static const unsigned int vin2_clkenb_pins[] = {
	RCAR_GP_PIN(6, 1),
};
static const unsigned int vin2_clkenb_mux[] = {
	VI2_CLKENB_MARK,
};
static const unsigned int vin2_clk_pins[] = {
	RCAR_GP_PIN(6, 0),
};
static const unsigned int vin2_clk_mux[] = {
	VI2_CLK_MARK,
};
/* - VIN3 ------------------------------------------------------------------- */
static const union vin_data16 vin3_data_pins = {
	.data16 = {
		RCAR_GP_PIN(7, 4), RCAR_GP_PIN(7, 5),
		RCAR_GP_PIN(7, 6), RCAR_GP_PIN(7, 7),
		RCAR_GP_PIN(7, 8), RCAR_GP_PIN(7, 9),
		RCAR_GP_PIN(7, 10), RCAR_GP_PIN(7, 11),
		RCAR_GP_PIN(7, 12), RCAR_GP_PIN(7, 13),
		RCAR_GP_PIN(7, 14), RCAR_GP_PIN(7, 15),
		RCAR_GP_PIN(8, 13), RCAR_GP_PIN(8, 14),
		RCAR_GP_PIN(8, 15), RCAR_GP_PIN(8, 16),
	},
};
static const union vin_data16 vin3_data_mux = {
	.data16 = {
		VI3_D0_C0_MARK, VI3_D1_C1_MARK,
		VI3_D2_C2_MARK,	VI3_D3_C3_MARK,
		VI3_D4_C4_MARK, VI3_D5_C5_MARK,
		VI3_D6_C6_MARK, VI3_D7_C7_MARK,
		VI3_D8_Y0_MARK, VI3_D9_Y1_MARK,
		VI3_D10_Y2_MARK, VI3_D11_Y3_MARK,
		VI3_D12_Y4_MARK, VI3_D13_Y5_MARK,
		VI3_D14_Y6_MARK, VI3_D15_Y7_MARK,
	},
};
static const unsigned int vin3_sync_pins[] = {
	/* HSYNC#, VSYNC# */
	RCAR_GP_PIN(7, 2), RCAR_GP_PIN(7, 3),
};
static const unsigned int vin3_sync_mux[] = {
	VI3_HSYNC_N_MARK, VI3_VSYNC_N_MARK,
};
static const unsigned int vin3_field_pins[] = {
	RCAR_GP_PIN(7, 16),
};
static const unsigned int vin3_field_mux[] = {
	VI3_FIELD_MARK,
};
static const unsigned int vin3_clkenb_pins[] = {
	RCAR_GP_PIN(7, 1),
};
static const unsigned int vin3_clkenb_mux[] = {
	VI3_CLKENB_MARK,
};
static const unsigned int vin3_clk_pins[] = {
	RCAR_GP_PIN(7, 0),
};
static const unsigned int vin3_clk_mux[] = {
	VI3_CLK_MARK,
};
/* - VIN4 ------------------------------------------------------------------- */
static const union vin_data12 vin4_data_pins = {
	.data12 = {
		RCAR_GP_PIN(8, 4), RCAR_GP_PIN(8, 5),
		RCAR_GP_PIN(8, 6), RCAR_GP_PIN(8, 7),
		RCAR_GP_PIN(8, 8), RCAR_GP_PIN(8, 9),
		RCAR_GP_PIN(8, 10), RCAR_GP_PIN(8, 11),
		RCAR_GP_PIN(8, 12), RCAR_GP_PIN(8, 13),
		RCAR_GP_PIN(8, 14), RCAR_GP_PIN(8, 15),
	},
};
static const union vin_data12 vin4_data_mux = {
	.data12 = {
		VI4_D0_C0_MARK, VI4_D1_C1_MARK,
		VI4_D2_C2_MARK, VI4_D3_C3_MARK,
		VI4_D4_C4_MARK, VI4_D5_C5_MARK,
		VI4_D6_C6_MARK, VI4_D7_C7_MARK,
		VI4_D8_Y0_MARK,	VI4_D9_Y1_MARK,
		VI4_D10_Y2_MARK, VI4_D11_Y3_MARK,
	},
};
static const unsigned int vin4_sync_pins[] = {
	 /* HSYNC#, VSYNC# */
	RCAR_GP_PIN(8, 2), RCAR_GP_PIN(8, 3),
};
static const unsigned int vin4_sync_mux[] = {
	VI4_HSYNC_N_MARK, VI4_VSYNC_N_MARK,
};
static const unsigned int vin4_field_pins[] = {
	RCAR_GP_PIN(8, 16),
};
static const unsigned int vin4_field_mux[] = {
	VI4_FIELD_MARK,
};
static const unsigned int vin4_clkenb_pins[] = {
	RCAR_GP_PIN(8, 1),
};
static const unsigned int vin4_clkenb_mux[] = {
	VI4_CLKENB_MARK,
};
static const unsigned int vin4_clk_pins[] = {
	RCAR_GP_PIN(8, 0),
};
static const unsigned int vin4_clk_mux[] = {
	VI4_CLK_MARK,
};
/* - VIN5 ------------------------------------------------------------------- */
static const union vin_data12 vin5_data_pins = {
	.data12 = {
		RCAR_GP_PIN(9, 4), RCAR_GP_PIN(9, 5),
		RCAR_GP_PIN(9, 6), RCAR_GP_PIN(9, 7),
		RCAR_GP_PIN(9, 8), RCAR_GP_PIN(9, 9),
		RCAR_GP_PIN(9, 10), RCAR_GP_PIN(9, 11),
		RCAR_GP_PIN(9, 12), RCAR_GP_PIN(9, 13),
		RCAR_GP_PIN(9, 14), RCAR_GP_PIN(9, 15),
	},
};
static const union vin_data12 vin5_data_mux = {
	.data12 = {
		VI5_D0_C0_MARK, VI5_D1_C1_MARK,
		VI5_D2_C2_MARK, VI5_D3_C3_MARK,
		VI5_D4_C4_MARK, VI5_D5_C5_MARK,
		VI5_D6_C6_MARK, VI5_D7_C7_MARK,
		VI5_D8_Y0_MARK, VI5_D9_Y1_MARK,
		VI5_D10_Y2_MARK, VI5_D11_Y3_MARK,
	},
};
static const unsigned int vin5_sync_pins[] = {
	/* HSYNC#, VSYNC# */
	RCAR_GP_PIN(9, 2), RCAR_GP_PIN(9, 3),
};
static const unsigned int vin5_sync_mux[] = {
	VI5_HSYNC_N_MARK, VI5_VSYNC_N_MARK,
};
static const unsigned int vin5_field_pins[] = {
	RCAR_GP_PIN(9, 16),
};
static const unsigned int vin5_field_mux[] = {
	VI5_FIELD_MARK,
};
static const unsigned int vin5_clkenb_pins[] = {
	RCAR_GP_PIN(9, 1),
};
static const unsigned int vin5_clkenb_mux[] = {
	VI5_CLKENB_MARK,
};
static const unsigned int vin5_clk_pins[] = {
	RCAR_GP_PIN(9, 0),
};
static const unsigned int vin5_clk_mux[] = {
	VI5_CLK_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(avb_link),
	SH_PFC_PIN_GROUP(avb_magic),
	SH_PFC_PIN_GROUP(avb_phy_int),
	SH_PFC_PIN_GROUP(avb_mdio),
	SH_PFC_PIN_GROUP(avb_mii),
	SH_PFC_PIN_GROUP(avb_gmii),
	SH_PFC_PIN_GROUP(avb_avtp_match),
	SH_PFC_PIN_GROUP(can0_data),
	SH_PFC_PIN_GROUP(can1_data),
	SH_PFC_PIN_GROUP(can_clk),
	SH_PFC_PIN_GROUP(du0_rgb666),
	SH_PFC_PIN_GROUP(du0_rgb888),
	SH_PFC_PIN_GROUP(du0_sync),
	SH_PFC_PIN_GROUP(du0_oddf),
	SH_PFC_PIN_GROUP(du0_disp),
	SH_PFC_PIN_GROUP(du0_cde),
	SH_PFC_PIN_GROUP(du1_rgb666),
	SH_PFC_PIN_GROUP(du1_sync),
	SH_PFC_PIN_GROUP(du1_oddf),
	SH_PFC_PIN_GROUP(du1_disp),
	SH_PFC_PIN_GROUP(du1_cde),
	SH_PFC_PIN_GROUP(intc_irq0),
	SH_PFC_PIN_GROUP(intc_irq1),
	SH_PFC_PIN_GROUP(intc_irq2),
	SH_PFC_PIN_GROUP(intc_irq3),
	SH_PFC_PIN_GROUP(lbsc_cs0),
	SH_PFC_PIN_GROUP(lbsc_cs1),
	SH_PFC_PIN_GROUP(lbsc_ex_cs0),
	SH_PFC_PIN_GROUP(lbsc_ex_cs1),
	SH_PFC_PIN_GROUP(lbsc_ex_cs2),
	SH_PFC_PIN_GROUP(lbsc_ex_cs3),
	SH_PFC_PIN_GROUP(lbsc_ex_cs4),
	SH_PFC_PIN_GROUP(lbsc_ex_cs5),
	SH_PFC_PIN_GROUP(msiof0_clk),
	SH_PFC_PIN_GROUP(msiof0_sync),
	SH_PFC_PIN_GROUP(msiof0_rx),
	SH_PFC_PIN_GROUP(msiof0_tx),
	SH_PFC_PIN_GROUP(msiof1_clk),
	SH_PFC_PIN_GROUP(msiof1_sync),
	SH_PFC_PIN_GROUP(msiof1_rx),
	SH_PFC_PIN_GROUP(msiof1_tx),
	SH_PFC_PIN_GROUP(qspi_ctrl),
	SH_PFC_PIN_GROUP(qspi_data2),
	SH_PFC_PIN_GROUP(qspi_data4),
	SH_PFC_PIN_GROUP(scif0_data),
	SH_PFC_PIN_GROUP(scif0_clk),
	SH_PFC_PIN_GROUP(scif0_ctrl),
	SH_PFC_PIN_GROUP(scif1_data),
	SH_PFC_PIN_GROUP(scif1_clk),
	SH_PFC_PIN_GROUP(scif1_ctrl),
	SH_PFC_PIN_GROUP(scif2_data),
	SH_PFC_PIN_GROUP(scif2_clk),
	SH_PFC_PIN_GROUP(scif3_data),
	SH_PFC_PIN_GROUP(scif3_clk),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	VIN_DATA_PIN_GROUP(vin0_data, 24),
	VIN_DATA_PIN_GROUP(vin0_data, 20),
	SH_PFC_PIN_GROUP(vin0_data18),
	VIN_DATA_PIN_GROUP(vin0_data, 16),
	VIN_DATA_PIN_GROUP(vin0_data, 12),
	VIN_DATA_PIN_GROUP(vin0_data, 10),
	VIN_DATA_PIN_GROUP(vin0_data, 8),
	SH_PFC_PIN_GROUP(vin0_sync),
	SH_PFC_PIN_GROUP(vin0_field),
	SH_PFC_PIN_GROUP(vin0_clkenb),
	SH_PFC_PIN_GROUP(vin0_clk),
	VIN_DATA_PIN_GROUP(vin1_data, 24),
	VIN_DATA_PIN_GROUP(vin1_data, 20),
	SH_PFC_PIN_GROUP(vin1_data18),
	VIN_DATA_PIN_GROUP(vin1_data, 16),
	VIN_DATA_PIN_GROUP(vin1_data, 12),
	VIN_DATA_PIN_GROUP(vin1_data, 10),
	VIN_DATA_PIN_GROUP(vin1_data, 8),
	VIN_DATA_PIN_GROUP(vin1_data_b, 24),
	VIN_DATA_PIN_GROUP(vin1_data_b, 20),
	SH_PFC_PIN_GROUP(vin1_data18_b),
	VIN_DATA_PIN_GROUP(vin1_data_b, 16),
	SH_PFC_PIN_GROUP(vin1_sync),
	SH_PFC_PIN_GROUP(vin1_field),
	SH_PFC_PIN_GROUP(vin1_clkenb),
	SH_PFC_PIN_GROUP(vin1_clk),
	VIN_DATA_PIN_GROUP(vin2_data, 16),
	VIN_DATA_PIN_GROUP(vin2_data, 12),
	VIN_DATA_PIN_GROUP(vin2_data, 10),
	VIN_DATA_PIN_GROUP(vin2_data, 8),
	SH_PFC_PIN_GROUP(vin2_sync),
	SH_PFC_PIN_GROUP(vin2_field),
	SH_PFC_PIN_GROUP(vin2_clkenb),
	SH_PFC_PIN_GROUP(vin2_clk),
	VIN_DATA_PIN_GROUP(vin3_data, 16),
	VIN_DATA_PIN_GROUP(vin3_data, 12),
	VIN_DATA_PIN_GROUP(vin3_data, 10),
	VIN_DATA_PIN_GROUP(vin3_data, 8),
	SH_PFC_PIN_GROUP(vin3_sync),
	SH_PFC_PIN_GROUP(vin3_field),
	SH_PFC_PIN_GROUP(vin3_clkenb),
	SH_PFC_PIN_GROUP(vin3_clk),
	VIN_DATA_PIN_GROUP(vin4_data, 12),
	VIN_DATA_PIN_GROUP(vin4_data, 10),
	VIN_DATA_PIN_GROUP(vin4_data, 8),
	SH_PFC_PIN_GROUP(vin4_sync),
	SH_PFC_PIN_GROUP(vin4_field),
	SH_PFC_PIN_GROUP(vin4_clkenb),
	SH_PFC_PIN_GROUP(vin4_clk),
	VIN_DATA_PIN_GROUP(vin5_data, 12),
	VIN_DATA_PIN_GROUP(vin5_data, 10),
	VIN_DATA_PIN_GROUP(vin5_data, 8),
	SH_PFC_PIN_GROUP(vin5_sync),
	SH_PFC_PIN_GROUP(vin5_field),
	SH_PFC_PIN_GROUP(vin5_clkenb),
	SH_PFC_PIN_GROUP(vin5_clk),
};

static const char * const avb_groups[] = {
	"avb_link",
	"avb_magic",
	"avb_phy_int",
	"avb_mdio",
	"avb_mii",
	"avb_gmii",
	"avb_avtp_match",
};

static const char * const can0_groups[] = {
	"can0_data",
	"can_clk",
};

static const char * const can1_groups[] = {
	"can1_data",
	"can_clk",
};

static const char * const du0_groups[] = {
	"du0_rgb666",
	"du0_rgb888",
	"du0_sync",
	"du0_oddf",
	"du0_disp",
	"du0_cde",
};

static const char * const du1_groups[] = {
	"du1_rgb666",
	"du1_sync",
	"du1_oddf",
	"du1_disp",
	"du1_cde",
};

static const char * const intc_groups[] = {
	"intc_irq0",
	"intc_irq1",
	"intc_irq2",
	"intc_irq3",
};

static const char * const lbsc_groups[] = {
	"lbsc_cs0",
	"lbsc_cs1",
	"lbsc_ex_cs0",
	"lbsc_ex_cs1",
	"lbsc_ex_cs2",
	"lbsc_ex_cs3",
	"lbsc_ex_cs4",
	"lbsc_ex_cs5",
};

static const char * const msiof0_groups[] = {
	"msiof0_clk",
	"msiof0_sync",
	"msiof0_rx",
	"msiof0_tx",
};

static const char * const msiof1_groups[] = {
	"msiof1_clk",
	"msiof1_sync",
	"msiof1_rx",
	"msiof1_tx",
};

static const char * const qspi_groups[] = {
	"qspi_ctrl",
	"qspi_data2",
	"qspi_data4",
};

static const char * const scif0_groups[] = {
	"scif0_data",
	"scif0_clk",
	"scif0_ctrl",
};

static const char * const scif1_groups[] = {
	"scif1_data",
	"scif1_clk",
	"scif1_ctrl",
};

static const char * const scif2_groups[] = {
	"scif2_data",
	"scif2_clk",
};

static const char * const scif3_groups[] = {
	"scif3_data",
	"scif3_clk",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const vin0_groups[] = {
	"vin0_data24",
	"vin0_data20",
	"vin0_data18",
	"vin0_data16",
	"vin0_data12",
	"vin0_data10",
	"vin0_data8",
	"vin0_sync",
	"vin0_field",
	"vin0_clkenb",
	"vin0_clk",
};

static const char * const vin1_groups[] = {
	"vin1_data24",
	"vin1_data20",
	"vin1_data18",
	"vin1_data16",
	"vin1_data12",
	"vin1_data10",
	"vin1_data8",
	"vin1_data24_b",
	"vin1_data20_b",
	"vin1_data16_b",
	"vin1_sync",
	"vin1_field",
	"vin1_clkenb",
	"vin1_clk",
};

static const char * const vin2_groups[] = {
	"vin2_data16",
	"vin2_data12",
	"vin2_data10",
	"vin2_data8",
	"vin2_sync",
	"vin2_field",
	"vin2_clkenb",
	"vin2_clk",
};

static const char * const vin3_groups[] = {
	"vin3_data16",
	"vin3_data12",
	"vin3_data10",
	"vin3_data8",
	"vin3_sync",
	"vin3_field",
	"vin3_clkenb",
	"vin3_clk",
};

static const char * const vin4_groups[] = {
	"vin4_data12",
	"vin4_data10",
	"vin4_data8",
	"vin4_sync",
	"vin4_field",
	"vin4_clkenb",
	"vin4_clk",
};

static const char * const vin5_groups[] = {
	"vin5_data12",
	"vin5_data10",
	"vin5_data8",
	"vin5_sync",
	"vin5_field",
	"vin5_clkenb",
	"vin5_clk",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(avb),
	SH_PFC_FUNCTION(can0),
	SH_PFC_FUNCTION(can1),
	SH_PFC_FUNCTION(du0),
	SH_PFC_FUNCTION(du1),
	SH_PFC_FUNCTION(intc),
	SH_PFC_FUNCTION(lbsc),
	SH_PFC_FUNCTION(msiof0),
	SH_PFC_FUNCTION(msiof1),
	SH_PFC_FUNCTION(qspi),
	SH_PFC_FUNCTION(scif0),
	SH_PFC_FUNCTION(scif1),
	SH_PFC_FUNCTION(scif2),
	SH_PFC_FUNCTION(scif3),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(vin0),
	SH_PFC_FUNCTION(vin1),
	SH_PFC_FUNCTION(vin2),
	SH_PFC_FUNCTION(vin3),
	SH_PFC_FUNCTION(vin4),
	SH_PFC_FUNCTION(vin5),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("GPSR0", 0xE6060004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		GP_0_28_FN, FN_IP1_4,
		GP_0_27_FN, FN_IP1_3,
		GP_0_26_FN, FN_IP1_2,
		GP_0_25_FN, FN_IP1_1,
		GP_0_24_FN, FN_IP1_0,
		GP_0_23_FN, FN_IP0_23,
		GP_0_22_FN, FN_IP0_22,
		GP_0_21_FN, FN_IP0_21,
		GP_0_20_FN, FN_IP0_20,
		GP_0_19_FN, FN_IP0_19,
		GP_0_18_FN, FN_IP0_18,
		GP_0_17_FN, FN_IP0_17,
		GP_0_16_FN, FN_IP0_16,
		GP_0_15_FN, FN_IP0_15,
		GP_0_14_FN, FN_IP0_14,
		GP_0_13_FN, FN_IP0_13,
		GP_0_12_FN, FN_IP0_12,
		GP_0_11_FN, FN_IP0_11,
		GP_0_10_FN, FN_IP0_10,
		GP_0_9_FN, FN_IP0_9,
		GP_0_8_FN, FN_IP0_8,
		GP_0_7_FN, FN_IP0_7,
		GP_0_6_FN, FN_IP0_6,
		GP_0_5_FN, FN_IP0_5,
		GP_0_4_FN, FN_IP0_4,
		GP_0_3_FN, FN_IP0_3,
		GP_0_2_FN, FN_IP0_2,
		GP_0_1_FN, FN_IP0_1,
		GP_0_0_FN, FN_IP0_0 }
	},
	{ PINMUX_CFG_REG("GPSR1", 0xE6060008, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_1_22_FN, FN_DU1_CDE,
		GP_1_21_FN, FN_DU1_DISP,
		GP_1_20_FN, FN_DU1_EXODDF_DU1_ODDF_DISP_CDE,
		GP_1_19_FN, FN_DU1_EXVSYNC_DU1_VSYNC,
		GP_1_18_FN, FN_DU1_EXHSYNC_DU1_HSYNC,
		GP_1_17_FN, FN_DU1_DB7_C5,
		GP_1_16_FN, FN_DU1_DB6_C4,
		GP_1_15_FN, FN_DU1_DB5_C3_DATA15,
		GP_1_14_FN, FN_DU1_DB4_C2_DATA14,
		GP_1_13_FN, FN_DU1_DB3_C1_DATA13,
		GP_1_12_FN, FN_DU1_DB2_C0_DATA12,
		GP_1_11_FN, FN_IP1_16,
		GP_1_10_FN, FN_IP1_15,
		GP_1_9_FN, FN_IP1_14,
		GP_1_8_FN, FN_IP1_13,
		GP_1_7_FN, FN_IP1_12,
		GP_1_6_FN, FN_IP1_11,
		GP_1_5_FN, FN_IP1_10,
		GP_1_4_FN, FN_IP1_9,
		GP_1_3_FN, FN_IP1_8,
		GP_1_2_FN, FN_IP1_7,
		GP_1_1_FN, FN_IP1_6,
		GP_1_0_FN, FN_IP1_5, }
	},
	{ PINMUX_CFG_REG("GPSR2", 0xE606000C, 32, 1) {
		GP_2_31_FN, FN_A15,
		GP_2_30_FN, FN_A14,
		GP_2_29_FN, FN_A13,
		GP_2_28_FN, FN_A12,
		GP_2_27_FN, FN_A11,
		GP_2_26_FN, FN_A10,
		GP_2_25_FN, FN_A9,
		GP_2_24_FN, FN_A8,
		GP_2_23_FN, FN_A7,
		GP_2_22_FN, FN_A6,
		GP_2_21_FN, FN_A5,
		GP_2_20_FN, FN_A4,
		GP_2_19_FN, FN_A3,
		GP_2_18_FN, FN_A2,
		GP_2_17_FN, FN_A1,
		GP_2_16_FN, FN_A0,
		GP_2_15_FN, FN_D15,
		GP_2_14_FN, FN_D14,
		GP_2_13_FN, FN_D13,
		GP_2_12_FN, FN_D12,
		GP_2_11_FN, FN_D11,
		GP_2_10_FN, FN_D10,
		GP_2_9_FN, FN_D9,
		GP_2_8_FN, FN_D8,
		GP_2_7_FN, FN_D7,
		GP_2_6_FN, FN_D6,
		GP_2_5_FN, FN_D5,
		GP_2_4_FN, FN_D4,
		GP_2_3_FN, FN_D3,
		GP_2_2_FN, FN_D2,
		GP_2_1_FN, FN_D1,
		GP_2_0_FN, FN_D0 }
	},
	{ PINMUX_CFG_REG("GPSR3", 0xE6060010, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_3_27_FN, FN_CS0_N,
		GP_3_26_FN, FN_IP1_22,
		GP_3_25_FN, FN_IP1_21,
		GP_3_24_FN, FN_IP1_20,
		GP_3_23_FN, FN_IP1_19,
		GP_3_22_FN, FN_IRQ3,
		GP_3_21_FN, FN_IRQ2,
		GP_3_20_FN, FN_IRQ1,
		GP_3_19_FN, FN_IRQ0,
		GP_3_18_FN, FN_EX_WAIT0,
		GP_3_17_FN, FN_WE1_N,
		GP_3_16_FN, FN_WE0_N,
		GP_3_15_FN, FN_RD_WR_N,
		GP_3_14_FN, FN_RD_N,
		GP_3_13_FN, FN_BS_N,
		GP_3_12_FN, FN_EX_CS5_N,
		GP_3_11_FN, FN_EX_CS4_N,
		GP_3_10_FN, FN_EX_CS3_N,
		GP_3_9_FN, FN_EX_CS2_N,
		GP_3_8_FN, FN_EX_CS1_N,
		GP_3_7_FN, FN_EX_CS0_N,
		GP_3_6_FN, FN_CS1_N_A26,
		GP_3_5_FN, FN_IP1_18,
		GP_3_4_FN, FN_IP1_17,
		GP_3_3_FN, FN_A19,
		GP_3_2_FN, FN_A18,
		GP_3_1_FN, FN_A17,
		GP_3_0_FN, FN_A16 }
	},
	{ PINMUX_CFG_REG("GPSR4", 0xE6060014, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_4_16_FN, FN_VI0_FIELD,
		GP_4_15_FN, FN_VI0_D11_G3_Y3,
		GP_4_14_FN, FN_VI0_D10_G2_Y2,
		GP_4_13_FN, FN_VI0_D9_G1_Y1,
		GP_4_12_FN, FN_VI0_D8_G0_Y0,
		GP_4_11_FN, FN_VI0_D7_B7_C7,
		GP_4_10_FN, FN_VI0_D6_B6_C6,
		GP_4_9_FN, FN_VI0_D5_B5_C5,
		GP_4_8_FN, FN_VI0_D4_B4_C4,
		GP_4_7_FN, FN_VI0_D3_B3_C3,
		GP_4_6_FN, FN_VI0_D2_B2_C2,
		GP_4_5_FN, FN_VI0_D1_B1_C1,
		GP_4_4_FN, FN_VI0_D0_B0_C0,
		GP_4_3_FN, FN_VI0_VSYNC_N,
		GP_4_2_FN, FN_VI0_HSYNC_N,
		GP_4_1_FN, FN_VI0_CLKENB,
		GP_4_0_FN, FN_VI0_CLK }
	},
	{ PINMUX_CFG_REG("GPSR5", 0xE6060018, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_5_16_FN, FN_VI1_FIELD,
		GP_5_15_FN, FN_VI1_D11_G3_Y3,
		GP_5_14_FN, FN_VI1_D10_G2_Y2,
		GP_5_13_FN, FN_VI1_D9_G1_Y1,
		GP_5_12_FN, FN_VI1_D8_G0_Y0,
		GP_5_11_FN, FN_VI1_D7_B7_C7,
		GP_5_10_FN, FN_VI1_D6_B6_C6,
		GP_5_9_FN, FN_VI1_D5_B5_C5,
		GP_5_8_FN, FN_VI1_D4_B4_C4,
		GP_5_7_FN, FN_VI1_D3_B3_C3,
		GP_5_6_FN, FN_VI1_D2_B2_C2,
		GP_5_5_FN, FN_VI1_D1_B1_C1,
		GP_5_4_FN, FN_VI1_D0_B0_C0,
		GP_5_3_FN, FN_VI1_VSYNC_N,
		GP_5_2_FN, FN_VI1_HSYNC_N,
		GP_5_1_FN, FN_VI1_CLKENB,
		GP_5_0_FN, FN_VI1_CLK }
	},
	{ PINMUX_CFG_REG("GPSR6", 0xE606001C, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_6_16_FN, FN_IP2_16,
		GP_6_15_FN, FN_IP2_15,
		GP_6_14_FN, FN_IP2_14,
		GP_6_13_FN, FN_IP2_13,
		GP_6_12_FN, FN_IP2_12,
		GP_6_11_FN, FN_IP2_11,
		GP_6_10_FN, FN_IP2_10,
		GP_6_9_FN, FN_IP2_9,
		GP_6_8_FN, FN_IP2_8,
		GP_6_7_FN, FN_IP2_7,
		GP_6_6_FN, FN_IP2_6,
		GP_6_5_FN, FN_IP2_5,
		GP_6_4_FN, FN_IP2_4,
		GP_6_3_FN, FN_IP2_3,
		GP_6_2_FN, FN_IP2_2,
		GP_6_1_FN, FN_IP2_1,
		GP_6_0_FN, FN_IP2_0 }
	},
	{ PINMUX_CFG_REG("GPSR7", 0xE6060020, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_7_16_FN, FN_VI3_FIELD,
		GP_7_15_FN, FN_IP3_14,
		GP_7_14_FN, FN_VI3_D10_Y2,
		GP_7_13_FN, FN_IP3_13,
		GP_7_12_FN, FN_IP3_12,
		GP_7_11_FN, FN_IP3_11,
		GP_7_10_FN, FN_IP3_10,
		GP_7_9_FN, FN_IP3_9,
		GP_7_8_FN, FN_IP3_8,
		GP_7_7_FN, FN_IP3_7,
		GP_7_6_FN, FN_IP3_6,
		GP_7_5_FN, FN_IP3_5,
		GP_7_4_FN, FN_IP3_4,
		GP_7_3_FN, FN_IP3_3,
		GP_7_2_FN, FN_IP3_2,
		GP_7_1_FN, FN_IP3_1,
		GP_7_0_FN, FN_IP3_0 }
	},
	{ PINMUX_CFG_REG("GPSR8", 0xE6060024, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_8_16_FN, FN_IP4_24,
		GP_8_15_FN, FN_IP4_23,
		GP_8_14_FN, FN_IP4_22,
		GP_8_13_FN, FN_IP4_21,
		GP_8_12_FN, FN_IP4_20_19,
		GP_8_11_FN, FN_IP4_18_17,
		GP_8_10_FN, FN_IP4_16_15,
		GP_8_9_FN, FN_IP4_14_13,
		GP_8_8_FN, FN_IP4_12_11,
		GP_8_7_FN, FN_IP4_10_9,
		GP_8_6_FN, FN_IP4_8_7,
		GP_8_5_FN, FN_IP4_6_5,
		GP_8_4_FN, FN_IP4_4,
		GP_8_3_FN, FN_IP4_3_2,
		GP_8_2_FN, FN_IP4_1,
		GP_8_1_FN, FN_IP4_0,
		GP_8_0_FN, FN_VI4_CLK }
	},
	{ PINMUX_CFG_REG("GPSR9", 0xE6060028, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_9_16_FN, FN_VI5_FIELD,
		GP_9_15_FN, FN_VI5_D11_Y3,
		GP_9_14_FN, FN_VI5_D10_Y2,
		GP_9_13_FN, FN_VI5_D9_Y1,
		GP_9_12_FN, FN_IP5_11,
		GP_9_11_FN, FN_IP5_10,
		GP_9_10_FN, FN_IP5_9,
		GP_9_9_FN, FN_IP5_8,
		GP_9_8_FN, FN_IP5_7,
		GP_9_7_FN, FN_IP5_6,
		GP_9_6_FN, FN_IP5_5,
		GP_9_5_FN, FN_IP5_4,
		GP_9_4_FN, FN_IP5_3,
		GP_9_3_FN, FN_IP5_2,
		GP_9_2_FN, FN_IP5_1,
		GP_9_1_FN, FN_IP5_0,
		GP_9_0_FN, FN_VI5_CLK }
	},
	{ PINMUX_CFG_REG("GPSR10", 0xE606002C, 32, 1) {
		GP_10_31_FN, FN_CAN1_RX,
		GP_10_30_FN, FN_CAN1_TX,
		GP_10_29_FN, FN_CAN_CLK,
		GP_10_28_FN, FN_CAN0_RX,
		GP_10_27_FN, FN_CAN0_TX,
		GP_10_26_FN, FN_SCIF_CLK,
		GP_10_25_FN, FN_IP6_18_17,
		GP_10_24_FN, FN_IP6_16,
		GP_10_23_FN, FN_IP6_15_14,
		GP_10_22_FN, FN_IP6_13_12,
		GP_10_21_FN, FN_IP6_11_10,
		GP_10_20_FN, FN_IP6_9_8,
		GP_10_19_FN, FN_RX1,
		GP_10_18_FN, FN_TX1,
		GP_10_17_FN, FN_RTS1_N,
		GP_10_16_FN, FN_CTS1_N,
		GP_10_15_FN, FN_SCK1,
		GP_10_14_FN, FN_RX0,
		GP_10_13_FN, FN_TX0,
		GP_10_12_FN, FN_RTS0_N,
		GP_10_11_FN, FN_CTS0_N,
		GP_10_10_FN, FN_SCK0,
		GP_10_9_FN, FN_IP6_7,
		GP_10_8_FN, FN_IP6_6,
		GP_10_7_FN, FN_HCTS1_N,
		GP_10_6_FN, FN_IP6_5,
		GP_10_5_FN, FN_IP6_4,
		GP_10_4_FN, FN_IP6_3,
		GP_10_3_FN, FN_IP6_2,
		GP_10_2_FN, FN_HRTS0_N,
		GP_10_1_FN, FN_IP6_1,
		GP_10_0_FN, FN_IP6_0 }
	},
	{ PINMUX_CFG_REG("GPSR11", 0xE6060030, 32, 1) {
		0, 0,
		0, 0,
		GP_11_29_FN, FN_AVS2,
		GP_11_28_FN, FN_AVS1,
		GP_11_27_FN, FN_ADICHS2,
		GP_11_26_FN, FN_ADICHS1,
		GP_11_25_FN, FN_ADICHS0,
		GP_11_24_FN, FN_ADIDATA,
		GP_11_23_FN, FN_ADICS_SAMP,
		GP_11_22_FN, FN_ADICLK,
		GP_11_21_FN, FN_IP7_20,
		GP_11_20_FN, FN_IP7_19,
		GP_11_19_FN, FN_IP7_18,
		GP_11_18_FN, FN_IP7_17,
		GP_11_17_FN, FN_IP7_16,
		GP_11_16_FN, FN_IP7_15_14,
		GP_11_15_FN, FN_IP7_13_12,
		GP_11_14_FN, FN_IP7_11_10,
		GP_11_13_FN, FN_IP7_9_8,
		GP_11_12_FN, FN_SD0_WP,
		GP_11_11_FN, FN_SD0_CD,
		GP_11_10_FN, FN_SD0_DAT3,
		GP_11_9_FN, FN_SD0_DAT2,
		GP_11_8_FN, FN_SD0_DAT1,
		GP_11_7_FN, FN_SD0_DAT0,
		GP_11_6_FN, FN_SD0_CMD,
		GP_11_5_FN, FN_SD0_CLK,
		GP_11_4_FN, FN_IP7_7,
		GP_11_3_FN, FN_IP7_6,
		GP_11_2_FN, FN_IP7_5_4,
		GP_11_1_FN, FN_IP7_3_2,
		GP_11_0_FN, FN_IP7_1_0 }
	},
	{ PINMUX_CFG_REG_VAR("IPSR0", 0xE6060040, 32,
			     4, 4,
			     1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP0_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP0_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* IP0_23 [1] */
		FN_DU0_DB7_C5, 0,
		/* IP0_22 [1] */
		FN_DU0_DB6_C4, 0,
		/* IP0_21 [1] */
		FN_DU0_DB5_C3, 0,
		/* IP0_20 [1] */
		FN_DU0_DB4_C2, 0,
		/* IP0_19 [1] */
		FN_DU0_DB3_C1, 0,
		/* IP0_18 [1] */
		FN_DU0_DB2_C0, 0,
		/* IP0_17 [1] */
		FN_DU0_DB1, 0,
		/* IP0_16 [1] */
		FN_DU0_DB0, 0,
		/* IP0_15 [1] */
		FN_DU0_DG7_Y3_DATA15, 0,
		/* IP0_14 [1] */
		FN_DU0_DG6_Y2_DATA14, 0,
		/* IP0_13 [1] */
		FN_DU0_DG5_Y1_DATA13, 0,
		/* IP0_12 [1] */
		FN_DU0_DG4_Y0_DATA12, 0,
		/* IP0_11 [1] */
		FN_DU0_DG3_C7_DATA11, 0,
		/* IP0_10 [1] */
		FN_DU0_DG2_C6_DATA10, 0,
		/* IP0_9 [1] */
		FN_DU0_DG1_DATA9, 0,
		/* IP0_8 [1] */
		FN_DU0_DG0_DATA8, 0,
		/* IP0_7 [1] */
		FN_DU0_DR7_Y9_DATA7, 0,
		/* IP0_6 [1] */
		FN_DU0_DR6_Y8_DATA6, 0,
		/* IP0_5 [1] */
		FN_DU0_DR5_Y7_DATA5, 0,
		/* IP0_4 [1] */
		FN_DU0_DR4_Y6_DATA4, 0,
		/* IP0_3 [1] */
		FN_DU0_DR3_Y5_DATA3, 0,
		/* IP0_2 [1] */
		FN_DU0_DR2_Y4_DATA2, 0,
		/* IP0_1 [1] */
		FN_DU0_DR1_DATA1, 0,
		/* IP0_0 [1] */
		FN_DU0_DR0_DATA0, 0 }
	},
	{ PINMUX_CFG_REG_VAR("IPSR1", 0xE6060044, 32,
			     4, 4,
			     1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP1_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP1_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* IP1_23 [1] */
		0, 0,
		/* IP1_22 [1] */
		FN_A25, FN_SSL,
		/* IP1_21 [1] */
		FN_A24, FN_SPCLK,
		/* IP1_20 [1] */
		FN_A23, FN_IO3,
		/* IP1_19 [1] */
		FN_A22, FN_IO2,
		/* IP1_18 [1] */
		FN_A21, FN_MISO_IO1,
		/* IP1_17 [1] */
		FN_A20, FN_MOSI_IO0,
		/* IP1_16 [1] */
		FN_DU1_DG7_Y3_DATA11, 0,
		/* IP1_15 [1] */
		FN_DU1_DG6_Y2_DATA10, 0,
		/* IP1_14 [1] */
		FN_DU1_DG5_Y1_DATA9, 0,
		/* IP1_13 [1] */
		FN_DU1_DG4_Y0_DATA8, 0,
		/* IP1_12 [1] */
		FN_DU1_DG3_C7_DATA7, 0,
		/* IP1_11 [1] */
		FN_DU1_DG2_C6_DATA6, 0,
		/* IP1_10 [1] */
		FN_DU1_DR7_DATA5, 0,
		/* IP1_9 [1] */
		FN_DU1_DR6_DATA4, 0,
		/* IP1_8 [1] */
		FN_DU1_DR5_Y7_DATA3, 0,
		/* IP1_7 [1] */
		FN_DU1_DR4_Y6_DATA2, 0,
		/* IP1_6 [1] */
		FN_DU1_DR3_Y5_DATA1, 0,
		/* IP1_5 [1] */
		FN_DU1_DR2_Y4_DATA0, 0,
		/* IP1_4 [1] */
		FN_DU0_CDE, 0,
		/* IP1_3 [1] */
		FN_DU0_DISP, 0,
		/* IP1_2 [1] */
		FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, 0,
		/* IP1_1 [1] */
		FN_DU0_EXVSYNC_DU0_VSYNC, 0,
		/* IP1_0 [1] */
		FN_DU0_EXHSYNC_DU0_HSYNC, 0 }
	},
	{ PINMUX_CFG_REG_VAR("IPSR2", 0xE6060048, 32,
			     4, 4,
			     4, 3, 1,
			     1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP2_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP2_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* IP2_23_20 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP2_19_17 [3] */
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP2_16 [1] */
		FN_VI2_FIELD, FN_AVB_TXD2,
		/* IP2_15 [1] */
		FN_VI2_D11_Y3, FN_AVB_TXD1,
		/* IP2_14 [1] */
		FN_VI2_D10_Y2, FN_AVB_TXD0,
		/* IP2_13 [1] */
		FN_VI2_D9_Y1, FN_AVB_TX_EN,
		/* IP2_12 [1] */
		FN_VI2_D8_Y0, FN_AVB_TXD3,
		/* IP2_11 [1] */
		FN_VI2_D7_C7, FN_AVB_COL,
		/* IP2_10 [1] */
		FN_VI2_D6_C6, FN_AVB_RX_ER,
		/* IP2_9 [1] */
		FN_VI2_D5_C5, FN_AVB_RXD7,
		/* IP2_8 [1] */
		FN_VI2_D4_C4, FN_AVB_RXD6,
		/* IP2_7 [1] */
		FN_VI2_D3_C3, FN_AVB_RXD5,
		/* IP2_6 [1] */
		FN_VI2_D2_C2, FN_AVB_RXD4,
		/* IP2_5 [1] */
		FN_VI2_D1_C1, FN_AVB_RXD3,
		/* IP2_4 [1] */
		FN_VI2_D0_C0, FN_AVB_RXD2,
		/* IP2_3 [1] */
		FN_VI2_VSYNC_N, FN_AVB_RXD1,
		/* IP2_2 [1] */
		FN_VI2_HSYNC_N, FN_AVB_RXD0,
		/* IP2_1 [1] */
		FN_VI2_CLKENB, FN_AVB_RX_DV,
		/* IP2_0 [1] */
		FN_VI2_CLK, FN_AVB_RX_CLK }
	},
	{ PINMUX_CFG_REG_VAR("IPSR3", 0xE606004C, 32,
			     4, 4,
			     4, 4,
			     1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP3_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP3_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* IP3_23_20 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP3_19_16 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP3_15 [1] */
		0, 0,
		/* IP3_14 [1] */
		FN_VI3_D11_Y3, FN_AVB_AVTP_MATCH,
		/* IP3_13 [1] */
		FN_VI3_D9_Y1, FN_AVB_GTXREFCLK,
		/* IP3_12 [1] */
		FN_VI3_D8_Y0, FN_AVB_CRS,
		/* IP3_11 [1] */
		FN_VI3_D7_C7, FN_AVB_PHY_INT,
		/* IP3_10 [1] */
		FN_VI3_D6_C6, FN_AVB_MAGIC,
		/* IP3_9 [1] */
		FN_VI3_D5_C5, FN_AVB_LINK,
		/* IP3_8 [1] */
		FN_VI3_D4_C4, FN_AVB_MDIO,
		/* IP3_7 [1] */
		FN_VI3_D3_C3, FN_AVB_MDC,
		/* IP3_6 [1] */
		FN_VI3_D2_C2, FN_AVB_GTX_CLK,
		/* IP3_5 [1] */
		FN_VI3_D1_C1, FN_AVB_TX_ER,
		/* IP3_4 [1] */
		FN_VI3_D0_C0, FN_AVB_TXD7,
		/* IP3_3 [1] */
		FN_VI3_VSYNC_N, FN_AVB_TXD6,
		/* IP3_2 [1] */
		FN_VI3_HSYNC_N, FN_AVB_TXD5,
		/* IP3_1 [1] */
		FN_VI3_CLKENB, FN_AVB_TXD4,
		/* IP3_0 [1] */
		FN_VI3_CLK, FN_AVB_TX_CLK }
	},
	{ PINMUX_CFG_REG_VAR("IPSR4", 0xE6060050, 32,
			     4, 3, 1,
			     1, 1, 1, 2, 2, 2,
			     2, 2, 2, 2, 2, 1, 2, 1, 1) {
		/* IP4_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP4_27_25 [3] */
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP4_24 [1] */
		FN_VI4_FIELD, FN_VI3_D15_Y7,
		/* IP4_23 [1] */
		FN_VI4_D11_Y3, FN_VI3_D14_Y6,
		/* IP4_22 [1] */
		FN_VI4_D10_Y2, FN_VI3_D13_Y5,
		/* IP4_21 [1] */
		FN_VI4_D9_Y1, FN_VI3_D12_Y4,
		/* IP4_20_19 [2] */
		FN_VI4_D8_Y0, FN_VI0_D23_R7, FN_VI2_D15_Y7, 0,
		/* IP4_18_17 [2] */
		FN_VI4_D7_C7, FN_VI0_D22_R6, FN_VI2_D14_Y6, 0,
		/* IP4_16_15 [2] */
		FN_VI4_D6_C6, FN_VI0_D21_R5, FN_VI2_D13_Y5, 0,
		/* IP4_14_13 [2] */
		FN_VI4_D5_C5, FN_VI0_D20_R4, FN_VI2_D12_Y4, 0,
		/* IP4_12_11 [2] */
		FN_VI4_D4_C4, FN_VI0_D19_R3, FN_VI1_D15_G7_Y7, 0,
		/* IP4_10_9 [2] */
		FN_VI4_D3_C3, FN_VI0_D18_R2, FN_VI1_D14_G6_Y6, 0,
		/* IP4_8_7 [2] */
		FN_VI4_D2_C2, 0, FN_VI0_D17_R1, FN_VI1_D13_G5_Y5,
		/* IP4_6_5 [2] */
		FN_VI4_D1_C1, FN_VI0_D16_R0, FN_VI1_D12_G4_Y4, 0,
		/* IP4_4 [1] */
		FN_VI4_D0_C0, FN_VI0_D15_G7_Y7,
		/* IP4_3_2 [2] */
		FN_VI4_VSYNC_N, FN_VI0_D14_G6_Y6, 0, 0,
		/* IP4_1 [1] */
		FN_VI4_HSYNC_N, FN_VI0_D13_G5_Y5,
		/* IP4_0 [1] */
		FN_VI4_CLKENB, FN_VI0_D12_G4_Y4 }
	},
	{ PINMUX_CFG_REG_VAR("IPSR5", 0xE6060054, 32,
			     4, 4,
			     4, 4,
			     4, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP5_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP5_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP5_23_20 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP5_19_16 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP5_15_12 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP5_11 [1] */
		FN_VI5_D8_Y0, FN_VI1_D23_R7,
		/* IP5_10 [1] */
		FN_VI5_D7_C7, FN_VI1_D22_R6,
		/* IP5_9 [1] */
		FN_VI5_D6_C6, FN_VI1_D21_R5,
		/* IP5_8 [1] */
		FN_VI5_D5_C5, FN_VI1_D20_R4,
		/* IP5_7 [1] */
		FN_VI5_D4_C4, FN_VI1_D19_R3,
		/* IP5_6 [1] */
		FN_VI5_D3_C3, FN_VI1_D18_R2,
		/* IP5_5 [1] */
		FN_VI5_D2_C2, FN_VI1_D17_R1,
		/* IP5_4 [1] */
		FN_VI5_D1_C1, FN_VI1_D16_R0,
		/* IP5_3 [1] */
		FN_VI5_D0_C0, FN_VI1_D15_G7_Y7_B,
		/* IP5_2 [1] */
		FN_VI5_VSYNC_N, FN_VI1_D14_G6_Y6_B,
		/* IP5_1 [1] */
		FN_VI5_HSYNC_N, FN_VI1_D13_G5_Y5_B,
		/* IP5_0 [1] */
		FN_VI5_CLKENB, FN_VI1_D12_G4_Y4_B }
	},
	{ PINMUX_CFG_REG_VAR("IPSR6", 0xE6060058, 32,
			     4, 4,
			     4, 1, 2, 1,
			     2, 2, 2, 2,
			     1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP6_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP6_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP6_23_20 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP6_19 [1] */
		0, 0,
		/* IP6_18_17 [2] */
		FN_DREQ1_N, FN_RX3, 0, 0,
		/* IP6_16 [1] */
		FN_TX3, 0,
		/* IP6_15_14 [2] */
		FN_DACK1, FN_SCK3, 0, 0,
		/* IP6_13_12 [2] */
		FN_DREQ0_N, FN_RX2, 0, 0,
		/* IP6_11_10 [2] */
		FN_DACK0, FN_TX2, 0, 0,
		/* IP6_9_8 [2] */
		FN_DRACK0, FN_SCK2, 0, 0,
		/* IP6_7 [1] */
		FN_MSIOF1_RXD, FN_HRX1,
		/* IP6_6 [1] */
		FN_MSIOF1_TXD, FN_HTX1,
		/* IP6_5 [1] */
		FN_MSIOF1_SYNC, FN_HRTS1_N,
		/* IP6_4 [1] */
		FN_MSIOF1_SCK, FN_HSCK1,
		/* IP6_3 [1] */
		FN_MSIOF0_RXD, FN_HRX0,
		/* IP6_2 [1] */
		FN_MSIOF0_TXD, FN_HTX0,
		/* IP6_1 [1] */
		FN_MSIOF0_SYNC, FN_HCTS0_N,
		/* IP6_0 [1] */
		FN_MSIOF0_SCK, FN_HSCK0 }
	},
	{ PINMUX_CFG_REG_VAR("IPSR7", 0xE606005C, 32,
			     4, 4,
			     3, 1, 1, 1, 1, 1,
			     2, 2, 2, 2,
			     1, 1, 2, 2, 2) {
		/* IP7_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP7_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		/* IP7_23_21 [3] */
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP7_20 [1] */
		FN_AUDIO_CLKB, 0,
		/* IP7_19 [1] */
		FN_AUDIO_CLKA, 0,
		/* IP7_18 [1] */
		FN_AUDIO_CLKOUT, 0,
		/* IP7_17 [1] */
		FN_SSI_SDATA4, 0,
		/* IP7_16 [1] */
		FN_SSI_WS4, 0,
		/* IP7_15_14 [2] */
		FN_SSI_SCK4, FN_TPU0TO3, 0, 0,
		/* IP7_13_12 [2] */
		FN_SSI_SDATA3, FN_TPU0TO2, 0, 0,
		/* IP7_11_10 [2] */
		FN_SSI_WS34, FN_TPU0TO1, 0, 0,
		/* IP7_9_8 [2] */
		FN_SSI_SCK34, FN_TPU0TO0, 0, 0,
		/* IP7_7 [1] */
		FN_PWM4, 0,
		/* IP7_6 [1] */
		FN_PWM3, 0,
		/* IP7_5_4 [2] */
		FN_PWM2, FN_TCLK3, FN_FSO_TOE, 0,
		/* IP7_3_2 [2] */
		FN_PWM1, FN_TCLK2, FN_FSO_CFE_1, 0,
		/* IP7_1_0 [2] */
		FN_PWM0, FN_TCLK1, FN_FSO_CFE_0, 0 }
	},
	{ },
};

const struct sh_pfc_soc_info r8a7792_pinmux_info = {
	.name = "r8a77920_pfc",
	.unlock_reg = 0xe6060000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
