/******************************* */
/* Rule Set Based Access Control */
/* Author and (c) 1999-2001:     */
/*   Amon Ott <ao@rsbac.org>     */
/* API: for Access Control       */
/* Decision Facility             */
/* Last modified: 29/Oct/2001    */
/******************************* */

#ifndef __RSBAC_ADF_H
#define __RSBAC_ADF_H

#include <linux/init.h>
#include <rsbac/types.h>
#include <rsbac/debug.h>
#include <rsbac/fs.h>

/***************************************************/
/*                   Prototypes                    */
/***************************************************/

/* Init function */
#ifdef CONFIG_RSBAC_INIT_DELAY
extern  void rsbac_init_adf(void);
#else
extern  void rsbac_init_adf(void) __init;
#endif

/* This function is the internal decision function, called from the next. */
/* It allows to ignore a certain module (last parameter), e.g. for asking */
/* all _other_ modules, but not the calling module, to avoid a circle.    */

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request_int(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t,
                                     enum  rsbac_switch_target_t);

/* This function is the official main decision function, called from the AEF. */

extern  enum rsbac_adf_req_ret_t  rsbac_adf_request(
                                     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t);

/* If the request returned granted and the operation is performed,           */
/* the following function is called by the AEF to get all aci set correctly. */
/* The second instance of target specification is the new target, if one has */
/* been created, otherwise its values are ignored.                           */
/* It returns 0 on success and an error from error.h otherwise.              */

extern  int  rsbac_adf_set_attr(     enum  rsbac_adf_request_t,
                                           rsbac_pid_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_target_t,
                                     union rsbac_target_id_t,
                                     enum  rsbac_attribute_t,
                                     union rsbac_attribute_value_t);

#include <linux/types.h>
#include <linux/dcache.h>

extern int rsbac_sec_del(struct dentry * dentry_p);

extern int rsbac_sec_trunc(struct dentry * dentry_p,
                           loff_t new_len, loff_t old_len);

extern void rsbac_symlink_redirect(struct dentry * dentry_p, char * name);

#ifdef CONFIG_RSBAC_ALLOW_DAC_DISABLE_PART
extern int rsbac_dac_part_disabled(struct dentry * dentry_p);
#endif

#endif
