/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

/* 
 * Begin Global Function Definitions
 */
_forward_ void       fc_bcopy(void *src, void *dest, unsigned long n);
_forward_ void       fc_bzero(void *src,  unsigned long size );
_forward_ int        fc_copyin(uchar *src, uchar *dst, unsigned long);
_forward_ int        fc_copyout(uchar *, uchar *, unsigned long);
_forward_ void       lpfc_mpdata_sync(fc_dev_ctl_t *p_dev_ctl, void *h, int a, int b, int c);
_forward_ void      *fc_kmem_alloc(unsigned int size);
_forward_ void       fc_kmem_free(void *obj, unsigned int size);
_forward_ void       curtime(uint32 *time);
_forward_ ulong      dfc_disable_lock(ulong p1, Simple_lock *p2);
_forward_ void       dfc_unlock_enable(ulong p1, Simple_lock *p2);
_forward_ ulong      lpfc_q_disable_lock(fc_dev_ctl_t *p_dev_ctl);
_forward_ void       lpfc_q_unlock_enable(fc_dev_ctl_t *p_dev_ctl, ulong p1);
_forward_ ulong      lpfc_mempool_disable_lock(fc_dev_ctl_t *p_dev_ctl);
_forward_ void       lpfc_mempool_unlock_enable(fc_dev_ctl_t *p_dev_ctl, ulong p1);
_forward_ int        dfc_sleep(fc_dev_ctl_t *p_dev_ctl, fcEvent_header *ep);
_forward_ int        dfc_wakeup(fc_dev_ctl_t *p_dev_ctl, fcEvent_header *ep);
_forward_ int        lpfc_DELAYMS(fc_dev_ctl_t *p_dev_ctl, int cnt);
_forward_ int        fc_fcp_bufunmap(fc_dev_ctl_t *pdev, struct sc_buf *sp);
_forward_ int        fc_bufmap(fc_dev_ctl_t *p_dev_ctl, uchar *bp, uint32 len,
                    void **phys, uint32 *cnt, void **handle);
_forward_ void       fc_bufunmap(fc_dev_ctl_t *p_dev_ctl, uchar *addr,
                    uchar *dmahandle, uint32 size);
_forward_ int        fc_fcp_bufmap(fc_dev_ctl_t *p_dev_ctl, struct sc_buf *sbp,
                    fc_buf_t *fcptr, IOCBQ *temp, ULP_BDE64 *bpl,
                    dvi_t * dev_ptr, int pend);
_forward_ void       fc_free(fc_dev_ctl_t *p_dev_ctl, MBUF_INFO *buf_info);
_forward_ int        fc_get_dds(fc_dev_ctl_t  *p_dev_ctl, uint32 *p_uio);
_forward_ int        fc_get_dds_bind(fc_dev_ctl_t  *p_dev_ctl);
_forward_ int        fc_get_dds(fc_dev_ctl_t  *p_dev_ctl, uint32 *p_uio);
_forward_ void       lpfc_scsi_selto_timeout(fc_dev_ctl_t *p, void *l1, void *l2);
_forward_ int        lpfc_copy_sense(dvi_t * dev_ptr, struct buf * bp);
_forward_ int        fc_intr(struct intr *p_ihs);
_forward_ int        fc_pcimap(fc_dev_ctl_t  *p_dev_ctl);
_forward_ ushort     fc_rdpci_cmd( fc_dev_ctl_t  *p_dev_ctl);
_forward_ uint32     fc_rdpci_32( fc_dev_ctl_t  *p_dev_ctl, uint32 offset);
_forward_ int        fc_initpci(struct dfc_info *di, fc_dev_ctl_t *p_dev_ctl);
_forward_ int        fc_readpci(struct dfc_info *di, uint32 offset, char *buf, uint32 cnt);
_forward_ int        fc_writepci(struct dfc_info *di, uint32 offset, char *buf, uint32 cnt);
_forward_ uchar     *fc_malloc(fc_dev_ctl_t *p_dev_ctl, MBUF_INFO *buf_info);
_forward_ int        fc_memmap(fc_dev_ctl_t  *p_dev_ctl);
_forward_ int        fc_unmemmap(fc_dev_ctl_t  *p_dev_ctl);
_forward_ int        lpfc_cfg_init(fc_dev_ctl_t  *p_dev_ctl);
_forward_ void       fc_wrpci_cmd( fc_dev_ctl_t  *p_dev_ctl, ushort cfg_value);
_forward_ int        i_clear(struct intr *ihs);
_forward_ int        i_init(struct intr *ihs);
_forward_ void       lpfc_fcp_error( fc_buf_t * fcptr, IOCB * cmd);
_forward_ dvi_t     *fc_alloc_devp(fc_dev_ctl_t  *, int target, fc_lun_t lun);
_forward_ int        fc_do_iodone( struct buf *bp);
_forward_ int        fc_device_changed(fc_dev_ctl_t *p, struct dev_info *dp);
_forward_ int        log_printf(int f, int type, int num, char *str, int brdno,
                                uint32 a1, uint32 a2, uint32 a3, uint32 a4);
_forward_ int        log_printf_msgblk( int brdno, msgLogDef * msg, char *str, int log_only);


_forward_ uint32     timeout(void (*func)(ulong),  struct timer_list * , uint32 );
_forward_ int        lpfc_ip_rcvsz(fc_dev_ctl_t  *p_dev_ctl);
_forward_ int        lpfc_kfree_skb(struct sk_buff *skb);
_forward_ struct sk_buff * lpfc_alloc_skb(unsigned int sz);
_forward_ void       fc_pci_dma_sync_single(struct pci_dev *hwdev, dma_addr_t h,
                            size_t size, int c);
_forward_ void      fc_write_toio(uint32 *src, uint32 *dest_io, uint32 cnt);
_forward_ void      fc_read_fromio(uint32 *src_io, uint32 *dest, uint32 cnt);
_forward_ uint32    fc_readl(uint32 *src);
_forward_ void      fc_writel(uint32 *src, uint32 value);
_forward_ int       fc_print( char * str, void * arg1, void * arg2);

