#ifndef __UWSCMD_H_
#define __UWSCMD_H_


// **********************************************************************
// * uwscmd.h                                                           *
// *                                                                    *
// * Written by Matthew DeLoera (deloera@us.ibm.com)                    *
// * (C) Copyright IBM Corporation, 1998-2001                           *
// *                                                                    *
// *  This software may be used and distributed according to the terms  *
// *  of the GNU Public License, incorporated herein by reference.      *
// **********************************************************************

// **********************************************************************
// * uwscmd.h - This header provides all global constants and data      *
// *            structs for the driver.                                 *
// *                                                                    *
// * Changes                                                            *
// * -------                                                            *
// * 01/29/2001 - Cleaned up for open source release.                   *
// * ----------------------------------------------------------------   *
// * 06/27/2002 - Added multi node support       // PHR_MULTI_4         *
// **********************************************************************


// ************
// * INCLUDES *
// ************

#include "ibmasmincludes.h"


// *****************************************************
// * LOCAL INCLUDES - NOTE THE #include AT END OF FILE *
// *****************************************************

#include "slim.h"
#include "uwioctl.h"
#define  __IBMLINUX__
#include "sysdrv.h"
#include "sysplx.h"
#include "sysscout.h"
#include "uwsrem.h"        // PHR_187116


// ***********
// * DEFINES *
// ***********

// DEVICE DRIVER MAJOR AND MINOR DEFINITIONS
#define LINUX_DD_MAJOR   6
#define LINUX_DD_MINOR   9    // build WRP122A

// POSSIBLE H/W PLATFORMS     // PHR_MULTI
#define SPTYPE_UNKNOWN  'U'
#define SPTYPE_EAGLE    'E'
#define SPTYPE_WISEMAN  'W'
#define SPTYPE_RANGER   'R'
#define SPTYPE_ASR      'A'
#define SPTYPE_JASPER   'J'
#define SPTYPE_PEARL    'P'

#define ASMTYPE_UNKNOWN  0     // PHR_MULTI_3
#define ASMTYPE_EAGLE    1     
#define ASMTYPE_WISEMAN  2     
#define ASMTYPE_RANGER   3     
#define ASMTYPE_ASR      4     
#define ASMTYPE_JASPER   5     
#define ASMTYPE_PEARL    6     

// EVENT QUEUE PARMS
#define EV_BUFFERS               10
#define EV_MAXNUMBER             0xFFFF
#define HB_BUFFER_SIZE           1024           
#define EV_BUFFER_SIZE           2048
#define SEND_BUFFER_SIZE         2048
#define RESPONSE_BUFFER_SIZE     0x2000
#define MAX_BUFF_SIZE            32768

// PID REGISTRATION TABLE PARMS
#define MAXPIDS                  16

// COMMAND TIMEOUT CONSTANTS
#define CMD_TIMEOUT              10    // 10  seconds in microseconds
#define CMD_TIMEOUT_25           25    // 25  seconds in microseconds
#define CMD_TIMEOUT_45           45    // 45  seconds in microseconds
#define CMD_TIMEOUT_240         240    // 240 seconds in microseconds

#define ASR_TIMEOUT              10    // 10  seconds in microseconds // PHR_MULTI

// DEFINES FOR INTERNALLY-GENERATED IOCtl'S
#define PID_SEND_DRVR_VER        0xC0DE1111
#define PID_OS_IS_UP             0xC0DE2222
#define PID_STOP_DRIVER          0xC0DE0000
#define PID_HEART_BEAT           0xC0DEFFFF
#define EXTERNAL_IOCTL           1
#define INTERNAL_IOCTL           2
#define QUEUED_IOCTL             3

// QUEUE PURGING SUBCOMMANDS
#define PURGE_EVENT_QUEUE             1
#define PURGE_EVENT_QUEUE_BYPID       2
#define PURGE_EVENT_QUEUE_DEREGISTER  3
#define PURGE_IOCTL_QUEUE             4
#define PURGE_SPCMD_QUEUE             5
#define PURGE_SPCMD_QUEUE_BYPID       6

// MAJOR NUMBER DEFINES
#ifndef SYSSP_MAJOR
#define SYSSP_MAJOR 0
#endif

// THIS MIGHT NOT BE NEEDED
#ifdef PDRIVER_INFO
#undef PDRIVER_INFO
#endif

// 2.2 VERSUS 2.4 KERNEL COMPATIBILITY
#if LINUX_VERSION_CODE < 132096
     #define wait_queue_head_t struct wait_queue *
     #define init_waitqueue_head(head) *(head) = NULL
#endif



// The mailbox port address is fixed at 0xE8 for the data port and 0xE9
//  for its control port.  The value of the interrupt vector must be 
//  read from the system CMOS.  The interrupt multiplexer must still 
//  be gated on.  
// The following parameters are fixed for the Ranger hardware:
//     -> I2C Data Port = E8
//     -> I2C Control Port = E9
//     -> Interrupt Multiplexer Register Select Port = EA
//     -> Interrupt Multiplexer Data Port = EB
//     -> Interrupt Multiplexer Register = 0D
//     -> Interrupt Vector ... to be read from CMOS
//
#define I2C_DATA_PORT         (pSpPrimaryNode->ioAddr)        // E8
#define I2C_CTL_PORT         ((pSpPrimaryNode->ioAddr)+1)     // E9
#define IMUX_SEL_PORT        ((pSpPrimaryNode->ioAddr)+2)     // EA
#define IMUX_CFG_PORT        ((pSpPrimaryNode->ioAddr)+3)     // EB

// The following 2 defines are used to read and write data from and 
//  to the I2C
#define PUT_I2C_DATA(uc)     WRITE_PORT_UCHAR (I2C_DATA_PORT, uc)
#define GET_I2C_DATA         READ_PORT_UCHAR  (I2C_DATA_PORT)

// Read the the I2C status from the control port 
#define GET_I2C_STATUS       READ_PORT_UCHAR  (I2C_CTL_PORT)

// The following 3 defines are used to access the interrupt multiplexer
//  register
#define PUT_IMUX_SEL(uc)     WRITE_PORT_UCHAR (IMUX_SEL_PORT, uc)
#define GET_IMUX_CFG         READ_PORT_UCHAR  (IMUX_CFG_PORT)
#define PUT_IMUX_CFG(uc)     WRITE_PORT_UCHAR (IMUX_CFG_PORT, uc)

// Masks used to manipulate the I2C control port bits
#define I2C_INTERRUPT_MASK   0x80
#define OUTPUT_PORT_FREE     0x20

// Different defines to support ISA hardware accesses
#define IMUX_KIOWA_CFG_MASK  0x0F  // IMUX mask for KIOWA
#define IMUX_MOHIC_CFG_MASK  0xF0  // IMUX mask for MOHICAN
#define CMOS_CONTROL_PORT    0x70  // system CMOS
#define CMOS_DATA_PORT       0x71  // system CMOS
#define MEM_BANK_OFFSET      0x0A  // offset to current memory bank value
#define BANK_0_ID            0x26  // switch to memory bank 0
#define SP_INT_OFFSET        0x33  // offset to service processor 


// Start of PHR_191379

#define DEF_ASR_TOGGLE   0x40
#define DEF_ASR_DISABLE  0x80

// Pearl ASR register SuperIO port addresses
#define PEARL_WRITE                         0xE06
#define PEARL_READ                          0xE07

// Pearl ASR register bit/signal assignments
#define PEARL_ASR_DISABLE_MASK               0x80  // bit 7: disable = 1, enable = 0
#define PEARL_ASR_TOGGLE_MASK                0x40  // bit 6: 0, then 1, then 0

// Jasper ASR I/O port address defines

#define JASPER_SUPERIO_BASE_ADDR                  // This is the base address where the SuperIO
                                                  // chip registers are supposed to be.  Unknown
                                                  // at this time.
#define JASPER_ASR_REG_OFFSET                0x38 // Offset from SIO base addr to ASR regs.
// Topaz ASR register bit/signal assignments
#define JASPER_ASR_DISABLE_MASK              0x01 // bit 0: disable = 1, enable = 0
#define JASPER_ASR_TOGGLE_MASK               0x02 // bit 1: 0, then 1, then 0

// End of PHR_191379


// ***********
// * STRUCTS *
// ***********

// CIRCULAR EVENT BUFFER NODE
typedef struct _eventReceived
{
   u_short        EvNumber;
   void          *pEvBuffer;
   u_short        EvLength;
} EVRCVD;

// GLOBAL PID TABLE NODE
typedef struct
{
     unsigned int PID;
     unsigned int valid;
} PIDNODE;

// COMMAND/EVENT QUEUE NODE
typedef struct _WORK_BLOCK
{
     void              *pNextBlock;          // pointer to the next node in the "queue"
     void              *pPrevBlock;          // pointer to the preceding node in the "queue"
     PDD_IOCTL_INFO     pDDIoctlInfo;
     UINT               PID;                 // the associated PID for this request
     UCHAR             *pBuffer;
     int                bufferLength;
     wait_queue_head_t  pWaitQueueRun;     
     wait_queue_head_t  pWaitQueueCancel; 
     wait_queue_head_t  pBlock;
     u_int              completionCode;      // MARKS OPERATING STATE OF THIS COMMAND BLOCK
     unsigned long      flags;
} WORK_BLOCK, *PWORK_BLOCK;

// ADDITIONAL NAMES FOR THIS USER-DEFINED TYPE
typedef WORK_BLOCK    CMD_BLOCK;
typedef WORK_BLOCK    EVENT_BLOCK;

typedef PWORK_BLOCK   PCMD_BLOCK;
typedef PWORK_BLOCK   PEVENT_BLOCK;

// GLOBAL DRIVER INFORMATION STRUCTURE
typedef struct _driverInfo
{
     // EXTERNAL THREAD MANANGEMENT
     PIDNODE PIDtable [MAXPIDS];      // Table of PID's of calling applications

     // CONFIGURATION-RELATED MEMBERS
     short  intVector;                // interrupt vector number
     PUCHAR ioAddr;                   // I/O ports for device
     PUCHAR baseAddr;                 // Physical address of board memory
     long   memSize;                  // size of board memory
     PUCHAR vBaseAddr;                // Virtual address of board memory
     int    devPresent;               // device present
     USHORT ASRbaseaddress;

     // Start of PHR_187116
     PUCHAR              pRemoteDataBaseAddr;    // base PCI address + the starting offset of the Remote data (0x4AC000)
     PREMOTE_INPUT_DATA  pRemoteDataStart;       // Starting address of Q
     PREMOTE_INPUT_DATA  pRemoteDataEnd;         // Ending address of Q
     PREMOTE_INPUT_DATA  pRemoteDataIn;          // Pointer to next incoming data in Q
     PREMOTE_INPUT_DATA  pRemoteDataOut;         // Pointer to next outgoing data in Q
     REMOTE_INPUT_DATA   CurrentRemoteInput;
     ULONG               RemoteInputCount;       // Total number of remote data elements in Q
     USHORT              PrevMouseButtonState;   // Previous state of the remote mouse button
     wait_queue_head_t   pRmtDataWaitQueue;      // Wait queue used to wait for remote data events
     // End of PHR_187116

     // DDINST HARDWARE DETECTION FLAGS
     //UCHAR  IsASR, IsRanger, IsWiseman, IsEagle, IsJasperASR, IsPearlASR;     // PHR_191379
     int AsmType;

     // SPINLOCKS
     spinlock_t CmdQueueLock;         
     spinlock_t EventQueueLock; 
     spinlock_t RemoteDataLock;       // PHR_187116

     // QUEUE-RELATED RESOURCES
     void   *EventQueue;              // Pointer to the head of the event queue
     void   *CmdQueue;                // Pointer to the head of the command queue
     void   *RemoteDataQueue;         // Pointer to the head of the Remote mouse/keyboard data queue  // PHR_187116

     // SLIM MACHINE-RELATED MEMBERS
     SLIM_STATUS receiveSlim;         // Receive state machine for events and comands
     SLIM_STATUS sendSlim;            // Send state machine for events and commands

     // EVENT-RELATED MEMBERS
     long    MagicNumber;             // Magic number kept at DD
     int     EvBufIndex;              // Event buffer index of next available buffer
     EVRCVD  EvRcvd[EV_BUFFERS];      // Circular evemt buffer where all received events are automatically copied

     // TIMEOUT-RELATED MEMBERS
     struct  timer_list CommandTimer; // Command timer
     struct  timer_list ASRtimer;     // ASR timer
     struct  timer_list RevHBtimer;   // Reverse Heart Beat timer

     PCMD_BLOCK  pActiveCmdBlk;       // PHR_MULTI    Active command block
     PCMD_BLOCK  pActiveRHBBlk;       // PHR_MULTI Active Reverse Heart Beat cmd blk
     PCMD_BLOCK  pHB_Block;           // PHR_MULTI_2  Heart Beat command block

     // INTERNAL COMMAND-RELATED MEMBERS
     UCHAR  *pSpResponseBuffer;       // PHR_MULTI
     UCHAR  *pSpSendBuffer;           // PHR_174969

} DRIVER_INFO, *PDRIVER_INFO;

// ONLY DECLARE GLOBAL DATA STRUCTURES IN uwsConfg.c
#ifndef UwsConfg_c
     extern int           NumSpNodes;
     extern int           ShuttingDown;                          
     extern PDRIVER_INFO  pSpNodeArray;        // ARRAY OF PDRIVER_INFO STRUCTS
     extern PDRIVER_INFO  pSpPrimaryNode;      // PRIMARY NODE POINTER            
     extern struct        pci_dev *PciDev;

     extern struct file_operations sysSp_fops; // GLOBAL ENTRY POINT REGISTRATION TABLE
#endif


// *******************************************************************************
// * PROTOTYPES - I revised this section because only selected routines actually *
// *              need to be exported from each module. The symbols representing *
// *              the modules are as follows :                                   *
// *                                                                             *
// * #ifdef UwsAsr_c                                                             *
// * #ifdef UwsCmd_c                                                             *
// * #ifdef UwsConfg_c                                                           *
// * #ifdef UwsEvent_c                                                           *
// * #ifdef UwsIoctl_c                                                           *
// * #ifdef UwsIsa_c                                                             *
// * #ifdef UwsQueue_c                                                           *
// * #ifdef UwsPci_c                                                             *
// * #ifdef UwsUtil_c                                                            *
// *******************************************************************************

// ************
// * uwscmd.c *
// ************

#ifndef UwsCmd_c
     extern int iSysSP_Major;
     extern int DBG_NOSHUTDOWN;
     extern int DBG_IRQOVERRIDE;
     extern int DBG_SIGNALS;
     extern int DBG_FUNCENTEXT;
     extern int DBG_PCIDEBUG;
     extern int DBG_TIMER;
     extern int DBG_LOCKS;
     extern int DBG_BLOCKS;
     extern int DBG_HB;
     extern int DBG_DEBUG;
     extern int DBG_MULTI;
     extern int DBG_QUEUES;
     extern int DBG_IOCTL;
     extern int DBG_INIT;
     extern int DBG_CMDTIMEOUT;
     extern int DBG_SHUTDOWN;
     extern int DBG_EVENTS;
     extern int DBG_IRQ;
     extern int DBG_ISADEBUG;
     extern int DBG_SLIM;
     extern int DBG_REV_HB;
     extern int DBG_FORCEASR;
     extern int DBG_ASR_TEST;
     extern int DBG_DDINST;
     extern int DBG_ASR;
     extern int DBG_PHR;
     extern int DBG_MOUSE;
#else
     static int iSysSP_Major    = SYSSP_MAJOR;
     static int DBG_NOSHUTDOWN  = 0;
     static int DBG_IRQOVERRIDE = 0;
     static int DBG_SIGNALS     = 0;
     static int DBG_FUNCENTEXT  = 0;
     static int DBG_PCIDEBUG    = 0;
     static int DBG_TIMER       = 0;
     static int DBG_LOCKS       = 0;
     static int DBG_BLOCKS      = 0;
     static int DBG_HB          = 0;
     static int DBG_DEBUG       = 0;
     static int DBG_MULTI       = 0;
     static int DBG_QUEUES      = 0;
     static int DBG_IOCTL       = 0;
     static int DBG_INIT        = 0;
     static int DBG_CMDTIMEOUT  = 0;
     static int DBG_SHUTDOWN    = 0;
     static int DBG_EVENTS      = 0;
     static int DBG_IRQ         = 0;
     static int DBG_ISADEBUG    = 0;
     static int DBG_SLIM        = 0;
     static int DBG_REV_HB      = 0;
     static int DBG_FORCEASR    = 0;
     static int DBG_ASR_TEST    = 0;
     static int DBG_DDINST      = 0;
     static int DBG_ASR         = 0;
     static int DBG_PHR         = 0;
     static int DBG_MOUSE       = 0; 

     #if LINUX_VERSION_CODE >= 132105
          MODULE_LICENSE("GPL");
          MODULE_DESCRIPTION("IBM ASM VERSION 6.9 BUILD ID WRP122A");
          MODULE_AUTHOR("IBM SERVICE PROCESSOR DEVICE DRIVER DEVELOPMENT TEAM");
     #endif

     // REGISTER AS MODULE PARAMETERS
     MODULE_PARM(iSysSP_Major, "i");
     MODULE_PARM_DESC(iSysSP_Major, "ibmasm's major number");
     MODULE_PARM(DBG_NOSHUTDOWN, "i");
     MODULE_PARM_DESC(DBG_NOSHUTDOWN,  "Disable sending OS Shutdown message");
     MODULE_PARM(DBG_IRQOVERRIDE, "i");
     MODULE_PARM_DESC(DBG_IRQOVERRIDE, "Manual IRQ value override");
     MODULE_PARM(DBG_SIGNALS, "i");
     MODULE_PARM_DESC(DBG_SIGNALS,     "DEBUGMSG: Indicates interruption by signals");
     MODULE_PARM(DBG_FUNCENTEXT, "i");
     MODULE_PARM_DESC(DBG_FUNCENTEXT,  "DEBUGMSG: Function entry and exit");
     MODULE_PARM(DBG_PCIDEBUG, "i");
     MODULE_PARM_DESC(DBG_PCIDEBUG,    "DEBUGMSG: PCI configuration");
     MODULE_PARM(DBG_TIMER, "i");
     MODULE_PARM_DESC(DBG_TIMER,       "DEBUGMSG: Timeout functionality");
     MODULE_PARM(DBG_LOCKS, "i");
     MODULE_PARM_DESC(DBG_LOCKS,       "DEBUGMSG: Spinlock activity");
     MODULE_PARM(DBG_BLOCKS, "i");
     MODULE_PARM_DESC(DBG_BLOCKS,      "DEBUGMSG: Blocking/sleeping/wakeup");
     MODULE_PARM(DBG_HB, "i");
     MODULE_PARM_DESC(DBG_HB,          "DEBUGMSG: Heartbeat task activity");
     MODULE_PARM(DBG_DEBUG, "i");
     MODULE_PARM_DESC(DBG_DEBUG,       "DEBUGMSG: Miscell. debug messages");
     MODULE_PARM(DBG_MULTI, "i");
     MODULE_PARM_DESC(DBG_MULTI,       "DEBUGMSG: Multi Node debug messages");
     MODULE_PARM(DBG_QUEUES , "i");
     MODULE_PARM_DESC(DBG_QUEUES,      "DEBUGMSG: Queue management");
     MODULE_PARM(DBG_IOCTL, "i");
     MODULE_PARM_DESC(DBG_IOCTL,       "DEBUGMSG: IOCtl processing");
     MODULE_PARM(DBG_INIT, "i");
     MODULE_PARM_DESC(DBG_INIT,        "DEBUGMSG: Driver loading/init.");
     MODULE_PARM(DBG_CMDTIMEOUT, "i");
     MODULE_PARM_DESC(DBG_CMDTIMEOUT,  "DEBUGMSG: Internal SP command timeouts");
     MODULE_PARM(DBG_SHUTDOWN, "i");
     MODULE_PARM_DESC(DBG_SHUTDOWN,    "DEBUGMSG: Driver unloading");
     MODULE_PARM(DBG_EVENTS, "i");
     MODULE_PARM_DESC(DBG_EVENTS,      "DEBUGMSG: Event processing");
     MODULE_PARM(DBG_IRQ, "i");
     MODULE_PARM_DESC(DBG_IRQ,         "DEBUGMSG: Interrupt handling");
     MODULE_PARM(DBG_ISADEBUG, "i");
     MODULE_PARM_DESC(DBG_ISADEBUG,    "DEBUGMSG: ISA configuration");
     MODULE_PARM(DBG_SLIM, "i");
     MODULE_PARM_DESC(DBG_SLIM,        "DEBUGMSG: SLIM state automata");
     MODULE_PARM(DBG_REV_HB, "i");
     MODULE_PARM_DESC(DBG_REV_HB,      "DEBUGMSG: Reverse Heart Beat Path");
     MODULE_PARM(DBG_FORCEASR, "i");
     MODULE_PARM_DESC(DBG_FORCEASR,    "DEBUGMSG: Force to ASR mode");
     MODULE_PARM(DBG_ASR_TEST, "i");
     MODULE_PARM_DESC(DBG_ASR_TEST,     "Tests ASR functionality");
     MODULE_PARM(DBG_DDINST, "i");
     MODULE_PARM_DESC(DBG_DDINST,      "DEBUGMSG: DDINST-related messages");
     MODULE_PARM(DBG_ASR, "i");
     MODULE_PARM_DESC(DBG_ASR,         "DEBUGMSG: ASR-related messages");
     MODULE_PARM(DBG_PHR, "i");
     MODULE_PARM_DESC(DBG_PHR,         "DEBUGMSG: PHR-Specific log points");
     MODULE_PARM(DBG_MOUSE, "i");
     MODULE_PARM_DESC(DBG_MOUSE,       "DEBUGMSG: KERNEL 2.4 log points");
#endif

// *********************
// * END OF PROTOTYPES *
// *********************

#ifdef UwsConfg_c
     #include "ddinst.h"
#endif

#endif


