/* ld script to make i386 Linux kernel
 * Written by Martin Mares <mj@atrey.karlin.mff.cuni.cz>;
 */
OUTPUT_FORMAT("elf32-i386", "elf32-i386", "elf32-i386")
OUTPUT_ARCH(i386)
ENTRY(_start)
SECTIONS
{
  . = PAGE_OFFSET_RAW + 0x100000;
  .text.startup : {
	BYTE(0xEA) /* jmp far */
	LONG(startup_32 + __KERNEL_TEXT_OFFSET - PAGE_OFFSET_RAW)
	SHORT(__KERNEL_CS)
	}

  . = ALIGN(32);
  _data = .;
  .data : {			/* Data */
	*(.data)
	CONSTRUCTORS
	}

  . = ALIGN(32);
  .data.cacheline_aligned : { *(.data.cacheline_aligned) }

  . = ALIGN(8192);
  .data.init_task : { *(.data.init_task) }

  . = ALIGN(4096);
  .data.page_aligned : {
	*(.data.swapper_pg_dir)
	*(.data.pg0)
	*(.data.pg1)
	*(.data.pg2)
	}

  _edata = .;			/* End of data section */

  __bss_start = .;		/* BSS */
  .bss : {
	*(.bss)
	LONG(0)
	} 
  __bss_end = . ;

  . = ALIGN(4096);		/* Init code and data */
  __init_begin = .;
  .data.init : { *(.data.init) }
  . = ALIGN(16);
  __setup_start = .;
  .setup.init : { *(.setup.init) }
  __setup_end = .;
  __kdb_initcall_start = .;
  .kdb_initcall.init : { *(.kdb_initcall.init) }
  __kdb_initcall_end = .;
  __initcall_start = .;
  .initcall.init : { *(.initcall.init) }
  __initcall_end = .;

#ifdef CONFIG_GRKERNSEC_PAX_KERNEXEC
  __text_init_start = .;
  .text.init (. - __KERNEL_TEXT_OFFSET) : AT (__text_init_start) {
	*(.text.init)
	. = ALIGN(4*1024*1024) - 1;
	BYTE(0)
	}
  __init_end = . + __KERNEL_TEXT_OFFSET;

/*
 * PaX: this must be kept in synch with the KERNEL_CS base
 * in the GDTs in arch/i386/kernel/head.S
 */
  _text = .;			/* Text and read-only data */
  .text : AT (. + __KERNEL_TEXT_OFFSET) {
#else
  .text.init : { *(.text.init) }
  . = ALIGN(4096);
  __init_end = .;
  _text = .;			/* Text and read-only data */
  .text : {
#endif

	*(.text)
	*(.fixup)
	*(.gnu.warning)
	} = 0x9090

  _etext = .;			/* End of text section */
  . = ALIGN(4096);
  . += __KERNEL_TEXT_OFFSET;
  .rodata.page_aligned : {
	*(.rodata.empty_zero_page)
	*(.rodata.idt)
	}
  .rodata : { *(.rodata) *(.rodata.*) }
  .kstrtab : { *(.kstrtab) }

  . = ALIGN(16);		/* Exception table */
  __start___ex_table = .;
  __ex_table : { *(__ex_table) }
  __stop___ex_table = .;

  __start___ksymtab = .;	/* Kernel symbol table */
  __ksymtab : { *(__ksymtab) }
  __stop___ksymtab = .;

  __start___kallsyms = .;	/* All kernel symbols */
  __kallsyms : { *(__kallsyms) }
  __stop___kallsyms = .;

#ifdef CONFIG_GRKERNSEC_PAX_KERNEXEC
  _end = ALIGN(4*1024*1024);
#else
  _end = .;
#endif

  /* Sections to be discarded */
  /DISCARD/ : {
	*(.text.exit)		/* Remove this line if you have linking errors complain about .text.exit */
	*(.data.exit)
	*(.exitcall.exit)
	*(.kdb_exitcall.exit)
	}

  /* Stabs debugging sections.  */
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment 0 : { *(.comment) }
}
