/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

#include <linux/init.h>
#include "fc_os.h"
#include "fc_hw.h"
#include "fc.h"
#include "fcmsg.h"

/*
# Verbosity:  only turn this flag on if you are willing to risk being
# deluged with LOTS of information.
# You can set a bit mask to record specific types of verbose messages:
#
# LOG_ELS                       0x1        ELS events
# LOG_DISCOVERY                 0x2        Link discovery events
# LOG_MBOX                      0x4        Mailbox events
# LOG_INIT                      0x8        Initialization events
# LOG_LINK_EVENT                0x10       Link events
# LOG_IP                        0x20       IP traffic history
# LOG_FCP                       0x40       FCP traffic history
# LOG_NODE                      0x80       Node table events
# LOG_MISC                      0x400      Miscellaneous events
# LOG_SLI                       0x800      SLI events
# LOG_CHK_COND                  0x1000     FCP Check condition flag
# LOG_ALL_MSG                   0x1fff     LOG all messages
*/
int  lpfc_log_verbose  =0;

/*
# Setting log-only to 0 causes log messages to be printed on the 
# console and to be logged to syslog (which may send them to the 
# console again if it's configured to do so). 
# Setting log-only to 1 causes log messages to go to syslog only.
*/
int  lpfc_log_only  =0;

/*
# lun-queue-depth:  the default value lpfc will use to limit
# the number of outstanding commands per FCP LUN.  This value is
# global, affecting each LUN recognized by the driver.
*/
int lpfc_lun_queue_depth =30;

/*
# lpfc_lun_skip : Is a LINUX OS parameter to support LUN skipping / no LUN
# If this is set to 1, lpfc will fake out the LINUX scsi layer to allow
# it to detect all LUNs if there are LUN holes on a device.
*/
int lpfc_lun_skip=0;

/*
# tgt-queue-depth:  the default value lpfc will use to limit
# the number of outstanding commands per FCP target.  This value is
# global, affecting each target recognized by the driver.
*/
int lpfc_tgt_queue_depth =0;

/*
# no-device-delay [0 or 1 to 30] - determines the length of
# the interval between deciding to fail back an I/O because there is no way
# to communicate with its particular device (e.g., due to device failure) and
# the actual fail back.  A value of zero implies no delay whatsoever.
# Cautions:  (1)  This value is in seconds.  
# (2)  Setting a long delay value may permit I/O to build up,
# each with a pending timeout, which could result in the exhaustion of
# critical LINUX kernel resources.
#
# Note that this value can have an impact on the speed with which a
# system can shut down with I/Os pending and with the HBA not able to
# communicate with the loop or fabric, e.g., with a cable pulled.
*/
int  lpfc_no_device_delay  =1;

/*
# +++ Variables relating to IP networking support. +++
*/

/*
# network-on:  true (1) if networking is enabled, false (0) if not
*/
int lpfc_network_on  = 0;

/*
# xmt-que-size:  size of the transmit queue for mbufs (128 - 10240)
*/
int lpfc_xmt_que_size  = 256;

/*
# +++ Variables common to both SCSI (FCP) and IP networking support. +++
*/

/*
# Some disk devices have a "select ID" or "select Target" capability.
# From a protocol standpoint "select ID" usually means select the
# Fibre channel "ALPA".  In the FC-AL Profile there is an "informative
# annex" which contains a table that maps a "select ID" (a number
# between 0 and 7F) to an ALPA.  By default, for compatibility with
# older drivers, the lpfc driver scans its ALPA map from low ALPA
# to high ALPA.
#
# Turning on the scan-down variable (on  = 1, off = 0) will
# cause the lpfc driver to use an inverted ALPA map, effectively
# scanning ALPAs from high to low as specified in the FC-AL annex.  
# A value of 2, will also cause target assignment in a private loop
# environment to be based on the ALPA. Persistent bindings should NOT be
# used if scan-down is 2.
#
# (Note: This "select ID" functionality is a LOOP ONLY characteristic
# and will not work across a fabric.)
*/
int  lpfc_scandown  =2;

/*
# Determine how long the driver will wait to begin linkdown processing
# when a cable has been pulled or the link has otherwise become
# inaccessible, 1 - 255 secs.  Linkdown processing includes failing back 
# cmds to the target driver that have been waiting around for the link
# to come back up.  There's a tradeoff here:  small values of the timer
# cause the link to appear to "bounce", while large values of the
# timer can delay failover in a fault tolerant environment. Units are in
# seconds. A value of 0 means never failback cmds until the link comes up.
*/
int  lpfc_linkdown_tmo  =30;

/*
# If set, nodev-holdio will hold all I/O errors on devices that disappear
# until they come back. Default is 0, return errors with no-device-delay
*/
int  lpfc_nodev_holdio  =0;

/*
# If set, nodev-tmo will hold all I/O errors on devices that disappear
# until the timer expires. Default is 0, return errors with no-device-delay.
*/
int  lpfc_nodev_tmo  =30;

/*
# Use no-device-delay to delay FCP RSP errors and certain check conditions
*/
int lpfc_delay_rsp_err =1;

/*
# Treat certain check conditions as a FCP error
*/
int lpfc_check_cond_err =1;

/*
# num-iocbs:  number of iocb buffers to allocate (128 to 10240)
*/
int lpfc_num_iocbs  = 2048;

/*
# num-bufs:  number of ELS buffers to allocate (64 to 4096)
# ELS buffers are needed to support Fibre channel Extended Link Services.
# Also used for SLI-2 FCP buffers, one per FCP command, and Mailbox commands.
*/
int  lpfc_num_bufs  = 4096;

/*
# topology:  link topology for init link
#            0x0  = attempt loop mode then point-to-point
#            0x02 = attempt point-to-point mode only
#            0x04 = attempt loop mode only 
#            0x06 = attempt point-to-point mode then loop
# Set point-to-point mode if you want to run as an N_Port.
# Set loop mode if you want to run as an NL_Port.
*/
int lpfc_topology  = 0;

/*
# link-speed:link speed selection for initializing the Fibre Channel connection.
#       0 = auto select (default)
#       1 = 1 Gigabaud
#       2 = 2 Gigabaud
*/
int  lpfc_link_speed  = 0;

/*
# ip-class:  FC class (2 or 3) to use for the IP protocol.
*/
int lpfc_ip_class  = 3;

/*
# fcp-class:  FC class (2 or 3) to use for the FCP protocol.
*/
int lpfc_fcp_class  = 3;

/*
# Use ADISC for FCP rediscovery instead of PLOGI
*/
int  lpfc_use_adisc  =0;

/*
# Extra FCP timeout for fabrics
*/
int  lpfc_fcpfabric_tmo  =0;

/*
# Number of 4k STREAMS buffers to post to IP ring
*/
int  lpfc_post_ip_buf  =128;

/*
#Use dqfull-throttle-up-time to specify when to increment the current Q depth.
# This variable is in seconds.
*/
int lpfc_dqfull_throttle_up_time =1;

/*
# Increment the current Q depth by dqfull-throttle-up-inc
*/
int lpfc_dqfull_throttle_up_inc =1;

/*
# Use ACK0, instead of ACK1 for class 2 acknowledgement
*/
int  lpfc_ack0support  =0;

/*
# Vendor specific flag for vendor specifc actions.
*/
int  lpfc_vendor  =0x1;

/*
# Linux does not scan past lun 0 is it's missing. Emulex driver can
# work around this limitation if this feature is on (1).
*/
int  lpfc_lun0_missing  =0;

/* 
# When a disk disapears, fiber cable being disconnected for example,
# this option will report it missing BUT removable. This allows
# Linux to re-discover the disk later on without scan, when the cable 
# is re-connected in our example. 
# Warning: when this option is set, statuses and timeout values on 
#          disk missing reported to the kernel may have an effect 
#          on other software packages like failover, multipath, etc...
*/
int  lpfc_use_removable =1;

/*
# specified the maximum number of luns per target. A value of 20 means
# luns from 0 to 19 are valid.
# Default of 0 means to use driver's maximum of 256.
 */
int  lpfc_max_lun =0;

/* 
# When the scsi layer passes the driver a command, the SCSI command structure
# has a field in it, sc_data_direction, to indicate if the SCSI command is a
# read or a write SCSI operation. Under some instances, this field is invalid
# and the SCSI opcode can be used to determine the type of SCSI operation. If
# wish to use the SCSI opcode, set this to 0.
# Note: For LINUX kernel revisions <= 2.4.4, this is ignored and the SCSI
# opcode is always used.
*/
int  lpfc_use_data_direction =1;

/* 
# Setup FCP persistent bindings,
# fcp-bind-WWPN binds a specific WorldWide PortName to a target id,
# fcp-bind-WWNN binds a specific WorldWide NodeName to a target id,
# fcp-bind-DID binds a specific DID to a target id.
# Only one binding method can be used. "lpfc_automap" needs to
# be changed to 0 and scan-down should NOT be set to 2 
# when one of these binding methods is used. 
# WWNN, WWPN and DID are hexadecimal values.
# WWNN must be 16 digit BCD with leading 0s.
# WWPN must be 16 digit BCD with leading 0s.
# DID must be 6 digit BCD with leading 0s.
# The SCSI ID to bind to consists of two parts, the lpfc interface
# to bind to, and the target number for that interface.
# Thus lpfc0t2 specifies target 2 on interface lpfc0.
#
# Here are some examples:
#                                   WWNN             SCSI ID
# char *lpfc_fcp_bind_WWNN[]={"22000020370b8275:lpfc0t1",
#                             "22000020370b8998:lpfc0t2"};
# 
#                                   WWPN             SCSI ID
# char *lpfc_fcp_bind_WWPN[]={"22000020370b8275:lpfc0t1",
#                             "22000020370b8998:lpfc0t2"};
# 
#                                   DID   SCSI ID
# char *lpfc_fcp_bind_DID[]={"0000dc:lpfc0t1",
#                            "0000e0:lpfc0t2"};
# 
*/
int  lpfc_bind_entries =0;
char *lpfc_fcp_bind_WWNN[MAX_FC_BINDINGS];
char *lpfc_fcp_bind_WWPN[MAX_FC_BINDINGS];
char *lpfc_fcp_bind_DID[MAX_FC_BINDINGS];

/*
# If automap is set, SCSI IDs for all FCP nodes without
# persistent bindings will be automatically generated.
# If new FCP devices are added to the network when the system is down,
# there is no guarantee that these SCSI IDs will remain the same
# when the system is booted again. 
# If one of the above fcp binding methods is specified, then automap
# devices will use the same mapping method to preserve 
# SCSI IDs between link down and link up.
# If no bindings are specified above, a value of 1 will force WWNN
# binding, 2 for WWPN binding, and 3 for DID binding.
# If automap is 0, only devices with persistent bindings will be
# recognized by the system.
*/
int  lpfc_automap  =2;

/* 
# Default values for I/O colaesing 
# cr_delay ms or cr_count outstanding commands
*/
int  lpfc_cr_delay  =0;
int  lpfc_cr_count  =0;



