.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetIndicatorState __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetIndicatorState \- Obtains the current state of the keyboard indicators
.SH SYNOPSIS
.HP
.B Status XkbGetIndicatorState
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "device_spec" "\^,"
.BI "unsigned int " "state_return" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I state_return
backfilled with a mask of the indicator state
.SH DESCRIPTION
.LP
Xkb allows applications to obtain information about indicators using two
different methods. The first method, which is similar to the core X
implementation, uses a mask to specify the indicators. The second method, which
is more suitable for applications concerned with interoperability, uses
indicator names. The correspondence between the indicator name and the bit
position in masks is as follows: one of the parameters returned from
.I XkbGetNamedIndicators
is an index that is the bit position to use in any function call that requires a
mask of indicator bits, as well as the indicator's index into the
XkbIndicatorRec array of indicator maps.

.I XkbGetIndicatorState
queries the
.I display
for the state of the indicators on the device specified by the
.I device_spec.
For each indicator that is "turned on" on the device, the associated bit is set
in
.I state_return.
If a compatible version of the Xkb extension is not available in the server,
.I XkbGetIndicatorState
returns a BadMatch error. Otherwise, it sends the request to the X server,
places the state of the indicators into
.I state_return,
and returns Success. Thus the value reported by
.I XkbGetIndicatorState
is identical to the value reported by the core protocol.
.SH DIAGNOSTICS
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has
correct type and range, but is otherwise invalid
.SH "SEE ALSO"
.BR XkbGetNamedIndicators (__libmansuffix__)

