module.exports = {
    fields: [
        {
            name: 'title',
            config: { boost: 10 }
        }, {
            name: 'body'
        }
    ],
    documents: [
        {
            "title": "لغة عربية",
            "body": "اللُّغَة العَرَبِيّة هي أكثر اللغات تحدثاً ونطقاً ضمن مجموعة اللغات السامية، وإحدى أكثر اللغات انتشاراً في العالم، يتحدثها أكثر من 467 مليون نسمة،[4](1) ويتوزع متحدثوها في الوطن العربي، بالإضافة إلى العديد من المناطق الأخرى المجاورة كالأحواز وتركيا وتشاد ومالي والسنغال وإرتيريا و إثيوبيا و جنوب السودان و إيران. اللغة العربية ذات أهمية قصوى لدى المسلمين، فهي لغة مقدسة (لغة القرآن)، ولا تتم الصلاة (وعبادات أخرى) في الإسلام إلا بإتقان بعض من كلماتها.[5][6] العربية هي أيضاً لغة شعائرية رئيسية لدى عدد من الكنائس المسيحية في الوطن العربي، كما كتبت بها كثير من أهم الأعمال الدينية والفكرية اليهودية في العصور الوسطى. وأثّر انتشار الإسلام، وتأسيسه دولاً، في ارتفاع مكانة اللغة العربية، وأصبحت لغة السياسة والعلم والأدب لقرون طويلة في الأراضي التي حكمها المسلمون، وأثرت العربية تأثيراً مباشراً أو غير مباشر على كثير من اللغات الأخرى في العالم الإسلامي، كالتركية والفارسية والأمازيغية والكردية والأردوية والماليزية والإندونيسية والألبانية وبعض اللغات الإفريقية الأخرى مثل الهاوسا والسواحيلية والتجرية والأمهرية و الصومالية، وبعض اللغات الأوروبية وخاصةً المتوسطية كالإسبانية والبرتغالية والمالطية والصقلية. كما أنها تُدرَّس بشكل رسمي أو غير رسمي في الدول الإسلامية والدول الإفريقية المحاذية للوطن العربي.",
            "id": 1
        }, {
            "title": "لغات تستخدم الأبجدية العربية",
            "body": "هناك عدد من الدول تستخدم الأبجدية العربية في كتابة لغاتها وتستعمل عادةً أبجدية مشتقة من العربية بإضافة حروف عربية غير مستخدمة من قبل العرب أنفسهم كي تقوم بالاشتمال على جميع مخارج ونطق الأحرف لهذه اللغات. استخدم المتحدثون باللغات غير المكتوبة سابقا الأبجدية العربية كأساسٍ كتابيٍ للغاتهم الأم. وأتى هذا من كون اللغة العربية لغتهم الثانية، أو لغة كتاب وحيهم، أو كون الأبجدية العربية الأبجدية الوحيدة التي اتصلوا بها. بالإضافة إلى ذلك، ولأن أغلب التعليم كان دينيا في وقتٍ من الأوقات، فقد كان المسلمون من غير العرب يكتبون بالأبجدية العربية أي لغةٍ يتحدثون بها. وأدى هذا إلى جعل الكتابة العربية الكتابة الأكثر استعمالا خلال العصور الوسطى. من أبرز اللغات التي تستخدم الأبجدية العربية في الزمن الحالي: اللغة الفارسية (بالفارسية: فارسي؛ أو زبان فارسي) المنتشرة في إيران وبعض أنحاء آسيا الوسطى؛ اللغة الكردية (بالكردية عربية الأبجدية: كوردي) المنتشرة في شمال العراق والمناطق المجاورة؛ اللغة الأردوية (بالأردوية: اردو) في باكستان والهند، ولغات عديدة أخرى.",
            "id": 2
        }, {
            "title": "عُـــــــــــــــمــــــــــــــــــــــان",
            "body": "عمان دولة عربية تقع في شبه الجزيرة العربية",
            "id": 3
        }
    ],
    tests: [
        {
            what: "find the word %w",
            search: "عربية",
            found: 3
        }, {
            what: "find the word %w",
            search: "استعمال",
            found: 1
        }, {
            what: "never find a word that does not exist, like %w",
            search: "بطيخ",
            found: 0
        },{
            what: "find a correctly stemmed word %w",
            search: "كتب",
            found: 2
        }, {
            what: "find a word regardless of the differences in the number of expansions it has between it in the search and in the document, like %w",
            search: "عـمـان",
            found: 1
        }
    ]
}