.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_file.mdoc -- description of zip_file_t
.\" Copyright (C) 2025 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_FILE" "5" "May 5, 2025" "NiH" "File Formats Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file\fR
\- file in archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_file_t *file\fR;
.SH "DESCRIPTION"
A
\fBzip_file\fR
represents a file inside an archive, opened for reading.
It is created with
zip_fopen(3),
zip_fopen_index(3),
zip_fopen_encrypted(3),
or
zip_fopen_index_encrypted(3).
.PP
Data is accessed with
zip_fread(3),
zip_file_is_seekable(3),
zip_ftell(3),
or
zip_fseek(3).
.PP
It is closed with
zip_fclose(3).
.PP
If the containing
\fIzip_t\fR
is closed, all further uses of the
\fIzip_file_t\fR
return an error.
It is a convenience wrapper around a
\fIzip_source_t\fR
as created by
zip_source_zip(3).
.SH "SEE ALSO"
zip_fclose(3),
zip_file_is_seekable(3),
zip_fopen(3),
zip_fopen_encrypted(3),
zip_fopen_index(3),
zip_fopen_index_encrypted(3,)
zip_fread(3),
zip_fseek(3),
zip_ftell(3),
zip_source_zip(3),
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>
