/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.test.classinfo.test;

import org.jboss.reflect.spi.TypeInfo;
import org.jboss.test.classinfo.support.CustomValueOf;


/**
 * Tests that public static XXX.valueOf(Object o) is called when calling ClassInfo.convertValue()
 *  
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public abstract class CustomValueValueOfTest extends AbstractClassInfoTest
{
   public CustomValueValueOfTest(String name)
   {
      super(name);
   }
   
   public void testCustomValueOf() throws Throwable
   {
      TypeInfo info = getTypeInfoFactory().getTypeInfo(CustomValueOf.class);
      Object value = info.convertValue("1234");
      assertNotNull(value);
      assertInstanceOf(value, CustomValueOf.class);
      assertEquals("1234", ((CustomValueOf)value).getString());
   }

}
