/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.bristol.star.cdf.CdfFormatException;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Bufs;
import uk.ac.bristol.star.cdf.record.CompressedParametersRecord;
import uk.ac.bristol.star.cdf.record.CompressedVariableValuesRecord;
import uk.ac.bristol.star.cdf.record.Compression;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordFactory;
import uk.ac.bristol.star.cdf.record.VariableDescriptorRecord;
import uk.ac.bristol.star.cdf.record.VariableIndexRecord;
import uk.ac.bristol.star.cdf.record.VariableValuesRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordMap {
    private final int nent_;
    private final int[] firsts_;
    private final int[] lasts_;
    private final Buf[] bufs_;
    private final long[] offsets_;
    private final int recSize_;
    private Block lastBlock_;

    private RecordMap(Entry[] entryArray, int n) {
        this.recSize_ = n;
        Arrays.sort(entryArray);
        this.nent_ = entryArray.length;
        this.firsts_ = new int[this.nent_];
        this.lasts_ = new int[this.nent_];
        this.bufs_ = new Buf[this.nent_];
        this.offsets_ = new long[this.nent_];
        for (int i = 0; i < this.nent_; ++i) {
            Entry entry = entryArray[i];
            this.firsts_[i] = entry.first_;
            this.lasts_[i] = entry.last_;
            this.bufs_[i] = entry.buf_;
            this.offsets_[i] = entry.offset_;
        }
        this.lastBlock_ = this.nent_ > 0 ? this.calculateBlock(0) : new Block(-1, -1, -1);
    }

    public int getEntryCount() {
        return this.nent_;
    }

    public int getEntryIndex(int n) {
        Block block = this.lastBlock_;
        if (!block.contains(n)) {
            this.lastBlock_ = block = this.calculateBlock(n);
        }
        assert (block.contains(n));
        return block.ient_;
    }

    public Buf getBuf(int n) {
        return this.bufs_[n];
    }

    public long getOffset(int n, int n2) {
        assert (n2 >= this.firsts_[n] && n2 <= this.lasts_[n]);
        return this.offsets_[n] + (long)((n2 - this.firsts_[n]) * this.recSize_);
    }

    public long getFinalOffsetInEntry(int n) {
        return this.offsets_[n] + (long)((this.lasts_[n] - this.firsts_[n] + 1) * this.recSize_);
    }

    private Block calculateBlock(int n) {
        int n2 = RecordMap.binarySearch(this.firsts_, n);
        if (n2 >= 0) {
            return new Block(n2, this.firsts_[n2], this.lasts_[n2]);
        }
        if (n2 == -1) {
            return new Block(-n2 - 2, 0, this.firsts_[0] - 1);
        }
        n2 = -2 - n2;
        int n3 = RecordMap.binarySearch(this.lasts_, n);
        if (n3 >= 0) {
            return new Block(n3, this.firsts_[n3], this.lasts_[n3]);
        }
        if (n3 == -this.nent_ - 1) {
            return new Block(n3, this.lasts_[this.nent_ - 1], Integer.MAX_VALUE);
        }
        if (n2 == (n3 = -1 - n3)) {
            return new Block(n2, this.firsts_[n2], this.lasts_[n2]);
        }
        return new Block(-n2 - 2, this.lasts_[n2] + 1, this.firsts_[n3] - 1);
    }

    public static RecordMap createRecordMap(VariableDescriptorRecord variableDescriptorRecord, RecordFactory recordFactory, int n) throws IOException {
        Compression compression = RecordMap.getCompression(variableDescriptorRecord, recordFactory);
        Buf buf = variableDescriptorRecord.getBuf();
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        long l = variableDescriptorRecord.vxrHead;
        while (l != 0L) {
            VariableIndexRecord variableIndexRecord = recordFactory.createRecord(buf, l, VariableIndexRecord.class);
            RecordMap.readEntries(variableIndexRecord, buf, recordFactory, n, compression, arrayList);
            l = variableIndexRecord.vxrNext;
        }
        Entry[] entryArray = arrayList.toArray(new Entry[0]);
        return new RecordMap(entryArray, n);
    }

    private static Compression getCompression(VariableDescriptorRecord variableDescriptorRecord, RecordFactory recordFactory) throws IOException {
        boolean bl = Record.hasBit(variableDescriptorRecord.flags, 2);
        if (bl && variableDescriptorRecord.cprOrSprOffset != -1L) {
            CompressedParametersRecord compressedParametersRecord = recordFactory.createRecord(variableDescriptorRecord.getBuf(), variableDescriptorRecord.cprOrSprOffset, CompressedParametersRecord.class);
            return Compression.getCompression(compressedParametersRecord.cType);
        }
        return Compression.NONE;
    }

    private static void readEntries(VariableIndexRecord variableIndexRecord, Buf buf, RecordFactory recordFactory, int n, Compression compression, List<Entry> list) throws IOException {
        int n2 = variableIndexRecord.nUsedEntries;
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n3 = variableIndexRecord.first[i];
            int n4 = variableIndexRecord.last[i];
            Record record = recordFactory.createRecord(buf, variableIndexRecord.offset[i]);
            if (record instanceof VariableValuesRecord) {
                object = (VariableValuesRecord)record;
                list.add(new Entry(n3, n4, buf, ((VariableValuesRecord)object).getRecordsOffset()));
                continue;
            }
            if (record instanceof CompressedVariableValuesRecord) {
                object = (CompressedVariableValuesRecord)record;
                int n5 = (n4 - n3 + 1) * n;
                Buf buf2 = Bufs.uncompress(compression, buf, ((CompressedVariableValuesRecord)object).getDataOffset(), n5);
                list.add(new Entry(n3, n4, buf2, 0L));
                continue;
            }
            if (record instanceof VariableIndexRecord) {
                object = (VariableIndexRecord)record;
                RecordMap.readEntries((VariableIndexRecord)object, buf, recordFactory, n, compression, list);
                long l = ((VariableIndexRecord)object).vxrNext;
                while (l != 0L) {
                    VariableIndexRecord variableIndexRecord2 = recordFactory.createRecord(buf, l, VariableIndexRecord.class);
                    RecordMap.readEntries(variableIndexRecord2, buf, recordFactory, n, compression, list);
                    l = variableIndexRecord2.vxrNext;
                }
                continue;
            }
            object = new StringBuffer().append("Unexpected record type (").append(record.getRecordType()).append(") pointed to by VXR offset").toString();
            throw new CdfFormatException((String)object);
        }
    }

    private static int binarySearch(int[] nArray, int n) {
        assert (RecordMap.isSorted(nArray));
        return Arrays.binarySearch(nArray, n);
    }

    private static boolean isSorted(int[] nArray) {
        int n = nArray.length;
        for (int i = 1; i < n; ++i) {
            if (nArray[i] >= nArray[i - 1]) continue;
            return false;
        }
        return true;
    }

    private static class Block {
        final int ient_;
        final int low_;
        final int high_;

        Block(int n, int n2, int n3) {
            this.ient_ = n;
            this.low_ = n2;
            this.high_ = n3;
        }

        boolean contains(int n) {
            return n >= this.low_ && n <= this.high_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Comparable<Entry> {
        private final int first_;
        private final int last_;
        private final Buf buf_;
        private final long offset_;

        Entry(int n, int n2, Buf buf, long l) {
            this.first_ = n;
            this.last_ = n2;
            this.buf_ = buf;
            this.offset_ = l;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.first_ - entry.first_;
        }
    }
}

