/*
 * (C) Copyright 2002, Schlund+Partner AG
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * @file XMLException.hpp
 * @version @$Id: XMLException.hpp,v 1.6 2002/12/19 15:16:45 spabsurd Exp $
 * @author Schlund + Partner AG
 * @brief *ps*
 *
 * (C) Copyright by Schlund+Partner AG
 *
 * Synopsis: @#include <sp-gxmlcpp/XMLException.hpp>
 *
 */

#ifndef SP_GXML_XMLEXCEPTION_HPP
#define SP_GXML_XMLEXCEPTION_HPP

// STDC++
#include <string>

namespace SP
{
namespace GXML
{

class XMLException
{
public:
	XMLException( int exception );
	int getException();
	std::string getMessage();

	enum Exceptions {
		XMLTREE_PARSE=1,		// Error parsing XML tree
		XMLTREE_CREATE_CONTEXT,	// Could not create XPath context
		XMLTREE_CREATE_NODE,		// Could not create node
		XMLTREE_ADD_NODE,		// Could not add node
		XMLTREE_TREE_INVALID,		// Invalid XML tree
		XMLTREE_NO_NODE_FROM_PATH,	// Path matches no node
		XMLTREE_NO_STRING_FROM_PATH,	// Path returns no string
		XMLTREE_NO_BOOL_FROM_PATH,	// Path returns no boolean
		XMLTREE_NO_FLOAT_FROM_PATH,	// Path returns no float
		XMLNODE_NO_NODE,		// Node pointer is NULL
		XMLNODE_LAST_NODE,		// Node has no following sibling
		XMLNODE_FIRST_NODE,		// Node has no preceding sibling
		XMLNODE_NO_PARENT,		// Node has no parent node
		XMLNODE_NO_CHILD,		// Node has no child node
		XMLNODE_NO_CONTENT,		// Node contains no text
		XMLNODE_NO_ATTRIBUTE,		// Node has no attributes
		XMLNODE_BUFFER_CREATE,	// Could not create XML buffer
		XMLNODE_NODE_DUMP,		// Could not dump the node
		XMLNODESET_EVAL,		// Could not evaluate XPath
		XMLNODESET_NO_SET,		// XPath delivers no node set
		XMLNODESET_NO_MATCH		// XPath doesn't exist
	};

private:
	int exception_;
};

}}
#endif
