# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import PolicyClientConfiguration
from .operations import (
    DataPolicyManifestsOperations,
    PolicyAssignmentsOperations,
    PolicyDefinitionVersionsOperations,
    PolicyDefinitionsOperations,
    PolicyExemptionsOperations,
    PolicySetDefinitionVersionsOperations,
    PolicySetDefinitionsOperations,
    VariableValuesOperations,
    VariablesOperations,
)

if TYPE_CHECKING:
    from azure.core import AzureClouds
    from azure.core.credentials_async import AsyncTokenCredential


class PolicyClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """To manage and control access to your resources, you can define customized policies and assign
    them at a scope.

    :ivar data_policy_manifests: DataPolicyManifestsOperations operations
    :vartype data_policy_manifests:
     azure.mgmt.resource.policy.aio.operations.DataPolicyManifestsOperations
    :ivar policy_definitions: PolicyDefinitionsOperations operations
    :vartype policy_definitions:
     azure.mgmt.resource.policy.aio.operations.PolicyDefinitionsOperations
    :ivar policy_definition_versions: PolicyDefinitionVersionsOperations operations
    :vartype policy_definition_versions:
     azure.mgmt.resource.policy.aio.operations.PolicyDefinitionVersionsOperations
    :ivar policy_set_definitions: PolicySetDefinitionsOperations operations
    :vartype policy_set_definitions:
     azure.mgmt.resource.policy.aio.operations.PolicySetDefinitionsOperations
    :ivar policy_set_definition_versions: PolicySetDefinitionVersionsOperations operations
    :vartype policy_set_definition_versions:
     azure.mgmt.resource.policy.aio.operations.PolicySetDefinitionVersionsOperations
    :ivar policy_assignments: PolicyAssignmentsOperations operations
    :vartype policy_assignments:
     azure.mgmt.resource.policy.aio.operations.PolicyAssignmentsOperations
    :ivar policy_exemptions: PolicyExemptionsOperations operations
    :vartype policy_exemptions:
     azure.mgmt.resource.policy.aio.operations.PolicyExemptionsOperations
    :ivar variables: VariablesOperations operations
    :vartype variables: azure.mgmt.resource.policy.aio.operations.VariablesOperations
    :ivar variable_values: VariableValuesOperations operations
    :vartype variable_values: azure.mgmt.resource.policy.aio.operations.VariableValuesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword cloud_setting: The cloud setting for which to get the ARM endpoint. Default value is
     None.
    :paramtype cloud_setting: ~azure.core.AzureClouds
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        *,
        cloud_setting: Optional["AzureClouds"] = None,
        **kwargs: Any
    ) -> None:
        _cloud = cloud_setting or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = PolicyClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            cloud_setting=cloud_setting,
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.data_policy_manifests = DataPolicyManifestsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_definitions = PolicyDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_definition_versions = PolicyDefinitionVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_set_definitions = PolicySetDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_set_definition_versions = PolicySetDefinitionVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_assignments = PolicyAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.policy_exemptions = PolicyExemptionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.variables = VariablesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.variable_values = VariableValuesOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
