# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClientDiscoveryDisplay(Model):
    """Localized display information of an operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Name of the resource provider.
    :vartype provider: str
    :ivar resource: Type of the resource.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'Provider', 'type': 'str'},
        'resource': {'key': 'Resource', 'type': 'str'},
        'operation': {'key': 'Operation', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(self):
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None
