/*
 * Copyright 2011 castLabs, Berlin
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoBufferWrapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
class ObjectDescriptor extends ObjectDescriptorBase : bit(8) tag=ObjectDescrTag {
bit(10) ObjectDescriptorID;
bit(1) URL_Flag;
const bit(5) reserved=0b1111.1;
if (URL_Flag) {
bit(8) URLlength;
bit(8) URLstring[URLlength];
} else {
ES_Descriptor esDescr[1 .. 255];
OCI_Descriptor ociDescr[0 .. 255];
IPMP_DescriptorPointer ipmpDescrPtr[0 .. 255];
IPMP_Descriptor ipmpDescr [0 .. 255];
}
ExtensionDescriptor extDescr[0 .. 255];
}
*/
@Descriptor(tags = {0x01, 0x11})
public class ObjectDescriptor extends ObjectDescriptorBase {
    private int objectDescriptorId;
    int objectDescriptorUrlFlag;
    int objectDescriptorUrlLength;
    String objectDescriptorUrlString;


    private int streamCount;
    private int extensionFlag;
    private List<ESDescriptor> esDescriptors = new ArrayList<ESDescriptor>();

    private int descriptorLength;
    private List<ExtensionDescriptor> extensionDescriptors = new ArrayList<ExtensionDescriptor>();

    public static ObjectDescriptor createFrom(IsoBufferWrapper in) throws IOException {
/*
    tmp = in.readUInt16();
    esDescriptor.objectDescriptorId = tmp & 0x3f;
    esDescriptor.objectDescriptorUrlFlag = (tmp >> 5) & 0x1;
    if (esDescriptor.objectDescriptorUrlFlag == 1) {
      esDescriptor.objectDescriptorUrlLength = in.readUInt8();
      esDescriptor.objectDescriptorUrlString = new String(in.read(esDescriptor.objectDescriptorUrlLength));
    }
     */

        ObjectDescriptor objectDescriptor = new ObjectDescriptor();

        int data = in.readUInt16();

        objectDescriptor.objectDescriptorId = data & 0xFFC0;
        objectDescriptor.streamCount = data & 0x3E;
        objectDescriptor.extensionFlag = data & 0x1;

//    for (int i = 0; i < objectDescriptor.streamCount; i++) {
//      objectDescriptor.esDescriptors.add(ESDescriptor.createFrom(in));
//    }
//
//    if (objectDescriptor.extensionFlag == 1) {
//      objectDescriptor.descriptorLength = in.readUInt8();
//      for (int i = 0; i < objectDescriptor.descriptorLength;) {
//        ExtensionDescriptor extensionDescriptor = ExtensionDescriptor.createFrom(in);
//        objectDescriptor.extensionDescriptors.add(extensionDescriptor);
//        i = i + extensionDescriptor.descriptorDataLength + 1;
//      }
//    }

        return objectDescriptor;
    }

    @Override
    public String toString() {
        return "ObjectDescriptor{" +
                "objectDescriptorId=" + objectDescriptorId +
                ", streamCount=" + streamCount +
                ", extensionFlag=" + extensionFlag +
                ", esDescriptors=" + esDescriptors +
                ", descriptorLength=" + descriptorLength +
                ", extensionDescriptors=" + extensionDescriptors +
                '}';
    }
}
