#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
TAR=../${SOURCE}_$2.orig.tar.gz
DIR=$SOURCE-$2
TAG=$(echo v$2 | sed -e 's,\.,_,g')
SVN=http://anonsvn.jboss.org/repos/hibernate/validator/tags

svn export $SVN/$TAG $DIR
# clean up the upstream tarball
GZIP=--best tar -c -z -f $TAR -X debian/orig-tar.exclude $DIR
rm -rf $3 $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

