/*
 * @(#)AllTestIssueRecordCollatorUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1.itf.impl;

import net.sourceforge.groboutils.pmti.v1.itf.*;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.*;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.AssertionFailedError;


/**
 * Tests the AllTestIssueRecordCollator class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/29 13:05:50 $
 * @since     July 14, 2002
 */
public class AllTestIssueRecordCollatorUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AllTestIssueRecordCollatorUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public AllTestIssueRecordCollatorUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testCollate1()
    {
        AllTestIssueRecordCollator atirc = new AllTestIssueRecordCollator();
        ITestIssueRecord records[] = {
                createRecord1(),
                createRecord1(),
            };
        ITestIssueRecordSet[] sets = atirc.collate( records );
        ITestIssueRecord retRecords[] = sets[0].getTestIssueRecords();
        assertEquals(
            "Must only return one set.",
            sets.length,
            1 );
        assertEquals(
            "Must return 2 records.",
            retRecords.length,
            2 );
        assertEquals(
            "Did not return the correct record for index 0.",
            retRecords[0],
            records[0] );
        assertEquals(
            "Did not return the correct record for index 1.",
            retRecords[1],
            records[1] );
    }

    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected ITestIssueRecord createRecord1()
    {
        IIssueRecord ir = new DefaultIssueRecord( "", null );
        DefaultTestRecord tr = new DefaultTestRecord();
        ITestIssueRecord tir = new DefaultTestIssueRecord( ir, tr, "text 1" );
        return tir;
    }
    
    
    protected ITestIssueRecord createRecord2()
    {
        IIssueRecord ir = new DefaultIssueRecord( "", null );
        DefaultTestRecord tr = new DefaultTestRecord();
        tr.setTestSuite( "suite" );
        
        ITestIssueRecord tir = new DefaultTestIssueRecord( ir, tr, "text 2" );
        return tir;
    }
    
    
    protected ITestIssueRecord createRecord3()
    {
        IIssueRecord ir = new DefaultIssueRecord( "", null );
        DefaultTestRecord tr = new DefaultTestRecord();
        tr.setTestSuite( "suite" );
        tr.setTestName( "name" );
        
        ITestIssueRecord tir = new DefaultTestIssueRecord( ir, tr, "text 3" );
        return tir;
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = ITestIssueRecordCollatorUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new AllTestIssueRecordCollator();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

