/*
 *  @(#)PathIteratorImpl.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1.engine;


import java.util.Enumeration;
import java.util.NoSuchElementException;

import net.sourceforge.groboutils.mbtf.v1.IPathIterator;
import net.sourceforge.groboutils.mbtf.v1.ITransition;

import org.apache.log4j.Logger;


/**
 * An iterator to allow the tracing of the transitions through a state machine.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:26 $
 * @since      June 12, 2002
 */
public class PathIteratorImpl implements IPathIterator
{
    private static final Logger LOG = Logger.getLogger(
        PathIteratorImpl.class );
    
    private int index = 0;
    private ITransition[] trans;
    
    
    public PathIteratorImpl( ITransition[] trans )
    {
        if (trans == null)
        {
            LOG.debug("no transitions");
            this.trans = new ITransition[0];
        }
        else
        {
            int len = trans.length;
            ITransition[] t = new ITransition[ len ];
            for (int i = 0; i < len; ++i)
            {
                if (trans[i] == null)
                {
                    throw new IllegalArgumentException(
                        "no nulls allowed in ITransition array");
                }
                // else
                LOG.debug("transition "+i+"="+trans[i]);
                t[i] = trans[i];
            }
            this.trans = t;
        }
    }
    
    
    public boolean hasMoreElements()
    {
        return hasNext();
    }
    
    
    public Object nextElement()
    {
        return nextTransition();
    }
    
    
    /**
     * Performs same functionality as <tt>hasMoreElements()</tt>.
     */
    public boolean hasNext()
    {
        return (this.index < trans.length);
    }
    
    
    /**
     * The same as <tt>nextElement()()</tt>, but without the required cast.
     *
     * @exception NoSuchElementException if the iterator is at the end.
     */
    public synchronized ITransition nextTransition()
    {
        if (!hasMoreElements())
        {
            throw new NoSuchElementException("end of list");
        }
        ITransition t = this.trans[ this.index ];
        ++this.index;
        LOG.debug("nextTranstion() = "+t);
        return t;
    }
}

