/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.xpath.XPathException;

public class UnionPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;
    private int nodeType = 0;

    public UnionPattern(Pattern pattern, Pattern pattern2) {
        this.p1 = pattern;
        this.p2 = pattern2;
        if (pattern.getNodeKind() == pattern2.getNodeKind()) {
            this.nodeType = pattern.getNodeKind();
        }
    }

    public Pattern simplify() throws XPathException {
        return new UnionPattern(this.p1.simplify(), this.p2.simplify());
    }

    public Pattern typeCheck(StaticContext staticContext) throws XPathException {
        return new UnionPattern(this.p1.typeCheck(staticContext), this.p2.typeCheck(staticContext));
    }

    public void setOriginalText(String string) {
        this.originalText = string;
        this.p1.setOriginalText(string);
        this.p2.setOriginalText(string);
    }

    public boolean matches(NodeInfo nodeInfo, Controller controller) throws XPathException {
        return this.p1.matches(nodeInfo, controller) || this.p2.matches(nodeInfo, controller);
    }

    public int getNodeKind() {
        return this.nodeType;
    }

    public NodeTest getNodeTest() {
        if (this.nodeType == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(this.nodeType);
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }
}

