#############################################################
#
# minicom
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
MINICOM_SOURCE:=minicom.tar.gz
MINICOM_SITE:=ftp://ftp.gnu.org/gnu/minicom
MINICOM_CAT:=zcat
endif

MINICOM_DIR:=$(BUILD_DIR)/minicom
MINICOM_BINARY:=src/minicom
MINICOM_TARGET_BINARY:=usr/bin/minicom

ifneq ($(USE_CVS),true)
minicom-fetch:
	 $(WGET) -P $(DL_DIR) $(MINICOM_SITE)/$(MINICOM_SOURCE)

minicom-source: $(DL_DIR)/$(MINICOM_SOURCE)
else
minicom-source:
endif

MINICOM_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d minicom $(CVS_TAG) $(CVS_PREFIX)minicom

minicom-checkout:
	@$(MINICOM_CVSCO)

$(MINICOM_DIR)/.unpacked: $(DL_DIR)/$(MINICOM_SOURCE)
ifneq ($(USE_CVS),true)
	$(MINICOM_CAT) $(DL_DIR)/$(MINICOM_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(MINICOM_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(MINICOM_DIR)/aux/
	touch $(MINICOM_DIR)/aclocal.m4
	touch $(MINICOM_DIR)/configure.in
	touch $(MINICOM_DIR)/Makefile.in
	touch $(MINICOM_DIR)/configure
	touch $(MINICOM_DIR)/.unpacked

$(MINICOM_DIR)/.configured: $(MINICOM_DIR)/.unpacked
	(cd $(MINICOM_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(MINICOM_DIR)/.configured

$(MINICOM_DIR)/$(MINICOM_BINARY): $(MINICOM_DIR)/.configured
	$(MAKE) -C $(MINICOM_DIR)

$(TARGET_DIR)/$(MINICOM_TARGET_BINARY): $(MINICOM_DIR)/$(MINICOM_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(MINICOM_DIR) install
	install -d $(DOC_DIR)/doc/minicom
	install -m0644 $(MINICOM_DIR)/COPYING $(DOC_DIR)/doc/minicom/COPYING

minicom: uclibc $(TARGET_DIR)/$(MINICOM_TARGET_BINARY)

minicom-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(MINICOM_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/minicom
	-$(MAKE) -C $(MINICOM_DIR) clean

minicom-dirclean:
	rm -rf $(MINICOM_DIR)
endif

